/** @file

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

This software is protected by the inclusion of the above copyright
notice. This software may not be provided or otherwise made available
to, or used by, any other person. No title to or ownership of the
software is  hereby  transferred.
The information contained in this document is considered the
CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
not be disclosed or discussed with anyone who is not employed by
Siemens AG, unless the individual / company
(i) has an express need to know such information, and
(ii) disclosure of information is subject to the terms of a duly
executed Confidentiality and Non-Disclosure Agreement between
Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR         Murat Korkmaz 

.FILENAME       pluginerror.h

.TODO           

.SHORT_DESCR    Error defines for the PlugIn interface. 

.SW_COMPONENT   PC-SIMU PlugIn

.SW_TYPE        

.CHANGE_CONTROL

Version   Date       Changed by          Reason of change<br>
--------------------------------------------------------------------------------<br>
01.00.00  2004-01-14 Murat Korkmaz       Initial Version.<br> 
------------------------------------------------------------------------------*/
#ifndef _PLUGIN_ERROR_H_
#define _PLUGIN_ERROR_H_
/* -----------------------------------------------------------------------------
INCLUDES
------------------------------------------------------------------------------*/
#include "pluginmessage.h"
/* -----------------------------------------------------------------------------
DEFINES
------------------------------------------------------------------------------*/
/** @defgroup plug_in_error Plug-in Error Defines
 *  Error defines for the plug-in manager.
 *  @ingroup plug_in_interface_base
 *  @{
 */

/*!
 * The operation completed successfully.
 */
#define PLUGIN_ERROR_SUCCESS                          0x0000
/*!
 * The plug-in interface is NULL pointer.
 */
#define PLUGIN_ERROR_INTERFACE_IS_NULLP               0x0001
/*!
 * The plug-in interface was not found in PlugIn.
 */
#define PLUGIN_ERROR_INIT_PLUGIN_FNC_NOT_FOUND        0x0002
/*!
 * The plug-in InitPlugIn function could not load 
 * from the PlugIn.
 */
#define PLUGIN_ERROR_INIT_FUNCTION_NOT_LOAD           0x0003
/*!
 * The plug-in HINSTANCE is NULL pointer.
 */
#define PLUGIN_ERROR_HINSTANCE_IS_NULLP               0x0004
/*!
 * The plug-in could not freed.
 */
#define PLUGIN_ERROR_FREE_PLUGIN                      0x0005
/*!
 * The requested PlugIn could not load.
 */
#define PLUGIN_ERROR_PLUGIN_COULD_NOT_LOAD            0x0006
/*!
 * The plug-in has differnt API version as the
 * application.
 */
#define PLUGIN_ERROR_WRONG_PLUGIN_API_VERSION         0x0007
/*!
 * The application has differnt API version as the
 * PlugIn.
 */
#define PLUGIN_ERROR_WRONG_APPL_API_VERSION           0x0008
/*!
 * The applications interface is a NULL pointer.
 */
#define PLUGIN_ERROR_APPL_INTERFACE_IS_NULLP          0x0009
/*!
 * The plug-in interface is not a NULL pointer.
 */
#define PLUGIN_ERROR_PLUGIN_INTERFACE_IS_NOT_NULLP    0x0010

/*!
 * The plug-in is already loaded.
 */
#define PLUGIN_ERROR_PLUGIN_ALREADY_LOADED             0x0011

/**                                                                       
 *  Function to get  appropriate error string.  
 *    
 *  @param   lReturn: Error ID  
 *  
 *  @return  CString: Error String
 */   
CString GetPlugInErrorString(long lReturn);

#endif // _PLUGIN_ERROR_H_

/** @} */ // end of plug_in_error
/* -----------------------------------------------------------------------------
END OF FILE pluginerror.h
------------------------------------------------------------------------------*/
