/* -----------------------------------------------------------------------------

Copyright (C) Siemens AG 1994-2004 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

.AUTHOR        Walter Stroell

.FILENAME      MOPI_PlugInInterface.cpp

.VERSION       00.00.00

.DATE          2004-03-25

.SHORT_DESCR:  MOPI plugin for PC MMI

.SW_COMPONENT: MOPI

.SW_TYPE       OPERATING SYSTEM

.EXIT_CODES

.CHANGE_CONTROL
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
00.00.00 2004-03-25  Walter Stroell (VIE)
         initial version
------------------------------------------------------------------------------*/

#include "stdafx.h"
#include "mopi.h"
#include "mopi_pctrl.h"
#include "mopi_timer.h"
#include "MOPI_PlugInInterface.h"
#include "MOPI_PlugInDlg.h"

// Used to initialize the Plug-In and various resources
AFX_API_EXPORT DWORD InitPlugIn(IPlugInInterfaceBase *&ptrPlugInInterface, IApplicationInterfaceBase *ptrAppInterface)
{
    if (ptrAppInterface == NULL)
        return PLUGIN_ERROR_APPL_INTERFACE_IS_NULLP;

    if (ptrPlugInInterface != NULL)
        return PLUGIN_ERROR_PLUGIN_INTERFACE_IS_NOT_NULLP;

    if (APPLICATION_BASE_API_VERSION == ptrAppInterface->GetApplicationAPIVersion())
    {
        AFX_MANAGE_STATE(AfxGetStaticModuleState());
        ptrPlugInInterface = new CMOPI_PlugInInterface(ptrAppInterface);
        ptrPlugInInterface->AddRef(); 
        return PLUGIN_ERROR_SUCCESS;
    }
    else
    {
        return PLUGIN_ERROR_WRONG_APPL_API_VERSION;
    }
}

CMOPI_PlugInInterface::CMOPI_PlugInInterface(IApplicationInterfaceBase* ptrAppInterface)
{
    m_cStrPlugInName.LoadString(IDS_PLUGIN_NAME);
    m_cStrPlugInInfo.LoadString(IDS_PLUGIN_INFO);
    m_uiRefCount = 0;
    m_ptrAppInterface = ptrAppInterface;
    m_uiCommand1 = m_ptrAppInterface->GetCommandIDs(1);
//    m_uiCommand2 = m_ptrAppInterface->GetCommandIDs(2);
    ptrAppInterface->GetMOPIApplicationInterface(m_ptrAppInterfaceMOPI);
}

DWORD CMOPI_PlugInInterface::GetPlugInAPIVersion()
{
    return APPLICATION_BASE_API_VERSION;
}

void CMOPI_PlugInInterface::GetPlugInNameInfo(CString *pcStrPlugInName, 
                                              CString *pcStrPlugInInfo)
{
    *pcStrPlugInName = m_cStrPlugInName;
    *pcStrPlugInInfo = m_cStrPlugInInfo;
}

UINT CMOPI_PlugInInterface::AddRef()
{ 
    m_uiRefCount++;	
    return m_uiRefCount;
}

UINT CMOPI_PlugInInterface::Release()
{ 
    m_uiRefCount--;
    if (0==m_uiRefCount)
    {
        delete this;
        return 0;
    }
    else
        return m_uiRefCount;
}


UINT CMOPI_PlugInInterface::PlugInMessagePort(const CString cStrPlugInName, UINT uiMsg, LPARAM lParam, PVOID pParam)
{
    if (!m_cStrPlugInName.Compare(cStrPlugInName) || !cStrPlugInName.Compare("*"))
    {
        switch (uiMsg)
        {
            case PM_CREATE_PLUGIN_MENU:
            {
                HMENU menu = (HMENU)lParam;

                AppendMenu(menu, MF_SEPARATOR, 0, "-");
                AppendMenu(menu, MF_STRING, m_uiCommand1, "MOPI System Info");
//                AppendMenu(menu, MF_STRING, m_uiCommand2, "MOPI perm Sys Heap Info");
            }
            break;

            case PM_CREATE_PLUGIN_TOOLBAR:
            {
                AFX_MANAGE_STATE(AfxGetStaticModuleState());

                T_PlugIn_TB_Info* pTBInfo = (T_PlugIn_TB_Info*)lParam;

                if (pTBInfo != NULL)
                {
                    //pTBInfo->iNumberBtn  = 2;
                    pTBInfo->iNumberBtn  = 1;

                    if (m_cToolBarBitmap.LoadBitmap(IDB_PLUGIN_TOOLBAR))
                        pTBInfo->pToolbarBmp = (long*)&m_cToolBarBitmap;

                    m_TBbuttons[0].iBitmap   = 0;
                    m_TBbuttons[0].idCommand = m_uiCommand1;
                    m_TBbuttons[0].fsState   = TBSTATE_ENABLED;
                    m_TBbuttons[0].fsStyle   = TBSTYLE_BUTTON;
                    m_TBbuttons[0].dwData    = 0;
                    m_TBbuttons[0].iString   = 0;

                    //m_TBbuttons[1].iBitmap   = 1;
                    //m_TBbuttons[1].idCommand = m_uiCommand2;
                    //m_TBbuttons[1].fsState   = TBSTATE_ENABLED;
                    //m_TBbuttons[1].fsStyle   = TBSTYLE_BUTTON;
                    //m_TBbuttons[1].dwData    = 0;
                    //m_TBbuttons[1].iString   = 1;

                    pTBInfo->pToolbarBtn = (long*)m_TBbuttons;
                    return PM_CREATE_PLUGIN_TOOLBAR;
                }
            }
            break;

            case PM_PLUGIN_CONFIG:
            {
            }
            break;

            default:
            {
                if (uiMsg == m_uiCommand1)
                {
                    ASSERT(m_ptrAppInterfaceMOPI != NULL);
                    if (m_ptrAppInterfaceMOPI != NULL)
                    {
                        AFX_MANAGE_STATE(AfxGetStaticModuleState());
                        CMOPI_PlugInDlg *dlg = new CMOPI_PlugInDlg( m_ptrAppInterfaceMOPI );

                        //dlg.DoModal();

                        dlg->Create( IDD_DIALOG_INFO );
                        dlg->ShowWindow( SW_SHOW );
                    }

                }
                //else if (uiMsg == m_uiCommand2)
                //{
                //    ASSERT(m_ptrAppInterfaceMOPI != NULL);
                //    if (m_ptrAppInterfaceMOPI != NULL)
                //    {
                //        AFX_MANAGE_STATE(AfxGetStaticModuleState());
                //        CMOPI_PlugInDlg dlg(m_ptrAppInterfaceMOPI, MOPI_perm);
                //        dlg.DoModal();
                //    }
                //}
            }
            break;
        }
    }
    return PM_MESSAGE_OK;
}


