/*



                               Siemens AG
                         Mobile Radio Terminals
                            Munich,  Germany

                          COMPANY CONFIDENTIAL
                          All Rights Reserved

.AUTHOR         A. Nagy (Bardenheuer Software)

.SHORT_DESCR    Wrapper Interface of the WindowsFileSystem used for MFC code separation 

.SW_COMPONENT   FFS - Flash file system

.SW_TYPE        Interface

.VERSION        01.00.01

.DATE           2004-01-12

.GSM_VARIANT

.GSM_SPECS

.EXIT_CODES

.STATUS         FIRST_VERSION


.CHANGE_CONTROL

 Version    Date    Changed by         Reason for Change

 1.0.0    2002.12.18 A. Nagy (Bardenheuer SW)   initial version
 1.0.1    2004-01-12 Alexander Nagy (Bardenheuer SW)
          changed return parameter bool -> BOOL 

*/

////////////////////////////////////////////////////////////////////////////////
// includes
////////////////////////////////////////////////////////////////////////////////
#include <global.h>
#include "smsafxh.h"
#include "simuapph.h"
#include "mmidisph.h"

#include "wfs_mfc_wrapper.h"


////////////////////////////////////////////////////////////////////////////////
// defines
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// local variables
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// extern functions
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// global prototypes
// Wrapper Interface of the WindowsFileSystem used for MFC code separation 
////////////////////////////////////////////////////////////////////////////////


BOOL  WFS_ReadDrivePathFromRegistry (char driveLetter, char *path, short len)
{
    CMMIDispWindow* dispWin = GET_APP()->GetMMIDispWindow();
    return dispWin->ReadDrivePathFromRegistry (driveLetter, path, len);
}
BOOL  WFS_ReadDriveSizeFromRegistry (char driveLetter, unsigned long *pSize)
{
    CMMIDispWindow* dispWin = GET_APP()->GetMMIDispWindow();
    return dispWin->ReadDriveSizeFromRegistry (driveLetter, pSize);
}

BOOL  WFS_WriteDrivePathToRegistry (char driveLetter)
{
    CMMIDispWindow* dispWin = GET_APP()->GetMMIDispWindow();
    return dispWin->WriteDrivePathToRegistry (driveLetter);
}

BOOL  WFS_WriteDriveSizeToRegistry (char driveLetter, unsigned long size )
{
    CMMIDispWindow* dispWin = GET_APP()->GetMMIDispWindow();
    return dispWin->WriteDriveSizeToRegistry (driveLetter, size);
}

