/*
			 Siemens AG
		 Mobile Radio Terminals
		  Munich, Germany

.AUTHOR         B. Adameit

.SHORT_DESCR    Refresh
                                           
.SW_COMPONENT   MMI-Simulation

.SW_TYPE        Support-File

.STATUS         OFFICAL

.CHANGE_CONTROL
Version |  Date  | Changed by | Reason for Change
  1.0    11.08.98  B.Adameit    created file  - taken over from atalmain
  1.1    19.10.98  B.Adameit    added call of simulate_sim_refresh to TKRefresh
  1.2    15.12.98  B.Adameit    added PhonebookRefresh 
  1.3    26.08.02  M.Schuette   replaced macro in ATCRefresh()
  1.4    13.07.04  R.Vretska    add dummy parameter to simulate_sim_refresh
*/
#include <global.h>
                                                             
#if MOBSIM > 0

#include "gbs.h"
#include "procid.h"
#include "ck_data.h"
#include "ck_rsm.h"
#include "ck_sapi.h"
#include "app_msg.h"
#include "pbfrefr.h"
#include "atalmsgh.h"
#include "simsimhh.h"

void
TKRefresh(void)
{
    simulate_sim_refresh(0); /* load new image file if one is defined in simsim.ini */
    GbsPostMessageS(CHIPKARTE_PL_PID,M_CK_SL_REL_IND);
    GbsPostMessageS(CHIPKARTE_PL_PID,M_CK_SL_CON_IND);
}

void
PhonebookRefresh(void)
{
  simulate_sim_refresh(0); /* load new image file if one is defined in simsim.ini */
  PBrefr_Required(); /* unconditional phonebook refresh */
}

void ATCRefresh(void)
{
   static unsigned char ptr[] = "\x0B\xD0\x09\x81\x03\x01\x01\x04\x82\x02\x81\x82";
   unsigned char aptr[255];

   SATAL_POST_TOOLKIT_ATC_COMMAND(ptr, aptr, 0);
}

TYPE_RSM_DATA rsm_data;
//unsigned char data[] = "\x01\x01\x01";  //data
unsigned char data[] = "\x41\x41\x52\x53\x54\x45\x4E\xFF\xFF\xFF\xFF\xFF\x0B\xFF\x12\x34\x56\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF";  //data

void ATC_Update_DF(void)
{
//#define binary 0

#ifdef binary
   int command = 0xD6;    // update binary
   int fileid = 0x6F37;   // ACMmax (binary)
//   unsigned char data[] = "\x01\x01\x01";  //data

   rsm_data.in.P1 = 0;  //offset high
   rsm_data.in.P2 = 0;  //offset low
   rsm_data.in.P3 = 3;  // length
#else
   int command = 0xDC;    // update record
   int fileid = 0x6F3A;   // ADN (record)
//   unsigned char data[] = "50";  //data

   rsm_data.in.P1 = 1;  // Rec. No
   rsm_data.in.P2 = 4;  // mode  (4 = current with P1=0)
   rsm_data.in.P3 = 26;  // length
#endif

   rsm_data.in.data = data;

   POST_CKMSG_RESTRICTED_ACCESS(command,fileid,&rsm_data);
}

#endif

