/*! \file 

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

.AUTHOR Sun Min(PEK)

.FILENAME SmtkToolOutput.cpp

.VERSION 01.00.00

.DATE 2004-06-17

.SHORT_DESCR:   Implementation of child window SMTK Tool output window
                of SMTK Tool Utilities window

.SW_COMPONENT:  SMTK EMULATOR

.SW_TYPE 

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change
01.00.00 2004-06-17 Sun Min(PEK)
            Initial version
01.00.01 2004-06-18 Sun Min(PEK)
                    Use this file only for SHAPED_UI            
01.01.00 2004-08-18 Sun Min(PEK)
                    Function SetOutputView(), OnSize() modify
01.01.01 2004-10-25 Sun Min(PEK)
                    Fix bug DT100106555,
                    Modify function SetOutputView() for fixing bug about output text.       
01.01.02 2004-11-04 Sun Min(PEK)
                    Enable SMTK Tool both in MDV and Shaped UI
01.01.03 2005-03-08 Guan Tian Yi(PEK)
                    Add the Popup window and Print java Trace
*/

//modify to enable SMTK tool both in MDV and Shaped UI
#ifdef JAVA_SDK
#include "SmtkToolOutput.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSmtkToolOutput dialog


CSmtkToolOutput::CSmtkToolOutput(CWnd* pParent /*=NULL*/)
    : CDialog(CSmtkToolOutput::IDD, pParent)
{
    //{{AFX_DATA_INIT(CSmtkToolOutput)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
}


void CSmtkToolOutput::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CSmtkToolOutput)
    DDX_Control(pDX, IDC_SMTK_OUTPUT_VIEW, m_outputView);
    //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSmtkToolOutput, CDialog)
    //{{AFX_MSG_MAP(CSmtkToolOutput)
        ON_WM_CREATE()
        ON_WM_SIZE()
    //}}AFX_MSG_MAP

    ON_WM_ERASEBKGND()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSmtkToolOutput message handlers
BOOL CSmtkToolOutput::OnInitDialog()
{
    CDialog::OnInitDialog();
    m_outputView.Clear();
    return TRUE; 
}

void CSmtkToolOutput::SetOutputView(UINT uiMessage,CString cStrOutPut)
{   
    switch(uiMessage)
    {
    case 1:
//fixing bug about output text
        {   
            if(!cStrOutPut.IsEmpty())
            {            

				{
			
                m_outputView.SetWindowText(cStrOutPut);
                m_outputView.LineScroll(m_outputView.GetLineCount(),0);
						
				}
            }
            break;
        }
    case 2:
        {
            m_outputView.SetWindowText("");
            break;
        }
    }
}

CSmtkToolOutput::~CSmtkToolOutput()
{
//  if (!m_outputView)
  //    delete m_outputView;    
}


void CSmtkToolOutput::OnSize(UINT nType,int cx,int cy)
{
    CDialog::OnSize(nType,cx,cy);
    if(m_outputView)
        m_outputView.LineScroll(m_outputView.GetLineCount(),0);
}


BOOL CSmtkToolOutput::OnEraseBkgnd(CDC* pDC)
{
    // TODO: Add your message handler code here and/or call default

    //return CDialog::OnEraseBkgnd(pDC);
    return FALSE;
}
#endif
