/*
             Siemens AG
         Mobile Radio Terminals
          Munich, Germany

.AUTHOR         B. Baier, PN KE CPT 53

.SHORT_DESCR    Display Window for MMI Test Environment

.SW_COMPONENT   PC-MMI-Test Environment
.SW_TYPE        Support-File

.VERSION        11.02.00

.DATE           2004-04-06

.CHANGE_CONTROL
Version |  Date  | Changed by | Reason for Change
1.0    04.04.97  B. Baier     file created...... (parts of old lcddrv.cpp)
1.1    04.04.97  B. Baier rewrite of keyboard message handling
1.2    04.04.97  B. Baier rewrite of paint procedure
1.3    28.08.97  B. Weimer    message evaluated when data is available on socket
1.4    11.09.98  P.Lef????????????vre    UP-Browser only #if UP_BROWSER > 0
1.5    15.09.98  B. Weimer    included upconf.h
--------------------------------------------------------------------------------
1.0    01.07.99  N. Haiduk    p35-variant
1.1    17.11.99  N. Haiduk    'UPNetDataAvailable' flagged with MMI_BROWSER_AVAILABLE
1.2    29.06.00  B. Weimer    removed UPNetDataAvailable (for browser)
1.3    08.08.00  T. Gaugler   added handling of message OBEX_TCP_WINDOWS_MESSAGE in
message loop to simulate OBEX over TCP by the means of
the winsock library.
--------------------------------------------------------------------------------
1.6    08.12.00  V. Bauche    skin and key event handling added
1.7    05.04.01  D. Ambras    1.6 merged into current version, skin improvements
1.8    11.04.01  D. Ambras    bugs and memory leaks fixed, magnification menu added
1.9    27.04.01  D. Ambras    debug menu, some enhancements, save settings to registry
1.10   03.05.01  Jan Eichholz debuggerActive now available as external
1.11   23.05.01  F.Schultze   Made use of ENABLE_JAVA_DEBUGGER switch
1.12   28.05.01  D.Ambras     save window coordinates in registry, 2 more debug options,
"magnification" --> "zoom", build info
1.13   30.05.01  D.Ambras     path buffer problem fixed, ressource leak fixed,
java debug proxy start/ stop on demand
1.14   13.06.01  D.Ambras     new skin for JAVA_SDK version (SL45i), no auto start
of java debug proxy
1.15   19.06.01  D.Ambras     non-permanent storage of command line options in registry,
new data handling via table introduced
1.16   11.07.01  D.Ambras     storage of install path in registry, use it for skin directory
improve of skin dimension handling
2.0    12.07.01  D.Ambras     bugfix for ability of skin change, some improvements
2.1    18.07.01  D.Ambras     set correct sub path for skins in JAVA SDK, some unused variables deleted
2.2    10.08.01  F.Schultze   Call jnfnet_tcp_notify for async winsock message
2.2.1  16.08.01  F.Schultze   Don't include jnf_neth.h
2.3    20.08.01  Dirk Ambras  refined startup and shutdown of java debug proxy
added skin for chinese version
2.4    24.08.01  Dirk Ambras  for java debugging: set java API and Apps class paths according to registry
2.5    14.09.01  Jan Eichholz kdp start changed

02.05.00  2001.09.17    Dirk Ambras (MCH)   merge from gen7k, grid lines for creation of skins added
side keys of PC simulation skin activated
02.06.00    18.09.01    Jan Eichholz        JDKHome added
02.07.00    24.09.01    Jan Eichholz        paths corrected
02.08.00    2001-10-12  D.Ambras (MCH)      made it color-compatible
08.05.00    2001-11-13  C.R1ffer (MCH)      interface of DispGetPixelInfo() changed back to old version
08.06.00    2001-11-14  D.Ambras (MCH)      fixed a minimize-window bug
support of color correction
08.06.00    2001-11-14  D.Ambras (MCH)      macro INCLUDEDEBUGCODE == 0 enabled
08.08.00    23.01.02    Jan Eichholz        start directory for kdp changed to INSTALL_PATH
08.09.00    2002-02-19  D.Ambras (MCH)      macro INCLUDEDEBUGCODE == 0 enabled, color support corrected
---------------------------------------------------------------------------------------------------
09.01.00    2002-03-13  C.R1ffer (MCH)      DPLDRV_COLOR_TYPE changed to a better name
09.02.00    2002-03-15  D.Ambras (MCH)      registry path model changed,
                                            disable debuggerActive by default,
                                            new good natured search for skin bitmaps
09.02.01    2002-03-22  F.Schultze (MCH)    JNFNET_WINDOW_MSG now taken from jnf_neth.h
09.03.00    2002-05-02  B. Duemler (KLF)    Added button to change the start of the simulation
                                            Now I can start the simulation in charge mode
09.04.00    2002-05-06  D.Ambras (MCH)      "Unified Emulator Interface" support merged from uen8m.z1
09.05.00    2002-05-24  F.Schultze (MCH)    put http_tcp_notify back in again
09.06.00    2002-07-11  D.Ambras (MCH)      made LCD color simulator switch accessible in Java SDK
                                            registry keys for LCD colors and monitor gamma added
09.07.00 2002-09-02 W.Goedde (isc-ag)       added menue for start-up mode
09.08.00 2002-11-11 Manfred Weil (KLF)      SMTK request: changed skin-names from L55 to S55 (3 times)
09.08.01 2002-12-13 Manfred Weil (KLF)      DestroyMenu(hMenu) in destructor function added,
                                            window title changed from "MMI-Display" to "SMTK Phone Simulator"
---------------------------------------------------------------------------------------------------
10.01.00 2002-12-09 Alexander Nagy (BS SW)  introduced new rooting directories for PCSIMU and SMTK
                                            to support more than one drive
                                            introduced new registry pathes for PCSIMU
10.01.01 2003-02-11 Alexander Nagy (BS SW)  bugfix in InitSimulatorRegistry()
10.01.02 2003 -02-13 Alexander Nagy (BS SW) remove FILESYSTEM_PATH key in der mg_MainKey folder if this key
                                            is defined in the mg_MainKey folder
                                            -> only one filesystem folder for serveral projects
                                            indroduced DeleteRegistryKey()
                                            modified ProjectPath()
10.01.03 2003 -02-25 Alexander Nagy (BS SW) modified GetOrSetInstallPath(); FS_DRIVE_PATH_ and FS_DRIVE_SIZE_ registry
                                            keys will be created for every flash file system drive - this allows
                                            registry modifications of this parameters;
                                            added initialization of the driveInfoBlock;
                                            replaced WFS_ChangeRootPath() by JAM_ChangeRootPath;
10.01.03 2003-03-03 Frank Schultze (MCH)    Added option for including timestamp in Java trace file
10.01.04 2003 -03-05 Alexander Nagy (BS SW) replaced GetCurrentDirectory() by Simu_GetExeInstallPath()
                                            introduced Simu_GetFilePath() in buildSkinsMenu() to avoid static path settings
10.02.00 2003-03-18 Dirk Ambras (MCH)       changed skin file loading to binary mode
10.03.00 2003-04-17 Jens Scharnow (KLF)     added support for MTT
10.04.00 2003-05-19 N.Barisits (VIE)        added include directive for inc_private_alias.h
10.04.01 2003-06-16 B. Baier                DispUpdate->DisplayUpdate
10.04.02 2003-06-17 B. Baier                added missing include dpl_def.h
10.05.00 2003-06-21 M.Korkmaz               New UI for PC-SIMU
10.05.01 2003-07-01 Yang Yong Qiang (PEK)   CLDC-HI adaption
10.05.02 2003-07-15 Jens Scharnow (KLF)     Improved MTT Support
         2003-07-18 Y.Lei,M.Korkmaz         created menu for clamp shell display
                                            update DispGetPixel etc. for MMI main display
10.06.02 2003-07-18 Andre Schmidt (KLF)     Change KeyType value from KEY_New_SELECT to KEY_New_CENTER (new center click)
10.06.03 2003-07-21 Murat Korkmaz           Bug fix HWND GetMMIDispHandle(void)
10.07.00 2003-07-21 C.R1ffer (MCH)          DispGetPixelInfo changed to DispGetPixel
                                            DisplayUpdate changed to DispRepaint
10.07.01 2003-07-22 Thomas Herrmann (MCH)   Integration of CLDC-HI options into new UI
10.07.02 2003-08-08 Frank Schultze (Mch)    getSystemProperty now takes 2 arguments
10.08.00 2003-08-27 C.R1ffer (MCH)          removed DispSetConnectedPixels, DispSetDisconnectedPixels and DispArePixelsConnected
                                            added dpls0.h and removed some prototypes
10.08.01 2003-09-02 Yang Yong Qiang (PEK)   Add tracenetworking and TraceNativeCalls into UI for CLDC HI
10.09.00 2003-09-03 Klaus Staudenmaier (ULM)Introduced Filesystem to PC-SIMU
                                            (Located now under C_mobsim\Filesystem\A..
10.09.01 2003-09-19 Thomas Herrmann (Mch)   Removed conditional code for KVM i.e. !USE_MONTY
10.10.00 2003-10-02 Alexnder Nagy (BS)      corrected registry structure PCSIMU/CDB/PROJEKT
10.10.01 2003-10-06 Thomas Herrmann (Mch)   Fixed Java UserClassPath issue
10.11.00 2003-09-12 Mads Kristiansen (KLF)  Added handler for UPBROWSER_NETEVENT_NOTIFY_MSG
-----------------------------------------------------------------------------------------------------------------------
10.12.00 2003-10-23 Murat Korkmaz (Mch)     Removing of old PC-SIMU UI sources
10.13.00 2003-10-27 Murat Korkmaz (Mch)     Changing of registry for Java DebugTrace settings
10.13.01 2003-10-28 Thomas Herrmann (Mch)
         Java debugger proxy port is now stored as integer instead of string
10.14.00 2003-11-17 Zhang qi fan(PEK)     Added localization support for SMTK
10.15.00 2003-12-11 Marian Kremnican (BTS) OnToolbarSwitchoff changed 
10.15.01 2003-12-11 Stefan Franke (SAL)      Activate the BrowserSim_NetworkEventNotify() function to make send/receive MMS possible
10.16.00 2003-12-18 Zhang Qi Fan (PEK)  bug fixed for SMTK: "Mobile Keyboard no reponse" afetr some actions with toolbar
10.17.00 2003-12-18 Alexander Nagy (Mch)    introduced preparations for the new FFS
                                            added public registry access functions (FS_DRIVE_PATH and FS_DRIVE_SIZE) to CMMIDispWindow class
10.17.01 2004-01-12 Alexander Nagy (Bardenheuer SW)
                                            changed return parameter bool -> BOOL of the registry access functions (FS_DRIVE_PATH and FS_DRIVE_SIZE)
10.18.00 2004-01-13 C.R1ffer (MCH)          added DispClearDispBufferBusy
10.18.01 2004-01-19 Norbert Barisits (VIE)  InitSimulatorRegistry - use malloc instead of _tcsdup
                                            to avoid memory context problems during shutdown 
10.18.02 2004-02-03 Yang Yong Qiang (PEK)  Replace USE_WINDOWS_FS with MOBSIM for Java Debugger Functionality
10.18.03 2004-02-09 Murat Korkmaz (MCH)    BugFix WriteDrivePathToRegistry function.
10.19.00 2004-02-10 Leena Khera(SISL,India)          added GetInstallPath()
10.19.01 2004-02-24 Murat Korkmaz (MCH)    BugFix CQ #19310, BitBlt with cordinates y=1,x=1.
10.19.02 2004-02-24 Murat Korkmaz (MCH)    BugFix MIDP registry entries are now in 
                                           HKEY_CURRENT_USER\Software\Siemens\PCSIMU\Options\Java Debug Trace
10.20.00 2004-02-13 Murat Korkmaz (MCH)    Adaptions for QWERTY keypad
10.20.01 2004-03-01 Marian Kremnican (BTS) Variable mg_MMIMode changed to type "C"
10.21.00 2004-03-03 Leena Khera(SISL,India) Added functions :
                                            ReadSimulatorRegistryFromSubDirectory
                                            WriteSimulatorRegistryToSubDirectory
10.21.01 2004-03-04 Murat Korkmaz (MCH)    BugFix: function getProjectPath.
10.22.00 2004-03-11 Murat Korkmaz (MCH)    Function SetSkinProps enhanced to get the Flexshelltype from skn file
10.22.00 2004-03-12 Murat Korkmaz (MCH)    Function added KeypGetFlexShellType 
10.23.00 2004-03-15 Murat Korkmaz (MCH)    Keys[] qwerty key uncommented
10.23.01 2004-03-17 Murat Korkmaz (MCH)    BugFix CQ #19310, BitBlt with cordinates y=2,x=2.
11.00.00 2004-03-18 Zhang Jing (PEK)       SHAPED UI for Java sdk 
11.00.01 2004-03-30 Hu Chengjing (PEK)	   Active OnIndex and OnContent to link to SMTKHelp.chm for SMTK emulators
11.00.02 2004-03-31 Zhang qifan (PEK)      Set skin& file name by product name for only SMTK
11.01.00 2004-04-05 C.R1ffer (MCH)         new handling for some special key events
11.02.00 2004-04-06 Murat Korkmaz(MCH)     New menu entry View->Flexshell Toolbar added.
11.02.01 2004-04-30 Sun Min (PEK)          Remove "Phone" menu from SMTK Emulator
                                           Modify the displayed content in "About" pop window in SMTK Emulator
11.03.00 2004-05-18 C.R1ffer (MCH)         added keycode support for VK_LCONTROL and VK_RCONTROL
11.03.01 2004-05-21 Sun Min(PEK)	   Add checkmark to "View->Hide Skin" when view switched to Display Only for SMTK;
                                           Add checkmark to "View->100%" or "view->200%" when switch between them for SMTK;
                                           Add checkmark to "View->Main menu" when open/close main menu.Third level menu items are eliminated.
                                           Keep pos and size of MDV when switch between MDV<->Shaped UI;
                                           When switch between 100%<->200%<->Hide Skin:keep the upper left corner is the starting point for the other views.
11.03.02 2004-05-21 Du Chun (Pek)
                                           Move the Options registry key from under Emulaters to under Emulators\<model>
                                           Remove MP model name from mg_RegistryKey and mg_MainKey
11.04.00 2004-05-27 Murat Korkmaz(MCH)     Function SetSkinProps modified, the skn files are now "ini" format.
11.04.01 2004-05-28 Du Chun (PEK)          Use same background bitmap for MDV and SHAPED UI window. 
11.04.02 2004-05-28 Du Chun (PEK)          Seperate SHAPED UI feature from JAVA_SDK. 
11.05.00 2004-06-02 Murat Korkmaz(MCH)     Function paint modified.
11.04.04 2004-06-01 Sun Min(PEK)           Change JAVA_SDK to USE_SHAPED_UI in OnMagnify100 and OnMagnify200.     
11.04.05 2004-06-02 Sun Min(PEK)           According to flexshell type, add related menu items to shaped UI menu.                                      
11.04.06 2004-06-10 Sun Min(PEK)           Add options window to shaped UI and remove debugging/tracing menu item from shaped UI.
                                           Only with JAVA_SDK switch: Completely remove the "Debugging/Tracing" Menu from MDV.
                                           Function buildSkinsMenu,buildSkinsPopMenu modified
                                           Function OnShowOptionsDlg added
11.05.00 2004-06-11 Du Chun (PEK)          Add Flexshell open and close function to Neo2. 
11.06.00 2004-06-17 Frank Schultze (MCH)   Fix compile error (Info_GetProductName)
11.07.00 2004-06-17 Sun Min(PEK)           Add SMTK Tool window to shaped UI
11.08.00 2004-06-18 Fang Yunchao(PEK)      Add UNICODE support
11.09.00 2004-06-24 Fang Yunchao(PEK)      Modification for SMTK Localization support
11.10.00 2004-06-24 Murat Korkmaz          Vibra feature for pc-simu added
11.10.01 2004-06-29 Murat Korkmaz          Bug Fixon Function PAint: freeing of pBmiDisplay
11.11.00 2004-07-01 C.R1ffer (MCH)         added some PC-Skin variables from dpl_s0k.c
11.12.00 2004-07-05 Murat Korkmaz          Dynamic Light feature added.
11.13.00 2004-07-12 Leena Khera(SISL,India)Show Error Message is activated by default, will not be stored in registry.
11.14.00 2004-07-14 Murat Korkmaz          Functions MakeButtonsVisible(CDC *dc) and Paint modified.
11.15.00 2004-07-18 Fang Yunchao(PEK)      Modification for UNICODE support
11.16.00 2004-07-30 Fang Yunchao(PEK)      Remove 3 bugs of Shaped UI
11.16.01 2004-08-03 Fang Yunchao(PEK)      move definition of varible "GlobalUiStyle" to the outside of #ifdef USE_SHAPED_UI
11.17.00 2004-08-06 Fang Yunchao(PEK)      Java debug proxy kdp.jar now loaded from path <drive_no:\SMTK\bin> for smtk emulator only!
11.17.01 2004-08-20  U.Kapala inc_private_alias is replaced with C2C concept and is removed. (only relevant for PCMMI)
11.18.00 2004-08-17 Sun Min(PEK)           Modify function SetSmtkToolValue(), SetOutputView.
10.18.01 2004-09-03 Thomas Herrmann (Mch)  Initialize RunFinalizationAtExit correctly
11.19.00 2004-09-07 Murat Korkmaz          Sound for vibra added.
11.19.01 2004-09-16 Fang Yunchao           moved 2 bugs in Shaped UI
11.20.00 2004-09-24 Guan Tian yi(PEK)      Remove the "Help" options and add the "About" options in SMTK Emulator.
11.20.01 2004-10-21 Fang Yun chao(PEK)     Fix bug DT100098141 
                                           Fix bugs of flex shell display
11.20.02 2004-10-25 Sun Min(PEK)           Fix bug DT100106555
                                           Fix bug about output text
11.20.03 2004-11-04 Sun Min(PEK)           Enable SMTK Tool both ind MDV and Shaped UI
11.20.04 2004-11-11 Guan Tian yi(PEK)      Fix the bug NO.DT100112311 
11.20.05 2004-11-18 Sun Min(PEK)           Enable smtk tool in java_sdk
11.20.06 2004-11-26 Sun Min(PEK)           Enable phone skin not only for USE_SHAPED_UI but also JAVA_SDK.
11.21.00 2004-12-10 Murat Korkmaz          Function afx_msg BOOL OnEraseBkgnd added.
11.21.01 2005-1-10  Guan Tian yi(PEK)      Rechange the "About" options to the "Help" and modification the "About" information.
11.21.02 2005-1-14  Guan Tian yi(PEK)      Change the mainkey value to SMTK_3.X in the RegistryKey.
11.21.03 2005-1-18  Guan Tian yi(PEK)      Add the "User's Manual"options in the "Help" menu,and disable the "CSDisp" options.
11.21.04 2005-01-25 Sun Min(PEK)           Add for Java COM0 and COM1 redirection for SMTK
11.21.05 2005-01-31 Fang Yunchao(PEK)      Fix SUN One Java debug, classpath bug and UEI Java trace options 
11.22.00 2005-02-23 Du Chun(PEK)           Adding function to emulators for running java applications dragged from outside
11.23.00 2005-03-08 Guan Tian yi(PEK)      Add the Popup window and Print java Trace.

**************************************Jerry*********************************
12.00.00 2006-03-17 Gurpreet Sabharwal(SISL ,India)
                    Removed Java Support And Functionality
12.00.01 2006-03-22 Parul Singhal(SISL,India) 
                    Support for Hard Keys is added.Changes made to enum KeyType and Keys[]
                    hardkeys included for idle screen,contacts,menu,lock,unlock,vol. up,vol. down, profile up, profile down
12.00.02 2006-03-27 Parul Singhal(SISL,India) 
                    Support for blinking effect 
12.00.03 2006-03-27 Manoj Gupta (SISL, India)
                    Enabling Debugging/Tracing menu option in PC simulation. It was removed accidently during java removal.
*/

                                                 
#include "smsafxh.h"
#include "simuapph.h"
#include "mmidisph.h"
//#include "machineh.h"
#include "mainfrmh.h"
#include "sp_bmpdlgh.h"
#include "sp_cmdwndh.h"

#ifdef JAVA_SDK
#include "htmlhelp.h"
#include "info_main.h"
#endif //JAVA_SDK

#include <winmain.h>
#include "winrc.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <afxmt.h>
#include "vcdbgout.h"
#include "info_main.h"


#ifdef LOCALIZATION_SUPPORT
#include "localizationapi.h"//KZ added it
#include "..\localizationapi\ChangeUILanguageDlg.h"
#endif

//for jerry
extern BOOL mg_StartBlinking;

#define FLEXSHELL_ROTATOR 2

//#include "mmiconf.h"

extern "C"
{
    #include <global.h>
//    #include "inc_private_alias.h"
    #include "display.h"
    #include "dpls0.h"
    #include "keypad.h"
    #include "ob_tcp.h"     /* OBEX Simulation over TCP */
    #include "mmi.h"    // to get the g_MMIMode
    #include "lp_msg.h"
    #include "sdapi.h"

    #include "dplcfg.h"
    #include "dpl_def.h"
//    #include "jproph.h"
    #include "winpumsg.h"
    //windows file system
    #include "wfs_api.h"
  
//    #include "jamh.h"
 //   #include "jproph.h"
    #include "simumtth.h"
    #include "mopiext.h"
    #include "msmsim.h"
    #include "mmsim.h"
    #include "sms_simh.h"
    #include "info_main.h"
}

#include "simsimh.h"
#include "simu_inith.h"
#include "gbsext.h"
#include "browser_sim.h"
#include "mmidisph.h"

#include "kbddrv.h"

#if INCLUDEDEBUGCODE

typedef int bool_t;

extern "C"
{
    /*Trace Java debugger support operations*/
    extern int TraceDebugger;

    /*Trace thread events (transfer, yield, etc...)*/
    extern int TraceThreadEvents;

    /*Trace thread events (transfer, yield, etc...)*/
    extern int TraceThreadsExcessive;

    /*Trace class file verification*/
    extern int TraceVerifier;

    /*Trace stack map generation*/
    extern int TraceStackmaps;

    /*Trace stack map generation verbose*/
    extern int TraceStackmapsVerbose;

    /*Trace bytecodes during verification*/
    extern int TraceVerifierByteCodes;

    /*Trace on-stack-replacements*/
    extern int TraceOSR;

    /*Print a line when a class is loaded*/
    extern int TraceClassLoading;

    /*Trace exception throwing (with stack traces)*/
    extern int TraceExceptions;

    /*Verbose trace of GC*/
    extern int TraceGC;

    /*Verbose trace of finalization behavior*/
    extern int TraceFinalization;

    /*Print user-level GC information*/
    extern int VerboseGC;

    /*Print user-level class loading information*/
    extern int VerboseClassLoading;

    /*Generate interpreter that traces bytecodes*/
    extern int TraceBytecodes;

    /*Stop at given bytecode*/
    //extern int TraceBytecodesVerbose;

    /*Print all object by iterating over the object heap*/
    extern int PrintAllObjects;

    /*Run all finalizers when JVM terminates*/
    extern int RunFinalizationAtExit;

    /*Print a class after class loading*/
    extern int PrintLoadedClasses;

    /*Print a log for computing the object histogram*/
    extern int PrintObjectHistogramData;

    /*Print locals and expression stack when printing frames*/
    extern int PrintLongFrames;

    /*Prints a histogram of the executed bytecodes*/
    extern int PrintBytecodeHistogram;

    /*Prints a line for each compiled method*/
    extern int PrintCompilation;

    /*Prints the native code for all compiled methods*/
    extern int PrintCompiledCode;

    /*Prints the native code for all compiled methods*/
    extern int PrintCompiledCodeAsYouGo;

    /*Prints a histogram of the executed bytecode pairs*/
    extern int PrintPairHistogram;

    /*Trace native method calls -- enter and exit*/
    extern int TraceNativeCalls;

    /*Trace network status*/
    extern int tracenetworking;

  //  extern char* UserClassPath;
}

#else /*INCLUDEDEBUGCODE*/
    int TraceDebugger;
    int TraceThreadEvents;
    int TraceThreadsExcessive;
    int TraceVerifier;
    int TraceStackmaps;
    int TraceStackmapsVerbose;
    int TraceVerifierByteCodes;
    int TraceOSR;
    int TraceClassLoading;
    int TraceExceptions;
    int TraceGC;
    int TraceFinalization;
    int VerboseGC;
    int VerboseClassLoading;
    int TraceBytecodes;
   //int TraceBytecodesVerbose;
    int PrintAllObjects;
    int RunFinalizationAtExit;
    int PrintLoadedClasses;
    int PrintObjectHistogramData;
    int PrintLongFrames;
    int PrintBytecodeHistogram;
    int PrintCompilation;
    int PrintCompiledCode;
    int PrintCompiledCodeAsYouGo;
    int PrintPairHistogram;
    int TraceNativeCalls;
    int tracenetworking;
#endif /*!INCLUDEDEBUGCODE*/

//sun min, 2004-11-10: add for com0 and com1 redirection
int Com0RedirectState;
    char Com0RedirectInfo[255];
extern "C" int GetCom0RedirectState()
{
    return Com0RedirectState;
}
extern "C" char* GetCom0RedirectInfo()
{
    return Com0RedirectInfo;
}

#if ENABLE_JAVA_DEBUGGER
    static PROCESS_INFORMATION  JavaDebuggerProcessInfo;
    extern "C" bool_t           debuggerActive;
#endif

int  mg_debuggerActive;
int  mg_Tracing;
int  mg_ShowErrorMessages= TRUE;
int  mg_ShowInfoMessages = TRUE;
extern "C" T_MMIMode  mg_MMIMode = e_normal_mode;
bool g_bIsSpapedUIVibrating      = false;

static int TraceMIDP10 =0;
static int TraceMIDP20 =1;
int mg_FlexShellType = eFlexShell_Non;

#ifdef JAVA_SDK    //flag for auto popup tool output window
int mg_autoPopupOutputWnd = 1;
//int mg_smtkToolDlgOpened = 0;
#endif


extern "C"
{
    void info_message(const char *message, const char *head);
    void jnfnet_tcp_notify (UINT, WPARAM, LPARAM);
    void http_tcp_notify (UINT, WPARAM, LPARAM);
}

extern char* GetNextStringPart(char *Source, char *Dest, int BufferLength);


#define NUMBEROF(x) (sizeof(x)/sizeof(x[0]))

#define INSIDE(_x, _y, _r)                              \
    ((_x >= DispGetPixelWidthZoom(E_DISP_MAIN)*((_r).x)) && \
     (_x < DispGetPixelWidthZoom(E_DISP_MAIN)*((_r).x + (_r).width)) &&  \
     (_y >= DispGetPixelHeightZoom(E_DISP_MAIN)*((_r).y)) && \
     (_y < DispGetPixelHeightZoom(E_DISP_MAIN)*((_r).y + (_r).height)))

typedef enum {
    KEY_New_0        = '0',
    KEY_New_1        = '1',
    KEY_New_2        = '2',
    KEY_New_3        = '3',
    KEY_New_4        = '4',
    KEY_New_5        = '5',
    KEY_New_6        = '6',
    KEY_New_7        = '7',
    KEY_New_8        = '8',
    KEY_New_9        = '9',
    KEY_New_ASTERISK = '*',
    KEY_New_POUND    = '#',

    KEY_New_UP       = -1,
    KEY_New_DOWN     = -2,
    KEY_New_LEFT     = -3,
    KEY_New_RIGHT    = -4,
    KEY_New_CENTER   = -5,

    KEY_New_SOFT1    = -6,
    KEY_New_SOFT2    = -7,
    KEY_New_SEND     = -10,
    KEY_New_END      = -11,
    KEY_New_POWER    = -12,

    // side keys:
    KEY_New_MEMO     = -13,
    KEY_New_PLAY     = -14,
    KEY_New_SideUp   = -15,
    KEY_New_SideDown = -16,
    KEY_New_PHONEBOOK= -17,

    // qwerty keys
    KEY_QWERTY_0_0   = -18,
    KEY_QWERTY_1_0   = -19,
    KEY_QWERTY_2_0   = -20,
    KEY_QWERTY_3_0   = -21,
    KEY_QWERTY_4_0   = -22,
    KEY_QWERTY_5_0   = -23,
    KEY_QWERTY_6_0   = -24,
    KEY_QWERTY_7_0   = -25,
    KEY_QWERTY_8_0   = -26,
    KEY_QWERTY_9_0   = -27,
    KEY_QWERTY_0_1   = -28,
    KEY_QWERTY_1_1   = -29,
    KEY_QWERTY_2_1   = -30,
    KEY_QWERTY_3_1   = -31,
    KEY_QWERTY_4_1   = -32,
    KEY_QWERTY_5_1   = -33,
    KEY_QWERTY_6_1   = -34,
    KEY_QWERTY_7_1   = -35,
    KEY_QWERTY_8_1   = -36,
    KEY_QWERTY_9_1   = -37,
    KEY_QWERTY_0_2   = -38,
    KEY_QWERTY_1_2   = -39,
    KEY_QWERTY_2_2   = -40,
    KEY_QWERTY_3_2   = -41,
    KEY_QWERTY_4_2   = -42,
    KEY_QWERTY_5_2   = -43,
    KEY_QWERTY_6_2   = -44,
    KEY_QWERTY_7_2   = -45,
    KEY_QWERTY_8_2   = -46,
    KEY_QWERTY_9_2   = -47,
    KEY_QWERTY_1_3   = -48,
    KEY_QWERTY_2_3   = -49,
    KEY_QWERTY_4_3   = -50,
    KEY_QWERTY_5_3   = -51,
    KEY_QWERTY_7_3   = -52,
    KEY_QWERTY_8_3   = -53,
    KEY_QWERTY_9_3   = -54,
    KEY_New_CONTACT  = -55, //contacts hard key implemented for jerry
    KEY_New_MENU     = -56, //contacts hard key implemented for jerry
    KEY_New_IDLE     = -57, //hard key implemented for jerry for displaying idlescreen
    KEY_New_LOCK     = -58, //lock hard key implemented for jerry
    KEY_New_UNLOCK   = -59, //unock hard key implemented for jerry
    KEY_VOL_UP       = -60, //Volume increase hard key implemented for jerry
    KEY_VOL_DOWN     = -61, //Volume decrease hard key implemented for jerry
    KEY_PROFILE_UP   = -62, //Pofile increase hard key implemented for jerry
    KEY_PROFILE_DOWN = -63, //Pofile increase hard key implemented for jerry
    KEY_New_INVALID  = 0,
} KeyType;

typedef struct _Rectangle {
    int x;
    int y;
    int width;
    int height;
} XRectangle;

typedef struct  {
    KeyType button;
    XRectangle bounds;
    char *name;
    int keyCode;
} Key;

static Key Keys[] =
{  //                                                    L1 Keypad defines, view keypad.h
    {KEY_New_POWER,    {0,   0,   0,  0 }, "KEY_POWER",  EOB},
    {KEY_New_SOFT1,    {107, 247, 33, 11}, "KEY_SOFT1",  SOFT_1},
    {KEY_New_SOFT2,    {190, 247, 33, 11}, "KEY_SOFT2",  SOFT_4},
    {KEY_New_UP,       {148, 251, 36, 13}, "KEY_UP",     NAVI_UP},
    {KEY_New_DOWN,     {148, 286, 36, 13}, "KEY_DOWN",   NAVI_DOWN},
    {KEY_New_LEFT,     {142, 264, 14, 22}, "KEY_LEFT",   NAVI_LEFT},
    {KEY_New_RIGHT,    {174, 264, 14, 22}, "KEY_RIGHT",  NAVI_RIGHT},
    {KEY_New_CENTER,   {0,   0,   0,   0}, "KEY_CENTER", NAVI_CENTER},
    {KEY_New_SEND,     {107, 259, 33, 28}, "KEY_SEND",   START},
    {KEY_New_END,      {190, 259, 33, 28}, "KEY_END",    ONOFF},

    {KEY_New_1,        {107, 304, 33, 15}, "KEY_1",      KEY_1},
    {KEY_New_2,        {149, 306, 33, 15}, "KEY_2",      KEY_2},
    {KEY_New_3,        {187, 304, 33, 15}, "KEY_3",      KEY_3},
    {KEY_New_4,        {107, 329, 33, 15}, "KEY_4",      KEY_4},
    {KEY_New_5,        {149, 331, 33, 15}, "KEY_5",      KEY_5},
    {KEY_New_6,        {187, 329, 33, 15}, "KEY_6",      KEY_6},
    {KEY_New_7,        {110, 356, 31, 15}, "KEY_7",      KEY_7},
    {KEY_New_8,        {149, 356, 33, 15}, "KEY_8",      KEY_8},
    {KEY_New_9,        {187, 356, 31, 15}, "KEY_9",      KEY_9},
    {KEY_New_ASTERISK, {116, 379, 27, 15}, "KEY_*",      STAR},
    {KEY_New_0,        {151, 379, 28, 15}, "KEY_0",      KEY_0},
    {KEY_New_POUND,    {186, 379, 27, 15}, "KEY_#",      HASH},

    // side keys:
    {KEY_New_MEMO,     {0, 0, 0, 0}, "KEY_MEMO"    ,     MEMO },
    {KEY_New_PLAY,     {0, 0, 0, 0}, "KEY_PLAY"    ,     KEY_PLAY_STOP},
    {KEY_New_SideUp,   {0, 0, 0, 0}, "KEY_SIDEUP"  ,     UP },
    {KEY_New_SideDown, {0, 0, 0, 0}, "KEY_SIDEDOWN",     DOWN },

    //qwerty keys
    {KEY_QWERTY_0_0,   {0, 0, 0, 0}, "KEY_QWERTY_0_0",   KEY_0_0 },
    {KEY_QWERTY_1_0,   {0, 0, 0, 0}, "KEY_QWERTY_1_0",   KEY_1_0 },
    {KEY_QWERTY_2_0,   {0, 0, 0, 0}, "KEY_QWERTY_2_0",   KEY_2_0 },
    {KEY_QWERTY_3_0,   {0, 0, 0, 0}, "KEY_QWERTY_3_0",   KEY_3_0 },
    {KEY_QWERTY_4_0,   {0, 0, 0, 0}, "KEY_QWERTY_4_0",   KEY_4_0 },
    {KEY_QWERTY_5_0,   {0, 0, 0, 0}, "KEY_QWERTY_5_0",   KEY_5_0 },
    {KEY_QWERTY_6_0,   {0, 0, 0, 0}, "KEY_QWERTY_6_0",   KEY_6_0 },
    {KEY_QWERTY_7_0,   {0, 0, 0, 0}, "KEY_QWERTY_7_0",   KEY_7_0 },
    {KEY_QWERTY_8_0,   {0, 0, 0, 0}, "KEY_QWERTY_8_0",   KEY_8_0 },
    {KEY_QWERTY_9_0,   {0, 0, 0, 0}, "KEY_QWERTY_9_0",   KEY_9_0 },
    {KEY_QWERTY_0_1,   {0, 0, 0, 0}, "KEY_QWERTY_0_1",   KEY_0_1 },
    {KEY_QWERTY_1_1,   {0, 0, 0, 0}, "KEY_QWERTY_1_1",   KEY_1_1 },
    {KEY_QWERTY_2_1,   {0, 0, 0, 0}, "KEY_QWERTY_2_1",   KEY_2_1 },
    {KEY_QWERTY_3_1,   {0, 0, 0, 0}, "KEY_QWERTY_3_1",   KEY_3_1 },
    {KEY_QWERTY_4_1,   {0, 0, 0, 0}, "KEY_QWERTY_4_1",   KEY_4_1 },
    {KEY_QWERTY_5_1,   {0, 0, 0, 0}, "KEY_QWERTY_5_1",   KEY_5_1 },
    {KEY_QWERTY_6_1,   {0, 0, 0, 0}, "KEY_QWERTY_6_1",   KEY_6_1 },
    {KEY_QWERTY_7_1,   {0, 0, 0, 0}, "KEY_QWERTY_7_1",   KEY_7_1 },
    {KEY_QWERTY_8_1,   {0, 0, 0, 0}, "KEY_QWERTY_8_1",   KEY_8_1 },
    {KEY_QWERTY_9_1,   {0, 0, 0, 0}, "KEY_QWERTY_9_1",   KEY_9_1 },
    {KEY_QWERTY_0_2,   {0, 0, 0, 0}, "KEY_QWERTY_0_2",   KEY_0_2 },
    {KEY_QWERTY_1_2,   {0, 0, 0, 0}, "KEY_QWERTY_1_2",   KEY_1_2 },
    {KEY_QWERTY_2_2,   {0, 0, 0, 0}, "KEY_QWERTY_2_2",   KEY_2_2 },
    {KEY_QWERTY_3_2,   {0, 0, 0, 0}, "KEY_QWERTY_3_2",   KEY_3_2 },
    {KEY_QWERTY_4_2,   {0, 0, 0, 0}, "KEY_QWERTY_4_2",   KEY_4_2 },
    {KEY_QWERTY_5_2,   {0, 0, 0, 0}, "KEY_QWERTY_5_2",   KEY_5_2 },
    {KEY_QWERTY_6_2,   {0, 0, 0, 0}, "KEY_QWERTY_6_2",   KEY_6_2 },
    {KEY_QWERTY_7_2,   {0, 0, 0, 0}, "KEY_QWERTY_7_2",   KEY_7_2 },
    {KEY_QWERTY_8_2,   {0, 0, 0, 0}, "KEY_QWERTY_8_2",   KEY_8_2 },
    {KEY_QWERTY_9_2,   {0, 0, 0, 0}, "KEY_QWERTY_9_2",   KEY_9_2 },
    {KEY_QWERTY_1_3,   {0, 0, 0, 0}, "KEY_QWERTY_1_3",   KEY_1_3 },
    {KEY_QWERTY_2_3,   {0, 0, 0, 0}, "KEY_QWERTY_2_3",   KEY_2_3 },
    {KEY_QWERTY_4_3,   {0, 0, 0, 0}, "KEY_QWERTY_4_3",   KEY_4_3 },
    {KEY_QWERTY_5_3,   {0, 0, 0, 0}, "KEY_QWERTY_5_3",   KEY_5_3 },
    {KEY_QWERTY_7_3,   {0, 0, 0, 0}, "KEY_QWERTY_7_3",   KEY_7_3 },
    {KEY_QWERTY_8_3,   {0, 0, 0, 0}, "KEY_QWERTY_8_3",   KEY_8_3 },
    {KEY_QWERTY_9_3,   {0, 0, 0, 0}, "KEY_QWERTY_9_3",   KEY_9_3 },
//Added for jerry
    {KEY_New_CONTACT,  {0, 0, 0, 0}, "CONTACT_LIST_KEY", CONTACTS      },//   addressbook Key
    {KEY_New_MENU,     {0, 0, 0, 0}, "MENU_KEY",         MENU          },//   menu Key(calls,msg,tips,settings)
    {KEY_New_IDLE,     {0, 0, 0, 0}, "IDLE_KEY",         IDLE_0        },//   idle Key
    {KEY_New_LOCK,     {0, 0, 0, 0}, "LOCK_KEY",         KEY_LOCK      },//   KEY PAD LOCK Key
    {KEY_New_UNLOCK,   {0, 0, 0, 0}, "UNLOCK_KEY",       KEY_UNLOCK    },//   KEY PAD UNLOCK Key
    {KEY_VOL_UP,       {0, 0, 0, 0}, "VOL_UP",           VOLUME_PLUS   },//   vol. up key
    {KEY_VOL_DOWN,     {0, 0, 0, 0}, "VOL_DOWN",         VOLUME_MINUS  },//   vol. decrease key
    {KEY_PROFILE_UP,   {0, 0, 0, 0}, "KEY_PROFILE_UP",   PROFILE_PLUS  },//   vol. decrease key
    {KEY_PROFILE_DOWN, {0, 0, 0, 0}, "KEY_PROFILE_DOWN", PROFILE_MINUS },//   vol. decrease key
//End
} ;

#define SKIN_PATH_LEN        256

static char *SkinSubDir = "skin_src";      // directory for storing skins (bitmaps, data)

#if MMI_CHINESE_UI_AVAILABLE == 1
    static char phoneBitmap  [32] = "K4588M.bmp";     // small
    static char phoneBitmapG [32] = "K4588Mg.bmp";    // large
    static char SkinData     [32] = "K4588M.skn";     // button locations etc.
#else
#if defined (JAVA_SDK) || defined (USE_SHAPED_UI)
    static char phoneNameOrg [32] = "CX70";			// the SMTK phone name 
    static char phoneBitmap  [32] = "CX70.bmp";     // small
    static char phoneBitmapG [32] = "CX70g.bmp";    // large
    static char SkinData     [32] = "CX70.skn";     // button locations etc.
#else
    static char phoneBitmap  [32] = "S55.bmp";     // small
    static char phoneBitmapG [32] = "S55g.bmp";    // large
    static char SkinData     [32] = "S55.skn";     // button locations etc.
#endif
#endif

    static HKEY mg_hKey             = HKEY_CURRENT_USER;      // makes registry settings dependent on user

#ifdef JAVA_SDK
    static char mg_MainKey     [64] = "SOFTWARE\\Siemens\\SMTK_3.X\\Emulators";
    static char mg_RegistryKey [64] = "Siemens\\SMTK_3.X\\Emulators";
#else
    static char mg_MainKey     [64] = "SOFTWARE\\Siemens\\PCSIMU";
    static char mg_RegistryKey [64] = "Siemens\\PCSIMU";
#endif

    static char mg_SubKey    [SKIN_PATH_LEN];
    static char mg_WorkSubKey[SKIN_PATH_LEN];
    static int  mg_EmulatorWinStartX=  100, mg_EmulatorWinStartY= 100;
           int  mg_CmdWinStartX     = -100, mg_CmdWinStartY     = -1;
    static int  RegDataVersion      = 0;
           char mg_InstallPath[SKIN_PATH_LEN];

    static int  backgroundColor = RGB(253,196,65); // SL45 display yellow
    static int  foregroundColor = RGB(0,0,0);      // black
    char   SkinDataFile[256], SkinBitmapFile[256];

    int  emulatorWidth;
    int  emulatorHeight;
    bool g_SetMagnify=false;//Used to control magnification,when we click "100%" or "200%" menu,we don't recalculate the magnification parameter on resize
    int  displayWidth;
    int  displayHeight;
    int  x_offset;
    int  y_offset;

extern "C"
{
    extern bool RealColors;
    extern double  MonitorGamma;

    void SetForegroundColor(int rgb);
    void SetBackgroundColor(int rgb);
};

// thread safety
static int          tlsId;

/* support for changing the device's skin */
#define NUM_SKINS_SUPPORTED  8
#define ID_SKIN1             0          // MUST start from 0 on
#define ID_SKIN2             1
#define ID_SKIN3             2
#define ID_SKIN4             3
#define ID_SKIN5             4
#define ID_SKIN6             5
#define ID_SKIN7             6
#define ID_SKIN8             7
#define ID_REAL_COLOR       11

// other menu items:
#define ID_MAGNIFY_1        20
#define ID_MAGNIFY_2        21
#define ID_MAGNIFY_3        22
#define ID_MAGNIFY_4        23
#define ID_MAGNIFY_5        24
#define ID_MAGNIFY_8        28
#define ID_SEARCH          100
#define ID_CONTENT         101
#define ID_INDEX           102
#define ID_ABOUT           103
#define ID_USERMANUAL      104


#define   ID_DEBUGGER_ACTIVE      280
#define   ID_SHOW_ERRORS          281
#define   ID_SHOW_INFOS           282
#define   ID_TRACE1               299
#define   ID_MODE_ALARM           300
#define   ID_MODE_CHARGE          301
#define   ID_MODE_NORMAL          302


//modified by duchun for SHAPED_UI
//#ifdef SHAPED_UI
#ifdef USE_SHAPED_UI

extern int GlobalFrameTop;
extern int GlobalFrameLeft;
extern int GlobalCmdWndTop;
extern int GlobalCmdWndLeft;
extern int GlobalPhoneWidth;
extern int GobalMainMenuOpened ;
//extern int GlobalUiStyle;
extern int GlobalUiSkin;

#endif
extern int GlobalUiStyle;//Fang Yunchao moved to the outside of #ifdef USE_SHPAED_UI
extern void startJavaApplication();
extern void msm_sim_mtc(void);
extern void msm_sim_disconnect(void);
extern void mm_sim_full_service(void);
extern void mm_sim_no_service(void);

typedef void (*T_MOPI_ExtFunction)( UINT32 fParam );

extern void MOPI_ExecuteFunction( T_MOPI_CepId        cepIdToSimulate,
                           T_MOPI_ExtFunction  fToExecute,
                           UINT32              fParam );
extern "C" void SMSSIM_IncomingShortMessage_Mopi( UINT32 fParam );
extern "C" void PowerAL_Indicate_LowPowerBegin_Mopi( UINT32 fParam );
extern void FilesystemNotifyFreeSpace();
extern void FilesystemNotifyNoFreeSpace();
extern "C" void SwitchOffRequest_Mopi( UINT32 fParam );
extern "C" void cmdChooseNetwork_Mopi( UINT32 fParam );
extern "C" void PowerAL_Indicate_LowPowerEnd_Mopi( UINT32 fParam );

static int   numSkins   = 0;                 // stores No. of avail. skins
static int   skinpainted= 0;
int   mg_Magnification=  1;
static int   mg_CurrentSkin  = -1;
static char  *skins[ NUM_SKINS_SUPPORTED];


#define  NO_CMD                   0
#define  JVM_GLOBAL_OPTION        1
#define  JVM_LOCAL_OPTION         2
#define  JVM_TEMP_OPTION          3

#define  CURRENT_REGISTRY_VERSION  2

typedef struct Type_TraceFlagItems
{
    int   FlagID;
    int   *FlagPtr;
    char  *RegistryString;
    int   status;               // 0 = end, 1 = JVM global option, 2 = JVM local option
}  TraceFlagItems;


static TraceFlagItems TraceFlagItemTable[] =
{
    { ID_DEBUGGER_ACTIVE,                &mg_debuggerActive,        "debuggerActive",           JVM_GLOBAL_OPTION },
    { ID_TRACE_DEBUGGER,                 &TraceDebugger,            "TraceDebugger",            JVM_GLOBAL_OPTION },
    { ID_TRACE_THREADEVENTS,             &TraceThreadEvents,        "TraceThreadEvents",        JVM_GLOBAL_OPTION },
    { ID_TRACE_THREADSEXCESSIVE,         &TraceThreadsExcessive,    "TraceThreadsExcessive",    JVM_GLOBAL_OPTION },
    { ID_TRACE_VERIFIER,                 &TraceVerifier,            "TraceVerifier",            JVM_GLOBAL_OPTION },
    { ID_TRACE_STACKMAPS,                &TraceStackmaps,           "TraceStackmaps",           JVM_GLOBAL_OPTION },

    { ID_TRACE_STACKMAPSVERBOSE,         &TraceStackmapsVerbose,    "TraceStackmapsVerbose",    JVM_GLOBAL_OPTION },
    { ID_TRACE_VERIFIERBYTECODES,        &TraceVerifierByteCodes,   "TraceVerifierByteCodes",   JVM_GLOBAL_OPTION },
    { ID_TRACE_OSR,                      &TraceOSR,                 "TraceOSR",                 JVM_GLOBAL_OPTION },
    { ID_TRACE_CLASSLOADING,             &TraceClassLoading,        "TraceClassLoading",        JVM_GLOBAL_OPTION },
    { ID_TRACE_EXCEPTIONS,               &TraceExceptions,          "TraceExceptions",          JVM_GLOBAL_OPTION },

    { ID_TRACE_GC,                       &TraceGC,                  "TraceGC",                  JVM_GLOBAL_OPTION },
    { ID_TRACE_FINALIZATION,             &TraceFinalization,        "TraceFinalization",        JVM_GLOBAL_OPTION },
    { ID_TRACE_VERBOSEGC,                &VerboseGC,                "VerboseGC",                JVM_GLOBAL_OPTION },
    { ID_TRACE_VERBOSECLASSLOADING,      &VerboseClassLoading,      "VerboseClassLoading",      JVM_GLOBAL_OPTION },
    { ID_TRACE_BYTECODES,                &TraceBytecodes,           "TraceBytecodes",           JVM_GLOBAL_OPTION },//Modified by Fang Yunchao for UEI Java trace options
    //{ ID_TRACE_BYTECODESVERBOSE,         &TraceBytecodesVerbose,    "TraceBytecodesVerbose",    JVM_GLOBAL_OPTION },
    { ID_TRACE_PRINTALLOBJECTS,          &PrintAllObjects,          "PrintAllObjects",          JVM_GLOBAL_OPTION },
    { ID_TRACE_RUNFINALIZATIONATEXIT,    &RunFinalizationAtExit,    "RunFinalizationAtExit",    JVM_GLOBAL_OPTION },
    { ID_TRACE_PRINTLOADEDCLASSES,       &PrintLoadedClasses,       "PrintLoadedClasses",       JVM_GLOBAL_OPTION },
    { ID_TRACE_PRINTOBJECTHISTOGRAMDATA, &PrintObjectHistogramData, "PrintObjectHistogramData", JVM_GLOBAL_OPTION },

    { ID_TRACE_PRINTLONGFRAMES,          &PrintLongFrames,          "PrintLongFrames",          JVM_GLOBAL_OPTION },
    { ID_TRACE_PRINTBYTECODEHISTOGRAM,   &PrintBytecodeHistogram ,  "PrintBytecodeHistogram",   JVM_GLOBAL_OPTION },
    { ID_TRACE_PRINTCOMPILATION,         &PrintCompilation,         "PrintCompilation",         JVM_GLOBAL_OPTION },
    { ID_TRACE_PRINTCOMPILEDCODE,        &PrintCompiledCode,        "PrintCompiledCode",        JVM_GLOBAL_OPTION },
    { ID_TRACE_PRINTCOMPILEDCODEASYOUGO, &PrintCompiledCodeAsYouGo, "PrintCompiledCodeAsYouGo", JVM_GLOBAL_OPTION },

    { ID_TRACE_PRINTPAIRHISTOGRAM,       &PrintPairHistogram,       "PrintPairHistogram",       JVM_GLOBAL_OPTION },
    { ID_TRACE_NATIVECALLS,              &TraceNativeCalls,         "Trace Native Method Enter and Exit",   JVM_GLOBAL_OPTION },
    { ID_TRACE_NETWORKING,               &tracenetworking,          "Trace network status",     JVM_GLOBAL_OPTION },
    { ID_TRACE_MIDP10,                   &TraceMIDP10,              "MIDP 1.0",     JVM_GLOBAL_OPTION },
    { ID_TRACE_MIDP20,                   &TraceMIDP20,              "MIDP 2.0",     JVM_GLOBAL_OPTION },

    { NO_CMD, &mg_Tracing,           "mg_Tracing",       JVM_GLOBAL_OPTION },
 // Error Messages are set ON by default, despite of any registry value "mg_ShowErrorMessages".
 // { NO_CMD, &mg_ShowErrorMessages, "mg_ShowErrorMessages", JVM_GLOBAL_OPTION },
    { NO_CMD, &mg_ShowInfoMessages,  "mg_ShowInfoMessages",  JVM_GLOBAL_OPTION },
    { NO_CMD, &mg_Magnification,     "mg_Magnification",     JVM_LOCAL_OPTION },
    { NO_CMD, &mg_CurrentSkin,       "mg_CurrentSkin",       JVM_LOCAL_OPTION },
    { NO_CMD, (int *) &mg_MMIMode,   "mg_MMIMode",           JVM_LOCAL_OPTION },

    { NO_CMD, &mg_EmulatorWinStartX, "mg_EmulatorWinStartX", JVM_LOCAL_OPTION },
    { NO_CMD, &mg_EmulatorWinStartY, "mg_EmulatorWinStartY", JVM_LOCAL_OPTION },
    { NO_CMD, &mg_CmdWinStartX,      "mg_CmdWinStartX",      JVM_LOCAL_OPTION },
    { NO_CMD, &mg_CmdWinStartY,      "mg_CmdWinStartY",      JVM_LOCAL_OPTION },

    { NO_CMD, &RegDataVersion,       "ValidConfig",          JVM_LOCAL_OPTION },    // let be the last one

    { NO_CMD, NULL, "", NO_CMD }     // end marker
};


///////////////////////////////////////////////////////////////////////////////////
//
//              Function section
//
///////////////////////////////////////////////////////////////////////////////////


void ReadRegistryString ( HKEY hKey, char* SubKey, char* Name, char* Value, int &result)
{
    char  szClass[20]= "\0";
    BYTE qValue[255] ="\0";
    HKEY  ReadKey;
    DWORD dwDispos;
    ULONG type= REG_EXPAND_SZ;
    ULONG size= 255;

    result = RegCreateKeyExA(hKey, SubKey, 0, szClass,
                   REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,
                   NULL, &ReadKey, &dwDispos);

    if ( result != NO_ERROR )  return;

    result = RegQueryValueExA( ReadKey, Name, 0, &type, (BYTE *) qValue, &size);
    strcpy(Value, (const char *) qValue);
    RegCloseKey(ReadKey);
}


int WriteRegistryString( HKEY hKey, char* SubKey, char* Name, char* Value)
{
    char  szClass[20]= "\0";
    HKEY  WriteKey;
    DWORD dwDispos;
    int   result;

    result = RegCreateKeyExA(hKey, SubKey, 0, szClass,
                   REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,
                   NULL, &WriteKey, &dwDispos);

    if ( result != NO_ERROR )  return result;

    result = RegSetValueExA( WriteKey, Name,  0, REG_EXPAND_SZ, (CONST BYTE *) Value,  strlen(Value) );
    RegCloseKey(WriteKey);

    return result;
}


int WriteRegistry(HKEY hKey, char* SubKey, char* Name, int Value)
{
    char  szClass[20]= "\0";
    HKEY  WriteKey;
    DWORD dwDispos, Data= (DWORD) Value;
    int   result;

    result = RegCreateKeyExA(hKey, SubKey, 0, szClass,
                   REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,
                   NULL, &WriteKey, &dwDispos);

    if ( result != NO_ERROR )  return result;

    result = RegSetValueExA( WriteKey, Name,  0, REG_DWORD, (CONST BYTE *) &Data,  sizeof(DWORD) );
    RegCloseKey(WriteKey);

    return result;
}


// this functions automatically detects for a given variable
// the registry string and correct (permanent) location to write to:

int WriteVariablePermanentToRegistry(int &Value)
{
    int          i= 0, result= ERROR_INVALID_HANDLE;
    static char  RegPath[ 128];

    while ( TraceFlagItemTable[i].status != NO_CMD)
    {
        if ( TraceFlagItemTable[i].FlagPtr == &Value)
        {
            if ( TraceFlagItemTable[i].status == JVM_GLOBAL_OPTION)
                result= WriteRegistry(mg_hKey, mg_MainKey, TraceFlagItemTable[i].RegistryString, Value );

            if ( TraceFlagItemTable[i].status == JVM_LOCAL_OPTION)
                result= WriteRegistry(mg_hKey, mg_SubKey,  TraceFlagItemTable[i].RegistryString, Value );

            // (over-)write in temp. section, too:
            result= WriteRegistry(mg_hKey, mg_WorkSubKey,  TraceFlagItemTable[i].RegistryString, Value );
            break;
        }
        i++;
    }

    return result;
}


int ReadRegistry(HKEY hKey, char* SubKey, char* Name, int &result)
{
    char  szClass[20]= "\0";
    HKEY  ReadKey;
    DWORD dwDispos, Data;
    ULONG type= REG_DWORD;
    ULONG size= sizeof(DWORD) ;

    result = RegCreateKeyExA(hKey, SubKey, 0, szClass,
                   REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,
                   NULL, &ReadKey, &dwDispos);

    if ( result != NO_ERROR )  return -1;

    result = RegQueryValueExA( ReadKey, Name, 0, &type, (BYTE *) &Data, &size);
    RegCloseKey(ReadKey);
    if ( result != NO_ERROR )  return -1;

    return Data;
}

int DeleteRegistryKey(HKEY hKey, char* SubKey, char* Name, int &result)
{
    char  szClass[20]= "\0";
    HKEY  DeleteKey;
    DWORD dwDispos;
    ULONG type= REG_DWORD;
    ULONG size= sizeof(DWORD) ;

    result = RegCreateKeyExA(hKey, SubKey, 0, szClass,
                   REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS,
                   NULL, &DeleteKey, &dwDispos);

    if ( result != NO_ERROR )  return (int)result;

    result = RegDeleteValueA( DeleteKey, Name);
    RegCloseKey(DeleteKey);
    if ( result != NO_ERROR )  return (int)result;

    return (int)result;
}

/////////////////////////////////////////////////////////
// public registry functions:
//

extern "C" void AppendSimulatorRegistryPath(char *Path)
{
    if ( mg_hKey == HKEY_CURRENT_USER)
        strcat( Path, "HKEY_CURRENT_USER\\");
    else
        strcat( Path, "<?>\\");

    strcat( Path, mg_SubKey);
}


extern "C" int WriteSimulatorRegistry( char* Name, int Value)
{
    // write non-permanent:
    return WriteRegistry(mg_hKey, mg_WorkSubKey, Name, Value);      // mg_SubKey
}


extern "C" int WritePermanentSimulatorRegistry( char* Name, int Value)
{
    WriteRegistry(mg_hKey, mg_SubKey, Name, Value);
    return WriteRegistry(mg_hKey, mg_WorkSubKey, Name, Value);
}


extern "C" int ReadSimulatorRegistry( char* Name, int &result)
{
    // first try in emulator's temp. area:
    int value= ReadRegistry(mg_hKey, mg_WorkSubKey, Name, result);
    if ( result == NO_ERROR)  return value;

    // try in emulator's permanent area:
    value= ReadRegistry(mg_hKey, mg_SubKey, Name, result);
    if ( result == NO_ERROR)  return value;

    // read from global setting area:
    return ReadRegistry(mg_hKey, mg_MainKey, Name, result);
}

extern "C" int ReadSimulatorRegistryFromSubDirectory ( char* SubDir, char* Name, int &result )
{
    int value = 0;  
    char* KeyToRead = NULLP;
    
    if ( NULLP == SubDir )
    {
        KeyToRead = (char*)malloc ( strlen ( mg_SubKey ) + 1 );
        strcpy ( KeyToRead, mg_SubKey );
    }
    else
    {
        KeyToRead = (char*)malloc ( strlen ( mg_SubKey ) + strlen ( SubDir ) + 1 );
        strcpy ( KeyToRead, mg_SubKey );
        strcat ( KeyToRead, "\\" );
        strcat ( KeyToRead, SubDir );
    }
        
    value = ReadRegistry(mg_hKey, KeyToRead, Name, result);    
    free ( KeyToRead ); 
    return value;
}

extern "C" int WriteSimulatorRegistryToSubDirectory ( char* SubDir, char* Name, int Value )
{
    int result = 0; 
    char* KeyToRead = NULLP;
    
    if ( NULLP == SubDir )
    {
        KeyToRead = (char*)malloc ( strlen ( mg_SubKey ) + 1 );
        strcpy ( KeyToRead, mg_SubKey );
    }
    else
    {
        KeyToRead = (char*)malloc ( strlen ( mg_SubKey ) + strlen ( SubDir ) + 1 );
        strcpy ( KeyToRead, mg_SubKey );
        strcat ( KeyToRead, "\\" );
        strcat ( KeyToRead, SubDir );
    }
        
    result = WriteRegistry(mg_hKey, KeyToRead, Name, Value);    
    free ( KeyToRead ); 
    return result;
}

extern "C" int WriteSimulatorRegistryString( char* Name, char* Value)
{
    // write non-permanent:
    return WriteRegistryString(mg_hKey, mg_WorkSubKey, Name, Value);
}


extern "C" int WritePermanentSimulatorRegistryString( char* Name, char* Value)
{
    WriteRegistryString(mg_hKey, mg_SubKey, Name, Value);
    return WriteRegistryString(mg_hKey, mg_WorkSubKey, Name, Value);        // for read operations
}


extern "C" void ReadSimulatorRegistryString ( char* Name, char* Value, int &result)
{
    // first try in emulator's temp. area:
    ReadRegistryString (mg_hKey, mg_WorkSubKey, Name, Value, result);
    if ( result == NO_ERROR)  return;

    // try in emulator's permanent area:
    ReadRegistryString (mg_hKey, mg_SubKey, Name, Value, result);
    if ( result == NO_ERROR)  return;

    // read from global setting area:
    ReadRegistryString (mg_hKey, mg_MainKey, Name, Value, result);
}

bool getProjectPath(char* path, UINT16 strLen);

char* GetInstallPath()
{
    return mg_InstallPath;
}
extern "C" void InitSimulatorRegistry( void)
{

#ifdef JAVA_SDK

    char  szValue[JAVA_MAX_PROPERTY_LEN];
    const char *platformname = NULL;
    platformname = getSystemProperty ("microedition.platform", szValue);

    if (platformname == NULL)
        platformname = "";

    strcpy( mg_SubKey    , mg_MainKey);
    strcat( mg_SubKey    , "\\");
    strcat( mg_SubKey    , platformname);

#else if //PC_SIMU
    char projectPath[WFS_MAX_PATH]= "\0";

    strcpy( mg_SubKey    , mg_MainKey);
    strcat( mg_SubKey    , "\\");

    getProjectPath(projectPath, WFS_MAX_PATH);
    strcat( mg_SubKey , projectPath);

#endif

    strcpy( mg_WorkSubKey, mg_SubKey);
    strcat( mg_WorkSubKey, "\\current_session");            // be aware it fits into string buffer size

    // delete stale session data:
    RegDeleteKeyA( mg_hKey, mg_WorkSubKey);      // must not have subkeys!

    // make predefinitions:
    WriteRegistry( mg_hKey, mg_WorkSubKey, "debuggerActive", FALSE);    // turn off debug mode as default

#if PC_SIMU_USE_NEW_UI

    // We need a registry key to store window position or states (docking, floating etc.)

    //Change the name of the registry key.
    free((void*)GET_APP()->m_pszRegistryKey);
    //@Ba use malloc instead of _tcsdup
#ifndef _UNICODE
    GET_APP()->m_pszRegistryKey = (char*)malloc(strlen(mg_RegistryKey)+1);
    strcpy((char *) GET_APP()->m_pszRegistryKey, mg_RegistryKey );
#else
    USES_CONVERSION;
    GET_APP()->m_pszRegistryKey = (LPCTSTR)malloc(strlen(mg_RegistryKey)+1);
    wcscpy((wchar_t*)GET_APP()->m_pszRegistryKey, A2W(mg_RegistryKey));
#endif
    //Change the name of the .INI file.
    free((void*)GET_APP()->m_pszProfileName);
    //@Ba use malloc instead of _tcsdup
#ifndef _UNICODE
    GET_APP()->m_pszProfileName = (char*)malloc(1);
    strcpy( (char*)GET_APP()->m_pszProfileName, "" );
#else
    GET_APP()->m_pszProfileName = (LPCTSTR)malloc(1);
    wcscpy( (wchar_t*)GET_APP()->m_pszProfileName,_T( "") );
#endif
 
#endif //PC_SIMU_USE_NEW_UI

}

#if ENABLE_JAVA_DEBUGGER
extern "C" int debuggerPort;

extern "C" void StartStopDebugger( bool_t StartOrStop)
{
    STARTUPINFOA    StartupInfo;
    static char    JavaExe[ SKIN_PATH_LEN], *p;
    static char    StartDirectory[ SKIN_PATH_LEN], *pDir;
    static char    ClassPath[ 8*SKIN_PATH_LEN];
    static char    cmdline  [ 8*SKIN_PATH_LEN];
    unsigned long  ExitCode;
    int            result;

    debuggerActive= StartOrStop;

    if (debuggerActive == TRUE)
    {
        /*
        if ( JavaDebuggerProcessInfo.dwProcessId != 0)
            return;                                         // already started
        */

        GetStartupInfoA( &StartupInfo);

        ReadSimulatorRegistryString( "JDK_HOME", JavaExe, result);

        if (result != NO_ERROR)
            SearchPathA( NULL, "javaw", ".exe", SKIN_PATH_LEN, (char *) &JavaExe, &p);
        else
            strcat(JavaExe, "\\bin\\javaw.exe");

        // get startup directory:
        ReadSimulatorRegistryString( "INSTALL_PATH", (char*) &StartDirectory, result);

        if ( result != NO_ERROR )
        {
            debuggerActive= FALSE;
            return;
        }

        strcpy( cmdline, JavaExe);
        strcat( cmdline, " -jar \"");
#ifndef JAVA_SDK
        ReadSimulatorRegistryString( "INSTALL_PATH", cmdline + strlen(cmdline), result);
#else
        ReadRegistryString (mg_hKey, "SOFTWARE\\Siemens\\SMTK_3.X", "SMTK_ROOT_PATH", cmdline + strlen(cmdline), result);
        if ( result != NO_ERROR){
            ReadSimulatorRegistryString( "INSTALL_PATH", cmdline + strlen(cmdline), result);
        }
#endif
        strcat( cmdline, "\\bin\\kdp.jar\" -v 0 -l ");

        int nDebugProxyPort = ReadSimulatorRegistry("KJAVA_PROXY_PORT", result);
        
    if (result != NO_ERROR)
        {
            nDebugProxyPort=5500;
        }

        sprintf(cmdline,"%s %d -p -r localhost %d -cp \"", cmdline, nDebugProxyPort, debuggerPort);

        // get user class path:
        if (UserClassPath != NULL)
        {
#if MOBSIM

 //           JAM_ChangeRootPath( ClassPath, UserClassPath);
#else
            ClassPath[0]= '\0';
#endif
        }
        else
            ReadSimulatorRegistryString( "KJAVA_CLASSPATH", ClassPath, result);

        strcat( cmdline, ClassPath);

        // get java API path:
        strcat( cmdline, ";");
        ReadSimulatorRegistryString( "KJAVA_API_CLASSPATH", ClassPath, result);
        strcat( cmdline, ClassPath);
        strcat(cmdline, "\"");

        // start java debug process:
        CreateProcessA( NULLP,
            cmdline,
            NULL, NULL,                     // security attributes
            FALSE,                          // handle inheritance
            CREATE_NEW_PROCESS_GROUP,       // creation flags
            NULL,                           // pointer to new environment block
            (char *) &StartDirectory,
            &StartupInfo,
            &JavaDebuggerProcessInfo);

        if ( JavaDebuggerProcessInfo.dwProcessId == 0)
            debuggerActive= FALSE;                      // could not start process!
    }
    else
    {
        if ( JavaDebuggerProcessInfo.dwProcessId == 0)
            return;                                         // never started

        // stop java debug process:
        GetExitCodeProcess( JavaDebuggerProcessInfo.hProcess, &ExitCode);
        if (ExitCode == STILL_ACTIVE)
        {
            TerminateProcess  ( JavaDebuggerProcessInfo.hProcess, 0);

            for (int i= 0; i< 5; i++)
            {
                Sleep(100);
                GetExitCodeProcess( JavaDebuggerProcessInfo.hProcess, &ExitCode);
                if (ExitCode != STILL_ACTIVE)
                    break;
            }
        }

        if (ExitCode != STILL_ACTIVE)
        {
            CloseHandle( JavaDebuggerProcessInfo.hProcess);
            JavaDebuggerProcessInfo.dwProcessId= 0;
            JavaDebuggerProcessInfo.hProcess   = NULL;
        }
        else
            debuggerActive= TRUE;                      // could not stop process!
    }
}
#endif



//              display window private functions
//
///////////////////////////////////////////////////////////////////////////////////


static void GetOrSetInstallPath( void)
{
    int result;

    //read the install path
    ReadSimulatorRegistryString( "INSTALL_PATH", mg_InstallPath, result);
    if (result != NO_ERROR)
    {//install path not found in registry

        //create install path
        Simu_GetExeInstallPath(mg_InstallPath, SKIN_PATH_LEN);

        //write install path to registry
        WritePermanentSimulatorRegistryString( "INSTALL_PATH", mg_InstallPath);
    }

}



static void DrawBitmap(HDC hdc, HBITMAP hBitmap, int x, int y, int rop)
{
    BITMAP  bm;
    HDC     hdcMem;
    POINT   ptSize, ptOrg;
    HBITMAP tmp;

    if (hBitmap == NULL)  return;

    hdcMem = CreateCompatibleDC(hdc);
    tmp = (HBITMAP)(SelectObject(hdcMem, hBitmap));
    SetMapMode(hdcMem, GetMapMode(hdc));
    GetObject(hBitmap, sizeof(BITMAP), (LPVOID)&bm);
    ptSize.x = bm.bmWidth;
    ptSize.y = bm.bmHeight;
    DPtoLP(hdc, &ptSize, 1);

    ptOrg.x = 0;
    ptOrg.y = 0;

    DPtoLP(hdcMem, &ptOrg, 1);

    BitBlt(hdc, x, y, ptSize.x, ptSize.y,
       hdcMem, ptOrg.x, ptOrg.y, rop);

    SelectObject(hdcMem, tmp);
    DeleteDC(hdcMem);
}



extern "C" void save_act_screen(void);


void InitMTTInterface(void)
{
    int nResultCode;
    int nMTTPort;
    char *szEnvPort=NULLP;
    int nDelayTimes[MTT_NUM_DELAY_TIMES];
    int i;

    // first check environment variable
    szEnvPort= getenv (MTT_SIMU_PORT_ENV);
    if (szEnvPort != NULLP)
    {
        // set the port from the environment
        nMTTPort=atoi(szEnvPort);
    }
    else
    {
        // no environment -> check registry
        nMTTPort=ReadSimulatorRegistry(MTT_SIMU_PORT_ENV, nResultCode);
        if (nResultCode != NO_ERROR)
        {
            // no registry string set. Write the default value and use it
            WritePermanentSimulatorRegistry(MTT_SIMU_PORT_ENV, MTT_TCP_DEFAULT_PORT);

            nMTTPort=MTT_TCP_DEFAULT_PORT;
        }
    }

    // read the delay times and write them, if they are new
    for (i=0; i< MTT_NUM_DELAY_TIMES; i++)
    {
        nDelayTimes[i]=ReadSimulatorRegistry((char *)MTT_SIMU_DELAY_STRINGS[i], nResultCode);
        if (nResultCode != NO_ERROR)
        {
            nDelayTimes[i]=MTT_SIMU_DEFAULT_DELAY_TIMES[i];
            WritePermanentSimulatorRegistry((char *)MTT_SIMU_DELAY_STRINGS[i], MTT_SIMU_DEFAULT_DELAY_TIMES[i]);
        }
    }

    mtt_tcp_activate(nMTTPort, nDelayTimes);
}


extern HWND GetMMIDispHandle(void)
{
#if PC_SIMU_USE_NEW_UI
   return GET_APP()->GetMMIDispWindow()->GetHandle();
#else
   ASSERT(FALSE);
   return NULL;
#endif
}
extern "C" T_FlexShellType KeypGetFlexShellType(void)
{
    return (T_FlexShellType)mg_FlexShellType;
}

bool getProjectPath(char* path, UINT16 strLen)
{

    //example:    d:\sw\account\net\project
    enum
    {
        PCSIMU_PROJECT,    // ep55mgpc
        PCSIMU_NET,        // uen9ma
        PCSIMU_CDB,        // CDB
        //PCSIMU_SW,       // sw
        //PCSIMU_PCD_ROOT, // d:
        PCSIMU_LEVEL_NB
    };

    char  buffer[ PCSIMU_LEVEL_NB][ WFS_MAX_PATH];
    char  projectPath[WFS_MAX_PATH]= "\0";
    char  *GetStringPart;
    int   index= PCSIMU_PROJECT;

    //initialize buffers
    strcpy( buffer[ PCSIMU_PROJECT], "unknown");
    strcpy( buffer[ PCSIMU_NET],     "unknown");
    strcpy( buffer[ PCSIMU_CDB],     "unknown");
    // determine directory of the exe file
    Simu_GetExeInstallPath(projectPath, strLen);

    //separate file level strings and save strings in buffer
    while ( index < PCSIMU_LEVEL_NB)
    {
        GetStringPart = strrchr( projectPath, '\\' );

        if ( GetStringPart == NULL)
            break;

        *GetStringPart++= '\0';
        GetNextStringPart( GetStringPart, buffer[ index++], WFS_MAX_PATH);
    }

    //build project path
    _snprintf( path, strLen, "%s\\%s", buffer[PCSIMU_CDB], buffer[PCSIMU_PROJECT]); 

    return TRUE;
}



/** Toggles state bit(s) of a (debug) menu item to indicate the function is currently turned on/off */

void CMMIDispWindow::ToggleTraceItemState(int cmdnr, UINT StateBits)
{
    LPMENUITEMINFO  ItemInfo;

    ItemInfo= (LPMENUITEMINFO) malloc( sizeof(MENUITEMINFO));
    ItemInfo->cbSize = sizeof( MENUITEMINFO);
    ItemInfo->fMask = MIIM_STATE;

    // hMenuPopupDebug
    GetMenuItemInfo(hMenu, (UINT) cmdnr, FALSE, ItemInfo);
    ItemInfo->fState ^= StateBits;
    SetMenuItemInfo(hMenu, (UINT) cmdnr, FALSE, ItemInfo);

    free( ItemInfo);
}

/** Sets state bit(s) of a  menu item to indicate the function is currently turned on/off */
void CMMIDispWindow::SetMenuItemState(HMENU menu,int cmdnr, UINT StateBits)
{
    LPMENUITEMINFO  ItemInfo;

    ItemInfo= (LPMENUITEMINFO) MOPI_Alloc( sizeof(MENUITEMINFO));
    ItemInfo->cbSize = sizeof( MENUITEMINFO);
    ItemInfo->fMask = MIIM_STATE;

    GetMenuItemInfo(menu, (UINT) cmdnr, FALSE, ItemInfo);
    ItemInfo->fState = StateBits;
    SetMenuItemInfo(menu, (UINT) cmdnr, FALSE, ItemInfo);

    MOPI_Free( ItemInfo);
}


/** Sets state bit(s) of a (debug) menu item to indicate the function is currently turned on/off */

void CMMIDispWindow::SetTraceItemState(int cmdnr, UINT StateBits)
{
    LPMENUITEMINFO  ItemInfo;

    ItemInfo= (LPMENUITEMINFO) malloc( sizeof(MENUITEMINFO));
    ItemInfo->cbSize = sizeof( MENUITEMINFO);
    ItemInfo->fMask = MIIM_STATE;

    GetMenuItemInfo(hMenuPopupDebug, (UINT) cmdnr, FALSE, ItemInfo);
    ItemInfo->fState = StateBits;
    SetMenuItemInfo(hMenuPopupDebug, (UINT) cmdnr, FALSE, ItemInfo);

    free( ItemInfo);
}


void CMMIDispWindow::SetZoomItemState(int cmdnr, UINT StateBits)
{
    LPMENUITEMINFO  ItemInfo;

    ItemInfo= (LPMENUITEMINFO) malloc( sizeof(MENUITEMINFO));
    ItemInfo->cbSize = sizeof( MENUITEMINFO);
    ItemInfo->fMask = MIIM_STATE;

    GetMenuItemInfo(hMenuPopupMag, (UINT) cmdnr, FALSE, ItemInfo);
    ItemInfo->fState = StateBits;
    SetMenuItemInfo(hMenuPopupMag, (UINT) cmdnr, FALSE, ItemInfo);

    free( ItemInfo);
}


/** Debug mode:
    OFF: save values of all debug menu items
    ON : restore values of all debug menu items

*/

void CMMIDispWindow::SetTracing(int DebugMode)
{
#if INCLUDEDEBUGCODE
    if (DebugMode == TRUE)
    {
        TraceDebugger               = prv_TraceDebugger;
        TraceThreadEvents           = prv_TraceThreadEvents;
        TraceThreadsExcessive       = prv_TraceThreadsExcessive;
        TraceVerifier               = prv_TraceVerifier;
        TraceStackmaps              = prv_TraceStackmaps;
        TraceStackmapsVerbose       = prv_TraceStackmapsVerbose;
        TraceVerifierByteCodes      = prv_TraceVerifierByteCodes;
        TraceOSR                    = prv_TraceOSR;
        TraceClassLoading           = prv_TraceClassLoading;
        TraceExceptions             = prv_TraceExceptions;
        TraceGC                     = prv_TraceGC;
        TraceFinalization           = prv_TraceFinalization;
        VerboseGC                   = prv_VerboseGC;
        VerboseClassLoading         = prv_VerboseClassLoading;
        TraceBytecodes              = prv_TraceBytecodes;
        //TraceBytecodesVerbose       = prv_TraceBytecodesVerbose;
        PrintAllObjects             = prv_PrintAllObjects;
        RunFinalizationAtExit       = prv_RunFinalizationAtExit;
        PrintLoadedClasses          = prv_PrintLoadedClasses;
        PrintObjectHistogramData    = prv_PrintObjectHistogramData;
        PrintLongFrames             = prv_PrintLongFrames;
        PrintBytecodeHistogram      = prv_PrintBytecodeHistogram;
        PrintCompilation            = prv_PrintCompilation;
        PrintCompiledCode           = prv_PrintCompiledCode;
        PrintCompiledCodeAsYouGo    = prv_PrintCompiledCodeAsYouGo;
        PrintPairHistogram          = prv_PrintPairHistogram;
        TraceNativeCalls            = prv_TraceNativeCalls;
        tracenetworking             = prv_tracenetworking;
        TraceMIDP10                 = prv_TraceMIDP10;
        TraceMIDP20                 = prv_TraceMIDP20;
    }
    else
    {
        prv_TraceDebugger            = TraceDebugger;
        prv_TraceThreadEvents        = TraceThreadEvents;
        prv_TraceThreadsExcessive    = TraceThreadsExcessive;
        prv_TraceVerifier            = TraceVerifier;
        prv_TraceStackmaps           = TraceStackmaps;
        prv_TraceStackmapsVerbose    = TraceStackmapsVerbose;
        prv_TraceVerifierByteCodes   = TraceVerifierByteCodes;
        prv_TraceOSR                 = TraceOSR;
        prv_TraceClassLoading        = TraceClassLoading;
        prv_TraceExceptions          = TraceExceptions;
        prv_TraceGC                  = TraceGC;
        prv_TraceFinalization        = TraceFinalization;
        prv_VerboseGC                = VerboseGC;
        prv_VerboseClassLoading      = VerboseClassLoading;
        prv_TraceBytecodes           = TraceBytecodes;
        //prv_TraceBytecodesVerbose    = TraceBytecodesVerbose;
        prv_PrintAllObjects          = PrintAllObjects;
        prv_RunFinalizationAtExit    = RunFinalizationAtExit;
        prv_PrintLoadedClasses       = PrintLoadedClasses;
        prv_PrintObjectHistogramData = PrintObjectHistogramData;
        prv_PrintLongFrames          = PrintLongFrames;
        prv_PrintBytecodeHistogram   = PrintBytecodeHistogram;
        prv_PrintCompilation         = PrintCompilation;
        prv_PrintCompiledCode        = PrintCompiledCode;
        prv_PrintCompiledCodeAsYouGo = PrintCompiledCodeAsYouGo;
        prv_PrintPairHistogram       = PrintPairHistogram;
        prv_TraceNativeCalls         = TraceNativeCalls;
        prv_tracenetworking          = tracenetworking;
        prv_TraceMIDP10              = TraceMIDP10;
        prv_TraceMIDP20              = TraceMIDP20;

        TraceDebugger            = FALSE;
        TraceThreadEvents        = FALSE;
        TraceThreadsExcessive    = FALSE;
        TraceVerifier            = FALSE;
        TraceStackmaps           = FALSE;
        TraceStackmapsVerbose    = FALSE;
        TraceVerifierByteCodes   = FALSE;
        TraceOSR                 = FALSE;
        TraceClassLoading        = FALSE;
        TraceExceptions          = FALSE;
        TraceGC                  = FALSE;
        TraceFinalization        = FALSE;
        VerboseGC                = FALSE;
        VerboseClassLoading      = FALSE;
        TraceBytecodes           = FALSE;
        //TraceBytecodesVerbose    = FALSE;
        PrintAllObjects          = FALSE;
        RunFinalizationAtExit    = TRUE;
        PrintLoadedClasses       = FALSE;
        PrintObjectHistogramData = FALSE;
        PrintLongFrames          = FALSE;
        PrintBytecodeHistogram   = FALSE;
        PrintCompilation         = FALSE;
        PrintCompiledCode        = FALSE;
        PrintCompiledCodeAsYouGo = FALSE;
        PrintPairHistogram       = FALSE;
        TraceNativeCalls         = FALSE;
        tracenetworking          = FALSE;
    }
#endif // INCLUDEDEBUGCODE
}


/** Debug mode:
    OFF: set all debug menu items invisible, save values and set to "FALSE"
    ON : set all debug menu items visible, restore values
*/
void CMMIDispWindow::EventToggleDebugging(void)
{
#if INCLUDEDEBUGCODE
    mg_Tracing^= TRUE;
    SetTracing(mg_Tracing);
    SetAllTraceItemState();
#endif
}

#ifndef LOCALIZATION_SUPPORT
HMENU CMMIDispWindow::buildSkinsMenu()
{
#ifndef JAVA_SDK
    char             SearchExt[ SKIN_PATH_LEN], name[ SKIN_PATH_LEN], *addr;
    HANDLE           fileHandle;
    WIN32_FIND_DATA  findData;
#endif

    hMenu           = CreateMenu();
#ifndef JAVA_SDK
    hMenuPopupPhones= CreateMenu();
#endif
    hMenuPopupHelp  = CreateMenu();
    hMenuPopupMag   = CreateMenu();
    
#ifndef JAVA_SDK
    hMenuPopupDebug = CreateMenu();
    hMenuPopupTrace = CreateMenu();
    hMenuPopupMode  = CreateMenu();
#endif

    hMenuPopupTools = CreateMenu();
    hMenuView       = CreateMenu();
    hMenuMainDisp   = CreateMenu();
//remove Clamp Shell Display menu
//    hMenuCSDisp     = CreateMenu();
#ifndef JAVA_SDK
    AppendMenu(hMenu, MF_POPUP, (UINT)hMenuPopupPhones, _T("Phone"));
#endif
    AppendMenu(hMenu, MF_POPUP, (UINT)hMenuPopupMag   , _T("Zoom"));

//#if INCLUDEDEBUGCODE		//Enabling debugging/tracing menu option
#ifndef JAVA_SDK
    AppendMenu(hMenu, MF_POPUP, (UINT)hMenuPopupDebug, _T("Debugging/Tracing"));
#endif
//#endif			//Enabling debugging/tracing menu option
    AppendMenu(hMenu, MF_POPUP, (UINT)hMenuPopupTools, _T("Tools"));  //Appends the menu item in to main menu
    AppendMenu(hMenu, MF_POPUP, (UINT)hMenuView , _T("View"));
    AppendMenu(hMenu, MF_POPUP, (UINT)hMenuPopupHelp , _T("Help"));

#ifndef JAVA_SDK
    char *ptrOld;
    char *ptrNew;

    // get path of the skin bitmaps
    if(!Simu_GetFilePath( SearchExt, "*.skn", "", True))
    {
        char  msg[ 512];
        strcat( msg, "Skins could not be found in the\nINSTALL_PATH directory root.");
        info_message(   msg, "Skin Build error" );
    }

    // build the skin directory path
    memcpy(SkinDir, SearchExt, sizeof(SearchExt));
    ptrOld = SkinDir;
    ptrNew = (char*) strrchr( (char*) ptrOld, '\\' );
    *ptrNew = '\0';
#else
    sprintf( SkinDir  , "%s\\bin\\%s"   , mg_InstallPath, SkinSubDir);
#endif

#ifndef JAVA_SDK                                    // in official version, hide ability of skin change:

    fileHandle = FindFirstFile( SearchExt, &findData);

    if (fileHandle == INVALID_HANDLE_VALUE)
    {
        // switch to developer path mode:
        sprintf( SkinDir  , "%s\\%s"   , mg_InstallPath, SkinSubDir);
        sprintf( SearchExt, "%s\\*.skn", SkinDir);
        fileHandle = FindFirstFile( SearchExt, &findData);
    }

    if (fileHandle != INVALID_HANDLE_VALUE)
    {
        print_d("Found skins in %s\n", SkinDir);
        do
        {
            skins[numSkins] = (char*) malloc( SKIN_PATH_LEN);
            GetFullPathName(findData.cFileName, SKIN_PATH_LEN, skins[numSkins], &addr);
            strcpy( name, addr);
            strcpy(skins[numSkins], addr);

            /* remove the .skn extension */
            name[strlen(name) - 4] = '\0';
            print_d("    %s\n", name);

            // we have to start from 1, because MFC does not support ID=0 for menus !!!!
            AppendMenu(hMenuPopupPhones, MF_STRING | MF_ENABLED, ++numSkins, name);
            if (numSkins > NUM_SKINS_SUPPORTED -1)   break;
        } while (FindNextFile(fileHandle, &findData));
        AppendMenu(hMenuPopupPhones, MF_SEPARATOR, 0, 0);
        skins[numSkins] = (char*) malloc( SKIN_PATH_LEN);
        strcpy( skins[numSkins], "no skin");
        AppendMenu(hMenuPopupPhones, MF_STRING | MF_ENABLED, ++numSkins,_T( "Hide Skin"));
    }
    FindClose(fileHandle);

    AppendMenu(hMenuPopupPhones, MF_SEPARATOR, 0, 0);
#else              // ifndef JAVA_SDK
    ++numSkins;
    AppendMenu(hMenuPopupPhones, MF_STRING | MF_ENABLED | MF_UNCHECKED,ID_DISPLAY_ONLY ,_T( "Hide Skin"));
    AppendMenu(hMenuPopupPhones, MF_SEPARATOR, 0, 0);
#endif

#if DPLDRV_COLOR_TYPE != DPLDRV_COLOR_TYPE_BLACK_WHITE
#ifndef JAVA_SDK
    AppendMenu(hMenuPopupPhones, MF_STRING | MF_ENABLED | MF_UNCHECKED, ID_REAL_COLOR,_T( "LCD colors"));
#endif
    if ( RealColors)
        ToggleTraceItemState( ID_REAL_COLOR, MF_CHECKED);
#endif

// Disable menu item 100%,by Fang Yun chao
if(mg_Magnification==1)
{
    AppendMenu(hMenuMainDisp, MF_STRING | MF_DISABLED|MF_CHECKED, ID_MAGNIFY_1,_T( "100%"));
    AppendMenu(hMenuMainDisp, MF_STRING | MF_ENABLED|MF_UNCHECKED, ID_MAGNIFY_2, _T("200%"));
    }
else
{
    AppendMenu(hMenuMainDisp, MF_STRING | MF_ENABLED|MF_UNCHECKED, ID_MAGNIFY_1,_T( "100%"));
    AppendMenu(hMenuMainDisp, MF_STRING | MF_DISABLED|MF_CHECKED, ID_MAGNIFY_2, _T("200%"));
}


#ifndef JAVA_SDK
    AppendMenu(hMenuMainDisp, MF_STRING | MF_ENABLED, ID_MAGNIFY_3, _T("300%"));
    AppendMenu(hMenuMainDisp, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuMainDisp, MF_STRING | MF_ENABLED, ID_MAGNIFY_5, _T("500%"));
    AppendMenu(hMenuMainDisp, MF_STRING | MF_ENABLED, ID_MAGNIFY_8,_T("800%"));
#endif

//remove Clamp Shell Display menu

/*  AppendMenu(hMenuCSDisp, MF_STRING | MF_ENABLED, ID_MAGNIFY_CS_1,_T( "100%"));
    AppendMenu(hMenuCSDisp, MF_STRING | MF_ENABLED, ID_MAGNIFY_CS_2,_T( "200%"));
    AppendMenu(hMenuCSDisp, MF_STRING | MF_ENABLED, ID_MAGNIFY_CS_3,_T( "300%"));
*/
    AppendMenu(hMenuPopupMag, MF_POPUP, (UINT)hMenuMainDisp,_T("Main Display"));
//    AppendMenu(hMenuPopupMag, MF_POPUP, (UINT)hMenuCSDisp,_T("Clamp Shell Display"));

//#if INCLUDEDEBUGCODE			//Enabling debugging/tracing menu option
#ifndef JAVA_SDK
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_DEBUGGER,          _T( "Java debugger support"));
    AppendMenu(hMenuPopupTrace, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_CLASSLOADING,      _T( "Print a line when a class is loaded"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_VERBOSECLASSLOADING, _T("Print user-level class loading information"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTLOADEDCLASSES, _T("Print class information after class loading"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_VERIFIER,          _T( "Trace class file verification"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_VERIFIERBYTECODES,  _T("Trace bytecodes during verification"));
    AppendMenu(hMenuPopupTrace, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_STACKMAPS,          _T("Trace stack map generation"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_STACKMAPSVERBOSE,   _T("Trace stack map generation verbose"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_OSR,                _T("Trace on-stack-replacements"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_EXCEPTIONS,         _T("Trace exception throwing (with stack traces)"));
    AppendMenu(hMenuPopupTrace, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_GC,               _T(  "Verbose trace of GC"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_VERBOSEGC,         _T( "Print user-level GC information"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_FINALIZATION,       _T("Verbose trace of finalization behavior"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTALLOBJECTS,    _T("Print all object by iterating over the object heap"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_DISABLED, ID_TRACE_RUNFINALIZATIONATEXIT, _T("Run all finalizers when JVM terminates"));
    AppendMenu(hMenuPopupTrace, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_THREADEVENTS,      _T( "Trace thread events"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_THREADSEXCESSIVE,   _T("Trace thread events excessive"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTLONGFRAMES,    _T("Print locals and expression stack when printing frames"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTCOMPILATION,   _T("Prints a line for each compiled method"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTCOMPILEDCODE,  _T("Prints the native code for all compiled methods"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTCOMPILEDCODEASYOUGO, _T("Prints the native code for all compiled methods"));
    AppendMenu(hMenuPopupTrace, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTOBJECTHISTOGRAMDATA,_T( "Print a log for computing the object histogram"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTBYTECODEHISTOGRAM,_T( "Prints a histogram of the executed bytecodes"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTPAIRHISTOGRAM, _T("Prints a histogram of the executed bytecode pairs"));
    AppendMenu(hMenuPopupTrace, MF_SEPARATOR, 0, 0);
    //AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_BYTECODES,         _T( "Generate interpreter that traces bytecodes"));
    //AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_BYTECODESVERBOSE,  _T( "Generate interpreter that traces bytecodes verbose"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_NATIVECALLS, _T("Trace native methods enter and exit"));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_NETWORKING, _T("Trace Networking"));
    AppendMenu(hMenuPopupDebug, MF_CHECKED | MF_STRING | MF_ENABLED, ID_DEBUGGER_ACTIVE,_T( "Debug Java Application"));
    AppendMenu(hMenuPopupDebug, MF_CHECKED | MF_STRING | MF_ENABLED, ID_SHOW_ERRORS    , _T("Show Error Messages"));
    AppendMenu(hMenuPopupDebug, MF_CHECKED | MF_STRING | MF_ENABLED, ID_SHOW_INFOS     , _T("Show Info Messages"));
    AppendMenu(hMenuPopupDebug, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPopupDebug, MF_CHECKED | MF_STRING | MF_ENABLED, ID_TRACE1,_T ("Turn Trace Options on"));
    AppendMenu(hMenuPopupDebug, MF_STRING  | MF_ENABLED| MF_POPUP, (UINT) hMenuPopupTrace,_T( "Trace Options"));
    AppendMenu(hMenuPopupDebug, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPopupMode,  MF_CHECKED | MF_STRING | MF_ENABLED, ID_MODE_ALARM, _T( "Alarm Mode"));
    AppendMenu(hMenuPopupMode,  MF_CHECKED | MF_STRING | MF_ENABLED, ID_MODE_CHARGE, _T("Charge Mode"));
    AppendMenu(hMenuPopupMode,  MF_CHECKED | MF_STRING | MF_ENABLED, ID_MODE_NORMAL, _T("Normal Mode"));
    AppendMenu(hMenuPopupDebug, MF_STRING  | MF_ENABLED| MF_POPUP, (UINT) hMenuPopupMode, _T("Mode at next startup"));
#endif  
//#endif			//Enabling debugging/tracing menu option

    AppendMenu(hMenuPopupTools, MF_STRING, ID_TOOLS_OPTIONS , _T("Options"));

    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, ID_VIEW_PHONESCREEN,_T( "Mobile Phone Screen"));
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, ID_VIEW_MMICOMMANDS, _T("MMI Commands"));
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, ID_VIEW_OUTPUTWND, _T("Output Window"));
//    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, ID_VIEW_CLAMPSHELL, _T("Clamp Shell Screen"));
    AppendMenu(hMenuView, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, IDR_MAINFRAME  ,    _T( "SoftKey Toolbar"));
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, IDR_FLEXSHELL ,      _T("Flexshell Toolbar"));
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, IDR_DOCKING_WINDOWS ,_T("Window Toolbar"));
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, ID_INDICATOR_MEM ,   _T("Status Bar"));
    AppendMenu(hMenuView, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuView,  MF_STRING | MF_ENABLED, ID_SHOW_SHAPED_UI , _T("Shaped UI"));


/*  remove the contents of search related from the new request of Help Menu.       
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_GRAYED, ID_SEARCH , _T("Search..."));
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_GRAYED, ID_CONTENT, _T("Content"));
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_GRAYED, ID_INDEX  ,_T("Index"));
    AppendMenu(hMenuPopupHelp, MF_SEPARATOR, 0, 0);
*/
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_ENABLED, ID_USERMANUAL ,_T( "User's Manual"));
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_ENABLED, ID_ABOUT ,_T( "About"));
 
    return hMenu;
}
HMENU CMMIDispWindow::buildSkinsPopMenu()
{
    hMenuPop         = CreatePopupMenu();
    hMenuFile       = CreateMenu();
    hMenuView       = CreateMenu();
    hMenuPopupHelp   = CreateMenu();
    hMenuCommand    = CreateMenu();
    hMenuZoom       = CreateMenu();
    hMenuPhone      = CreateMenu();
    hMenuNetworkSimu       = CreateMenu(); /* Network Simulation */
    hMenuPhoneSimu    = CreateMenu(); /* Phone Simulation */
    hMenuPopupTools = CreateMenu();   /*tools, add by sunmin*/
    
    //AppendMenu(hMenuPop, MF_POPUP, (UINT)hMenuFile, "File");
    AppendMenu(hMenuPop, MF_POPUP, (UINT)hMenuView , _T("View"));
    AppendMenu(hMenuPop, MF_POPUP, (UINT)hMenuNetworkSimu , _T("NetWork Commands"));
    AppendMenu(hMenuPop, MF_POPUP, (UINT)hMenuPhoneSimu , _T("Phone Commands"));
    AppendMenu(hMenuPop, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPop, MF_POPUP, (UINT)hMenuPopupTools,_T( "Tools")); /*add tools->option menu to shaped UI, by Sun Min*/
    AppendMenu(hMenuPop, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPop, MF_POPUP, (UINT)hMenuPopupHelp , _T("Help"));
    AppendMenu(hMenuPop, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPop, MF_STRING | MF_ENABLED,ID_CLOSE_ENTIR_PROGRAM , _T("Exit (Alt + F4)"));


    AppendMenu(hMenuFile, MF_STRING | MF_ENABLED, ID_START_JAVA_APP, _T("Start Java Application"));
    AppendMenu(hMenuFile, MF_STRING | MF_ENABLED,NULL , _T("Switch Off Phone (long press F4)"));
    AppendMenu(hMenuFile, MF_SEPARATOR, 0, 0);

    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, ID_GOTO_DOCKED_WIN, _T("Multi Document View"));
    AppendMenu(hMenuView, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED | MF_UNCHECKED ,ID_MAIN_MENU,_T( "Main Menu"));
   
    if(m_iFlexShellType==FLEXSHELL_ROTATOR)
    {
        AppendMenu(hMenuView, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuView,MF_STRING | MF_ENABLED | MF_UNCHECKED ,ID_FLEXSHELL_CLOSE,_T("Close Flexshell"));
// Change flex shell initial status to "open" by Fang Yun chao
    AppendMenu(hMenuView,MF_STRING | MF_DISABLED | MF_CHECKED ,ID_FLEXSHELL_OPEN,_T("Open Flexshell"));
    AppendMenu(hMenuView,MF_STRING | MF_GRAYED | MF_UNCHECKED ,ID_FLEXSHELL_MIDDLE,_T("Middle Flexshell"));
    }
    
    AppendMenu(hMenuView, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED | MF_UNCHECKED , ID_DISPLAY_ONLY, _T("Hide Skin"));
    AppendMenu(hMenuView, MF_SEPARATOR, 0, 0);

if(mg_Magnification==1) 
{
    AppendMenu(hMenuView, MF_STRING | MF_DISABLED | MF_CHECKED,ID_MAGNIFY_1, _T("100%"));
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED | MF_UNCHECKED, ID_MAGNIFY_2, _T("200%"));
    }
   else
{
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED | MF_UNCHECKED,ID_MAGNIFY_1, _T("100%"));
    AppendMenu(hMenuView, MF_STRING | MF_DISABLED | MF_CHECKED, ID_MAGNIFY_2, _T("200%"));
}
  

#if 0

#if DPLDRV_COLOR_TYPE != DPLDRV_COLOR_TYPE_BLACK_WHITE
    AppendMenu(hMenuPhone, MF_STRING | MF_ENABLED | MF_UNCHECKED, ID_REAL_COLOR, _T("LCD colors"));

    if ( RealColors)
        ToggleTraceItemState( ID_REAL_COLOR, MF_CHECKED);
#endif
    AppendMenu(hMenuPhone, MF_SEPARATOR, 0, 0);

    char *ptrOld;
    char *ptrNew;

    // get path of the skin bitmaps
    if(!Simu_GetFilePath( SearchExt, "*.skn", "", True))
    {
        char  msg[ 512];
        strcat( msg, "Skins could not be found in the\nINSTALL_PATH directory root.");
        info_message(   msg, "Skin Build error" );
    }

    // build the skin directory path
    memcpy(SkinDir, SearchExt, sizeof(SearchExt));
    ptrOld = SkinDir;
    ptrNew = (char*) strrchr( (char*) ptrOld, '\\' );
    *ptrNew = '\0';


    fileHandle = FindFirstFile( SearchExt, &findData);

    if (fileHandle == INVALID_HANDLE_VALUE)
    {
        // switch to developer path mode:
        sprintf( SkinDir  , "%s\\%s"   , mg_InstallPath, SkinSubDir);
        sprintf( SearchExt, "%s\\*.skn", SkinDir);
        fileHandle = FindFirstFile( SearchExt, &findData);
    }

    if (fileHandle != INVALID_HANDLE_VALUE)
    {
        print_d("Found skins in %s\n", SkinDir);
        do
        {
            skins[numSkins] = (char*) malloc( SKIN_PATH_LEN);
            GetFullPathName(findData.cFileName, SKIN_PATH_LEN, skins[numSkins], &addr);
            strcpy( name, addr);
            strcpy(skins[numSkins], addr);

            /* remove the .skn extension */
            name[strlen(name) - 4] = '\0';
            print_d("    %s\n", name);

            // we have to start from 1, because MFC does not support ID=0 for menus !!!!
            AppendMenu(hMenuPhone, MF_STRING | MF_ENABLED | MF_UNCHECKED, ++numSkins, name);

            if (numSkins > NUM_SKINS_SUPPORTED -1)   break;
        } while (FindNextFile(fileHandle, &findData));

        AppendMenu(hMenuPhone, MF_SEPARATOR, 0, 0);
        skins[numSkins] = (char*) malloc( SKIN_PATH_LEN);
        strcpy( skins[numSkins], "no skin");
        AppendMenu(hMenuPhone, MF_STRING | MF_ENABLED | MF_UNCHECKED, ++numSkins, _T("hide skin"));
    }
    FindClose(fileHandle);

#endif // end 0

 


//Incoming Call//
    AppendMenu(hMenuCommand, MF_POPUP, (UINT)hMenuNetworkSimu, _T("Network Simulation"));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_ENABLED, ID_MOBILE_TERMINATING_CALL, _T("Mobile Terminating Call"));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_ENABLED, ID_DISCONNECT_CALL_BY_NET, _T("Disconnect Call by Net"));
#if 0
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_GRAYED, NULL, _T("IInterrupt Call (Reest.Proc)"));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_GRAYED, NULL,_T( "Insert Mobile in Carkit-high"));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_GRAYED, NULL, _T("Remove Mobile from Carkit-high"));
#endif

//Net Service//
    AppendMenu(hMenuNetworkSimu, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_ENABLED, ID_FULL_SERVICE,_T( "Full Service"));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_ENABLED, ID_NO_SERVICE, _T("No Service"));

//SMS//
    AppendMenu(hMenuNetworkSimu, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_ENABLED, ID_INCOMING_SHORT_MESSAGE, _T("Incoming Short Message"));
#if 0
    //AppendMenu(hMenuSMS, MF_STRING | MF_GRAYED, NULL, "Immediate Message");
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_GRAYED, NULL, _T("Status Report"));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_GRAYED, NULL, _T("Toggle Voice Message"));
#endif
//MOC//
#if 0
    AppendMenu(hMenuCommand, MF_POPUP, (UINT)hMenuMOC, "MOC");
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_GRAYED, NULL,_T( "Disconnect Progress is off,-> on"));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_GRAYED, NULL, _T("Release With ""busy"" is off,-> on"));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_GRAYED, NULL,_T( "CCBS isn't supported, -> on"));
    AppendMenu(hMenuCommand, MF_SEPARATOR, 0, 0);
#endif

//EMS//
    AppendMenu(hMenuNetworkSimu, MF_SEPARATOR, 0, 0);  
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_ENABLED, ID_BUILD_SHORT_MESSAGE,_T( "Build Incoming Short Message"));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_ENABLED, ID_SEND_NEXT_SEGMENT_EMS_MESSAGE, _T("Send next Segment of EMS Message"));

//Net Selection//
    AppendMenu(hMenuNetworkSimu, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_ENABLED, ID_CHOOSE_NETWORK, _T("Choose NetWork"));

    AppendMenu(hMenuCommand, MF_POPUP, (UINT)hMenuPhoneSimu, _T("Phone Simulation"));
   
    AppendMenu(hMenuPhoneSimu, MF_STRING | MF_ENABLED, ID_START_JAVA_APP, _T("Start Java Application"));

//2004-11-04 Sun Min: delete this unused menu item
//  AppendMenu(hMenuPhoneSimu, MF_STRING | MF_ENABLED, ID_SHOW_RUN_TIME_HEAP, _T("Show Run Time Heap Info"));

//Power//
    AppendMenu(hMenuPhoneSimu, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPhoneSimu, MF_STRING | MF_ENABLED, ID_BEGIN_LOW_POWER, _T("Begin Low Power"));
    AppendMenu(hMenuPhoneSimu, MF_STRING | MF_ENABLED, ID_END_LOW_POWER, _T("End Low Power"));

    //AppendMenu(hMenuPhoneSimu, MF_SEPARATOR, 0, 0);
    //AppendMenu(hMenuPhoneSimu, MF_STRING | MF_ENABLED, ID_CHANGE_MICROEDITION_LOCALE, "Change Microedition.locale");
    
    // AppendMenu(hMenuPhoneSimu, MF_SEPARATOR, 0, 0);
    //AppendMenu(hMenuPhoneSimu, MF_STRING | MF_ENABLED, ID_SEND_FREE_SPACE_NOTIFICATION, "Send 'Free Space' Notification");
    //AppendMenu(hMenuPhoneSimu, MF_STRING | MF_ENABLED, ID_SEND_NO_FREE_SPACE_NOTIFICATION, "Send 'Free Space' Notification");

    AppendMenu(hMenuPhoneSimu, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPhoneSimu, MF_STRING | MF_ENABLED,ID_SWITCH_OFF ,_T( "Switch Off"));

//HZ//
#if 0
    AppendMenu(hMenuCommand, MF_STRING | MF_GRAYED, NULL, _T("Homezone: off -> on"));
#endif

//Tools: add tools-options menu to shaped UI, by Sun Min//
    AppendMenu(hMenuPopupTools, MF_STRING, ID_TOOLS_OPTIONS , _T("Options"));   
//add SMTK Tool Utilities menu item to shaped UI, by Sun Min//
    AppendMenu(hMenuPopupTools, MF_STRING, ID_SMTK_TOOL , "SMTK Tool Utilities");   


//Help// 

/*  remove the contents of search related from the new request of Help Menu.       
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_GRAYED, ID_SEARCH ,_T( "Search..."));
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_GRAYED, ID_CONTENT, _T("Content"));
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_GRAYED, ID_INDEX  , _T("Index"));
    AppendMenu(hMenuPopupHelp, MF_SEPARATOR, 0, 0);
*/
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_ENABLED, ID_USERMANUAL ,_T( "User's Manual"));
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_ENABLED, ID_ABOUT , _T("About"));



    return hMenuPop;

}


#else
HMENU CMMIDispWindow::buildSkinsMenu()
{
#ifndef JAVA_SDK
    char             SearchExt[ SKIN_PATH_LEN], name[ SKIN_PATH_LEN], *addr;
    HANDLE           fileHandle;
    WIN32_FIND_DATA  findData;
#endif

    hMenu           = CreateMenu();
#ifndef JAVA_SDK
    hMenuPopupPhones= CreateMenu();
#endif
    hMenuPopupHelp  = CreateMenu();
    hMenuPopupMag   = CreateMenu();

#ifndef JAVA_SDK
    hMenuPopupDebug = CreateMenu();
    hMenuPopupTrace = CreateMenu();
    hMenuPopupMode  = CreateMenu();
#endif

    hMenuPopupTools = CreateMenu();
    hMenuView       = CreateMenu();
    hMenuMainDisp   = CreateMenu();
//remove Clamp Shell Display menu
//    hMenuCSDisp     = CreateMenu();
#ifndef JAVA_SDK
    AppendMenu(hMenu, MF_POPUP, (UINT)hMenuPopupPhones, CLocalizationString(IDS_MENU_PHONE));
#endif

    AppendMenu(hMenu, MF_POPUP, (UINT)hMenuPopupMag   , CLocalizationString(IDS_MENU_ZOOM));

#if INCLUDEDEBUGCODE
    AppendMenu(hMenu, MF_POPUP, (UINT)hMenuPopupDebug, CLocalizationString(IDS_MENU_DEBUG_TRACING));
#endif
    AppendMenu(hMenu, MF_POPUP, (UINT)hMenuPopupTools, CLocalizationString(IDS_MENU_TOOLS));  //Appends the menu item in to main menu
    AppendMenu(hMenu, MF_POPUP, (UINT)hMenuView , CLocalizationString(IDS_MENU_VIEW));
    AppendMenu(hMenu, MF_POPUP, (UINT)hMenuPopupHelp , CLocalizationString(IDS_MENU_HELP));

#ifndef JAVA_SDK
    char *ptrOld;
    char *ptrNew;
    
    numSkins = 0;
    // get path of the skin bitmaps
    if(!Simu_GetFilePath( SearchExt, "*.skn", "", True))
    {
        char  msg[ 512];
        strcat( msg, "Skins could not be found in the\nINSTALL_PATH directory root.");
        info_message(   msg, "Skin Build error" );
    }

    // build the skin directory path
    memcpy(SkinDir, SearchExt, sizeof(SearchExt));
    ptrOld = SkinDir;
    ptrNew = (char*) strrchr( (char*) ptrOld, '\\' );
    *ptrNew = '\0';
#else
    sprintf( SkinDir  , "%s\\bin\\%s"   , mg_InstallPath, SkinSubDir);
#endif

#ifndef JAVA_SDK                                    // in official version, hide ability of skin change:

    fileHandle = FindFirstFile( SearchExt, &findData);

    if (fileHandle == INVALID_HANDLE_VALUE)
    {
        // switch to developer path mode:
        sprintf( SkinDir  , "%s\\%s"   , mg_InstallPath, SkinSubDir);
        sprintf( SearchExt, "%s\\*.skn", SkinDir);
        fileHandle = FindFirstFile( SearchExt, &findData);
    }

    if (fileHandle != INVALID_HANDLE_VALUE)
    {
        print_d("Found skins in %s\n", SkinDir);
        do
        {
            skins[numSkins] = (char*) malloc( SKIN_PATH_LEN);
            GetFullPathName(findData.cFileName, SKIN_PATH_LEN, skins[numSkins], &addr);
            strcpy( name, addr);
            strcpy(skins[numSkins], addr);

            /* remove the .skn extension */
            name[strlen(name) - 4] = '\0';
            print_d("    %s\n", name);

            // we have to start from 1, because MFC does not support ID=0 for menus !!!!
            AppendMenu(hMenuPopupPhones, MF_STRING | MF_ENABLED, ++numSkins, name);

            if (numSkins > NUM_SKINS_SUPPORTED -1)   break;
        } while (FindNextFile(fileHandle, &findData));

        AppendMenu(hMenuPopupPhones, MF_SEPARATOR, 0, 0);
        skins[numSkins] = (char*) malloc( SKIN_PATH_LEN);
        strcpy( skins[numSkins], "no skin");
        AppendMenu(hMenuPopupPhones, MF_STRING | MF_ENABLED, ++numSkins, CLocalizationString(IDS_MENU_HIDESKIN));
    }
    FindClose(fileHandle);

    AppendMenu(hMenuPopupPhones, MF_SEPARATOR, 0, 0);
#endif              // ifndef JAVA_SDK

#if DPLDRV_COLOR_TYPE != DPLDRV_COLOR_TYPE_BLACK_WHITE
#ifndef JAVA_SDK
    AppendMenu(hMenuPopupPhones, MF_STRING | MF_ENABLED | MF_UNCHECKED, ID_REAL_COLOR, CLocalizationString(IDS_MENU_REAL_COLOR));
#endif

    if ( RealColors)
        ToggleTraceItemState( ID_REAL_COLOR, MF_CHECKED);
#endif

// Change flex shell initial status to "Open" by Fang Yunchao
    AppendMenu(hMenuMainDisp, MF_STRING | MF_DISABLED|MF_CHECKED, ID_MAGNIFY_1, CLocalizationString(IDS_MENU_MAGNIFY_1));
  //  if(m_iFlexShellType==FLEXSHELL_ROTATOR)
  //  {
     //   AppendMenu(hMenuMainDisp, MF_STRING |  MF_GRAYED, ID_MAGNIFY_2, CLocalizationString(IDS_MENU_MAGNIFY_2));
   // }
  //  else
  //  {
    AppendMenu(hMenuMainDisp, MF_STRING | MF_ENABLED|MF_UNCHECKED, ID_MAGNIFY_2, CLocalizationString(IDS_MENU_MAGNIFY_2));
   // }

#ifndef JAVA_SDK
    AppendMenu(hMenuMainDisp, MF_STRING | MF_ENABLED, ID_MAGNIFY_3, CLocalizationString(IDS_MENU_MAGNIFY_3));
    AppendMenu(hMenuMainDisp, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuMainDisp, MF_STRING | MF_ENABLED, ID_MAGNIFY_5, CLocalizationString(IDS_MENU_MAGNIFY_5));
    AppendMenu(hMenuMainDisp, MF_STRING | MF_ENABLED, ID_MAGNIFY_8, CLocalizationString(IDS_MENU_MAGNIFY_8));
#endif

//remove Clamp Shell Display menu
/*
    AppendMenu(hMenuCSDisp, MF_STRING | MF_ENABLED, ID_MAGNIFY_CS_1, CLocalizationString(IDS_MENU_MAGNIFY_1));
    AppendMenu(hMenuCSDisp, MF_STRING | MF_ENABLED, ID_MAGNIFY_CS_2, CLocalizationString(IDS_MENU_MAGNIFY_2));
    AppendMenu(hMenuCSDisp, MF_STRING | MF_ENABLED, ID_MAGNIFY_CS_3, CLocalizationString(IDS_MENU_MAGNIFY_3));
*/
    AppendMenu(hMenuPopupMag, MF_POPUP, (UINT)hMenuMainDisp, CLocalizationString(IDS_MENU_MAIN_DISPLAY));
//    AppendMenu(hMenuPopupMag, MF_POPUP, (UINT)hMenuCSDisp,   CLocalizationString(IDS_MENU_CS_DISPLAY));

#if INCLUDEDEBUGCODE
#ifndef JAVA_SDK
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_DEBUGGER,           CLocalizationString(IDS_MENU_TRACE_DEBUGGER));
    AppendMenu(hMenuPopupTrace, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_CLASSLOADING,       CLocalizationString(IDS_MENU_TRACE_CLASSLOADING));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_VERBOSECLASSLOADING, CLocalizationString(IDS_MENU_TRACE_VERBOSECLASSLOADING));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTLOADEDCLASSES, CLocalizationString(IDS_MENU_TRACE_PRINTLOADEDCLASSES));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_VERIFIER,           CLocalizationString(IDS_MENU_TRACE_VERIFIER));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_VERIFIERBYTECODES,  CLocalizationString(IDS_MENU_TRACE_VERIFIERBYTECODES));
    AppendMenu(hMenuPopupTrace, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_STACKMAPS,          CLocalizationString(IDS_MENU_TRACE_STACKMAPS));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_STACKMAPSVERBOSE,   CLocalizationString(IDS_MENU_TRACE_STACKMAPSVERBOSE));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_OSR,                CLocalizationString(IDS_MENU_TRACE_OSR));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_EXCEPTIONS,         CLocalizationString(IDS_MENU_TRACE_EXCEPTIONS));
    AppendMenu(hMenuPopupTrace, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_GC,                 CLocalizationString(IDS_MENU_TRACE_GC));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_VERBOSEGC,          CLocalizationString(IDS_MENU_TRACE_VERBOSEGC));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_FINALIZATION,       CLocalizationString(IDS_MENU_TRACE_FINALIZATION));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTALLOBJECTS,    CLocalizationString(IDS_MENU_TRACE_PRINTALLOBJECTS));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_DISABLED, ID_TRACE_RUNFINALIZATIONATEXIT, CLocalizationString(IDS_MENU_TRACE_RUNFINALIZATIONATEXIT));
    AppendMenu(hMenuPopupTrace, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_THREADEVENTS,       CLocalizationString(IDS_MENU_TRACE_THREADEVENTS));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_THREADSEXCESSIVE,   CLocalizationString(IDS_MENU_TRACE_THREADSEXCESSIVE));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTLONGFRAMES,    CLocalizationString(IDS_MENU_TRACE_PRINTLONGFRAMES));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTCOMPILATION,   CLocalizationString(IDS_MENU_TRACE_PRINTCOMPILATION));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTCOMPILEDCODE,  CLocalizationString(IDS_MENU_TRACE_PRINTCOMPILEDCODE));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTCOMPILEDCODEASYOUGO, CLocalizationString(IDS_MENU_TRACE_PRINTCOMPILEDCODEASYOUGO));
    AppendMenu(hMenuPopupTrace, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTOBJECTHISTOGRAMDATA, CLocalizationString(IDS_MENU_TRACE_PRINTOBJECTHISTOGRAMDATA));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTBYTECODEHISTOGRAM, CLocalizationString(IDS_MENU_TRACE_PRINTBYTECODEHISTOGRAM));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_PRINTPAIRHISTOGRAM, CLocalizationString(IDS_MENU_TRACE_PRINTPAIRHISTOGRAM));
    AppendMenu(hMenuPopupTrace, MF_SEPARATOR, 0, 0);
    //AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_BYTECODES,          "Generate interpreter that traces bytecodes");
    //AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_BYTECODESVERBOSE,   "Generate interpreter that traces bytecodes verbose");
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_NATIVECALLS, CLocalizationString(IDS_MENU_TRACE_NATIVECALLS));
    AppendMenu(hMenuPopupTrace, MF_UNCHECKED | MF_STRING | MF_ENABLED, ID_TRACE_NETWORKING, CLocalizationString(IDS_MENU_TRACE_NETWORKING));

    AppendMenu(hMenuPopupDebug, MF_CHECKED | MF_STRING | MF_ENABLED, ID_DEBUGGER_ACTIVE, CLocalizationString(IDS_MENU_DEBUGGER_ACTIVE));
    AppendMenu(hMenuPopupDebug, MF_CHECKED | MF_STRING | MF_ENABLED, ID_SHOW_ERRORS    , CLocalizationString(IDS_MENU_SHOW_ERRORS));
    AppendMenu(hMenuPopupDebug, MF_CHECKED | MF_STRING | MF_ENABLED, ID_SHOW_INFOS     , CLocalizationString(IDS_MENU_SHOW_INFOS));
    AppendMenu(hMenuPopupDebug, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPopupDebug, MF_CHECKED | MF_STRING | MF_ENABLED, ID_TRACE1, CLocalizationString(IDS_MENU_TRACE1));
    AppendMenu(hMenuPopupDebug, MF_STRING  | MF_ENABLED| MF_POPUP, (UINT) hMenuPopupTrace, CLocalizationString(IDS_MENU_TRACE_OPTION));
    AppendMenu(hMenuPopupDebug, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPopupMode,  MF_CHECKED | MF_STRING | MF_ENABLED, ID_MODE_ALARM,  CLocalizationString(IDS_MENU_MODE_ALARM));
    AppendMenu(hMenuPopupMode,  MF_CHECKED | MF_STRING | MF_ENABLED, ID_MODE_CHARGE, CLocalizationString(IDS_MENU_MODE_CHARGE));
    AppendMenu(hMenuPopupMode,  MF_CHECKED | MF_STRING | MF_ENABLED, ID_MODE_NORMAL, CLocalizationString(IDS_MENU_MODE_NORMAL));
    AppendMenu(hMenuPopupDebug, MF_STRING  | MF_ENABLED| MF_POPUP, (UINT) hMenuPopupMode, CLocalizationString(IDS_MENU_NEXT_START_MODE));
#endif
#endif

    AppendMenu(hMenuPopupTools, MF_STRING, ID_TOOLS_OPTIONS , CLocalizationString(IDS_MENU_TOOLS_OPTIONS));
    // Fang Yunchao move "Change Windows UI Language " to main menu
   // AppendMenu(hMenuPopupTools, MF_STRING, E_MMI_CMD_Change_UI_language , CLocalizationString(IDS_MMI_CMD_CHANGE_UI_LANGUAGE));


    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, ID_VIEW_PHONESCREEN, CLocalizationString(IDS_MENU_VIEW_PHONESCREEN));
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, ID_VIEW_MMICOMMANDS, CLocalizationString(IDS_MENU_VIEW_MMICOMMANDS));
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, ID_VIEW_OUTPUTWND, CLocalizationString(IDS_MENU_VIEW_OUTPUTWND));
//    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, ID_VIEW_CLAMPSHELL, CLocalizationString(IDS_MENU_VIEW_CLAMPSHELL));
    AppendMenu(hMenuView, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, IDR_MAINFRAME  ,     CLocalizationString(IDS_MENU_MAINFRAME));
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, IDR_DOCKING_WINDOWS ,CLocalizationString(IDS_MENU_DOCKING_WINDOWS));
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, ID_INDICATOR_MEM ,   CLocalizationString(IDS_MENU_INDICATOR_MEM));
    /* 2004/6/17 Fang Yunchao modification for SMTK Localization Project begin */
    AppendMenu(hMenuView,  MF_STRING | MF_ENABLED, ID_SHOW_SHAPED_UI ,CLocalizationString(IDS_MENU_SHAPED_UI));
    /* 2004/6/17 Fang Yunchao modification for SMTK Localization Project end */
   
/*  remove the contents of search related from the new request of Help Menu.       
   
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_GRAYED, ID_SEARCH , CLocalizationString(IDS_MENU_SEARCH));
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_GRAYED, ID_CONTENT, CLocalizationString(IDS_MENU_CONTENT));
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_GRAYED, ID_INDEX  , CLocalizationString(IDS_MENU_INDEX));
    AppendMenu(hMenuPopupHelp, MF_SEPARATOR, 0, 0);
*/
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_ENABLED, ID_USERMANUAL ,CLocalizationString(IDS_MENU_USERMANUAL));
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_ENABLED, ID_ABOUT , CLocalizationString(IDS_MENU_ABOUT));

    return hMenu;
}

/* 2004/6/17 Fang Yunchao modification for SMTK Localization Project begin */
HMENU CMMIDispWindow::buildSkinsPopMenu()
{
   hMenuPop         = CreatePopupMenu();
    hMenuFile       = CreateMenu();
    hMenuView       = CreateMenu();
    hMenuPopupHelp   = CreateMenu();
    hMenuCommand    = CreateMenu();
    hMenuZoom       = CreateMenu();
    hMenuPhone      = CreateMenu();
    hMenuNetworkSimu       = CreateMenu(); /* Network Simulation */
    hMenuPhoneSimu    = CreateMenu(); /* Phone Simulation */
    hMenuPopupTools = CreateMenu();   /*tools, add by sunmin*/


    //AppendMenu(hMenuPop, MF_POPUP, (UINT)hMenuFile, "File");
    AppendMenu(hMenuPop, MF_POPUP, (UINT)hMenuView , CLocalizationString(IDS_MENU_VIEW));
    AppendMenu(hMenuPop, MF_POPUP, (UINT)hMenuNetworkSimu , CLocalizationString(IDS_MMI_CMD_NETWORK_COMMANDS));
    AppendMenu(hMenuPop, MF_POPUP, (UINT)hMenuPhoneSimu ,  CLocalizationString(IDS_MMI_CMD_PHONE_COMMANDS));
    AppendMenu(hMenuPop, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPop, MF_POPUP, (UINT)hMenuPopupTools,  CLocalizationString(IDS_MENU_TOOLS));
    AppendMenu(hMenuPop, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPop, MF_POPUP, (UINT)hMenuPopupHelp , CLocalizationString(IDS_MENU_HELP));
    AppendMenu(hMenuPop, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPop, MF_STRING | MF_ENABLED,ID_CLOSE_ENTIR_PROGRAM , CLocalizationString(IDS_MENU_EXIT));


    AppendMenu(hMenuFile, MF_STRING | MF_ENABLED, ID_START_JAVA_APP,CLocalizationString(IDS_MMI_CMD_START_JAVA_APPLICATION));
    AppendMenu(hMenuFile, MF_STRING | MF_ENABLED,NULL ,CLocalizationString(IDS_MENU_SWITCH_OFF_PHONE));
    AppendMenu(hMenuFile, MF_SEPARATOR, 0, 0);

    AppendMenu(hMenuView, MF_STRING | MF_ENABLED, ID_GOTO_DOCKED_WIN,CLocalizationString(IDS_MENU_MULTI_DOCUMENT_VIEW));
    AppendMenu(hMenuView, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED | MF_UNCHECKED ,ID_MAIN_MENU,CLocalizationString(IDS_MENU_MAIN_MENU));
   if(m_iFlexShellType==FLEXSHELL_ROTATOR)
    {
    AppendMenu(hMenuView, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuView,MF_STRING | MF_ENABLED | MF_UNCHECKED ,ID_FLEXSHELL_CLOSE,CLocalizationString(IDS_MENU_CLOSE_FLEXSHELL));
// change flex shell initial status to "open" by Fang Yunchao
    AppendMenu(hMenuView,MF_STRING | MF_DISABLED | MF_CHECKED ,ID_FLEXSHELL_OPEN,CLocalizationString(IDS_MENU_OPEN_FLEXSHELL));
    AppendMenu(hMenuView,MF_STRING | MF_GRAYED |  MF_UNCHECKED,ID_FLEXSHELL_MIDDLE,CLocalizationString(IDS_MENU_MIDDLE_FLEXSHELL));
    }

    AppendMenu(hMenuView, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuView, MF_STRING | MF_ENABLED | MF_UNCHECKED , ID_DISPLAY_ONLY, CLocalizationString(IDS_MENU_HIDESKIN));
    AppendMenu(hMenuView, MF_SEPARATOR, 0, 0);

    AppendMenu(hMenuView, MF_STRING | MF_DISABLED | MF_CHECKED,ID_MAGNIFY_1,CLocalizationString(IDS_MENU_MAGNIFY_1));
  //  if(m_iFlexShellType==FLEXSHELL_ROTATOR)
  // {
    //  AppendMenu(hMenuView, MF_STRING | MF_GRAYED| MF_UNCHECKED, ID_MAGNIFY_2, CLocalizationString(IDS_MENU_MAGNIFY_2));
//  }
    //else
//{
        AppendMenu(hMenuView, MF_STRING | MF_ENABLED | MF_UNCHECKED, ID_MAGNIFY_2, CLocalizationString(IDS_MENU_MAGNIFY_2));
//  }
   
#if 0

#if DPLDRV_COLOR_TYPE != DPLDRV_COLOR_TYPE_BLACK_WHITE
    AppendMenu(hMenuPhone, MF_STRING | MF_ENABLED | MF_UNCHECKED, ID_REAL_COLOR, CLocalizationString(IDS_MENU_REAL_COLOR));

    if ( RealColors)
        ToggleTraceItemState( ID_REAL_COLOR, MF_CHECKED);
#endif
    AppendMenu(hMenuPhone, MF_SEPARATOR, 0, 0);

     char *ptrOld;
     char *ptrNew;
    

    // get path of the skin bitmaps
    if(!Simu_GetFilePath( SearchExt, "*.skn", "", True))
    {
        char  msg[ 512];
        strcat( msg, "Skins could not be found in the\nINSTALL_PATH directory root.");
        info_message(   msg, "Skin Build error" );
        
    }

    // build the skin directory path
    memcpy(SkinDir, SearchExt, sizeof(SearchExt));
    ptrOld = SkinDir;
    ptrNew = (char*) strrchr( (char*) ptrOld, '\\' );
     *ptrNew = '\0';

    
    fileHandle = FindFirstFile( SearchExt, &findData);

    if (fileHandle == INVALID_HANDLE_VALUE)
    {
        // switch to developer path mode:
        sprintf( SkinDir  , "%s\\%s"   , mg_InstallPath, SkinSubDir);
       sprintf( SearchExt, "%s\\*.skn", SkinDir);
        fileHandle = FindFirstFile( SearchExt, &findData);
        
    }

    if (fileHandle != INVALID_HANDLE_VALUE)
    {
        print_d("Found skins in %s\n", SkinDir);
        do
        {
             skins[numSkins] = (char*) malloc( SKIN_PATH_LEN);
           GetFullPathName(findData.cFileName, SKIN_PATH_LEN, skins[numSkins], &addr);
            strcpy( name, addr);
           strcpy(skins[numSkins], addr);
            
            /* remove the .skn extension */
            // name[strlen(name) - 4] = '\0';
            name[wcslen(name) - 4] = _T('\0)';
            print_d("    %s\n", name);

            // we have to start from 1, because MFC does not support ID=0 for menus !!!!
            AppendMenu(hMenuPhone, MF_STRING | MF_ENABLED | MF_UNCHECKED, ++numSkins, name);

            if (numSkins > NUM_SKINS_SUPPORTED -1)   break;
        } while (FindNextFile(fileHandle, &findData));

        AppendMenu(hMenuPhone, MF_SEPARATOR, 0, 0);
        skins[numSkins] = (char*) malloc( SKIN_PATH_LEN);
       strcpy( skins[numSkins], "no skin");
       AppendMenu(hMenuPhone, MF_STRING | MF_ENABLED | MF_UNCHECKED, ++numSkins,CLocalizationString(IDS_MENU_HIDESKIN));
        
    }
    FindClose(fileHandle);

#endif // end 0

//Incoming Call//
    AppendMenu(hMenuCommand, MF_POPUP, (UINT)hMenuNetworkSimu,CLocalizationString(IDS_MENU_NETWORK_SIMULATION));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_ENABLED, ID_MOBILE_TERMINATING_CALL, CLocalizationString(IDS_MENU_MOBILE_TERMINATING_CALL));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_ENABLED, ID_DISCONNECT_CALL_BY_NET, CLocalizationString(IDS_MMI_CMD_MSM_DISCONNECT_CALL_BY_NET));
#if 0
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_GRAYED, NULL, CLocalizationString(IDS_MENU_INTERRUPT_CALL));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_GRAYED, NULL,  CLocalizationString(IDS_MENU_INSERT_MOBILE_IN_CARKIT_HIGH));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_GRAYED, NULL, CLocalizationString(IDS_MENU_REMOVE_MOBILE_FROM_CARKIT_HIGH));
#endif

//Net Service//
    AppendMenu(hMenuNetworkSimu, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_ENABLED, ID_FULL_SERVICE,CLocalizationString(IDS_MMI_CMD_MM_FULL_SERVICE));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_ENABLED, ID_NO_SERVICE, CLocalizationString(IDS_MMI_CMD_MM_NO_SERVICE));

//SMS//
    AppendMenu(hMenuNetworkSimu, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_ENABLED, ID_INCOMING_SHORT_MESSAGE,CLocalizationString(IDS_MMI_CMD_SMS_INCOMMING_SMS));
#if 0
    //AppendMenu(hMenuSMS, MF_STRING | MF_GRAYED, NULL, "Immediate Message");
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_GRAYED, NULL, CLocalizationString(IDS_MMI_CMD_SMS_STATUS_REPORT));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_GRAYED, NULL, CLocalizationString(IDS_MMI_CMD_SMS_TOGGLE_VOICE_MESSAGE));
#endif
//MOC//
#if 0
    AppendMenu(hMenuCommand, MF_POPUP, (UINT)hMenuMOC,CLocalizationString(IDS_MENU_MOC));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_GRAYED, NULL, CLocalizationString(IDS_MENU_DISCONNECT_PROGRESS_OFF));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_GRAYED, NULL, CLocalizationString(IDS_MENU_RELEASE_WITH_BUSY_IS_OFF));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_GRAYED, NULL, CLocalizationString(IDS_MENU_CCBS_ISNOT_SUPPORT));
    AppendMenu(hMenuCommand, MF_SEPARATOR, 0, 0);
#endif

//EMS//
    AppendMenu(hMenuNetworkSimu, MF_SEPARATOR, 0, 0);  
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_ENABLED, ID_BUILD_SHORT_MESSAGE, CLocalizationString(IDS_MENU_BUILD_INCOMING_SMS));
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_ENABLED, ID_SEND_NEXT_SEGMENT_EMS_MESSAGE,CLocalizationString(IDS_MENU_SEND_NEXT_SEGMENT_OF_EMS_MESSAGE));
//Net Selection//
    AppendMenu(hMenuNetworkSimu, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuNetworkSimu, MF_STRING | MF_ENABLED, ID_CHOOSE_NETWORK,CLocalizationString(IDS_MMI_CMD_CHOOSE_NETWORK ));

    AppendMenu(hMenuCommand, MF_POPUP, (UINT)hMenuPhoneSimu, CLocalizationString(IDS_MENU_PHONE_SIMULATION));
   
    AppendMenu(hMenuPhoneSimu, MF_STRING | MF_ENABLED, ID_START_JAVA_APP,CLocalizationString(IDS_MMI_CMD_START_JAVA_APPLICATION));

//2004-11-04 Sun Min: delete to remove the unused menu item
    //AppendMenu(hMenuPhoneSimu, MF_STRING | MF_ENABLED, ID_SHOW_RUN_TIME_HEAP,CLocalizationString(IDS_MMI_CMD_SHOW_RUN_TIME_HEAP_INFO));

//Power//
    AppendMenu(hMenuPhoneSimu, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPhoneSimu, MF_STRING | MF_ENABLED, ID_BEGIN_LOW_POWER,CLocalizationString(IDS_MMI_CMD_BEGIN_LOW_POWER));
    AppendMenu(hMenuPhoneSimu, MF_STRING | MF_ENABLED, ID_END_LOW_POWER,CLocalizationString(IDS_MMI_CMD_END_LOW_POWER));

    //AppendMenu(hMenuPhoneSimu, MF_SEPARATOR, 0, 0);
    //AppendMenu(hMenuPhoneSimu, MF_STRING | MF_ENABLED, ID_CHANGE_MICROEDITION_LOCALE, "Change Microedition.locale");
    
    // AppendMenu(hMenuPhoneSimu, MF_SEPARATOR, 0, 0);
    //AppendMenu(hMenuPhoneSimu, MF_STRING | MF_ENABLED, ID_SEND_FREE_SPACE_NOTIFICATION, "Send 'Free Space' Notification");
    //AppendMenu(hMenuPhoneSimu, MF_STRING | MF_ENABLED, ID_SEND_NO_FREE_SPACE_NOTIFICATION, "Send 'Free Space' Notification");

    AppendMenu(hMenuPhoneSimu, MF_SEPARATOR, 0, 0);
    AppendMenu(hMenuPhoneSimu, MF_STRING | MF_ENABLED,ID_SWITCH_OFF , CLocalizationString(IDS_MMI_CMD_SWITCH_OFF));

//HZ//
#if 0
    AppendMenu(hMenuCommand, MF_STRING | MF_GRAYED, NULL, CLocalizationString(IDS_MENU_HOMEZONE));
#endif
 
   //Tools: add for SMTK Localization support, by Fang Yunchao 
    AppendMenu(hMenuPopupTools, MF_STRING, ID_TOOLS_OPTIONS ,CLocalizationString(IDS_MENU_TOOLS_OPTIONS));
    // AppendMenu(hMenuPopupTools, MF_STRING, E_MMI_CMD_Change_UI_language , CLocalizationString(IDS_MMI_CMD_CHANGE_UI_LANGUAGE));
    AppendMenu(hMenuPopupTools, MF_STRING, ID_SMTK_TOOL ,CLocalizationString(IDS_MENU_SMTK_TOOL_UTILITIES));


//Help// 
/*  remove the contents of search related from the new request of Help Menu.       
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_GRAYED, ID_SEARCH ,CLocalizationString(IDS_MENU_SEARCH));
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_GRAYED, ID_CONTENT, CLocalizationString(IDS_MENU_CONTENT));
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_GRAYED, ID_INDEX  , CLocalizationString(IDS_MENU_INDEX));
    AppendMenu(hMenuPopupHelp, MF_SEPARATOR, 0, 0);
*/
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_ENABLED, ID_USERMANUAL , CLocalizationString(IDS_MENU_USERMANUAL));   
    AppendMenu(hMenuPopupHelp, MF_STRING | MF_ENABLED, ID_ABOUT , CLocalizationString(IDS_MENU_ABOUT));




    return hMenuPop;

}
/* 2004/6/17 Fang Yunchao modification for SMTK Localization Project end */

#endif

#ifdef LOCALIZATION_SUPPORT
LRESULT CMMIDispWindow::OnUpdateWindowsUI(UINT uCode, LONG lParam)
{
    RegenerateMenu();
    #ifdef USE_SHAPED_UI
    CMainFrame* pFrame=(CMainFrame*)GET_APP()->m_pMainWnd;
    if(GlobalUiStyle == SHAPED_UI)
        {
        if(GobalMainMenuOpened==TRUE)
         {
          pFrame->m_MainMenuDlg.DestroyWindow();
          pFrame->m_MainMenuDlg.Create(IDD_SP_UI_PHONE_BODY,NULL);
              MakeActiveWnd();
         }
    }
     #endif
    return 0;
}
#endif

void CMMIDispWindow::SetSkinProps(const char *SkinData, const char *SkinBitmap)
{
    CString cStrSknDataFile;
    CString cStrSknBmpFile;
    CFile   cFSknFile;
    CFile   cFBmpFile;
    char    NeoSkinData[MAX_PATH];
    char    NeoSkinBitmap[MAX_PATH];   
    int     iNrLED = 0;
    UINT    LEDColor_R,LEDColor_G,LEDColor_B;
    RECT    rect;
    CString cStrDynLight = _T("DYNAMIC_LIGHT");
    m_cDynLightManager.DestroyLEDs();


#ifndef _UNICODE
    cStrSknDataFile.Format("%s\\%s",SkinDir,SkinData);
    cStrSknBmpFile.Format("%s\\%s",SkinDir,SkinBitmap);
#else
    USES_CONVERSION;
    cStrSknDataFile.Format(_T("%s\\%s"),A2W(SkinDir),A2W(SkinData));
    cStrSknBmpFile.Format(_T("%s\\%s"),A2W(SkinDir),A2W(SkinBitmap));
#endif
//added by duchun for neo flexshell close
    if(mg_FlexShellType == 2)
    {
// Fix a bug of flex shell display when hide skin by Fang Yunchao
#ifdef USE_SHAPED_UI
        if(m_bFlexShellClose&&GlobalUiSkin == SHAPED_UI_HAVE_SKIN)
#else
        if(m_bFlexShellClose)
#endif
        {
            sprintf(NeoSkinData,"%s_closed.skn", Info_GetProductName());       
        if(mg_Magnification==1)
       {
             sprintf(NeoSkinBitmap,"%s_closed.bmp", Info_GetProductName());
       }
       else
       {     
        sprintf(NeoSkinBitmap,"%s_closedg.bmp", Info_GetProductName());
       }
#ifndef _UNICODE
        cStrSknDataFile.Format(_T("%s\\%s"),SkinDir,NeoSkinData);
            cStrSknBmpFile.Format(_T("%s\\%s"),SkinDir,NeoSkinBitmap);
#else
        USES_CONVERSION;
        cStrSknDataFile.Format(_T("%s\\%s"),A2W(SkinDir),A2W(NeoSkinData));
            cStrSknBmpFile.Format(_T("%s\\%s"),A2W(SkinDir),A2W(NeoSkinBitmap));
#endif
        }
    }

    // look at first if both files exists
    if (cFSknFile.Open(cStrSknDataFile, CFile::modeRead) &&
        cFBmpFile.Open(cStrSknBmpFile,  CFile::modeRead))
    {
        cFSknFile.Close();
        cFBmpFile.Close();
        SkinShown = TRUE;
        
        // 1 or 2 is possible only
        if (mg_Magnification > 2)  
            mg_Magnification= 2;     
    
        NormalWidth   = GetPrivateProfileInt(_T("GENERAL_VALUES"),_T( "emulatorWidth"),  250 ,cStrSknDataFile);
        NormalHeight  = GetPrivateProfileInt(_T("GENERAL_VALUES"),_T( "emulatorHeight"), 500 ,cStrSknDataFile);
        x_offset      = GetPrivateProfileInt(_T("GENERAL_VALUES"), _T("x_offset"),       136 ,cStrSknDataFile);
        y_offset      = GetPrivateProfileInt(_T("GENERAL_VALUES"), _T("y_offset"),       136 ,cStrSknDataFile);
        displayWidth  = GetPrivateProfileInt(_T("GENERAL_VALUES"), _T("displayWidth"),   136 ,cStrSknDataFile)*mg_Magnification;
        displayHeight = GetPrivateProfileInt(_T("GENERAL_VALUES"), _T("displayHeight"),  136 ,cStrSknDataFile)*mg_Magnification;
        emulatorWidth = GetPrivateProfileInt(_T("GENERAL_VALUES"), _T("emulatorWidth"),  250 ,cStrSknDataFile)*mg_Magnification+7;
        emulatorHeight= GetPrivateProfileInt(_T("GENERAL_VALUES"),_T( "emulatorHeight"), 500 ,cStrSknDataFile)*mg_Magnification+20;

        backgroundColor = RGB(GetPrivateProfileInt(_T("GENERAL_VALUES"), _T("backgroundColor_R"), 253 ,cStrSknDataFile), 
                              GetPrivateProfileInt(_T("GENERAL_VALUES"), _T("backgroundColor_G"), 196 ,cStrSknDataFile), 
                              GetPrivateProfileInt(_T("GENERAL_VALUES"), _T("backgroundColor_G"), 65  ,cStrSknDataFile));
        foregroundColor = RGB(GetPrivateProfileInt(_T("GENERAL_VALUES"), _T("foregroundColor_R"), 0   ,cStrSknDataFile), 
                              GetPrivateProfileInt(_T("GENERAL_VALUES"), _T("foregroundColor_G"), 0   ,cStrSknDataFile), 
                              GetPrivateProfileInt(_T("GENERAL_VALUES"),_T( "foregroundColor_G"), 0   ,cStrSknDataFile));

        for (int i=0; i<NUMBEROF(Keys); i++)
        {
            Keys[i].bounds.x      = GetPrivateProfileIntA(Keys[i].name, "X_Offset", 0, (LPCSTR)(LPCTSTR)cStrSknDataFile);
            Keys[i].bounds.y      = GetPrivateProfileIntA(Keys[i].name, "Y_Offset", 0, (LPCSTR)(LPCTSTR)cStrSknDataFile);
            Keys[i].bounds.width  = GetPrivateProfileIntA(Keys[i].name, "width",    0, (LPCSTR)(LPCTSTR)cStrSknDataFile);
            Keys[i].bounds.height = GetPrivateProfileIntA(Keys[i].name, "height",   0, (LPCSTR)(LPCTSTR)cStrSknDataFile);
        }

        if (m_bFirstInit)
        {
            m_bFirstInit = FALSE;
            m_iFlexShellType=mg_FlexShellType=GetPrivateProfileInt(_T("GENERAL_VALUES"),_T( "flexShellType"),  0 ,cStrSknDataFile);
        }
        if(m_HSkinImg)
    {
        DeleteObject(m_HSkinImg);
    }

       m_HSkinImg = (HBITMAP) LoadImage(AfxGetInstanceHandle(), cStrSknBmpFile,
                                        IMAGE_BITMAP, 0, 0, LR_DEFAULTCOLOR | LR_LOADFROMFILE);

       iNrLED = GetPrivateProfileInt(cStrDynLight, _T( "numberofLEDs"), 0 ,cStrSknDataFile);

       for (i=0; i<iNrLED; i++)
       {
           cStrDynLight.Format(_T("DYNAMIC_LIGHT_LED%d"),i);
           /*
       rect.left   = GetPrivateProfileIntA(cStrDynLight, "X_Offset",   0, (LPCSTR)(LPCTSTR)cStrSknDataFile);
           rect.top    = GetPrivateProfileIntA(cStrDynLight, "Y_Offset",   0, (LPCSTR)(LPCTSTR)cStrSknDataFile);
           rect.right  = GetPrivateProfileIntA(cStrDynLight, "width",      0, (LPCSTR)(LPCTSTR)cStrSknDataFile);
           rect.bottom = GetPrivateProfileIntA(cStrDynLight, "height",     0, (LPCSTR)(LPCTSTR)cStrSknDataFile);
           LEDColor_R  = GetPrivateProfileIntA(cStrDynLight, "LEDColor_R", 0, (LPCSTR)(LPCTSTR)cStrSknDataFile);
           LEDColor_G  = GetPrivateProfileIntA(cStrDynLight, "LEDColor_G", 0, (LPCSTR)(LPCTSTR)cStrSknDataFile);
           LEDColor_B  = GetPrivateProfileIntA(cStrDynLight, "LEDColor_B", 0, (LPCSTR)(LPCTSTR)cStrSknDataFile);
     */
       rect.left   = GetPrivateProfileInt(cStrDynLight,_T("X_Offset"),   0, cStrSknDataFile);
           rect.top    = GetPrivateProfileInt(cStrDynLight,_T( "Y_Offset"),   0, cStrSknDataFile);
           rect.right  = GetPrivateProfileInt(cStrDynLight,_T( "width"),      0, cStrSknDataFile);
           rect.bottom = GetPrivateProfileInt(cStrDynLight,_T( "height"),     0, cStrSknDataFile);
           LEDColor_R  = GetPrivateProfileInt(cStrDynLight, _T("LEDColor_R"), 0, cStrSknDataFile);
           LEDColor_G  = GetPrivateProfileInt(cStrDynLight,_T("LEDColor_G"), 0, cStrSknDataFile);
           LEDColor_B  = GetPrivateProfileInt(cStrDynLight,_T("LEDColor_B"), 0, cStrSknDataFile);
           m_cDynLightManager.CreateLED(i, &rect,LEDColor_R,LEDColor_G,LEDColor_B);
       }


    }
    else
    {
        if (cFSknFile.m_hFile != CFile::hFileNull)
            cFSknFile.Close();
        if (cFBmpFile.m_hFile != CFile::hFileNull)
            cFBmpFile.Close();

        if (m_bFirstInit)
        {
            m_bFirstInit     = FALSE;
            m_iFlexShellType = mg_FlexShellType = eFlexShell_Non; 
        }

        SkinShown      = FALSE;
        NormalWidth    = DispGetWidth(E_DISP_MAIN);
        NormalHeight   = DispGetHeight(E_DISP_MAIN);
        displayWidth   = DispGetWidth(E_DISP_MAIN)  * mg_Magnification;
        displayHeight  = DispGetHeight(E_DISP_MAIN) * mg_Magnification;
        emulatorWidth  = displayWidth  + 11;
        emulatorHeight = displayHeight + 25;
        x_offset       = 0;
        y_offset       = 0;
        
        // SL45 colors
        backgroundColor = RGB(253, 196, 65);           
        foregroundColor = RGB(0, 0, 0);

        // disable all mouse button keys
        for (int i=0; i<NUMBEROF(Keys); i++)                
        {
            Keys[i].bounds.x = -2;
            Keys[i].bounds.y = -2;
            Keys[i].bounds.width = 0;
            Keys[i].bounds.height= 0;
        }
    }

    SetForegroundColor(foregroundColor);
    SetBackgroundColor(backgroundColor); 
    DispSetPixelWidthZoom (E_DISP_MAIN,mg_Magnification);
    DispSetPixelHeightZoom(E_DISP_MAIN,mg_Magnification);

#ifndef JAVA_SDK
    // enable high zoom selections:
    SetZoomItemState(ID_MAGNIFY_3, MF_STRING | MF_ENABLED);
    SetZoomItemState(ID_MAGNIFY_5, MF_STRING | MF_ENABLED);
    SetZoomItemState(ID_MAGNIFY_8, MF_STRING | MF_ENABLED);
#endif
}


////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////  CMMIDispWindow ///////////////////////////////////////////////////////////


BEGIN_MESSAGE_MAP(CMMIDispWindow, CDispWnd)
    //{{AFX_MSG_MAP(CMMIDispWindow)
    ON_COMMAND(ID_TOOLBAR_DIAL, OnToolbarDial)
    ON_COMMAND(ID_TOOLBAR_HANGUP, OnToolbarHangup)
    ON_COMMAND(ID_TOOLBAR_INSERT_SIM, OnToolbarInsertSim)
    ON_COMMAND(ID_TOOLBAR_PHONEBOOK, OnToolbarPhonebook)
    ON_COMMAND(ID_TOOLBAR_REMOVE_SIM, OnToolbarRemoveSim)
    ON_COMMAND(ID_TOOLBAR_SOFTKEY2, OnToolbarSoftkey2)
    ON_COMMAND(ID_TOOLBAR_SOFTKEY3, OnToolbarSoftkey3)
    ON_COMMAND(ID_TOOLBAR_SOFTKEY4, OnToolbarSoftkey4)
  ON_COMMAND(ID_TOOLBAR_BLINK1, OnToolbarSoftkey5)
    ON_COMMAND(ID_TOOLBAR_START, OnToolbarStart)
    ON_COMMAND(ID_TOOLBAR_SWITCHOFF, OnToolbarSwitchoff)
    ON_COMMAND(ID_TOOLBAR_VM, OnToolbarVm)
    ON_COMMAND(ID_TOOLBAR_SOFTKEY1, OnToolbarSoftkey1)
    ON_COMMAND(ID_REAL_COLOR, OnRealColor)
//    ON_COMMAND(ID_SEARCH, OnSearch)
//    ON_COMMAND(ID_CONTENT, OnContent)
//    ON_COMMAND(ID_INDEX, OnIndex)
    ON_COMMAND(ID_USERMANUAL, OnUserManual)
    ON_COMMAND(ID_ABOUT, OnAbout)
    ON_COMMAND(ID_TRACE1, OnTrace1)
    ON_COMMAND(ID_SHOW_ERRORS, OnShowErrors)
    ON_COMMAND(ID_SHOW_INFOS, OnShowInfos)
    ON_COMMAND(ID_DEBUGGER_ACTIVE, OnDebuggerActive)
    ON_COMMAND(ID_FLEXSHELL_CLOSE,OnFlexshellClose)
    ON_COMMAND(ID_FLEXSHELL_OPEN,OnFlexshellOpen)
    ON_COMMAND(ID_FLEXSHELL_MIDDLE,OnFlexshellMiddle)
    ON_UPDATE_COMMAND_UI(ID_FLEXSHELL_CLOSE,     OnUpdateFlexshellClose)
    ON_UPDATE_COMMAND_UI(ID_FLEXSHELL_MIDDLE,     OnUpdateFlexshellMiddle)
    ON_UPDATE_COMMAND_UI(ID_FLEXSHELL_OPEN,      OnUpdateFlexshellOpen)    
    ON_COMMAND(ID_MAGNIFY_1, OnMagnify100)
    ON_COMMAND(ID_MAGNIFY_2, OnMagnify200)
    ON_COMMAND(ID_MAGNIFY_3, OnMagnify300)
    ON_COMMAND(ID_MAGNIFY_5, OnMagnify500)
    ON_COMMAND(ID_MAGNIFY_8, OnMagnify800)
    ON_UPDATE_COMMAND_UI(ID_MAGNIFY_3, OnUpdateMagnify300)
    ON_UPDATE_COMMAND_UI(ID_MAGNIFY_5, OnUpdateMagnify500)
    ON_UPDATE_COMMAND_UI(ID_MAGNIFY_8, OnUpdateMagnify800)
    ON_COMMAND(ID_MODE_CHARGE, OnModeCharge)
    ON_COMMAND(ID_MODE_NORMAL, OnModeNormal)
    ON_COMMAND(ID_MODE_ALARM, OnModeAlarm)
    
    //add by sunmin for add option window to shaped UI and MDV
    ON_COMMAND(ID_TOOLS_OPTIONS,OnShowOptionsDlg)
    //add by FANG YUNCHAO for add "Change Windows UI Language " menu item
 #ifdef LOCALIZATION_SUPPORT
    ON_COMMAND(E_MMI_CMD_Change_UI_language,ChangeUILanguageOption)
#endif

    
//modified by duchun for SHAPED_UI
//#ifdef SHAPED_UI
#ifdef USE_SHAPED_UI
    ON_COMMAND(ID_SHOW_SHAPED_UI, OnGotoShapedUi)
    ON_COMMAND(ID_MAIN_MENU, OnMainMenu)
    ON_COMMAND(ID_SMTK_TOOL,OnSmtkTool)
#endif
    ON_COMMAND(ID_START_JAVA_APP, OnStartJavaApp)
    ON_COMMAND(ID_MOBILE_TERMINATING_CALL, OnTerminatingCall)
    ON_COMMAND(ID_DISCONNECT_CALL_BY_NET, OnDisconnectCallByNet)
    ON_COMMAND(ID_BUILD_SHORT_MESSAGE, OnBuildShortMessage)             
    ON_COMMAND(ID_SEND_NEXT_SEGMENT_EMS_MESSAGE, OnSendNextSegmentEMSMessage)

    
    ON_COMMAND(ID_FULL_SERVICE, OnFullService)
    ON_COMMAND(ID_NO_SERVICE, OnNoService)
    ON_COMMAND(ID_INCOMING_SHORT_MESSAGE, OnIncomingShortMessage)
    ON_COMMAND(ID_CHOOSE_NETWORK, OnChooseNetwork)
//2004-11-04 Sun Min: delete unused menu item
    //ON_COMMAND(ID_SHOW_RUN_TIME_HEAP, OnRunTimeHeap)
    ON_COMMAND(ID_BEGIN_LOW_POWER, OnBeginLowPower)
    ON_COMMAND(ID_END_LOW_POWER, OnEndLowPower)
    ON_COMMAND(ID_CHANGE_MICROEDITION_LOCALE, OnChangeMicroedition)
    ON_COMMAND(ID_SEND_FREE_SPACE_NOTIFICATION, OnFreeSpaceNotification)
    ON_COMMAND(ID_SEND_NO_FREE_SPACE_NOTIFICATION, OnNoFreeSpaceNotification)
    ON_COMMAND(ID_SWITCH_OFF, OnSwitchOff)
//modified by duchun for SHAPED_UI
#ifdef USE_SHAPED_UI
    ON_COMMAND(ID_GOTO_DOCKED_WIN, OnGoToDockedWin)
    ON_COMMAND(ID_DISPLAY_ONLY, OnDisplayOnly)
    ON_UPDATE_COMMAND_UI(ID_DISPLAY_ONLY, OnUpdateDisplayOnly)
#endif

    ON_COMMAND(ID_CLOSE_ENTIR_PROGRAM, OnCloseEntirProgram)
// for shaped ui
//  ON_WM_ERASEBKGND()
//  ON_WM_CTLCOLOR()
//modified by duchun for SHAPED_UI
//#endif
    ON_WM_KEYDOWN()
    ON_WM_KEYUP()
    ON_WM_CREATE()
    ON_WM_PAINT()
    ON_WM_SIZE()
    ON_WM_DESTROY()
    ON_WM_LBUTTONDOWN()
    ON_WM_LBUTTONUP()
    ON_WM_INITMENU()
    ON_WM_MENUSELECT()
    ON_WM_INITMENUPOPUP()
    ON_WM_MOVE()
    ON_WM_MOVING()
    ON_WM_ACTIVATE()
    ON_WM_NCPAINT()
    ON_WM_SHOWWINDOW()
    ON_WM_WINDOWPOSCHANGING()
    ON_WM_TIMER()
    ON_WM_DROPFILES()
#ifdef LOCALIZATION_SUPPORT
    ON_MESSAGE(WM_UPDATE_WINDOWS_UI,          OnUpdateWindowsUI)  //added by kevin
#endif
 // for bitmap ui
    ON_WM_ERASEBKGND()
    ON_WM_CTLCOLOR()
    //}}AFX_MSG_MAP
    ON_COMMAND_RANGE(ID_SKIN1, ID_SKIN8, OnSetSkin)
    //ON_COMMAND_RANGE(ID_TRACE_MEMORYALLOCATION,ID_TRACE_NETWORKING, OnTraceMenu)
    ON_COMMAND_RANGE(ID_TRACE_DEBUGGER,ID_TRACE_NETWORKING, OnTraceMenu)
//modified by duchun for SHAPED_UI
//#ifdef SHAPED_UI
#ifdef USE_SHAPED_UI
    ON_WM_RBUTTONDOWN()
    ON_WM_RBUTTONUP()
#endif
    ON_WM_CHAR()
    ON_WM_SETFOCUS()
    ON_MESSAGE(WM_VIBRA_CTRL, OnVibraCtrl)
END_MESSAGE_MAP()


// Do not create unless previously registered.
CMMIDispWindow::CMMIDispWindow( void )
{
    m_bFirstInit = TRUE;
    m_rPaint = 0;
//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
// SHAPED_UI
    m_bTransparent = FALSE;         // No transparency
    m_bStaticTransparent = TRUE;    // Static controls are transparent
    m_bBitmapCreated = FALSE;       // Don't automatically release the bitmap
    m_bBitmapExists = FALSE;        // IS there a bitmap?
    m_bClickAnywhereMove = FALSE;   // Clicking anywhere moves
    GobalMainMenuOpened = FALSE;
    m_CountSkinChange = 0;
    m_Magnify = mg_Magnification;
    m_SkinLoaded = 0;
    if (GlobalUiStyle == SHAPED_UI)
    {
        // Create a hollow brush used in making static controls transparent
        m_brushHollow = (HBRUSH) GetStockObject (HOLLOW_BRUSH);
    }
#endif
    m_inKeyPos = FALSE;

//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
        m_rcFrame.SetRect(50,50,800,650);
        m_rcShapedUI.SetRect(SHAPED_UI_FRAME_LEFT,SHAPED_UI_FRAME_TOP,SHAPED_UI_FRAME_LEFT+emulatorWidth,SHAPED_UI_FRAME_TOP+emulatorHeight);
#endif
#ifdef JAVA_SDK
    m_pDlgSmtkTool=NULL;
#endif
    m_bFlexShellClose  = FALSE;
    // change flex shell initial status to "open" by Fang Yunchao
    m_bFlexShellMiddle = FALSE;
    m_bFlexShellOpen   = TRUE;
    m_bIsVibrating     = FALSE;
    m_uiVibraTimeOut   = 25;
    m_uiX              = 0;
    m_uiXVibra         = 0;
    m_HSkinImg         = NULL;
}


extern "C" HWND DispGetWinHandle(void)
{
#if PC_SIMU_USE_NEW_UI
    return GET_APP()->GetMMIDispWindow()->m_hWnd;
#else
    ASSERT(FALSE);
    return NULL;
#endif
}

void CMMIDispWindow::Register( void )
{
}


void CMMIDispWindow::SetAllTraceItemState()
{
    UINT  TurnOn = MF_CHECKED   | MF_STRING | MF_ENABLED;
    UINT  TurnOff= MF_UNCHECKED | MF_STRING | MF_ENABLED;

#if ENABLE_JAVA_DEBUGGER
    SetTraceItemState(ID_DEBUGGER_ACTIVE, debuggerActive ? TurnOn : TurnOff);
#else
    SetTraceItemState(ID_DEBUGGER_ACTIVE, TurnOff | MFS_GRAYED);
#endif

    SetTraceItemState(ID_TRACE1         , mg_Tracing          ? TurnOn : TurnOff);
    SetTraceItemState(ID_SHOW_ERRORS    , mg_ShowErrorMessages? TurnOn : TurnOff);
    SetTraceItemState(ID_SHOW_INFOS     , mg_ShowInfoMessages ? TurnOn : TurnOff);

    SetTraceItemState(ID_MODE_ALARM     , (mg_MMIMode==e_alarm_mode)  ? TurnOn : TurnOff);
    SetTraceItemState(ID_MODE_CHARGE    , (mg_MMIMode==e_charge_mode) ? TurnOn : TurnOff);
    SetTraceItemState(ID_MODE_NORMAL    , (mg_MMIMode==e_normal_mode) ? TurnOn : TurnOff);

    if (mg_Tracing == FALSE)
    {
        TurnOn  |= MFS_DISABLED | MFS_GRAYED;
        TurnOff |= MFS_DISABLED | MFS_GRAYED;
        SetTracing(TRUE);                       // restore data to display
    }

    SetTraceItemState(ID_TRACE_DEBUGGER,                 TraceDebugger            ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_THREADEVENTS,             TraceThreadEvents        ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_THREADSEXCESSIVE,         TraceThreadsExcessive    ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_VERIFIER,                 TraceVerifier            ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_STACKMAPS,                TraceStackmaps           ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_STACKMAPSVERBOSE,         TraceStackmapsVerbose    ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_VERIFIERBYTECODES,        TraceVerifierByteCodes   ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_OSR,                      TraceOSR                 ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_CLASSLOADING,             TraceClassLoading        ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_EXCEPTIONS,               TraceExceptions          ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_GC,                       TraceGC                  ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_FINALIZATION,             TraceFinalization        ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_VERBOSEGC,                VerboseGC                ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_VERBOSECLASSLOADING,      VerboseClassLoading      ? TurnOn : TurnOff);
    //SetTraceItemState(ID_TRACE_BYTECODES,                TraceBytecodes           ? TurnOn : TurnOff);
    //SetTraceItemState(ID_TRACE_BYTECODESVERBOSE,         TraceBytecodesVerbose    ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_PRINTALLOBJECTS,          PrintAllObjects          ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_RUNFINALIZATIONATEXIT,    RunFinalizationAtExit    ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_PRINTLOADEDCLASSES,       PrintLoadedClasses       ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_PRINTOBJECTHISTOGRAMDATA, PrintObjectHistogramData ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_PRINTLONGFRAMES,          PrintLongFrames          ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_PRINTBYTECODEHISTOGRAM,   PrintBytecodeHistogram   ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_PRINTCOMPILATION,         PrintCompilation         ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_PRINTCOMPILEDCODE,        PrintCompiledCode        ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_PRINTCOMPILEDCODEASYOUGO, PrintCompiledCodeAsYouGo ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_PRINTPAIRHISTOGRAM,       PrintPairHistogram       ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_NATIVECALLS,              TraceNativeCalls         ? TurnOn : TurnOff);
    SetTraceItemState(ID_TRACE_NETWORKING,               tracenetworking          ? TurnOn : TurnOff);

    if (mg_Tracing == FALSE)  SetTracing(FALSE);
}

void CMMIDispWindow::SaveAllDataToPermanentRegistry()
{
    int i;
    CString cStrjavaOptions = "Options\\Java Debug Trace";

#ifdef JAVA_SDK
    char  szValue[JAVA_MAX_PROPERTY_LEN];
    char *pcProductName = NULL;
    pcProductName = getSystemProperty ("microedition.platform", szValue);
   
    if (pcProductName != NULL)
    {
        cStrjavaOptions = CString(pcProductName) + "\\" + cStrjavaOptions;
    }
#endif

    if (mg_Tracing == FALSE)  SetTracing(TRUE);           // restore hidden data to save

#if ENABLE_JAVA_DEBUGGER
    mg_debuggerActive= debuggerActive;                    // store here to write
#endif

    RegDataVersion= CURRENT_REGISTRY_VERSION;
    i = 0;
    while ( TraceFlagItemTable[i].status != NO_CMD)
    {
        if ( TraceFlagItemTable[i].status == JVM_GLOBAL_OPTION)
        {
            if ( TraceFlagItemTable[i].FlagID >= ID_TRACE_DEBUGGER &&
                TraceFlagItemTable[i].FlagID <= ID_TRACE_MIDP20)
            {
#ifndef _UNICODE
        GET_APP()->WriteProfileInt(cStrjavaOptions, TraceFlagItemTable[i].RegistryString, *(TraceFlagItemTable[i].FlagPtr));
#else
        USES_CONVERSION;
        GET_APP()->WriteProfileInt(cStrjavaOptions, A2W(TraceFlagItemTable[i].RegistryString), *(TraceFlagItemTable[i].FlagPtr));
#endif
            }
            else
            WriteRegistry(mg_hKey, mg_MainKey, TraceFlagItemTable[i].RegistryString, *(TraceFlagItemTable[i].FlagPtr) );
        }

        if ( TraceFlagItemTable[i].status == JVM_LOCAL_OPTION)
            WriteRegistry(mg_hKey, mg_SubKey, TraceFlagItemTable[i].RegistryString, *(TraceFlagItemTable[i].FlagPtr) );
        i++;
    }

    if (mg_Tracing == FALSE)  SetTracing(FALSE);
    GetOrSetInstallPath();
}


void CMMIDispWindow::GetAllDataFromRegistry()
{
    int    result, i= 0;
    char   RegString[ 32]= "\0";
    float  g;
    CString cStrjavaOptions = "Options\\Java Debug Trace";
#ifdef JAVA_SDK
    char  szValue[JAVA_MAX_PROPERTY_LEN];
    char *pcProductName = NULL;
    pcProductName = getSystemProperty ("microedition.platform", szValue);
    
    if (pcProductName != NULL)
    {
        cStrjavaOptions = CString(pcProductName) + "\\" + cStrjavaOptions;
    }
#endif  

    while ( TraceFlagItemTable[i].status != NO_CMD)
    {
        if ( TraceFlagItemTable[i].FlagID >= ID_TRACE_DEBUGGER &&
             TraceFlagItemTable[i].FlagID <= ID_TRACE_NETWORKING)
        {
#ifndef _UNICODE
        *(TraceFlagItemTable[i].FlagPtr) = GET_APP()->GetProfileInt(cStrjavaOptions,TraceFlagItemTable[i].RegistryString,0);
#else
        USES_CONVERSION;
        *(TraceFlagItemTable[i].FlagPtr) = GET_APP()->GetProfileInt(cStrjavaOptions, A2W(TraceFlagItemTable[i].RegistryString),0);
#endif
        }
        else
        {
        *(TraceFlagItemTable[i].FlagPtr)= ReadSimulatorRegistry( TraceFlagItemTable[i].RegistryString, result);
        }
        i++;
    }

#if ENABLE_JAVA_DEBUGGER
    if ( mg_debuggerActive == TRUE)     // read from registry as "int"
        debuggerActive= TRUE;
    else
        debuggerActive= FALSE;
#endif

    GetOrSetInstallPath();

    ReadSimulatorRegistryString ( "MonitorGamma", RegString, result);
    if ( RegString[0] != '\0' )
    {
        result= sscanf( RegString, "%f", &g);
        if ( result == 1)
            MonitorGamma= g;
    }

    ReadSimulatorRegistryString ( "LCD_Colors", RegString, result);
    if ( RegString[0] != '\0' )
    {
        result= sscanf( RegString, "%f", &g);
        if ( result == 1)
            RealColors= g != 0 ? TRUE : FALSE;
    }
}


void CMMIDispWindow::MakeButtonsVisible(CDC *dc)
{
    CBrush    cbrBtn;
    CPen      cPenBtn, cPenGrid; 
    int       i, zoom;

    cbrBtn.CreateSolidBrush(RGB(255,0, 0));
    cPenBtn.CreatePen(PS_SOLID, 1, RGB(255, 255, 0));
    cPenGrid.CreatePen(PS_SOLID, 1, RGB(195, 204, 230));

    dc->SelectObject(&cbrBtn);
    dc->SelectObject(&cPenBtn);

    zoom = DispGetPixelWidthZoom(E_DISP_MAIN);

     for( i= 0; i< NUMBEROF(Keys); i++)
    {
        dc->Rectangle(zoom * Keys[i].bounds.x,  zoom * Keys[i].bounds.y,
                     zoom *(Keys[i].bounds.x + Keys[i].bounds.width),
                     zoom *(Keys[i].bounds.y + Keys[i].bounds.height));
    }

    dc->SelectObject(&cPenGrid);

    for ( i= 20; i< (zoom*NormalWidth); i+= 20)
    {
        dc->MoveTo(i, 0);
        dc->LineTo(i, zoom * NormalHeight);
    }

    for ( i= 20; i< (zoom*NormalHeight); i+= 20)
    {
        dc->MoveTo(0, i);
        dc->LineTo(zoom * NormalWidth, i);
    }
}


void CMMIDispWindow::Paint(CDC & dc)
{
    CDC         memDC;
    COLORREF    act_color;
    CBrush      cbrBtn;
    CPen        cPenBtn;  
    UINT        uiWidth;
    UINT        uiHeight;
    BITMAPINFO  *pBmiDisplay   = NULL;
    HBITMAP     imgDisplay     = NULL;
    COLORREF    *pPixels       = NULL;
    int         iDisplayWidth  = DispGetWidth(E_DISP_MAIN);
    int         iDisplayHeight = DispGetHeight(E_DISP_MAIN); 
    int         iZoomHeight    = DispGetPixelHeightZoom(E_DISP_MAIN);
    int         iZoomWidth     = DispGetPixelWidthZoom(E_DISP_MAIN);

    memDC.CreateCompatibleDC(&dc);

    ///////////////////////////////////////////////////////////////////////////
    // let's make at first a clean DC (like a clean white paper)             //
    ///////////////////////////////////////////////////////////////////////////
    uiWidth  = NormalWidth  * iZoomHeight;
    uiHeight = NormalHeight * iZoomWidth;
    cbrBtn.CreateSolidBrush(RGB(255,255, 255));
    cPenBtn.CreatePen(PS_SOLID, 1, RGB(255, 255, 255));
    dc.SelectObject(&cbrBtn);
    dc.SelectObject(&cPenBtn);
    dc.Rectangle(0,0,uiWidth,uiHeight);


    ///////////////////////////////////////////////////////////////////////////
    // now let's draw  the phone bitmap (skin)                               //
    ///////////////////////////////////////////////////////////////////////////
    if (m_HSkinImg != NULL)
    {
        if (NULL != memDC.SelectObject(m_HSkinImg))
        {
          
            if(GlobalUiStyle == SHAPED_UI && m_bIsVibrating)
            {
                dc.BitBlt(0, 0, emulatorWidth, emulatorHeight, &memDC, 0, 0,SRCCOPY);  
            }
            else
            dc.BitBlt(m_uiX, 0, emulatorWidth, emulatorHeight, &memDC, 0, 0,SRCCOPY);

            if (m_bIsVibrating)
                Beep(m_uiX*350,1);

            m_cDynLightManager.Paint(&dc, iZoomWidth);   

            //if you want see the coordinates of skin file than uncomment the line below
            //MakeButtonsVisible(&dc);
        }
    }


    
    ///////////////////////////////////////////////////////////////////////////
    // let's draw the display of the mobile phone                            //
    ///////////////////////////////////////////////////////////////////////////
    pBmiDisplay = (BITMAPINFO *)new char[sizeof(BITMAPINFO)]; 

    pBmiDisplay->bmiHeader.biSize          = sizeof(BITMAPINFOHEADER);
    pBmiDisplay->bmiHeader.biWidth         = iDisplayWidth;
    pBmiDisplay->bmiHeader.biHeight        = -iDisplayHeight;      
    pBmiDisplay->bmiHeader.biPlanes        = 1;
    pBmiDisplay->bmiHeader.biBitCount      = 32;
    pBmiDisplay->bmiHeader.biCompression   = BI_RGB;
    pBmiDisplay->bmiHeader.biSizeImage     = 0;
    pBmiDisplay->bmiHeader.biXPelsPerMeter = 0;
    pBmiDisplay->bmiHeader.biYPelsPerMeter = 0;
    pBmiDisplay->bmiHeader.biClrUsed       = 0;
    pBmiDisplay->bmiHeader.biClrImportant  = 0;

    // Create the display bitmap in memory
    imgDisplay = CreateDIBSection(memDC.m_hDC, pBmiDisplay, DIB_RGB_COLORS, (void **)&pPixels, NULL, 0);

    for (int y = 0; y < iDisplayHeight; y++)
    {
        for (int x = 0; x < iDisplayWidth; x++)
        {
            DispGetPixel(E_DISP_MAIN, x, y, &act_color);
            // set "BGR" from given "RGB" value:
            *pPixels = (act_color & 0x00ff00) | (act_color >> 16) | ((act_color & 0xff) << 16);
            pPixels++;
        }
    }

    // feedback for L1 Display Driver Simulation
    DispClearDispBufferBusy(E_DISP_MAIN);

    if (imgDisplay != NULL)
    {
        int iX, iY;
        memDC.SelectObject(imgDisplay);

        if (iZoomWidth == 1 && iZoomHeight == 1)
        {
            if (!SkinShown)
            {
                iX = iY = 2;
            }
            else
            {
                iX = x_offset; 
                iY = y_offset;
            }

            dc.BitBlt(iX, iY, iDisplayWidth, iDisplayHeight, &memDC, 0, 0,SRCCOPY);
        } 
        else
        {
            if (!SkinShown)
            {
                iX = iY = 2;
            }
            else
            {
                iX = x_offset * iZoomWidth;
                iY = y_offset * iZoomHeight;   
            }

            dc.StretchBlt(iX, iY, 
                        iDisplayWidth  * iZoomWidth,
                        iDisplayHeight * iZoomHeight,
                        &memDC,0,0,iDisplayWidth,iDisplayHeight, SRCCOPY);
        }        
            DeleteObject(imgDisplay);
    }    
    if (pBmiDisplay)
        delete pBmiDisplay;
    if(!memDC)
        DeleteDC(memDC);
    
    
}

LRESULT CMMIDispWindow::OnVibraCtrl(WPARAM wParam, LPARAM lParam)
{
    m_uiXVibra       = HIWORD(wParam);
    m_uiVibraTimeOut = LOWORD(wParam);
    m_bIsVibrating   = m_uiXVibra?TRUE:FALSE;

    SetTimer(VIBRA_CTRL_TIMER, m_uiVibraTimeOut, 0);
    return 0;
}

extern "C" void VibraCtrl_Simu(unsigned int uiXVibra, unsigned int uiVibraTimeOut)
{
    ::SendMessage(GetMMIDispHandle(),WM_VIBRA_CTRL, MAKEWPARAM(uiVibraTimeOut, uiXVibra),0);
}

extern "C" void save_act_screen(void);


void CMMIDispWindow::SetSkin(int NewSkinID)
{
    char   phoneName[16];

#ifdef JAVA_SDK
    sprintf(SkinData,  "%s.skn", Info_GetProductName());
    sprintf(phoneBitmap,"%s.bmp", Info_GetProductName());
    sprintf(phoneBitmapG,"%sg.bmp", Info_GetProductName());
#endif

    mg_CurrentSkin= NewSkinID;

    if ( mg_CurrentSkin >= 0 && mg_CurrentSkin < numSkins )
    {
        CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;

//modified by duchun for SHAPED_UI
//#ifndef JAVA_SDK
#ifndef USE_SHAPED_UI
            // Menu elements are moved by 1 element
#ifndef _UNICODE
        pFrame->GetMenu()->GetMenuString(mg_CurrentSkin+1, phoneName, 15, MF_BYCOMMAND);   // get name of mobile
#else
        USES_CONVERSION;
        pFrame->GetMenu()->GetMenuString(mg_CurrentSkin+1, A2W(phoneName), 15, MF_BYCOMMAND);   // get name of mobile
#endif
            sprintf(phoneBitmap,  "%s.bmp",  phoneName);
            sprintf(phoneBitmapG, "%sg.bmp", phoneName);

                        if (mg_Magnification == 1)
                        {
                SetSkinProps(skins[mg_CurrentSkin], phoneBitmap);
                        }
                        else
                        {
                             SetSkinProps(skins[mg_CurrentSkin], phoneBitmapG);
                        } 
#else 
            if (GlobalUiSkin == SHAPED_UI_HAVE_SKIN)
            {
                sprintf(phoneName, phoneNameOrg);
            }
            else
            {
                sprintf(phoneName, "hide skin");
            }

            sprintf(phoneBitmap, "%s.bmp", phoneName);
                    sprintf(phoneBitmapG, "%sg.bmp", phoneName);
            
            if (mg_Magnification == 1)
            {
                SetSkinProps(SkinData, phoneBitmap);
            }
            else
            {
                SetSkinProps(SkinData, phoneBitmapG);
            }

    }
    else
    {
            if (GlobalUiSkin == SHAPED_UI_HAVE_SKIN)
            {
                sprintf(phoneName, phoneNameOrg);
            }
            else
            {
                sprintf(phoneName, "hide skin");
            }

            sprintf(phoneBitmap, "%s.bmp", phoneName);
            sprintf(phoneBitmapG, "%sg.bmp", phoneName);
            
            if (mg_Magnification == 1)
            {
                SetSkinProps(SkinData, phoneBitmap);
            }
            else
            {
                SetSkinProps(SkinData, phoneBitmapG);
            }
#endif// JAVA_SDK
    }
//modified by duchun for SHAPED_UI
//#ifndef JAVA_SDK
#ifndef USE_SHAPED_UI
    else
    // fix the bug of flex shell display in 200% mode by Fang Yunchao
    {
       if (mg_Magnification == 1)
    {
          SetSkinProps(SkinData, phoneBitmap);
        }
    else
    {
     SetSkinProps(SkinData, phoneBitmapG);
    }

    }
#endif

//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
    if (GlobalUiStyle == SHAPED_UI)
    {
        SetWindowPos(&wndTop,  0, 0, emulatorWidth, emulatorHeight, NULL);
    }
    else
#endif // JAVA_SDK
    {
        SetWindowPos(&wndTopMost,  0, 0, emulatorWidth, emulatorHeight,
                 SWP_NOZORDER | SWP_NOMOVE);
// Fix  the bug of flex shell display by Fang Yunchao
        g_SetMagnify=TRUE;
           CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;     
        pFrame->Invalidate();
    
    }
}

LRESULT CMMIDispWindow::WindowProc(UINT iMessage, WPARAM wParam, LPARAM lParam)
{
    switch (iMessage)
    {
        case WM_CHAR:
            print_d("WM_CHAR '%c' (%u)\n", wParam, wParam);
            break;
        case WM_DEADCHAR:
            print_d("WM_DEADCHAR '%c' (%u)\n", wParam, wParam);
            break;
        case OBEX_TCP_WINDOWS_MESSAGE:
            (void)obex_tcp_notify(iMessage, wParam, lParam);
            break;

       // case JNFNET_TCP_NOTIFY_MSG:
       //     jnfnet_tcp_notify (iMessage, wParam, lParam);
        //    break;

        case HTTP_TCP_NOTIFY_MSG:
            http_tcp_notify (iMessage, wParam, lParam);
            break;
        case MTT_TCP_NOTIFY_MSG:
            mtt_tcp_notify (iMessage, wParam, lParam);
            break;

        case UPBROWSER_NETEVENT_NOTIFY_MSG:
            /*  lParam contains the occured network-event and error-code
                wParam contains the socket with data waiting for retrieval
             */
            BrowserSim_NetworkEventNotify(lParam, wParam);
            break;
    }

    return CDispWnd::WindowProc(iMessage, wParam, lParam);
}


CMMIDispWindow::~CMMIDispWindow( void )
{
    // free resources and memory:

    int  i;

    for (i= 0; i <= numSkins; i++)
    {
        if (skins[i] != NULL)  free(skins[i] );
    }

    DestroyMenu(hMenu);
#ifdef JAVA_SDK               // free unconnected ressources
    DestroyMenu( hMenuPopupPhones);
#endif

#if ENABLE_JAVA_DEBUGGER
    if ( JavaDebuggerProcessInfo.dwProcessId != 0)
    {
        unsigned long  ExitCode;

        GetExitCodeProcess( JavaDebuggerProcessInfo.hProcess, &ExitCode);
        if (ExitCode == STILL_ACTIVE)
        {
            TerminateProcess  ( JavaDebuggerProcessInfo.hProcess, 0);
            for (int i= 0; i< 5; i++)
            {
                Sleep(100);
                GetExitCodeProcess( JavaDebuggerProcessInfo.hProcess, &ExitCode);
                if (ExitCode != STILL_ACTIVE)
                    break;
            }
        }

        if (ExitCode != STILL_ACTIVE)
        {
            CloseHandle( JavaDebuggerProcessInfo.hProcess);
            JavaDebuggerProcessInfo.dwProcessId= 0;
            JavaDebuggerProcessInfo.hProcess   = NULL;
        }
    }
#endif
}

/**
 *  The framework calls this member function when an application
 *  requests that the Windows window be created. The function calls
 *  InitMenuAndSkin function.
 *
 *  @return  int: OnCreate must return 0 to continue
 *                the creation of the CWnd object. If the application
 *                returns -1, the window will be destroyed.
 */
int CMMIDispWindow::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CDispWnd::OnCreate(lpCreateStruct) == -1)
        return -1;

    InitMenuAndSkin();

#ifdef JAVA_SDK
//  isAutoPopupSMTKTool=1;
//  Begin check the output window auto popup registry key 
    
    char chToolWndName[] = "mg_ToolWndPopup";
    char chValue[MAX_PATH] ;
    int iResult = 0;

    ReadRegistryString(mg_hKey,mg_MainKey,chToolWndName,chValue,iResult);

    if(iResult != ERROR_SUCCESS)
    {
        strcpy(chValue,"1");
        iResult = WriteRegistryString( mg_hKey,mg_MainKey,chToolWndName,chValue);
        mg_autoPopupOutputWnd = 1;
    }
    else
    {
        if(chValue[0] == '1')
        {
            mg_autoPopupOutputWnd = 1;
        }
        else
        {
            mg_autoPopupOutputWnd = 0;
        }
    }
////end check
#endif
    DragAcceptFiles(TRUE);
    return 0;
}

void CMMIDispWindow::OnSize(UINT nType, int cx, int cy)
{
    CDispWnd::OnSize(nType, cx, cy);
    RECT clientrect;
    RECT winrect;

    print_d("Windowsize: %d %d\n\n",cx, cy);
    skinpainted = 0;
// fix the bug of flex shell display by Fang Yunchao
    int tempMagnification=mg_Magnification;
    if (nType == SIZE_MAXIMIZED || nType == SIZE_RESTORED )
    {
        GetClientRect(&clientrect);
        GetWindowRect(&winrect);

        // set magnification due to window size:
//add by duchun for flexshell neo2 
        
    if (GlobalUiStyle != SHAPED_UI)       
    {
       if(mg_FlexShellType != 2)
       {   
            if (DispGetDirection() == disp_dir_horizontal)
            {
                mg_Magnification= (int) (1.0 * (cx +9) / NormalWidth);
            }
            else
            {
                mg_Magnification= (int) (1.0 *  (cx +9) / NormalHeight);
            }
        }
        else
        {
            if(m_bFlexShellClose)
            {
                if (DispGetDirection() == disp_dir_horizontal)
               {
                    mg_Magnification= (int) (1.0 * (cx +9) / NormalWidth);
               }
               else
              {
                    mg_Magnification= (int) (1.0 *  (cx +9) / NormalHeight);
              }
            }
            else
            {
               if (DispGetDirection() == disp_dir_horizontal)
               {
                 mg_Magnification= (int) (1.0 * (cx +9) / NormalHeight);
               }
               else
               {
                 mg_Magnification= (int) (1.0 *  (cx +9) / NormalWidth );
               }
            }
          }
    }

        if (mg_Magnification > 2 && SkinShown == TRUE)     // phone skins can display 1x or 2x only
            mg_Magnification= 2;

        if (mg_Magnification < 1)  mg_Magnification= 1;

        WriteVariablePermanentToRegistry( mg_Magnification);
        DispSetPixelWidthZoom (E_DISP_MAIN,mg_Magnification);
        DispSetPixelHeightZoom(E_DISP_MAIN,mg_Magnification);
// fix the bug of flex shell display by Fang Yunchao
    if(g_SetMagnify)
    {
        mg_Magnification=tempMagnification;
        g_SetMagnify=FALSE;
    }

#if defined (JAVA_SDK) || defined (USE_SHAPED_UI)
        if (mg_Magnification == 1)
        {
            SetSkinProps(SkinData, phoneBitmap);  
        }
        else
        {
            SetSkinProps(SkinData, phoneBitmapG);
        }
#else
     if (mg_Magnification == 1)
        {
            SetSkinProps(skins[mg_CurrentSkin], phoneBitmap);  
        }
        else
        {
            SetSkinProps(skins[mg_CurrentSkin], phoneBitmapG);
        }
#endif
    }
}

void CMMIDispWindow::OnPaint()
{
    CPaintDC dc(this);
    CBitmap  bitmap;
    CDC      dcMem;
    UINT     uiWidth;
    UINT     uiHeight;

    uiWidth  = NormalWidth  * DispGetPixelWidthZoom(E_DISP_MAIN);
    uiHeight = NormalHeight * DispGetPixelWidthZoom(E_DISP_MAIN);

    if( dcMem.CreateCompatibleDC( &dc ) ) 
    {       
        bitmap.CreateCompatibleBitmap(&dc, uiWidth, uiHeight);
        CBitmap* pOldBitmap = dcMem.SelectObject(&bitmap);
 
        Paint(dcMem);

              
        dc.BitBlt(m_uiX,
                  0,
                  uiWidth,
                  uiHeight,
                  &dcMem,
                  m_uiX,
                  0,
                  SRCCOPY );
       GdiFlush();
    }
    DeleteObject(bitmap); 
    DeleteDC(dc);
    DeleteDC(dcMem);
}
  
BOOL CMMIDispWindow::OnEraseBkgnd(CDC* pDC) 
{
    if (m_bIsVibrating && GlobalUiStyle == SHAPED_UI)
    {
        g_bIsSpapedUIVibrating = true;
        return FALSE;
    }
    else
    {
        g_bIsSpapedUIVibrating = false;
        return CWnd::OnEraseBkgnd(pDC);
    }
}

void CMMIDispWindow::OnDestroy()
{
    CDispWnd::OnDestroy();
    DestroyMenu(hMenu);
    PostQuitMessage(0);
}

void CMMIDispWindow::OnMove(int x, int y)
{
    CDispWnd::OnMove(x, y);
    HelperMessageHandler();
}

void CMMIDispWindow::OnMoving(UINT fwSide, LPRECT pRect)
{
    CDispWnd::OnMoving(fwSide, pRect);
    HelperMessageHandler();
}

void CMMIDispWindow::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized)
{
    CDispWnd::OnActivate(nState, pWndOther, bMinimized);
    HelperMessageHandler();
}

void CMMIDispWindow::OnNcPaint()
{
    HelperMessageHandler();
    // Do not call CDispWnd::OnNcPaint() for painting messages
}

void CMMIDispWindow::OnShowWindow(BOOL bShow, UINT nStatus)
{
    CDispWnd::OnShowWindow(bShow, nStatus);
    HelperMessageHandler();
}

void CMMIDispWindow::OnWindowPosChanging(WINDOWPOS FAR* lpwndpos)
{
    CDispWnd::OnWindowPosChanging(lpwndpos);
    HelperMessageHandler();
}


void CMMIDispWindow::OnToolbarSwitchoff()
{
    KeyboardKeyDown(VK_F1);
    KeyboardKeyUp(VK_F1);  
    MMI_ExitReq();      // kremni
}

void CMMIDispWindow::OnToolbarPhonebook()
{
    KeyboardKeyDown(VK_F2);
    KeyboardKeyUp(VK_F2);    
}

void CMMIDispWindow::OnToolbarDial()
{
    KeyboardKeyDown(VK_F3);
    KeyboardKeyUp(VK_F3); 
}

void CMMIDispWindow::OnToolbarHangup()
{
    KeyboardKeyDown(VK_F4);
    KeyboardKeyUp(VK_F4);
}

void CMMIDispWindow::OnToolbarSoftkey1()
{
    KeyboardKeyDown(VK_F5);
    KeyboardKeyUp(VK_F5);
}

void CMMIDispWindow::OnToolbarSoftkey2()
{
    KeyboardKeyDown(VK_F6);
    KeyboardKeyUp(VK_F6);
}

void CMMIDispWindow::OnToolbarSoftkey3()
{
    KeyboardKeyDown(VK_F7);
    KeyboardKeyUp(VK_F7);
}

void CMMIDispWindow::OnToolbarSoftkey4()
{
    KeyboardKeyDown(VK_F8);
    KeyboardKeyUp(VK_F8);
	
	//jerry_starts for blinking effect
	mg_StartBlinking = TRUE;//jerry_ends
}

//Added jerry
void CMMIDispWindow::OnToolbarSoftkey5()
{
    mg_StartBlinking = FALSE;
}

void CMMIDispWindow::OnToolbarInsertSim()
{
    simulate_sim_connect();
}

void CMMIDispWindow::OnToolbarStart()
{
    KeyboardKeyDown(VK_F10);
    KeyboardKeyUp(VK_F10);
}

void CMMIDispWindow::OnToolbarVm()
{
    KeyboardKeyDown(VK_F11);
    KeyboardKeyUp(VK_F11);
}

void CMMIDispWindow::OnToolbarRemoveSim()
{
    simulate_sim_release();
}

/**
 *  Menu function to set requested skin. This function matches ID range
 *  from ID_SKIN1 to ID_SKIN_8. If the requested skin is already shown than /n
 *  nothing.
 *
 *  @param   nID: id of requested skin
 */
void CMMIDispWindow::OnSetSkin(UINT nID )
{
    // Menu elements are moved by 1 element. Skin ID's start by 1 because
    // MFC doesn't support ID=0 !!
    nID = nID-1;

    ASSERT(nID >= ID_SKIN1 && nID <= ID_SKIN8);

//modified by duchun for SHAPED_UI
//#ifndef JAVA_SDK  
#ifndef USE_SHAPED_UI
    // We don't need to change the skin if requested skin is the same as mg_CurrentSkin
    if (mg_CurrentSkin != (int)nID)
    {
        SetSkin(nID);
        WriteVariablePermanentToRegistry( mg_CurrentSkin);
        ReSizeDockingWnd();
    }
#else
    //if (mg_CurrentSkin != (int)nID)
    {
        SetSkin(nID);
        WriteVariablePermanentToRegistry( mg_CurrentSkin);
        ReSizeDockingWnd();
    }

#endif
}
/**
 *  Menu function to set realcolor state.
 */
void CMMIDispWindow::OnRealColor()
{
    RealColors ^= TRUE;
    ToggleTraceItemState(ID_REAL_COLOR, MFS_CHECKED);
    DispRepaint( E_DISP_MAIN, 0, 0, DispGetWidth(E_DISP_MAIN), DispGetHeight(E_DISP_MAIN) );
    ReSizeDockingWnd();
}

/**
 * Menu function Search.
 */
/*
void CMMIDispWindow::OnSearch()
{
#ifndef LOCALIZATION_SUPPORT
    MessageBox(_T("Search"),_T("Siemens Mobile Phone Emulator"), MB_OK | MB_SETFOREGROUND); 
#else
    MessageBox(CLocalizationString(IDS_HELP_STR_SEARCH),CLocalizationString(IDS_HELP_STR_TITLE), MB_OK | MB_SETFOREGROUND); 
#endif
}
*/
/**
 * Menu function Content.
 */
/*
void CMMIDispWindow::OnContent()
{
#ifndef JAVA_SDK
    AfxMessageBox("Content", MB_OK | MB_SETFOREGROUND);
#else
    char pDir[128];
    int result;
    char mg_RootKey    [64] = "SOFTWARE\\Siemens\\SMTK_3.X";
    HWND m_hHelpwnd = NULL;
    
    ReadRegistryString (mg_hKey, mg_RootKey, "SMTK_ROOT_PATH", pDir, result);
    if ( result == NO_ERROR){
        strcat(pDir,"help\\SMTKHelp.chm");
        CWnd* mainWnd = AfxGetApp()->m_pMainWnd;
        m_hHelpwnd =
            ::HtmlHelpA(
                    mainWnd->m_hWnd,
                    pDir,
                    HH_DISPLAY_TOC,
                    NULL) ;
    }
    if(m_hHelpwnd == NULL || result != NO_ERROR)
#ifndef LOCALIZATION_SUPPORT
        AfxMessageBox(_T("Help Error"),MB_OK,0);
#else
        AfxMessageBox(CLocalizationString(IDS_HELP_ERROR_STR),MB_OK,0);
#endif
#endif //JAVA_SDK    
}
*/
/**
 * Menu function Index.
 *//*
void CMMIDispWindow::OnIndex()
{
#ifndef JAVA_SDK
    AfxMessageBox("Index", MB_OK | MB_SETFOREGROUND);
#else
    char pDir[128];
    int result;
    char mg_RootKey    [64] = "SOFTWARE\\Siemens\\SMTK_3.X";
    HWND m_hHelpwnd = NULL;
    
    ReadRegistryString (mg_hKey, mg_RootKey, "SMTK_ROOT_PATH", pDir, result);
    if ( result == NO_ERROR){
        strcat(pDir,"help\\SMTKHelp.chm");

        CWnd* mainWnd = AfxGetApp()->m_pMainWnd;
        m_hHelpwnd = ::HtmlHelpA(mainWnd->m_hWnd,
                                pDir,
                                HH_DISPLAY_INDEX,
                                NULL) ;
    }
    if(m_hHelpwnd == NULL || result != NO_ERROR)
#ifndef LOCALIZATION_SUPPORT
        AfxMessageBox( _T("Help error"),MB_OK,0);
#else
        AfxMessageBox( CLocalizationString(IDS_HELP_ERROR_STR),MB_OK,0);

#endif
#endif //JAVA_SDK
}
*/
/*
** Menu function User Manual
*/
void CMMIDispWindow::OnUserManual()
{
    #ifndef JAVA_SDK
    AfxMessageBox("User's Manual", MB_OK | MB_SETFOREGROUND);
#else
    char pDir[WFS_MAX_PATH] = {""};
//  char pDefDir[WFS_MAX_PATH] = { ""}; 
    int result;
    char mg_RootKey    [64] = "SOFTWARE\\Siemens\\SMTK_3.X";
    HWND m_hHelpwnd = NULL;
    HINSTANCE hInst = NULL;
    
    ReadRegistryString (mg_hKey, mg_RootKey, "SMTK_ROOT_PATH", pDir, result);
    if ( result == NO_ERROR)
    {
        
        strcat(pDir,"help\\user_manual.pdf");
//      strcat(pDefDir, "help");
        CWnd* mainWnd = AfxGetApp()->m_pMainWnd;
        hInst = ::ShellExecute( mainWnd->m_hWnd,
                                NULL,
                                LPCTSTR(pDir),
                                NULL,
                                NULL,
                                SW_SHOW );

    }
    DWORD dwMark = (DWORD)hInst;
    if(result == NO_ERROR)
    {
        if(dwMark <= 32)
        {
            switch(dwMark)
            {
            case ERROR_PATH_NOT_FOUND:
            case ERROR_FILE_NOT_FOUND:
                MessageBox(_T("User's Manual not found.\r\nPlease repair your SMTK Core Pack installation or download the latest version from www.siemens.com/smtk"),_T("User's Manual Error"), MB_OK);
                break;
            case SE_ERR_NOASSOC:
                MessageBox(_T("Adobe(r) Reader(r) is not installed.\r\nThe User's Manual cannot be opened. Please install the latest Adobe(r) Reader(r) version available from adobe.com"),_T("Adobe(r) Reader(r) Error"),MB_OK);
                break;
            default:
                MessageBox(_T("User's Manual cannot be opened. Unknown Error."),_T("User's Manual Error"),MB_OK);
            }
        }
    }
#endif 
}
/**
 * Menu function About.
 */
void CMMIDispWindow::OnAbout()
{
#ifndef LOCALIZATION_SUPPORT
    char msg[256];
    sprintf( msg, "This Siemens AG Phone Emulator\n");                       //edit by guantianyi to change the About DLG information 2004-12-08
    sprintf( msg, "%swas built on %s at %s.\n\n", msg, __DATE__, __TIME__);
    sprintf( msg, "%sSiemens AG, Munich, Germany            \n", msg);
    sprintf( msg, "%swww.siemens.com/smtk\n\n", msg); 
    sprintf( msg, "%s                                          (C) 2004\n", msg);
#ifdef JAVA_SDK
    MessageBox(msg,_T("About Siemens AG Phone Emulator"), MB_OK | MB_SETFOREGROUND);    
#else
    AfxMessageBox(msg, MB_OK | MB_SETFOREGROUND);
#endif
#else
    TCHAR msg[256];
    _stprintf( msg,  CLocalizationString(IDS_ABOUT_HELP_STR1));
    _stprintf( msg,  CLocalizationString(IDS_ABOUT_HELP_STR2), msg,_T(__DATE__),_T(__TIME__));
    _stprintf( msg, CLocalizationString(IDS_ABOUT_HELP_STR3), msg);
#ifdef JAVA_SDK    
    _stprintf( msg, CLocalizationString(IDS_ABOUT_HELP_STR4), msg);
#else
    _stprintf( msg, CLocalizationString(IDS_ABOUT_HELP_STR5), msg);
#endif
    _stprintf( msg,  CLocalizationString(IDS_ABOUT_HELP_STR6), msg);
#ifdef JAVA_SDK
    MessageBox(msg, CLocalizationString(IDS_ABOUT_HELP_STR7), MB_OK | MB_SETFOREGROUND);    
#else
    AfxMessageBox(msg, MB_OK | MB_SETFOREGROUND);
#endif
#endif
}

/**
 *Menu function Tools->options
 *add by sunmin for show option window in mdv and shaped UI
 */
void CMMIDispWindow::OnShowOptionsDlg()
{
    int nResponse = ((CMainFrame*) GET_APP()->m_pMainWnd)->m_cOptionsdlg.DoModal();
}

/**
 *Menu function Tools->Change Windows UI Language
 *add by Fang Yunchao for show change windows UI Language window in SMTK Localization version
 */
#ifdef LOCALIZATION_SUPPORT
afx_msg void CMMIDispWindow::ChangeUILanguageOption()
{
    CChangeUILanguageDlg dlg(NULL);
    dlg.DoModal();
}
#endif

/**
 *  Function to set Tracemenu state. It uses command range  from
 *  ID_TRACE_MEMORYALLOCATION to ID_TRACE_NETWORKING.
 *
 *  @param   nID: ID of command range
 */
void CMMIDispWindow::OnTraceMenu(UINT nID)
{
    ASSERT(nID >= ID_TRACE_DEBUGGER && nID <= ID_TRACE_NETWORKING);

    UINT i= 0;
    while ( TraceFlagItemTable[i].status != '\0' )
    {
        if ( TraceFlagItemTable[i].FlagID == (int)nID )
        {
            *(TraceFlagItemTable[i].FlagPtr) ^= TRUE;
            ToggleTraceItemState(nID, MFS_CHECKED);
            WriteVariablePermanentToRegistry( *(TraceFlagItemTable[i].FlagPtr));
            break;
        }
        i++;
    }
}

/**
 *  Menu function to set trace state.
 */
void CMMIDispWindow::OnTrace1()
{
    EventToggleDebugging();
    WriteVariablePermanentToRegistry( mg_Tracing);
}

void CMMIDispWindow::OnTraceMenuInterface(UINT nID)
{
    OnTraceMenu(nID);
}
/**
 *  Menu function to set showerror state.
 */
void CMMIDispWindow::OnShowErrors()
{
    mg_ShowErrorMessages ^= TRUE;
    ToggleTraceItemState(ID_SHOW_ERRORS, MFS_CHECKED);
    // No need to save the value in to the regsitry as Show Error will be activated by default.
    //WriteVariablePermanentToRegistry( mg_ShowErrorMessages);
}

/**
 *  Menu function to set showinfo state.
 */
void CMMIDispWindow::OnShowInfos()
{
    mg_ShowInfoMessages ^= TRUE;
    ToggleTraceItemState(ID_SHOW_INFOS, MFS_CHECKED);
    WriteVariablePermanentToRegistry( mg_ShowInfoMessages);
}

/**
 *  Menu function to set ModeCharge state.
 */
void CMMIDispWindow::OnModeCharge()
{
    mg_MMIMode = e_charge_mode;
    SetTraceItemState(ID_MODE_ALARM,  MFS_UNCHECKED);
    SetTraceItemState(ID_MODE_CHARGE, MFS_CHECKED);
    SetTraceItemState(ID_MODE_NORMAL, MFS_UNCHECKED);
    WriteVariablePermanentToRegistry( (int &) mg_MMIMode);
}

/**
 *  Menu function to set ModeNormal state.
 */
void CMMIDispWindow::OnModeNormal()
{
    mg_MMIMode = e_normal_mode;
    SetTraceItemState(ID_MODE_ALARM,  MFS_UNCHECKED);
    SetTraceItemState(ID_MODE_CHARGE, MFS_UNCHECKED);
    SetTraceItemState(ID_MODE_NORMAL, MFS_CHECKED);
    WriteVariablePermanentToRegistry( (int &) mg_MMIMode);
}

/**
 *  Menu function to set ModeAlarm state.
 */
void CMMIDispWindow::OnModeAlarm()
{
    mg_MMIMode = e_alarm_mode;
    SetTraceItemState(ID_MODE_ALARM,  MFS_CHECKED);
    SetTraceItemState(ID_MODE_CHARGE, MFS_UNCHECKED);
    SetTraceItemState(ID_MODE_NORMAL, MFS_UNCHECKED);
    WriteVariablePermanentToRegistry( (int &) mg_MMIMode);
}

/**
 *Menu function to close flexshell
 */
void CMMIDispWindow::OnFlexshellClose()
{

    int iMainMenuOpen = 0;
    //middle -> close
    if (m_bFlexShellMiddle)
    {
        KeyboardButtonDown(SW0ON); 
        KeyboardButtonUp(SW0ON); 
    }

    //open -> middle -> close
    if (m_bFlexShellOpen)
    {
        KeyboardButtonDown(SW1OFF); 
        KeyboardButtonUp(SW1OFF);
        KeyboardButtonDown(SW0ON); 
        KeyboardButtonUp(SW0ON);
    }

    m_bFlexShellClose  = TRUE;
    m_bFlexShellMiddle  = FALSE;
    m_bFlexShellOpen   = FALSE;
// fix the bug of flex shell display by Fang Yunchao
    g_SetMagnify=TRUE;
#ifdef USE_SHAPED_UI
    SetMenuItemState(hMenuView,ID_FLEXSHELL_CLOSE,  MFS_CHECKED|MFS_DISABLED );
    SetMenuItemState(hMenuView, ID_FLEXSHELL_OPEN,  MFS_UNCHECKED|MFS_ENABLED );
   // SetMenuItemState(hMenuView, ID_FLEXSHELL_MIDDLE,  MFS_UNCHECKED|MFS_ENABLED );     
        
    if(GlobalUiStyle == PC_SIMU_USE_NEW_UI)
    {
        CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;       
        pFrame->GetWindowRect(m_rcFrame); 
        OnGoToDockedWin();
        m_bTransparent = FALSE;
        SetSkin(0);
    }
    else
    {
        if(GobalMainMenuOpened)
        {
            OnMainMenuClose();
            iMainMenuOpen = 1;
        }
        OnGotoShapedUi();
        if(iMainMenuOpen)
        {
            OnMainMenuOpen();
            iMainMenuOpen = 0;
        }

    }
#endif
}

/**
 *Menu function to open flexshell
 */
void CMMIDispWindow::OnFlexshellOpen()
{
    int iMainMenuOpen = 0;
    //middle -> open
    if (m_bFlexShellMiddle)
    {
        KeyboardButtonDown(SW1ON); 
        KeyboardButtonUp(SW1ON); 
    }

    // close -> middle -> open
    if (m_bFlexShellClose)
    {
        KeyboardButtonDown(SW0OFF); 
        KeyboardButtonUp(SW0OFF);
        KeyboardButtonDown(SW1ON); 
        KeyboardButtonUp(SW1ON);
    }
// fix the bug of flex shell display by Fang Yun chao
    g_SetMagnify=TRUE;
    m_bFlexShellClose  = FALSE;
    m_bFlexShellMiddle  = FALSE;
    m_bFlexShellOpen   = TRUE;
#ifdef USE_SHAPED_UI
    SetMenuItemState(hMenuView,ID_FLEXSHELL_CLOSE,  MFS_UNCHECKED|MFS_ENABLED );
    SetMenuItemState(hMenuView, ID_FLEXSHELL_OPEN,  MFS_CHECKED|MFS_DISABLED );
  //  SetMenuItemState(hMenuView, ID_FLEXSHELL_MIDDLE,  MFS_UNCHECKED|MFS_ENABLED );    
    if(GlobalUiStyle == PC_SIMU_USE_NEW_UI)
    {
        CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;       
        pFrame->GetWindowRect(m_rcFrame);        
        OnGoToDockedWin();
        m_bTransparent = FALSE;
        SetSkin(0);
    }
    else
    {
        //if main menu opened, close it.
        if(GobalMainMenuOpened)
        {
            OnMainMenuClose();
            iMainMenuOpen = 1;
        }
        OnGotoShapedUi();
        if(iMainMenuOpen)
        {
            OnMainMenuOpen();
            iMainMenuOpen = 0;
        }
    }
#endif
}

/**
 *Menu function to middle flexshell
 */
void CMMIDispWindow::OnFlexshellMiddle()
{

     //close -> middle
    if (m_bFlexShellClose)
    {
        KeyboardButtonDown(SW0OFF); 
        KeyboardButtonUp(SW0OFF); 
    }

    //open -> middle
    if (m_bFlexShellOpen)
    {
        KeyboardButtonDown(SW1OFF); 
        KeyboardButtonUp(SW1OFF); 
    }

 //   m_bFlexShellClose  = FALSE;
  //  m_bFlexShellMiddle  = TRUE;
   // m_bFlexShellOpen   = FALSE;
#ifdef USE_SHAPED_UI
   // SetMenuItemState(hMenuView,ID_FLEXSHELL_CLOSE,  MFS_UNCHECKED|MFS_ENABLED );
   // SetMenuItemState(hMenuView, ID_FLEXSHELL_OPEN,  MFS_UNCHECKED|MFS_ENABLED );
   // SetMenuItemState(hMenuView, ID_FLEXSHELL_MIDDLE,  MFS_CHECKED|MFS_DISABLED );    
#endif
}

void CMMIDispWindow::OnUpdateFlexshellOpen(CCmdUI* pCmdUI)
{
    pCmdUI->SetCheck (m_bFlexShellOpen);
    pCmdUI->Enable(!m_bFlexShellOpen);
}


void CMMIDispWindow::OnUpdateFlexshellClose(CCmdUI* pCmdUI)
{
    pCmdUI->SetCheck (m_bFlexShellClose);
    pCmdUI->Enable(!m_bFlexShellClose);
}

void CMMIDispWindow::OnUpdateFlexshellMiddle(CCmdUI* pCmdUI)
{
  //  pCmdUI->SetCheck (m_bFlexShellMiddle);
  //pCmdUI->Enable(!m_bFlexShellMiddle);
}

/**
 *  Zoom 100% of mobilephone screen
 */
void CMMIDispWindow::OnMagnify100()
{
// fix bug of flex shell display by Fang Yun chao
    SetMenuItemState(hMenuPopupMag, ID_MAGNIFY_1,  MFS_CHECKED|MFS_DISABLED);
   // if(m_iFlexShellType!=FLEXSHELL_ROTATOR)
   // {
    SetMenuItemState(hMenuPopupMag, ID_MAGNIFY_2,  MFS_UNCHECKED|MFS_ENABLED);
  //  }
    SetMenuItemState(hMenuView,ID_MAGNIFY_1, MFS_CHECKED|MFS_DISABLED);
   // if(m_iFlexShellType!=FLEXSHELL_ROTATOR)
  //  {
    SetMenuItemState(hMenuView,ID_MAGNIFY_2, MFS_UNCHECKED|MFS_ENABLED);
  //  }
#ifdef USE_SHAPED_UI
    /*Keep pos of shaped UI*/
    if(GlobalUiStyle == SHAPED_UI)
        {
            CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;
            pFrame->GetWindowRect(m_rcShapedUI);
        }
#endif
    SetMagnify(1);
}

/**
 *  Zoom 200% of mobilephone screen
 */
void CMMIDispWindow::OnMagnify200()
{
  //  if(m_iFlexShellType!=FLEXSHELL_ROTATOR)
  //  {
    SetMenuItemState(hMenuPopupMag, ID_MAGNIFY_1,  MFS_UNCHECKED|MFS_ENABLED);
    SetMenuItemState(hMenuPopupMag, ID_MAGNIFY_2,  MFS_CHECKED|MFS_DISABLED);
    SetMenuItemState(hMenuView,ID_MAGNIFY_1, MFS_UNCHECKED|MFS_ENABLED);
    SetMenuItemState(hMenuView,ID_MAGNIFY_2, MFS_CHECKED|MFS_DISABLED);
#ifdef USE_SHAPED_UI
    /*for keep pos of shaped UI*/
    if(GlobalUiStyle == SHAPED_UI)
        {
            CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;
            pFrame->GetWindowRect(m_rcShapedUI);
        }
#endif
    SetMagnify(2);
//   }   
}

/**
 *  Zoom 300% of mobilephone screen
 */
void CMMIDispWindow::OnMagnify300()
{
    SetMagnify(3);
}

/**
 *    Update the menu item, if Mobile skin is shown than
 *  disable this menu. We don't support zoom state 300%, 500%, 800%
 *  if skin is shown.
 *
 *  @param   pCmdUI: pointer of CCmdUI class to
 *                   disable or enable menu items
 */
void CMMIDispWindow::OnUpdateMagnify300(CCmdUI* pCmdUI)
{
    pCmdUI->Enable(!SkinShown);
}

/**
 *  Zoom 500% of mobilephone screen
 */
void CMMIDispWindow::OnMagnify500()
{
    SetMagnify(5);
}

/**
 *  Update the menu item, if Mobile skin is shown than
 *  disable this menu. We don't support zoom state 300%, 500%, 800%
 *  if skin is shown.
 *
 *  @param   pCmdUI: pointer of CCmdUI class to
 *                   disable or enable menu items
 */
void CMMIDispWindow::OnUpdateMagnify500(CCmdUI* pCmdUI)
{
    pCmdUI->Enable(!SkinShown);
}

/**
 *  Zoom 800% of mobilephone screen
 */
void CMMIDispWindow::OnMagnify800()
{
    SetMagnify(8);
}

/**
 *  Update the menu item, if Mobile skin is shown than
 *  disable this menu. We don't support zoom state 300%, 500%, 800%
 *  if skin is shown.
 *
 *  @param   pCmdUI: pointer of CCmdUI class to
 *                   disable or enable menu items
 */
void CMMIDispWindow::OnUpdateMagnify800(CCmdUI* pCmdUI)
{
    pCmdUI->Enable(!SkinShown);
}

/**
 *  Helper function to set the zoom state, if the requested zoom state /n
 *  is the same as current state, then do nothing.
 *
 *  @param   uiMagnify: zoom state
 */
void CMMIDispWindow::SetMagnify(int uiMagnify)
{
    // We don't need to resize if we have the same mg_Magnification value
//modified by duchun for SHAPED_UI
//#ifndef JAVA_SDK
    g_SetMagnify=true;//donot adjust mg_Magnification parameter when OnSize message happens
#ifndef USE_SHAPED_UI
    if (mg_Magnification != uiMagnify)
#endif
    {
        mg_Magnification = uiMagnify;
         
        m_Magnify = uiMagnify;

//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
        //if main menu opened, close it.
        OnMainMenuClose();
#endif
        SetSkin(mg_CurrentSkin);

//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
        // set Frame Window for reloading shaped frame
         if (GlobalUiStyle == SHAPED_UI)
         {
            m_Magnify = mg_Magnification;
            
            LoadPhoneSkin(m_Magnify, GlobalUiSkin); 
            
         }
#endif
        WriteVariablePermanentToRegistry( mg_Magnification);
    }
    if (GlobalUiStyle != SHAPED_UI)
    {
        ReSizeDockingWnd();
    }
}

/**
 *    Function to set the debugger flag.
 */
void CMMIDispWindow::OnDebuggerActive()
{
#if ENABLE_JAVA_DEBUGGER
    if (debuggerActive == FALSE)
        debuggerActive = TRUE;
    else
        debuggerActive = FALSE;

    ToggleTraceItemState(ID_DEBUGGER_ACTIVE, MFS_CHECKED);
    mg_debuggerActive = debuggerActive;
    WriteVariablePermanentToRegistry( mg_debuggerActive);
#endif
}


//-------------------------------------------------------------------------------
///////////////// SHAPED UI /////////////////////////////////////////////////////
//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
/** 
 * Main Menu
 */
void CMMIDispWindow::OnMainMenu()
{
    CMainFrame* pFrame=(CMainFrame*)GET_APP()->m_pMainWnd;
    if(GlobalUiStyle == SHAPED_UI)
        {
        if(GobalMainMenuOpened==FALSE)
            {
                    pFrame->m_MainMenuDlg.Create(IDD_SP_UI_PHONE_BODY,NULL);
                    pFrame->ShowWindow(SW_RESTORE);
                    GobalMainMenuOpened = TRUE;
                    SetMenuItemState(hMenuView, ID_MAIN_MENU,MFS_CHECKED);
            MakeActiveWnd();
        }
            else
            {
            pFrame->m_MainMenuDlg.DestroyWindow();
            GobalMainMenuOpened = FALSE;
            SetMenuItemState(hMenuView, ID_MAIN_MENU,MFS_UNCHECKED);
        }
        }
}

void CMMIDispWindow::OnMainMenuOpen()
{

    if (GlobalUiStyle == SHAPED_UI)
    {
        CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;
        pFrame->m_MainMenuDlg.Create(IDD_SP_UI_PHONE_BODY,NULL);
        pFrame->ShowWindow(SW_RESTORE);
        GobalMainMenuOpened = TRUE;
        SetMenuItemState(hMenuView, ID_MAIN_MENU,MFS_CHECKED);
    }
}

/** 
 * Main Menu Close
 */
void CMMIDispWindow::OnMainMenuClose()
{
    if (GlobalUiStyle == SHAPED_UI)
    {
            CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;
        pFrame->m_MainMenuDlg.DestroyWindow();
        GobalMainMenuOpened = FALSE;
        SetMenuItemState(hMenuView, ID_MAIN_MENU,MFS_UNCHECKED);
    }    
}

#endif // JAVA_SDK shaped ui

void CMMIDispWindow::OnKeyDown( UINT nChar, UINT nRepCnt, UINT nFlags )
{
    print_d("WM_KEYDOWN %u\n", nChar);
    switch (nChar)
    {
        case VK_F9:
        {
            simulate_sim_connect();
            return;
        }
        case VK_F12:
        {
            simulate_sim_release();
            return;
        }
//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
        case VK_TAB: // main menu window open and close key
        {

            if (GlobalUiStyle == SHAPED_UI)
            {
                if (GobalMainMenuOpened == FALSE)
                {
                    OnMainMenuOpen();
                    GobalMainMenuOpened = TRUE;
                    MakeActiveWnd(); 
                }
                else
                {
                    OnMainMenuClose();
                    GobalMainMenuOpened = FALSE;
                }
                return;
            }
        }
#endif // JAVA_SDK

        case VK_SHIFT:
        {
            UINT nVKeyCode = MapVirtualKey( nFlags&0x00FF,  // scan code
                                            3 );            // scan code -> virtual key code

            if( nVKeyCode == VK_RSHIFT )
                KeyboardKeyDown(VK_RSHIFT);
            else
                KeyboardKeyDown(VK_LSHIFT);

            return;
        }
        case VK_CONTROL:
        {
            if( nFlags & 0x2000 )
            {
                KeyboardKeyDown(VK_MENU);       // -> Alt Gr
            }
            else
            {
                if( nFlags & 0x0100 )
                    KeyboardKeyDown(VK_RCONTROL);
                else
                    KeyboardKeyDown(VK_LCONTROL);
            }

            return;
        }
        case VK_MENU:
        {
            break;
        }

        default:
        {
            KeyboardKeyDown(nChar);
        }
    }
    CDispWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CMMIDispWindow::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    print_d("WM_KEYUP %u\n", nChar);
    switch (nChar)
    {
        case VK_F9:
        case VK_F12: // don't send to keyboard driver
        {
            return;
        }
        case VK_SNAPSHOT:
        {
            save_act_screen();
            return ;
        }
        case VK_SHIFT:
        {
            UINT nVKeyCode = MapVirtualKey( nFlags&0x00FF,  // scan code
                                            3 );            // scan code -> virtual key code

            if( nVKeyCode == VK_RSHIFT )
                KeyboardKeyUp(VK_RSHIFT);
            else
                KeyboardKeyUp(VK_LSHIFT);

            return;
        }
        case VK_CONTROL:
        {
            if( nFlags & 0x0100 )
                KeyboardKeyUp(VK_RCONTROL);
            else
                KeyboardKeyUp(VK_LCONTROL);

            return;
        }
        case VK_MENU:
        {
            if( nFlags & 0x0100 )
            {
                KeyboardKeyUp(VK_MENU);     // -> only Alt Gr.
                return;
            }
            break;
        }

        default:
        {
            KeyboardKeyUp(nChar);
        }
    }
    CDispWnd::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CMMIDispWindow::OnLButtonDown(UINT nFlags, CPoint point)
{
    // Call LButton Helper  Function
    LButtonUpDown(WM_LBUTTONDOWN, nFlags, point);
    CDispWnd::OnLButtonDown(nFlags, point);
}

void CMMIDispWindow::OnLButtonUp(UINT nFlags, CPoint point)
{
    // Call LButton Helper  Function
    LButtonUpDown(WM_LBUTTONUP, nFlags, point);
    CDispWnd::OnLButtonUp(nFlags, point);
}


/**
 *  Helper function for OnLButtonDown  OnLButtonup functions
 *
 *  @param   iMessage: State variable to get
 *                     WM_LBUTTONDOWN or WM_LBUTTONUP state.
 *  @param   nFlags:   Indicates whether various
 *                     virtual keys are down.
 *  @param   point:    Specifies the x- and y-coordinate
 *                     of the cursor
 */
void CMMIDispWindow::LButtonUpDown(UINT iMessage, UINT nFlags, CPoint point)
{
    MakeActiveWnd();

    int xPos = point.x;  // horizontal position of cursor
    int yPos = point.y;  // vertical position of cursor

    print_d("Mouse buttom action at: %d, %d\n", xPos, yPos);
    for (int i = 0; i < NUMBEROF(Keys); ++i)
    {
        if (INSIDE(xPos, yPos, Keys[i].bounds))
        {
            print_d("Mouse click inside %s\n", Keys[i].name);
            if (Keys[i].button == KEY_New_POWER)
            {
           m_inKeyPos = TRUE;
               DefWindowProc(iMessage, 0, MAKELONG(xPos,yPos));
               break;
            }
            else
            {
                if (iMessage == WM_LBUTTONDOWN)
                {
            m_inKeyPos = TRUE;
                     KeyboardButtonDown(Keys[i].keyCode);
            break;
                }
                else
                {
            m_inKeyPos = TRUE;
                    KeyboardButtonUp(Keys[i].keyCode);
            break;
                }
            }
        }// end of if
    else
    {
        m_inKeyPos = FALSE;
        }
    }// end of for

    if (m_inKeyPos == FALSE)
    {
      //  CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd; 
     AfxGetMainWnd()->PostMessage (WM_NCLBUTTONDOWN, HTCAPTION, MAKELPARAM(point.x,point.y));

    }
}


void CMMIDispWindow::OnTimer(UINT nIDEvent)
{
    switch (nIDEvent)
    {
        case VIBRA_CTRL_TIMER:
        {
            KillTimer(VIBRA_CTRL_TIMER);
            if (m_bIsVibrating)
            {
                if(GlobalUiStyle == SHAPED_UI)
                {
                    CRect rcMain;
                    CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;
                    pFrame->GetWindowRect(rcMain);
                    
                    if (m_uiX == 0)
                    {
                        rcMain.left -= m_uiXVibra;
                    }
                    else
                    {
                        rcMain.left += m_uiX;
                    }

                    pFrame->MoveWindow(rcMain);
                } 
            
                if (m_uiX == m_uiXVibra)
                {
                    m_uiX = 0;
                }
                else
                {
                    m_uiX = m_uiXVibra;
                }

                skinpainted = 0;
                Invalidate(FALSE);
                SetTimer(VIBRA_CTRL_TIMER, m_uiVibraTimeOut,0);
            }
            else
            {
                 m_uiX = 0;
            }
            break;
        }
    }
    CDispWnd::OnTimer(nIDEvent);
}

/**
 *    Helper function to resize mobilephone window. The function will be called
 *    after zoom or change skin function was called.
 */
void CMMIDispWindow::ReSizeDockingWnd(void)
{
    CMobilePhoneScreenWnd* pcMobile  = (CMobilePhoneScreenWnd*)GetOwner();

    if (pcMobile != NULL)
    {
        pcMobile->ReSizeWnd(emulatorWidth+50, emulatorHeight+50);
    }
    MakeActiveWnd();
}

void CMMIDispWindow::HelperMessageHandler(void)
{
    RECT  WinRect;

    GetWindowRect(&WinRect);
    if (mg_EmulatorWinStartX != WinRect.left ||
        mg_EmulatorWinStartY != WinRect.top    )
    {
        mg_EmulatorWinStartX= WinRect.left;
        mg_EmulatorWinStartY= WinRect.top;

        if ( mg_EmulatorWinStartX > -100 &&
             mg_EmulatorWinStartY > -100   )               // don't write if iconifying emulator
        {
            WriteVariablePermanentToRegistry( mg_EmulatorWinStartX);
            WriteVariablePermanentToRegistry( mg_EmulatorWinStartY);
        }
    }
    skinpainted = 0;
}


/**
 *  The function inits menu and skins. Because of some defaults we
 *  initialize menus during the creation, instead of Menu resource file,
 *  of CMMIDispWindow class.
 *
 */
void CMMIDispWindow::InitMenuAndSkin(void)
{
    int    result;

    BACKGROUND_BRUSH= FOREGROUND_BRUSH= NULL;
    BACKGROUND_PEN  = FOREGROUND_PEN  = NULL;
    hScreenBitmap   = NULL;

    mg_Tracing    = TRUE;
    SetTracing(FALSE);      // init. prv. variables
    SetTracing(TRUE);

#if ENABLE_JAVA_DEBUGGER
    // do some initialization for safety

    JavaDebuggerProcessInfo.dwProcessId= 0;
    JavaDebuggerProcessInfo.hProcess   = NULL;
#endif

    RegDataVersion= ReadRegistry(mg_hKey, mg_SubKey, "ValidConfig", result);

    if (RegDataVersion == CURRENT_REGISTRY_VERSION && result == NO_ERROR)
    {
        GetAllDataFromRegistry();
//Sun Min, 2004-11-10: add for com0 redirection
    int result;
    char com0info[50]="\0";
    char *pcName="com0_PC_Port";
    char pcJavaApp[256]="\0";
    strcat(pcJavaApp,mg_SubKey);
    strcat(pcJavaApp,"\\Options\\JavaCOMPorts");
    ReadRegistryString ( mg_hKey, pcJavaApp, pcName, com0info, result);
    if(strcmp(com0info,"Not Set")==0)
    {
            Com0RedirectState=0;
            strcpy(Com0RedirectInfo,"Not Set");                 
    }
    else
    {
        Com0RedirectState=1;
        strcpy(Com0RedirectInfo,com0info);
    }
        SetTracing(FALSE);      // init. prv. variables
    }
    else
    {
        SaveAllDataToPermanentRegistry();
//sun min,2004-11-10: add for com0 redirection

        Com0RedirectState=0;
    strcpy(Com0RedirectInfo,"Not Set");
        char *pcName="com0_PC_Port";
    char *pcValue="Not Set";
    char pcJavaApp[256]="\0";
    strcat(pcJavaApp,mg_SubKey);
    strcat(pcJavaApp,"\\Options\\JavaCOMPorts");
    WriteRegistryString(mg_hKey,pcJavaApp,pcName,pcValue);


        GetAllDataFromRegistry();       // re-read to honour command line settings
    }
#ifndef LOCALIZATION_SUPPORT
    CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;

    // Create menu for MainFrame
    m_cMenu.CreateMenu();
    // Build Menu and the handler
    m_cMenu.m_hMenu = buildSkinsMenu();
    pFrame->GetMenu()->DestroyMenu();

//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
    if (GlobalUiStyle != SHAPED_UI)
#endif
    {
        // Set the created menu to MainFrame's new menu
        pFrame->SetMenu(&m_cMenu);
    }

    SetSkin(mg_CurrentSkin);            // read skin-related values from files
//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
    // Create popup floating menu for MainFrame
    m_cPopMenu.CreateMenu();
    // Build popup floating Menu and the handler
    m_cPopMenu.m_hMenu = buildSkinsPopMenu();
#endif 

    if (mg_Tracing == TRUE)  SetTracing(TRUE);
    SetAllTraceItemState();
#else
    RegenerateMenu();
    SetSkin(mg_CurrentSkin);            // read skin-related values from files
#endif // no LOCALIZATION_SUPPORT
    
}

#ifdef LOCALIZATION_SUPPORT
void CMMIDispWindow::RegenerateMenu(void)
{
    CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;
    if(m_cMenu.m_hMenu != NULL)
        m_cMenu.Detach();
    m_cMenu.CreateMenu();
    // Build Menu and the handler
    m_cMenu.m_hMenu = buildSkinsMenu();
    
    CMenu * pMenu = pFrame->GetMenu();
    if(pMenu)
        pMenu->DestroyMenu();

    // Set the created menu to MainFrame's new menu
    pFrame->SetMenu(&m_cMenu);
    /* 2004/6/17 Fang Yunchao add for SMTK Localization project begin */     
   #ifdef JAVA_SDK
    if(m_cPopMenu.m_hMenu != NULL)
        m_cPopMenu.Detach();
    // Create popup floating menu for MainFrame
    m_cPopMenu.CreateMenu();
    // Build popup floating Menu and the handler
    m_cPopMenu.m_hMenu = buildSkinsPopMenu();
    if(m_cPopMenu.m_hMenu==NULL)
    {
        TRACE(traceAppMsg, 0, "Warning:Create Popup menu failed.\n");
     }
    #endif 
 /* 2004/6/17 Fang Yunchao add for SMTK Localization project end */
    if (mg_Tracing == TRUE)  SetTracing(TRUE);
    SetAllTraceItemState();
}
#endif

void CMMIDispWindow::MakeActiveWnd(void)
{
    SetActiveWindow();
    SetFocus();
}

HWND CMMIDispWindow::GetHandle()
{
    return m_hWnd;
}

CString CMMIDispWindow::GetWorkSubKey()
{
    return (CString)mg_SubKey;
}

HMENU CMMIDispWindow::GetPopupTraceMenu()
{
    return hMenuPopupTrace;
}
BOOL CMMIDispWindow::ReadDrivePathFromRegistry (char driveLetter, char *path, short len)
{
    char keyStr[WFS_MAX_PATH];
    char pathStr[WFS_MAX_PATH];
    int result;

    *path = '\0';

    //create registry key of the file system path
    _snprintf( keyStr,
               sizeof(keyStr),
               "FS_DRIVE_PATH_%c",
               driveLetter);

    // read filesystem path first in the global setting area
    ReadRegistryString (mg_hKey, mg_MainKey, keyStr, pathStr, result);
    if (result != NO_ERROR)
    {//not found
        // read filesystem path in the project setting area
        ReadSimulatorRegistryString( keyStr, pathStr, result);
        if (result != NO_ERROR)
        {
            return FALSE;
        }
        else
        {
            _snprintf( path, len, "%s", pathStr);
            return TRUE; 
        }
    }
    else
    {
        _snprintf( path, len, "%s", pathStr);
        return TRUE;
    }
}

BOOL CMMIDispWindow::ReadDriveSizeFromRegistry (char driveLetter, unsigned long *size)
{
    char keyStr[_MAX_PATH];
    int result;

    *size = 0;

    //create registry key of the drive size
    _snprintf( keyStr,
               sizeof(keyStr),
               "FS_DRIVE_SIZE_%c",
               driveLetter);

    // read drive size first in the global setting area
    *size = (unsigned int) ReadRegistry (mg_hKey, mg_MainKey, keyStr, result);
    if (result != NO_ERROR)
    {//not found
        // read drive size in the project setting area
        *size = (unsigned int) ReadSimulatorRegistry( keyStr, result);
        if (result != NO_ERROR)
        {
            return FALSE;
        }
        else
        {
            return TRUE; 
        }
    }
    else
    {
        return TRUE;
    }
}
BOOL  CMMIDispWindow::WriteDrivePathToRegistry (char driveLetter)
{
    char wfsDrivePath[WFS_MAX_PATH];
    char keyPathString[WFS_MAX_PATH];


    //****** FS_DRIVE_PATH_ registry settings

    //create registry key of the file system path
    _snprintf( keyPathString,
               sizeof(keyPathString),
               "FS_DRIVE_PATH_%c",
               driveLetter);

#ifdef JAVA_SDK
    _snprintf( wfsDrivePath,
               sizeof(wfsDrivePath),
               "%s\\Filesystem\\%c",
               mg_InstallPath,
               driveLetter);
#else
    _snprintf( wfsDrivePath,
               sizeof(wfsDrivePath),
               "%s\\C_mobsim\\Filesystem\\%c",
               mg_InstallPath,
               driveLetter);
#endif

        //create the filesystem path in the project specific area of the registry
        WritePermanentSimulatorRegistryString( keyPathString, wfsDrivePath);

    return TRUE;
}
BOOL CMMIDispWindow::WriteDriveSizeToRegistry (char driveLetter, unsigned long size )
{
    char keySizeString[WFS_MAX_PATH];
    
    //create registry key of the drive size
    _snprintf(  keySizeString,
                sizeof(keySizeString),
                "FS_DRIVE_SIZE_%c",
                driveLetter);

#ifdef JAVA_SDK
    //create the drive size in the project specific area of the registry
    WritePermanentSimulatorRegistry( keySizeString,0x7FFFFFFF);
#else if//PC-SIMU
    //create the drive size in the project specific area of the registry
    WritePermanentSimulatorRegistry( keySizeString, (int) size);
#endif
    return TRUE;
}
void CMMIDispWindow::OnRButtonDown(UINT nFlags, CPoint point)
{

//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
    // floating menu position for mp body 
    if (GlobalUiStyle == SHAPED_UI)
    {
        RECT rc;
        GetWindowRect(&rc);
        
        m_cPopMenu.TrackPopupMenu(TPM_TOPALIGN, \
            rc.left + point.x, \
            rc.top + point.y, this);
    }
#endif
    CDispWnd::OnRButtonDown(nFlags, point);
}

void CMMIDispWindow::OnRButtonUp(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default

    CDispWnd::OnRButtonUp(nFlags, point);
}


void CMMIDispWindow::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    // TODO: Add your message handler code here and/or call default

    CDispWnd::OnChar(nChar, nRepCnt, nFlags);
}


//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
/**
 * For bitmap load and show
 */
void CMMIDispWindow::OnStartJavaApp()
{
    startJavaApplication();
}

/**
 * floating menu command
 */ 
void CMMIDispWindow::OnTerminatingCall()
{
    msm_sim_mtc();
}

/**
 * floating menu command
 */
void CMMIDispWindow::OnDisconnectCallByNet()
{
    msm_sim_disconnect();
}

/**
 * floating menu command
 */
void CMMIDispWindow::OnFullService()
{
    mm_sim_full_service();
}

/**
 * floating menu command
 */
void CMMIDispWindow::OnNoService()
{
    mm_sim_no_service();
}

/**
 * floating menu command
 */
void CMMIDispWindow::OnIncomingShortMessage()
{
    MOPI_ExecuteFunction( NOPROCESS_PID, SMSSIM_IncomingShortMessage_Mopi, (UINT32)0);
}

/**
 * floating menu command
 */
void CMMIDispWindow::OnChooseNetwork()
{
    MOPI_ExecuteFunction( NOPROCESS_PID, cmdChooseNetwork_Mopi, 0 );
}

/**
 *  command for run time heap info
 */
void RunTimeHeapInfo()
{
//2004-11-04 sunmin: modify to show smtk tool utilities in cmd list
#ifdef JAVA_SDK
    CMMIDispWindow *p_DispWindow=(CMMIDispWindow *)GET_APP()->GetMMIDispWindow();
    if(!p_DispWindow->m_hWnd)
        return;
    p_DispWindow->ShowSmtkTool();
#else
    CMainFrame *p_Frame = (CMainFrame *) GET_APP()->m_pMainWnd;
    if (!p_Frame->m_JavaHeapDlg.m_hWnd)
    {
        p_Frame->m_JavaHeapDlg.Create(IDD_SP_JAVA_HEAP, NULL);
        p_Frame->m_JavaHeapDlg.ShowWindow(SW_SHOW);
        CMMIDispWindow * p_Disp = ((CMFC_Simulation_App *)AfxGetApp())->GetMMIDispWindow(); 
        p_Disp->MakeActiveWnd();

    }
#endif
}

/**
 *  command for run time heap info
 */
void CMMIDispWindow::OnRunTimeHeap()
{
 //2004-11-04 Sun Min: modify to enable smtk tool in cmd list
#ifdef JAVA_SDK
    RunTimeHeapInfo();
#endif

}

/**
 * floating menu command
 */
void CMMIDispWindow::OnBeginLowPower()
{
    MOPI_ExecuteFunction( NOPROCESS_PID, PowerAL_Indicate_LowPowerBegin_Mopi, 0 );
}

/**
 * floating menu command
 */
void CMMIDispWindow::OnEndLowPower()
{
    MOPI_ExecuteFunction( NOPROCESS_PID, PowerAL_Indicate_LowPowerEnd_Mopi, 0 );
}

/**
 * floating menu command microedition.locale
 */
void CMMIDispWindow::OnChangeMicroedition()
{

}

/**
 * floating menu command
 */
void CMMIDispWindow::OnFreeSpaceNotification()
{
    FilesystemNotifyFreeSpace();
}

/**
 * floating menu command
 */
void CMMIDispWindow::OnNoFreeSpaceNotification()
{
    FilesystemNotifyNoFreeSpace();
}

/**
 * floating menu command
 */
void CMMIDispWindow::OnSwitchOff()
{
    MOPI_ExecuteFunction( NOPROCESS_PID, SwitchOffRequest_Mopi, (UINT32)0 );
}

/**
 * floating menu command
 */
void CMMIDispWindow::OnBuildShortMessage()
{
    SMSSIM_IncomingSimpleShortMsg();
}

/**
 * floating menu command
 */
void CMMIDispWindow::OnSendNextSegmentEMSMessage()
{
    SMSSIM_IncomingEnhancedShortMsg();
}

//modified by duchun for SHAPED_UI
#ifdef USE_SHAPED_UI
/**
 * On command to show the MDV window from shaped ui
 */
void CMMIDispWindow::OnGoToDockedWin()
{
    // restore the docked view
    CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;
        
    pFrame->GetWindowRect(m_rcShapedUI);

    // set frame region
    pFrame->SetWindowRgn(NULL,TRUE);
    // set this region
    SetWindowRgn(NULL,TRUE);
    pFrame->MoveWindow(m_rcFrame.left,m_rcFrame.top,m_rcFrame.Width(),m_rcFrame.Height(),TRUE);

    pFrame->DisplayControlBar();

    pFrame->SetMenu(&m_cMenu);

    //if main menu opened, close it.
    OnMainMenuClose();

#ifdef JAVA_SDK
    //hide smtktool dlg: add by sunmin for hide smtktool
    if(m_pDlgSmtkTool!=NULL)
        m_pDlgSmtkTool->ShowWindow(SW_HIDE);
#endif
        


    // set the UI style
    GlobalUiStyle = PC_SIMU_USE_NEW_UI;

}

/**
 * On command to show the shaped User interface
 */
void CMMIDispWindow::OnGotoShapedUi()
{
    GlobalUiStyle = SHAPED_UI;
    CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;
    
    pFrame->GetWindowRect(m_rcFrame);

    // hide the dockbar window 
    pFrame->HideControlBar();
    // restore the shaped ui
    m_bTransparent = FALSE;
    
    SetSkin(0);
    
    LoadPhoneSkin(mg_Magnification,GlobalUiSkin);

    
    
}
#endif
/**
 * Close the program Alt+F4
 */
void CMMIDispWindow::OnCloseEntirProgram()
{
    CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;
    pFrame->OnClose();

}


//modified by duchun for SHAPED_UI
#ifdef USE_SHAPED_UI
/**
 * command to show display only information
 */
void CMMIDispWindow::OnDisplayOnly()
{

    //if main menu opened, close it.
    OnMainMenuClose();

    if (GlobalUiStyle != SHAPED_UI)
    {
        if (GlobalUiSkin == SHAPED_UI_NO_SKIN)
        {
            GlobalUiSkin = SHAPED_UI_HAVE_SKIN;
            SetMenuItemState(hMenuPopupPhones,ID_DISPLAY_ONLY, MF_UNCHECKED | MF_STRING | MF_ENABLED);
            SetMenuItemState(hMenuView,ID_DISPLAY_ONLY, MF_UNCHECKED | MF_STRING | MF_ENABLED);
            OnSetSkin(1);
        }
        else
        {
            GlobalUiSkin = SHAPED_UI_NO_SKIN;
            SetMenuItemState(hMenuPopupPhones,ID_DISPLAY_ONLY, MF_CHECKED | MF_STRING | MF_ENABLED);
            SetMenuItemState(hMenuView,ID_DISPLAY_ONLY, MF_CHECKED | MF_STRING | MF_ENABLED);
            OnSetSkin(1);
        }

    }
    else// in SHAPED_UI window
    {
        CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;
        pFrame->GetWindowRect(m_rcShapedUI);
        if (GlobalUiSkin == SHAPED_UI_NO_SKIN)
        {
            GlobalUiSkin = SHAPED_UI_HAVE_SKIN;
            SetMenuItemState(hMenuPopupPhones,ID_DISPLAY_ONLY, MF_UNCHECKED | MF_STRING | MF_ENABLED);
            SetMenuItemState(hMenuView,ID_DISPLAY_ONLY, MF_UNCHECKED | MF_STRING | MF_ENABLED);
            OnSetSkin(1);
            //g_SetMagnify=true;
            LoadPhoneSkin(mg_Magnification, GlobalUiSkin);
            //g_SetMagnify=false;

        }
        else
        {
            GlobalUiSkin = SHAPED_UI_NO_SKIN;
            SetMenuItemState(hMenuPopupPhones,ID_DISPLAY_ONLY, MF_CHECKED | MF_STRING | MF_ENABLED);
            SetMenuItemState(hMenuView,ID_DISPLAY_ONLY, MF_CHECKED | MF_STRING | MF_ENABLED);
            OnSetSkin(1);
        //  g_SetMagnify=true;
            LoadPhoneSkin(mg_Magnification, GlobalUiSkin);
        //      g_SetMagnify=false;
        }

    }
}

/**
 * On command to verify the update of the display only check
 */
void CMMIDispWindow::OnUpdateDisplayOnly(CCmdUI* pCmdUI)
{

    
}
#endif
void CMMIDispWindow::OnSetFocus(CWnd* pOldWnd)
{
    CDispWnd::OnSetFocus(pOldWnd);
    BringWindowToTop();
    // TODO: Add your message handler code here

}

//modified by duchun for SHAPED_UI
#ifdef USE_SHAPED_UI
// For bitmap load and show
BOOL CMMIDispWindow::LoadBitmap (LPCTSTR lpszResourceName, LPCTSTR lpszFilename)
{
    // Release the bitmap if it was created
    ReleaseBitmap ();

    if (lpszResourceName != NULL)
    {
        // Load the bitmap from a resource
        m_bmBitmap = new CBitmap;
        if (!m_bmBitmap->LoadBitmap (lpszResourceName))
            return FALSE;

        // Automatically delete the object
        m_bBitmapCreated = TRUE;
        m_bBitmapExists = TRUE;

        // Make the window transparent if needed
        MakeWindowRgn ();
        ReleaseBitmap ();
    }
    else
    {
        // Load the bitmap from a file
        HBITMAP hbm = (HBITMAP) LoadImage (NULL, lpszFilename, IMAGE_BITMAP, 0, 0,
            LR_LOADFROMFILE|LR_CREATEDIBSECTION);
        if (hbm == NULL) return FALSE;

        // Get the CBitmap object
        CopyBitmapFrom (CBitmap::FromHandle(hbm));
        //m_bmBitmap = CBitmap::FromHandle (hbm);
        DeleteObject(hbm);
    }


    return TRUE;
}

BOOL CMMIDispWindow :: LoadBitmap (UINT nIDResource)
{
    // Release the bitmap if it was created
    ReleaseBitmap ();
    
    // Load the bitmap
    m_bmBitmap = new CBitmap;
    if (!m_bmBitmap->LoadBitmap (nIDResource))
        return FALSE;

    // Automatically delete the object
    m_bBitmapCreated = TRUE;
    m_bBitmapExists = TRUE;

    // Make the window transparent if needed
    MakeWindowRgn ();
    ReleaseBitmap ();

    return TRUE;
}

//----------------------------------------------------------------
// CMMIDispWindow :: CopyBitmapFrom - sets the bitmap to a copy
//  of a CBitmap.
//
// Parameters:
//  pBitmap - a pointer to the bitmap to make a copy of and use.

BOOL CMMIDispWindow :: CopyBitmapFrom (CBitmap *pBitmap)
{
    // Release the bitmap if it was created
    ReleaseBitmap ();

    // Get the bitmap information
    BITMAP bmSrc;
    pBitmap->GetBitmap (&bmSrc);

    // Get a DC to the source bitmap
    CDC dcSrc;
    dcSrc.CreateCompatibleDC (NULL);
    CBitmap *bmSrcOld = dcSrc.SelectObject (pBitmap);

    // Create a new bitmap
    m_bmBitmap = new CBitmap;
    if (!m_bmBitmap->CreateCompatibleBitmap (&dcSrc, bmSrc.bmWidth, bmSrc.bmHeight))
        return FALSE;

    // Get a DC to the destination bitmap
    CDC dcDst;
    dcDst.CreateCompatibleDC (NULL);
    CBitmap *bmDstOld = dcDst.SelectObject (m_bmBitmap);

    // Copy the bitmap
    dcDst.BitBlt (0, 0, bmSrc.bmWidth, bmSrc.bmHeight, &dcSrc, 0, 0, SRCCOPY);

    // Release
    dcSrc.SelectObject (bmSrcOld);
    dcDst.SelectObject (bmDstOld);
    dcSrc.DeleteDC ();
    dcDst.DeleteDC ();

    // Automatically delete the object
    m_bBitmapCreated = TRUE;
    m_bBitmapExists = TRUE;

    return TRUE;
}

//----------------------------------------------------------------
// CMMIDispWindow :: SetBitmap - sets the bitmap
//
// Parameters:
//  pBitmap - a pointer to the bitmap to use.
//
// NOTE: This function does not copy the bitmap.  You are responsible
//  for handling the bitmap.  Use CopyBitmapFrom() to copy a bitmap.

void CMMIDispWindow :: SetBitmap (CBitmap *pBitmap)
{
    // Release the bitmap if it was created
    ReleaseBitmap ();

    // Set the bitmap
    m_bmBitmap = pBitmap;

    // The bitmap exists, but was not created
    m_bBitmapExists = TRUE;

    // Make the window transparent if needed
    MakeWindowRgn ();
}

//----------------------------------------------------------------
// CMMIDispWindow :: ReleaseBitmap - releases a bitmap if it was
//  created using LoadBitmap or CopyBitmapFrom.

void CMMIDispWindow :: ReleaseBitmap ()
{
    // Make sure that the bitmap was created using LoadBitmap or CopyBitmapFrom
    if (m_bBitmapCreated)
    {
        // Delete the bitmap
        m_bmBitmap->DeleteObject ();
        delete m_bmBitmap;

        // The bitmap has not been created yet
        m_bBitmapCreated = FALSE;
    }

    m_bBitmapExists = FALSE;
}

void CMMIDispWindow :: ReleaseRegion ()
{
    if (m_bRegionCreated)
    {
        m_MainMenuRgn.DeleteObject();
        m_bRegionCreated = FALSE;
    }
}

//----------------------------------------------------------------
// CMMIDispWindow :: SetTransparent - sets the dialog's transparent
//  state.

void CMMIDispWindow :: SetTransparent (BOOL bTransparent)
{
    m_bTransparent = bTransparent;
}

void CMMIDispWindow :: SetTransColor (COLORREF col)
{
    m_colTrans = col;
    MakeWindowRgn ();
}

#endif
//modified by duchun for SHAPED_UI
#ifdef USE_SHAPED_UI
/**----------------------------------------------------------------
 * CMMIDispWindow :: MakeWindowRgn - makes a window region from
 * the bitmap and uses it if on transparent mode.
*/
void CMMIDispWindow :: MakeWindowRgn ()
{

    // Set the window region to the full window
    if (m_bRgnFrameEstablished == TRUE)
    {
        m_rgnFrame.DeleteObject();
    }

    //GetWindowRect (m_ClientFrame);
    CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;
    //pFrame->GetWindowRect(m_rcFrame);
    pFrame->GetClientRect(m_ClientFrame);
    //pFrame->GetWindowRect(m_ClientFrame);


    //initalize the frame background region
    m_rgnFrame.CreateRectRgn (m_ClientFrame.left, m_ClientFrame.top, m_ClientFrame.Width(), m_ClientFrame.Height());
    m_rgnFrame.CombineRgn(&m_rgnFrame, &m_rgnFrame, RGN_XOR);


    // Set the region to the window rect minus the client rect
    //CRect rcWnd;
    CRect rcClient;
    int Max_x, Min_x, start_y, end_y;

//  pFrame->GetWindowRect(rcWnd);
    //ClientToScreen (rcWnd);

    CRgn rgn;

    pFrame->GetClientRect (rcClient);
    pFrame->ClientToScreen (rcClient);

    CRgn rgnClient;
    rgn.CreateRectRgn (rcClient.left, rcClient.top, rcClient.right, rcClient.bottom);

    // Subtract rgnClient from rgn
    rgn.CombineRgn (&rgn, &rgn, RGN_XOR);

    // Get a DC for the bitmap
    CDC dcImage;
    dcImage.CreateCompatibleDC (NULL);
    CBitmap *pOldBitmap = dcImage.SelectObject (m_bmBitmap);

    // Get the bitmap for width and height information
    BITMAP bm;
    m_bmBitmap->GetBitmap (&bm);

    // Use the minimum width and height
    int width = min (bm.bmWidth, rcClient.Width());
    int tmp_height = rcClient.Height();
    int height = min (bm.bmHeight, tmp_height );

    // Use RLE (run-length) style because it goes faster.
    // Row start is where the first opaque pixel is found.  Once
    // a transparent pixel is found, a line region is created.
    // Then row_start becomes the next opaque pixel.
    int row_start, row_end, x, y, x_start;
    BOOL TopFind = FALSE;

    if (mg_Magnification == 1)
    {
        start_y = SHAPED_UI_CMD_START_TOP;
        end_y = SHAPED_UI_CMD_END_BOTTOM;
    }
    else
    {
        start_y = SHAPED_UI_CMD_START_TOP2;
        end_y = SHAPED_UI_CMD_END_BOTTOM2;

    }

    Min_x = width;
    m_PicLeft.x = width;
    Max_x = 0;
//Du Chun use one bitmap for MDV and SHAPED UI
//Scan the bitmap from both the left and right side.
    // Go through all rows
    for (y=0; y<height; y++)
    {
        // Start looking at the beginning
        row_start = 0;
                row_end = 0;

        for (int x=0; x<width; x++) //Scan from the left
        {
            if (dcImage.GetPixel(x, y) != m_colTrans) //found the left boundary point
            {
                row_start = x;
                break;
            }
        }
        if(row_start >= 0)
        {
            for (int x=width-1; x >= 0; x--)  //Scan from the right
            {
                if (dcImage.GetPixel(x, y) != m_colTrans) //found the right boundary point
                {
                    row_end = x;
                    break;
                }
            }
            if (TopFind == FALSE)
            {
                m_PicTop.x = row_end;
                m_PicTop.y = y;
                TopFind = TRUE;
            }
            
            CRgn rgnAdd;
            rgnAdd.CreateRectRgn (row_start, y, row_end, y+1);
            if (y == start_y)
            {
                x_start = row_start;
                GlobalCmdWndTop = start_y;
                GlobalCmdWndLeft = row_end;
            }

            if (m_PicLeft.x > row_start)    
            {
                m_PicLeft.x = row_start;
                m_PicLeft.y = y;
            }

            // Caculate the max and min point
            if (y >= start_y && y <= end_y)
            {
                if (row_end > Max_x) Max_x = row_end;
                if (row_end < Min_x) Min_x = row_end;
            }
            rgn.CombineRgn (&rgn, &rgnAdd, RGN_OR);
        }
/*
        // Go through all columns
        for (x=0; x<width; x++)
        {
            // If this pixel is transparent
            if (dcImage.GetPixel(x, y) == m_colTrans)
            {
                // If we haven't found an opaque pixel yet, keep searching
                if (row_start == x) row_start ++;
                else
                {
                    // find the top point for setting the bmp position

                    if (TopFind == FALSE)
                    {
                        m_PicTop.x = x;
                        m_PicTop.y = y;
                        TopFind = TRUE;
                    }
                    // We have found the start (row_start) and end (x) of
                    // an opaque line.  Add it to the region.
                    CRgn rgnAdd;
                    rgnAdd.CreateRectRgn (row_start, y, x, y+1);
                    if (y == start_y)
                    {
                        x_start = row_start;
                        GlobalCmdWndTop = start_y;
                        GlobalCmdWndLeft = x;
                    }

                    if (m_PicLeft.x > row_start)    
                    {
                        m_PicLeft.x = row_start;
                        m_PicLeft.y = y;
                    }

                    // Caculate the max and min point
                    if (y >= start_y && y <= end_y)
                    {
                        if (x > Max_x) Max_x = x;
                        if (x < Min_x) Min_x = x;
                    }

                    rgn.CombineRgn (&rgn, &rgnAdd, RGN_OR);
                    row_start = x+1;
                }
            }
        }*/
        // If the last pixel is still opaque, make a region.
/*      if (row_start != x)
        {
            CRgn rgnAdd;
            //rgnAdd.CreateRectRgn (rcClient.left+row_start, rcClient.top+y,
            //  rcClient.left+x, rcClient.top+y+1);
            rgnAdd.CreateRectRgn (row_start, y, x, y+1);
            rgn.CombineRgn (&rgn, &rgnAdd, RGN_OR);
        }
*/  }
    //end of for

    // edge width
    POINT offsetPoint, offsetClient;

    CRect rc;
    // client coordinate
    pFrame->GetWindowRect(rc);
    pFrame->ScreenToClient(rc);

    offsetClient.x = 0 - rc.left;
    offsetClient.y = 0 - rc.top;


    //titlebar height calculate
    TITLEBARINFO titleBarInfo;
    titleBarInfo.cbSize = sizeof(TITLEBARINFO);
    GetTitleBarInfo(&titleBarInfo);
    offsetClient.y += 17;
    offsetClient.x += 3;

    // for display only
    if (m_CountSkinChange == 0)
    {
        m_OffsetClient.x = offsetClient.x;
        m_OffsetClient.y = offsetClient.y;
        m_CountSkinChange++;
    }

    //int s = titleBarInfo.rcTitleBar.bottom - titleBarInfo.rcTitleBar.top;

    // screen coordinate for command window
    CPoint p, p2;
    p.x = offsetClient.x + GlobalCmdWndLeft;
    p.y = offsetClient.y + GlobalCmdWndTop;
    pFrame->ClientToScreen(&p);
    p2.x = GlobalCmdWndLeft;
    p2.y = GlobalCmdWndTop;
    pFrame->ClientToScreen(&p2);
    offsetPoint.x = p.x - p2.x; 
    offsetPoint.y = p.y - p2.y;

    // set the start position of the main menu
    pFrame->ClientToScreen(&m_ClientFrame);
//  GlobalCmdWndLeft = p.x - m_ClientFrame.left;
//  GlobalCmdWndTop = p.y - m_ClientFrame.top;
    //GlobalCmdWndLeft = m_ClientFrame.left + emulatorWidth - SHAPED_UI_CMD_WIDTH/2-50 ;
    //GlobalCmdWndLeft = p.x - m_ClientFrame.left-7;//by Fang Yunchao ,for remove a bug of Shaped UI
    GlobalCmdWndLeft =emulatorWidth-7;// p.x - m_ClientFrame.left-7;//by Fang Yunchao ,for remove a bug of Shaped UI
    GlobalCmdWndTop = p.y - m_ClientFrame.top;
    //GlobalCmdWndTop = GlobalCmdWndTop + offsetPoint.y;
    // shift the mp body rgn to main frame position 
    rgn.OffsetRgn(offsetClient.x, offsetClient.y);
    //rgn.OffsetRgn(rcWnd.left, rcWnd.top);
//  m_rgnFrame.CombineRgn(&m_rgnFrame, &rgn, RGN_OR);

    // set window region        
//  int i = pFrame->SetWindowRgn(m_rgnFrame, TRUE);
    int i = pFrame->SetWindowRgn(rgn, TRUE);
    m_bRgnFrameEstablished = True;

    width = Max_x - Min_x;
    // for main menu region
    // adjust the rgn position 
    ReleaseRegion(); // if region has been created

    if (start_y <= m_PicTop.y)
    {
        // the shaped command window start_y is out of the range of shaped bmp
        // create a round rect for the command window
        m_bRegionCreated = m_MainMenuRgn.CreateRoundRectRgn(0, 0, SHAPED_UI_CMD_WIDTH - 100, \
            end_y - start_y, 30, 30);
        return;
    }
    else
    {
        m_bRegionCreated = m_MainMenuRgn.CreateRoundRectRgn(0, 0, Max_x - Min_x + SHAPED_UI_CMD_WIDTH - 100, \
            end_y - start_y, 30, 30);
    }
// fix bug of main menu display by Fang Yunchao
/*
    //m_MainMenuRgn.CombineRgn(&m_MainMenuRgn,&m_MainMenuRgn,RGN_XOR);
    for (y = start_y ; y < end_y ; y ++)
    {
        // Start looking at the beginning
        row_start = 0;

        // Go through all columns

        for (x = Min_x; x <= Max_x ; x++)
        {
            // If this pixel is transparent
            if (dcImage.GetPixel(x, y) == m_colTrans)
            {
                CRgn rgnAddCmd;
                if (x == Min_x)
                {
                    break;
                }
                else
                {

                    if (GlobalUiSkin == SHAPED_UI_NO_SKIN)
                    {
                        rgnAddCmd.CreateRectRgn (row_start,
                            y - start_y, x, y - start_y+1);
                    }
                    else
                    {
                        if (1) /// temp will changed for the first time show region
                        {
                            rgnAddCmd.CreateRectRgn (0,
                                y - start_y, x - Min_x, y - start_y + 1);  
                        }
                        else
                        {
                            rgnAddCmd.CreateRectRgn (0,
                                y - start_y, x - Min_x, y + 1);
                        }

                    }
                }
                m_MainMenuRgn.CombineRgn (&m_MainMenuRgn, &rgnAddCmd, RGN_DIFF);

                break;
            }// end of if
        }
    }// end of for
    */

}


BOOL CMMIDispWindow::LoadPhoneSkin(int magnify, int mode)
{
    char SkinBmp[SKIN_PATH_LEN];
    char * pFileName;
#ifdef _UNICODE
    TCHAR temp[SKIN_PATH_LEN];//Added by Fang Yunchao for SMTK Localization
#endif
    char    NeoSkinBitmap[SKIN_PATH_LEN];   //added by duchun for neo flexshell close

    //strcpy(SkinBmp,SkinBitmapFile);

    sprintf(SkinBmp,"%s\\%s.bmp",SkinDir,phoneNameOrg);
//added by duchun for neo flexshell close
    if(mg_FlexShellType == 2)
    {
        if(m_bFlexShellClose)
        { 
            sprintf(NeoSkinBitmap,"%s_closed", Info_GetProductName());
            sprintf(SkinBmp,"%s\\%s.bmp",SkinDir,NeoSkinBitmap);
        }
    }

    // check if the skin file exist
    pFileName = strstr(SkinBmp,".bmp");

   CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;

   if (pFileName)
   {
        // replace the file name of the skin to set window rgn
       // so white bk skin can be shown in MDV
       if (magnify == 1)
       {
//Du Chun use one bitmap for MDV and SHAPED UI
//          strcpy(pFileName,"_sp.bmp");
            strcpy(pFileName,".bmp");

       }
       else
       {
//Du Chun use one bitmap for MDV and SHAPED UI
//          strcpy(pFileName,"g_sp.bmp");
            strcpy(pFileName,"g.bmp");
       }
   }

    if (mode == SHAPED_UI_HAVE_SKIN)
    {
        if (pFileName)// find it's the existing skin
        {
#ifndef _UNICODE
            m_SkinLoaded = LoadBitmap(NULL, (LPCTSTR)SkinBmp);
#else
        {
            for(int i=0;i<strlen(SkinBmp);i++)
            temp[i]=SkinBmp[i];
            temp[i]='\0';
            m_SkinLoaded = LoadBitmap(NULL, temp);
        }
#endif
            GlobalUiSkin = SHAPED_UI_HAVE_SKIN;
//modified by duchun for Neo
            //GlobalPhoneWidth = SHAPED_UI_FRAME_WIDTH;
            GlobalPhoneWidth = emulatorWidth;
        }

    }// end of have skin
    else //SHAPED_UI_NO_SKIN
    {
        if (magnify == 1)
        {
            CRgn DispRgn;
            DispRgn.CreateRectRgn(m_OffsetClient.x, m_OffsetClient.y,
                emulatorWidth - 5,
                emulatorHeight + 16);
            pFrame->MoveWindow(m_rcShapedUI.left,m_rcShapedUI.top,SHAPED_UI_FRAME_WIDTH + 100,SHAPED_UI_FRAME_HEIGHT / 2);
            MoveWindow(-2,
            -2,
            SHAPED_UI_FRAME_WIDTH - 20,
            SHAPED_UI_FRAME_HEIGHT / 2 - 20);
            
            //mainmenu position
            GlobalCmdWndLeft = emulatorWidth - 5;
            GlobalCmdWndTop = 0;


            int i = pFrame->SetWindowRgn(DispRgn, TRUE);

            // establish main menu region
            ReleaseRegion(); // if region has been created, release it
            m_bRegionCreated = m_MainMenuRgn.CreateRoundRectRgn(
                0, 0, SHAPED_UI_CMD_WIDTH - 95, \
                SHAPED_UI_CMD_END_BOTTOM - SHAPED_UI_CMD_START_TOP,
                30, 30);

            GlobalUiSkin = SHAPED_UI_NO_SKIN;
            m_SkinLoaded = 0;
            ReSizeDockingWnd();//Fang Yunchao add for remove a bug of Shaped UI
            return SHAPED_UI_NO_SKIN;
        }
        else // magnify == 2
        {
            CRgn DispRgn;
            int height, width;
            width = emulatorWidth - 7;
            height = emulatorHeight + 10;
            DispRgn.CreateRectRgn(m_OffsetClient.x,
                m_OffsetClient.y,
                width,
                height);

            MoveWindow(-2,
            -2,
            emulatorWidth,
            emulatorHeight);

            pFrame->MoveWindow(m_rcShapedUI.left,m_rcShapedUI.top,SHAPED_UI_FRAME_WIDTH*2,SHAPED_UI_FRAME_HEIGHT);
            int i = pFrame->SetWindowRgn(DispRgn, TRUE);


            //mainmenu position
            GlobalCmdWndLeft = width;
            GlobalCmdWndTop = 20;

            // establish main menu region
            ReleaseRegion(); // if region has been created, release it
            m_bRegionCreated = m_MainMenuRgn.CreateRoundRectRgn(
                0, 0, SHAPED_UI_CMD_WIDTH - 95, \
                SHAPED_UI_CMD_END_BOTTOM2 - SHAPED_UI_CMD_START_TOP2,
                30, 30);


            GlobalUiSkin = SHAPED_UI_NO_SKIN;
            GlobalPhoneWidth = SHAPED_UI_FRAME_WIDTH - 50;
            m_SkinLoaded = 0;
            ReSizeDockingWnd();//Fang Yunchao Add for remove a bug of Shaped UI
            return SHAPED_UI_NO_SKIN;

        }

    }// SHAPED_UI_NO_SKIN

    RECT rc;
    //Added by duchun
    RECT rcFrameWindow;
    RECT rcFrameClient;
    int iFrameHorBorderSize;
    int iFrameVerBorderSize;
    
    pFrame->GetWindowRect(&rcFrameWindow);
    pFrame->GetClientRect(&rcFrameClient);
    iFrameHorBorderSize = rcFrameWindow.right - rcFrameWindow.left - (rcFrameClient.right - rcFrameClient.left);
    iFrameVerBorderSize = rcFrameWindow.bottom - rcFrameWindow.top - (rcFrameClient.bottom - rcFrameClient.top);

    if (m_SkinLoaded)
    {
        GetWindowRect(&rc);

        if (magnify == 1)
        {

            // set the frame window size
            pFrame->MoveWindow(m_rcShapedUI.left,
                m_rcShapedUI.top,
//              SHAPED_UI_FRAME_WIDTH + 50,
//              SHAPED_UI_FRAME_HEIGHT+80);
                emulatorWidth + iFrameHorBorderSize+50,
                emulatorHeight + iFrameVerBorderSize+20 );

            MoveWindow(-1,
            -1,
            emulatorWidth+ iFrameHorBorderSize+5,
            emulatorHeight + iFrameVerBorderSize);

            // for special status
            // if the window is 200% zoom but window is floating 
            // and the real zoom is 100%
            if (mg_Magnification == 2)
            {
                MoveWindow(-1,
                -1,
                emulatorWidth + iFrameHorBorderSize,
                emulatorHeight + iFrameVerBorderSize);

                mg_Magnification = 1;

            }

        }
        else // Zoom 200%
        {
            CRect Dtrc;
            CWnd * pWnd;

            pWnd = GetDesktopWindow();

            pWnd->GetWindowRect(&Dtrc);

            // set the frame window
            pFrame->MoveWindow(m_rcShapedUI.left,
            m_rcShapedUI.top,
            emulatorWidth+ iFrameHorBorderSize+50,
            emulatorHeight*1.5);//modified by fang Yunchao for remove a bug of Shaped  UI
                        // set the Disp window
            MoveWindow(-1,
                -1,
            emulatorWidth ,
            emulatorHeight );
        }

        SetTransparent (TRUE);
//Du Chun use one bitmap for MDV and SHAPED UI 
//      SetTransColor (RGB(255,0,255));
        SetTransColor (RGB(255,255,255));
        SetStaticTransparent (TRUE);

        GlobalUiStyle = SHAPED_UI;
        //ModifyStyle(WS_CAPTION,0);
        pFrame->GetWindowRect(&rc);
        pFrame->InvalidateRect(&rc, TRUE);
    }
    else// fail to load the phone skin
    {
        //if main menu opened, close it.
        OnMainMenuClose();
        pFrame->SetMenu(&m_cMenu);
        pFrame->DisplayControlBar();

        // refresh window
        CRect rc;
        pFrame->GetWindowRect(&rc);
        pFrame->InvalidateRect(rc, TRUE);

        // set the UI style
        GlobalUiStyle = PC_SIMU_USE_NEW_UI;

    }
    ReSizeDockingWnd();


    //pFrame->CloseWindow();
    //pFrame-;

    return GlobalUiSkin;
}

#endif

/*
  Show the SMTK tool utilities window.
*/
#ifdef JAVA_SDK
void CMMIDispWindow::ShowSmtkTool()
{
    if(m_pDlgSmtkTool==NULL)
        m_pDlgSmtkTool=new CDlgSmtkTool;

    if(!::IsWindow(m_pDlgSmtkTool->GetSafeHwnd()))
        {
            m_pDlgSmtkTool->Create(CDlgSmtkTool::IDD,this); 
            CRect rcSmtkToolDlg;
            CRect tempMMidisp;
            GetWindowRect(tempMMidisp);
            m_pDlgSmtkTool->GetWindowRect(rcSmtkToolDlg);
                        m_pDlgSmtkTool->MoveWindow(tempMMidisp.left+tempMMidisp.Width(),tempMMidisp.Height()*3/4,rcSmtkToolDlg.Width(),rcSmtkToolDlg.Height());
            m_pDlgSmtkTool->SetOutputView(1, cStrForSmtlToolOutput);            
         }
//fixing bug about output text
    //m_pDlgSmtkTool->SetOutputView(1, cStrForSmtlToolOutput);  
    m_pDlgSmtkTool->ShowWindow(SW_SHOW);    
    m_pDlgSmtkTool->PostMessage(WM_SIZE,0,0);
    //mg_smtkToolDlgOpened = 1;
}

/*
  Show the SMTK tool utilities window.
*/
void CMMIDispWindow::OnSmtkTool()
{
    ShowSmtkTool();
}

/*
  Set the Java heap string value in the heap view dialog.
*/
void CMMIDispWindow::SetSmtkToolValue(CString cStr)
{
    if(m_pDlgSmtkTool)
    {
       m_pDlgSmtkTool->SetJavaHeap(cStr);
    }
}
/*
  Set the debug output text to the debug window.
*/
void CMMIDispWindow::SetOutputView(UINT uiMessage,CString cStrOutput)
{
//modify by sunmin for fixing bug about output text
    switch (uiMessage)
    {
        case 1:
        {
            if(!(cStrForSmtlToolOutput.IsEmpty()))
        {
                cStrForSmtlToolOutput+="\r\n";                
            }
            cStrForSmtlToolOutput+=cStrOutput;            
        }
        break;
        case 2:
        {
            cStrForSmtlToolOutput.Empty();
        }
        break;
    }
    
    if(m_pDlgSmtkTool)
    {
        m_pDlgSmtkTool->SetOutputView(uiMessage,cStrForSmtlToolOutput);
    }
}

#endif

/*
  Get draged file name and judge to start java app.
*/
void CMMIDispWindow::OnDropFiles(HDROP hDropInfo)
{
    LPTSTR lpszFile = NULL; //draged in file name
    UINT iFile = 0; //file counter
    UINT cch = 0;  //file name size
    UINT iRet = 0;
    char *lastDot = NULL; // string of the file name extension

    //get buffer size
    cch = DragQueryFile(hDropInfo,iFile,lpszFile,cch);
    if(cch>0)
    {
        lpszFile = new char[cch+1];
        //get dragged file name
        iRet = DragQueryFile(hDropInfo,iFile,lpszFile,cch+1);
        if(iRet>0)
        {
            lpszFile[iRet] = '\0';
            lastDot = strrchr(lpszFile, '.');
            if ((lastDot != NULL) &&
                ( strcmp(lastDot, ".class") == 0 ||
                strcmp(lastDot, ".jad")   == 0 ||
                strcmp(lastDot, ".jar")   == 0   ) ) //is a java app file type?
            {
            
//                Kauai_Start(lpszFile,TRUE);
            }
        }
        if(lpszFile)
        {
            delete lpszFile;
            lpszFile = NULL;
        }
    }
    return;
}
