/*
             Siemens AG
         Mobile Radio Terminals
          Munich, Germany

.AUTHOR         D. Ambras ICM MP PO6 SW

.SHORT_DESCR    PC-Emulator: processing of command line parameters

.SW_COMPONENT

.SW_TYPE        Support-File

.VERSION        8.2.3

.DATE           2003-05-19

.STATUS         FIRST VERSION

.CHANGE_CONTROL
Version |  Date     | Changed by         | Reason for Change
 8.1.0    2002-02-19   D.Ambras (MCH)       file created with contents of winkinit.cpp
                                            new unified emulator interface implemented
 8.1.1    2002-02-28   D.Ambras (MCH)       added options -D, -Xdevice and -Xheapsize
 8.2.0    2002-04-04   D.Ambras (MCH)       suppressed options /P and /S for SDK compilation
                                            help text refined
 8.2.1    2002-04-04   D.Ambras (MCH)       allow .jar files as command line application, too
 8.2.1    2002-05-22   R.Vretska (VIE)      added XTRACE options
 8.2.2    2002-05-24   N.Haiduk (KLF)       added option '/F' for full log-file output
 8.2.3    2003-05-19   N.Barisits (VIE)     added include directive for inc_private_alias.h
-------------------------------------------------------------------------------------------
08.02.04 2003-06-16 Thomas Herrmann (Mch)
         Adaptions for Visual Studio .NET 2003
08.02.05 2003-07-23 F.Schultze (Mch)
         getSystemProperty changed prototype
08.02.06 2003-07-29 Thomas Herrmann (Mch)
         JavaAppViaCommandLineRunning changed prototype (C/C++ issue with bool)
08.03.00 2003-09-26 Frank Schultze (MCH)
         Add ClassPathSetExternally
08.03.01 2003-10-21 Thomas Herrmann (Mch)
         Java debugger proxy port is now stored as integer instead of string
08.04.00 2003-11-07 Harpreet Singh 
         Added command line option for removing
		 "No Sim" widget at start of PC-Simu
08.04.01 2003-11-19 Frank Schultze / Thomas Herrmann (Mch)
         Fixed UserClassPath option for Java debugger
08.04.02 2004-01-28  Leena Khera(SISL)  
         Command Line Name /Registry Entry Name is modified to "ShowSimDialog" for No Sim Dialog 
08.05.00 2004-2-19  zhang qifan(PEK)
         Add information initialize for SMTK
08.05.01 2004-02-20 Klaus Staudenmaier (ULM)
         Solve Compile Errors from 08.05.00 ( Missing #ifdef JAVA_SDK)	 
08.05.02 2004-03-10 Uwe Kapala fix PCMMI problems due to DISP_LCD_WIDTH/HEIGHT
08.05.03 2004-03-31  zhang qi fan(PEK)
	 Mobile information initialzation for SMTK
08.05.03 2004-04-30  Zhang qi fan(PEK)
	 UEI interface update for SMTK, introducing .bootclasspath parameter	 
08.05.04 2004-06-17  Zhang qi fan(PEK)
	 Change directory separator of .bootclasspath parameter	from "\" to "/" in order to integrated with JBuilder
08.05.05 2004-06-18  Fang Yunchao(PEK)
	 Add UNICODE support
08.05.06 2004-06-21 Alex Nagy (BS/MCH)
         PC-MMI replaced inc_private_alias.h by the C2C concept
08.05.07 2005-01-31 Fang Yunchao(PEK)     Fix bug of SUN One classpath and UEI java trace   


**************************************Jerry*********************************
09.00.00  2006-03-17  Gurpreet Sabharwal(SISL ,India)
                      Removed Java Support And Functionality





*/


#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

extern "C"
{
    #include <global.h>
//    #include "jenv.h"
//    #include "jproph.h"
    #include "sim_regh.h"
    #include "dplcfg.h"
    #include "dplcolor.h"
    #include "ddlcdsiz.h"
  //    extern const unsigned char LCD_WIDTH, LCD_HEIGHT;
}

#include "wtypes.h"  // LPTSTR


//#define  MAX_ARG_STRING_LEN    512
#define  MAX_ARG_STRING_LEN      2048

// binary coded action specifiers:
#define  NO_CMD                  0
#define  BOOL_JVM_OPTION         1
#define  STRING_JVM_OPTION       2
#define  NUMBER_JVM_OPTION       4
#define  CALL_FNT_JVM_OPTION     8
#define  TRACING_JVM_OPTION     16 + BOOL_JVM_OPTION


BOOL JVM_OptionNotImplementedAndStop(char *Option);
BOOL JVM_OptionHasNoEffect(char *Option);

static BOOL mg_bClassPathSetExternally;

//extern "C" char * UserClassPath;

static BOOL setClasspathHook (char* classpath)
{

 //   if (UserClassPath)
 //       free (UserClassPath);

  //  UserClassPath = strdup(classpath);
 //   mg_bClassPathSetExternally = TRUE;

    return TRUE;
}

extern "C" BOOL ClassPathSetExternally (void)
{
    return mg_bClassPathSetExternally;
}

typedef struct Type_RegistryCmdOptions
{
    char  *CmdOption;
    char  *RegistryString;
    int   type;
    BOOL  (*DoExtraAction)( char *);
}  RegistryCmdOptions;


typedef struct Type_BooleanOption
{
    char  *String;
    bool  result;
}  BooleanOption;


static const BooleanOption BoolTable[] =
{
    { "y",    TRUE },
    { "yes",  TRUE },
    { "TRUE", TRUE  },
    { "on",   TRUE  },

    { "n",    FALSE },
    { "no",   FALSE },
    { "FALSE",FALSE },
    { "off",  FALSE },
    {"1",TRUE},
    {"0",FALSE},

    { "", FALSE }
};


static const RegistryCmdOptions JVM_Cmdtable[] =
{
    { "/traceallocation "         , "tracememoryallocation",         TRACING_JVM_OPTION, NULL},
    { "/tracegc "                 , "tracegarbagecollection",        TRACING_JVM_OPTION, NULL},
    { "/tracegcverbose "          , "tracegarbagecollectionverbose", TRACING_JVM_OPTION, NULL},
    { "/traceclassloading "       , "traceclassloading",             TRACING_JVM_OPTION, NULL},
    { "/traceclassloadingverbose ", "traceclassloadingverbose",      TRACING_JVM_OPTION, NULL},
    { "/traceverifier "           , "traceverifier",                 TRACING_JVM_OPTION, NULL},
    { "/tracestackmaps "          , "tracestackmaps",                TRACING_JVM_OPTION, NULL},
    { "/tracebytecodes "          , "tracebytecodes",                TRACING_JVM_OPTION, NULL},
    { "/tracemethods "            , "tracemethodcalls",              TRACING_JVM_OPTION, NULL},
    { "/tracemethodsverbose "     , "tracemethodcallsverbose",       TRACING_JVM_OPTION, NULL},
    { "/traceframes "     , "traceframes",      TRACING_JVM_OPTION, NULL},
    { "/tracestackchunks ", "tracestackchunks", TRACING_JVM_OPTION, NULL},
    { "/traceexceptions " , "traceexceptions",  TRACING_JVM_OPTION, NULL},
    { "/traceevents "     , "traceevents",      TRACING_JVM_OPTION, NULL},
    { "/tracethreading "  , "tracethreading",   TRACING_JVM_OPTION, NULL},
    { "/tracemonitors "   , "tracemonitors",    TRACING_JVM_OPTION, NULL},
    { "/tracenetworking " , "tracenetworking",  TRACING_JVM_OPTION, NULL},

    { "/tracing "       , "mg_Tracing",          BOOL_JVM_OPTION, NULL},
    { "/javadebugger "  , "debuggerActive",      BOOL_JVM_OPTION, NULL},
    { "/ShowErrors "    , "mg_ShowErrorMessages",BOOL_JVM_OPTION, NULL},
    { "/ShowInfos "     , "mg_ShowInfoMessages", BOOL_JVM_OPTION, NULL},
    { "/dj "            , "debuggerActive",      BOOL_JVM_OPTION, NULL},            // Debug Java App
    { "/DebugJavaApp "  , "debuggerActive",      BOOL_JVM_OPTION, NULL},
    { "/Xdebug "        , "debuggerActive",      BOOL_JVM_OPTION, NULL},
    { "/Xdevice:"       , "",                    CALL_FNT_JVM_OPTION, JVM_OptionHasNoEffect},
    { "/Xheapsize:"     , "",                    CALL_FNT_JVM_OPTION, JVM_OptionHasNoEffect},

#ifdef JAVA_SDK
    { "/P "             , "",                    CALL_FNT_JVM_OPTION, JVM_OptionHasNoEffect},
    { "/S "             , "",                    CALL_FNT_JVM_OPTION, JVM_OptionHasNoEffect},
    { "/F "             , "",                    CALL_FNT_JVM_OPTION, JVM_OptionHasNoEffect},
#endif
    { "", "", NO_CMD, NULL }           // end marker
};


static const RegistryCmdOptions JVM_Cmdtable_WithArg[] =
{
 // { "/Xheapsize:"   , "KJAVA_heapsize",      STRING_JVM_OPTION, NULL},
 // { "/Xdevice:"     , "KJAVA_device",        STRING_JVM_OPTION, NULL},
    { "/cp "          , "KJAVA_CLASSPATH",     CALL_FNT_JVM_OPTION, setClasspathHook},      // Set java class path
    { "/ClassPath "   , "KJAVA_CLASSPATH",     CALL_FNT_JVM_OPTION, setClasspathHook},
    { "/acp "         , "KJAVA_API_CLASSPATH", STRING_JVM_OPTION, NULL},      // Set java API class path
    { "/APIClassPath ", "KJAVA_API_CLASSPATH", STRING_JVM_OPTION, NULL},
    { "/jdk "           , "JDK_HOME",           STRING_JVM_OPTION, NULL},      // Set jdk home directory
    { "/JDKHome "       , "JDK_HOME",           STRING_JVM_OPTION, NULL},
    { "/l "             , "KJAVA_PROXY_PORT",   NUMBER_JVM_OPTION, NULL},      // Set kdp port
    { "/DebugProxyPort ", "KJAVA_PROXY_PORT",   NUMBER_JVM_OPTION, NULL},

    { "", "", NO_CMD, NULL }           // end marker
};


static const RegistryCmdOptions JVM_Cmdtable_Xverbose[] =
{
    { "allocation"      , "tracememoryallocation",          BOOL_JVM_OPTION, NULL},
    { "gc"              , "tracegarbagecollection",         BOOL_JVM_OPTION, NULL},
    { "gcverbose"       , "tracegarbagecollectionverbose",  BOOL_JVM_OPTION, NULL},
    { "class"           , "traceclassloading",              BOOL_JVM_OPTION, NULL},      // !
    { "classverbose"    , "traceclassloadingverbose",       BOOL_JVM_OPTION, NULL},      // !
    { "verifier"        , "traceverifier",           BOOL_JVM_OPTION, NULL},
    { "stackmaps"       , "tracestackmaps",          BOOL_JVM_OPTION, NULL},
    { "bytecodes"       , "tracebytecodes",          BOOL_JVM_OPTION, NULL},
    { "methods"         , "tracemethodcalls",        BOOL_JVM_OPTION, NULL},
    { "methodsverbose"  , "tracemethodcallsverbose", BOOL_JVM_OPTION, NULL},
    { "frames"          , "traceframes",             BOOL_JVM_OPTION, NULL},
    { "stackchunks"     , "tracestackchunks",BOOL_JVM_OPTION, NULL},
    { "exceptions"      , "traceexceptions", BOOL_JVM_OPTION, NULL},
    { "events"          , "traceevents",     BOOL_JVM_OPTION, NULL},
    { "threading"       , "tracethreading",  BOOL_JVM_OPTION, NULL},
    { "monitors"        , "tracemonitors",   BOOL_JVM_OPTION, NULL},
    { "networking"      , "tracenetworking", BOOL_JVM_OPTION, NULL},

    { "", "", NO_CMD, NULL }
};

bool UEI_Trace_all=FALSE;
bool StartFromCommandline=FALSE;
bool  UEI_Trace_options[] =
{
    {FALSE},
    {FALSE},
    {FALSE},
    {FALSE},      
    {FALSE},      
    {FALSE},
    {FALSE},
    {FALSE},
    {FALSE},
    {FALSE},
    {FALSE},
    {FALSE},
    {FALSE},
    {FALSE},
    {FALSE},
    {FALSE},
    {FALSE}
};
static const RegistryCmdOptions JVM_Cmdtable_Xrunjdwp[] =
{
    { "transport", "KJAVA_transport",  STRING_JVM_OPTION, NULL},
    { "address",   "KJAVA_PROXY_PORT", NUMBER_JVM_OPTION, NULL},
    { "server",    "KJAVA_server",     STRING_JVM_OPTION, NULL},
    { "suspend",   "KJAVA_suspend",    BOOL_JVM_OPTION,   NULL},

    { "", "", NO_CMD, NULL }
};


static const RegistryCmdOptions JVM_Cmdtable_Xjam[] =
{
    { "install",      "KJAVA_JAM_install",   STRING_JVM_OPTION,   NULL},
    { "force",        "KJAVA_JAM_force",     BOOL_JVM_OPTION,     NULL},
    { "run",          "KJAVA_JAM_run",       STRING_JVM_OPTION,   NULL},
    { "remove",       "KJAVA_JAM_remove",    STRING_JVM_OPTION,   NULL},
    { "transient",    "KJAVA_JAM_transient", STRING_JVM_OPTION,   NULL},
    { "list",         "",                    CALL_FNT_JVM_OPTION, JVM_OptionNotImplementedAndStop},
    { "storageNames", "",                    CALL_FNT_JVM_OPTION, JVM_OptionNotImplementedAndStop},

    { "", "", NO_CMD, NULL }
};


static const RegistryCmdOptions JVM_Cmdtable_D[] =          // setting of properties
{
    { "HTTP_PROXY", "HTTP_PROXY",  STRING_JVM_OPTION, NULL},
    {"ShowSimDialog","ShowSimDialog",BOOL_JVM_OPTION,NULL},

    { "", "", NO_CMD, NULL }
};


extern int mg_nPrintDScreenOutput;
extern int mg_nPrintDLogfile;
extern int mg_ShowErrorMessages;
extern int mg_ShowInfoMessages;

// XTRACE parameters
#define CMFC_FILENAME_LEN   100
#define CMFC_USERNAME_LEN   30
#define CMFC_GENNAME_LEN    10
char xtraceFileName[CMFC_FILENAME_LEN ];
char xtraceUserName[CMFC_USERNAME_LEN ];
char xtraceGenName[CMFC_GENNAME_LEN ];

// autostart items:
static char JavaApp[MAX_ARG_STRING_LEN];
static int  JavaAppProcessed  = TRUE;
static int  StartTestProcessed= TRUE;
static int  StartTest, StartTestArg1, StartTestArg2, StartTestArg3;
static bool JavaAppViaCommandLineStarted;

extern "C" void info_message(const char *message, const char *head);


/** starts applications given on command line after successful initilization */

extern "C" void CheckAutoStartItems(void)
{
    if ( JavaAppProcessed == FALSE )
    {
        JavaAppProcessed= TRUE;
        
//        Kauai_Start( JavaApp, TRUE);
    }

/*
    if ( StartTestProcessed == FALSE )
    {
        StartTestProcessed= TRUE;
        if (StartTest == 1)                 // display test
            Display_AutoTest_Main( StartTestArg1, StartTestArg2, StartTestArg3);
    }
*/
}


/** copies next argument of given cmd line pointer
 *
 *  @param  CmdLine      source string ptr.
 *  @param  String       destination
 *  @param  BufferLength max. length of "String" buffer
 *
 *  @retval  cmd line pointer, shifted to next string part
*/

char* GetNextStringPart(char *CmdLine, char *String, int BufferLength)
{
    char  *p;
    bool  OneArgument= FALSE;

    while (*CmdLine == ' ')  CmdLine++;

    p = String;
    while ((*CmdLine != ' ' || OneArgument == TRUE) &&
            *CmdLine != '\0'                        &&
            *CmdLine != ','                         &&
            *CmdLine != '='                         &&
            --BufferLength > 0                         )
    {
        // process '"' signs, do not output them
        if (*CmdLine == '\"')
        {
            OneArgument ^= TRUE;
            CmdLine++;
            continue;
        }
        *p++ = *CmdLine++;
    }
    *p= '\0';

    return CmdLine;         // shifted to next string part
}


/** parses next boolean argument of given cmd line pointer
 *
 *  @param  CmdLine  source string ptr.
 *  @param  setting  result
 *
 *  @retval  cmd line pointer, shifted to next string part
*/

char* GetBooleanOption(char *CmdLine, bool *setting)
{
    bool  recognized = FALSE;
    char  limiter;
    int   i = 0;

    while (BoolTable[i].String[0] != '\0')
    {
        if (_strnicmp(CmdLine, BoolTable[i].String, strlen(BoolTable[i].String)) == 0)
        {
            *setting = BoolTable[i].result;
            recognized = TRUE;
            limiter = CmdLine[strlen( BoolTable[i].String)];
            break;
        }
        i++;
    }

    // test if limiter is valid:
    if ((limiter != ',' && limiter != ' ') || !recognized)
    {
        char  str[32];

        GetNextStringPart(CmdLine, str, 32);
        print_d("Warning: Unknown boolean setting in command line \"%s\" !", str);

        return CmdLine;
    }
    else
        return CmdLine + strlen(BoolTable[i].String);
}


BOOL JVM_OptionNotImplementedAndStop(char *Option)
{
    print_d("Warning: Option \"%s\" is not implemented.", Option);
    return FALSE;
}


BOOL JVM_OptionHasNoEffect( char *Option)
{
    print_d( "Warning: Option \"%s\" has no effect.", Option);
    return TRUE;
}


/** parses EUI conforming command line options like
 *   "-Xverbose:gc,class "   (boolean) or
 *   "-Xrunjdwp:suspend=no " (string-based)
 * and writes parse results to assigned registry strings
 *
 *  @param  CmdLine   source string ptr.
 *  @param  EuiCmd    the recognized EUI command
 *  @param  CmdTable  the data table of EuiCmd
 *
 *  @retval  cmd line pointer, shifted to next command
*/

char* ProcessEuiCommand( char *CmdLine, char *EuiCmd, const RegistryCmdOptions *CmdTable, bool *error)
{
    bool  OptionRecognized, setting;
    char  limiter;
    int   i, CmdOptionLen;
    char  StringValue[64];

    *error = FALSE;
    CmdLine += strlen(EuiCmd);          // go to first option
    do
    {
        i = 0;
        OptionRecognized = FALSE;

        while (CmdTable[i].CmdOption[0] != '\0')
        {
            CmdOptionLen = strlen(CmdTable[i].CmdOption);

            // search for matching option:
            if (_strnicmp(CmdLine, CmdTable[i].CmdOption, CmdOptionLen) == 0)
            {
                limiter = *(CmdLine +CmdOptionLen);

                if (limiter == ',' ||
                    limiter == ' ' ||
                    limiter == '='    )      // complete string compare
                {
                    if (CmdTable[i].type & BOOL_JVM_OPTION)
                    {
                        // write a boolean value
                        setting = TRUE;
                        if (limiter == '=')
                            CmdLine = GetBooleanOption(CmdLine +CmdOptionLen +1, &setting);

                        //WriteSimulatorRegistry(CmdTable[i].RegistryString, setting);
			UEI_Trace_options[i]=TRUE;
                        StartFromCommandline=TRUE;

                        OptionRecognized = TRUE;
                        break;
                    }

                    if (CmdTable[i].type & NUMBER_JVM_OPTION)
                    {
                        if (limiter == '=')
                            CmdLine = GetNextStringPart(CmdLine +CmdOptionLen +1, StringValue, 64);

                        WriteSimulatorRegistry(CmdTable[i].RegistryString, atoi(StringValue));
                        OptionRecognized = TRUE;
                        break;
                    }

                    if (CmdTable[i].type & STRING_JVM_OPTION)
                    {
                        // write a string value
                        strcpy(StringValue, "y");
                        if (limiter == '=')
                            CmdLine = GetNextStringPart(CmdLine +CmdOptionLen +1, StringValue, 64);

                        WriteSimulatorRegistryString(CmdTable[i].RegistryString, StringValue);
                        OptionRecognized = TRUE;
                        break;
                    }

                    if (CmdTable[i].type & CALL_FNT_JVM_OPTION)
                    {
                        // call a function which performs the desired action
                        if (    CmdTable[i].DoExtraAction != NULL)
                        if (! (*CmdTable[i].DoExtraAction)( CmdTable[i].CmdOption))
                            *error = TRUE;

                        OptionRecognized = TRUE;
                        break;
                    }
                }
            }
            i++;
        }

        if (OptionRecognized == FALSE)
        {
            char  str[32];

            GetNextStringPart(CmdLine, str, 32);
            print_d( "Warning: Unknown specifier in command line parameter \"%s%s\" !", EuiCmd, str);
        }

        // go to next option:
        while (*(CmdLine) != ',' && *(CmdLine) != ' ')
            CmdLine++;

    } while (*CmdLine++ == ',');

    return --CmdLine;
}


/** makes output of -Xquery command */

void PrintEmulatorInformation( void)
{
    char buf[20];

#ifdef JAVA_SDK
    char bootpath[128];
    int  result;
    int  bootpath_num =0 ;
#endif    

 //  const char *platformname = getSystemProperty ("microedition.platform", buf);
    printf("#\n");

//    printf("#     Siemens %s mobile phone emulator query results\n", platformname);
    printf("#\n\n");

    printf("# Device list\n");
    
//    printf("device.list: %s\n\n", platformname);

    printf("# Device properties\n");

//    printf("%s.description:     Siemens %s mobile phone emulator\n", platformname, platformname);
//    printf("%s.screen.width:    %d\n", platformname, DISP_LCD_WIDTH);
//    printf("%s.screen.height:   %d\n", platformname , DISP_LCD_HEIGHT);

#if DPLDRV_COLOR_TYPE == COLOR_BMP_16BIT

//    printf("%s.screen.isColor:  true\n",    platformname);
//    printf("%s.screen.bitDepth: 16\n",       platformname);
#else
    // @@@ take care of greyscale displays in future
//    printf("%s.screen.isColor:  false\n",   platformname);
//    printf("%s.screen.bitDepth: 1\n",       platformname);
#endif

//    printf("%s.screen.isTouch:  false\n\n", platformname);

#ifdef JAVA_SDK
    ReadSimulatorRegistryString("KJAVA_API_CLASSPATH",bootpath,&result);
    if (result == NO_ERROR){
	while(bootpath[bootpath_num] != '\0'){
		if (bootpath[bootpath_num] == '\\')
			bootpath[bootpath_num] = '/';
		bootpath_num++;
	}    
        printf("%s.bootclasspath:   %s\n\n", platformname,bootpath);
    }
#endif

    fflush( stdout);
}


/** process whole command line string
 *  @param  lpCmdLine  pointer to cmd. line
 *
 *  @retval  true : start simulation
             false: end program immediately
*/
#ifdef JAVA_SDK
extern "C" void Info_InitInfoMain(void);
#endif

bool ProcessCommandLine(LPSTR lpCmdLine)//Fang Yunchao modification for SMTK Localization,LPTSTR to LPSTR
{
    int   i;
    bool  recognized, help, UncheckOption= FALSE, error;
    char  *CmdLine, *CmdLine_malloc;

    mg_nPrintDScreenOutput= 0;
    mg_nPrintDLogfile     = 1;
    JavaApp[0]            = '\0';

    // XTRACE initialization
    xtraceFileName[0]    = '\0';
    xtraceUserName[0]    = '\0';
    xtraceGenName[0]     = '\0';

#ifdef JAVA_SDK
    // auto set "-s" as command line option
    mg_nPrintDScreenOutput= 0;
    mg_nPrintDLogfile     = 0;
    Info_InitInfoMain();
#endif

    CmdLine = CmdLine_malloc = (char*) malloc( strlen(lpCmdLine) +2);

    strcpy(CmdLine, lpCmdLine);
    strcat(CmdLine, " ");          // helps parsing last option
    InitSimulatorRegistry();

    while (CmdLine[0] != '\0')      // parse all options
    {
        /////////////////////////////////////////////////////
        // some preparations

        if (CmdLine[0] == ' ')
        {
            CmdLine++;
            continue;
        }

        if (CmdLine[0] == '-')      // for unix users ;-)
            CmdLine[0] = '/';

        recognized= FALSE;
        help      = FALSE;
        error     = FALSE;

        if (_strnicmp( CmdLine, "! ", 2) == 0)
        {
            UncheckOption= TRUE;
            CmdLine++;
            CmdLine++;
            continue;
        }

        /////////////////////////////////////////////////////
        // Start Java App

        if (_strnicmp( CmdLine, "/sj "          , 4 ) == 0 ||
            _strnicmp( CmdLine, "/StartJavaApp ", 14) == 0 ||
            _strnicmp( CmdLine, "/Xdescriptor:" , 13) == 0   )
        {
            while (*CmdLine != ' ' && *CmdLine != ':')
                CmdLine++;

            CmdLine++;
            CmdLine = GetNextStringPart(CmdLine, JavaApp, MAX_ARG_STRING_LEN);
            JavaAppProcessed = FALSE;
            recognized = TRUE;
        }

        /////////////////////////////////////////////////////
        // Print Emulator Information
#ifdef JAVA_SDK
        if (_strnicmp(CmdLine, "/Xquery ", 8 ) == 0)
        {
	    //Info_InitInfoMain();
            PrintEmulatorInformation();
            recognized = TRUE;
            error = TRUE;            // to stop execution
        }
#endif	

        /////////////////////////////////////////////////////
        // Start a test
/*
        if (_strnicmp( CmdLine, "/st "       , 4 ) == 0 ||
            _strnicmp( CmdLine, "/StartTest ", 11) == 0   )
        {
            char STest[MAX_ARG_STRING_LEN];

            while ( *CmdLine != ' ')  CmdLine++;
            CmdLine= GetNextStringPart(CmdLine, STest, MAX_ARG_STRING_LEN);

            if (_strnicmp( STest, "DPL", 3) == 0 )
            {
                // display driver tests
                StartTestProcessed= FALSE;
                StartTest    = 1;           // display

                CmdLine      = GetNextStringPart(CmdLine, STest, MAX_ARG_STRING_LEN);
                StartTestArg1= atoi( STest);
                CmdLine      = GetNextStringPart(CmdLine, STest, MAX_ARG_STRING_LEN);
                StartTestArg2= atoi( STest);
                CmdLine      = GetNextStringPart(CmdLine, STest, MAX_ARG_STRING_LEN);
                StartTestArg3= atoi( STest);

                recognized   = TRUE;
            }
        }
*/

#ifndef JAVA_SDK
        /////////////////////////////////////////////////////
        // /P (verbose mode)

        if (_strnicmp(CmdLine, "/P ", 3) == 0 )
        {
            mg_nPrintDScreenOutput = 1;
            mg_nPrintDLogfile = 1;
            recognized= TRUE;
        }

        /////////////////////////////////////////////////////
        // /S (silent mode)

        if (_strnicmp(CmdLine, "/F ", 3) == 0)    // verbose mode, write all logfiles (incl. mmi.log) => very slow !
        {
		    mg_nPrintDScreenOutput = 0;
		    mg_nPrintDLogfile = 2;
            recognized = TRUE;
        }
        else if (_strnicmp(CmdLine, "/S ", 3) == 0)
        {
            mg_nPrintDScreenOutput = 0;
            mg_nPrintDLogfile = 0;
            recognized = TRUE;
        }

        /////////////////////////////////////////////////////
        // XTRACE options /T /U /G

        if (_strnicmp(CmdLine, "/T ", 3) == 0)
        {
            while (*CmdLine != ' ')  CmdLine++;
            CmdLine = GetNextStringPart(CmdLine, xtraceFileName, CMFC_FILENAME_LEN);

            recognized = TRUE;
        }
        if (_strnicmp( CmdLine, "/U ", 3) == 0 )
        {
            while (*CmdLine != ' ')  CmdLine++;
            CmdLine = GetNextStringPart(CmdLine, xtraceUserName, CMFC_USERNAME_LEN);

            recognized = TRUE;
        }
        if (_strnicmp(CmdLine, "/G ", 3) == 0 )
        {
            while (*CmdLine != ' ')  CmdLine++;
            CmdLine = GetNextStringPart(CmdLine, xtraceGenName, CMFC_GENNAME_LEN);

            recognized = TRUE;
        }
#endif

        /////////////////////////////////////////////////////
        // turn on/off all tracing JVM options

        if (_strnicmp(CmdLine, "/traceall ", 10) == 0 ||
            _strnicmp(CmdLine, "/Xverbose ", 10) == 0 ||
            _strnicmp(CmdLine, "/Xverbose:all ", 14) == 0 )
        {
            i = 0;
/* To fix UEI java trace options bug */
/*  while (JVM_Cmdtable[i].CmdOption[0] != '\0')
            {
                if (JVM_Cmdtable[i].type == TRACING_JVM_OPTION)
                {
                    WriteSimulatorRegistry(JVM_Cmdtable[i].RegistryString, UncheckOption ? FALSE : TRUE);
                }
                i++;
            }
*/
           while (JVM_Cmdtable_Xverbose[i].CmdOption[0] != '\0')
            {
               UEI_Trace_options[i]=TRUE;
                i++;
            }
    	    UEI_Trace_all=TRUE;
            StartFromCommandline=TRUE;

            // set correct trace mode:
            WriteSimulatorRegistry("mg_Tracing", UncheckOption ? FALSE : TRUE);
            recognized = TRUE;
        }

        ///////////////////////////////////////////////////////////////////
        // several JVM options

        i = 0;
        if (!recognized)
        while (JVM_Cmdtable[i].CmdOption[0] != '\0' )
        {
            if (_strnicmp(CmdLine, JVM_Cmdtable[i].CmdOption, strlen( JVM_Cmdtable[i].CmdOption) ) == 0)
            {
                if (JVM_Cmdtable[i].type & BOOL_JVM_OPTION)
                {
                    WriteSimulatorRegistry(JVM_Cmdtable[i].RegistryString, UncheckOption ? FALSE : TRUE);
                }

                if (JVM_Cmdtable[i].type & CALL_FNT_JVM_OPTION)
                {
                    // call a function which performs the desired action
                    if (     JVM_Cmdtable[i].DoExtraAction != NULL)
                    if ( ! (*JVM_Cmdtable[i].DoExtraAction)( JVM_Cmdtable[i].CmdOption) )
                        error = TRUE;
                }
                recognized= TRUE;
                break;
            }
            i++;
        }

        ///////////////////////////////////////////////////////////////////
        // several options with string argument, stored in registry only

        i = 0;
        if (!recognized)
        while (JVM_Cmdtable_WithArg[i].CmdOption[0] != '\0')
        {
            if (_strnicmp(CmdLine, JVM_Cmdtable_WithArg[i].CmdOption,
                            strlen( JVM_Cmdtable_WithArg[i].CmdOption) ) == 0 )
            {
                char Argument[MAX_ARG_STRING_LEN];

                while (*CmdLine != ' ' &&  *CmdLine != ':')
                    CmdLine++;

                if (*CmdLine == ':')
                    CmdLine++;
                CmdLine = GetNextStringPart(CmdLine, Argument, MAX_ARG_STRING_LEN);

                if (JVM_Cmdtable_WithArg[i].type & STRING_JVM_OPTION)
                {
                    WriteSimulatorRegistryString(JVM_Cmdtable_WithArg[i].RegistryString, Argument);
                }
                else if (JVM_Cmdtable_WithArg[i].type & NUMBER_JVM_OPTION)
                {
                    WriteSimulatorRegistry(JVM_Cmdtable_WithArg[i].RegistryString, atoi(Argument));
                }

                if (JVM_Cmdtable_WithArg[i].type & CALL_FNT_JVM_OPTION)
                {
                    // call a function which performs the desired action
                    if ( JVM_Cmdtable_WithArg[i].DoExtraAction != NULL)
                    {
                        if ( ! (*JVM_Cmdtable_WithArg[i].DoExtraAction)( Argument ) )
                        {
                            error = TRUE;
                        }
                    }
                }

                recognized = TRUE;
                break;
            }
            i++;
        }

        /////////////////////////////////////////////////////
        // new UEI style to set boolean "-Xverbose" options

        if (!recognized)
        if (_strnicmp(CmdLine, "/Xverbose:", 10) == 0)
        {
            CmdLine = ProcessEuiCommand(CmdLine, "-Xverbose:", JVM_Cmdtable_Xverbose, &error);
            // assume trace mode is requested:
            WriteSimulatorRegistry("mg_Tracing", TRUE);
            recognized = TRUE;
        }

        /////////////////////////////////////////////////////
        // UEI options to start JDWP debug session

        if ((_strnicmp(CmdLine, "/Xrunjdwp:", 10) == 0))
        {
            CmdLine = ProcessEuiCommand(CmdLine, "-Xrunjdwp:", JVM_Cmdtable_Xrunjdwp, &error);
            recognized = TRUE;
        }

        /////////////////////////////////////////////////////
        // UEI options to start JAM

        if ((_strnicmp(CmdLine, "/Xjam:", 6) == 0))
        {
            CmdLine = ProcessEuiCommand(CmdLine, "-Xjam:", JVM_Cmdtable_Xjam, &error);
            recognized = TRUE;
        }

        /////////////////////////////////////////////////////
        // UEI options to set properties

        if (!recognized)                           // is important to separate from "-dj"
        if ((_strnicmp(CmdLine, "/D", 2) == 0))
        {
            CmdLine = ProcessEuiCommand(CmdLine, "-D", JVM_Cmdtable_D, &error);
            recognized = TRUE;
        }

        /////////////////////////////////////////////////////
        // Version info

        if (_strnicmp(CmdLine, "/V "      , 3) == 0 ||
            _strnicmp(CmdLine, "/version ", 9) == 0   )
        {
            char szBuf[20];
//            const char *platformname = getSystemProperty ("microedition.platform", szBuf);

  //          printf("Siemens Mobility Toolkit for %s (built: %s, %s)\n", platformname, __DATE__, __TIME__);
//            printf("%s\n",getSystemProperty("microedition.profiles", szBuf));
            
//            printf("%s\n",getSystemProperty("microedition.configuration", szBuf));
            fflush( stdout);

            recognized = TRUE;
            error = TRUE;            // to stop execution
        }

        /////////////////////////////////////////////////////
        // Help Info

        if ( _strnicmp(CmdLine, "/? "   , 3) == 0 ||
             _strnicmp(CmdLine, "/H "   , 3) == 0 ||
             _strnicmp(CmdLine, "/Help ", 6) == 0    )
        {
            char msg[2048];

            sprintf( msg, "This emulator fully supports the Unified Emulator Interface (UEI v0.91).\n");
            sprintf( msg, "%sPlease take a look at UEI documentation for detailed information.\n\n", msg);
            sprintf( msg, "%sAdditional command line parameters:\n\n", msg);
/*
            sprintf(msg, "%s-? or -help 	... Issues help information.\n", msg);
            sprintf(msg, "%s-v or -version 	... Displays emulator version information.\n\n\n", msg);
*/
            sprintf(msg, "%s-Dhttp_proxy <proxy>     ... Defines a proxy for http connection.\n", msg);

#ifndef JAVA_SDK
            sprintf(msg, "%s-sj <file> or -StartJavaApp <file> ... Starts java application <file> immediately.\n", msg);
            sprintf(msg, "%s-dj	or -DebugJavaApp ... Debugs java applications.\n", msg);
            sprintf(msg, "%s-cp <path> or -ClassPath <path>	... Changes java class path to <path>.\n", msg);
            sprintf(msg, "%s-acp <path> or -APIClassPath <path>	... Changes java API class path to <path>.\n", msg);
            sprintf(msg, "%s-l <port> or -DebugProxyPort <port>	... Changes java debug proxy port number to <port>.\n", msg);
            sprintf(msg, "%s-jdk <path> or -JDKHome <path> ... Will use the given jdk to start the debug proxy.\n\n", msg);

            // -s is auto set in java SDK:
            sprintf(msg, "%s-s ... Suppresses debugging information (speeds up execution).\n", msg);
            sprintf(msg, "%s-p ... More debugging information (slows down execution).\n", msg);
            sprintf(msg, "%s-trace<...> ... Several trace options. See CLDC-HI Porting Guide.\n", msg);
            sprintf(msg, "%s-tracing ... Turns on VM trace mode.\n\n", msg);
            // XTRAC Help
            sprintf(msg, "%sIf the next three parameters are passed, a log file is created\n", msg);
            sprintf(msg, "%swhich can afterwards be analysed with Winresi:\n", msg);
            sprintf(msg, "%s-t <filename> ... XTRACE log file name (must have extension .trn).\n", msg);
            sprintf(msg, "%s-u <username> ... username for XTRACE log file.\n", msg);
            sprintf(msg, "%s-g <gen-name> ... SW generation for XTRACE log file (e.g. ken8).\n\n", msg);
#endif
            sprintf(msg, "%s-ShowErrors ... Turns on error report mode.\n", msg);
            sprintf(msg, "%s-ShowInfos ... Turns on information mode.\n", msg);
            sprintf(msg, "%s! ... Turns off next (boolean) option.\n\n\n\n", msg);
            sprintf(msg, "%sSiemens AG IC Mobile\nICM MP Munich, Germany   www.siemens.de-mobile\n\n", msg);
            sprintf(msg, "%s (C) 2003\n", msg);

            mg_ShowInfoMessages = TRUE;
            info_message(msg, "Available Command Line Parameters" );

            error = TRUE;            // to stop execution
        }

        if ( error)
        {
            free( CmdLine_malloc);
            return FALSE;
        }

        /////////////////////////////////////////////////////
        // unrecognized option

        if ( recognized == FALSE)
        {
            char *lastDot;

            // assume this is the application (class) to start
            CmdLine = GetNextStringPart(CmdLine, JavaApp, MAX_ARG_STRING_LEN);

            lastDot = strrchr(JavaApp, '.');
            if (lastDot == NULL      ||
                  (strcmp(lastDot, ".class") != 0 &&
                   strcmp(lastDot, ".jad")   != 0 &&
                   strcmp(lastDot, ".jar")   != 0   ) )
               strcat(JavaApp, ".class");

            JavaAppProcessed = FALSE;
            recognized = TRUE;
        }

        // go to next option:
        while (*CmdLine != ' ' && *CmdLine != '\0')
            CmdLine++;

        UncheckOption = FALSE;           // reset this flag
    }               // while (arguments)

    free(CmdLine_malloc);
    return TRUE;
}


extern "C" BOOL JavaAppViaCommandLineRunning(void)
{
    return JavaAppViaCommandLineStarted;
}
