/*
		      Siemens AG
		 Mobile Radio Terminals
		    Munich, Germany

.AUTHOR         Anastasios Leontarakis, ICP CD MP GSM RD M 53

.SHORT_DESCR    PC-Testumgebung

.SW_COMPONENT	Softkeys-View

.STATUS         OFFICAL

.CHANGE_CONTROL
Version |  Date  | Changed by | Reason for Change
  1.0    12.04.99 A.Leontarakis file created, Fx-Taste Behandlung
  1.1    25.01.00 N.Faisst      added cast to DLGPROC due to migration Borland C -> MS-VC

------------------------------ L55 fugu -------------------------------------------------------
 9.20.00 2002-10-08  Reinhard Zoll (MchG)
                                new message ID introduced:  M_MMI_SLIDER_MOVED

 9.20.01 2003-05-19  N.Barisits (VIE)
                     include "g_gbs_h.h" removed
 9.21.00 2003-10-07  M.Korkmaz (MCH)
                     Softkeys (Open, Close) for ClamShell Display added
 9.21.03 2003-10-23  M.Korkmaz (MCH)
                     BugFix: Freeze of PC-Simu after radio button was checked
10.00.00 2004-04-02  C.Rffer (MCH)
                     changed KeyboardKeyDown/Up to KeyboardButtonDown/Up
10.01.00 2004-04-06  M.Korkmaz (MCH)
                     Default position of slider is now middle
*/

#include "winmain.h"
#include "winrc.h"
#include "winkrc.h"
#include "sms_res.h"

extern "C"
{
#include <global.h>
#include "glob_msg.h"
#include "skviewh.h"
#include "ddcode0h.h"
#include "procid.h"
#include "keypad.h"
#include "gbs.h"
#include "kbddrv.h"
}

extern "C" HWND DispGetWinHandle(void);

static HWND hStoftKeysBox;

/* Timer used for delayed delivery of slider message. */
/* Delay if two messages have to be send at once:     */
/*   Slider movement via defined radio-button generates a call to a one of the "KeyboardKey..." functions. */
/*   if the movement is performed directly from open to close there have to be generated two calls */
/*   the second call with some milliseconds delay. */
typedef enum 
{
    TIMER_SW0ON = 1,    /* used for slider movement from  OPEN  to CLOSE */
    TIMER_SW1ON,        /* used for slider movement from  CLOSE to OPEN  */
    TIMER_KEYUP
} e_SliderMsgTimer;

static unsigned char szKeyup = EOB;

void softKeyPressed(unsigned int snr)
{
	unsigned int warteZeit;

        warteZeit = 50;

	if (hStoftKeysBox != NULLP)
        {
        	switch (snr)
                {
                	// Setzen ...
        		case 1: CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON1, BST_CHECKED);
                		Sleep(warteZeit);
                        	CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON1, BST_UNCHECKED);
                        	break;
        		case 2: CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON2, BST_CHECKED);
                		Sleep(warteZeit);
                        	CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON2, BST_UNCHECKED);
                        	break;
        		case 3: CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON3, BST_CHECKED);
                		Sleep(warteZeit);
                        	CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON3, BST_UNCHECKED);
                        	break;
        		case 4: CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON4, BST_CHECKED);
                		Sleep(warteZeit);
                        	CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON4, BST_UNCHECKED);
	                       	break;
        		case 5: CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON5, BST_CHECKED);
                		Sleep(warteZeit);
                        	CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON5, BST_UNCHECKED);
                        	break;
        		case 6: CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON6, BST_CHECKED);
                		Sleep(warteZeit);
                        	CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON6, BST_UNCHECKED);
                        	break;
        		case 7: CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON7, BST_CHECKED);
                		Sleep(warteZeit);
                        	CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON7, BST_UNCHECKED);
                        	break;
        		case 8: CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON8, BST_CHECKED);
                		Sleep(warteZeit);
                        	CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON8, BST_UNCHECKED);
	                       	break;
        		case 9: CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON9, BST_CHECKED);
                		Sleep(warteZeit);
                        	CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON9, BST_UNCHECKED);
                        	break;
        		case 10: CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON10, BST_CHECKED);
                		Sleep(warteZeit);
                        	CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON10, BST_UNCHECKED);
                        	break;
        		case 11: CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON11, BST_CHECKED);
                                 Sleep(warteZeit);
                                 CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON11, BST_UNCHECKED);
                                 break;
        		case 12: CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON12, BST_CHECKED);
                		 Sleep(warteZeit);
                                 CheckDlgButton(hStoftKeysBox, IDC_RADIOBUTTON12, BST_UNCHECKED);
                                 break;
                }
        }
}

#pragma warn -par
BOOL CALLBACK SoftkeysViewDlgProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
        switch (message)
        {
                case WM_CLOSE:
        	        hStoftKeysBox = 0;
	                DestroyWindow(hwndDlg);
		return TRUE;

                case WM_WINDOWPOSCHANGED:
                case WM_RBUTTONUP:
                case WM_LBUTTONUP:
                case WM_LBUTTONDBLCLK:
                        if (GetFocus() != DispGetWinHandle())
                        {
                          // SetFocus(DispGetWinHandle());
                        }
                break;
                case WM_TIMER:
                    KillTimer(hStoftKeysBox , wParam);
                    switch (wParam) 
                    {
                        case TIMER_SW0ON:
                                KeyboardButtonDown(SW0ON);
                                szKeyup = SW0ON;
                                SetTimer (hStoftKeysBox, TIMER_KEYUP, 40 , NULL);
                                break;
                        case TIMER_SW1ON:
                                KeyboardButtonDown(SW1ON);
                                szKeyup = SW1ON;
                                SetTimer (hStoftKeysBox, TIMER_KEYUP, 40 , NULL);
                                break;
                        case TIMER_KEYUP:
                                KeyboardButtonUp(szKeyup);
                                break;
                        default:    break;
                    }
                    ;
                break;
                case WM_COMMAND:
                    switch (LOWORD(wParam))
                    {
                        case IDC_SLIDER_CLOSED:
                            if (IsDlgButtonChecked(hStoftKeysBox, IDC_SLIDER_CLOSED))
                                break;
                            if (IsDlgButtonChecked(hStoftKeysBox, IDC_SLIDER_BETWEEN))
                            {   // Moved from middle possition to closed MMI_Main_Process
                                KeyboardButtonDown(SW0ON);      // Function call in behalf of counter-handling
                                szKeyup = SW0ON;
                                SetTimer (hStoftKeysBox, TIMER_KEYUP, 40 , NULL);
                            }
                            if (IsDlgButtonChecked(hStoftKeysBox, IDC_SLIDER_OPEN))
                            {   // Moved from open possition to closed
                                KeyboardButtonDown(SW1OFF);     // Function call in behalf of counter-handling
                                                                // Postpone call of Key Up in case of unlink both events
                                szKeyup = SW1OFF;
                                SetTimer (hStoftKeysBox, TIMER_KEYUP, 40 , NULL);
                                SetTimer (hStoftKeysBox, TIMER_SW0ON, 50 , NULL);
                                //KeyboardButtonDown(SW0ON);    // Function call in behalf of counter-handling
                            }
                            CheckDlgButton(hStoftKeysBox, IDC_SLIDER_CLOSED , BST_CHECKED);
                            CheckDlgButton(hStoftKeysBox, IDC_SLIDER_BETWEEN, BST_UNCHECKED);
                            CheckDlgButton(hStoftKeysBox, IDC_SLIDER_OPEN   , BST_UNCHECKED);
                            break;
                        case IDC_SLIDER_BETWEEN:
                            if (IsDlgButtonChecked(hStoftKeysBox, IDC_SLIDER_BETWEEN))
                                break;
                            if (IsDlgButtonChecked(hStoftKeysBox, IDC_SLIDER_CLOSED))
                            {   // Moved from closed possintion to middle
                                KeyboardButtonDown(SW0OFF);     // Function call in behalf of counter-handling
                                szKeyup = SW0OFF;
                                SetTimer (hStoftKeysBox, TIMER_KEYUP, 40 , NULL);
                            }
                            if (IsDlgButtonChecked(hStoftKeysBox, IDC_SLIDER_OPEN))
                            {   // Moved from open possition to middle
                                KeyboardButtonDown(SW1OFF);     // Function call in behalf of counter-handling
                                szKeyup = SW1OFF;
                                SetTimer (hStoftKeysBox, TIMER_KEYUP, 40 , NULL);
                            }
                            CheckDlgButton(hStoftKeysBox, IDC_SLIDER_CLOSED , BST_UNCHECKED);
                            CheckDlgButton(hStoftKeysBox, IDC_SLIDER_BETWEEN, BST_CHECKED);
                            CheckDlgButton(hStoftKeysBox, IDC_SLIDER_OPEN   , BST_UNCHECKED);
                            break;
                        case IDC_SLIDER_OPEN:
                            if (IsDlgButtonChecked(hStoftKeysBox, IDC_SLIDER_OPEN))
                                break;
                            if (IsDlgButtonChecked(hStoftKeysBox, IDC_SLIDER_BETWEEN))
                            {   // Moved from middle possition to open
                                KeyboardButtonDown(SW1ON);      // Function call in behalf of counter-handling
                                szKeyup = SW1ON;
                                SetTimer (hStoftKeysBox, TIMER_KEYUP, 40 , NULL);
                            }
                            if (IsDlgButtonChecked(hStoftKeysBox, IDC_SLIDER_CLOSED))
                            {   // Moved from closed possition to open
                                KeyboardButtonDown(SW0OFF);     // Function call in behalf of counter-handling
                                                                // Postpone call of Key Up in case of unlink both events
                                szKeyup = SW0OFF;
                                SetTimer (hStoftKeysBox, TIMER_KEYUP, 40 , NULL);
                                SetTimer (hStoftKeysBox, TIMER_SW1ON, 50 , NULL);
                                //KeyboardButtonDown(SW1ON);    // Function call in behalf of counter-handling
                            }
                            CheckDlgButton(hStoftKeysBox, IDC_SLIDER_CLOSED , BST_UNCHECKED);
                            CheckDlgButton(hStoftKeysBox, IDC_SLIDER_BETWEEN, BST_UNCHECKED);
                            CheckDlgButton(hStoftKeysBox, IDC_SLIDER_OPEN   , BST_CHECKED);
                            break;
                          
                         ///// Clam Shell Display Softkeys ////
                          case IDC_CLAMSHELL_OPEN:
                            if (IsDlgButtonChecked(hStoftKeysBox, IDC_CLAMSHELL_OPEN))
                                break;
                            if (IsDlgButtonChecked(hStoftKeysBox, IDC_CLAMSHELL_CLOSED))
                            {
                                // interface function for action by opening of ClamShell Display
                            }
                            CheckDlgButton(hStoftKeysBox, IDC_CLAMSHELL_CLOSED, BST_UNCHECKED);
                            CheckDlgButton(hStoftKeysBox, IDC_CLAMSHELL_OPEN,   BST_CHECKED);
                            break;
                         case IDC_CLAMSHELL_CLOSED:
                            if (IsDlgButtonChecked(hStoftKeysBox, IDC_CLAMSHELL_CLOSED))
                                break;
                            if (IsDlgButtonChecked(hStoftKeysBox, IDC_SLIDER_OPEN))
                            {  
                                // interface function for action by closing of ClamShell Display
                            }
                            CheckDlgButton(hStoftKeysBox, IDC_CLAMSHELL_CLOSED, BST_CHECKED);
                            CheckDlgButton(hStoftKeysBox, IDC_CLAMSHELL_OPEN,   BST_UNCHECKED);
                            break;
                        default:
                            break;
                        }
                break;
	}

        return FALSE;
}
#pragma warn +par


extern "C" void openSoftKeyViewDLG(void)
{
	if(hStoftKeysBox != NULL)
        	return;
#ifdef _MSC_VER
	hStoftKeysBox = CreateDialog(MainApp::hInstance, MAKEINTRESOURCE(DLG_SOFTKEYVIEW), DispGetWinHandle(),(DLGPROC)SoftkeysViewDlgProc);
#else
	hStoftKeysBox = CreateDialog(MainApp::hInstance, MAKEINTRESOURCE(DLG_SOFTKEYVIEW), DispGetWinHandle(),(FARPROC)SoftkeysViewDlgProc);
#endif
        if (hStoftKeysBox == NULL)
        {
                print_d("ERROR in creating Softkeys Box Window!");
                MessageBox( DispGetWinHandle(), "Error: Could not create Softkeys Box Window",
                                "PC-Simulator: Softkeys",
                                (MB_OK | MB_ICONEXCLAMATION) | MB_TASKMODAL );
                return;
        }
        else
        {

                // position is relatively to Display Window underneath, right border aligned
                RECT displrect, viewrect;
                LONG dx, dy;

                GetWindowRect(DispGetWinHandle(),&displrect);
                GetWindowRect(hStoftKeysBox, &viewrect);

                dx = viewrect.right - viewrect.left;
                dy = viewrect.bottom - viewrect.top;

                viewrect.top = displrect.bottom + 10;
                viewrect.bottom = viewrect.top + dy;

                viewrect.right = displrect.right;
                viewrect.left = viewrect.right - dx;

 //               MoveWindow(hStoftKeysBox, viewrect.left, viewrect.top, dx, dy, TRUE);

                ShowWindow(hStoftKeysBox, SW_SHOW);
                // default position of slider 
                CheckDlgButton(hStoftKeysBox, IDC_SLIDER_BETWEEN   , BST_CHECKED);
                
                // Default position of ClamShell Window
                CheckDlgButton(hStoftKeysBox, IDC_CLAMSHELL_CLOSED   , BST_CHECKED);
        }
}
