/**********************************************************************
*
*	C++ Source:		mpscswnd.cpp
*	Instance:		mec_1
*	Description:	
*	%created_by:	fangyunc %
*	%date_created:	2004-06-17 14:23:33 %
*
**********************************************************************/


#include "smsafxh.h"
#include "simuapph.h"

#include "mpscswndh.h"
BEGIN_MESSAGE_MAP(CClampShellScreenWnd, CDockingWnd)
    //{{AFX_MSG_MAP(CClampShellScreenWnd)
    ON_WM_CREATE()
    ON_WM_SIZE()
    ON_WM_LBUTTONDOWN()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/**                                                                       
 *  Constructor of CClampShellScreenWnd.  
 */  
CClampShellScreenWnd::CClampShellScreenWnd()
{

}

/**                                                                       
 *  Destructor of CClampShellScreenWnd.  
 */
CClampShellScreenWnd::~CClampShellScreenWnd()
{

}


/**                                                                       
 *  The function creates an object of MMIDispWindow.  
 */      
int CClampShellScreenWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
    if (CDockingWnd::OnCreate(lpCreateStruct) == -1)
        return -1;


    
    // Create an object of ClampShellDispWindow
    if (!m_cCSDisp.Create(_T("CLAMP_SHELL_WINDOW"), NULL, AFX_WS_DEFAULT_VIEW, 
                            CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST+10, NULL))
    {
        TRACE0("Failed to create view window\n");
        return -1;
    }
    // Set the object in CMFC_Simulation_App 
    GET_APP()->SetClampShellDispWindow(&m_cCSDisp);
    return 0;
}

/**                                                                       
 *   Funtion to resize also child windows  
 */   
void CClampShellScreenWnd::OnSize(UINT nType, int cx, int cy) 
{
    CDockingWnd::OnSize(nType, cx, cy);
    m_cCSDisp.SetWindowPos (NULL, -1, -1, cx, cy, SWP_SHOWWINDOW);
    m_cCSDisp.Invalidate();    
}
/**
 *  Function to let the MMIDispWindow have first crack.
 */
BOOL CClampShellScreenWnd::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
    if (m_cCSDisp.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
       return TRUE;
    

    return CWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

/**                                                                       
 *  Function to set focus if the user has clicked with the 
 *  leftmousebutton.  
 */                  
void CClampShellScreenWnd::OnLButtonDown(UINT nFlags, CPoint point)
{
    m_cCSDisp.SetActiveWindow();
    m_cCSDisp.SetFocus();
    CDockingWnd::OnLButtonDown(nFlags, point);
}



