/** @file */
/* ----------------------------------------------------------------------------

Copyright (C) Siemens AG 1994-2001 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_c.c,v, Revision: 1.9, genxfile V1.11

.AUTHOR Marian Kremnican BTS

.FILENAME mobile_simu_sqr.c

.CSVERSION 1.1

.VERSION 01.02.0

.DATE 2004-08-22

.SHORT_DESCR  Selection Query Response for mobile simulation

.SW_COMPONENT 

.SW_TYPE 


.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
01.00.00 2004-01-19 Marian Kremnican (BTS)
         Initial Version
01.01.00 2004-03-01 Marian Kremnican (BTS)
         Variable g_MMIMode replaced by mg_MMIMode
01.02.00 2004-08-22 Alex Nagy (MCH/BS)
         integrated SddWAS to PC-MMI -> removed Modeman_RegisterSelectionQueryHandler()
         calls for accessory
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    INCLUDES
------------------------------------------------------------------------------*/
#include <global.h>
#include "modeman_ci.h"
#include "mmi.h"
//#include "msmodes.h"
//#include "mopiext.h"


extern T_MMIMode  mg_MMIMode;       // defined in winpdisp.cpp

/* -----------------------------------------------------------------------------
Next simulation mode can be set in menu "Debugging/Tracing > Mode at next startup"
This mode is saved in a variable mg_MMIMode and can be checked for its value
at startup phase of simulation program. The modeman provides a mechanism to do that
using a registration of "Selection Query Response" procedure in it's internal table.
The SQR procedure is called with one of these value (see modeman_ms.h)
typedef enum
{
	E_MODEMAN_SQ_KEYPAD_ONOFF_KEY_IS_PRESSED = 0,
	E_MODEMAN_SQ_ACCESSORY_CARKIT_IS_PRESENT,
	E_MODEMAN_SQ_ACCESSORY_EXTERNAL_POWER_IS_PRESENT,
	E_MODEMAN_SQ_RTC_ALARM_IS_PENDING,
	E_MODEMAN_SQ_MEASUREMENT_BATTERY_POWER_IS_OK,
	E_MODEMAN_SQ_COUNT
} E_MODEMAN_SELECTION_QUERY;

The returne value must be one of
typedef enum {
	E_MODEMAN_SQR_NO = 0,
	E_MODEMAN_SQR_YES
} E_MODEMAN_SELECTION_QUERY_RESPONSE;

In this module the appropriate SQR procedures for simulation are defined.
------------------------------------------------------------------------------*/
/**
 *  \brief  Selection query handler for mobile simulation
 *
 *  According to value of mg_MMIMode the response to query is build.
 *  For simulation the charge mode and alarm mode are defined yet.
 *
 *  \param  query_in			query to which the handler returns an answer
 *  \retval E_MODEMAN_SQR_NO	don't switch in the queried mode
            E_MODEMAN_SQR_YES   switch in the queried mode
 */

E_MODEMAN_SELECTION_QUERY_RESPONSE Mobsim_SelectionQueryResponse( E_MODEMAN_SELECTION_QUERY query_in )
{
    // preset the response to NO
    E_MODEMAN_SELECTION_QUERY_RESPONSE retVal = E_MODEMAN_SQR_NO;

    switch( query_in )
    {
    case 	E_MODEMAN_SQ_KEYPAD_ONOFF_KEY_IS_PRESSED:
        if( mg_MMIMode == e_normal_mode )
           retVal = E_MODEMAN_SQR_YES;
        break;
    case E_MODEMAN_SQ_ACCESSORY_CARKIT_IS_PRESENT:
        ;       // always return NO; TODO: check the carkit in SIMU ??
        break;
    case E_MODEMAN_SQ_ACCESSORY_EXTERNAL_POWER_IS_PRESENT:
        if( mg_MMIMode == e_charge_mode )
           retVal = E_MODEMAN_SQR_YES;
        break;
    case E_MODEMAN_SQ_RTC_ALARM_IS_PENDING:
        if( mg_MMIMode == e_alarm_mode )
           retVal = E_MODEMAN_SQR_YES;
        break;
    case E_MODEMAN_SQ_MEASUREMENT_BATTERY_POWER_IS_OK:
        retVal = E_MODEMAN_SQR_YES;     // battery power allways OK in SIMU
        break;
    default:
        ;   // unknonw query_in, return NO
    }

    return retVal;
}

/**
 *  \brief  Register simulation Selection Query Respond procedures by Modeman
 *
 */
void Mobsim_RegisterSQRHandler( void )
{
    Modeman_RegisterSelectionQueryHandler( E_MODEMAN_SQ_KEYPAD_ONOFF_KEY_IS_PRESSED,
                                           Mobsim_SelectionQueryResponse );
    //Modeman_RegisterSelectionQueryHandler( E_MODEMAN_SQ_ACCESSORY_CARKIT_IS_PRESENT,
    //                                       Mobsim_SelectionQueryResponse );
    //Modeman_RegisterSelectionQueryHandler( E_MODEMAN_SQ_ACCESSORY_EXTERNAL_POWER_IS_PRESENT,
    //                                       Mobsim_SelectionQueryResponse );
    Modeman_RegisterSelectionQueryHandler( E_MODEMAN_SQ_RTC_ALARM_IS_PENDING,
                                           Mobsim_SelectionQueryResponse );
    Modeman_RegisterSelectionQueryHandler( E_MODEMAN_SQ_MEASUREMENT_BATTERY_POWER_IS_OK,
                                           Mobsim_SelectionQueryResponse );
}
/* -----------------------------------------------------------------------------
    END OF FILE mobile_simu_sqr.c
------------------------------------------------------------------------------*/
