/** @file */
/* ----------------------------------------------------------------------------

Copyright (C) Siemens AG 1994-2001 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_c.c,v, Revision: 1.9, genxfile V1.11

.AUTHOR                     Y.Lei

.FILENAME                   mmicsdisp.cpp

.TODO                       

.CSVERSION                  1.1

.VERSION                    see CHANGE_CONTROL

.DATE                       see CHANGE_CONTROL

.SHORT_DESCR                Clam Shell Display Support

.SW_COMPONENT               PC Simulation

.SW_TYPE                    

.EXIT_CODES                 

.CHANGE_CONTROL 
Version     Date        Changed by          Reason of change
--------------------------------------------------------------------------------
00.00.00    2003-07-15  Y. Lei (MCH)        file created...
00.01.00    2003-08-27  C.Rffer (MCH)      removed DispSetConnectedPixels, LCSD_WIDTH and LCSD_HEIGHT
                                            added dpls0.h and removed some prototypes
00.01.01    2003-09-04  M.Korkmaz           Bugfix Paint problems of clam shell display 
                                            Function OnLButtonDown for setfocus implemented
00.02.00    2004-01-13  C.Rffer (MCH)      added DispClearDispBufferBusy
------------------------------------------------------------------------------*/

#include "smsafxh.h"
#include "simuapph.h"
#include "mmicsdisph.h"
#include "type.h" //for Visual Studio C++ 6.0
#include "display.h"
#include "mainfrmh.h"

#include "dpl_def.h"
#include "dpls0.h"          // L1 Simulation


 
extern "C" HWND CSDispGetWinHandle(void)
{
    return GET_APP()->GetClampShellDispWindow()->m_hWnd;
}


////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////  CClampShellDispWindow ///////////////////////////////////////////////////////////


BEGIN_MESSAGE_MAP(CClampShellDispWindow, CDispWnd)
    //{{AFX_MSG_MAP(CClampShellDispWindow)
    ON_WM_PAINT()
    ON_WM_SIZE()
    ON_WM_LBUTTONDOWN()
    ON_COMMAND(ID_MAGNIFY_CS_1, OnMagnify100)
    ON_COMMAND(ID_MAGNIFY_CS_2, OnMagnify200)
    ON_COMMAND(ID_MAGNIFY_CS_3, OnMagnify300)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


// Do not create unless previously registered.
CClampShellDispWindow::CClampShellDispWindow( void )
{
   m_UIMagnification = 1;
   m_UINormalWidth    = DispGetWidth (E_DISP_CLAMPSHELL);
   m_UINormalHeight   = DispGetHeight(E_DISP_CLAMPSHELL);
}

CClampShellDispWindow::~CClampShellDispWindow( void )
{
  
}
void CClampShellDispWindow::OnPaint()
{
    Paint();
    // Do not call CDispWnd::OnPaint() for painting messages
}

/**
* 
*/
void CClampShellDispWindow::Paint( void )
{
    
    CPaintDC         dc(this); // device context for painting
    PAINTSTRUCT      ps = dc.m_ps;
    COLORREF         act_color, *pPixels, *pix;
    HBITMAP          tmpBitmap, hBitmap;
    HDC              hdcComp;
    BITMAPINFO       *pBmi;         
    BITMAPINFOHEADER *pBmiHeader;

    int width           = DispGetWidth  (E_DISP_CLAMPSHELL);
    int height          = DispGetHeight (E_DISP_CLAMPSHELL);
    UINT displayWidth   = width  * m_UIMagnification;
    UINT displayHeight  = height * m_UIMagnification;
  
    //////////////////////////////////
    // draw display of mobile:
    //////////////////////////////////
    
    pBmi= (BITMAPINFO *)new char[sizeof(BITMAPINFO)];   
    pBmiHeader= &pBmi->bmiHeader;
    pBmiHeader->biSize          = sizeof(BITMAPINFOHEADER);
    pBmiHeader->biWidth         = DispGetWidth  (E_DISP_CLAMPSHELL);
    pBmiHeader->biHeight        = -DispGetHeight(E_DISP_CLAMPSHELL);             // 0,0 in the top/right corner
    pBmiHeader->biPlanes        = 1;
    pBmiHeader->biBitCount      = 32;
    pBmiHeader->biCompression   = BI_RGB;

    pBmiHeader->biSizeImage     = 0;
    pBmiHeader->biXPelsPerMeter = 0;
    pBmiHeader->biYPelsPerMeter = 0;
    pBmiHeader->biClrUsed       = 0;
    pBmiHeader->biClrImportant  = 0;

    // Create the bitmap in memory..
    pPixels = NULL;
    hBitmap = CreateDIBSection( ps.hdc, pBmi, DIB_RGB_COLORS, (void **)&pPixels, NULL, 0 );
    pix     = pPixels;

    for (int y = 0; y < height; y++)
    {
        for (int x = 0; x < width; x++)
        {
            DispGetPixel(E_DISP_CLAMPSHELL, x, y, &act_color);
            // set "BGR" from given "RGB" value:
            *pix = (act_color & 0x00ff00) | (act_color >> 16) | ((act_color & 0xff) << 16);
            pix++;
        }
    }

    // feedback for L1 Display Driver Simulation
    DispClearDispBufferBusy(E_DISP_CLAMPSHELL);

    hdcComp   = CreateCompatibleDC(ps.hdc);
    tmpBitmap = (HBITMAP) SelectObject(hdcComp, hBitmap);

    if (DispGetPixelWidthZoom(E_DISP_CLAMPSHELL) == 1 && DispGetPixelHeightZoom(E_DISP_CLAMPSHELL) == 1)
    {
        BitBlt(ps.hdc,
               0,
               0,
               width, 
               height,
               hdcComp,
               0,0,
               SRCCOPY);
    }
    else
    {
        StretchBlt(ps.hdc,
                   0,
                   0,
                   width * DispGetPixelWidthZoom (E_DISP_CLAMPSHELL),
                   height * DispGetPixelHeightZoom(E_DISP_CLAMPSHELL),
                   hdcComp,
                   0,0,
                   width, 
                   height,
                   SRCCOPY);
    }

    SelectObject(hdcComp, tmpBitmap);
    DeleteObject(hBitmap);          // Delete the memory image.
    DeleteDC    (hdcComp);
    DeleteObject(tmpBitmap);
    delete [] pBmi;
}

/**
 *  Zoom 100% of clamp shell screen
 */
void CClampShellDispWindow::OnMagnify100()
{  
    SetMagnify(1);
}

/**
 *  Zoom 200% of clamp shell screen
 */
void CClampShellDispWindow::OnMagnify200()
{
    SetMagnify(2);
}

/**
 *  Zoom 300% of clamp shell screen
 */
void CClampShellDispWindow::OnMagnify300()
{
    SetMagnify(3);
}

/**
 *  Helper function to set the zoom state, if the requested zoom state /n
 *  is the same as current state, then do nothing.CS
 *
 *  @param   uiMagnify: zoom state
 */
void CClampShellDispWindow::SetMagnify(UINT uiMagnify)
{
    // We don't need to resize if we have the same mg_Magnification value
    if (m_UIMagnification != uiMagnify)
    {
        m_UIMagnification = uiMagnify;
    }
    ReSizeDockingWnd();
}

/**
 *    Helper function to resize clamp shell window. The function will be called
 *    after zoom or change skin function was called.
 */
void CClampShellDispWindow::ReSizeDockingWnd()
{
    CClampShellScreenWnd* pcCSMobile  = (CClampShellScreenWnd*)GetOwner();

    if(pcCSMobile != NULL)
    {
        pcCSMobile->ReSizeWnd(DispGetWidth(E_DISP_CLAMPSHELL)*m_UIMagnification, (DispGetHeight(E_DISP_CLAMPSHELL)*m_UIMagnification)+20);
    }
    SetActiveWindow();
    SetFocus();
}

void CClampShellDispWindow::OnSize(UINT nType, int cx, int cy)
{
    CDispWnd::OnSize(nType, cx, cy);
    RECT clientrect;
    RECT winrect;

    if (nType == SIZE_MAXIMIZED || nType == SIZE_RESTORED )
    {
        GetClientRect(&clientrect);
        GetWindowRect(&winrect);

        // set magnification due to window size:
        if (DispGetDirection() == disp_dir_horizontal)
        {
            m_UIMagnification= (int) (1.0 * (cx +9) / m_UINormalWidth);
        }
        else
        {
           m_UIMagnification= (int) (1.0 *  (cx +9) / m_UINormalHeight);
        }
      
        if (m_UIMagnification < 1) 
            m_UIMagnification = 1;

        //WriteVariablePermanentToRegistry( m_UIMagnification);
        DispSetPixelWidthZoom (E_DISP_CLAMPSHELL, m_UIMagnification);
        DispSetPixelHeightZoom(E_DISP_CLAMPSHELL, m_UIMagnification);
    }
}
void CClampShellDispWindow::OnLButtonDown(UINT nFlags, CPoint point)
{
    SetActiveWindow();
    SetFocus();
    CDispWnd::OnLButtonDown(nFlags, point);
}


