/*! \file 

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR Murat Korkmaz Bardenheuer Software GmbH

.FILENAME mainfrm.cpp


.CSVERSION 1.1


.VERSION 02.15.00

.DATE 2004-05-13

.SHORT_DESCR:   MainFrame of the aplication

.SW_COMPONENT:  MMI PC-SIMULATION

.SW_TYPE 

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change

01.00.00 2003-01-07 Murat Korkmaz (Bardenheuer Software)
                    Initial Version New UserInterface of PC-MMI-Test Environment
02.00.00 2003-07-18 Yingfan Lei, Murat Korkmaz
                    Created new docking window as clamp shell and modified correspondingly view menu 
02.01.00 2003-08-08 Murat Korkmaz
                    Disable corosponding clam shell menus 
02.02.00 2003-08-11 Murat Korkmaz
		    Bugfix setfocus problems
02.03.00 2003-08-20 Yingfan Lei
                    adjusted OnActivateApp for VC++ 6.0
                    Juergen Reichmann
                    added Timer for SetFocus
02.04.00 2003-09-03 Murat Korkmaz
                    Bugfix setfocus problems on function OnActivateApp
                    EnableCSDisplay function changed
02.05.00 2003-09-11 Murat Korkmaz
                    New Output Window added
02.06.00 2003-09-17 Y.Lei
                    added ActivateTracePopupMenu for on/off trace menu
02.07.00 2003-09-30 A. Nagy
                    added NULLP check to OnTimer()
02.08.00 2003-11-17 Zhang qi fan(PEK)
                    added localization support for SMTK
02.08.00 2003-01-08 C. Hierl
                    CreateGapiDlgConnect added
02.08.01 2004-01-19 N. Barisits, W. Stroell (VIE)
                    CMainFrame::OnTimer - close application instead of simulation of keypress A
					CMainFrame::OnClose - SIM simulation release and keypress W simulation removed
02.09.00 2004-01-20 Murat Korkmaz
                    Plug-in feature for PC-SIMU added (m_pcPlugInManager).
02.10.00 2004-01-22 Murat Korkmaz
                    Function DockControlBarLeftOf added.Notification user messages
                    from mainfrm.cpp to mainfrm.h removed.
02.11.00 2004-02-09 Murat Korkmaz
                    Preprocessor JAVA_SDK for Plug-in feature of PC-SIMU added.
02.12.00 2004-02-13 Murat Korkmaz (MCH)    Adaptions for QWERTY keypad
02.12.01 2004-03-17 Murat Korkmaz (MCH)    BugFix: Saving of docking wnds in to Registry
02.13.00 2004-03-18 Zhang Jing (PEK)  Shaped ui for JAVA_SDK
02.13.01 2004-03-31 Zhang qi fan(PEK)
		    reset SMTK registry according product name
02.14.00 2004-04-05 Murat Korkmaz (MCH)
                    New toolbar for Flexshell state added
02.14.01 2004-05-06 Murat Korkmaz (MCH)
                    Outputwindow will be hide if the user
                    sets the appropriate toolbar. 
02.15.00 2004-05-13 Leena Khera(SISL,India)
                    Windows Position are not restored, Count of Plugin are taken.
                    VerifyBarState() function excluded the plugin Window to verify
02.16.00 2004-05-21 Sun Min(PEK)
                    Keep window position when switch between MDV <-> Shaped UI and size of MDV should be kept for SMTK
                    Function HideControlBar() is modified.
02.16.01 2004-05-21 Sun Min(PEK)
                    For SMTK, when define JAVA_SDK, Disable the Loadbars() in OnCreate().		                                    
02.16.02 2004-05-28 Du Chun (PEK)
                    Seperate SHAPED UI feature from JAVA_SDK. 
02.16.03 2004-05-31 Sun Min(PEK)
                    Adaption cmd msg functions for Flexshell from class CMainFrame to class CMMIDispWindow.
02.16.04 2004-06-10 Sun Min(PEK)
                    Adaption cmd msg function OnShowOptionsDlg from class CMainFrame to class CMMIDispWindow.
02.17.00 2004-06-11 Du Chun (PEK)          
                    Add Flexshell open and close function to Neo2. 
02.17.02 2004-06-17 Fang Yunchao  (PEK)  
                    Add UNICODE support. 
02.18.00 2004-06-17 Sun Min(PEK)
                    Add SMTK Tool window to Shaped UI
02.19.00 2004-06-16 Murat Korkmaz (MCH)
                    Removing of unused source, some cleaning algorithm added. 
02.20.00 2004-06-17 Sun Min(PEK)
                    Add SMTK Tool window to Shaped UI
02.21.00 2004-06-17 Fang Yunchao  (PEK)  
                    Add UNICODE support. 
02.21.01 2004-06-21 Sun Min(PEK)
                    Remove unused code	
02.21.02 2004-06-24 Fang Yunchao  (PEK)  
                    Modification for SMTK Localization support. 	    
02.22.00 2004-07-08 Murat Korkmaz
                    Function IsPaintAllowed modified.
02.23.00 2004-08-18 Sun Min(PEK)
                    Function OnJavaOutput(),Java_DebugOutput_Print() modified.
02.23.01 2004-10-25 Sun Min(PEK)
                    Fix bug DT100106555
                    Modify function SetStatusbarInfo() for fix bug in main menu's progress bar;
                    Modify function OnJavaOutput() for fix bug in output text in SMTK
02.23.02 2004-11-18 Sun Min(PEK)
                    Modify "USE_SHAPED_UI" TO "JAVA_SDK" to enable smtk tool utilities in emulator.
02.24.00 2004-12-15 Murat Korkmaz
                    Function OnEraseBkgnd added
02.25.00 2005-01-27 Li Yang (PEK)
                    Add function ExitMPMConnectionProcess() in OnClose() function.      
02.25.01 2005-03-08 Guan Tian yi (PEK)
                    Add Popup window and PrintTrace     

**************************************Jerry*********************************
03.00.00  2006-03-17  Gurpreet Sabharwal(SISL ,India)
                      Removed Java Support And Functionality
03.00.01  2006-03-27  Parul Singhal(SISL,India) 
                      Support for blinking effect 

                
*/



#include "mainfrmh.h"
#include "simuapph.h"
#include "pluginmanager.h"
#include "display.h"

#include <afxmt.h>
#ifdef JAVA_SDK
#include "info_main.h"
#endif
#include <afxmt.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern "C"
{
#include <global.h>
#include "kbddrv.h"
#include "keypad.h"
extern int  emulatorWidth;  ///< Width of the emulator.
extern int  emulatorHeight; ///< Height of the emulator.

extern int  OS_ShutdownPending;
extern void gapi_CreateDialogConnect(void * pGAPI_MessageParam);
}

//#include "machineh.h"
#include "simsimh.h"
#include "sim_regh.h"
#include "mainfrmh.h"

#define ONCLOSE_TIMER   0x0010
#define SETFOCUS_TIMER  0x0011

//for jerry
#define BLINK_TIMER  0X0012

#ifdef LOCALIZATION_SUPPORT
#include "localizationapi.h"  //added by kevin
#endif

#ifdef JAVA_SDK    //flag for auto popup tool output window
extern int mg_autoPopupOutputWnd;
//extern int mg_smtkToolDlgOpened;
#endif

/// the MainFrame postion point shaped ui
int GlobalFrameTop = SHAPED_UI_FRAME_TOP;
int GlobalFrameLeft = SHAPED_UI_FRAME_LEFT;
int GlobalCmdWndTop = 0;
int GlobalCmdWndLeft = 0;
int GlobalPhoneWidth = 0;
BOOL mg_StartBlinking   = FALSE;//for jerry

//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI

int GlobalUiSkin = SHAPED_UI_HAVE_SKIN;
int GlobalUiStyle = SHAPED_UI;
#else
int GlobalUiStyle = PC_SIMU_USE_NEW_UI;
#endif

extern char  SkinDataFile[], SkinBitmapFile[];
extern int   mg_Magnification;
extern int   mg_FlexShellType;
extern bool  g_bIsSpapedUIVibrating;

extern int MPMConnectState ;
extern "C" void	ExitMPMConnectionProcess();


/**                                                                       
 *Extern function to set Statusbar info "MMI Heap" and "widget 
 *command".  
 *    
 *  @param   nPanel: if 0 than  ID_INDICATOR_MEM
 *                   if 1 than  ID_INDICATOR_WIDGET
 *  @param   *szTitle: char buffer to set in specific statusbar pane.  
 *  
 */                                                                        
extern "C" void SetStatusbarInfo(int nPanel,  const char *szTitle )
{
	// To be thread secure
	CMutex mutex;
	if (GlobalUiStyle == PC_SIMU_USE_NEW_UI)
	{
	    
		if (nPanel == 0)
		{
			mutex.Lock();
			((CMainFrame*) GET_APP()->m_pMainWnd)->m_cStrStatusbarTextMEM = szTitle;
			mutex.Unlock();
			((CMainFrame*) GET_APP()->m_pMainWnd)->PostMessage(WM_STATUSBARTEXT_CHANGED, STATUSBARTEXT_CHANGED_MEM);
		}
		else
		if (nPanel == 1)
		{
			mutex.Lock();
			((CMainFrame*) GET_APP()->m_pMainWnd)->m_cStrStatusbarTextWIDGET = szTitle;
			mutex.Unlock();
			((CMainFrame*) GET_APP()->m_pMainWnd)->PostMessage(WM_STATUSBARTEXT_CHANGED, STATUSBARTEXT_CHANGED_WIDGET);
		}

	}
//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
	else // set the java heap progress bar
	if (GlobalUiStyle == SHAPED_UI)
	{
                
		
		CMainFrame *p_Frame = (CMainFrame *) GET_APP()->m_pMainWnd;
		mutex.Lock();
		// for heap progress bar
		if (p_Frame->m_MainMenuDlg.m_hWnd)
		{
			p_Frame->m_MainMenuDlg.ProgressBarPos();
		}
		mutex.Unlock();

	/*
		// for runtime heap information
		mutex.Lock();
		if (p_Frame->m_JavaHeapDlg.m_hWnd)
		{
			//p_Frame->m_JavaHeapDlg.m_HeapView.RunTimeHeapPos();
		}
		mutex.Unlock();
                */
        
        
		
		if(nPanel==0)
		{
		    mutex.Lock();
		    CMMIDispWindow* tempWindow=NULL;
		    if(tempWindow=GET_APP()->GetMMIDispWindow())					
			tempWindow->SetSmtkToolValue(szTitle);				
		    mutex.Unlock();
		}
	}
#endif
}

/**                                                                       
 *  Extern function to show or hide the clam shell display
 *    
 *  @param   bEnableDisable: if true than show clam shell display
 *  
 */     
extern "C" void EnableCSDisplay(bool bEnableDisable)
{
    if (bEnableDisable)
    {  
        ((CMainFrame*) GET_APP()->m_pMainWnd)->PostMessage(WM_CLAMSHELL, CLAMSHELL_SHOW);
    }
    else
    {
        ((CMainFrame*) GET_APP()->m_pMainWnd)->PostMessage(WM_CLAMSHELL, CLAMSHELL_HIDE);
    }
    //pFrame->HelperOnViewClampShell(bEnableDisable);
    //pFrame->m_bShowClampShell = bEnableDisable;
}

extern "C" void Java_DebugOutput_clear(void)
{
    ((CMainFrame*) GET_APP()->m_pMainWnd)->PostMessage(WM_JAVA_OUTPUT, OUTPUT_CLEAR);
}

extern "C" void Java_DebugOutput_Print(char *str)
{
   // To be thread secure
    CEvent cEventObj;
    CMutex mutex;

	CString strTemp = "";
	char chTemp=' ';
	if(str)
	{
		strTemp = str;
	}
	int iLen = strTemp.GetLength();
	if(iLen>0)
	{
		chTemp = strTemp.GetAt(iLen-1);
		if(chTemp == '\r'|| chTemp == '\n')
		{
//modify by sunmin for improve debug text output, 2004-08-03
            ((CMainFrame*) GET_APP()->m_pMainWnd)->m_cStrJavaOutput += strTemp ;
        ((CMainFrame*) GET_APP()->m_pMainWnd)->PostMessage(WM_JAVA_OUTPUT, OUTPUT_PRINT, (LPARAM) &cEventObj);
        cEventObj.Lock();
		}
		else
		{
			((CMainFrame*) GET_APP()->m_pMainWnd)->m_cStrJavaOutput += strTemp ;
		}
              }   
	}

extern "C" bool IsPaintAllowed(int iDispType)
{
    bool bReturn = ((CMainFrame*) GET_APP()->m_pMainWnd)->IsPaintAllowed(iDispType)?true:false;
    return bReturn;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
    //{{AFX_MSG_MAP(CMainFrame)
    ON_WM_CREATE()
    ON_WM_CLOSE()
    ON_COMMAND(ID_VIEW_MMICOMMANDS,           OnViewMmicommands)
    ON_COMMAND(ID_VIEW_PHONESCREEN,           OnViewPhonescreen)
    ON_COMMAND(ID_VIEW_CLAMPSHELL,            OnViewClampShell)
    ON_COMMAND(ID_VIEW_OUTPUTWND,             OnViewOutPutWindow)
    ON_COMMAND(IDR_MAINFRAME,                 OnViewToolbarSoftKeys)
    ON_COMMAND(IDR_DOCKING_WINDOWS,           OnViewToolbarWindows)
    ON_COMMAND(IDR_FLEXSHELL,                 OnViewFlexshell)

    ON_COMMAND(ID_INDICATOR_MEM,              OnViewStatusbar)   
    ON_UPDATE_COMMAND_UI(ID_VIEW_PHONESCREEN, OnUpdateViewPhonescreen)
    ON_UPDATE_COMMAND_UI(ID_VIEW_MMICOMMANDS, OnUpdateViewMmicommands)
    ON_UPDATE_COMMAND_UI(ID_VIEW_CLAMPSHELL,  OnUpdateViewClampShell)
    ON_UPDATE_COMMAND_UI(ID_VIEW_OUTPUTWND ,  OnUpdateViewOutPutWindow)
    ON_UPDATE_COMMAND_UI(IDR_MAINFRAME,       OnUpdateViewToolbarSoftKeys)
    ON_UPDATE_COMMAND_UI(IDR_DOCKING_WINDOWS, OnUpdateViewToolbarWindows)
    ON_UPDATE_COMMAND_UI(ID_INDICATOR_MEM,    OnUpdateViewStatusbar)
    ON_UPDATE_COMMAND_UI(IDR_FLEXSHELL,          OnUpdateViewFlexshell)

    ON_MESSAGE(WM_STATUSBARTEXT_CHANGED,      OnSetStatusbarText)
    ON_MESSAGE(WM_CLAMSHELL,                  EnableCSDisplay)
    ON_MESSAGE(WM_JAVA_OUTPUT,                OnJavaOutput)
#ifdef LOCALIZATION_SUPPORT
	ON_MESSAGE(WM_UPDATE_WINDOWS_UI,          OnUpdateWindowsUI)  //added by kevin
#endif
    ON_MESSAGE(WM_CREATE_GAPI_DLG,            OnCreateGapiDlgConnect)
    ON_WM_SETFOCUS()
    ON_WM_INITMENU()
    ON_WM_INITMENUPOPUP()
	ON_WM_TIMER()
    ON_WM_ACTIVATEAPP()
    ON_WM_KEYDOWN()
    ON_WM_KEYUP()
    ON_WM_MOVE()
    ON_WM_ERASEBKGND()
	ON_COMMAND(ID_CLOSE_ENTIR_PROGRAM,        OnClose)
    //}}AFX_MSG_MAP
#ifndef JAVA_SDK
    ON_COMMAND_RANGE(PLUGIN_COMMAND_START_ID, PLUGIN_COMMAND_END_ID, OnPlugInCommands)
#endif //JAVA_SDK

END_MESSAGE_MAP()

static UINT indicators[] =
{
    ID_INDICATOR_MEM,
    ID_INDICATOR_WIDGET,
};


/**                                                                       
 *  Constructor of CMainFrame. It sets the profile string for registry key.       
 */                                                                        
CMainFrame::CMainFrame()
{
#ifndef JAVA_SDK
    m_cStrProfile     = _T("WindowPositions\\Wnd");
#else
  #ifndef _UNICODE 
	m_cStrProfile.Format(_T("%s\\WindowPositions\\Wnd"),Info_GetProductName());
#else
	USES_CONVERSION;
	m_cStrProfile.Format(_T("%s\\WindowPositions\\Wnd"),A2W((LPCSTR)Info_GetProductName()));
#endif
#endif
    m_bShowClampShell = FALSE;

//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
	GlobalUiSkin = SHAPED_UI_HAVE_SKIN;
#endif
	m_cStrJavaOutput = "";
}

/**                                                                       
 *  Destructor of CMainFrame.  
 */                                                                        
CMainFrame::~CMainFrame()
{
    destruct_simsim ();

#if !defined (JAVA_SDK) && !defined (USE_SHAPED_UI)
    if (m_pcPlugInManager)
    {
        m_pcPlugInManager->FreePlugIns();
        delete m_pcPlugInManager;
    }
#endif //JAVA_SDK    

    CWinApp* pApp = AfxGetApp();
    TCHAR szSection[256];
    wsprintf(szSection, _T("%s-Main"), m_cStrProfile);
    CRect rc;
    GetWindowRect(rc);

    pApp->WriteProfileString(szSection, NULL, NULL);
    pApp->WriteProfileInt(szSection,_T( "left"),   rc.left);
    pApp->WriteProfileInt(szSection,_T( "right"),  rc.right);
    pApp->WriteProfileInt(szSection, _T("bottom"), rc.bottom);
    pApp->WriteProfileInt(szSection,_T( "top"),    rc.top);

    SaveBarState(m_cStrProfile);
    SavePosBar(m_cStrProfile);
    
    if( MPMConnectState == 1 ){
       ExitMPMConnectionProcess();  //if MPM connection keep alive when emulator exiting, close it first.
    }
}

/**                                                                       
 *  The framework calls this member function when an application 
 *  requests that the Windows window be created. Use to create docking windows.  
 *    
 *  @param   lpCreateStruct: The CREATESTRUCT structure defines the initialization parameters 
 *                           passed to the window procedure of an application.   
 *  
 *  @return  int: OnCreate must return 0 to continue the creation of the CWnd object. If the application 
 *                          returns -1, the window will be destroyed.
 */                                                                        
int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
        return -1;
    DWORD dwToolbar = WS_CHILD|WS_VISIBLE|CBRS_TOP|CBRS_GRIPPER|CBRS_TOOLTIPS|CBRS_FLYBY|CBRS_SIZE_DYNAMIC;
    // Create toolbar for functions key (F1-F12)
    if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, dwToolbar, CRect(0, 0, 0, 0),IDR_MAINFRAME) || 
        !m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
    {
        TRACE0("Failed to create toolbar\n");
        return -1;      // fail to create
    }

    // Create toolbar to show or hide the docking windows
    if (!m_wndToolBarView.CreateEx(this, TBSTYLE_FLAT, dwToolbar, CRect(0, 0, 0, 0),IDR_DOCKING_WINDOWS) || 
        !m_wndToolBarView.LoadToolBar(IDR_DOCKING_WINDOWS))
    {
        TRACE0("Failed to create toolbar\n");
        return -1;      // fail to create

    }
    if (!m_wndToolBarFlexshell.CreateEx(this, TBSTYLE_FLAT, dwToolbar, CRect(0, 0, 0, 0),IDR_DOCKING_WINDOWS) || 
        !m_wndToolBarFlexshell.LoadToolBar(IDR_FLEXSHELL))
    {
        TRACE0("Failed to create toolbar\n");
        return -1;      // fail to create

    }

	// Create statusbar and set specific style
	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}
	m_wndStatusBar.SetPaneStyle(m_wndStatusBar.CommandToIndex(ID_INDICATOR_MEM), SBPS_NOBORDERS);
	m_wndStatusBar.SetPaneStyle(m_wndStatusBar.CommandToIndex(ID_INDICATOR_COMMAND), SBPS_NOBORDERS);

	// create a view to occupy the client area of the frame
    if (!m_wndView.Create(NULL, NULL, AFX_WS_DEFAULT_VIEW,
        CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL))
    {
        TRACE0("Failed to create view window\n");
        return -1;
    }
    
 
    // Create Clamp Shell Screen, set style
#ifndef LOCALIZATION_SUPPORT
    if (!m_wndClampShellScreen.Create (_T("ClampShell"), this, 501))
#else
	if (!m_wndClampShellScreen.Create (CLocalizationString(IDS_WND_CLAMPSHELL), this, 501))
#endif
    {
        TRACE0("Failed to create Clamp Shell Screen window\n");
        return -1;      // fail to create
    }
    m_wndClampShellScreen.SetBarStyle(m_wndClampShellScreen.GetBarStyle() |CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
  
  
    // Create MMI command window and set style
#ifndef LOCALIZATION_SUPPORT
    if (!m_wndMMICommand.Create (_T("MMI Commands"), this, 502))
#else
	if (!m_wndMMICommand.Create (CLocalizationString(IDS_WND_MMI_COMMAND), this, 502))
#endif
    {
        TRACE0("Failed to create MMI Commands window\n");
        return -1;      // fail to create
    }
    m_wndMMICommand.SetBarStyle(m_wndMMICommand.GetBarStyle() |CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
#ifndef LOCALIZATION_SUPPORT
    if (!m_wndOutput.Create (_T("Output"), this, 503))
#else
	if (!m_wndOutput.Create (CLocalizationString(IDS_WND_OUTPUT), this, 503))
#endif
    {
        TRACE0("Failed to create MMI Commands window\n");
        return -1;      // fail to create
    }
    m_wndOutput.SetBarStyle(m_wndOutput.GetBarStyle() |CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);


    // be dockable
    EnableDocking(CBRS_ALIGN_ANY);

#ifdef _SCB_REPLACE_MINIFRAME
    m_pFloatingFrameClass = RUNTIME_CLASS(CSCBMiniDockFrameWnd);
#endif //_SCB_REPLACE_MINIFRAME

	// dock the toolbar
    m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
    m_wndToolBarView.EnableDocking(CBRS_ALIGN_ANY);
    m_wndToolBarFlexshell.EnableDocking(CBRS_ALIGN_ANY);
 
	// Create Mobile phone screen, set style
#ifndef LOCALIZATION_SUPPORT
    if (!m_wndMobilePhoneScreen.Create (_T("MobilePhone"), this, AFX_IDW_CONTROLBAR_FIRST+8))
#else
	if (!m_wndMobilePhoneScreen.Create (CLocalizationString(IDS_WND_MOBILEPHONE), this, AFX_IDW_CONTROLBAR_FIRST+8))
#endif
    {
        TRACE0("Failed to create Mobile Phone Screen window\n");
        return -1;      // fail to create
    }
    m_wndMobilePhoneScreen.SetBarStyle(m_wndMobilePhoneScreen.GetBarStyle() |CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
  
    // Dock only on right hand side or left hand side. 
	m_wndMobilePhoneScreen.EnableDocking(CBRS_ALIGN_LEFT|CBRS_ALIGN_RIGHT);
    m_wndClampShellScreen.EnableDocking(CBRS_ALIGN_LEFT|CBRS_ALIGN_RIGHT);
    m_wndMMICommand.EnableDocking(CBRS_ALIGN_LEFT|CBRS_ALIGN_RIGHT);

//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
	if (GlobalUiStyle == PC_SIMU_USE_NEW_UI)
	{
#endif 
		m_wndOutput.EnableDocking(CBRS_ALIGN_BOTTOM|CBRS_ALIGN_TOP);
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
	}
	else
	{
		m_wndOutput.EnableDocking(0);

	}
#endif
//modified by duchun for SHAPED_UI
//#ifndef JAVA_SDK
#ifndef USE_SHAPED_UI
    DockControlBar(&m_wndToolBar,AFX_IDW_DOCKBAR_TOP);
    DockControlBar(&m_wndToolBarView,AFX_IDW_DOCKBAR_TOP);
    DockControlBar(&m_wndToolBarFlexshell,AFX_IDW_DOCKBAR_TOP);
    DockControlBarLeftOf(&m_wndToolBarView,&m_wndToolBar);
    DockControlBarLeftOf(&m_wndToolBarFlexshell,&m_wndToolBarView);
#endif
    // Dock at first left
    DockControlBar(&m_wndMobilePhoneScreen,AFX_IDW_DOCKBAR_LEFT);
    // Dock at first left
    DockControlBar(&m_wndClampShellScreen, AFX_IDW_DOCKBAR_LEFT);
    // Dock at first right
    DockControlBar(&m_wndMMICommand,AFX_IDW_DOCKBAR_RIGHT );
    // Dock at first bottom
    DockControlBar(&m_wndOutput,AFX_IDW_DOCKBAR_BOTTOM);

//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
	if (GlobalUiStyle != PC_SIMU_USE_NEW_UI)
	{
        HideControlBar();
	}
	else
	{
		DisplayControlBar();
	}
#endif
    //hide clamp shell screen at first and disable the corosponding menus
    ShowControlBar(&m_wndClampShellScreen,FALSE, FALSE);
    ShowControlBar(&m_wndOutput,FALSE, FALSE);

    if(mg_FlexShellType == 0) //added by duchun, when flexshell type is 0,disable flexshell toolbar
    {
        ShowControlBar(&m_wndToolBarFlexshell,FALSE, FALSE);
    }

//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
	if (GlobalUiStyle == SHAPED_UI)
	{
		CMMIDispWindow * p_Disp = GET_APP()->GetMMIDispWindow();
		p_Disp->LoadPhoneSkin(mg_Magnification, GlobalUiSkin);
	}
#endif

#if !defined (JAVA_SDK) && !defined (USE_SHAPED_UI)
    // Plug-in feature
    m_pcPlugInManager = new CPlugInManager(this);
    if (m_pcPlugInManager)
        m_pcPlugInManager->LoadPlugIns();

//LEENA
    // Load positions, state from registry
    LoadBars();//(Called later than LoadPlugIns() as then we can know the number of PlugIns
    m_pcPlugInManager->DockPlugInsToolBars();
#else
    //LoadBars();
//LEENA
#endif //JAVA_SDK

#if _MSC_VER > 1200
	if (GlobalUiStyle == PC_SIMU_USE_NEW_UI)
	{
		ActivateTracePopupMenu(false);
	}
#endif

#if !defined (JAVA_SDK) && !defined (USE_SHAPED_UI)
	EnableCSDisplay(CLAMSHELL_HIDE, 0);
#endif
	// refresh window
	CRect rc;
	GetWindowRect(&rc);
	InvalidateRect(rc, TRUE);

	//jerry_starts BLINKING EFFECT
	SetTimer(BLINK_TIMER, 500, 0);
	m_bBlink = 0;//jerry_ends

    return 0;
}

/**                                                                       
 * Call this function before swith the MDV to shaped ui
 *
 */                                                                        
void CMainFrame::HideControlBar()
{
	ShowControlBar(&m_wndOutput,FALSE, FALSE);
	ShowControlBar(&m_wndMMICommand,FALSE, FALSE);

	ShowControlBar(&m_wndToolBar,FALSE, FALSE);
	ShowControlBar(&m_wndToolBarView,FALSE, FALSE);

    if(mg_FlexShellType != 0) //if type is 0, already disabled.
    {
    ShowControlBar(&m_wndToolBarFlexshell,FALSE, FALSE);
    }

    ShowControlBar(&m_wndStatusBar,FALSE, FALSE);

	// set the output window always floating
    m_wndOutput.EnableDocking(0);

	// remove title bar 
    ModifyStyle(WS_CAPTION, 0);
    m_wndMobilePhoneScreen.ModifyStyle(WS_CAPTION, 0);

    CMMIDispWindow * p_Disp = GET_APP()->GetMMIDispWindow();
    p_Disp->ModifyStyle(WS_CAPTION,0);


	//ModifyStyle(WS_BORDER, FALSE);

	// set control bar position
    // Dock at first left
	 if (m_wndMobilePhoneScreen.IsFloating())
	 {
		 mg_Magnification = 1;

		 m_wndMobilePhoneScreen.EnableDocking(CBRS_ALIGN_LEFT|CBRS_ALIGN_RIGHT);

	    DockControlBar(&m_wndMobilePhoneScreen,AFX_IDW_DOCKBAR_LEFT);
	 }
    DockControlBar(&m_wndMobilePhoneScreen,AFX_IDW_DOCKBAR_LEFT);

	// refresh window
	CRect rc;
	GetWindowRect(&rc);
	InvalidateRect(rc, TRUE);


}

/**                                                                       
 * Call this function before swith the shaped ui to MDV
 *
 */                                                                        
BOOL CMainFrame::DisplayControlBar()
{
	
	// tool bar
	ShowControlBar(&m_wndToolBar,TRUE, FALSE);
	ShowControlBar(&m_wndToolBarView,TRUE, FALSE);
	// command window
	ShowControlBar(&m_wndMMICommand,TRUE, FALSE);

    if(mg_FlexShellType != 0) //if type is 0, shoulb be disabled.
    {
    ShowControlBar(&m_wndToolBarFlexshell,TRUE,FALSE);
    }
        
    ShowControlBar(&m_wndStatusBar,TRUE,FALSE);

	// toolbar docking
	DockControlBar(&m_wndToolBar,AFX_IDW_DOCKBAR_TOP);
	DockControlBarLeftOf(&m_wndToolBarView,&m_wndToolBar);
	// output window
    m_wndOutput.EnableDocking(CBRS_ALIGN_BOTTOM|CBRS_ALIGN_TOP);
	// added title bar 
	ModifyStyle(0, WS_CAPTION);
    
//    m_wndMobilePhoneScreen.ModifyStyle(0, WS_CAPTION);

    CMMIDispWindow * p_Disp = GET_APP()->GetMMIDispWindow();
    p_Disp->ModifyStyle(0, WS_CAPTION);

	// border
	ModifyStyle(0, WS_BORDER);

	// refresh window
	CRect rc;
	GetWindowRect(&rc);
	InvalidateRect(rc, TRUE);

	return TRUE;
	

}

/**                                                                       
 *  Use this function  to change the style.      
 */                                                                        
BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
    if( !CFrameWnd::PreCreateWindow(cs) )
        return FALSE;

    cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
    return TRUE;
}


#ifdef _DEBUG  
/**                                                                       
 *Funtions for debugging. 
 */                                                                        
void CMainFrame::AssertValid() const
{
    CFrameWnd::AssertValid();
}
/**                                                                       
 *Funtions for debugging. 
 */ 
void CMainFrame::Dump(CDumpContext& dc) const
{
    CFrameWnd::Dump(dc);
}

#endif //_DEBUG
//jerry_starts for blinking funtionality
extern "C" void SetBlinkTimer()
{
    mg_StartBlinking = TRUE;
}
extern "C" void ResetBlinkTimer()
{
    mg_StartBlinking = FALSE;
}//jerry_ends


void CMainFrame::DockControlBarLeftOf(CToolBar* Bar, CToolBar* LeftOf)
{
    CRect rect;
    DWORD dw;
    UINT n;

    // get MFC to adjust the dimensions of all docked ToolBars
    // so that GetWindowRect will be accurate
    RecalcLayout(TRUE);

    LeftOf->GetWindowRect(&rect);
    rect.OffsetRect(1,0);
    dw=LeftOf->GetBarStyle();
    n = 0;
    n = (dw&CBRS_ALIGN_TOP) ? AFX_IDW_DOCKBAR_TOP : n;
    n = (dw&CBRS_ALIGN_BOTTOM && n==0) ? AFX_IDW_DOCKBAR_BOTTOM : n;
    n = (dw&CBRS_ALIGN_LEFT && n==0) ? AFX_IDW_DOCKBAR_LEFT : n;
    n = (dw&CBRS_ALIGN_RIGHT && n==0) ? AFX_IDW_DOCKBAR_RIGHT : n;

    // When we take the default parameters on rect, DockControlBar will dock
    // each Toolbar on a seperate line. By calculating a rectangle, we
    // are simulating a Toolbar being dragged to that location and docked.
    DockControlBar(Bar,n,&rect);
}



/**                                                                       
 *  Called by the framework to route and dispatch command messages and 
 *  to handle the update of command user-interface objects.      
 */                                                                        
BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
    // pump through application object
    // let the MobilePhoneScreen have first crack at the command
    if (m_wndMobilePhoneScreen.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
    {
        return TRUE;
    }

    if (m_wndClampShellScreen.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
    {
        return TRUE;
    }
#if !defined (JAVA_SDK) && !defined (USE_SHAPED_UI)
    if (nCode == CN_COMMAND)
    {
        if (pHandlerInfo && m_pcPlugInManager->PlugInOnCmdMsg(nID,nCode,pExtra,pHandlerInfo))
        {
            return true;
        }
    }
#endif //JAVA_SDK
    // otherwise, do default handling
    return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}


/**                                                                       
 *  Helper function to verify state of docking windows.  
 *    
 *  @param   lpszProfileName: registry profile name.  
 *  
 *  @return  BOOL: true if OK
 */                                                                        
BOOL CMainFrame::VerifyBarState(LPCTSTR lpszProfileName)
{
    CDockState state;
    state.LoadState(lpszProfileName);
#if 0
    for (int i = 0; i < state.m_arrBarInfo.GetSize(); i++)
#else
    int nEndCounter = state.m_arrBarInfo.GetSize();
#ifndef JAVA_SDK
    if (m_pcPlugInManager)
        nEndCounter -= m_pcPlugInManager->GetNumberOfLoadedPlugIns();
#endif
    for (int i = 0; i < nEndCounter; i++)
#endif
    {
        CControlBarInfo* pInfo = (CControlBarInfo*)state.m_arrBarInfo[i];
        ASSERT(pInfo != NULL);
        int nDockedCount = pInfo->m_arrBarID.GetSize();
        if (nDockedCount > 0)
        {
            // dockbar
            for (int j = 0; j < nDockedCount; j++)
            {
                UINT nID = (UINT) pInfo->m_arrBarID[j];
                if (nID == 0) continue; // row separator
                if (nID > 0xFFFF)
                    nID &= 0xFFFF; // placeholder - get the ID
                if (GetControlBar(nID) == NULL)
                    return FALSE;
            }
        }

        if (!pInfo->m_bFloating) // floating dockbars can be created later
            if (GetControlBar(pInfo->m_nBarID) == NULL)
                return FALSE; // invalid bar ID
    }

    return TRUE;
}

/**                                                                       
 *  Helper Function to load window pos and state.  
 */                                                                        
void CMainFrame::LoadBars()
{

    CWinApp* pApp = AfxGetApp();
	TCHAR szSection[256];
 	wsprintf(szSection, _T("%s-Main"), m_cStrProfile);
	CRect rc=CRect(0,0,0,0);
	rc.left=pApp->GetProfileInt(szSection, _T("left"),10);
	rc.top=pApp->GetProfileInt(szSection, _T("top"),10);
	rc.bottom=pApp->GetProfileInt(szSection, _T("bottom"),758);
	rc.right=pApp->GetProfileInt(szSection, _T("right"),1014);
	MoveWindow(rc);
 
    if (VerifyBarState(m_cStrProfile))
    {
        LoadPosBar(m_cStrProfile);
        LoadBarState(m_cStrProfile);
    }
}

/**                                                                       
 *  Helper Function to load window pos and state.  
 */ 
void CMainFrame::LoadPosBar(CString szBars)
{
    POSITION pos = m_listControlBars.GetHeadPosition();
    while (pos != NULL)
    {
        CSizingControlBar* pBar = (CSizingControlBar*) m_listControlBars.GetNext(pos);
        ASSERT(pBar != NULL);
        if (pBar->IsKindOf(RUNTIME_CLASS(CSizingControlBar)))
            pBar->LoadState(szBars);
    }
}

/**                                                                       
 *  Helper Function to save window pos and state.  
 */ 
void CMainFrame::SavePosBar(CString szBars)
{
    POSITION pos = m_listControlBars.GetHeadPosition();
    while (pos != NULL)
    {
        CSizingControlBar* pBar = (CSizingControlBar*) m_listControlBars.GetNext(pos);
        ASSERT(pBar != NULL);
        if (pBar->IsKindOf(RUNTIME_CLASS(CSizingControlBar)))
            pBar->SaveState(szBars);
    }
}

/**                                                                       
 *  The function saves current pos of windows in registry.  
 */
void CMainFrame::OnClose()
{
#if !defined (JAVA_SDK) && !defined (USE_SHAPED_UI)
    if (m_pcPlugInManager)
    {
        m_pcPlugInManager->FreePlugIns();
        delete m_pcPlugInManager;
    }
#endif //JAVA_SDK    

    CWinApp* pApp = AfxGetApp();
    TCHAR szSection[256];
    wsprintf(szSection,_T( "%s-Main"), m_cStrProfile);
    CRect rc;
    GetWindowRect(rc);

    pApp->WriteProfileString(szSection, NULL, NULL);
    pApp->WriteProfileInt(szSection,_T("left"),   rc.left);
    pApp->WriteProfileInt(szSection,_T( "right"),  rc.right);
    pApp->WriteProfileInt(szSection,_T( "bottom"), rc.bottom);
    pApp->WriteProfileInt(szSection, _T("top"),    rc.top);
    SaveBarState(m_cStrProfile);
    SavePosBar(m_cStrProfile);

/*add by sunmin for smtktool dlg*/
#ifdef JAVA_SDK
	CMMIDispWindow * p_Disp = GET_APP()->GetMMIDispWindow();
	if(p_Disp->m_pDlgSmtkTool!=NULL)
	{
		p_Disp->m_pDlgSmtkTool->DeleteAllChildDlg();
		delete p_Disp->m_pDlgSmtkTool;
		p_Disp->m_pDlgSmtkTool=NULL;
	}
#endif

    OS_ShutdownPending = 1;

    SetTimer(ONCLOSE_TIMER,75,NULL);
}

/**                                                                       
 *  The framework calls this member function after each interval specified in the SetTimer member 
 *  function used to install a timer.  
 */ 
void CMainFrame::OnTimer(UINT nIDEvent) 
{
	switch (nIDEvent)
    {
        case ONCLOSE_TIMER:
        {
            KillTimer(ONCLOSE_TIMER);
            // close application
            exit(0);
            break;
        }

        case SETFOCUS_TIMER:
        {
            if(NULL != GET_APP()->GetMMIDispWindow())
            {
                if (GET_APP()->GetMMIDispWindow()->SetFocus() == GET_APP()->GetMMIDispWindow())
                {
                    KillTimer (SETFOCUS_TIMER);
                }
                
                break;
            }
        }
		//Added for jerry
	case BLINK_TIMER:
	{
	    if (mg_StartBlinking)
	    {
		     if (m_bBlink)
		     {
		         m_wndToolBar.LoadToolBar(IDR_MAINFRAME1);
			 m_bBlink = 0;
		     }
		     else
		     {
		         m_wndToolBar.LoadToolBar(IDR_MAINFRAME);
			m_bBlink = 1;
		     }
	    }

	    break;
	}
    }
	
	CFrameWnd::OnTimer(nIDEvent);
}

/**                                                                       
 *  Toolbar command to show or hide the MMI command window.      
 */                                                                        
void CMainFrame::OnViewMmicommands() 
{      
    if (m_wndMMICommand.IsWindowVisible())
        ShowControlBar(&m_wndMMICommand,FALSE, FALSE);
    else
        ShowControlBar(&m_wndMMICommand,TRUE, FALSE);    
}

/**                                                                       
 *  Toolbar command to show or hide the Mobile phone window.      
 */ 
void CMainFrame::OnViewPhonescreen() 
{
    if (m_wndMobilePhoneScreen.IsWindowVisible())
        ShowControlBar(&m_wndMobilePhoneScreen, FALSE, FALSE);
    else
        ShowControlBar(&m_wndMobilePhoneScreen, TRUE, FALSE);    
}

/**                                                                       
 *  Toolbar command to show or hide the clamp shell window.      
 */
void CMainFrame::OnViewClampShell() 
{
    HelperOnViewClampShell(!m_wndClampShellScreen.IsWindowVisible());
}

void CMainFrame::HelperOnViewClampShell(BOOL bShow)
{
    ShowControlBar(&m_wndClampShellScreen, bShow, FALSE);
}
/**                                                                       
 *  Menu command to show or hide the Toolbar SoftKeys.         
 */ 
void CMainFrame::OnViewToolbarSoftKeys()
{
    //just for testing. Must be moved later.
    //EnableCSDisplay(false);

    if (m_wndToolBar.IsWindowVisible())
        ShowControlBar(&m_wndToolBar,FALSE, FALSE);
    else
        ShowControlBar(&m_wndToolBar,TRUE, FALSE);    
}

/**                                                                       
 *  Menu command to show or hide the Toolbar Windows.      
 */ 
void CMainFrame::OnViewToolbarWindows()
{
     //just for testing. Must be moved later.
   // EnableCSDisplay(true);
    if (m_wndToolBarView.IsWindowVisible())
        ShowControlBar(&m_wndToolBarView,FALSE, FALSE);
    else
        ShowControlBar(&m_wndToolBarView,TRUE, FALSE);    
}

/**                                                                       
 *  Menu command to show or hide the status bar.      
 */ 
void CMainFrame::OnViewStatusbar()
{
    if (m_wndStatusBar.IsWindowVisible())
        ShowControlBar(&m_wndStatusBar,FALSE, FALSE);
    else
        ShowControlBar(&m_wndStatusBar,TRUE, FALSE);    
}

#ifdef LOCALIZATION_SUPPORT

LRESULT CMainFrame::OnUpdateWindowsUI(UINT uCode, LONG lParam)
{
	CMMIDispWindow * pWnd = GET_APP()->GetMMIDispWindow();
	ASSERT(pWnd);
//	pWnd->RegenerateMenu();
	pWnd->SendMessage(WM_UPDATE_WINDOWS_UI);
	CMMICommandTree * pTree = m_wndMMICommand.GetCommandTree();
	ASSERT(pTree);
	//pTree->RegenerateTree(TRUE);
	pTree->SendMessage(WM_UPDATE_WINDOWS_UI);
    EnableCSDisplay(CLAMSHELL_HIDE, 0);
#if _MSC_VER > 1200
	ActivateTracePopupMenu(false);
#endif
	m_wndMobilePhoneScreen.SetWindowText(CLocalizationString(IDS_WND_MOBILEPHONE));
	m_wndClampShellScreen.SetWindowText(CLocalizationString(IDS_WND_CLAMPSHELL));
	m_wndMMICommand.SetWindowText(CLocalizationString(IDS_WND_MMI_COMMAND));
	m_wndOutput.SetWindowText(CLocalizationString(IDS_WND_OUTPUT));
	this->SetWindowText(CLocalizationString(IDS_MAINFRM_TITLE));
	return 0;
}
#endif

/**                                                                       
 *  Toolbar on update command to verify check state of toolbar.      
 */ 
void CMainFrame::OnUpdateViewPhonescreen(CCmdUI* pCmdUI) 
{

    pCmdUI->SetCheck (m_wndMobilePhoneScreen.IsWindowVisible());    
}

/**                                                                       
 *  Toolbar on update command to verify check state of toolbar.     
 */ 
void CMainFrame::OnUpdateViewMmicommands(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck (m_wndMMICommand.IsWindowVisible());
}

/**                                                                       
 *  Toolbar on update command to verify check state of toolbar.     
 */ 
void CMainFrame::OnUpdateViewClampShell(CCmdUI* pCmdUI) 
{
    pCmdUI->Enable(m_bShowClampShell);
    pCmdUI->SetCheck (m_wndClampShellScreen.IsWindowVisible());
}

/**                                                                       
 * On update command to verify check state of Menu.     
 */ 
void CMainFrame::OnUpdateViewToolbarSoftKeys(CCmdUI* pCmdUI) 
{
    pCmdUI->SetCheck (m_wndToolBar.IsWindowVisible());
}

/**                                                                       
 * On update command to verify check state of Menu.     
 */
void CMainFrame::OnUpdateViewToolbarWindows(CCmdUI* pCmdUI)
{
    pCmdUI->SetCheck (m_wndToolBarView.IsWindowVisible());
}

/**                                                                       
 * On update command to verify check state of Statusbar.     
 */ 
void CMainFrame::OnUpdateViewStatusbar(CCmdUI* pCmdUI)
{
    pCmdUI->SetCheck (m_wndStatusBar.IsWindowVisible());
}

#ifndef JAVA_SDK
void CMainFrame::OnPlugInCommands(UINT uiCmd)
{
    ASSERT(m_pcPlugInManager != NULL);
    
    if (m_pcPlugInManager != NULL)
        m_pcPlugInManager->PlugInMessagePort("*", uiCmd,0,0);
}
#endif //JAVA_SDK

BOOL CMainFrame::OnEraseBkgnd(CDC* pDC) 
{
    if (g_bIsSpapedUIVibrating)
        return FALSE;
    else
        return CWnd::OnEraseBkgnd(pDC);
}
/**                                                                       
 * Command to show the Output window.     
 */ 
void CMainFrame::OnViewOutPutWindow()
{
   if (m_wndOutput.IsWindowVisible())
        ShowControlBar(&m_wndOutput, FALSE, FALSE);
    else
        ShowControlBar(&m_wndOutput, TRUE, FALSE);    
}

/**                                                                       
 * On update command to verify check state of Output window.     
 */ 
void CMainFrame::OnUpdateViewOutPutWindow(CCmdUI* pCmdUI)
{
  pCmdUI->SetCheck (m_wndOutput.IsWindowVisible());    
}


/**                                                                       
 * Command to set the Statusbar information     
 */ 
LRESULT CMainFrame::OnSetStatusbarText(UINT uCode, LONG lParam)
{
    int iIndex = 0;
    CMutex mutex;
    
    if (uCode == STATUSBARTEXT_CHANGED_MEM)
    {
        iIndex = m_wndStatusBar.CommandToIndex(ID_INDICATOR_MEM);
        if (iIndex != -1)
        {
            mutex.Lock();
            m_wndStatusBar.SetPaneText(iIndex, m_cStrStatusbarTextMEM);
            mutex.Unlock();
        }
    }
    else
    if (uCode == STATUSBARTEXT_CHANGED_WIDGET)
    {
        iIndex = m_wndStatusBar.CommandToIndex(ID_INDICATOR_WIDGET);
        if (iIndex != -1)
        {
            mutex.Lock();
            m_wndStatusBar.SetPaneText(iIndex, m_cStrStatusbarTextWIDGET);
            mutex.Unlock();
        }
    }
	return 0;
}

/**                                                                       
 * Command to set the CSDisplay menu items    
 */ 
LRESULT CMainFrame::EnableCSDisplay(UINT uCode, LONG lParam)
{
    if (uCode == CLAMSHELL_SHOW)
    {
        HelperOnViewClampShell(true);
        m_bShowClampShell = true;
        GetMenu()->EnableMenuItem((UINT)GET_APP()->GetMMIDispWindow()->hMenuCSDisp, MF_ENABLED);
    }
    else
    if (uCode == CLAMSHELL_HIDE)
    {
        HelperOnViewClampShell(false);
        m_bShowClampShell = false;
        GetMenu()->EnableMenuItem((UINT)GET_APP()->GetMMIDispWindow()->hMenuCSDisp, MF_GRAYED);
    }
    return 0;
}

/**                                                                       
 * show Java Output window     
 */ 
LRESULT CMainFrame::OnJavaOutput(UINT uCode, LONG lParam)
{
	CEvent *pcEventObj = (CEvent*)lParam;

//modify by sunmin on 2004-10-25 for fixing bug about output text.

	{
		//ShowControlBar(&m_wndOutput,TRUE, FALSE);
		m_wndOutput.JavaOutput(uCode, m_cStrJavaOutput);
#ifdef USE_SHAPED_UI
		CMMIDispWindow *pDispWnd = ((CMMIDispWindow*) GET_APP()->GetMMIDispWindow());	

		if(!(pDispWnd->m_pDlgSmtkTool))
			pDispWnd->ShowSmtkTool();   
		else
		{
            BOOL isShow=pDispWnd->m_pDlgSmtkTool->IsWindowVisible();
		
		    if(mg_autoPopupOutputWnd&&(!isShow))// && (!(pDispWnd->m_pDlgSmtkTool->IsWindowVisible())))
		   {
               pDispWnd->ShowSmtkTool();         
           }        		
		}
		pDispWnd->SetOutputView(uCode,m_cStrJavaOutput);
		
#endif
	}
	pcEventObj->SetEvent();
	m_cStrJavaOutput = "";
    return 0;
}

LRESULT CMainFrame::OnCreateGapiDlgConnect(WPARAM pGAPI_MessageParam, LPARAM lparam)
{
	gapi_CreateDialogConnect((void *)pGAPI_MessageParam);
	return 0;  
}

//Adaption this cmd msg function to class CMMIDispWindow, by sunmin
/*
 *void CMainFrame::OnShowOptionsDlg()
 *{
 *   int nResponse = m_cOptionsdlg.DoModal();
 *}
*/


T_SC_Options CMainFrame::GetSmartCardOptions()
{
    return m_cOptionsdlg.GetSmartCardOptions();
}

void CMainFrame::OnActivateApp(BOOL bActive, DWORD dwThreadID)
{

#if _MSC_VER > 1200
    CFrameWnd::OnActivateApp(bActive, dwThreadID);
#else
    CFrameWnd::OnActivateApp(bActive, (HTASK)dwThreadID);
#endif

    if (bActive)
    {  
        SetFocus();
        SetTimer (SETFOCUS_TIMER, 100, NULL);
    }    
}

void CMainFrame::ActivateTracePopupMenu(bool active)
{
    CMainFrame* pFrame = (CMainFrame*) GET_APP()->m_pMainWnd;
    if (active)
    {  
        pFrame->GetMenu()->EnableMenuItem((UINT)GET_APP()->GetMMIDispWindow()->GetPopupTraceMenu(),  MF_ENABLED);
    }
    else
    {
        pFrame->GetMenu()->EnableMenuItem((UINT)GET_APP()->GetMMIDispWindow()->GetPopupTraceMenu(),  MF_GRAYED);
    }
}

//modified by duchun for SHAPED_UI
//#ifdef JAVA_SDK
#ifdef USE_SHAPED_UI
/**                                                                       
 * This function is for shaped ui main menu window follwing the movement of the MP body
 * when the mp phone window move, the commands window also move     
 */ 
void CMainFrame::OnMove(int x, int y)
{
	CFrameWnd::OnMove(x, y);

	CRect rcFrame;
	GetWindowRect(&rcFrame);

	if (m_MainMenuDlg.m_hWnd)
	{
		if (GlobalUiSkin == SHAPED_UI_HAVE_SKIN)
		{
			m_MainMenuDlg.MoveWindow(GlobalCmdWndLeft + rcFrame.left,
				GlobalCmdWndTop + rcFrame.top,
				SHAPED_UI_CMD_WIDTH, SHAPED_UI_CMD_HEIGHT);
		}
		else  // no skin
		{
			m_MainMenuDlg.MoveWindow(GlobalCmdWndLeft + rcFrame.left,
				GlobalCmdWndTop + rcFrame.top,
				SHAPED_UI_CMD_WIDTH, SHAPED_UI_CMD_HEIGHT);

		}
	}
}
#endif // JAVA_SDK

BOOL CMainFrame::IsPaintAllowed(int iDispType)
{
    switch (iDispType)
    {
        case E_DISP_MAIN:
        {
            return (m_wndMobilePhoneScreen.IsWindowVisible() & !IsIconic());
        }
        case E_DISP_CLAMPSHELL:
        {
            return (m_wndClampShellScreen.IsWindowVisible() & !IsIconic());
        }
    }
    return true;
}

void CMainFrame::OnViewFlexshell()
{
    if (m_wndToolBarFlexshell.IsWindowVisible())
        ShowControlBar(&m_wndToolBarFlexshell,FALSE, FALSE);
    else
        ShowControlBar(&m_wndToolBarFlexshell,TRUE, FALSE);    
}


void CMainFrame::OnUpdateViewFlexshell(CCmdUI* pCmdUI)
{
  pCmdUI->SetCheck (m_wndToolBarFlexshell.IsWindowVisible());   
}

