/*! \file 

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

.AUTHOR Sun Min(ICM.MP.PD.SW(PEK))

.FILENAME dlgSmtkTool.cpp

.VERSION 01.00.00

.DATE 2004-06-17

.SHORT_DESCR:   Implementation of CDlgSmtkTool

.SW_COMPONENT:  SMTK EMULATOR

.SW_TYPE 

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change

01.00.00 2004-06-17 Sun Min(PEK)
		    Initial version
01.00.01 2004-06-18 Sun Min(PEK)
                    Use this file only for SHAPED UI	
01.00.02 2004-06-24 Fang Yunchao(PEK)
                  modification for SMTK Localization support	    
01.01.00 2004-08-17 Sun Min(PEK)
                    Add functions OnDestroy(), OnSize(),
                    Modify function SetOutputView()
01.01.01 2004-10-25 Sun Min(PEK)
                    Fix bug DT100106551,
                    Modify function OnInitDialog() for fix bug.
01.01.01 2004-11-04 Sun Min(PEK)
                    Enable SMTK Tool both in MDV and Shaped UI.
01.01.02 2005-03-09 Guan Tian yi(PEK)
                    Add the Print Stack Trace
*/

//enable both MDV and Shaped UI
#ifdef JAVA_SDK

#include "DlgSmtkTool.h"
#include "javaoutputviewh.h"

extern int WriteRegistryString( HKEY hKey, char* SubKey, char* Name, char* Value);
extern void ReadRegistryString ( HKEY hKey, char* SubKey, char* Name, char* Value, int &result);

#ifdef JAVA_SDK    //flag for auto popup tool output window
extern int mg_autoPopupOutputWnd;
//extern int mg_smtkToolDlgOpened;
#endif


// SmtkToolDlg dialog

IMPLEMENT_DYNAMIC(CDlgSmtkTool, CDialog)
CDlgSmtkTool::CDlgSmtkTool(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgSmtkTool::IDD, pParent)
	
{
	m_pSmtkToolHeap=NULL;
	m_pSmtkToolOutput=NULL;
}


CDlgSmtkTool::~CDlgSmtkTool()
{
	
}


void CDlgSmtkTool::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgSmtkTool)
	DDX_Control(pDX, IDC_SMTKTOOL_TAB, m_tabctrl);
        DDX_Control(pDX, IDC_SMTKTOOL_JAVAHEAPINFO, m_JavaHeapInfo);
	DDX_Check(pDX, IDC_SMTKTOOL_JAVAHEAPINFO_CHECKBOX, m_Check);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgSmtkTool, CDialog)
	ON_NOTIFY(TCN_SELCHANGE, IDC_SMTKTOOL_TAB, OnTcnSelchangeSmtktoolTab)
	ON_WM_SIZE()
	ON_WM_CLOSE()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_SMTKTOOL_JAVAHEAPINFO_CHECKBOX, OnBnClickedSmtktoolJavaheapinfoCheckbox)
END_MESSAGE_MAP()


// SmtkToolDlg message handlers



BOOL CDlgSmtkTool::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	
	RECT lpRect;
	CRect infoRect,checkBoxRect;
	LONG iX,iY,iWidth,iHeight;
	//Get size of dialog window
	GetClientRect(&lpRect);
	GetDlgItem(IDC_SMTKTOOL_JAVAHEAPINFO)->GetWindowRect(infoRect);
	iX=lpRect.left+5;
	iY=lpRect.bottom-5-infoRect.Height();
	iWidth=lpRect.right-lpRect.left-10;
	iHeight=infoRect.Height();
	GetDlgItem(IDC_SMTKTOOL_JAVAHEAPINFO)->MoveWindow(iX,iY,iWidth,iHeight);

	//Move the checkBox
	GetDlgItem(IDC_SMTKTOOL_JAVAHEAPINFO_CHECKBOX)->GetWindowRect(checkBoxRect);
	iY-=(5+checkBoxRect.Height());
	GetDlgItem(IDC_SMTKTOOL_JAVAHEAPINFO_CHECKBOX)->MoveWindow(iX,iY,checkBoxRect.Width(),checkBoxRect.Height());



	//Move the tab control to the new position and size
	iX=lpRect.left+5;
	iY=lpRect.top+5;
	iWidth=lpRect.right-lpRect.left-10;
	iHeight=lpRect.bottom-lpRect.top-infoRect.Height()-40;
	m_tabctrl.MoveWindow(iX,iY,iWidth,iHeight);
	//Move the item window(java heap dialog and output dialog) to the new position and size.
	//m_tabctrl.GetWindowRect(infoRect);
	m_tabctrl.GetClientRect(infoRect);
	//ScreenToClient(infoRect);
	iX=infoRect.left+10;
	iY=infoRect.top+30;
	iWidth=infoRect.Width()-10;
	iHeight=infoRect.Height()-30;
	

	// TODO:  Add extra initialization here

	/*Initialization tabelctrl for smtk tool*/
		

	//add the "heap" window
	m_pSmtkToolHeap=new CSmtkToolHeap;
	m_pSmtkToolHeap->Create(CSmtkToolHeap::IDD, this);
	TCITEM item;
	item.mask = TCIF_TEXT|TCIF_PARAM;
	item.lParam = (LPARAM) m_pSmtkToolHeap;
	item.pszText = _T("Heap");
	m_tabctrl.InsertItem(0, &item);

     
	m_pSmtkToolHeap->MoveWindow(iX,iY,iWidth,iHeight);
	m_pSmtkToolHeap->ShowWindow(SW_SHOW);
	

	//** add the "output" window
	
	m_pSmtkToolOutput=new CSmtkToolOutput;
	m_pSmtkToolOutput->Create(CSmtkToolOutput::IDD,this);
	item.lParam = (LPARAM) m_pSmtkToolOutput;
	item.pszText = _T("Output");
	
	m_tabctrl.InsertItem(1, &item);

        
	m_pSmtkToolOutput->MoveWindow(iX,iY,iWidth,iHeight);
	m_pSmtkToolOutput->GetClientRect(&lpRect);
	m_pSmtkToolOutput->m_outputView.MoveWindow(&lpRect);

	m_pSmtkToolOutput->ShowWindow(SW_HIDE);
	
	//initialize the java heap info
	m_JavaHeapInfo.Clear();
	HKEY hKey = HKEY_CURRENT_USER ;
	char subKey[] = "SOFTWARE\\Siemens\\SMTK_3.X\\Emulators";
	char name[] = "mg_ToolWndPopup";
	char chValue[255];
	int iValue;
	ReadRegistryString(hKey,subKey,name,chValue,iValue);
	
	CButton *pButton = (CButton*)GetDlgItem(IDC_SMTKTOOL_JAVAHEAPINFO_CHECKBOX);
	if(memcmp(chValue,"1",1) == 0)
	{
		m_Check = TRUE;
		pButton->SetCheck(1);
		mg_autoPopupOutputWnd = 1;
	}
	else
	{
		m_Check = FALSE;
		pButton->SetCheck(0);
		mg_autoPopupOutputWnd = 0;
	}
	
        m_tabctrl.SetCurSel(1);	
	this->PostMessage(WM_SIZE,0,0);	

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}


void CDlgSmtkTool::OnTcnSelchangeSmtktoolTab(NMHDR* pNMHDR, LRESULT* pResult)
{
	// TODO: Add your control notification handler code here
	int nIndex=m_tabctrl.GetCurSel();

	switch(nIndex)
	{
	case 0:
		m_pSmtkToolHeap->ShowWindow(SW_SHOW);
		m_pSmtkToolOutput->ShowWindow(SW_HIDE);
        break;
	case 1:
		//show output window here;
		m_pSmtkToolHeap->ShowWindow(SW_HIDE);
		m_pSmtkToolOutput->ShowWindow(SW_SHOW);
		break;
	default:
		//show method window here;
		ASSERT(FALSE);
		break;
	}

	*pResult = 0;
}

void CDlgSmtkTool::OnDestroy(void)
{
	CDialog::OnDestroy();

}

void CDlgSmtkTool::OnClose(void)
{
	CDialog::OnClose();

}

void CDlgSmtkTool::DeleteAllChildDlg(void)
{
	if(m_pSmtkToolHeap!=NULL)
		delete m_pSmtkToolHeap;
	
	if(m_pSmtkToolOutput!=NULL)
		delete m_pSmtkToolOutput;
		
}

/*External interface to set runtime Java heap value in SMTK Tool Utilities window*/
void CDlgSmtkTool::SetJavaHeap(CString cStr)
{	
	m_JavaHeapInfo.Clear();
	m_JavaHeapInfo.SetWindowText(cStr);
}

/*External interface to set output information in SMTK Tool Utilities window*/

void CDlgSmtkTool::SetOutputView(UINT uiMessage,CString cStrOutPut)
{
	m_pSmtkToolOutput->SetOutputView(uiMessage,cStrOutPut);
	m_pSmtkToolOutput->UpdateWindow();
}


void CDlgSmtkTool::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType,cx,cy);
	if(m_tabctrl.m_hWnd==NULL)
		return;

	RECT lpRect;
	CRect infoRect,checkBoxRect;
	LONG iX,iY,iWidth,iHeight;

	//Get size of dialog window
	GetClientRect(&lpRect);

	//Move the info display to the new position and size

	GetDlgItem(IDC_SMTKTOOL_JAVAHEAPINFO)->GetWindowRect(infoRect);
	iX=lpRect.left+5;
	iY=lpRect.bottom-5-infoRect.Height();
	iWidth=lpRect.right-lpRect.left-10;
	iHeight=infoRect.Height();
	GetDlgItem(IDC_SMTKTOOL_JAVAHEAPINFO)->MoveWindow(iX,iY,iWidth,iHeight);

	//Move the checkBox
	GetDlgItem(IDC_SMTKTOOL_JAVAHEAPINFO_CHECKBOX)->GetWindowRect(checkBoxRect);
	iY-=(5+checkBoxRect.Height());
	GetDlgItem(IDC_SMTKTOOL_JAVAHEAPINFO_CHECKBOX)->MoveWindow(iX,iY,checkBoxRect.Width(),checkBoxRect.Height());

	

	//Move the tab control to the new position and size
	iX=lpRect.left+5;
	iY=lpRect.top+5;
	iWidth=lpRect.right-lpRect.left-10;
	iHeight=lpRect.bottom-lpRect.top-infoRect.Height()-40;
	m_tabctrl.MoveWindow(iX,iY,iWidth,iHeight);
	
	//Move the item window(java heap dialog and output dialog) to the new position and size.
	//m_tabctrl.GetWindowRect(infoRect);
	m_tabctrl.GetClientRect(infoRect);
	//ScreenToClient(infoRect);
	iX=infoRect.left+10;
	iY=infoRect.top+30;
	iWidth=infoRect.Width()-10;
	iHeight=infoRect.Height()-30;
	m_pSmtkToolOutput->MoveWindow(iX,iY,iWidth,iHeight);
	m_pSmtkToolOutput->GetClientRect(&lpRect);
	m_pSmtkToolOutput->m_outputView.MoveWindow(&lpRect);
	m_pSmtkToolHeap->MoveWindow(iX,iY,iWidth,iHeight);

	//Move the item in the item-window of ctrltab.
	int nIndex=m_tabctrl.GetCurSel();
	switch(nIndex)
	{
	case 0:
		m_pSmtkToolHeap->ShowWindow(SW_SHOW);
		m_pSmtkToolOutput->ShowWindow(SW_HIDE);
		break;
	case 1:
		//show output window here;
		m_pSmtkToolHeap->ShowWindow(SW_HIDE);
		m_pSmtkToolOutput->ShowWindow(SW_SHOW);
		m_pSmtkToolOutput->Invalidate(TRUE);
		m_pSmtkToolOutput->m_outputView.ShowWindow(SW_SHOW);
		break;
	default:
		//show method window here;
		ASSERT(FALSE);
		break;
	}
}



void CDlgSmtkTool::OnBnClickedSmtktoolJavaheapinfoCheckbox()
{
	// TODO: Add your control notification handler code here
	HKEY hKey = HKEY_CURRENT_USER ;
	char subKey[] = "SOFTWARE\\Siemens\\SMTK_3.X\\Emulators";
	char name[] = "mg_ToolWndPopup";
	char chValue[3] = "0\0";
	int iValue;
	
	UpdateData(TRUE);
	if(m_Check == TRUE )
	{
		chValue[0] = '1' ;
		mg_autoPopupOutputWnd = 1;
	}
	else
	{
		chValue[0] = '0' ;
		mg_autoPopupOutputWnd = 0;
	}
	WriteRegistryString(HKEY_CURRENT_USER,subKey,name,chValue);
}

#endif
