/* ----------------------------------------------------------------------------

Copyright (C) Siemens AG 1994-2004 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

.AUTHOR        Norbert Barisits

.FILENAME      MOPI_PlugInDlg.cpp

.VERSION       00.00.00

.DATE          2004-03-25

.SHORT_DESCR:  MOPI plugin for PC MMI

.SW_COMPONENT: MOPI

.SW_TYPE       OPERATING SYSTEM

.EXIT_CODES

.CHANGE_CONTROL
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
00.00.00 2004-03-25  Norbert Barisits
         initial version
------------------------------------------------------------------------------*/

#pragma once

#include "resource.h"
#include "afxwin.h"
#include "afxcmn.h"
#include "InfoList.h"
// CMOPI_PlugInDlg dialog

interface IApplicationInterfaceMOPI;

class CMOPI_PlugInDlg : public CDialog
{
	DECLARE_DYNAMIC(CMOPI_PlugInDlg)

    enum eMopiResourceType
    {
        eDlgNotUsed = 0,
        eDlgSetup,
        eDlgResourceUsage,
        eDlgMemory,
        eDlgHeap,
        eDlgBlockpool,
        eDlgProcessControl,
        eDlgSAProcesses,
        eDlgProcessGroups,
        eDlgSystemtasks,
        eDlgInterrupttasks,
        eDlgMessageHandling,
        eDlgQueueManagement,
        eDlgTimerManagement,
		eDlgMsgReceivers,
		eDlgTransactions,
		eDlgMessageLog,
		eDlgPendingQueues,
		eDlgMessageQueues,
		eDlgTimers,
		eDlgSyncManagement,
		eDlgMutexes,
		eDlgMsgLog,
		eDlgProcQueueDetail,
		eDlgPendQueueDetail
    };

    static const int BORDER_WIDTH  = 10;
    static const int TREE_WIDTH    = 160;
    static const int BUTTON_WIDTH  = 80;
    static const int BUTTON_HEIGHT = 24;

public:
	CMOPI_PlugInDlg(IApplicationInterfaceMOPI* ipMOPI, UINT uiType = 0, CWnd* pParent = NULL);   // standard constructor
	virtual ~CMOPI_PlugInDlg();
    virtual BOOL OnInitDialog();
// Dialog Data
	enum { IDD = IDD_DIALOG_INFO };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	DECLARE_MESSAGE_MAP()
    IApplicationInterfaceMOPI* m_ipMOPI;
    UINT m_uiType;

    eMopiResourceType m_eType;
    eMopiResourceType m_lastEType;
    bool m_created;
    virtual void OnOK();
    virtual void OnCancel();

    void UserSelChange();
    void Display_NotImpl();
    void Display_Memory();
    void Display_Heap();
    void Display_Blockpool();
    void Display_ResourceUsage();
    void Display_ProcessUse( T_IMOPI_ResourceTable *pResTable );
    void Display_SAProcesses( T_IMOPI_ResourceTable *pResTable );
    void Display_ProcGroups( T_IMOPI_ResourceTable *pResTable );
    void Display_Tasks( T_IMOPI_ResourceTable *pResTable, T_IMOPI_ResourceType type );
    void Display_MsgHndlResources( T_IMOPI_MsgResources *pRes );
    void Display_QueueResources( T_IMOPI_QueueResources *pRes );
    void Display_TimerResources( T_IMOPI_TimerResources *pRes );
    void Display_SyncResources( T_IMOPI_SyncResources *pRes );
    void Display_Mutexes( T_IMOPI_SyncResources *pRes );
    void Display_Timers( T_IMOPI_TimerResources *pRes );
    void Display_MsgLog( T_IMOPI_MsgLog *pLog );
    void Display_ProcessQueues( T_IMOPI_QueueResources *pRes );
    void Display_PendingQueues( T_IMOPI_QueueResources *pRes );

protected:
    CTreeCtrl m_cTree;
    CInfoList m_cList;

public:
    afx_msg void OnTvnSelchangedTree(NMHDR *pNMHDR, LRESULT *pResult);
    afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg void OnNMDblclkList(NMHDR *pNMHDR, LRESULT *pResult);
    afx_msg void OnTimer(UINT nIDEvent);
    afx_msg void OnBnClickedButtonrefresh();
    afx_msg void OnNMDblclkTree(NMHDR *pNMHDR, LRESULT *pResult);
};
