/* -----------------------------------------------------------------------------

Copyright (C) Siemens AG 1994-2004 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

.AUTHOR        Walter Stroell

.FILENAME      MOPI_MsgPostDlg.cpp

.VERSION       00.00.01

.DATE          2004-06-17

.SHORT_DESCR:  MOPI plugin for PC MMI

.SW_COMPONENT: MOPI

.SW_TYPE       OPERATING SYSTEM

.EXIT_CODES

.CHANGE_CONTROL
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
00.00.00 2004-03-25  Walter Stroell (VIE)
         initial version
00.00.01 2004-06-17  Walter Stroell (VIE)
         formal modifications
------------------------------------------------------------------------------*/

#include "stdafx.h"
#include "MOPI_PlugIn.h"
#include "MOPI_MsgPostDlg.h"
#include ".\mopi_msgpostdlg.h"

// MOPI_MsgPostDlg dialog

IMPLEMENT_DYNAMIC(MOPI_MsgPostDlg, CDialog)
MOPI_MsgPostDlg::MOPI_MsgPostDlg(IApplicationInterfaceMOPI* ipMOPI, CWnd* pParent /*=NULL*/)
	: CDialog(MOPI_MsgPostDlg::IDD, pParent)
{
	m_ipMOPI = ipMOPI;
    m_cepSrcValid = false;
    m_cepTargetValid = false;
    m_msgIdValid = false;
    m_payloadLengthValid = false;
    m_payloadValid = true;
}

MOPI_MsgPostDlg::~MOPI_MsgPostDlg()
{
}

void MOPI_MsgPostDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDITCepSrc, m_cEditCepSource);
	DDX_Control(pDX, IDC_EDITCepTarget, m_cEditCepTarget);
	DDX_Control(pDX, IDC_EDITMsgId, m_cEditMsgId);
	DDX_Control(pDX, IDC_EDITMsgLength, m_cEditMsgLength);
	DDX_Control(pDX, IDC_EDITMsgPayload, m_cEditMsgPayload);
}


BEGIN_MESSAGE_MAP(MOPI_MsgPostDlg, CDialog)
ON_EN_UPDATE(IDC_EDITCepSrc, OnEnUpdateEditcepsrc)
ON_EN_CHANGE(IDC_EDITCepTarget, OnEnChangeEditceptarget)
ON_EN_CHANGE(IDC_EDITMsgId, OnEnChangeEditmsgid)
ON_EN_CHANGE(IDC_EDITMsgLength, OnEnChangeEditmsglength)
ON_EN_CHANGE(IDC_EDITMsgPayload, OnEnChangeEditmsgpayload)
ON_BN_CLICKED(IDPost, OnBnClickedPost)
END_MESSAGE_MAP()


void MOPI_MsgPostDlg::OnEnUpdateEditcepsrc()
{
	CString cepSrc;
	int     hexVal;
	m_cEditCepSource.GetWindowText( cepSrc );
	if (cepSrc.GetLength() > 4)
	{
		cepSrc.Truncate( 4 );
		m_cEditCepSource.SetWindowText( cepSrc );
	}
	m_cepSrcValid = Hex2Val( cepSrc.GetString(), hexVal, 0xFFFF );
	m_pMsg.cepSource = (short)hexVal;
}

void MOPI_MsgPostDlg::OnEnChangeEditceptarget()
{
	CString cepTarget;
	int     hexVal;

	m_cEditCepTarget.GetWindowText( cepTarget );
	if (cepTarget.GetLength() > 4)
	{
		cepTarget.Truncate( 4 );
		m_cEditCepTarget.SetWindowText( cepTarget );
	}
	m_cepTargetValid = Hex2Val( cepTarget.GetString(), hexVal, 0xFFFF );
	m_pMsg.cepTarget = (short)hexVal;
}

void MOPI_MsgPostDlg::OnEnChangeEditmsgid()
{
	CString msgId;
	int     hexVal;

	m_cEditMsgId.GetWindowText( msgId );
	if (msgId.GetLength() > 4)
	{
		msgId.Truncate( 4 );
		m_cEditMsgId.SetWindowText( msgId );
	}
	m_msgIdValid = Hex2Val( msgId.GetString(), hexVal, 0xFFFF );
	m_pMsg.msgId = (short)hexVal;
}

void MOPI_MsgPostDlg::OnEnChangeEditmsglength()
{
	CString payloadLength;
	int     hexVal;

	m_cEditMsgLength.GetWindowText( payloadLength );
	if (payloadLength.GetLength() > 4)
	{
		payloadLength.Truncate( 4 );
		m_cEditMsgLength.SetWindowText( payloadLength );
	}
	m_payloadLengthValid = Hex2Val( payloadLength.GetString(), hexVal, 0xFFFF );
	m_pMsg.payloadLength = (short)hexVal;
}

void MOPI_MsgPostDlg::OnEnChangeEditmsgpayload()
{

}

void MOPI_MsgPostDlg::OnBnClickedPost()
{
    char*   p;
    char*   delim = ", ";
    int     count = 0;
    size_t  sLength;
    int     v;
	CString msgPayload;

	if ( !m_cepSrcValid )
	{
		(void)MessageBox( "CEP-Id source invalid", "ERROR", MB_OK );
		return;
	}

	if ( !m_cepTargetValid )
	{
		(void)MessageBox( "CEP-Id target invalid", "ERROR", MB_OK );
		return;
	}

	if ( !m_msgIdValid )
	{
		(void)MessageBox( "message id value invalid", "ERROR", MB_OK );
		return;
	}

    if ( !m_payloadLengthValid )
	{
		(void)MessageBox( "payload length invalid", "ERROR", MB_OK );
		return;
	}

	m_cEditMsgPayload.GetWindowText( msgPayload );

    m_payloadValid = true;
    p = strtok( (char*)msgPayload.GetString(), delim );
    while (p)
    {
        sLength = strlen( p );
        // try to get a byte value
        if (Hex2Val( p, v, 0xFF ) == false)
        {
            m_payloadValid = false;
        }
        if (count < IAPPLIF_MSG_PAYLOAD_SIZE_MAX)
        {
            m_pMsg.payload[ count ] = (char) v;
            ++count;
        }
        else
        {
            m_payloadValid = false;
        }
        p = strtok( 0, delim );
    }

    if ( !m_payloadValid )
	{
		(void)MessageBox( "payload invalid", "ERROR", MB_OK );
		return;
	}

	if ( count == 0 )
	{
		if ( m_pMsg.payloadLength != 0 )
		{
			(void)MessageBox( "payload missing", "ERROR", MB_OK );
			return;
		}
	}
	else
	{
		if ( count < m_pMsg.payloadLength )
		{
			(void)MessageBox( "payload length invalid", "ERROR", MB_OK );
			return;
		}
	}

	(void)m_ipMOPI->Command( ePostMsg, (void*)&m_pMsg );
}

bool MOPI_MsgPostDlg::Hex2Val( const char* s, int& value, unsigned int limit )
{
    unsigned int   r = 0;
    bool  hit = false;
    bool  fault = false;

    while (*s)
    {
        hit = true;
        if (*s >= '0' && *s <= '9')
        {
            r = (r << 4) + *s - 0x30;
        }
        else if (*s >= 'A' && *s <= 'F')
        {
            r = (r << 4) + *s - 0x41 + 10;
        }
        else
        {
            fault = true;
        }
        ++s;
    }
    if (hit == true && fault == false)
    {
        value = r;
        if (r <= limit)
            return (true);
        else
            return (false);
    }
    value = 0;
    return (false);
}

