/* -----------------------------------------------------------------------------

Copyright (C) Siemens AG 1994-2004 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

.AUTHOR        Norbert Barisits

.FILENAME      MOPI_MemDumpDlg.cpp

.VERSION       00.00.00

.DATE          2004-03-31

.SHORT_DESCR:  MOPI plugin for PC MMI

.SW_COMPONENT: MOPI

.SW_TYPE       OPERATING SYSTEM

.EXIT_CODES

.CHANGE_CONTROL
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
00.00.00 2004-03-31  Norbert Barisits
         initial version
------------------------------------------------------------------------------*/

#include "stdafx.h"
#include "mopi.h"
#include "Iappinterfacemopi.h"
#include "MOPI_PlugIn.h"
#include "MOPI_MemDumpDlg.h"
#include ".\mopi_memdumpdlg.h"

#define MOPI_MEM_DATA(pHeader)  ((unsigned char *)((T_IMOPI_MemBlockHeader *)pHeader + 1))

// MOPI_MemDumpDlg dialog

IMPLEMENT_DYNAMIC(MOPI_MemDumpDlg, CDialog)
MOPI_MemDumpDlg::MOPI_MemDumpDlg( IApplicationInterfaceMOPI* ipMOPI, DWORD_PTR pMem, CWnd* pParent /*=NULL*/)
	: CDialog(MOPI_MemDumpDlg::IDD, pParent)
{
    m_ipMOPI = ipMOPI;
    m_pMem = pMem;
    // Initializes a CFont object with the specified characteristics. 
    VERIFY(m_cFont.CreateFont(
    -11,                       // nHeight
    0,                         // nWidth
    0,                         // nEscapement
    0,                         // nOrientation
    FW_NORMAL,                 // nWeight
    FALSE,                     // bItalic
    FALSE,                     // bUnderline
    0,                         // cStrikeOut
    ANSI_CHARSET,              // nCharSet
    OUT_DEFAULT_PRECIS,        // nOutPrecision
    CLIP_DEFAULT_PRECIS,       // nClipPrecision
    DEFAULT_QUALITY,           // nQuality
    FIXED_PITCH,               // nPitchAndFamily
    "Courier New"));           // lpszFacename
}

MOPI_MemDumpDlg::~MOPI_MemDumpDlg()
{
    // Done with the font.  Delete the font object.
    m_cFont.DeleteObject();
}

void MOPI_MemDumpDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_EDIT, m_cEdit);
}


BEGIN_MESSAGE_MAP(MOPI_MemDumpDlg, CDialog)
END_MESSAGE_MAP()


// MOPI_MemDumpDlg message handlers

BOOL MOPI_MemDumpDlg::OnInitDialog() 
{
    T_IMOPI_MemBlockHeader *pMB = (T_IMOPI_MemBlockHeader *)m_pMem;

    CDialog::OnInitDialog();

    m_cEdit.SetFont( &m_cFont, FALSE );

    if (pMB != NULL && pMB->uSize > 0)
    {
        CString  cStr;
        int   i;
        int   size = pMB->uSize;
        unsigned char *pBase = MOPI_MEM_DATA( pMB );
        unsigned char *p = pBase;

        cStr.Format( "Memory Dump - %s", pMB->pMO->name );
        SetWindowText( cStr );

        char *textBuffer = (char *)malloc( (((size / 16) + 1) * 80) + 200 );
        int  currentPos = 0;

        cStr = pMB->filename;
        if (cStr.GetLength() > 59)
        {
            cStr = cStr.Left( 23 ) + ".." + cStr.Right( 34 );
        }

        currentPos += sprintf( &textBuffer[ currentPos ],
            "CepID: 0x%04X, Size: %d\r\nFile#Line: %s#%d\r\n\r\n",
            pMB->cepId, pMB->uSize, cStr, pMB->lineNumber );

        for (i = 0; i < size;)
        {
            int ic = i;
            int boundary = i + 16;
            currentPos += sprintf( &textBuffer[ currentPos ], "%p:", p );
            p += 16;
            for (; i < boundary && i < size; ++i)
            {
                currentPos += sprintf( &textBuffer[ currentPos ], " %02X", pBase[ i ] );
            }
            for (; i < boundary; ++i)
            {
                currentPos += sprintf( &textBuffer[ currentPos ], "   " );
            }
            currentPos += sprintf( &textBuffer[ currentPos ], " | " );
            i = ic;
            for (; i < boundary && i < size; ++i)
            {
                unsigned char c = pBase[ i ];
                if (c < 0x20 || c > 0x7F)
                    c = '.';
                currentPos += sprintf( &textBuffer[ currentPos ], "%c", c );
            }
            currentPos += sprintf( &textBuffer[ currentPos ], "\r\n" );
        }
        m_cEdit.SetWindowText( textBuffer );
        free( textBuffer );
    }

    int textLen = m_cEdit.GetWindowTextLength();
    m_cEdit.SetSel( textLen, textLen, TRUE );
    m_cEdit.SetFocus();
    return FALSE;
}

