/* -----------------------------------------------------------------------------

Copyright (C) Siemens AG 1994-2004 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

.AUTHOR        Walter Stroell

.FILENAME      MOPI_GrpDetailDlg.cpp

.VERSION       00.00.01

.DATE          2004-06-17

.SHORT_DESCR:  MOPI plugin for PC MMI

.SW_COMPONENT: MOPI

.SW_TYPE       OPERATING SYSTEM

.EXIT_CODES

.CHANGE_CONTROL
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
00.00.00 2004-03-25  Walter Stroell (VIE)
         initial version
00.00.01 2004-06-17  Walter Stroell (VIE)
         memory consumed added for process and task resources
------------------------------------------------------------------------------*/

#include "stdafx.h"
#include "mopi_pctrl.h"
#include "MOPI_PlugIn.h"
#include "MOPI_GrpDetailDlg.h"
#include ".\mopi_grpdetaildlg.h"

extern const char * ProcStateString( T_IMOPI_ProcessState_Enum );

// MOPI_GrpDetailDlg dialog

IMPLEMENT_DYNAMIC(MOPI_GrpDetailDlg, CDialog)
MOPI_GrpDetailDlg::MOPI_GrpDetailDlg(DWORD_PTR pGroup, CWnd* pParent /*=NULL*/)
	: CDialog(MOPI_GrpDetailDlg::IDD, pParent)
{
    m_pGroup = pGroup;
}

MOPI_GrpDetailDlg::~MOPI_GrpDetailDlg()
{
}

void MOPI_GrpDetailDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST, m_cList);
}


BEGIN_MESSAGE_MAP(MOPI_GrpDetailDlg, CDialog)
END_MESSAGE_MAP()


// MOPI_GrpDetailDlg message handlers

BOOL MOPI_GrpDetailDlg::OnInitDialog() 
{
    CDialog::OnInitDialog();
    ASSERT (m_pGroup != NULL);
	T_IMOPI_GroupProcess *pProc;

    if (m_pGroup != NULL)
    {
        CString  cStr;
        int      i;
		int      p;
        T_IMOPI_ProcessGroup *pGroup = (T_IMOPI_ProcessGroup*)m_pGroup;

        SetWindowText( (LPCTSTR)pGroup->resHeader.pTaskConfig->pTaskName );

        // Delete all items (Rows)
        m_cList.DeleteAllItems();
        // Delete all of the columns
        int nColumnCount = m_cList.GetHeaderCtrl()->GetItemCount();
        for (i = 0; i < nColumnCount; i++)
        {
            m_cList.DeleteColumn( 0 );
        }

        i = 0;
        // setup listview
		m_cList.InsertColumn( i, _T("Name"),            LVCFMT_LEFT, 200, i++ );
		m_cList.InsertColumn( i, _T("CEP-Id"),          LVCFMT_LEFT,  50, i++ );
		m_cList.InsertColumn( i, _T("Prio"),            LVCFMT_LEFT,  40, i++ );
		m_cList.InsertColumn( i, _T("State"),           LVCFMT_LEFT,  70, i++ );
		m_cList.InsertColumn( i, _T("Trace mask"),      LVCFMT_LEFT,  70, i++ );
		m_cList.InsertColumn( i, _T("Msg"),             LVCFMT_LEFT,  50, i++ );
        m_cList.InsertColumn( i, _T("max. Msg"),        LVCFMT_LEFT,  70, i++ );
        m_cList.InsertColumn( i, _T("mem consumed"),    LVCFMT_LEFT, 100, i++ );

		i = 0;
		for (p = 0; p < pGroup->maxMembers; p++)
		{
			if ( ( pProc = pGroup->pProcess[p] ) != 0 )
			{
				int j = 1;
				cStr.Format( "%s", pProc->procBase.pName );
				m_cList.InsertItem(  i, cStr );
				cStr.Format( "0x%04X", pProc->procBase.cepId );
				m_cList.SetItemText( i, j++, cStr );
				cStr.Format( "%d", pProc->procBase.prio );
				m_cList.SetItemText( i, j++, cStr );
				cStr.Format( "%s", ProcStateString(pProc->procBase.state) );
				m_cList.SetItemText( i, j++, cStr );
				cStr.Format( "0x%04X", pProc->procBase.traceMask );
				m_cList.SetItemText( i, j++, cStr );
				cStr.Format( "%d", pProc->procBase.queue.msgCount );
				m_cList.SetItemText( i, j++, cStr );
				cStr.Format( "%d", pProc->procBase.queue.maxCount );
				m_cList.SetItemText( i, j++, cStr );
				cStr.Format( "0x%04X", pProc->procBase.memConsumed );
				m_cList.SetItemText( i, j++, cStr );
				i++;
			}
		}
        if (i == 0)
        {
            m_cList.InsertItem( i, _T("no group process created") );
        }
    }

    ListView_SetExtendedListViewStyleEx( GetDlgItem( IDC_LIST )->m_hWnd,
        LVS_EX_FULLROWSELECT | LVS_EX_TWOCLICKACTIVATE,
        LVS_EX_FULLROWSELECT | LVS_EX_TWOCLICKACTIVATE );
	return TRUE;
}
