/* -----------------------------------------------------------------------------

 Copyright (C) Siemens AG 1994-2001,  ALL RIGHTS RESERVED

 This software is protected by the inclusion of the above copyright
 notice. This software may not be provided or otherwise made available
 to, or used by, any other person. No title to or ownership of the
 software is  hereby  transferred.
 The information contained in this document is considered the
 CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
 not be disclosed or discussed with anyone who is not employed by
 Siemens AG, unless the individual / company
 (i) has an express need to know such information, and
 (ii) disclosure of information is subject to the terms of a duly
 executed Confidentiality and Non-Disclosure Agreement between
 Siemens AG and the individual / company.



.AUTHOR         Zhang Jing (PEK)

.FILENAME       sp_bmpdlg.cpp

.VERSION        01.00.00

.DATE           2004-03-17

.SHORT_DESCR    command list embedded in the visio bar

.SW_COMPONENT   MMI PC-SIMULATION

.SW_TYPE        

.EXIT_CODES

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
01.00.00 2004-03-17  Zhang Jing (PEK)
         Initial version
01.00.01 2004-04-30  Zhang qifan (PEK)
         remove "File system" commands in SMTK emulator  
01.00.02 2004-04-30  Zhang qifan (PEK)
         update command list for both MMI command tree and Shaped-UI command list for SMTK emulators only
01.01.00 2004-05-17  Alexander Nagy (Bardenheuer Software)
         - removed mms simulation for MMI_MMS_AVAILABLE == 0
01.01.01 2004-05-28 Du Chun (PEK)          
         Seperate SHAPED UI feature from JAVA_SDK. 
01.01.02 2004-05-28 Du Chun (PEK)          
         Execute SMTK phone commands in same function.
01.01.03 2004-06-16 Sun Min(PEK)
         Use new icons for command tree and command list.
01.00.04 2004-04-30  Fang Yunchao (PEK)
         Add UNICODE & Localization support
01.01.05 2005-1-25  Li Yang(PEK)
         Add new item for MPM connection

**************************************Jerry*********************************
02.00.00  2006-03-17  Gurpreet Sabharwal(SISL ,India)
                      Removed Java Support And Functionality




*/


#pragma once
#include "smsafxh.h"
#include "sms_res.h"
#include "sp_cmdlisth.h"
#include "simuapph.h"


extern "C"
{
#include <global.h>
#include "llisth.h"
#include "listview.h"
}

#include <stdlib.h>
#include <stdio.h>
#include "winmain.h"
#include "winrc.h"
#include "simsimh.h"
// shaped ui
#include "mainfrmh.h"
//#include "upsimh.h"

extern "C"
{
#include "gbs.h"
#include "gbsext.h"
#include "mopiext.h" //@Str
#include "msmsim.h"
#include "mmsim.h"
#include "mmi.h"
#include "aoc_al.h"
#include "power_al.h"
#include "ck_data.h"
#include "ataldech.h"
#include "apptoolk.h"
#include "sms_simh.h"
#include "ck_data.h"
#include "ck_port.h"
#include "ck_state.h"
#include "mmiconf.h"
#ifndef MMI_CAMERA_AVAILABLE
  #define MMI_CAMERA_AVAILABLE 0
#endif

#ifdef MMI_NIGHTDESIGN_AVAILABLE
#include "msmled.h"
#endif

//#include "ob_tcp.h"

#include "skviewh.h"
//#include "jenv.h"   //JAVA
#include "sim_regh.h"

#include "accdefs.h"

// following includes needed for Simulation of Carkit GPS
// JLehmann: This is not the suitable file for this Carkit Simulation!!!
#include "xai_user.h"
#include "xauserh.h"
#include "adaclogh.h"
#include "mm_al.h"

// SyncML
#include "sa_mainh.h"

#define SERIAL_1    1
// previous includes needed for Simulation of Carkit GPS

#ifdef BT_AVAILABLE
#undef BT_AVAILABLE
#endif
#define BT_AVAILABLE 0

#ifdef MMI_BROWSER_AVAILABLE
#undef MMI_BROWSER_AVAILABLE
#endif
#define MMI_BROWSER_AVAILABLE 0



#if MMI_VOICEDIAL_AVAILABLE
    #include "procid.h"
    #include "wrecog.h"
    WordID GetVoiceDialId( void );
    #define VD_PID MMI_PID
#endif

#include "browser_sim.h" 
 
#include "btoothf.h"

#define DBG_DEBUGGING_ACTIVE OFF // TODO: set to OFF before put
#include "debug.h"

extern unsigned char tempPlmn[5];

/* header included by niharika */
#include "sms_res.h"
#include "laihlib.h"
#include "mm_al.h"
#include "mmalmm.h"
#include "choosenet.h"
#include "AlarmSetDlgh.h"

#include "fsuiinfoh.h"
#include "mmi_msg.h"
#include "was.h"

#include "simjava.h"
#include "simjappworldclock.h"
#include "simjappstartupassistant.h"


#if MMI_MMS_AVAILABLE
// mms debug dialog header
extern "C"
{
    #include "winmms.h"
}
#endif //#if MMI_MMS_AVAILABLE

#include "accdefs.h"
#include "sp_cmdlisth.h"
#include "sp_cmdlisth.h"

}

// shaped ui
extern int GobalMainMenuOpened;


//defines for MPM connection
extern int MPMConnectState;
extern int WireSimuState;


//modified by duchun for SHAPED_UI
//#ifdef SHAPED_UI
#ifdef USE_SHAPED_UI
extern void RunTimeHeapInfo();
#endif
extern bool featureIsAvailable( void );


#define CARKIT_GPS_LOGO_TIMER       0x1001
#define CARKIT_BTN_LONG_PRESS_TIMER  0x1002

//Added by Du Chun, execute SMTK phone commands in one function!
extern void ExecuteSMTKPhoneCommand(E_MMI_COMMANDS E_MMI_CMD);


T_MMI_CMD_Entry array_SMTK_MMI_CMD_Entries[]=
{
    //Command Name,                                    Command Tooltip,
    //Image closed,                                    Image opened,
    //Command Enum,                                    additional check command pointer

//NetWork Commands//
//The following commmands are belong to the NetWork Commands group.
//NetWork Commands Group
    {IDS_MMI_CMD_NETWORK_COMMANDS,                    IDS_MMI_CMD_NETWORK_COMMANDS_TOOLTIP, 
     IMG_FOLDER_ORANGE_CLOSE ,                         IMG_FOLDER_ORANGE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},
//Terminating Call
    {IDS_MMI_CMD_MSM_MOBILE_TERMINATING_CALL,          IDS_MMI_CMD_MSM_MOBILE_TERMINATING_CALL_TOOLTIP,
     IMG_RECEIVING_CALL,                                   IMG_RECEIVING_CALL, 
     E_MMI_CMD_MSM_Mobile_Terminating_Call,            featureIsAvailable},
//Disconnect call by net
    {IDS_MMI_CMD_MSM_DISCONNECT_CALL_BY_NET,           IDS_MMI_CMD_MSM_DISCONNECT_CALL_BY_NET_TOOLTIP, 
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_MSM_MSM_Disconnect_Call_by_Net,         featureIsAvailable},

// MM Services
    {IDS_MMI_CMD_MM_FULL_SERVICE,                      IDS_MMI_CMD_MM_FULL_SERVICE_TOOLTIP, 
     IMG_FULL_SERVICE,                                   IMG_FULL_SERVICE, 
     E_MMI_CMD_MM_Full_Service,                        NULL},
//MM No Service
    {IDS_MMI_CMD_MM_NO_SERVICE,                        IDS_MMI_CMD_MM_NO_SERVICE_TOOLTIP,
     IMG_NO_SERVICE,                                   IMG_NO_SERVICE, 
     E_MMI_CMD_MM_No_Service,                          NULL},
   
// SMS
   {IDS_MMI_CMD_SMS_INCOMMING_SMS,                    IDS_MMI_CMD_SMS_INCOMMING_SMS_TOOLTIP,
     IMG_SHORTMESSAGES,                                   IMG_SHORTMESSAGES,
     E_MMI_CMD_SMS_Incoming_Short_Message,             NULL},

// EMS //

     {IDS_MMI_CMD_EMS_BUILD_INCOMMING_SMS,              IDS_MMI_CMD_EMS_BUILD_INCOMMING_SMS_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_EMS_Build_Incoming_Short_Message,       NULL},

    {IDS_MMI_CMD_EMS_SEND_NEXT_SEGMENT,                IDS_MMI_CMD_EMS_SEND_NEXT_SEGMENT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_EMS_Send_Next_Segment_of_EMS_Message,   NULL},

// Choose Network
     {IDS_MMI_CMD_CHOOSE_NETWORK,                       IDS_MMI_CMD_CHOOSE_NETWORK_TOOLTIP,
     IMG_CHOOSE_NETWORK,                                 IMG_CHOOSE_NETWORK,
     E_MMI_CMD_Choose_Network,                         NULL},

// Limited Service MM

    {IDS_MMI_CMD_MM_LIMITED_SERVICE,                   IDS_MMI_CMD_MM_LIMITED_SERVICE_TOOLTIP, 
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED, 
     E_MMI_CMD_NoCommand,                            NULL},
     //E_MMI_CMD_MM_Limited_Service,                     NULL},

// SMS commands
    {IDS_MMI_CMD_SMS_IMMEDIATE_MESSAGE,                IDS_MMI_CMD_SMS_IMMEDIATE_MESSAGE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_NoCommand,                            NULL},
     //E_MMI_CMD_SMS_Immediate_Message,                  NULL},
    
    {IDS_MMI_CMD_SMS_SATUS_REPORT,                     IDS_MMI_CMD_SMS_SATUS_REPORT_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_NoCommand,                            NULL},
     //E_MMI_CMD_SMS_Status_Report,                      NULL},

    {IDS_MMI_CMD_SMS_TOGGLE_VOICE_MESSAGE,             IDS_MMI_CMD_SMS_TOGGLE_VOICE_MESSAGE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_NoCommand,                            NULL},
     //E_MMI_CMD_SMS_Toggle_Voice_Message,               NULL},

// MSM

#if 0
     {IDS_MMI_CMD_MSM_INTERRUPT_CALL_REEST_PROC,        IDS_MMI_CMD_MSM_INTERRUPT_CALL_REEST_PROC_TOOLTIP, 
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_NoCommand,                            NULL},
     //E_MMI_CMD_MSM_MSM_Interrupt_Call_Reest_Proc,      featureIsAvailable},

    {IDS_MMI_CMD_MSM_INSERT_MOBILE_IN_CARKIT_HIGH,     IDS_MMI_CMD_MSM_INSERT_MOBILE_IN_CARKIT_HIGH_TOOLTIP, 
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_NoCommand,                            NULL},
     //E_MMI_CMD_MSM_MSM_Insert_Mobile_in_Carkit_high,   featureIsAvailable},

    {IDS_MMI_CMD_MSM_REMOVE_MOBILE_FROM_CARKIT_HIGH,   IDS_MMI_CMD_MSM_REMOVE_MOBILE_FROM_CARKIT_HIGH_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_NoCommand,                            NULL},
     //E_MMI_CMD_MSM_MSM_Remove_Mobile_from_Carkit_high, featureIsAvailable},
#endif


// MOC //
    {IDS_MMI_CMD_MOC_DISCONNECT_PROGRESS_IS_OFF_ON,    IDS_MMI_CMD_MOC_DISCONNECT_PROGRESS_IS_OFF_ON_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_NoCommand,                            NULL},
     //E_MMI_CMD_MSM_MOC_disconnect_progress_is_off_on,  msm_sim_disc_progress_set_is_pos},

     {IDS_MMI_CMD_MOC_RELEASE_WITH_BUSSY_IS_OFF_ON,     IDS_MMI_CMD_MOC_RELEASE_WITH_BUSSY_IS_OFF_ON_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,     
     E_MMI_CMD_NoCommand,                            NULL},
     //E_MMI_CMD_MSM_MOC_release_with_busy_is_off_on,    msm_sim_MOC_busy_set_is_pos},

    {IDS_MMI_CMD_MOC_CCBS_IS_SUPPORTED_OFF,            IDS_MMI_CMD_MOC_CCBS_IS_SUPPORTED_OFF_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_NoCommand,                            NULL},
     //E_MMI_CMD_MSM_MOC_CCBS_is_supported_off,          msm_sim_CCBS_clear_is_pos},

// HZ //
    {IDS_MMI_CMD_HZ_HOMEZONE_OFF_ON,                   IDS_MMI_CMD_HZ_HOMEZONE_OFF_ON_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_NoCommand,                            NULL},
     //E_MMI_CMD_MSM_HZ_Homezone_off_on,                 msm_sim_HZ_set_is_pos},
//End of NetWork Commands Group


// Phone Commands // 
//The following commmands are belong to the Phone Commands group.
//Phone Commands Group
    {IDS_MMI_CMD_PHONE_COMMANDS,                        IDS_MMI_CMD_PHONE_COMMANDS_TOOLTIP, 
     IMG_FOLDER_ORANGE_CLOSE ,                              IMG_FOLDER_ORANGE_OPEN,
     E_MMI_CMD_NoCommand,                              NULL},
// Start Java Application //
    {IDS_MMI_CMD_START_JAVA_APPLICATION,               IDS_MMI_CMD_START_JAVA_APPLICATION_TOOLTIP,
     IMG_START_JAVA_APP,                                 IMG_START_JAVA_APP,
     E_MMI_CMD_Start_Java_Application,                 NULL},

// MPM Connection  //
    {IDS_MMI_CMD_MPM_CONNECTION,                       IDS_MMI_CMD_MPM_CONNECTION_TOOLTIP,
     IMG_WINDOW_GREEN,                                 IMG_WINDOW_GREEN,
     E_MMI_CMD_MPM_connection,                        NULL},

// Show Run Time Heap Info //
    {IDS_MMI_CMD_SHOW_RUN_TIME_HEAP_INFO,               IDS_MMI_CMD_SHOW_RUN_TIME_HEAP_INFO_TOOLTIP,
     IMG_SHOW_RUN_TIME_JAVA,                                 IMG_SHOW_RUN_TIME_JAVA,
     E_MMI_CMD_Show_Run_Time_Heap_Info,                 NULL},

// POWER //    
    {IDS_MMI_CMD_BEGIN_LOW_POWER,                      IDS_MMI_CMD_BEGIN_LOW_POWER_TOOLTIP,
     IMG_BEGIN_LOW_POWER,                                    IMG_BEGIN_LOW_POWER,
     E_MMI_CMD_Power_Begin_Low_Power,                  NULL},

    {IDS_MMI_CMD_END_LOW_POWER,                        IDS_MMI_CMD_END_LOW_POWER_TOOLTIP,
     IMG_END_LOW_POWER,                                   IMG_END_LOW_POWER,
     E_MMI_CMD_Power_End_Low_Power,                    NULL},
    
// Change microedition.local //
#if 0
    {IDS_MMI_CHANGE_MICROEDITION_LOCAL,                  IDS_MMI_CHANGE_MICROEDITION_LOCAL_TOOLTIP,
     IMG_FOLDER_BLUE_CLOSE,                            IMG_FOLDER_BLUE_OPEN,
     E_MMI_CMD_Change_microedition_local,                NULL},
#endif

// Filesystem //
/*    {IDS_MMI_CMD_SEND_FREE_SPACE,                      IDS_MMI_CMD_SEND_FREE_SPACE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Send_Free_Space,                        NULL},
     
    {IDS_MMI_CMD_SEND_NO_FREE_SPACE,                   IDS_MMI_CMD_SEND_NO_FREE_SPACE_TOOLTIP,
     IMG_WINDOW_RED,                                   IMG_WINDOW_RED,
     E_MMI_CMD_Send_No_Free_Space,                     NULL},*/
#ifdef LOCALIZATION_SUPPORT
    {IDS_MMI_CMD_CHANGE_UI_LANGUAGE,                   IDS_MMI_CMD_CHANGE_UI_LANGUAGE_TOOLTIP,
     IMG_WINDOW_GREEN,                                 IMG_WINDOW_GREEN,
     E_MMI_CMD_Change_UI_language,                        NULL},
#endif

// Switch Off  //
    {IDS_MMI_CMD_SWITCH_OFF,                           IDS_MMI_CMD_SWITCH_OFF_TOOLTIP,
     IMG_SWITCHOFF,                                    IMG_SWITCHOFF,
     E_MMI_CMD_Switch_Off,                             NULL},
//End of Phone Commands Group  
};

#define SIZEOFSMTKMPCMD sizeof(array_SMTK_MMI_CMD_Entries)/sizeof(struct_T_MMI_CMD_Entry)

int GetSizeofSMTKMPCmd()
{
    return SIZEOFSMTKMPCMD;
}


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCmdList


///////////////////////////////////////////////////////////////////////////////

BEGIN_MESSAGE_MAP(CMMICmdList, CToolTipListCtrl)
    ON_WM_CREATE()
//  ON_NOTIFY_REFLECT(LVN_GETINFOTIP, OnLvnGetInfoTip)
ON_WM_KEYDOWN()
END_MESSAGE_MAP()

CMMICmdList::CMMICmdList()
{
    m_ToolTipBKColor   = RGB(195, 204, 230);
    m_ToolTipTextColor = RGB(0, 0, 0);
    m_ToolTipDelayTime = 30000;
    m_bAscending       = TRUE;
    m_itemCount        = 0;
    m_itemNow         = 0;
}

/**                                                                       
 *  Destructor of  CMMICmdList. 
 *  It cleans up the generated objects  
 */                                                                        
CMMICmdList::~CMMICmdList()
{
    CMMICmdListItem *pcItem = NULL;
    
    for (int index = 0; index < m_cListItemArray.GetSize(); index++)
    {
        pcItem = m_cListItemArray.GetAt(index);
        
        if (pcItem != NULL)
            delete pcItem;
    }
}

int CMMICmdList::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
    if (CToolTipListCtrl::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    // Enable tooltips
    EnableToolTips(TRUE);

#if INIT32COLOR_ICON // not defined, needs to change future
    // Create empty image list...
    HIMAGELIST hImageList = ImageList_Create(16, 16, ILC_COLOR32 | ILC_MASK, 0, 5);
    
    // Load 256 colour bitmap containing the images...
    HBITMAP hBitmap(HBITMAP(LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_FOLDER), IMAGE_BITMAP,
        0, 0,
        LR_CREATEDIBSECTION)));
    _ASSERTE(hBitmap);
    if (hBitmap)
    {
        // Plonk bitmap into image list...
        ImageList_AddMasked(hImageList, hBitmap, RGB(255, 255, 255));       
        // Destroy bitmap
        DeleteObject(hBitmap);
    }
    
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_RECEIVING_CALL)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_FUL_SERVICE)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_NO_SERVICE)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_SHORTMESSAGES)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_CHOOSE_NETWORK)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_START_JAVA_APP)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_SHOW_RUN_TIME_JAVA)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_BEGIN_LOW_POWER)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_END_LOW_POWER)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_SWITCHOFF)));  

    m_image.m_hImageList = hImageList;  
    SetImageList(&m_image, LVSIL_SMALL);
#endif

    return 0;
}



/**                                                                       
 *  Helper function to create a new MMICommandListItem. 
 *  The funtion is called during CMMICmdList::InitListItems function. 
 *  It creates new CMMICmdListItem objects with appropriate values.
 *  All new created objects  will be stored in CMMICmdList::m_cListItemArray 
 *  to clean up the objects during desruction of CMMICmdList class.
 *
 *  @param   cmd_entry: \ref struct_T_MMI_CMD_Entry  
 *  @param   hParent: Parent item Handle to set parent item in InsertItem() function.
 *                    default value is hParent=TVI_ROOT.
 *  
 *  @return  LV_ITEM: Handle of the new item.
 */                                                                        
UINT CMMICmdList::AddMMICommandListItem(T_MMI_CMD_Entry   cmd_entry,
                                                 UINT  Column)
{
    UINT           iActual;
    CMMICmdListItem *pcItem = NULL; 
    LV_ITEM         ListItem;
#ifndef LOCALIZATION_SUPPORT
    CString cStrCmdName, cStrCmdToolTip;
    cStrCmdName   .LoadString(cmd_entry.ulCmdName);
    cStrCmdToolTip.LoadString(cmd_entry.ulCmdToolTip);
#else
    CLocalizationString cStrCmdName, cStrCmdToolTip;
    cStrCmdName=CLocalizationString(cmd_entry.ulCmdName);
    cStrCmdToolTip=CLocalizationString(cmd_entry.ulCmdToolTip);
#endif
    // Is there an additional check command?
    pcItem = new  CMMICmdListItem(cStrCmdName, 
                                        cStrCmdToolTip, 
                                        cmd_entry.uiImage, 
                                        cmd_entry.E_MMI_CMD);

    ListItem.iImage = cmd_entry.uiImage;
    ListItem.pszText = cStrCmdName.GetBuffer(cStrCmdName.GetLength());
    ListItem.mask = LVIF_IMAGE|LVIF_TEXT|LVIF_STATE|LVIF_PARAM;
    ListItem.lParam = (LPARAM)pcItem;
    ListItem.iItem = m_itemCount;
    ListItem.state = 0;
    ListItem.iSubItem = 0;

    // insert a new item in a List view control.
    m_itemCount++;
    iActual =   InsertItem(&ListItem);
    SetItemToolTipText(iActual,1,cStrCmdName);

   // Add objects in an array to clean up the objects during  
   // destruction of CMMICmdList class.
   m_cListItemArray.Add(pcItem);

     return iActual;
}


/**                                                                       
 *  This function inits the MMI Commands in to list items. All entries of the array \ref list_SMTK_MMI_CMD_Enties   
 *  will be read and processed. The function will be sort the array elements after item image value  
 */                       
extern const int SizeOfMMICmdEntry;

void CMMICmdList::InitListItems()
{
    // Enable tooltips
    EnableToolTips(TRUE);
#if INIT32COLOR_ICON // not defined, needs to change future

    // Create empty image list...
    HIMAGELIST hImageList = ImageList_Create(16, 16, ILC_COLOR32 | ILC_MASK, 0, 5);
    
    // Load 256 colour bitmap containing the images...
    HBITMAP hBitmap(HBITMAP(LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_FOLDER), IMAGE_BITMAP,
        0, 0,
        LR_CREATEDIBSECTION)));
    _ASSERTE(hBitmap);
    if (hBitmap)
    {
        // Plonk bitmap into image list...
        ImageList_AddMasked(hImageList, hBitmap, RGB(255, 255, 255));       
        // Destroy bitmap
        DeleteObject(hBitmap);
    }
    
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_RECEIVING_CALL)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_FUL_SERVICE)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_NO_SERVICE)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_SHORTMESSAGES)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_CHOOSE_NETWORK)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_START_JAVA_APP)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_SHOW_RUN_TIME_JAVA)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_BEGIN_LOW_POWER)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_END_LOW_POWER)));
    ImageList_AddIcon(hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_SWITCHOFF)));
    m_image.m_hImageList = hImageList;  
    SetImageList(&m_image, LVSIL_SMALL);
#endif
    
    //LV_ITEM hRoot = TVI_ROOT;
    int CommandAmount = sizeof(array_SMTK_MMI_CMD_Entries)/sizeof(struct_T_MMI_CMD_Entry);
    int index = 0;

    for(index = 0; index < CommandAmount; index++ )
    {
        // Is the item a root or has not child comands? if yes use return value 'hRoot'
        AddMMICommandListItem( array_SMTK_MMI_CMD_Entries[ index ]);
    }

}

BOOL CMMICmdList::AppendItemGroup(UINT itemCount)
{
    UINT CommandAmount = sizeof(array_SMTK_MMI_CMD_Entries)/sizeof(struct_T_MMI_CMD_Entry);

    if (itemCount > CommandAmount)
    {
        itemCount = CommandAmount;
    }
    UINT index = m_itemNow;

    for(index = m_itemNow; index < itemCount; index++ )
    {

        
        if( (array_SMTK_MMI_CMD_Entries[index].ulCmdName == IDS_MMI_CMD_MPM_CONNECTION) || 
            (array_SMTK_MMI_CMD_Entries[index].ulCmdName == IDS_MMI_CMD_MPM_DISCONNECTION) ){
            m_indexMPMConnection = index;
        } 
            
        
        // Is the item a root or has not child comands? if yes use return value 'hRoot'
        AddMMICommandListItem( array_SMTK_MMI_CMD_Entries[ index ]);
    }

    m_itemNow = itemCount;
    return TRUE;
}



/**                                                                       
 *  Provides a Windows procedure (WindowProc) for a CWnd object.  
 *  We use Windows procedure to handle WM_LBUTTONDOWN, WM_LBUTTONUP, WM_LBUTTONDBLCLK
 *  WM_TIMER messages. Some MMI commands can only called with Windows procedure.
 *
 *  @param   message: Specifies the Windows message to be processed.  
 *
 *  @param   wParam:  Provides additional information 
 *                    used in processing the message. The parameter value 
 *                    depends on the message.  
 *
 *  @param   lParam:  Provides additional information 
 *                    used in processing the message. The parameter value 
 *                    depends on the message.  
 *  
 *  @return  LRESULT: The return value depends on the 
 *                    message.
 */                  

LRESULT CMMICmdList::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
    // Some variables used for sending ADAC-Logo Bitmap
    char * pBuffer;
    static int  nPacketCount;      // Counter for packets to send
    const int   nPacketSize = 50;  // Number of bytes for one packet
    static int  nNofPackets;       // Number of packtes to send
    static int  nCommand;          // Flag to send command or data
    static char szSaveBuf[256];    // Buffer with original command line
    static char AdacLogoHexAsciiBuffer[2*ADAC_BINARY_BITMAP_SIZE+1];
    LVFINDINFO find;
    UINT nFlags;

    //PID tmp = NULL;
    // --------------------------------------------------------------------------
    switch (message)
    {

        case WM_LBUTTONDOWN:
            break;
        case WM_LBUTTONUP:
            break;
        case WM_LBUTTONDBLCLK:
        {
            INT  hItem  = FindItem(& find);
             int xPos = LOWORD(lParam);  // horizontal position of cursor 
            int yPos = HIWORD(lParam);  // vertical position of cursor 
            CPoint point(xPos,yPos);
            
             hItem = HitTest(point, &nFlags);

            if ((hItem != -1 ))
            {
                pBuffer = (char*) XRC_GetSerialRxBuffer(SERIAL_1);
                CMMICmdListItem *pcItem = NULL;
    
                // Get value associated with the item and cast to CMMICmdListItem pointer.
                pcItem = (CMMICmdListItem*) GetItemData(hItem);
                 
                  //GetItem(pcItem);
                if (NULL != pcItem)
                {
                    E_MMI_COMMANDS E_MMI_CMD = E_MMI_CMD_NoCommand;

                    // Get the appropriate MMI command enum.
                    E_MMI_CMD = pcItem->GetEnumMMICommands();

//Added by Du Chun, execute SMTK phone commands in one function!
                    ExecuteSMTKPhoneCommand(E_MMI_CMD);

                    
                    if (E_MMI_CMD == E_MMI_CMD_MPM_connection)
                    {
                        ChangeItemMPMConnection(hItem);                    
                    }
                    

                    // Make PhoneScreen as active window
                    GET_APP()->GetMMIDispWindow()->MakeActiveWnd();
                    return 0;
                }
            }
        }
    }// End Switch

    return CToolTipListCtrl::WindowProc(message, wParam, lParam);
}



void CMMICmdList::ChangeItemMPMConnection(int hItem)
{
    if ( WireSimuState == 1 ){       //To avoid run two wire simulation applications at same time;
        return;         
    }

    if( MPMConnectState == 1 ){ 
        array_SMTK_MMI_CMD_Entries[m_indexMPMConnection].ulCmdName      = IDS_MMI_CMD_MPM_DISCONNECTION ;    
        array_SMTK_MMI_CMD_Entries[m_indexMPMConnection].ulCmdToolTip   = IDS_MMI_CMD_MPM_DISCONNECTION_TOOLTIP ;
        CString temp;
        temp.LoadString(IDS_MMI_CMD_MPM_DISCONNECTION);
        this->SetItemText(hItem, 0, temp);
        //this->SetItemText(hItem, 0, "MPM Disconnection");
        this->Invalidate();
    }else{
        array_SMTK_MMI_CMD_Entries[m_indexMPMConnection].ulCmdName      = IDS_MMI_CMD_MPM_CONNECTION ;    
        array_SMTK_MMI_CMD_Entries[m_indexMPMConnection].ulCmdToolTip   = IDS_MMI_CMD_MPM_CONNECTION_TOOLTIP ;
        CString temp;
        temp.LoadString(IDS_MMI_CMD_MPM_CONNECTION);
        this->SetItemText(hItem, 0, temp);
        //this->SetItemText(hItem, 0, "MPM Connection");
        this->Invalidate();
    }
}






IMPLEMENT_DYNAMIC(CMMICmdListItem, CObject)
/**                                                                       
 *  Constructor of CMMICmdListItem. Is sets some member variables with values 
 *  which are given during creation of a new object.
 *  Use this constructor to create new CMMICmdListItem object.  
 *    
 *  @param   cStrCmdName: name of mmi command.  
 *  @param   cStrCmdToolTip: tooltip info of mmi command  
 *  @param   uiImage: imagenumber     
 *  @param   E_MMI_CMD: \ref E_MMI_COMMANDS  
 */                                                                        
CMMICmdListItem::CMMICmdListItem(CString           cStrCmdName,   
                                         CString           cStrCmdToolTip,
                                         UINT              uiImage,
                                         E_MMI_COMMANDS    E_MMI_CMD)
{
 
   m_cmd_name         = cStrCmdName;
   m_cmd_ToolTip      = cStrCmdToolTip;
   m_uiImage          = uiImage;
   m_E_MMI_Commands   = E_MMI_CMD;
    
}


/**                                                                       
 *  Destructor of CMMICmdListItem class.      
 */                                                                        
CMMICmdListItem::~CMMICmdListItem()
{
}

/**                                                                       
 *  Returns mmi command name.   
 *  @return  CString: mmi command name.
 */                                                                        
CString CMMICmdListItem::GetLabel() const 
{
    return m_cmd_name;    
}

/**                                                                       
 *  Returns mmi command tooltip info.      
 *  @return  CString: tooltip info.
 */                                                                        
CString CMMICmdListItem::GetToolTipText() const
{
    return m_cmd_ToolTip;    
}

/**                                                                       
 *  Returns mmi commands appropiate \ref E_MMI_COMMANDS         
 *  @return  E_MMI_COMMANDS: \ref E_MMI_COMMANDS
 */                                                                        
E_MMI_COMMANDS CMMICmdListItem::GetEnumMMICommands() const
{
    return m_E_MMI_Commands;
}

/**                                                                       
 *  Returns image value. Image value means group affiliation.       
 *  @return  UINT: gruop affiliation.
 */                                                                        
UINT CMMICmdListItem::GetImage() const
{
    return m_uiImage;
}

void CMMICmdList::ExecuteMMICommands(E_MMI_COMMANDS E_MMI_CMD)
{

}

/**                                                                       
 *  The function close the main menu window when the 
 *  Tab key pressed 
 */             
void CMMICmdList::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    switch (nChar)
    {
        case VK_TAB:
        {
            if (GobalMainMenuOpened == TRUE)            
            {
                CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;
                pFrame->m_MainMenuDlg.DestroyWindow();
                GobalMainMenuOpened = FALSE;
            }
            return;
        }
        default:
             ;
    }

    CToolTipListCtrl::OnKeyDown(nChar, nRepCnt, nFlags);
}
