
/** @file

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

This software is protected by the inclusion of the above copyright
notice. This software may not be provided or otherwise made available
to, or used by, any other person. No title to or ownership of the
software is  hereby  transferred.
The information contained in this document is considered the
CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
not be disclosed or discussed with anyone who is not employed by
Siemens AG, unless the individual / company
(i) has an express need to know such information, and
(ii) disclosure of information is subject to the terms of a duly
executed Confidentiality and Non-Disclosure Agreement between
Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR         Murat Korkmaz

.FILENAME       appimopi.h

.TODO

.SHORT_DESCR    Implementation of MOPI interface functions .

.SW_COMPONENT   PC-SIMU PlugIn

.SW_TYPE

.CHANGE_CONTROL

Version   Date       Changed by          Reason of change<br>
--------------------------------------------------------------------------------<br>
01.00.00  2004-01-14 Murat Korkmaz       Initial Version.<br>
01.00.01  2004-01-27 Walter Stroell      enable PMOPI function calls
01.01.00  2004-02-09 Murat Korkmaz       preprocessor JAVA_SDK added
01.02.00  2004-03-18 Norbert Barisits    first working version
01.02.01  2004-04-21 Walter Stroell      implementation update
01.02.02  2004-06-02 Walter Stroell      fix at command message log clear
01.02.03  2004-06-21 Norbert Barisits    eMemInfo added
------------------------------------------------------------------------------*/
#ifndef JAVA_SDK
/* -----------------------------------------------------------------------------
INCLUDES
------------------------------------------------------------------------------*/
#include "appimopi.h"
#include "mopi_pctrl.h"
#include "mopi_timer.h"
#include "mopi_sync.h"
#include "mopi_msg.h"
#include "mopi_mem.h"
#include "mopiext.h"

#if ( MOBSIM > 0 ) && ( UNITEST == 0 )
extern "C"
{
    extern T_MOPI_Heap              imopiPermanentPool;
    extern T_MOPI_Heap              imopiSystemPool;
    extern T_IMOPI_MemObject       *pImopiFirstMO;
    extern T_IMOPI_MemInfo          imopiMemInfo;
    extern T_IMOPI_MsgResources     imopiMsgHndlResources;
    extern T_IMOPI_QueueResources   imopiQueueResources;
    extern T_IMOPI_TimerResources   imopiTimerResources;
    extern T_IMOPI_SyncResources    imopiSyncResources;
    extern T_IMOPI_MsgLog           imopiMsgLog;

    void OS_EnterCriticalSection( void );
    void OS_LeaveCriticalSection( void );
}
#endif


CAppiMOPI::CAppiMOPI()
{
}


CAppiMOPI::~CAppiMOPI(void)
{
}


//! passes the requested information to the caller
/*!

\ingroup    PluginInterface

\return     requested info

\pre        MOPI initialisation finished.
*/
void* CAppiMOPI::GetInfo( eIAppIfMOPIRequestType reqType )
{
    switch( reqType )
    {
    case eVersionInfo:
        return (void*)MOPI_VersionGet();
    case eNonPermSysHeap:
        return (void*)&imopiSystemPool;
    case ePermSysHeap:
        return (void*)&imopiPermanentPool;
    case eFirstMemObject:
        return (void*)pImopiFirstMO;
    case eMemInfo:
        return (void*)&imopiMemInfo;
    case eTaskProcResources:
        return (void*)&imopiResourceTable;
    case eQueueResources:
        return (void*)&imopiQueueResources;
    case eMsgHndlResources:
        return (void*)&imopiMsgHndlResources;
    case eTimerResources:
        return (void*)&imopiTimerResources;
    case eSyncResources:
        return (void*)&imopiSyncResources;
    case eMsgLog:
        return (void*)&imopiMsgLog;
    }
    return 0;
}

extern "C" void CAppiMOPI_PostMessageId( UINT32 fParam )
{
    MOPI_PostMessageId( ((T_Cmd_PostMsgId*)fParam)->cepTarget,
                        ((T_Cmd_PostMsgId*)fParam)->msgId );
}

extern "C" void CAppiMOPI_PostMessageInt( UINT32 fParam )
{
    MOPI_PostMessageUINT32( ((T_Cmd_PostMsgInt*)fParam)->cepTarget,
                            ((T_Cmd_PostMsgInt*)fParam)->msgId,
                            ((T_Cmd_PostMsgInt*)fParam)->payload );
}

extern "C" void CAppiMOPI_PostMessage( UINT32 fParam )
{
T_MOPI_Message msg;
char          *pPayload;

    pPayload = (char*)MOPI_CreateMessage( &msg,
                                         ((T_Cmd_PostMsg*)fParam)->cepTarget,
                                         ((T_Cmd_PostMsg*)fParam)->msgId,
                                         ((T_Cmd_PostMsg*)fParam)->payloadLength );

    (void)memcpy( pPayload,
                  ((T_Cmd_PostMsg*)fParam)->payload,
                  ((T_Cmd_PostMsg*)fParam)->payloadLength );

    MOPI_PostMessage( &msg );
}

extern "C" void CAppiMOPI_ClrMsgLog( UINT32 fParam )
{
    IMOPI_MsgLogClear();
}

eIAppIfMOPIResponseType CAppiMOPI::Command( eIAppIfMOPICommandType cmd, void *pData )
{
    switch( cmd )
    {
    case eMsgLogClear:
        MOPI_ExecuteFunction( MOPI_CEPID_UNDEFINED, CAppiMOPI_ClrMsgLog, 0 );
        return eOk;

    case ePostMsgId:
        MOPI_ExecuteFunction( ((T_Cmd_PostMsgId*)pData)->cepSource,
                              CAppiMOPI_PostMessageId,
                              (UINT32)pData);
        return eOk;

    case ePostMsgInt:
        MOPI_ExecuteFunction( ((T_Cmd_PostMsgInt*)pData)->cepSource,
                              CAppiMOPI_PostMessageInt,
                              (UINT32)pData);
        return eOk;

    case ePostMsg:
	    MOPI_ExecuteFunction( ((T_Cmd_PostMsg*)pData)->cepSource,
	                          CAppiMOPI_PostMessage,
	                          (UINT32)pData);
	    return eOk;

	default:
		return eNotImpl;
	}
}

#endif //JAVA_SDK
/* -----------------------------------------------------------------------------
END OF FILE  appimopi.h
------------------------------------------------------------------------------*/

