/** @file

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

This software is protected by the inclusion of the above copyright
notice. This software may not be provided or otherwise made available
to, or used by, any other person. No title to or ownership of the
software is  hereby  transferred.
The information contained in this document is considered the
CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
not be disclosed or discussed with anyone who is not employed by
Siemens AG, unless the individual / company
(i) has an express need to know such information, and
(ii) disclosure of information is subject to the terms of a duly
executed Confidentiality and Non-Disclosure Agreement between
Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR         Andreas Emmer

.FILENAME       appimlf.cpp

.DATE           %date_created: 2005-04-18

.SHORT_DESCR    Implementation of MOPI interface functions.

.SW_COMPONENT   PC-SIMU PlugIn

.SW_TYPE

.CHANGE_CONTROL

Version   Date        Changed by
Reason of change<br>
--------------------------------------------------------------------------------<br>
02.00.00  2004-11-25  Andreas Emmer initial version
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
INCLUDES
------------------------------------------------------------------------------*/
#include "global.h"
#include "afxwin.h"
//#include "keypad.h"
//#include "kbddrv.h"
//#include "winmain.h"

// Ring buffer header
//#include "..\..\private_pc\ringBuffer.h"
//#include "..\..\private_pc\dispwndh.h"
#include "..\..\private_pc\pluginmanager.h"
//#include "mmi.h"    // to get the g_MMIMode
#include "..\..\private_pc\appimlf.h"
//#include "..\..\private_pc\mmidisph.h"
//#include "..\..\private_pc\Iappinterfacemopi.h"
//#include "..\..\private_pc\mainfrmh.h"
//#include "..\..\private_pc\mmidisph.h"
// Ring buffer header
#include "mopi.h"
#include "display.h"
#include "dpls0.h"




#ifndef JAVA_SDK // JAVA_SDK

  //################################################################################
  //## externals ###################################################################
  //################################################################################
  extern int mg_ShowErrorMessages;
  extern int mg_ShowInfoMessages;
  extern int mg_nPrintDLogfile;
  extern int mg_nPrintDScreenOutput;

  extern "C"
  {
    void Keypad_KeyDown(unsigned char keyCode);
    void Keypad_KeyUp(unsigned char keyCode);
    void CSMGotoIdle( void );
    bool CSMIsIdleCSMOnTop(void);
    //void Simu_GetExeInstallPath(char* pExePath,  UINT16 strLen);
    char *CallstackConverter(unsigned long);

    void DevMenu_HeapOvlSetHeapID( unsigned int nSlot, UINT8 nHeapID, UINT32 nAdditionalInfo );
    void EntwFlags_BitSetzen(unsigned int bit_nbr);

    extern T_MOPI_Heap              imopiSystemPool;
  }

  //################################################################################
  //## delivery ####################################################################
  //################################################################################

  #define DISP_LCD_WIDTH    132
  #define DISP_LCD_HEIGHT   176

  typedef struct struct_Disp_Buffer
    {
    UINT16 Width;
    UINT16 Height;
    COLORREF *pPixel;
    } T_Disp_Buffer;



  int *CAppiMLF::Command( MLF_PlugIntoPCSimuCommand cmd, void *pData )
    // executes a command sent by PLUGIN !!!
    //
    {
    switch( cmd )
      {
      case MLF_CMD_PressKey:
        Keypad_KeyDown (((T_Command_KeyCode*)pData)->simulated_keycode);
        return NULL;
      case MLF_CMD_ReleaseKey:
        Keypad_KeyUp (((T_Command_KeyCode*)pData)->simulated_keycode );
        return NULL;
      case MLF_CMD_GotoIdle:
        DevMenu_HeapOvlSetHeapID(0,5,0);//slot, MONITOR_MEM_NONPERM, 0   out of 'mnu0_heapovlh.h'
        CSMGotoIdle();
        return NULL;
      case MLF_CMD_Sleep:
        Sleep( ((T_Command_KeyCode*)pData)->sleep_time );
        return NULL;
      case MLF_CMD_GetDisplayBuffer:
        return (int*)GetDisplayBuffer();
      case MLF_CMD_PhoneIsInIdle:
        return (int*)CSMIsIdleCSMOnTop();// (NULL) 0 not in idle, else in idle
      case MLF_CMD_ShowErrorAndInfoMsgs:
        {
        mg_ShowErrorMessages=1;
        mg_ShowInfoMessages=1;
        break;
        }
      case MLF_CMD_DoNotShowErrorAndInfoMsgs:
        {
        mg_ShowErrorMessages=0;
        mg_ShowInfoMessages=0;
        break;
        }
      case MLF_CMD_GetPrintDLogfileStatus:
        return (int *)GetPrintDLogfileStatus();
      case MLF_CMD_TurnOffDLogfile:
        {
        mg_nPrintDScreenOutput=0;
        mg_nPrintDLogfile=0;
        break;
        }
      case MLF_CMD_ResetPrintDLogfile:
        {
        mg_nPrintDScreenOutput= (((T_Command_KeyCode*)pData)->sleep_time) /10;
        mg_nPrintDLogfile=      (((T_Command_KeyCode*)pData)->sleep_time) ;
        break;
        }
      case MLF_CMD_GetCallstackInfo:
        {
        return (int *)GetCallstackInfo( ((T_Command_KeyCode*)pData)->address );
        }
      case MLF_CMD_ShowNonPerMem:
        {
        DevMenu_HeapOvlSetHeapID(0,5,0);//slot, MONITOR_MEM_NONPERM, 0   out of 'mnu0_heapovlh.h'
        EntwFlags_BitSetzen( 12 );// eDevFlags_HeapViewOverlay           out of 'entwtool.h'
        break;
        }
      }
    return NULL;
    }

  //################################################################################
  //## internals ###################################################################
  //################################################################################

  //################################################################################

  CAppiMLF::CAppiMLF()
    {
    }

  //################################################################################

  CAppiMLF::~CAppiMLF(void)
    {
    }

  //################################################################################

  int* CAppiMLF::GetHeapStartAddress()
    {
    DM_PCB      *pool = (DM_PCB *)imopiSystemPool.pMemObj;
    DM_HEADER   *memory_ptr;

    // Protect against simultaneous access to the memory pool
    TCT_Protect( &(pool->dm_protect) );

    // scan the memory list
    memory_ptr = (DM_HEADER *)pool;//(DM_HEADER *)pool->dm_start_address;
    TCT_Unprotect();

    //
    return (int*)memory_ptr;
    }

  //################################################################################

  int* CAppiMLF::GetHeapStartAddress2()
  {
    DM_PCB      *pool = (DM_PCB *)imopiSystemPool.pMemObj;
    DM_HEADER   *memory_ptr;

    // Protect against simultaneous access to the memory pool
    TCT_Protect( &(pool->dm_protect) );

    // scan the memory list
    memory_ptr = (DM_HEADER *)pool;//(DM_HEADER *)pool->dm_start_address;
    TCT_Unprotect();
    return (int*)memory_ptr;
  }

  //################################################################################
/*

    typedef BOOL  (*pSymCleanup)            (HANDLE hProcess);
    typedef BOOL  (*pSymGetLineFromAddr)    (HANDLE hProcess,DWORD dwAddr,PDWORD pdwDisplacement,PIMAGEHLP_LINE Line);
    typedef DWORD (*pUnDecorateSymbolName)  (LPCSTR DecoratedName,LPSTR UnDecoratedName,DWORD UndecoratedLength,DWORD Flags);
    typedef BOOL  (*pSymGetSymFromAddr)     (HANDLE hProcess,DWORD Address,LPDWORD Displacement,PIMAGEHLP_SYMBOL Symbol);
    typedef BOOL  (*pSymInitialize)         (HANDLE hProcess,LPSTR UserSearchPath,BOOL fInvadeProcess);
    typedef DWORD (*pSymSetOptions)         (DWORD SymOptions);
    typedef DWORD (*pSymGetOptions)         (VOID);

    pSymCleanup              MySymCleanup;
    pSymGetLineFromAddr      MySymGetLineFromAddr;
    pUnDecorateSymbolName    MyUnDecorateSymbolName;
    pSymGetSymFromAddr       MySymGetSymFromAddr;
    pSymInitialize           MySymInitialize;
    pSymSetOptions           MySymSetOptions;
    pSymGetOptions           MySymGetOptions;

    // ############################################################################################

    static HMODULE LoadDbgHelpDLL (void)
      {
      HINSTANCE DbgHelpDLL;
      //load lib
      if ((DbgHelpDLL =             LoadLibrary ("dbghelp.dll")) == NULL)                                                {return NULL;}
      //
      if ((MySymCleanup =           (pSymCleanup)           GetProcAddress (DbgHelpDLL,"SymCleanup")) == NULL)           {FreeLibrary (DbgHelpDLL);return NULL;}
      if ((MySymGetLineFromAddr =   (pSymGetLineFromAddr)   GetProcAddress (DbgHelpDLL,"SymGetLineFromAddr")) == NULL)   {FreeLibrary (DbgHelpDLL);return NULL;}
      if ((MyUnDecorateSymbolName = (pUnDecorateSymbolName) GetProcAddress (DbgHelpDLL,"UnDecorateSymbolName")) == NULL) {FreeLibrary (DbgHelpDLL);return NULL;}
      if ((MySymGetSymFromAddr =    (pSymGetSymFromAddr)    GetProcAddress (DbgHelpDLL,"SymGetSymFromAddr")) == NULL)    {FreeLibrary (DbgHelpDLL);return NULL;}
      if ((MySymInitialize =        (pSymInitialize)        GetProcAddress (DbgHelpDLL,"SymInitialize")) == NULL)        {FreeLibrary (DbgHelpDLL);return NULL;}
      if ((MySymSetOptions =        (pSymSetOptions)        GetProcAddress (DbgHelpDLL,"SymSetOptions")) == NULL)        {FreeLibrary (DbgHelpDLL);return NULL;}
      if ((MySymGetOptions =        (pSymGetOptions)        GetProcAddress (DbgHelpDLL,"SymGetOptions")) == NULL)        {FreeLibrary (DbgHelpDLL);return NULL;}
      return DbgHelpDLL;
      }

  #ifndef MAXNAMELENGTH
    #define MAXNAMELENGTH 128
    #endif
*/
  //################################################################################
  int* CAppiMLF::GetCallstackInfo(unsigned long address_of_callstack)
    {
    char              strCallstackText[500];
    int               i,j;


    COLORREF       *pPixels      = NULL;
    T_Disp_Buffer  *displbuf_ptr = new T_Disp_Buffer;

    // reserve a buffer for the pixels
    pPixels = (COLORREF*)malloc(1000 * sizeof(COLORREF));



//call
    sprintf(strCallstackText,"%s",CallstackConverter(address_of_callstack) );

    // finally convert the text
    for (i=0,j=0;  ( i<(int)strlen(strCallstackText) ) && (i<200)   ; i+=4,j++)
      {
      pPixels[j]= (strCallstackText[i+3]<<24) + (strCallstackText[i+2]<<16) + (strCallstackText[i+1]<<8) + strCallstackText[i];
      }
    pPixels[j]=0;
    pPixels[j+1]=0;

    // setup the return pointer
    displbuf_ptr->Width = 0;
    displbuf_ptr->Height= 0;
    displbuf_ptr->pPixel= (COLORREF*)pPixels;

    // and return
    return (int*)displbuf_ptr;
    }


  //################################################################################

  int* CAppiMLF::GetPrintDLogfileStatus()
    {
    COLORREF       *pPixels      = NULL;
    T_Disp_Buffer  *displbuf_ptr = new T_Disp_Buffer;
    // setup the return pointer
    pPixels = (COLORREF*)malloc(10 * 10 * sizeof(COLORREF));
    displbuf_ptr->Width = (mg_nPrintDScreenOutput *10 +mg_nPrintDLogfile);
    // and return
    return (int*)displbuf_ptr;
    }

  //################################################################################


  int* CAppiMLF::GetDisplayBuffer()
  {
  // Returns the DispBuffer-pointer for saving display screens of mobile,
  // will also refresh the DisplayBuffer for that pointer!!!
  // (no update on the PCSIMU display buffer)
  //
    int x             = 0;
    int y             = 0;
    int height                   = DISP_LCD_HEIGHT;
    int width                    = DISP_LCD_WIDTH;
    COLORREF       rgb_val       = NULL;
    COLORREF       *pPixels      = NULL;
    T_Disp_Buffer  *displbuf_ptr = new T_Disp_Buffer;

    // reserve a buffer for the pixels
    pPixels = (COLORREF*)malloc(height * width * sizeof(COLORREF));

    // setup the return pointer
    displbuf_ptr->Width = width;
    displbuf_ptr->Height= height;
    displbuf_ptr->pPixel= (COLORREF*)pPixels;

    // do not forget to fill the buffer with mobile display content
    for (int y = 0; y < height; y++)
      {
      for (int x = 0; x < width; x++)
        {
        DispGetPixel(E_DISP_MAIN, x, y, &rgb_val);
        // set "BGR" from given "RGB" value:

        *pPixels= (rgb_val & 0x00ff00) | (rgb_val >> 16) | ((rgb_val & 0xff) << 16);

        pPixels++;
        }
      }

    // and return
    return (int*)displbuf_ptr;
    }

  //################################################################################
  //################################################################################
  //################################################################################
  #endif//JAVA_SDK
  /* -----------------------------------------------------------------------------
  END OF FILE  appimlf.cpp
  ------------------------------------------------------------------------------*/

