/*! \file 

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR Murat Korkmaz Bardenheuer Software GmbH

.FILENAME mpswnd.cpp


.CSVERSION 1.1


.VERSION 01.00.00

.DATE 2003-01-07

.SHORT_DESCR:   Docking MobilePhoneScreen window

.SW_COMPONENT:  MMI PC-SIMULATION

.SW_TYPE 

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change

01.00.00 2003-01-07 Murat Korkmaz (BS)
         Initial Version
01.00.01 2003-08-05 Murat Korkmaz (BS)
         m_cMMIDisp.MakeActiveWnd() activated
01.00.02 2004-05-27 Fang Yunchao  (PEK)
         Add UNICODE support
         
*/

#include "smsafxh.h"
#include "simuapph.h"

#include "mpswndh.h"



#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif




BEGIN_MESSAGE_MAP(CMobilePhoneScreenWnd, CDockingWnd)
    //{{AFX_MSG_MAP(CMobilePhoneScreenWnd)
    ON_WM_CREATE()
    ON_WM_SIZE()
    ON_WM_LBUTTONDOWN()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/**                                                                       
 *  Constructor of CMobilePhoneScreenWnd.  
 */  
CMobilePhoneScreenWnd::CMobilePhoneScreenWnd()
{

}

/**                                                                       
 *  Destructor of CMobilePhoneScreenWnd.  
 */
CMobilePhoneScreenWnd::~CMobilePhoneScreenWnd()
{

}


/**                                                                       
 *  The function creates an object of MMIDispWindow.  
 */      
int CMobilePhoneScreenWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
    if (CDockingWnd::OnCreate(lpCreateStruct) == -1)
        return -1;

  //  MMIDispWindow::Register();
    
    // Create an object of MMIDispWindow
    if (!m_cMMIDisp.Create(_T("MMI_DISPLAY_WINDOW"), NULL, AFX_WS_DEFAULT_VIEW, 
                            CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST+10, NULL))
    {
        TRACE0("Failed to create view window\n");
        return -1;
    }
    // Set the object in CMFC_Simulation_App 
    GET_APP()->SetMMIDispWindow(&m_cMMIDisp);
    return 0;
}

/**                                                                       
 *   Funtion to resize also child windows  
 */   
void CMobilePhoneScreenWnd::OnSize(UINT nType, int cx, int cy) 
{
    CDockingWnd::OnSize(nType, cx, cy);

    m_cMMIDisp.SetWindowPos (NULL, -1, -1, cx, cy, SWP_SHOWWINDOW);
    m_cMMIDisp.Invalidate();    
}
/**
 *  Function to let the MMIDispWindow have first crack.
 */
BOOL CMobilePhoneScreenWnd::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
    if (m_cMMIDisp.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
       return TRUE;
    

    return CWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

/**                                                                       
 *  Function to set focus if the user has clicked with the 
 *  leftmousebutton.  
 */                  
void CMobilePhoneScreenWnd::OnLButtonDown(UINT nFlags, CPoint point)
{
    m_cMMIDisp.MakeActiveWnd();
    CDockingWnd::OnLButtonDown(nFlags, point);
}

