/* -----------------------------------------------------------------------------

 Copyright (C) Siemens AG 1994-2001,  ALL RIGHTS RESERVED

 This software is protected by the inclusion of the above copyright
 notice. This software may not be provided or otherwise made available
 to, or used by, any other person. No title to or ownership of the
 software is  hereby  transferred.
 The information contained in this document is considered the
 CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
 not be disclosed or discussed with anyone who is not employed by
 Siemens AG, unless the individual / company
 (i) has an express need to know such information, and
 (ii) disclosure of information is subject to the terms of a duly
 executed Confidentiality and Non-Disclosure Agreement between
 Siemens AG and the individual / company.



.AUTHOR         Zhang Jing (PEK)

.FILENAME       sp_cmdwnd.cpp

.VERSION        01.00.00

.DATE           2004-02-17

.SHORT_DESCR    Main Menu Window for Shaped Ui

.SW_COMPONENT   MMI PC-SIMULATION

.SW_TYPE        

.EXIT_CODES

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
01.00.00 2004-03-25  Zhang Jing (PEK)
         Initial version
01.00.01 2004-06-16   Sun Min(PEK)
         Add new icons for commands tree.
01.00.02 2004-06-24   Fang Yunchao(PEK)
         Modification for SMTK Localization support.
01.00.03 2004-06-28   Fang Yunchao(PEK)
         fix a bug caused by SMTK Localization support.
01.00.04 2004-10-25 Sun Min(PEK)
         Modify function ProgressBarPos() for fixing bug about progress bar
         in main menu.
*/


#include "smsafxh.h"
#include "sp_cmdwndh.h"
#include "sp_vsbarctrlh.h"
#include "sp_cmdwndh.h"
#include "mainfrmh.h"
#include "sms_res.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////

extern char   SkinDataFile[], SkinBitmapFile[];

extern int GlobalFrameTop, GlobalFrameLeft;
extern int GlobalPhoneWidth;
extern int GlobalCmdWndLeft, GlobalCmdWndTop;
int GobalMainMenuOpened = FALSE;
#ifdef JAVA_SDK
extern "C" long GlobalTotalJavaHeapSize;
extern "C" long GlobalLastJavaHeapSize;
#endif

//add by sunmin for enable progress bar, 2004-10-25

extern "C" {
	long getHeapSize();
	long memoryFree();
}


// for modless dialog
BOOL CMainMenuDlg::Create()
{
	//return CBitmapDialog::Create(m_nID, m_pParent);
	return CBitmapDialog::Create();
	
}

// end of modeless Dialog


CMainMenuDlg::CMainMenuDlg(CWnd* pParent /*=NULL*/)
	: CBitmapDialog(CMainMenuDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMainMenuDlg)
	//}}AFX_DATA_INIT
	m_pParent = pParent;
	m_nID = CMainMenuDlg::IDD;
	m_count = 0;
    m_framePosTop = GlobalFrameTop;
    m_framePosLeft = GlobalFrameLeft;
#if 0
	m_wndStatusBar = NULL;
	m_wndToolBar = NULL;
	m_wndVisioBar = NULL;

	m_ImageLarge = NULL;
	m_ImageSmall = NULL;
	 m_hImageList = NULL;
#endif
}


void CMainMenuDlg::DoDataExchange(CDataExchange* pDX)
{
	CBitmapDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMainMenuDlg)
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_HEAP_PROGRESS, m_progress);

}


BEGIN_MESSAGE_MAP(CMainMenuDlg, CBitmapDialog)
	//{{AFX_MSG_MAP(CMainMenuDlg)
	ON_WM_CLOSE()
	ON_WM_CREATE()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	ON_MESSAGE(XTWM_VISIOBAR_NOTIFY, OnVisioBarNotify)
	ON_WM_LBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_LBUTTONUP()
	ON_WM_NCLBUTTONUP()
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
	ON_WM_KEYDOWN()
//	ON_WM_SETFOCUS()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainMenuDlg message handlers

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

BOOL CMainMenuDlg::OnInitDialog() 
{
	CBitmapDialog::OnInitDialog();

	// set the movement of the main menu
	SetClickAnywhereMove (TRUE);

	CRect rcFrame;
	CMainFrame * p_Frame = (CMainFrame*)GET_APP()->m_pMainWnd;

	// get the frame window position
	p_Frame->GetWindowRect(&rcFrame);

	// set the shaped region of the main menu
	CMMIDispWindow * p_Disp = GET_APP()->GetMMIDispWindow();
	SetWindowRgnArea(&p_Disp->m_MainMenuRgn);

	// set window position
	SetWindowPos(
		NULL,                            //The handle of the window 
		GlobalCmdWndLeft + rcFrame.left,    //horizontal
		GlobalCmdWndTop + rcFrame.top,      //virtical
		SHAPED_UI_CMD_WIDTH,               //width
		SHAPED_UI_CMD_HEIGHT,              //height
		SWP_NOZORDER                      //position layer
		);

	// create the visio bar
	m_wndVisioBar.Create(WS_CHILD | WS_VISIBLE, \
		CRect(SHAPED_UI_CMDLIST_LEFT, \
		SHAPED_UI_CMDLIST_TOP, \
		SHAPED_UI_CMDLIST_WIDTH, \
		SHAPED_UI_CMDLIST_HEIGHT), \
		this, IDD_SP_UI_PHONE_BODY);
	
	// create the list control which embedded into the visio bar 
	m_wndListMSM.Create(WS_CHILD|LVS_SHOWSELALWAYS|LVS_REPORT|LVS_SINGLESEL|LVS_NOCOLUMNHEADER, \
		CRect(0,0,0,0), &m_wndVisioBar, 1010);
	m_wndListJAVA.Create(WS_CHILD|LVS_SHOWSELALWAYS|LVS_REPORT|LVS_SINGLESEL|LVS_NOCOLUMNHEADER, \
		CRect(20,20,SHAPED_UI_CMDLIST_WIDTH,300), &m_wndVisioBar, 1010);


	// The bigining of the creation of Visio Bar
	if (m_count == 0) 
	{
		// Create the image lists used by the visio bar.
		m_ImageSmall.Create (16, 16, ILC_COLOR32|ILC_MASK, 0, 5);
		m_ImageLarge.Create (32, 32, ILC_COLOR16|ILC_MASK, 2, 1);
		m_count ++ ;
	}

	// set the container of the visio bar
	m_wndVisioBar.SetOwner(GetDlgItem(IDD_SP_UI_PHONE_BODY)); 
	// Set the background and text color of the visio bar.
	m_wndVisioBar.SetBackColor(RGB(255,128,0));
	m_wndVisioBar.SetTextColor(RGB(0x3a,0x6e,0xa5));

	// initalize the visio bar
	InitializeVisioBar();
	
	// show runtime heap information 
	ProgressBarPos();

	/*!  Open the Window by animation
	/*   which can't be shown when set window region used
	*/
	AnimateWindow(2000,AW_SLIDE|AW_HOR_POSITIVE);
	CRect rc;
	GetClientRect(&rc);
	InvalidateRect(rc, TRUE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void CMainMenuDlg::InitializeVisioBar()
{
	int iFolder; // index of the added folder

	 // Load 256 colour bitmap containing the images...
    HBITMAP hBitmap(HBITMAP(LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDB_FOLDER), IMAGE_BITMAP,
        0, 0,
        LR_CREATEDIBSECTION)));
    _ASSERTE(hBitmap);
    if (hBitmap)
    {
        // Plonk bitmap into image list...
        ImageList_AddMasked(m_ImageSmall.m_hImageList, hBitmap, RGB(255, 255, 255));       
        // Destroy bitmap
        DeleteObject(hBitmap);
    }
    ImageList_AddIcon(m_ImageSmall.m_hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_RECEIVING_CALL)));
	ImageList_AddIcon(m_ImageSmall.m_hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_FUL_SERVICE)));
    ImageList_AddIcon(m_ImageSmall.m_hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_NO_SERVICE)));
    ImageList_AddIcon(m_ImageSmall.m_hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_SHORTMESSAGES)));
	ImageList_AddIcon(m_ImageSmall.m_hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_CHOOSE_NETWORK)));
    ImageList_AddIcon(m_ImageSmall.m_hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_START_JAVA_APP)));
    ImageList_AddIcon(m_ImageSmall.m_hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_SHOW_RUN_TIME_JAVA)));
    ImageList_AddIcon(m_ImageSmall.m_hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_BEGIN_LOW_POWER)));
	ImageList_AddIcon(m_ImageSmall.m_hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_END_LOW_POWER)));
    ImageList_AddIcon(m_ImageSmall.m_hImageList,LoadIcon(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDI_SWITCHOFF)));
		

	
    
	// set the image lists for the visio bar.
	m_wndVisioBar.SetImageList(&m_ImageLarge, OBS_XT_LARGEICON);
	m_wndVisioBar.SetImageList(&m_ImageSmall, OBS_XT_SMALLICON);
	

	// set the image lists
	m_wndListMSM.SetImageList(&m_ImageSmall, LVSIL_SMALL);
	m_wndListJAVA.SetImageList(&m_ImageSmall, LVSIL_SMALL);

	m_wndListMSM.SetImageList(&m_ImageSmall, LVSIL_NORMAL);
	m_wndListJAVA.SetImageList(&m_ImageLarge, LVSIL_NORMAL);

	// Get the Width of the Visio Bar Window
	CRect rect;
	m_wndListJAVA.GetClientRect(&rect);
	int nColInterval = rect.Width();

	// Add the first folder to the visio bar.
	m_wndListMSM.InsertColumn(0, _T("Column 1"), LVCFMT_LEFT, nColInterval);
#ifndef LOCALIZATION_SUPPORT
	iFolder = m_wndVisioBar.AddFolderBar(_T("Network Commands"), &m_wndListMSM);
#else
	iFolder = m_wndVisioBar.AddFolderBar(CLocalizationString(IDS_MMI_CMD_NETWORK_COMMANDS), &m_wndListMSM);
#endif
	m_wndListMSM.SetItemNow( 1 );
	m_wndListMSM.AppendItemGroup(9);

	// Add the list control to the visio bar.
	m_wndListJAVA.InsertColumn(0, _T("Column 1"), LVCFMT_LEFT, nColInterval);
#ifndef LOCALIZATION_SUPPORT
	iFolder = m_wndVisioBar.AddFolderBar(_T("Phone Commands"), &m_wndListJAVA);
#else
	iFolder = m_wndVisioBar.AddFolderBar(CLocalizationString(IDS_MMI_CMD_PHONE_COMMANDS), &m_wndListJAVA);
#endif
	m_wndListJAVA.SetItemNow( 18 );
	m_wndListJAVA.AppendItemGroup(25);
	m_count ++ ;
	
	// We want to receive notification messages.
	m_wndVisioBar.SetOwner(this);

	// Select the first folder in the bar.
	m_wndVisioBar.SetSelFolder(1);

}

/*
 * Visio bar message notification
 */
LRESULT CMainMenuDlg::OnVisioBarNotify(WPARAM wParam, LPARAM lParam)
{
	int nBarAction = (int)wParam;

	// Cast the lParam to a XT_VISIOBAR_INFO* struct pointer.
	XT_VISIOBAR_INFO* pOBInfo = (XT_VISIOBAR_INFO*)lParam;
	ASSERT(pOBInfo);
	
	switch (nBarAction)
	{
	case OBN_XT_ITEMCLICK: // Execute item command 
		{CString strMsg=pOBInfo->lpszText;
		AfxMessageBox(strMsg);
		TRACE2( "Item selected: %d, Name: %s.\n", pOBInfo->nIndex, pOBInfo->lpszText);
		}
		break;

	case OBN_XT_FOLDERCHANGE:
		TRACE2( "Folder selected: %d, Name: %s.\n", pOBInfo->nIndex, pOBInfo->lpszText);
		break;
		
	case OBN_XT_ONLABELENDEDIT:
		TRACE2( "Item edited: %d, New name: %s.\n", pOBInfo->nIndex, pOBInfo->lpszText);
		break;

	case OBN_XT_ONGROUPENDEDIT:
		TRACE2( "Folder edited: %d, New name: %s.\n", pOBInfo->nIndex, pOBInfo->lpszText);
		break;
		
	case OBN_XT_DRAGITEM:
		TRACE3( "Dragging From: %d, To: %d, Name: %s.\n", pOBInfo->nDragFrom, pOBInfo->nDragTo, pOBInfo->lpszText);
		break;

	case OBN_XT_ITEMHOVER:
		TRACE2( "Hovering Item: %d, Name: %s.\n", pOBInfo->nIndex, pOBInfo->lpszText);
		break;
		
	case OBN_XT_DELETEITEM:
		
		TRACE2( "Item deleted: %d, Name: %s.\n", pOBInfo->nIndex, pOBInfo->lpszText);
		break;
		
	case OBN_XT_DELETEFOLDER:
    	TRACE2( "Folder deleted: %d, Name: %s.\n", pOBInfo->nIndex, pOBInfo->lpszText);
		break;
	}

	return TRUE;
}


void CMainMenuDlg::OnClose() 
{
    // when close the window , use animation 
	// if the setwindow region use , this will no effection
	AnimateWindow(1000,AW_SLIDE|AW_HOR_NEGATIVE|AW_HIDE);
	CBitmapDialog::OnClose();
}


BOOL CMainMenuDlg::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	return CBitmapDialog::Create();
}

int CMainMenuDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CBitmapDialog::OnCreate(lpCreateStruct) == -1)
		return -1;

	CMMIDispWindow * p_Disp = (CMMIDispWindow *)GET_APP()->GetMMIDispWindow();
	p_Disp->SetFocus();

	return 0;
}

void CMainMenuDlg::OnDestroy() 
{
	CBitmapDialog::OnDestroy();

	// set back focus to the Phone Body
	CMMIDispWindow * p_Disp = (CMMIDispWindow *)GET_APP()->GetMMIDispWindow();
	p_Disp->SetFocus();

	// destroy the Visio Bar
	m_wndVisioBar.DestroyWindow();
	
}

void CMainMenuDlg::OnLButtonDown(UINT nFlags, CPoint point)
{
	CBitmapDialog::OnLButtonDown(nFlags, point);
}

void CMainMenuDlg::OnRButtonUp(UINT nFlags, CPoint point)
{
	// leave for future window move
	CRect rc;
	GetWindowRect(&rc);
	if (rc.left > GlobalFrameLeft)
	{
		//MoveWindow(GlobalFrameTop + SHAPED_UI_FRAME_WIDTH - 54,GlobalFrameLeft+16,\
		   SHAPED_UI_CMD_WIDTH,SHAPED_UI_CMD_HEIGHT);
	}
	else
	{
	}

	CBitmapDialog::OnRButtonUp(nFlags, point);
}

void CMainMenuDlg::OnLButtonUp(UINT nFlags, CPoint point)
{
	CRect rc;
	GetWindowRect(&rc);
	if (rc.left > GlobalFrameLeft)
	{
		//MoveWindow(GlobalFrameTop + SHAPED_UI_FRAME_WIDTH - 54,GlobalFrameLeft+16,\
		   SHAPED_UI_CMD_WIDTH,SHAPED_UI_CMD_HEIGHT);
	}
	else
	{
	}

	CBitmapDialog::OnLButtonUp(nFlags, point);
}

void CMainMenuDlg::OnNcLButtonUp(UINT nHitTest, CPoint point)
{
	CRect rc;
	GetWindowRect(&rc);
	if (rc.left > GlobalFrameLeft)
	{
		//MoveWindow(GlobalFrameTop + SHAPED_UI_FRAME_WIDTH - 54,GlobalFrameLeft+16,\
		   SHAPED_UI_CMD_WIDTH,SHAPED_UI_CMD_HEIGHT);
	}
	else
	{
	}

	CBitmapDialog::OnNcLButtonUp(nHitTest, point);
}

/*
 * When user press the button on the edge of the region
 * This function will close the main menu window 
 */
void CMainMenuDlg::OnBnClickedOk()
{
	CMFC_Simulation_App * p_App = (CMFC_Simulation_App *)GET_APP();
	GobalMainMenuOpened = FALSE;
	DestroyWindow();
}


void CMainMenuDlg::SetupListCtrl()
{
// for test tool tip
	CRect rectListCtrl;

	m_ctrMyListCtrl.EnableToolTips(TRUE);

	m_ctrMyListCtrl.SetRedraw(FALSE);

	m_ctrMyListCtrl.GetClientRect(&rectListCtrl);
	int nColInterval = rectListCtrl.Width()/3;

	m_ctrMyListCtrl.InsertColumn(0, _T("Column 1"), LVCFMT_LEFT, nColInterval);

	LVITEM lvi;
	CString strItem;
	for (int i = 0; i < 3; i++) {

		lvi.mask = LVIF_IMAGE | LVIF_TEXT;
		lvi.iItem = i;
		lvi.iSubItem = 0;
		strItem.Format(_T("Item (%d, %d)"), i, 0);
		lvi.pszText = (LPTSTR)(LPCTSTR)(strItem);

		m_ctrMyListCtrl.InsertItem(&lvi);

		strItem = "This is the " + strItem;

		m_ctrMyListCtrl.SetItemToolTipText(i, 0, strItem);
	}

	m_ctrMyListCtrl.SetRedraw(TRUE);

}

/*
 * In this function, we clear the main menu background and set the region of it
 */
BOOL CMainMenuDlg::SetWindowRgnArea(CRgn * rgn)
{
	CRgn cmdRgn;
	CRect rcWnd;

	// create region
	GetWindowRect(rcWnd);
	cmdRgn.CreateRectRgn (rcWnd.left, rcWnd.top, rcWnd.right, rcWnd.bottom);
	
	// clear Window rgn
	cmdRgn.CombineRgn(&cmdRgn, &cmdRgn, RGN_XOR);

	// make special rgn
	cmdRgn.CombineRgn(&cmdRgn, rgn, RGN_OR);
	

	SetWindowRgn(cmdRgn, TRUE);

	return TRUE;
}

/*
 * In this function, we can close the main menu window 
 */
void CMainMenuDlg::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
    switch (nChar)
    {
		case VK_TAB:
		{
			// close the Main Menu when Tab pressed
			if (GobalMainMenuOpened == TRUE)			
			{
				CMainFrame*  pFrame =  (CMainFrame*) GET_APP()->m_pMainWnd;
				pFrame->m_MainMenuDlg.DestroyWindow();
				GobalMainMenuOpened = FALSE;
			}
			return;
		}
        default:
			 ;
	}
    CBitmapDialog::OnKeyDown(nChar, nRepCnt, nFlags);
}

/*
 * This function set the progress data in the main menu window
 */
void CMainMenuDlg::ProgressBarPos()
{
#ifdef JAVA_SDK
	// set the progress bar data
//modify by sunmin for fixing bug about progress bar in main menu,2004-10-25
        long totalHeap=getHeapSize();
	long freeHeap=memoryFree();
	m_PrgSize = (int) totalHeap / 100; 
	m_PrgStep = (int) m_PrgSize / 1000;
	m_PrgNow = (int) (totalHeap-freeHeap) / 100;  

	m_progress.SetRange(0, m_PrgSize);
	m_progress.SetPos(m_PrgNow);
	m_progress.SetStep(m_PrgStep);
	m_progress.StepIt();
#endif 
}
