/** @file */
/* ----------------------------------------------------------------------------

Copyright (C) Siemens AG 1994-2001 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_c.c,v, Revision: 1.9, genxfile V1.11

.AUTHOR Marian Kremnican BTS

.FILENAME mobile_simu_caf.c

.CSVERSION 1.1

.VERSION 01.06.10

.DATE 2004-08-22

.SHORT_DESCR  Power up/down sequence for PCT environment

.SW_COMPONENT 

.SW_TYPE 

.EXIT_CODES
  16 - not valid Currently selected Mobile Station Mode
  17 - not valid Requested action

.TODO
    In InitializeMobsimErrorMode - timer function used to shut down.
  Define TASK_NR and MODUL_NR
  Define right value for TRACE_AP_MODE, now 18


.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
01.00.00 2003-11-21 Marian Kremnican (BTS)
         Initial Version
01.01.00 2003-12-15 Robert Vretska (VIE)
         remove LCS-AL
01.01.01 2003-12-31 Gurpreet Dogra (ULM)
         Corrected the Default Block intialization for FAK and MyMenu
01.02.00a 2003-12-18 Gerald Stckl(MCH) 
         replace sms_entity_init() by calling processes directly
01.02.00 2003-12-18 Alexander Nagy (Bardenheuer SW)
         removed FFS init
01.03.00 2004-01-06 Markus Schmidt (extern GOD) Siemens Salzgitter
         Function WinMms_Init() added to restore the MMS Debug Dialog
         settings and include winmms.h
01.04.00 2004-01-15 Uwe Kapala (KLF) added Info_InitInfoMain
01.04.01 2004-01-22 Alexander Nagy (Bardenheuer SW)
         added Info_init();
01.04.02 2004-01-30 Marian Kremnican (BTS)
         Exit procedures from winbinit.cpp added here
01.04.03 2004-02-09 Marian Kremnican (BTS)
         Intergation of msmonoff process
01.04.03 2004-02-10 Klaus Staudenmaier (ULM)
         Bugfix Alarm/ChargeOnly Mode does not Work	 
01.05.00 2004-03-01 Marian Kremnican (BTS)
         Correction for Charge-only and alarm-only modes
01.06.00 2004-03.02 Klaus Staudenmaier (ULM)
          Removed the following Functioncalls: LoadOnBitmaps, LoadWaitBitmaps,
          SaveOnBitmaps, SaveWaitBitmaps
01.06.01 2004-03-02 Alexander Nagy (Bardenheuer SW)
          removed DevLayerProcess_Init() from InitializeMobsimPowerUp()
01.06.02 2004-03.03 Klaus Staudenmaier (ULM)
         Moved SMSregDB_Init from Runlevel 31 to 0 (according to Peter Freitag)
01.06.03 2004-03-11 Marian Kremnican (BTS)
         Versions merge, SMSreDB_Init and SMSshdl_InitSM moved to level 11    
01.06.04 2004-03-12 Alexander Nagy (Bardenheuer SW)
         fixed merge bug     
01.06.05 2004-03-15 Alexander Nagy (Bardenheuer SW)
         removed DevLayerProcess_Init() from InitializeMobsimPowerUp()
01.06.06 2004-03-24 Walter Stroell (VIE)
         MOPI_Shutdown() now called during PC-MMI shutdown
01.06.07 2004-05-17  Alexander Nagy (Bardenheuer Software)
         removed mms simulation for MMI_MMS_AVAILABLE == 0
01.06.08 2004-06-01 Alexander Nagy (Bardenheuer SW)
         separated MemMan_Init() and Info_InitInfoMain() to own action functions
         removed MOPI_Shutdown() to ensure a correct modeman shutdown
01.06.09 2004-06-10 Martin Lehotsky (BTS)
         added initialization of serial communication layer for dual core version
         of PC-Simu (conditionally compiled if DUAL_CORE defined); replaced found
         TABs with spaces.
01.06.10 2004-08-22 Alex Nagy (MCH/BS)
         integrated dl_caf.c to PC-MMI -> removed mssm initialization
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    INCLUDES
------------------------------------------------------------------------------*/
#include <global.h>
#include "modeman.h"
#include "msmodes.h"
#include "mopiext.h"
#include "fakh.h"
#include "info_main.h"
#include "info.h"
#include "msmonoff.h"   // kremni: integration of msmonoff

#include "mmiconf.h"
#if MMI_MMS_AVAILABLE
#include "winmms.h"
#endif 
#ifdef DUAL_CORE
#include "appatsend.h"
#endif
/* -----------------------------------------------------------------------------
    EXIT DEFINES
------------------------------------------------------------------------------*/
#define TASK_NR   0x0
#define MODUL_NR  0x0
#include "exit.h"

void DropApp( void );

/* -----------------------------------------------------------------------------
    TYPES
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    FILE LOCAL CONSTANTS
------------------------------------------------------------------------------*/
/* -----------------------------------------------------------------------------
    FILE LOCAL VARIABLES
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    FILE LOCAL PROTOTYPES
------------------------------------------------------------------------------*/
extern void InitCommunicationHandler( void );
extern void InitSerialDevices( void );
extern void Keyp0Init( void );
extern void MSMTone_Init( void );
extern void msm_sim_init( void );
extern void mm_sim_init( void );
extern void LcsAdmInit( void );
extern void SuplServInit( void );
extern void sm_sim_init( void );
extern void EMSAL_Admin_InitProcess( void );
#ifdef WAS_ACC_SETUP
extern void Was_initialize( void );
#endif
extern void MlAE_Init( void );
extern void LoadTastenKlickWaveForm( UINT8 * );
#if (MMI_OUTDOOR_AVAILABLE)
extern void BAROMETER_OMA_Init( void );
#endif

extern void CBS_entity_init( void );
extern void createCKPresentationLayerProcess( void );
extern void KG_RandMasterInit( unsigned long );
extern void FilenameSeekProcessInit( void );
extern void ddsound_InitSoundPlayer( void );
extern void UDIAL_InitProcess( void );
extern void MyMenu_DefaultBlock_Init();
extern void Camera_Init( void );
extern void UnloadTastenKlickWaveForm( void );

extern void Camera_Deactivate( void );
extern void DevLayerProcess_Init( void );
extern void SMSshdl_InitSM( void );
extern void SMSregDB_Init( void );
extern void SetQuitMsgPosted( void );
extern void SetSimulationMode( void );

extern void MOPI_Shutdown( void );

//static const unsigned char componentActionFunctionName_MobsimActionFunction[] = {"MobsimActionFunction"};
/* Power Down */     

/* Power Up */       
static E_MODEMAN_COMPONENT_ACTION_STATE InitializeMobsimPowerUp(T_Modeman_ComponentAction_ProcessingLevel level);
static E_MODEMAN_COMPONENT_ACTION_STATE ShutDownMobsimPowerUp(T_Modeman_ComponentAction_ProcessingLevel level);
/* Normal (GSM) */   
#if MODEMAN_MSM_NORMAL_GSM_REQUIRED > 0
static E_MODEMAN_COMPONENT_ACTION_STATE InitializeMobsimNormalGsm(T_Modeman_ComponentAction_ProcessingLevel level);
#if MODEMAN_CA_SHUTDOWN_ALLOWED > 0
static E_MODEMAN_COMPONENT_ACTION_STATE ShutDownMobsimNormalGsm(T_Modeman_ComponentAction_ProcessingLevel level);
#endif // #if MODEMAN_CA_SHUTDOWN_ALLOWED > 0
#endif // #if MODEMAN_MSM_NORMAL_GSM_REQUIRED > 0

/* Normal (TDMA) */  

/* Charge Only */    
#if MODEMAN_MSM_CHARGE_ONLY_REQUIRED > 0 
static E_MODEMAN_COMPONENT_ACTION_STATE InitializeMobsimChargeOnly(T_Modeman_ComponentAction_ProcessingLevel level);
#if MODEMAN_CA_SHUTDOWN_ALLOWED > 0
static E_MODEMAN_COMPONENT_ACTION_STATE ShutDownMobsimChargeOnly(T_Modeman_ComponentAction_ProcessingLevel level);
#endif // #if MODEMAN_CA_SHUTDOWN_ALLOWED > 0
#endif // #if MODEMAN_MSM_CHARGE_ONLY_REQUIRED > 0 

/* Alarm */          
#if MODEMAN_MSM_ALARM_REQUIRED > 0 
static E_MODEMAN_COMPONENT_ACTION_STATE InitializeMobsimAlarmMode(T_Modeman_ComponentAction_ProcessingLevel level);
static E_MODEMAN_COMPONENT_ACTION_STATE ShutDownMobsimAlarmMode(T_Modeman_ComponentAction_ProcessingLevel level);
#endif // #if MODEMAN_MSM_ALARM_REQUIRED > 0 

/* Error */          

/* Service (GSM) */  

/* Service (TDMA) */ 

/* Burn In */        

/* Swup */           

/* -----------------------------------------------------------------------------
    IMPLEMENTATION SECTION EXPORTED FUNCTIONS
------------------------------------------------------------------------------*/
/* ------------------------------------------------------------------------*//**
   Dummy system Component Interface Function for mobile simution. 
  
   \note    no side effects
   \return  Returns component action status as described in file 'modeman.h'
   \retval  always E_MODEMAN_CAS_COMPLETED - Action is completed successfully
*//*------------------------------------------------------------------------- */
E_MODEMAN_COMPONENT_ACTION_STATE DummyComponentActionFunction(
    E_MODEMAN_MOBILE_STATION_MODE               mode,   /**< Currently selected Mobile Station Mode */
    E_MODEMAN_COMPONENT_ACTION                  action, /**< Requested action */
    T_Modeman_ComponentAction_ProcessingLevel   level)  /**< Processing level (initialized with 0) */
{
    return E_MODEMAN_CAS_COMPLETED;
}

/* ------------------------------------------------------------------------*//**
   System Component Interface Function for mobile simution. 
  
   \note    no side effects
   \return  Returns component action status as described in file 'modeman.h'
   \retval  E_MODEMAN_CAS_COMPLETED - Action is completed successfully
   \retval  E_MODEMAN_CAS_NOT_COMPLETED - Action processing is completed for the current processing level
                                          but there are outstanding task 
                                          that require at least one additional processing level
*//*------------------------------------------------------------------------- */
E_MODEMAN_COMPONENT_ACTION_STATE MobSim_ComponentActionFunction(
    E_MODEMAN_MOBILE_STATION_MODE               mode,   /**< Currently selected Mobile Station Mode */
    E_MODEMAN_COMPONENT_ACTION                  action, /**< Requested action */
    T_Modeman_ComponentAction_ProcessingLevel   level)  /**< Processing level (initialized with 0) */
{
    E_MODEMAN_COMPONENT_ACTION_STATE RetVal = E_MODEMAN_CAS_COMPLETED;
    
    switch(mode)
    {
        case E_MODEMAN_MSM_POWER_DOWN:   /* Power Down */
            break;
        case E_MODEMAN_MSM_POWER_UP:     /* Power Up */
            if (action == E_MODEMAN_CA_INITIALIZE)
            {
                RetVal = InitializeMobsimPowerUp(level);
            }
#if         MODEMAN_CA_SHUTDOWN_ALLOWED > 0
            else if (action == E_MODEMAN_CA_SHUTDOWN)
            {
                RetVal = ShutDownMobsimPowerUp(level);                
            } 
#endif      //#if MODEMAN_CA_SHUTDOWN_ALLOWED > 0      
            else
            {   /* not valid action */
                SEXIT(17);
                RetVal = E_MODEMAN_CAS_COMPLETED;
            }        
            break;
#if         MODEMAN_MSM_NORMAL_GSM_REQUIRED > 0            
        case E_MODEMAN_MSM_NORMAL_GSM:   /* Normal (GSM) */
            if (action == E_MODEMAN_CA_INITIALIZE)
            {
                RetVal = InitializeMobsimNormalGsm(level);
            }
#if         MODEMAN_CA_SHUTDOWN_ALLOWED > 0
            else if (action == E_MODEMAN_CA_SHUTDOWN)
            {
                RetVal = ShutDownMobsimNormalGsm(level);                
            } 
#endif      //#if MODEMAN_CA_SHUTDOWN_ALLOWED > 0      
            else
            {   /* not valid action */
                SEXIT(17);
                RetVal = E_MODEMAN_CAS_COMPLETED;
            }
            break;
#endif      // #if MODEMAN_MSM_NORMAL_GSM_REQUIRED > 0

#if         MODEMAN_MSM_CHARGE_ONLY_REQUIRED > 0 
        case E_MODEMAN_MSM_CHARGEONLY:   /* Charge Only */            
            if (action == E_MODEMAN_CA_INITIALIZE)
            {
                RetVal = InitializeMobsimChargeOnly(level);
            }
#if         MODEMAN_CA_SHUTDOWN_ALLOWED > 0            
            else if (action == E_MODEMAN_CA_SHUTDOWN)
            {
                RetVal = ShutDownMobsimChargeOnly(level);
            }  
#endif      // #if MODEMAN_CA_SHUTDOWN_ALLOWED > 0            
            else
            {   /* not valid action */
                SEXIT(17);
                RetVal = E_MODEMAN_CAS_COMPLETED;
            }                      
            break;
#endif      //#if MODEMAN_MSM_CHARGE_ONLY_REQUIRED > 0

#if MODEMAN_MSM_ALARM_REQUIRED
        case E_MODEMAN_MSM_ALARM:        /* Alarm */            
            if (action == E_MODEMAN_CA_INITIALIZE)
            {
                RetVal = InitializeMobsimAlarmMode(level);
            }
#if         MODEMAN_CA_SHUTDOWN_ALLOWED > 0            
            else if (action == E_MODEMAN_CA_SHUTDOWN)
            {
                RetVal = ShutDownMobsimAlarmMode(level);
            }  
#endif      // #if MODEMAN_CA_SHUTDOWN_ALLOWED > 0            
            else
            {   /* not valid action */
                SEXIT(17);
                RetVal = E_MODEMAN_CAS_COMPLETED;
            }                      
            break;
#endif      // #if MODEMAN_MSM_ALARM_REQUIRED

#if 0
        case E_MODEMAN_MSM_ERROR:        /* Error */            
            break;  
#endif  0

#if  0
        case E_MODEMAN_MSM_SERVICE_GSM:  /* Service (GSM) */            
            break;     
#endif 0

#if 0               
        case E_MODEMAN_MSM_SERVICE_TDMA: /* Service (TDMA) */
            break;
#endif      //#if 0

#if 0
        case E_MODEMAN_MSM_BURNIN:       /* Burn In */      
            break; 
#endif 0

#if 0                   
        case E_MODEMAN_MSM_SWUP:         /* Swup */
            break;
#endif      //#if 0

        default:    // not expected mode
            SEXIT(16);
            RetVal = E_MODEMAN_CAS_COMPLETED;
            break;            
    }
    return RetVal;
}


MODEMAN_DECLARE_COMPONENT_ACTION_FUNCTION( E_MODEMAN_CID_APPLICATIONS, MobSim_ComponentActionFunction )

/* -----------------------------------------------------------------------------
    IMPLEMENTATION SECTION LOCAL FUNCTIONS
------------------------------------------------------------------------------*/
/* Power Down */     

/* Power Up */       
static E_MODEMAN_COMPONENT_ACTION_STATE InitializeMobsimPowerUp(T_Modeman_ComponentAction_ProcessingLevel level)
{
    E_MODEMAN_COMPONENT_ACTION_STATE RetVal = E_MODEMAN_CAS_COMPLETED;
    
    switch(level)
    {
        case 0:    
        case 1:
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;        
        case 2:
#ifdef DUAL_CORE
            //initialize driver for serial line communication for AT commands
            AppATSendDriverInitialize();
#endif        
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;        
        case 3:
            /*************************************************************************************** 
            * 'WinMms_Init()' calls the external debug help tool (dialog/debug config tool) *
            * at winmms.cpp to add a debug listener callback at the MMS client file mms_cl.c!     *
            * This call must be performed before 'MMILow_Init()' is called!                       *
            ***************************************************************************************/
#if MMI_MMS_AVAILABLE
            WinMms_Init(); 
#endif //#if MMI_MMS_AVAILABLE

            RetVal = E_MODEMAN_CAS_COMPLETED;
            break;               
        default:
            /* nothing to do, all relevant processing levels are already done */
            RetVal = E_MODEMAN_CAS_COMPLETED;   
            break;
    }    
    return RetVal;
}

static E_MODEMAN_COMPONENT_ACTION_STATE ShutDownMobsimPowerUp(T_Modeman_ComponentAction_ProcessingLevel level)
{
    E_MODEMAN_COMPONENT_ACTION_STATE RetVal = E_MODEMAN_CAS_COMPLETED;
    
    switch(level)
    {
        case 0:
#ifdef DUAL_CORE
            AppATSendDriverStopReceiving();
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
#else            
            RetVal = E_MODEMAN_CAS_COMPLETED;
#endif            
            break;        

        default:
            /* nothing to do, all relevant processing levels are already done */
            RetVal = E_MODEMAN_CAS_COMPLETED;   
            break;            
    }    
    return RetVal;    
}

/* Normal (GSM) */   
#if MODEMAN_MSM_NORMAL_GSM_REQUIRED > 0
static E_MODEMAN_COMPONENT_ACTION_STATE InitializeMobsimNormalGsm(T_Modeman_ComponentAction_ProcessingLevel level)
{
    E_MODEMAN_COMPONENT_ACTION_STATE RetVal = E_MODEMAN_CAS_COMPLETED;
    
    switch(level)
    {
        case 0:
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;                
        case 1:
            InitCommunicationHandler();
            InitSerialDevices();
            Keyp0Init();
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:          
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;        
        case 9:
            MSMTone_Init();
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;        
        case 10:
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;      
        case 11:
            SMSshdl_InitSM();
            SMSregDB_Init();
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;        
        case 12:
        case 13:
        case 14:
        case 15:
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;        
        case 16:
            msm_sim_init();
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;        
        case 17:
        case 18:
        case 19:
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;        
        case 20:
            mm_sim_init();
            LcsAdmInit();
            SuplServInit();
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;        
        case 21:
        case 22:
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;        
        case 23:
            sm_sim_init ();
            #ifdef WAS_ACC_SETUP
                Was_initialize();
            #endif
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;        
        case 24:
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;        
        case 25:
            LoadTastenKlickWaveForm( ".\\soundsim\\taste.wav");
            #if (MMI_OUTDOOR_AVAILABLE)
            // initialize barometer process
                BAROMETER_OMA_Init();
            #endif
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;        
        case 26:
        case 27:
        case 28:
        case 29:
        case 30:
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;        
        case 31:
            CBS_entity_init();
            createCKPresentationLayerProcess();
            KG_RandMasterInit(0);
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;        
        case 32:
            FilenameSeekProcessInit();
            ddsound_InitSoundPlayer();
            //UDIAL_InitProcess();
            MyMenu_DefaultBlock_Init();
            #ifdef FAK_DEFAULT_BLOCK_INIT
                Fak_Defualt_Initialization();
            #endif
            Camera_Init();
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;        
        case 33:
        case 34:
        case 35:
        case 36:
        case 37:
        case 38:
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;
        case 39:
            RetVal = E_MODEMAN_CAS_COMPLETED;
        default:
            /* nothing to do, all relevant processing levels are already done */
            RetVal = E_MODEMAN_CAS_COMPLETED;   
            break;
    }    
    return RetVal;
}

#if MODEMAN_CA_SHUTDOWN_ALLOWED > 0
static E_MODEMAN_COMPONENT_ACTION_STATE ShutDownMobsimNormalGsm(T_Modeman_ComponentAction_ProcessingLevel level)
{
    E_MODEMAN_COMPONENT_ACTION_STATE RetVal = E_MODEMAN_CAS_COMPLETED;
    
    switch(level)
    {
        case 0:
        case 1:
        case 2:
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;
        case 3:
            Camera_Deactivate();
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;
        case 4:
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;
        case 5:
            UnloadTastenKlickWaveForm( );
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;                
        case 6:
        case 7:
        case 8:
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;                
        case 9:
            RetVal = E_MODEMAN_CAS_COMPLETED;
            break;                
      
        default:
            /* nothing to do, all relevant processing levels are already done */
            RetVal = E_MODEMAN_CAS_COMPLETED;   
            break;            
    }    
    return RetVal;

}
#endif // #if MODEMAN_CA_SHUTDOWN_ALLOWED > 0

#endif // #if MODEMAN_MSM_NORMAL_GSM_REQUIRED > 0

/* Normal (TDMA) */  

/* Charge Only */    
#if MODEMAN_MSM_CHARGE_ONLY_REQUIRED > 0 //(see ml_cha.c)
static E_MODEMAN_COMPONENT_ACTION_STATE InitializeMobsimChargeOnly(T_Modeman_ComponentAction_ProcessingLevel level)
{
    E_MODEMAN_COMPONENT_ACTION_STATE RetVal = E_MODEMAN_CAS_COMPLETED;
    
    switch(level)
    {
        case 0:
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;
            
        default:
            /* nothing to do, all relevant processing levels are already done */
            RetVal = E_MODEMAN_CAS_COMPLETED;   
            break;            
    }    
    return RetVal;    
}

#if MODEMAN_CA_SHUTDOWN_ALLOWED > 0
static E_MODEMAN_COMPONENT_ACTION_STATE ShutDownMobsimChargeOnly(T_Modeman_ComponentAction_ProcessingLevel level)
{
    E_MODEMAN_COMPONENT_ACTION_STATE RetVal = E_MODEMAN_CAS_COMPLETED;
    
    switch(level)
    {
        case 0:
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;                
        case 1:
            RetVal = E_MODEMAN_CAS_COMPLETED;
            break;        
            
        default:
            /* nothing to do, all relevant processing levels are already done */
            RetVal = E_MODEMAN_CAS_COMPLETED;   
            break;            
    }    
    return RetVal;    
}
#endif // #if MODEMAN_CA_SHUTDOWN_ALLOWED > 0
#endif //#if MODEMAN_MSM_CHARGE_ONLY_REQUIRED > 0 

/* Alarm */ 
#if MODEMAN_MSM_ALARM_REQUIRED > 0 // (see ml_ala.c)
static E_MODEMAN_COMPONENT_ACTION_STATE InitializeMobsimAlarmMode(T_Modeman_ComponentAction_ProcessingLevel level)
{
    E_MODEMAN_COMPONENT_ACTION_STATE RetVal = E_MODEMAN_CAS_COMPLETED;
    
    switch(level)
    {
        case 0:
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;                
            
        default:
            /* nothing to do, all relevant processing levels are already done */
            RetVal = E_MODEMAN_CAS_COMPLETED;   
            break;            
    }    
    return RetVal;    
}

#if MODEMAN_CA_SHUTDOWN_ALLOWED > 0    
static E_MODEMAN_COMPONENT_ACTION_STATE ShutDownMobsimAlarmMode(T_Modeman_ComponentAction_ProcessingLevel level)
{
    E_MODEMAN_COMPONENT_ACTION_STATE RetVal = E_MODEMAN_CAS_COMPLETED;
    
    switch(level)
    {
        case 0:
            RetVal = E_MODEMAN_CAS_NOT_COMPLETED;
            break;
        case 1:
            RetVal = E_MODEMAN_CAS_COMPLETED;
            break;

        default:
            /* nothing to do, all relevant processing levels are already done */
            RetVal = E_MODEMAN_CAS_COMPLETED;   
            break;
    }    
    return RetVal;    
}
#endif // #if MODEMAN_CA_SHUTDOWN_ALLOWED > 0
#endif // #if MODEMAN_MSM_ALARM_REQUIRED > 0 

/* Error */          

/* Service (GSM) */  

/* Service (TDMA) */ 

/* Burn In */        


/* -----------------------------------------------------------------------------
    END OF FILE mobile_simu_caf.c
------------------------------------------------------------------------------*/
