/** @file */
/* ----------------------------------------------------------------------------

Copyright (C) Siemens AG 1994-2004 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_c.c,v, Revision: 1.9, genxfile V1.11

.AUTHOR         %derived_by: leenak % (last modifier)

.FILENAME       BlackBerryDlg.cpp

.VERSION        %version: 1 %

.DATE           %date_modified: 2004-07-30 09:52:16 %

.SHORT_DESCR    Implementation for BlackBerry dialog

.SW_COMPONENT   PC-MMI-Test Environment

.SW_TYPE 

.EXIT_CODES

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
   1     2004-05-27 Guenther Karl (VIE)
         Initial Version
------------------------------------------------------------------------------*/


/* -----------------------------------------------------------------------------
    INCLUDES
------------------------------------------------------------------------------*/
#include "sms_res.h"

extern "C"
{
    #include <global.h>
    #include "gbs.h"
    #include "app_msg.h"
    #include "procid.h"
    #include "blackberry.h"
}


#if BLACKBERRY_AVAILABLE > 0

#include "BlackBerryDlg.h" 

extern "C"
{
    #include "bbEEFull.h"
    #include "mopi.h"
    #include "mopiext.h"
}

/* -----------------------------------------------------------------------------
    EXIT DEFINES
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    DEFINES
------------------------------------------------------------------------------*/
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/* -----------------------------------------------------------------------------
    TYPES
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    FILE LOCAL CONSTANTS
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    FILE LOCAL VARIABLES
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    FILE LOCAL PROTOTYPES
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    IMPLEMENTATION SECTION EXPORTED FUNCTIONS
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    IMPLEMENTATION SECTION LOCAL FUNCTIONS
------------------------------------------------------------------------------*/

CBlackBerryDlg::CBlackBerryDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CBlackBerryDlg::IDD, pParent)
{
    //{{AFX_DATA_INIT(CBlackBerryDlg)
    //}}AFX_DATA_INIT
}

//------------------------------------------------------------------------------
void CBlackBerryDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CBlackBerryDlg)
    DDX_Control(pDX, IDC_EDIT_BB_SAMPLE, m_EditString);
    //}}AFX_DATA_MAP

}

//------------------------------------------------------------------------------
BEGIN_MESSAGE_MAP(CBlackBerryDlg, CDialog)
    //{{AFX_MSG_MAP(CBlackBerryDlg)
    ON_BN_CLICKED(IDOK, OnBnClickedOk)
    ON_BN_CLICKED(IDC_BB_SENDMAIL, OnBnClickedBbSendMail)
    ON_BN_CLICKED(IDC_BB_RECEIVE_MAIL, OnBnClickedBbReceiveMail)
    ON_BN_CLICKED(IDC_RADIO_BB_GENERIC, OnBnClickedRadioBbGeneric)
    ON_BN_CLICKED(IDC_RADIO_BB_PROSUMER, OnBnClickedRadioBbProsumer)
    ON_BN_CLICKED(IDC_RADIO_BB_ENTERPRISE, OnBnClickedRadioBbEnterprise)
    ON_BN_SETFOCUS(IDC_RADIO_BB_GENERIC, SelectCurrentVariant)
    ON_BN_SETFOCUS(IDC_RADIO_BB_PROSUMER, SelectCurrentVariant)
    ON_BN_SETFOCUS(IDC_RADIO_BB_ENTERPRISE, SelectCurrentVariant)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

//------------------------------------------------------------------------------
BOOL CBlackBerryDlg::OnInitDialog() 
{
    CDialog::OnInitDialog();
    SelectCurrentVariant();
    return TRUE;
}

//------------------------------------------------------------------------------

void CBlackBerryDlg::SelectCurrentVariant(void)
{
    T_BB_Variant variant;
    char *buffer;

    variant = bbGetVariant();
    switch (variant)
    {
    default:
    case eBB_UNDEFINED:
    case eBB_GENERIC:
        CheckRadioButton(IDC_RADIO_BB_ENTERPRISE, IDC_RADIO_BB_PROSUMER, IDC_RADIO_BB_GENERIC);
        buffer="generic";
        break;
    case eBB_PROSUMER:
        CheckRadioButton(IDC_RADIO_BB_ENTERPRISE, IDC_RADIO_BB_PROSUMER, IDC_RADIO_BB_PROSUMER);
        buffer="prosumer";
        break;
    case eBB_ENTERPRISE:
        CheckRadioButton(IDC_RADIO_BB_ENTERPRISE, IDC_RADIO_BB_PROSUMER, IDC_RADIO_BB_ENTERPRISE);
        buffer="enterprise";
        break;
    }
    TRACE("current variant => %s\n", buffer);
} 

void CBlackBerryDlg::OnBnClickedOk()
{
    // TODO: Add your control notification handler code here
    OnOK();
}

void CBlackBerryDlg::OnBnClickedBbSendMail()
{
    TRACE("=> SendMail\n");
}

void CBlackBerryDlg::OnBnClickedBbReceiveMail()
{
    TRACE("=> ReceiveMail\n");
}

void CBlackBerryDlg::OnBnClickedRadioBbGeneric()
{
    MOPI_ExecuteFunction( MOPI_GetCurrentCepId(), (T_MOPI_ExtFunction) bbSetVariant, (UINT32) eBB_GENERIC);
    TRACE("=> Generic\n");
}

void CBlackBerryDlg::OnBnClickedRadioBbProsumer()
{
    MOPI_ExecuteFunction( MOPI_GetCurrentCepId(), (T_MOPI_ExtFunction) bbSetVariant, (UINT32) eBB_PROSUMER);
    TRACE("=> Prosumer\n");
}

void CBlackBerryDlg::OnBnClickedRadioBbEnterprise()
{
    MOPI_ExecuteFunction( MOPI_GetCurrentCepId(), (T_MOPI_ExtFunction) bbSetVariant, (UINT32) eBB_ENTERPRISE);
    TRACE("=> Enterprise\n");
}

#endif // BLACKBERRY_AVAILABLE
