#ifndef SIMUMTTP_H
#define SIMUMTTP_H
/** @file */
/* -----------------------------------------------------------------------------
Copyright (C) Siemens AG 1994-2001 * ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR Jens Scharnow (KLF-5918)

.FILENAME simumttp.h


.CSVERSION 1.1


.VERSION 01.01.01

.DATE 2004-03-08

.SHORT_DESCR private Header of the MTT<->Simulation Interface

.SW_COMPONENT Simulation

.SW_TYPE private Header

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change
--------------------------------------------------------------------------------
01.00.00 2003-02-26 Jens Scharnow (KLF-5918) (KLF_EXT)
         Initial Version
01.01.00 2003-12-08 Jens Scharnow (KLF-5918) (KLF_EXT)
         Changed key codes for R65
01.01.01 2004-03-08 A.Nagy (Bardenheuer Software)
         replaced ddcode0h.h by keypad.h

------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    INCLUDES
------------------------------------------------------------------------------*/
#include <global.h>
#include "simumtth.h"
#include "keypad.h"




/* -----------------------------------------------------------------------------
    Neccessary externals
------------------------------------------------------------------------------*/
extern UINT8 DispBuff[];

/* -----------------------------------------------------------------------------
    DEFINES
------------------------------------------------------------------------------*/

// character to be sent to the simulation to fetch the screen
#define SIM_MTT_FETCH_SCREEN_CHAR ' ' 

// character to be sent to the simulation to release a key
#define SIM_MTT_PRESS_KEY_CHAR 'P'

// character to be sent to the simulation to release a key
#define SIM_MTT_RELEASE_KEY_CHAR 'R'

// to mark the end of the map (see below: mg_SIM_MTTKeymap)
#define SIM_MTT_COMMAND_NOT_FOUND 0xFF 

/* -----------------------------------------------------------------------------
    TYPES
------------------------------------------------------------------------------*/

/* -----------------------------------------------------------------------------
    CONSTANTS
------------------------------------------------------------------------------*/

// mapping of characters to be sent to the Simulation to simulate key presses
// character -> Siemens Key Code (as defined in ddcode0h.h)
static const unsigned char mg_SIM_MTTKeymap[][2]={
    {'#',HASH},
    {'*',STAR},
    {'1',KEY_1},
    {'2',KEY_2},
    {'3',KEY_3},
    {'4',KEY_4},
    {'5',KEY_5},
    {'6',KEY_6},
    {'7',KEY_7},
    {'8',KEY_8},
    {'9',KEY_9},
    {'0',KEY_0},
    {0x01,SOFT_1},
    {0x04,SOFT_4},
    {0x0c,ONOFF},
    {0x0b,START},
    {0x3c,NAVI_DOWN},
    {0x3b,NAVI_UP},
    {0x3d,NAVI_LEFT},
    {0x3e,NAVI_RIGHT},
    {0x1a,NAVI_CENTER},
    {0x0d,UP},
    {0x0e,DOWN},
    {0x06,MEMO}, 
    {SIM_MTT_COMMAND_NOT_FOUND, SIM_MTT_COMMAND_NOT_FOUND} // last entry
};


/* -----------------------------------------------------------------------------
    PROTOTYPES
------------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

/* --------------------------------------------------------------------------- */
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* SIMUMTTP_H */

/* -----------------------------------------------------------------------------
    END OF FILE simumttp.h
----------------------------------------------------------------------------- */
