/*! \file 

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

.AUTHOR Sun Min(ICM MP PD SW(PEK))

.FILENAME SmtkToolHeap.cpp

.VERSION 01.00.00

.DATE 2004-06-17

.SHORT_DESCR:   SMTK TOOL CLASS AND API

.SW_COMPONENT:  SMTK EMULATOR

.SW_TYPE 

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change
01.00.00 2004-06-17 Sun Min(PEK)
                    Initial version
01.00.01 2004-06-18 Sun Min(PEK)
                    Use this file only for SHAPED UI		    
01.01.00 2004-08-17 Sun Min(PEK)
                    Add function OnSize(),	    
                    Modify function OnInitDialog(),
01.01.01 2004-11-04 Sun Min(PEK)
                    Enable SMTK Tool both in MDV and Shaped UI
*/

//2004-11-04 Sun Min : modify to enable SMTK tool both in MDV and Shaped UI
#ifdef JAVA_SDK
#include "SmtkToolHeap.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSmtkToolHeap dialog


CSmtkToolHeap::CSmtkToolHeap(CWnd* pParent /*=NULL*/)
	: CDialog(CSmtkToolHeap::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSmtkToolHeap)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CSmtkToolHeap::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSmtkToolHeap)
		DDX_Control(pDX,IDC_HIGH,m_cButtonUpdateHigh);
		DDX_Control(pDX,IDC_NORMAL,m_cButtonUpdateNormal);
		DDX_Control(pDX,IDC_LOW,m_cButtonUpdateLow);

	//}}AFX_DATA_MAP
}



BEGIN_MESSAGE_MAP(CSmtkToolHeap, CDialog)
	//{{AFX_MSG_MAP(CSmtkToolHeap)
	ON_WM_DESTROY()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP	
	
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSmtkToolHeap message handlers
BOOL CSmtkToolHeap::OnInitDialog()
{
	CDialog::OnInitDialog();
	m_nCheckStatus=1;
    m_cButtonUpdateNormal.SetCheck(1);
	m_cButtonUpdateHigh.SetCheck(0);
	m_cButtonUpdateLow.SetCheck(0);
	GetDlgItem(IDC_STATIC_HEAP_INFO2)->GetWindowRect(m_cRectHeapView);
	ScreenToClient(m_cRectHeapView);
        m_cRectHeapView.bottom-=10;
	m_cRectHeapView.top+=20;
	m_cRectHeapView.left+=20;
	m_cRectHeapView.right-=20;
	m_HeapView.SetJavaHeapViewPos(m_cRectHeapView);
	if(!m_HeapView.Create(NULL,NULL,AFX_WS_DEFAULT_VIEW,m_cRectHeapView,this,AFX_IDW_PANE_FIRST+11,NULL))
	{
		TRACE0("Failed to create view window\n");
        return -1;	
	}
	return TRUE;
}

BOOL CSmtkToolHeap::OnCommand(WPARAM wParam,LPARAM lParam)
{
	if(m_cButtonUpdateHigh.GetCheck()==BST_CHECKED)
		m_nCheckStatus=0;
	else if(m_cButtonUpdateNormal.GetCheck()==BST_CHECKED)
        m_nCheckStatus=1;
    else
		m_nCheckStatus=2;
	m_HeapView.SetUpdateRate(m_nCheckStatus);
	return CDialog::OnCommand(wParam,lParam);
}

void CSmtkToolHeap::OnDestroy()
{
	CDialog::OnDestroy();
	m_HeapView.DestroyWindow();
}

void CSmtkToolHeap::OnSize(UINT nType,int cx,int cy)
{
	CDialog::OnSize(nType,cx,cy);
	RECT rHeapWindow;
	GetClientRect(&rHeapWindow);
	ClientToScreen(&rHeapWindow);

	CWnd *pCwndGroup=NULL;
	pCwndGroup=GetDlgItem(IDC_STATIC_HEAP_INFO2);
	if(pCwndGroup)
	{
		pCwndGroup->GetWindowRect(m_cRectHeapView);
		m_cRectHeapView.bottom=rHeapWindow.bottom-20;
		m_cRectHeapView.right=rHeapWindow.right-20;
		ScreenToClient(m_cRectHeapView);
		pCwndGroup->MoveWindow(m_cRectHeapView);
		//pCwndGroup->GetClientRect(&rHeapWindow);
		m_cRectHeapView.bottom-=10;
		m_cRectHeapView.top+=20;
		m_cRectHeapView.left+=20;
		m_cRectHeapView.right-=20;
		if(m_HeapView)
		{
			m_HeapView.MoveWindow(m_cRectHeapView);
			m_HeapView.SetJavaHeapViewPos(m_cRectHeapView);
		}
	}
	
	//delete pCwndGroup;
	
	//GetDlgItem(IDC_STATIC_HEAP_INFO)->GetWindowRect(m_cRectHeapView);
	//GetDlgItem(IDC_STATIC_HEAP_INFO)->GetWindowRect(m_cRectHeapView);
	//ScreenToClient(m_cRectHeapView);
	//GetDlgItem(IDC_STATIC_HEAP_INFO)->MoveWindow(m_cRectHeapView.left,m_cRectHeapView.top,crHeapWindow.bottom-80,crHeapWindow.right-80);

}

#endif //define USE_SHAPED_UI
