/** @file

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

This software is protected by the inclusion of the above copyright
notice. This software may not be provided or otherwise made available
to, or used by, any other person. No title to or ownership of the
software is  hereby  transferred.
The information contained in this document is considered the
CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
not be disclosed or discussed with anyone who is not employed by
Siemens AG, unless the individual / company
(i) has an express need to know such information, and
(ii) disclosure of information is subject to the terms of a duly
executed Confidentiality and Non-Disclosure Agreement between
Siemens AG and the individual / company.

Created using template RCSfile: templ_h.h,v, Revision: 1.7, genxfile V1.11

.AUTHOR         Murat Korkmaz 

.FILENAME       appibase.h

.TODO           

.SHORT_DESCR    Implementation of base interface functions . 

.SW_COMPONENT   PC-SIMU PlugIn

.SW_TYPE        

.CHANGE_CONTROL

Version   Date       Changed by          Reason of change<br>
--------------------------------------------------------------------------------<br>
01.00.00  2004-01-14 Murat Korkmaz       Initial Version.<br>
01.01.00  2004-02-09 Murat Korkmaz       preprocessor JAVA_SDK added
01.02.00  2005-04-18 Andreas Emmer		 appimlf interfcae added for the MemLeakFinder
------------------------------------------------------------------------------*/
#ifndef JAVA_SDK

/* -----------------------------------------------------------------------------
INCLUDES
------------------------------------------------------------------------------*/
#include "pluginmanager.h"
#include "appimopi.h"
#include "appimlf.h"

CAppiBase::CAppiBase(CPlugInManager* pcManager)
{
    ASSERT(pcManager != NULL);
    m_pcManager       = pcManager;
}

CAppiBase::~CAppiBase(void)
{
    if (m_pcAppiMOPI != NULL)
    {
        delete m_pcAppiMOPI;
        m_pcAppiMOPI = NULL;
    }

	if (m_pcAppiMLF != NULL)
	{
		delete m_pcAppiMLF;
		m_pcAppiMLF = NULL;
	}

}
/**
 *   This function will return the APPLICATION_API_VERSION (interface version) 
 *   which was compiled with the PlugIn.
 *
 *   @return  DWORD: a value which identifies the BASE API version of the PlugIn.
 */
DWORD CAppiBase::GetApplicationAPIVersion()
{
    return APPLICATION_BASE_API_VERSION;
}

/**
 *   This function returns commands IDs for plug-ins.
 *   The range of commands are between PLUGIN_COMMAND_START_ID 
 *   and PLUGIN_COMMAND_END_ID.
 *
 *   @param  num : number of requested command ID.
 *   @return UINT: free command ID. 
 */
UINT CAppiBase::GetCommandIDs(int num)
{
    ASSERT(m_pcManager != NULL);
    return m_pcManager->GetCommandIDs(num);
}

/**
 *   This function gives the MOPI Application interfaces for the MOPI_PlugIn.dll.
 *
 *   @param  ptrMOPIAppInterface : the addres of the IApplicationInterfaceMOPI object.
 *   @return BOOL: TRUE if IApplicationInterfaceMOPI is available. 
 */
BOOL CAppiBase::GetMOPIApplicationInterface(IApplicationInterfaceMOPI *&ptrMOPIAppInterface)
{
    BOOL bReturn = FALSE;
    m_pcAppiMOPI = new CAppiMOPI();

    if (m_pcAppiMOPI != NULL)
    {
        ptrMOPIAppInterface = m_pcAppiMOPI;
        bReturn = TRUE;
    }
    return bReturn;
}
/**
*   This function gives the MemLeakFinder Application interfaces for the MemLeakFinder_PlugIn.dll.
*
*   @param  ptrMLFAppInterface : the addres of the IApplicationInterfaceMLF object.
*   @return BOOL: TRUE if IApplicationInterfaceMLF is available. 
*/

BOOL CAppiBase::GetMLFApplicationInterface(IApplicationInterfaceMLF *&ptrMLFAppInterface)
{
	BOOL bReturn = FALSE;
	m_pcAppiMLF = new CAppiMLF();

	if (m_pcAppiMLF != NULL)
	{
		ptrMLFAppInterface = m_pcAppiMLF;
		bReturn = TRUE;
	}
	return bReturn;
}

#endif //JAVA_SDK
/* -----------------------------------------------------------------------------
END OF FILE appibase.h
------------------------------------------------------------------------------*/

