/*! \file 

Copyright (C) Siemens AG 1994-2003  ALL RIGHTS RESERVED

  This software is protected by the inclusion of the above copyright
  notice. This software may not be provided or otherwise made available
  to, or used by, any other person. No title to or ownership of the
  software is  hereby  transferred.
  The information contained in this document is considered the
  CONFIDENTIAL and PROPRIETARY information of Siemens AG and may
  not be disclosed or discussed with anyone who is not employed by
  Siemens AG, unless the individual / company
  (i) has an express need to know such information, and
  (ii) disclosure of information is subject to the terms of a duly
  executed Confidentiality and Non-Disclosure Agreement between
  Siemens AG and the individual / company.

.AUTHOR zhang qi fan(ICM.MP.VC(beijing))

.FILENAME LocalizationClass.cpp

.VERSION 01.00.00

.DATE 2003-10-22

.SHORT_DESCR:   Localization Class and APIs

.SW_COMPONENT:  SMTK EMULATOR

.SW_TYPE 

.CHANGE_CONTROL 
Version  Date        Changed by
         Reason of change

01.00.00 2003-10-22 zhang qi fan(ICM.MP.VC(beijing))          
01.00.00 2004-02-19 zhang qi fan(ICM.MP.VC(beijing))          
         Localization interface upgrade
02.00.00 2004-08-11 Fang Yunchao(PEK)          
         Remove a bug
*/
#ifdef LOCALIZATION_SUPPORT

#include "localizationclass.h"
#include "LocalizationCtrl.h"

CLocalizationString::CLocalizationString(void)
{
}

CLocalizationString::~CLocalizationString(void)
{
}

CLocalizationString::CLocalizationString(UINT nID)
{
	this->LoadString(nID);
}

BOOL CLocalizationString::LoadString(UINT nID)
{
#ifdef _UNICODE
	return  CLocalizationCtrlInterface::LoadStringWC(nID,*this);
#else
	return  CLocalizationCtrlInterface::LoadString(nID,*this);
#endif
}

void CLocalizationString::Format(UINT nFormatID,...)
{
	CString strFormat;
	strFormat.LoadString(nFormatID);
	
	va_list argList;
	va_start( argList, nFormatID );
	FormatV( strFormat, argList );
	va_end( argList );	
}


const CLocalizationString& CLocalizationString::operator=(const CLocalizationString& stringSrc)
{
	CString::Format(stringSrc);
	return *this;
}

const CLocalizationString& CLocalizationString::operator=(LPCTSTR lpsz)
{
	CString::Format(lpsz);
	return *this;
}


const CLocalizationString& CLocalizationString::operator=(TCHAR ch)
{
	CString::Format(ch);	
	return *this;
}

BOOL CLocalizationDialog::Create(UINT nIDTemplate, CWnd* pParentWnd)
{
	m_nTemplID = nIDTemplate;
	return Create(MAKEINTRESOURCE(nIDTemplate), pParentWnd);
}

BOOL CLocalizationDialog::Create(LPCTSTR lpszTemplateName, CWnd* pParentWnd)
{
	BOOL res = CLocalizationCtrlInterface::QueryModelessDialog(m_nTemplID,this,pParentWnd);	
	m_pParent = pParentWnd;
//	if(!res)
//		return FALSE;
//	res = CDialog::Create(lpszTemplateName,pParentWnd);	
	return res;
}

CLocalizationDialog::CLocalizationDialog(LPCTSTR lpszTemplateName, CWnd* pParentWnd)
{
	CDialog::CDialog(lpszTemplateName,pParentWnd);
	m_pParent = pParentWnd;
}

CLocalizationDialog::CLocalizationDialog(UINT nIDTemplate, CWnd* pParentWnd)
//					:CDialog(nIDTemplate,pParentWnd)
{
	CDialog::CDialog(nIDTemplate,pParentWnd);
	m_nTemplID = nIDTemplate;
	m_pParent = pParentWnd;
}

BOOL CLocalizationDialog::ExecuteDlgInit(LPCTSTR lpszResourceName)
{
	// find resource handle
	LPVOID lpResource = NULL;
	HGLOBAL hResource = NULL;
	if (lpszResourceName != NULL)
	{
//		HINSTANCE hInst = CLocalizationCtrlInterface::GetCurrentLoadedResourceInstance();
//		HRSRC hDlgInit = ::FindResource(hInst, lpszResourceName, RT_DLGINIT);
//		if (hDlgInit != NULL)
//		{
			// load it
//			hResource = LoadResource(hInst, hDlgInit);
//			if (hResource == NULL)
//				return FALSE;
			// lock it
//			lpResource = LockResource(hResource);
//			ASSERT(lpResource != NULL);
//		}
		hResource = CLocalizationCtrlInterface::GetDialogInitIformation(lpszResourceName);
		lpResource = lpResource = LockResource(hResource);;
	}

	// execute it
	BOOL bResult = CWnd::ExecuteDlgInit(lpResource);

	// cleanup
	if (lpResource != NULL && hResource != NULL)
	{
		UnlockResource(hResource);
		FreeResource(hResource);
	}
	return bResult;
}

INT_PTR CLocalizationDialog::DoModal()
{	
	CLocalizationCtrlInterface::QueryModelDialog(m_nTemplID,this,m_pParent);	
	INT_PTR res = CDialog::DoModal();
	UINT TemplID = m_nTemplID;
//	AFX_ZERO_INIT_OBJECT(CDialog);	
	m_lpDialogTemplate = NULL;
	return res;
}

#include <afxpriv.h>
BOOL AFXAPI AfxHelpEnabled()
{
	if (AfxGetApp() == NULL)
		return FALSE;

	// help is enabled if the app has a handler for ID_HELP
	AFX_CMDHANDLERINFO info;

	// check main window first
	CWnd* pWnd = AfxGetMainWnd();
	if (pWnd != NULL && pWnd->OnCmdMsg(ID_HELP, CN_COMMAND, NULL, &info))
		return TRUE;

	// check app last
	return AfxGetApp()->OnCmdMsg(ID_HELP, CN_COMMAND, NULL, &info);
}

BOOL CLocalizationDialog::OnInitDialog()
{
	// execute dialog RT_DLGINIT resource
	BOOL bDlgInit;
	if (m_lpDialogInit != NULL)
		bDlgInit = CWnd::ExecuteDlgInit(m_lpDialogInit);
	else
		//bDlgInit = ExecuteDlgInit(m_lpszTemplateName);
		bDlgInit = ExecuteDlgInit(MAKEINTRESOURCE(m_nTemplID));

	if (!bDlgInit)
	{
		TRACE(traceAppMsg, 0, "Warning: ExecuteDlgInit failed during dialog init.\n");
		EndDialog(-1);
		return FALSE;
	}

	// transfer data into the dialog from member variables
	if (!UpdateData(FALSE))
	{
		TRACE(traceAppMsg, 0, "Warning: UpdateData failed during dialog init.\n");
		EndDialog(-1);
		return FALSE;
	}

	// enable/disable help button automatically
	CWnd* pHelpButton = GetDlgItem(ID_HELP);
	if (pHelpButton != NULL)
		pHelpButton->ShowWindow(AfxHelpEnabled() ? SW_SHOW : SW_HIDE);

	return TRUE;    // set focus to first one
}

BOOL CLocalizationMenu::LoadMenu(UINT nIDResource)
{
	BOOL res = CLocalizationCtrlInterface::LoadMenu(nIDResource,this);
	return res;
}


BOOL CLocalizationToolBar :: LoadToolBar(UINT nResID)
{
	return LoadToolBar(MAKEINTRESOURCE(nResID));
}

BOOL CLocalizationToolBar :: LoadToolBar(LPCTSTR lpszResourceName)
{
	BOOL res = CLocalizationCtrlInterface::LoadToolBar(lpszResourceName,this);
	if(!res)
		return FALSE;
	res = LoadBitmap(lpszResourceName);
	return res;
}

BOOL CLocalizationToolBar::LoadBitmap(LPCTSTR lpszResourceName)
{	
	HBITMAP hBm = CLocalizationCtrlInterface::LoadBitmap(lpszResourceName);
	if(!hBm)
		return FALSE;
	if(!AddReplaceBitmap(hBm))
		return FALSE;

	m_hInstImageWell = CLocalizationCtrlInterface::GetCurrentLoadedResourceInstance();
	m_hRsrcImageWell = CLocalizationCtrlInterface::GetCurrentLoadedResourceHandle();
	return TRUE;
}

CLocalizationToolBar::CLocalizationToolBar()
{
}


BOOL CLocalizationPropertyPage::Create(UINT nIDTemplate, CWnd* pParentWnd)
{
	m_nTemplID = nIDTemplate;
	return Create(MAKEINTRESOURCE(nIDTemplate), pParentWnd);
}

BOOL CLocalizationPropertyPage::Create(LPCTSTR lpszTemplateName, CWnd* pParentWnd)
{
	BOOL res = CLocalizationCtrlInterface::QueryModelessDialog(m_nTemplID,this,pParentWnd);	
	return res;
}

CLocalizationPropertyPage::CLocalizationPropertyPage()
{	
	CPropertyPage::CPropertyPage();
}

CLocalizationPropertyPage::CLocalizationPropertyPage(LPCTSTR lpszTemplateName, UINT nIDCaption,DWORD dwSize)
{
	CPropertyPage::CPropertyPage(lpszTemplateName, nIDCaption,dwSize);
}

CLocalizationPropertyPage::CLocalizationPropertyPage(UINT nIDTemplate, UINT nIDCaption,DWORD dwSize)
{
	m_nTemplID = nIDTemplate;
	CPropertyPage::CPropertyPage(nIDTemplate, nIDCaption,dwSize);
}

#endif
