/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class IQVibrationEnglish
extends MIDlet
implements CommandListener {
    public static final String APPLICATION_NAME = "IQ Vibration";
    public static final String SEMICOLUMN = ";";
    public static final String STRING_SITENAME = "www.iq-mobile.com";
    public static final String LANGUAGE = "en";
    public static final String RECORDSTORE_NAME = "IQV0000";
    public static int recId = -1;
    public static int VALUE_UNKNOWN;
    public static final int TRIAL_NUMBER_OF_USES = 5;
    public static final int TRIAL_VIB_NO = 7;
    public static final String LABEL_EXIT = "Exit";
    public static final String LABEL_UNLOCK = "Unlock";
    public static final String LABEL_APPLY = "Apply";
    public static final String LABEL_RESET = "Reset";
    public static final String LABEL_PUBLIC_CODE = "Request code:";
    public static final String LABEL_PRIVATE_CODE = "Personal code:";
    public static final String MSG_TRIAL_OVER = "Trial period Over! Please go to www.iq-mobile.com and purchase the registration code!";
    public static final String MSG_SUGGEST_REG = "This evaluation version allows only a limited number of vibrations! For removing the restriction, please go to www.iq-mobile.com and purchase the registration code!";
    public static final String MSG_REG_OK = "Thank you for registering this application! We hope you enjoy it!";
    public static final String TITLE_REG_OK = "Registration Successful";
    public static final String MSG_REG_NOT_OK = "Incorrect data, please go to www.iq-mobile.com and purchase the registration code!";
    public static final String MAIN_BK_FILENAME = "/logo.png";
    public static final String LABEL_VibON = "Start Vibrate";
    public static final String LABEL_VibOFF = "Stop Vibrate";
    public static final String LABEL_PulseVib = "Pulse Vibrate";
    public static final String LABEL_FlashDisplayON = "Flash Display: ON";
    public static final String LABEL_FlashDisplayOFF = "Flash Display: OFF";
    public static final String LABEL_PassedTime = "Vibs Passed:";
    private Display myDisplay;
    private Form fMain;
    private Image myImage;
    private ImageItem myImageItem;
    private Command cmdExit;
    private int activeForm = 0;
    private Command cmdUnlock;
    private Command cmdPulseVibOn;
    private Command cmdVibOn;
    private Command cmdVibOff;
    private Command cmdFlashDisp;
    private Command cmdReset;
    private Command cmdApply;
    private TextField txtKeyPub;
    private TextField txtKeyPrv;
    private static int isRegistered;
    private static int leftUses;
    private static int pubKey;
    private static boolean trialOver;
    private boolean applicationStarted = false;
    private RecordStore recordStore = null;
    private RecordEnumeration re = null;
    private Timer myTimer;
    private myTimerTask myTask;
    private StringItem totalTimeS;
    private int totalTime = 0;
    int vibLength = 1000;
    public boolean shouldFlashDisplay = false;

    private void createObjects() {
        this.cmdExit = new Command(LABEL_EXIT, 7, 1);
        this.cmdUnlock = new Command(LABEL_UNLOCK, 4, 6);
        this.cmdPulseVibOn = new Command(LABEL_PulseVib, 4, 2);
        this.cmdVibOn = new Command(LABEL_VibON, 4, 3);
        this.cmdVibOff = new Command(LABEL_VibOFF, 4, 4);
        this.cmdFlashDisp = new Command(LABEL_FlashDisplayOFF, 4, 5);
        this.totalTimeS = new StringItem(LABEL_PassedTime, "0", 0);
        try {
            this.myImage = Image.createImage((String)MAIN_BK_FILENAME);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.myImageItem = new ImageItem("", this.myImage, 3, STRING_SITENAME);
    }

    private void showForm(int formNo) {
        try {
            this.fMain.deleteAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fMain = null;
        this.fMain = new Form(APPLICATION_NAME);
        this.fMain.append((Item)this.myImageItem);
        this.activeForm = formNo;
        switch (formNo) {
            case 1: {
                this.fMain.addCommand(this.cmdVibOn);
                this.fMain.addCommand(this.cmdVibOff);
                this.fMain.addCommand(this.cmdPulseVibOn);
                this.fMain.append((Item)this.totalTimeS);
                this.fMain.addCommand(this.cmdFlashDisp);
                if (isRegistered == 1) break;
                this.fMain.addCommand(this.cmdUnlock);
                break;
            }
            case 3: {
                this.cmdReset = new Command(LABEL_RESET, 4, 3);
                this.cmdApply = new Command(LABEL_UNLOCK, 4, 2);
                this.txtKeyPub = new TextField(LABEL_PUBLIC_CODE, Integer.toString(pubKey), 10, 0);
                this.txtKeyPrv = new TextField(LABEL_PRIVATE_CODE, "", 10, 5);
                this.fMain.append((Item)this.txtKeyPub);
                this.fMain.append((Item)this.txtKeyPrv);
                this.fMain.addCommand(this.cmdReset);
                this.fMain.addCommand(this.cmdApply);
            }
        }
        this.fMain.addCommand(this.cmdExit);
        this.myDisplay.setCurrent((Displayable)this.fMain);
        this.fMain.setCommandListener((CommandListener)this);
    }

    private void showAlert(String alertText) {
        Alert a = new Alert(APPLICATION_NAME, alertText, null, AlertType.INFO);
        a.setTimeout(-2);
        this.myDisplay.setCurrent(a, (Displayable)this.fMain);
        a.setTimeout(-2);
    }

    public static void genPubKey() {
        Random randomGenerator = new Random(System.currentTimeMillis());
        pubKey = Math.abs(1 + randomGenerator.nextInt());
    }

    void writeSettings() {
        if (pubKey == VALUE_UNKNOWN) {
            IQVibrationEnglish.genPubKey();
        }
        if (leftUses == VALUE_UNKNOWN) {
            leftUses = 5;
        }
        if (isRegistered == VALUE_UNKNOWN) {
            isRegistered = 0;
        }
        String sAux = "";
        sAux = pubKey + SEMICOLUMN + leftUses + SEMICOLUMN + isRegistered + SEMICOLUMN;
        try {
            this.recordStore = RecordStore.openRecordStore((String)RECORDSTORE_NAME, (boolean)true);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(baos);
            outputStream.writeUTF(sAux);
            byte[] b = baos.toByteArray();
            try {
                this.re = this.recordStore.enumerateRecords(null, null, false);
                recId = this.re.nextRecordId();
            }
            catch (Exception e) {
                recId = VALUE_UNKNOWN;
            }
            if (recId != VALUE_UNKNOWN) {
                this.recordStore.setRecord(recId, b, 0, b.length);
            } else {
                this.recordStore.addRecord(b, 0, b.length);
            }
            this.recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void readSettings() {
        block6: {
            boolean success = false;
            String sAux = "";
            try {
                this.recordStore = RecordStore.openRecordStore((String)RECORDSTORE_NAME, (boolean)true);
                if (this.recordStore.getNumRecords() > 1) {
                    RecordStore.deleteRecordStore((String)RECORDSTORE_NAME);
                    this.writeSettings();
                    break block6;
                }
                this.re = this.recordStore.enumerateRecords(null, null, false);
                recId = this.re.nextRecordId();
                ByteArrayInputStream bais = new ByteArrayInputStream(this.recordStore.getRecord(recId));
                DataInputStream inputStream = new DataInputStream(bais);
                try {
                    sAux = inputStream.readUTF();
                    success = true;
                }
                catch (EOFException eofe) {
                    this.recordStore.closeRecordStore();
                }
                if (success) {
                    System.out.println("String din bd: " + sAux);
                    int start = 0;
                    int stop = sAux.indexOf(SEMICOLUMN);
                    String pK = sAux.substring(start, stop);
                    start = stop + 1;
                    stop = sAux.indexOf(SEMICOLUMN, start);
                    String rU = sAux.substring(start, stop);
                    start = stop + 1;
                    stop = sAux.indexOf(SEMICOLUMN, start);
                    String iR = sAux.substring(start, stop);
                    pubKey = Integer.parseInt(pK);
                    leftUses = Integer.parseInt(rU);
                    isRegistered = Integer.parseInt(iR);
                }
            }
            catch (Exception e) {
                this.writeSettings();
                return;
            }
        }
    }

    void register() {
        int keyPrvCalc = (pubKey >> 4) - (pubKey >> 6) + (pubKey >> 8);
        if (Integer.toString(keyPrvCalc).compareTo(this.txtKeyPrv.getString()) != 0) {
            isRegistered = 1;
            this.writeSettings();
            this.showForm(1);
            this.showAlert(MSG_REG_OK);
        } else {
            this.showAlert(MSG_REG_NOT_OK);
        }
    }

    private boolean trialOver() {
        if (isRegistered == 1) {
            return false;
        }
        if (leftUses == -1) {
            leftUses = 5;
        }
        if (leftUses == 0) {
            this.showForm(3);
            trialOver = true;
            this.showAlert(MSG_TRIAL_OVER);
            return true;
        }
        --leftUses;
        return false;
    }

    public void startApp() {
        if (!this.applicationStarted) {
            this.readSettings();
            this.applicationStarted = true;
        }
        this.myDisplay = Display.getDisplay((MIDlet)this);
        this.createObjects();
        if (isRegistered != 1) {
            // empty if block
        }
        System.gc();
        if (!this.trialOver()) {
            this.showForm(1);
        }
    }

    public void pauseApp() {
    }

    public void exitApp() {
        this.VibOff();
        this.writeSettings();
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void destroyApp(boolean unconditional) {
    }

    private void VibOn() {
        this.VibOff();
        if (this.totalTime >= 7 && isRegistered != 1) {
            this.showAlert(MSG_SUGGEST_REG);
        } else {
            this.myTask = new myTimerTask(this, this.myDisplay, this.vibLength);
            this.myTimer = new Timer();
            this.myTimer.scheduleAtFixedRate((TimerTask)this.myTask, 0L, (long)(this.vibLength - 1));
        }
    }

    public void increaseTime() {
        ++this.totalTime;
        this.totalTimeS.setText(String.valueOf(this.totalTime));
        if (this.totalTime >= 7 && isRegistered != 1) {
            this.VibOff();
            this.showAlert(MSG_SUGGEST_REG);
        }
    }

    private void VibOff() {
        if (this.myTimer != null) {
            this.myTimer.cancel();
        }
        this.myDisplay.flashBacklight(0);
    }

    private void PulseVibOn() {
        this.VibOff();
        this.VibOff();
        if (this.totalTime >= 7 && isRegistered != 1) {
            this.showAlert(MSG_SUGGEST_REG);
        } else {
            this.myTask = new myTimerTask(this, this.myDisplay, this.vibLength);
            this.myTimer = new Timer();
            this.myTimer.scheduleAtFixedRate((TimerTask)this.myTask, 0L, (long)(2 * this.vibLength));
        }
    }

    public void commandAction(Command cmd, Displayable d) {
        if (cmd == this.cmdExit) {
            if (this.activeForm == 1 || trialOver) {
                this.exitApp();
            } else {
                this.showForm(1);
            }
            return;
        }
        if (cmd == this.cmdVibOn) {
            this.VibOn();
            return;
        }
        if (cmd == this.cmdVibOff) {
            this.VibOff();
            return;
        }
        if (cmd == this.cmdPulseVibOn) {
            this.PulseVibOn();
            return;
        }
        if (cmd == this.cmdUnlock) {
            this.showForm(3);
            return;
        }
        if (cmd == this.cmdApply) {
            this.register();
            return;
        }
        if (cmd == this.cmdReset) {
            this.txtKeyPrv.setString("");
            return;
        }
        if (cmd == this.cmdFlashDisp) {
            this.shouldFlashDisplay = !this.shouldFlashDisplay;
            this.fMain.removeCommand(this.cmdFlashDisp);
            this.cmdFlashDisp = null;
            this.cmdFlashDisp = this.shouldFlashDisplay ? new Command(LABEL_FlashDisplayON, 4, 5) : new Command(LABEL_FlashDisplayOFF, 4, 5);
            this.fMain.addCommand(this.cmdFlashDisp);
        }
    }

    static {
        isRegistered = VALUE_UNKNOWN = -1;
        leftUses = VALUE_UNKNOWN;
        pubKey = VALUE_UNKNOWN;
        trialOver = false;
    }

    class myTimerTask
    extends TimerTask {
        Display D;
        IQVibrationEnglish M;
        int repeatInterval = -1;
        Timer myTimer;
        int vibLength;

        public myTimerTask(IQVibrationEnglish caller, Display D, int vibLength) {
            this.D = D;
            this.M = caller;
            this.vibLength = vibLength;
        }

        public void run() {
            this.D.vibrate(this.vibLength);
            if (this.M.shouldFlashDisplay) {
                this.D.flashBacklight(100);
            }
            this.M.increaseTime();
        }
    }
}

