/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Random;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.ImageItem;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Spacer;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class IQTalkingClock
extends MIDlet
implements CommandListener {
    public static final String APPLICATION_NAME = "IQ Talking Clock";
    public static final String STRING_SITENAME = "www.iq-mobile.com";
    public static final String LABEL_EXIT = "Exit";
    public static final String LABEL_SAYTIME = "SayTime";
    public static final String LABEL_TIME = "Adjust Time";
    public static final String LABEL_UNLOCK = "Unlock";
    public static final String LABEL_RESET = "Reset";
    public static final String LABEL_APPLY = "Apply";
    public static final String LABEL_HOUR = "Hour:";
    public static final String LABEL_MINUTE = "Minute:";
    public static final String LABEL_PUBLIC_CODE = "Request code:";
    public static final String LABEL_PRIVATE_CODE = "Personal code:";
    public static final String LANGUAGE = "en";
    public static final String MSG_TRIAL_OVER = "Trial period Over! Please go to www.iq-mobile.com and purchase the registration code!";
    public static final String MSG_REG_OK = "Thank you for registering this application! We hope you enjoy it!";
    public static final String TITLE_REG_OK = "Registration Successful";
    public static final String MSG_REG_NOT_OK = "Incorrect data, please go to www.iq-mobile.com and purchase the registration code!";
    public static final String MAIN_BK_FILENAME = "/clock.png";
    public static final String SET_BK_FILENAME = "/clockset.png";
    public static final String REG_BK_FILENAME = "/clockreg.png";
    public static final int TRIAL_NUMBER_OF_USES = 4;
    public static final String RECORDSTORE_NAME = "M";
    public static int recId = -1;
    private Display myDisplay;
    private Form fMain;
    private Image myImage;
    private ImageItem myImageItem;
    private int activeForm = 1;
    private Command cmdExit;
    private Command cmdAdjTime;
    private Command cmdUnlock;
    private Command cmdSayTime;
    private StringItem strCurrentTime;
    private Spacer mySpacer;
    private Command cmdClose;
    private Command cmdReset;
    private Command cmdApply;
    private TextField txtKeyPub;
    private TextField txtKeyPrv;
    private int minDif = 0;
    private int hourDif = 0;
    private int minCur = 0;
    private int hourCur = 0;
    private static int isRegistered = -1;
    private static int leftUses = -1;
    private static int pubKey = -1;
    private static boolean trialOver = false;
    private RecordStore recordStore = null;
    private RecordEnumeration re = null;

    public void startApp() {
        this.myDisplay = Display.getDisplay((MIDlet)this);
        this.fMain = new Form(APPLICATION_NAME);
        this.myDisplay.setCurrent((Displayable)this.fMain);
        this.fMain.setCommandListener((CommandListener)this);
        this.readSettings();
        if (!this.trialOver()) {
            this.writeSettings();
            this.showForm(1);
        } else {
            this.showForm(3);
            trialOver = true;
        }
    }

    private void showForm(int n) {
        this.activeForm = n;
        this.fMain.deleteAll();
        this.fMain.removeCommand(this.cmdExit);
        this.fMain.removeCommand(this.cmdAdjTime);
        this.fMain.removeCommand(this.cmdUnlock);
        this.fMain.removeCommand(this.cmdSayTime);
        this.fMain.removeCommand(this.cmdClose);
        this.fMain.removeCommand(this.cmdReset);
        this.fMain.removeCommand(this.cmdApply);
        this.getCurrentTime();
        switch (n) {
            case 1: {
                this.cmdSayTime = new Command(LABEL_SAYTIME, 4, 1);
                this.cmdExit = new Command(LABEL_EXIT, 7, 1);
                this.cmdAdjTime = new Command(LABEL_TIME, 4, 2);
                this.cmdUnlock = new Command(LABEL_UNLOCK, 4, 3);
                try {
                    this.myImage = Image.createImage((String)MAIN_BK_FILENAME);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.myImageItem = new ImageItem("", this.myImage, 3, STRING_SITENAME);
                String string = "\n" + Integer.toString(this.validHour(this.hourCur + this.hourDif)) + ":" + Integer.toString(this.validMinute(this.minCur + this.minDif));
                this.strCurrentTime = new StringItem(null, string);
                this.strCurrentTime.setLayout(3);
                this.fMain.addCommand(this.cmdExit);
                this.fMain.addCommand(this.cmdAdjTime);
                this.fMain.addCommand(this.cmdSayTime);
                if (isRegistered == 0) {
                    this.fMain.addCommand(this.cmdUnlock);
                }
                this.fMain.append((Item)this.myImageItem);
                IQWavPlayer iQWavPlayer = new IQWavPlayer();
                IQreadTime iQreadTime = new IQreadTime(this.validHour(this.hourCur + this.hourDif), this.validMinute(this.minCur + this.minDif), LANGUAGE, iQWavPlayer);
                break;
            }
            case 2: {
                this.cmdClose = new Command(LABEL_EXIT, 7, 1);
                this.cmdReset = new Command(LABEL_RESET, 4, 3);
                this.cmdApply = new Command(LABEL_APPLY, 4, 2);
                try {
                    this.myImage = Image.createImage((String)SET_BK_FILENAME);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.myImageItem = new ImageItem("", this.myImage, 3, STRING_SITENAME);
                this.txtKeyPub = new TextField(LABEL_HOUR, Integer.toString(this.validHour(this.hourCur + this.hourDif)), 2, 5);
                this.txtKeyPrv = new TextField(LABEL_MINUTE, Integer.toString(this.validMinute(this.minCur + this.minDif)), 2, 5);
                this.fMain.append((Item)this.myImageItem);
                this.fMain.append((Item)this.txtKeyPub);
                this.fMain.append((Item)this.txtKeyPrv);
                this.fMain.addCommand(this.cmdClose);
                this.fMain.addCommand(this.cmdReset);
                this.fMain.addCommand(this.cmdApply);
                break;
            }
            case 3: {
                this.cmdClose = new Command(LABEL_EXIT, 7, 1);
                this.cmdReset = new Command(LABEL_RESET, 4, 3);
                this.cmdApply = new Command(LABEL_UNLOCK, 4, 2);
                try {
                    this.myImage = Image.createImage((String)REG_BK_FILENAME);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.myImageItem = new ImageItem("", this.myImage, 3, STRING_SITENAME);
                this.txtKeyPub = new TextField(LABEL_PUBLIC_CODE, Integer.toString(pubKey), 10, 5);
                this.txtKeyPrv = new TextField(LABEL_PRIVATE_CODE, "", 10, 5);
                this.fMain.append((Item)this.myImageItem);
                this.fMain.append((Item)this.txtKeyPub);
                this.fMain.append((Item)this.txtKeyPrv);
                this.fMain.addCommand(this.cmdClose);
                this.fMain.addCommand(this.cmdReset);
                this.fMain.addCommand(this.cmdApply);
            }
        }
    }

    void emptyRS() {
        System.out.println("EmptyRS");
        try {
            this.recordStore = RecordStore.openRecordStore((String)RECORDSTORE_NAME, (boolean)true);
            this.re = this.recordStore.enumerateRecords(null, null, false);
            while (this.re.hasNextElement()) {
                recId = this.re.nextRecordId();
                this.recordStore.deleteRecord(recId);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    void readSettings() {
        Object object;
        Object object2;
        System.out.println("READING SETTINGS");
        boolean bl = false;
        String string = "";
        try {
            this.recordStore = RecordStore.openRecordStore((String)RECORDSTORE_NAME, (boolean)true);
            this.re = this.recordStore.enumerateRecords(null, null, false);
            int n = this.recordStore.getNumRecords();
            if (n > 1) {
                this.emptyRS();
            }
            System.out.println("Citit RECID=" + recId);
            recId = this.re.nextRecordId();
            object2 = new ByteArrayInputStream(this.recordStore.getRecord(recId));
            object = new DataInputStream((InputStream)object2);
            try {
                string = ((DataInputStream)object).readUTF();
                bl = true;
            }
            catch (EOFException eOFException) {
                this.recordStore.closeRecordStore();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            try {
                System.out.println("String din bd: " + string);
                int n = 0;
                int n2 = string.indexOf(";");
                String string2 = string.substring(n, n2);
                n = n2 + 1;
                n2 = string.indexOf(";", n);
                object2 = string.substring(n, n2);
                n = n2 + 1;
                n2 = string.indexOf(";", n);
                object = string.substring(n, n2);
                n = n2 + 1;
                n2 = string.indexOf(";", n);
                String string3 = string.substring(n, n2);
                n = n2 + 1;
                n2 = string.length();
                String string4 = string.substring(n, n2);
                pubKey = Integer.parseInt(string2);
                leftUses = Integer.parseInt((String)object2);
                isRegistered = Integer.parseInt((String)object);
                this.minDif = Integer.parseInt(string4);
                this.hourDif = Integer.parseInt(string3);
                System.out.println("La citire am obtinut: " + this.hourDif + ":" + this.minDif);
            }
            catch (Exception exception) {
                this.writeSettings();
            }
        } else {
            System.out.println("!Success");
            this.writeSettings();
        }
    }

    void writeSettings() {
        System.out.println("WRITING SETTINGS");
        String string = "";
        if (pubKey == -1) {
            IQTalkingClock.genPubKey();
            string = pubKey + ";" + 4 + ";0;0;0";
        } else if (leftUses == -1) {
            leftUses = 4;
        }
        string = pubKey + ";" + leftUses + ";" + isRegistered + ";" + this.hourDif + ";" + this.minDif;
        System.out.println("La scriere bag: " + string);
        try {
            this.recordStore = RecordStore.openRecordStore((String)RECORDSTORE_NAME, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(string);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            try {
                this.re = this.recordStore.enumerateRecords(null, null, false);
                recId = this.re.nextRecordId();
            }
            catch (Exception exception) {
                recId = -1;
            }
            if (recId != -1) {
                this.recordStore.setRecord(recId, byArray, 0, byArray.length);
            } else {
                this.recordStore.addRecord(byArray, 0, byArray.length);
            }
            this.recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("nu am reusit sa scriu in bd" + exception.toString());
        }
    }

    public static void genPubKey() {
        Random random = new Random(System.currentTimeMillis());
        pubKey = Math.abs(1 + random.nextInt());
    }

    void getCurrentTime() {
        Calendar calendar = Calendar.getInstance();
        this.hourCur = calendar.get(10);
        this.minCur = calendar.get(12);
    }

    int validHour(int n) {
        if (n <= 0) {
            n += 12;
        }
        if (n > 12) {
            n -= 12;
        }
        return n;
    }

    int validMinute(int n) {
        if (n < 0) {
            n += 60;
        }
        if (n > 59) {
            n -= 60;
        }
        return n;
    }

    void changeTime() {
        int n;
        int n2;
        boolean bl = false;
        try {
            n2 = Integer.parseInt(this.txtKeyPub.getString());
            n = Integer.parseInt(this.txtKeyPrv.getString());
        }
        catch (Exception exception) {
            n2 = this.hourCur;
            n = this.minCur;
        }
        if (n2 > 24 || n2 < 0 || n > 59 || n < 0) {
            this.hourDif = 0;
            this.txtKeyPub.setString(Integer.toString(this.validHour(this.hourCur + this.hourDif)));
            this.minDif = 0;
            this.txtKeyPrv.setString(Integer.toString(this.validMinute(this.minCur + this.minDif)));
        } else {
            this.minDif = n - this.minCur;
            this.hourDif = n2 - this.hourCur;
            this.writeSettings();
            this.showForm(1);
        }
    }

    private boolean trialOver() {
        System.out.println("Is registered=" + isRegistered);
        System.out.println("Left Uses=" + leftUses);
        System.out.println("Is registered=" + isRegistered);
        if (isRegistered == 1) {
            return false;
        }
        if (leftUses == -1) {
            leftUses = 4;
        }
        if (leftUses == 0) {
            this.showAlert(MSG_TRIAL_OVER);
            return true;
        }
        --leftUses;
        return false;
    }

    void register() {
        int n = (pubKey >> 4) - (pubKey >> 6) + (pubKey >> 8);
        if (Integer.toString(n).compareTo(this.txtKeyPrv.getString()) != 0) {
            isRegistered = 1;
            this.writeSettings();
            this.showAlert(MSG_REG_OK);
            this.startApp();
        } else {
            this.showAlert(MSG_REG_NOT_OK);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.cmdExit) {
            this.exitApp();
        } else if (command == this.cmdAdjTime) {
            this.showForm(2);
        } else if (command == this.cmdUnlock) {
            this.showForm(3);
        } else if (command == this.cmdClose) {
            if (!trialOver) {
                this.showForm(1);
            } else {
                this.exitApp();
            }
        } else if (command == this.cmdReset) {
            if (this.activeForm == 2) {
                this.hourDif = 0;
                this.minDif = 0;
                this.writeSettings();
                this.txtKeyPub.setString(Integer.toString(this.validHour(this.hourCur + this.hourDif)));
                this.txtKeyPrv.setString(Integer.toString(this.validMinute(this.minCur + this.minDif)));
            } else if (this.activeForm == 3) {
                this.txtKeyPrv.setString("");
            }
        } else if (command == this.cmdApply) {
            if (this.activeForm == 2) {
                this.changeTime();
            } else {
                this.register();
            }
        } else if (command == this.cmdSayTime) {
            IQWavPlayer iQWavPlayer = new IQWavPlayer();
            IQreadTime iQreadTime = new IQreadTime(this.validHour(this.hourCur + this.hourDif), this.validMinute(this.minCur + this.minDif), LANGUAGE, iQWavPlayer);
        }
    }

    private void showAlert(String string) {
        Alert alert = new Alert(APPLICATION_NAME, string, null, AlertType.WARNING);
        alert.setTimeout(-2);
        this.myDisplay.setCurrent(alert, (Displayable)this.fMain);
    }

    public void pauseApp() {
    }

    public void exitApp() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void destroyApp(boolean bl) {
    }
}

