/**
 *       Copyright (C) Danish Wireless Design A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Danish Wireless
 * Design A/S. Passing on and copying of this document, use and communication
 * of its contents is not permitted without prior written authorisation.
 *
 * Description:  This files contains the interface description for
* production test dll for all the DWD platform.
 *
 * Revision Information:
 *   File name: \dwdtools\Phonetool\src\dwdptest.h
 *   Version: \main\21
 *   Date: 2003-12-10 16:42:48
 *   Comment:
 *     Updated to Version 9.5
 */

/* Defines for 16 bit and 32 bit integers: */
#define int16 short int
#define int32 int
#define DLL_HANDLE 2


#define DWD_SET_IF_FREQ_1696MHZ(handle) DWD_set_rf_channel(  dwd_tx_arfcn_tp, 512, handle )
#define DWD_SET_IF_FREQ_1712MHZ(handle) DWD_set_rf_channel(  dwd_tx_arfcn_tp, 790, handle )

#define DWD_RTC_TIME_STRING_LENGTH 8
#define DWD_RTC_DATE_STRING_LENGTH 10


/*--------------- WAP defines -----------------*/
#define DWD_WAP_SETTINGS_SIZE          5
#define DWD_WAP_FAVORITES_SIZE        10
#define DWD_WAP_PROXYNAME_SIZE        15
#define DWD_WAP_URL_SIZE             150
#define DWD_WAP_IP_ADDRESS_SIZE       16
#define DWD_WAP_LOGIN_NAME_SIZE       30
#define DWD_WAP_LOGIN_PASSWORD_SIZE   30
#define DWD_WAP_DIALUP_NUMBER_SIZE    30
#define DWD_WAP_FAVORITES_NAME_SIZE   30
/*---------------------------------------------*/
/*--------------- security defines ------------*/
#define DWD_MAX_NOF_PERS_CODE  8
#define DWD_MP_MCC_NOF_DIGITS 3
#define DWD_MP_MNC_NOF_DIGITS 3
#define DWD_MP_MSIN_NOF_DIGITS 2
#define DWD_MP_GIDX_MAX_NOF_DIGITS 20
#define DWD_MP_IMSI_NOF_DIGITS 16
#define DWD_MAX_NOF_DIGITS_IN_CONTROL_KEY 16
#define DWD_MIN_NOF_DIGITS_IN_CONTROL_KEY  6
/*---------------------------------------------*/
#define MMI_GREETING_TEXT_LENGTH	32




/*---------------------------------------------*/
/* Enumerations and types                      */
/*---------------------------------------------*/
enum dwd_rf_band
{
  dwd_gsm_900,
  dwd_dcs_1800,
  dwd_gsm_850,
  dwd_pcs_1900
};

enum dwd_rf_bands_support
{
  dwd_900_1800 = 0,
  dwd_850_1900,
  dwd_900_1800_1900,
  dwd_850_900_1800_1900
};

enum dwd_result_codes
{
  dwd_error,
  dwd_ok
};

enum dwd_test_modes
{
  dwd_in_line_mode,
  dwd_calib_mode,
  dwd_mmi_mode
};

enum dwd_rf_modes
{
  dwd_rx_cont,
  dwd_tx_cont,
  dwd_rx_burst,
  dwd_tx_burst,
  dwd_mon_burst,
  dwd_rxtxmon,
  dwd_stop,
};

enum dwd_arfcn_tps
{
  dwd_rx_arfcn_tp,
  dwd_tx_arfcn_tp,
  dwd_mon_arfcn_tp
};

enum dwd_gain_tps
{
  dwd_rx_gain_tp,
  dwd_mon_gain_tp,
  dwd_rx_2_gain_tp,
  dwd_rx_3_gain_tp,
  dwd_rx_4_gain_tp
};

enum dwd_ramp_mode
{
  dwd_external_pa_ramp,
  dwd_internal_pa_ramp,
};

enum dwd_gmsk_modes
{
   dwd_high   /* all ones*/,
   dwd_random /* all random*/,
   dwd_normal /*normal burst including training sequence*/,
   dwd_edge_high,
   dwd_edge_random,
   dwd_edge_normal,
   dwd_edge_low,
   dwd_low

};

enum dwd_config_tp
{
  dwd_original_config,
  dwd_updated_config
};

enum dwd_test_station_tp
{
  dwd_in_line,
  dwd_calib,
  dwd_mmi
};

enum dwd_tag_parms
{
	dwd_logo,
	dwd_language,
	dwd_custom,
	dwd_contrast,
	dwd_greeting,
    dwd_wap
};

enum dwd_ch_high_low_tps
{
  dwd_low_ch,
  dwd_high_ch,
  dwd_mid_low_ch,
  dwd_mid_high_ch
};

typedef enum
{
  dwd_audio_mode_normal,
  dwd_audio_mode_headset,
  dwd_audio_mode_handsfree
} dwd_audio_mode_type;

typedef enum {
  dwd_normal_mode,
  dwd_not_applicable,
  dwd_ptest_mode
} dwd_mode_type;

typedef enum{
  dwd_at_hash_on,
  dwd_at_hash_off
}dwd_v24_mode_type;
		
typedef enum
{
	DWD_BAUDRATE_1200,
	DWD_BAUDRATE_2400,
	DWD_BAUDRATE_4800,
	DWD_BAUDRATE_9600,
	DWD_BAUDRATE_19200,
	DWD_BAUDRATE_38400,
	DWD_BAUDRATE_57600,
	DWD_BAUDRATE_115200,
	DWD_BAUDRATE_230400,
	DWD_BAUDRATE_460800
}dwd_baud_rate_type;

typedef enum
{
  dwd_rtc_setting_ok,
  dwd_rtc_setting_invalid,
}dwd_rtc_result_type;


typedef enum
{
	RING_TONE1 = 0,
	RING_TONE2,
	RING_TONE3,
	RING_TONE4,
	RING_TONE5,
	RING_TONE6,
	RING_TONE7,
	RING_TONE8,
	RING_TONE9,
	RING_TONE10,
	RING_TONE11,
	RING_TONE12,
	RING_TONE13,
	RING_TONE14,
	RING_TONE15,
	RING_TONE16,
	RING_TONE17,
	RING_TONE18,
	RING_TONE19,
	RING_TONE20,
	RING_TONE21,
	RING_TONE22,
	RING_TONE23,
	RING_TONE24,
	RING_TONE25,
	RING_TONE26,
	RING_TONE27,
	RING_TONE28,
	RING_TONE29,
	RING_TONE30,
	RING_TONE31,
	RING_TONE32,
	RING_TONE33,
	RING_TONE34,
	RING_TONE35,
	RING_TONE36,
	RING_TONE37,
	RING_TONE38,
	RING_TONE39,
	RING_TONE40,
	RING_TONE41,
	RING_TONE42,
	RING_TONE43,
	RING_TONE44,
	RING_TONE45,
	RING_TONE46,
	RING_TONE47,
	RING_TONE48,
	RING_TONE_OWN1,
	RING_TONE_OWN2,
} dwd_ring_tone_type;

typedef enum
{
	RING_VOLUME1 = 0,
	RING_VOLUME2,
	RING_VOLUME3,
	RING_VOLUME4,
	RING_VOLUME5,
} dwd_ring_volume_type;

typedef enum
{
	ALERT_TYPE_LIGHT_ONLY = 0,
	ALERT_TYPE_MELODY,
	ALERT_TYPE_VIBRATION,
	ALERT_TYPE_VIBRA_MELODY,
} dwd_alert_type;

typedef enum
{
	KEYPAD_TONE_OFF = 0,
	KEYPAD_TONE_TONE,
	KEYPAD_TONE_BEEP,
} dwd_keypad_tone_type;

typedef enum
{
	MSG_TONE_SMS1 = 0,
	MSG_TONE_SMS2,
	MSG_TONE_SMS3,
	MSG_TONE_SMS4,
	MSG_TONE_SMS5,
	MSG_TONE_SMS6,
	MSG_TONE_SMS7,
	MSG_TONE_SMS8,
	MSG_TONE_SMS9,
	MSG_TONE_SMS10,
	MSG_TONE_LIGHT_ONLY,
	MSG_TONE_VIBRATION,
} dwd_msg_tone_type;

typedef enum
{
	BACK_LIGHT_OFF = 0,
	BACK_LIGHT_SHORT,
	BACK_LIGHT_LONG,
} dwd_back_light_type;

typedef enum
{
  dwd_no_fcb_sb_found,
  dwd_only_fcb_found,
  dwd_fcb_sb_found
} dwd_wrk_fcb_sb_result_type;

typedef enum
{
  dwd_trx_gprs = 0,
  dwd_trx_egprs
} dwd_trx_mode;

typedef enum
{
  dwd_led_blue = 0,
  dwd_led_red,
  dwd_led_green,
  dwd_led_blue_red,
  dwd_led_blue_green,
  dwd_led_red_green,
  dwd_led_red_blue_green,
  dwd_led_nof_colors
} dwd_led_color_type;

typedef enum
{
  dwd_rach_tsc_0 = 0,
  dwd_rach_tsc_1 = 1,
  dwd_rach_tsc_2 = 2
} dwd_tsc_type;

typedef enum
{
  dwd_rach_ab_8    = 15,
  dwd_rach_ab_11   = 16,
  dwd_rach_ab_11_e = 17
} dwd_block_format_type;

typedef enum
{
  dwd_prach_chn = 12,
  dwd_rach_chn = 13
} dwd_channel_type;


enum
{
  dwd_treat_1800_as_1800 = 0,
  dwd_treat_1800_as_1900 = 1
};

enum dwd_ee_opcode
{
  dwd_get_tag_parms_offset,
  dwd_reset_p_lock,
  dwd_read_p_lock,
  dwd_enable_p_lock,
  dwd_reset_s_lock,
  dwd_read_s_lock,
  dwd_enable_s_lock,
  dwd_read_pers,
  dwd_write_pers,
  dwd_reset_pers,
  dwd_reset_dyn_nv_to_default
};

enum dwd_lcd_opcode
{
  dwd_send_instruction_data,
  dwd_send_display_data,
  dwd_first_v_ram_data,
  dwd_intermediate_v_ram_data,
  dwd_last_v_ram_data,
  dwd_lcd_start_demo,
  dwd_lcd_stop_demo,
  dwd_lcd_read_register,
  dwd_lcd_write_register,
  dwd_lcd_set_pixel,
  dwd_lcd_max_opcodes
};

enum dwd_ffs_opcode
{
  dwd_findfirst,
  dwd_findnext,
  dwd_get_file_info,
  dwd_create,
  dwd_get_free_id,
  dwd_open,
  dwd_close,
  dwd_read,
  dwd_write,
  dwd_delete,
  dwd_file_exists,
  dwd_clean_flash,
  dwd_initialize,
  dwd_deactivate,
  dwd_close_cb,
  dwd_create_cb,
  dwd_write_cb,
  dwd_read_cb,
  dwd_append,
  dwd_append_cb,
  dwd_modify,
  dwd_modify_cb,
  dwd_delete_cb,
  dwd_rename,
  dwd_rename_cb,
  dwd_get_nof_files,
  dwd_get_nof_files_by_type,
  dwd_get_free_space,
  dwd_get_free_space_by_type,
  dwd_get_free_space_in_global_pool,
  dwd_get_raw_free_space_by_type,
  dwd_get_raw_free_space_in_global_pool,
  dwd_create_static,
  dwd_create_static_cb,
  dwd_get_free_static_space,
  dwd_get_file_name,
  dwd_get_file_id,
  dwd_copy_cb,
  dwd_load_to_lfa_cb,
  dwd_get_lfa_ref,
  dwd_get_lfa_info,
  dwd_read_lfa_data,
  dwd_create_factory_default,
  dwd_create_factory_default_cb,
  dwd_restart,
  dwd_restore_factory_default,
  dwd_restore_factory_default_cb,
  dwd_ffs_get_version,
  dwd_ffs_get_revision,
  dwd_ffs_get_parameters,
  dwd_ffs_get_features,
  dwd_get_reserved_space_by_type,
  dwd_get_reserved_space_in_global_pool,
  dwd_get_used_space,
  dwd_get_used_space_by_type,
  dwd_get_used_space_in_global_pool,
  dwd_calculate_file_overhead
};

enum dwd_features_present_codes
{
  dwd_none                      =0,
  dwd_ffs_present               =2,
  dwd_bt_present                =4,
  dwd_mmc_present               =8,
  dwd_aud_ma2_present           =16,
  dwd_aud_ma3_present           =32,
  dwd_fm_radio_present          =64,
  dwd_mpeg3_present             =128,
  dwd_voicerec_present          =256,
  dwd_l1_workbench_present      =512,
  dwd_wap_present               =1024,
  dwd_cam_present		=2048,
  dwd_edge_present              =4096,
  dwd_led_backlight_present     =8192,
  dwd_irda_present              =16384
};

enum dwd_aud_opcode
{
   dwd_vms_record,
   dwd_vms_play,
   dwd_vms_stop,
   dwd_vms_check_status,
   dwd_set_uplink_path,
   dwd_get_uplink_path,
   dwd_set_downlink_path,
   dwd_get_downlink_path,
   dwd_set_I2Sx_config,
   dwd_get_I2Sx_config,
   dwd_set_audio_mixing,
   dwd_get_audio_mixing,
   dwd_set_pcm_channel,
   dwd_get_pcm_channel,
   dwd_set_dsp_parameters,
   dwd_get_dsp_parameters,
   dwd_set_afe_parameters,
   dwd_get_afe_parameters, //17

   dwd_vm_stop_recording,
   dwd_vm_stop_playback,

   dwd_allocate_resource,
   dwd_release_resource,
   dwd_key_tone,

   dwd_speech_enable,
   dwd_speech_disable,  
   dwd_speech_set_volume ,
   dwd_speech_mute, 

   dwd_vibrator_start, 
   dwd_vibrator_stop, 

   dwd_amp_enable,
   dwd_amp_disable, //30

   dwd_tone_start,
   dwd_tone_start_user_tone,
   dwd_tone_stop,

   dwd_ringer_start, 
   dwd_ringer_start_user_tone,
   dwd_ringer_stop, 
   dwd_ringer_suspend,
   dwd_ringer_stop_suspend,
   dwd_ringer_resume,
   dwd_ringer_set_volume ,
   dwd_ringer_set_channel_volume,

   dwd_info_driver_status,
   dwd_info_hw_available,

   dwd_misc_set_accessory,
   dwd_init_resource_table,

   dwd_fetch_EGOLD_variables1,
   dwd_fetch_SGOLD_variables1,

   dwd_fetch_dsp_buf,
   dwd_ringer_start_user_tone2, 
   dwd_create_fr_FFS, //50
   dwd_open_read_DS_FFS,
   dwd_open_write_DS_FFS,
   dwd_create_AMR_FFS,
   dwd_delete_FFS_file,
   dwd_close_FFS,
   dwd_vms_record_mtest,
   dwd_vms_play_mtest,
   dwd_vms_stop_mtest,
   dwd_vms_check_status_mtest,
   dwd_vm_stop_recording_mtest,
   dwd_vm_stop_playback_mtest,

   dwd_set_dai_mode,
   dwd_get_dai_mode,
   dwd_set_pcm_routing,
   dwd_get_pcm_routing,
   
   dwd_update_paths, //66

   dwd_enum_end
};


enum dwd_afr_opcode
{
  dwd_afr_start,
  dwd_afr_stop,
  dwd_afr_mute,
  dwd_afr_set_station,
  dwd_afr_read_current_status,
  dwd_afr_read_config,
  dwd_afr_write_config
};

enum
{
  dwd_not_allowed,		/* not allowed in search mode */
  dwd_level_5,			/* low; level ADC output = 5.*/
  dwd_level_7,			/* mid; level ADC output = 7.*/
  dwd_level_10			/* high; level ADC output = 10.*/
};

enum
{
  dwd_off,			/* Station preset */
  dwd_manualUp,			/* Manual one step up */
  dwd_manualDown,		/* Manual one step down */
  dwd_autoUp,			/* Auto seek up */
  dwd_downAuto			/* Auto seek down */
};

enum
{
  dwd_afr_mono,
  dwd_afr_stereo
};

enum dwd_cam_opcode
{ 
  dwd_cam_sensor_wr,
  dwd_cam_sensor_rd,
  dwd_cam_vc_wr_data,
  dwd_cam_vc_rd_data,
  dwd_cam_viewfinder,
  dwd_cam_freeze_picture,
  dwd_cam_lcd_transparent,
  dwd_cam_start_preview_mode1,
  dwd_cam_start_preview_mode2,
  dwd_cam_start_preview_mode3,
  dwd_cam_stop_preview,
  dwd_cam_sleep,
  dwd_cam_status,
  dwd_cam_take_picture,
  dwd_cam_get_jpeg_file_size,
  dwd_cam_get_jpeg_picture,
  dwd_cam_put_jpeg_picture,
  dwd_cam_max_opcodes
};
 
enum dwd_start_preview_mode
{
  dwd_preview_mode1,
  dwd_preview_mode2,
  dwd_preview_mode3
}; 	

enum dwd_chr_generic
{
  dwd_chr_get_main_control_status,
  dwd_chr_get_measurement_control_status,
  dwd_chr_get_charger_control_status,
  dwd_chr_get_capacity_control_status
};

enum dwd_gtb_opcode
{
  dwd_gtb_transfer_ffs_file_to_ram_1,
  dwd_gtb_store_ram_1_data_to_ffs_file,
  dwd_gtb_transfer_ffs_file_to_ram_2,
  dwd_gtb_store_ram_2_data_to_ffs_file,
  dwd_reprog_dsp_patch
};
 	
enum dwd_baseband_present_codes
{
  dwd_bb_none = 0,
  dwd_egold_plus_v1_2 = 2,
  dwd_egold_v3 = 4,
  dwd_sgold = 8,
  dwd_sgold_lite = 16,
  dwd_sglite_v1_1 = 32,
  dwd_egold_lite = 64
};

enum DWD_rf_present_codes
{
  dwd_rf_none = 0,
  dwd_smarti_plus_b1 = 2,
  dwd_smarti_plus_c1 = 4,
  dwd_smarti_plus_c2 = 8,
  dwd_smarti_dc = 16,
  dwd_smarti_dc_plus_v1 = 32,
  dwd_smarti_dc_plus_v2 = 64,
  dwd_smarti_sd = 128,
  dwd_smarti_sd8 = 256,
  dwd_smarti_sd9 = 512
};

enum dwd_acc_opcode
{
   dwd_acc_type,
   dwd_acc_status
};

enum dwd_vib_opcode
 {
   dwd_vib_start,
   dwd_vib_stop,
   dwd_vib_pause,
   dwd_vib_status
 };

enum dwd_umts_fdd_test_mode
{
  dwd_umts_fdd_non_sig_mode,
  dwd_umts_fdd_sig_mode
};

enum dwd_mmci_opcode
{ 
  dwd_mmci_initialize,
  dwd_mmci_deactivate,
  dwd_mmci_open,
  dwd_mmci_close,
  dwd_mmci_create,
  dwd_mmci_create_cb,
  dwd_mmci_write,
  dwd_mmci_write_cb,
  dwd_mmci_read,
  dwd_mmci_read_cb,
  dwd_mmci_append,
  dwd_mmci_append_cb,
  dwd_mmci_delete,
  dwd_mmci_delete_cb,
  dwd_mmci_rename,
  dwd_mmci_rename_cb,
  dwd_mmci_make_dir,
  dwd_mmci_make_dir_cb,
  dwd_mmci_remove_dir,
  dwd_mmci_remove_dir_cb,
  dwd_mmci_change_dir,
  dwd_mmci_get_dir,
  dwd_mmci_file_exists,
  dwd_mmci_findfirst,
  dwd_mmci_findnext,
  dwd_mmci_get_file_info,
  dwd_mmci_get_free_space
};


/*---------------------------------------------*/
/* Structures and types                        */
/*---------------------------------------------*/
/* WAP..init..type's for the EEP_static */
typedef struct
{
	unsigned char  /*WCHAR*/      proxyname[2*DWD_WAP_PROXYNAME_SIZE];
	char			              url[DWD_WAP_URL_SIZE];
	unsigned char  /*WCHAR*/      ip_address[2*DWD_WAP_IP_ADDRESS_SIZE];
	unsigned char  /*WCHAR*/      login_name[2*DWD_WAP_LOGIN_NAME_SIZE];
	unsigned char  /*WCHAR*/      login_password[2*DWD_WAP_LOGIN_PASSWORD_SIZE];
	unsigned char  /*WCHAR*/      dialup_number[2*DWD_WAP_DIALUP_NUMBER_SIZE];
	char           /*BOOLEAN */   security;
	char           /*BOOLEAN */   data_call_type;
} dwd_wap_settings_init_type;

typedef struct
{
	unsigned char  /*WCHAR*/      name[2*DWD_WAP_FAVORITES_NAME_SIZE];
	char                          url[DWD_WAP_URL_SIZE];
} dwd_wap_favorites_init_type;

typedef struct
{
  dwd_wap_settings_init_type default_wap_settings[DWD_WAP_SETTINGS_SIZE];
  dwd_wap_favorites_init_type default_wap_favorites[DWD_WAP_FAVORITES_SIZE];
} dwd_wap_init_type;

typedef struct
{
  unsigned int16 greeting_msg[MMI_GREETING_TEXT_LENGTH+1];
} dwd_greeting_type;

typedef struct
{
  signed int16 /*dwd_ring_tone_type*/   ring_tone;
  signed int16 /*dwd_ring_volume_type*/ ring_volume;
  signed int16 /*dwd_alert_type*/       alert_type;
  signed int16 /*dwd_keypad_tone_type*/ keypad_tone;
  signed int16 /*dwd_msg_tone_type*/    msg_tone;
  signed int16 /*dwd_ring_tone_type*/   alarm_tone;
  char   /*Boolean*/   error_tone;
  char   /*Boolean*/   minute_minder;
  char   /*Boolean*/   connect_tone;
  char   /*Boolean*/   broadcast_enabled;
  signed int16 /*dwd_back_light_type*/  back_light;
  char   /*Boolean*/   service_light;
  char   /*Boolean*/   auto_redial;
  char   /*Boolean*/   active_flip;
  char   /*Boolean*/   anykey_answer;
  unsigned char        reserved[30];
} dwd_custom_settings_type;

typedef struct
{
   unsigned char   ch_tp;  /* channel type SDCCH4, SDCCH8, TCH-F */
   unsigned char   hopping; /* 1 if hopping - else 0 */
   unsigned int16  arfcn;
   unsigned char   tn;
   unsigned char   tsc;
   unsigned char   sub_ch;  /* sdcch sub channel */
} dwd_msl_dedic_chan_descr_type;

typedef struct
{
   dwd_msl_dedic_chan_descr_type ch_descr;
   unsigned char                 ch_mode; /* sig-only, FR, EFR */
   unsigned char                 ciphering_mode;  /* none, A51, A52 */
   unsigned char                 nof_ho_attempts; /*This counts the number of handovers attempted since power on*/
   unsigned char                 nof_ho_failure; /*This counts the number of failed handovers since power on*/
}  dwd_msl_dedic_descr_type;

typedef struct
{
  unsigned char  length;
  unsigned int16 ba_list[32];
} dwd_msl_ba_list_type;

typedef struct
{
  unsigned int16 arfcn;
  unsigned char  tn;
  unsigned char  dsc;
} dwd_msl_idle_mode_data_type;

typedef struct
{
  unsigned char     rxlev_full;
  unsigned char     rxlev_sub;
  unsigned char     rxqual_full;
  unsigned char     rxqual_sub;
  unsigned char     dtx_u;
  unsigned char     txpwr;
  unsigned char     ta;
  unsigned char     rlf;
} dwd_msl_dedic_scell_meas_type;

typedef struct
{
   unsigned int16  arfcn;
   unsigned char   bsic;   /* If not yet decoded it should be set to i.e. 0xFF so this it easy to identify */
   unsigned char   rxlev;
} dwd_msl_idle_scell_meas_type;

typedef struct
{
   unsigned int16  arfcn;
   unsigned char   bsic;   /* If not yet decoded it should be set to i.e. 0xFF so this it easy to identify */
   unsigned char   rxlev;
} dwd_msl_ncell_meas_elem_type;

typedef struct
{
  unsigned char                 no_ncells;
  dwd_msl_ncell_meas_elem_type	ncell_meas[8];
} dwd_msl_ncell_meas_type;

typedef signed char dwd_rxlev_offset_table_type[70];

typedef signed char dwd_ch_comp_rxlev_offset_table_type[8];

typedef struct
{
   signed char rampup;
   signed char rampdown;
} dwd_pa_timing_elm_type;

typedef dwd_pa_timing_elm_type  pa_timing_offset_table_type[16];

typedef signed int16 dwd_pa_offset_comp_table_type[16];

typedef struct
{
  signed int16 pa_ch_comp0;
  signed int16 pa_ch_comp1;
  signed int16 pa_ch_comp2;
  signed int16 pa_ch_comp3;
}dwd_pa_ch_comp_elm_type;

typedef dwd_pa_ch_comp_elm_type pa_ch_comp_type[16];

typedef struct
{
  signed char pa_temp_comp0;
  signed char pa_temp_comp1;
  signed char pa_temp_comp2;
  signed char pa_temp_comp3;
  signed char pa_temp_comp4;
}dwd_pa_temp_comp_elm_type;

typedef dwd_pa_temp_comp_elm_type pa_temp_comp_type[16];


typedef unsigned char dwd_pa_vhome_offset_comp_table_type[16];

typedef struct
{
  signed int16 vbat_gain;
  signed int16 vbat_offset;
  signed int16 tbat_gain;
  signed int16 tbat_offset;
  signed int16 tenv_gain;
  signed int16 tenv_offset;
  signed int16 btec_gain;
  signed int16 btec_offset;
  signed int16 tvco_gain;
  signed int16 tvco_offset;
} dwd_adc_adjusted_comp_parms_type;

typedef struct
{
  signed int16   vbat_adc_value;  /* Used for battery voltage */
  signed int16   tbat_adc_value;  /* Used for detection of external equipment */
  signed int16   tenv_adc_value;  /* Used for RF temperature  */
  signed int16   btec_adc_value;  /* Used for battery ID */
  signed int16   tvco_adc_value;  /* Not used in Neon */
  signed int16   curr_adc_value;  /* Used in SGOLD */
} dwd_adc_meas_type;

typedef struct
{
  unsigned int16 default_dac_value;
  unsigned int16 dac_step_gsm_in_hz;
} dwd_afc_comp_type;

typedef struct
{
   signed char imei[16];
   unsigned int32 serial_number;
} dwd_ms_id_type;

typedef struct
{
  unsigned int16 id;
  unsigned int16 hw_version;
  unsigned char eep_version;
  unsigned char eep_revision;

} dwd_config_type;

typedef dwd_config_type dwd_updated_config_type;
typedef dwd_config_type dwd_original_config_type;

typedef struct
{
  unsigned int16 result;
  unsigned int16 nof_tests;
  unsigned int16 version;
  unsigned int16 sw_version;
  unsigned int16 spec;
  unsigned int16 testsite_id;
} dwd_test_station_type;

typedef dwd_test_station_type dwd_inline_test_type;
typedef dwd_test_station_type dwd_calib_test_type;
typedef dwd_test_station_type dwd_mmi_test_type;

typedef struct
{
  unsigned char year;
  unsigned char month;
  unsigned char week;
  unsigned char day;
} dwd_production_date_type;

typedef struct
{
  unsigned int16 param_1;
  unsigned int16 param_2;
  unsigned int16 param_3;
  unsigned int16 param_4;
  unsigned int16 param_5;
  unsigned int16 param_6;
  unsigned int16 param_7;
  unsigned int16 param_8;
  unsigned int16 param_9;
} dwd_customer_parm_type;

typedef struct
{
  unsigned int32           serial_no;
  unsigned int16           testseries_id;
  dwd_config_type          orig_conf;
  dwd_config_type          upd_conf;
  dwd_test_station_type    in_line;
  dwd_test_station_type    calib;
  dwd_test_station_type    mmi;
  dwd_production_date_type date;
  dwd_customer_parm_type   cust_parms;
} dwd_production_parm_type;

typedef struct
{
  unsigned int16 static_size;
  unsigned int16 dynamic_size;
  unsigned int16 org_version;
  unsigned long eep_start_addr;
  unsigned int16 upd_revision;
} dwd_get_eep_info_type;

typedef struct
{
 unsigned int16 gsm900_ch_array[6];
 unsigned int16 dcs1800_ch_array[8];
 unsigned int16 gsm850_ch_array[6];
 unsigned int16 pcs1900_ch_array[8];
}dwd_ch_array_type;

typedef struct
{
   dwd_msl_idle_mode_data_type	    msl_idle_mode_data;
   dwd_msl_idle_scell_meas_type     msl_idle_scell_meas;
   dwd_msl_dedic_descr_type         msl_dedic_descr;
   dwd_msl_dedic_scell_meas_type    msl_dedic_scell_meas;
   dwd_msl_ncell_meas_type          msl_ncell_meas;
   dwd_msl_ba_list_type             msl_ba_list;
   unsigned int16                   l1_state;
} dwd_ms_log_type;

typedef struct
{
  unsigned char number[20];
} dwd_pn_type;

typedef unsigned char dwd_rtc_time_type[DWD_RTC_TIME_STRING_LENGTH + 1];
typedef unsigned char dwd_rtc_date_type[DWD_RTC_DATE_STRING_LENGTH + 1];

typedef struct
{
  unsigned char string[30];
} dwd_sp_test_approval_type;

typedef struct
{
 unsigned char string[10];
} dwd_hw_ver_string_type;

typedef struct
{
  unsigned char return_code;
  char  MUTE; /*boolean: If MUTE = 1, then L and R audio muted. If MUTE = 0, then audio not muted.*/
  signed char SSL;	/* Search Stop Level.*/
  char 	HLSI; /*Boolean : HIGH/LOW Side Injection. If HLSI = 1, then HIGH side LO injection. If HLSI = 0, then LOW side LO injection.*/
  char	MS; /*Boolean:	 Mono/Stereo. If MS = 1, then forced mono. If MS = 0, then stereo ON.*/
  char	ML;	/* Boolean: Mute Left. If ML = 1, then left audio channel muted and forced mono. If ML = 0, then not muted.*/
  char	MR;	/* Boolean: Mute Right. If MR = 1, then right audio channel muted and forced mono. If MR = 0, then not muted.*/
  char	BL;	/* Boolean: Band Limits. If BL = 1, then Japan FM band. If BL = 0, then US/Europe FM band.*/
  char	HCC; /* Boolean: High Cut Control. If HCC = 1, then high cut control is ON. If HCC = 0, then high cut control is OFF.*/
}dwd_afr_config_data_type;

typedef struct
{
  unsigned char return_code;
  unsigned char signal_level;
  unsigned int frequency;
  char stereo;
}dwd_afr_read_current_status_type;

typedef struct
{
  unsigned char key[16];
} dwd_cust_key_type;


typedef struct
{
 unsigned int16 reg;
 unsigned int16 value;
} dwd_cam_reg_type;

/*-------------------------------------------------------------------------*/
/*----------------------- S-GOLD Workbench struct -------------------------*/
typedef enum
{
  through_txrach = 0, 
  through_corach = 1 
}dwd_rach_type;  /* T_ATCTST_RACH_TYPE;*/

typedef enum
{
   dwd_loopback_decoded_block,
   dwd_loopback_burst_by_burst
} dwd_loopback_mode_type; /* T_DWD_LOOPBACK_MODE_TYPE; */

typedef struct /*T_DWD_HOPPING_RF_s*/
{
  unsigned char  maio;
  unsigned char  hsn;
}dwd_hopping_rf; /*T_DWD_HOPPING_RF;*/


typedef struct /*T_DWD_SINGLE_RF_s*/
{
  unsigned short  arfcn;
}dwd_single_rf; /*T_DWD_SINGLE_RF;*/


typedef enum
{
  single_rf,
  hopping_rf
}dwd_chn_selpresent; /*T_DWD_CHN_SELPresent; */

typedef struct /*T_DWD_CHN_SEL_s*/
{
  dwd_chn_selpresent chn_selpresent; /*T_DWD_CHN_SELPresent Present;*/
  union
  {
   dwd_single_rf single_rf; /*T_DWD_SINGLE_RF  single_rf;*/
   dwd_hopping_rf hopping_rf; /*T_DWD_HOPPING_RF  hopping_rf;*/
  } U;
}dwd_chn_sel;/*T_DWD_CHN_SEL;*/

typedef struct /*T_DWD_CHANNEL_DESCRIPTION_s*/
{
  dwd_chn_sel       chan_sel; /*T_DWD_CHN_SEL  chan_sel;*/
  unsigned char     channel_type;
  unsigned char     subchannel;
  unsigned short    timeslot_no;
  unsigned char     tsc;
}dwd_channel_description; /*T_DWD_CHANNEL_DESCRIPTION;*/

typedef struct
{
  unsigned short  A[64];
}dwd_ma_field; /*T_DWD_MA_FIELD;*/


typedef struct /*T_DWD_MOBILE_ALLOCATION_s*/
{
  unsigned short  rf_chan_cnt;
  dwd_ma_field    rf_chan_no; /*T_DWD_MA_FIELD   rf_chan_no;*/
}dwd_mobile_allocation; /*T_DWD_MOBILE_ALLOCATION;*/


typedef struct /*T_DWD_L1_CHANNEL_ELEM_s*/
{
  dwd_channel_description description; /*T_DWD_CHANNEL_DESCRIPTION  description;*/
  dwd_mobile_allocation   frequency_list; /*T_DWD_MOBILE_ALLOCATION    frequency_list;*/
} dwd_l1_channel_elem; /*T_DWD_L1_CHANNEL_ELEM;*/

typedef struct
{
  unsigned int16 A[8];
} dwd_timeslot_source; /*T_DWD_TIMESLOT_SOURCE; */

typedef struct
{
  unsigned int16 modul;
  signed int16	ioffs;
  signed int16  qoffs;
  unsigned int16 rms;
  signed int16 toffs;
  unsigned int16 berl;
  unsigned int16 berh;
  signed int16 foffs;
}dwd_equ_data; /*T_ATCTST_EQU_DATA*/


typedef unsigned int16  dwd_timeslot_allocation; /*T_ATCTST_TIMESLOT_ALLOCATION;*/
typedef unsigned int16  dwd_radio_freq_no; /*T_ATCTST_RADIO_FREQ_NO; */

typedef unsigned short         dwd_radion_freq_no; /* T_ATCTST_RADIO_FREQ_NO; */
typedef unsigned char          dwd_txpwr; /* T_ATCTST_TXPWR; */

typedef struct /*T_ATCTST_AMR_CONFIG_s */
{
    unsigned char  acs;
    unsigned char amr_thrsh[6];
} dwd_amr_config_type;

typedef struct
{
 unsigned int16 id;
 unsigned char dsp_pipe;
 unsigned char nof_parms;
 unsigned int16 parms[22];  
}dwd_dsp_cmd_elm_type;

typedef dwd_dsp_cmd_elm_type dsp_cmd_type[1];

typedef struct
{
  unsigned char color[10];
  unsigned int16 total_time[10];
  unsigned int16 on_time[10];
} dwd_colorstream_type;

typedef struct
{
  signed int16       filter_in_1[5];
  signed int16       filter_in_2[5];
  signed int16       filter_out_1[5];
  signed int16       filter_out_2[5];

  signed int16       scal_in;
  signed int16       scal_out;
  signed int16       scal_mic;
  signed int16       scal_rec;
  signed int16       gain_out;
  signed int16       mic_mute_on;
  signed int16       side_tone_fact;
  signed int16       side_tone_val;
  signed int16       fill_1[4];
  signed int16       hf_on;
  signed int16       hf_analog_gain;
  signed int16       fill_2[3];
  signed int16       dtx_on;

  signed int16       mix_fact_speech;
  signed int16       mix_fact_tone;
  signed int16       hf_step_width;
  signed int16       hf_lms_length;
  signed int16       hf_lms_offset;
  signed int16       hf_block_length;
  signed int16       hf_rxtx_relation;
  signed int16       fill_3[3];
  signed int16       hf_add_atten;
  signed int16       hf_min_atten;
  signed int16       hf_max_atten;

  signed int16       vgtx;
  signed int16       mic_1_2_on; /* 0 = mic 1, otherwise mic 2 */

  signed int16       vg1_on;
  signed int16       vg2_on;
  signed int16       vg1rx;
  signed int16       vg2rx;

  unsigned char      aud_main_state;
  unsigned char      aud_buz_state;
  unsigned char      aud_ear_state;
  unsigned char      aud_mic_state;
  unsigned char      audio_mode;
}DWD_get_audio_data_con_type;


typedef enum 
{
  dwd_aud_handset_mic,
  dwd_aud_headset_mic,
  dwd_aud_I2S1_rx,  /*aud_bt_headset*/
  dwd_aud_uplink_source_end
}dwd_aud_uplink_source_enum;

typedef enum
{
  dwd_aud_normal_earpiece,
  dwd_aud_mono_headset,
  dwd_aud_stereo_headset,
  dwd_aud_backspeaker,
  dwd_aud_I2S1_tx, // Bluetooth
  dwd_aud_downlink_source_end
}dwd_aud_downlink_source_enum;

typedef struct
{
	bool earpiece;
        bool mono_headset;
        bool stereo_headset;
        bool accessory;
        bool back_speaker;
        bool voice_memo_in;
        bool i2s1_tx_bt_carkit;
        bool i2s2_tx;
        bool tty;
}DWD_SGOLD_downlink_data;

typedef struct
{
	bool handset;
	bool headset;
        bool voice_memo;
        bool i2s1_rx_bt;
        bool i2s2_rx;
        bool tty1;
}DWD_SGOLD_uplink_data;

typedef struct {
	signed int16 a0;
	signed int16 a1;
	signed int16 a2;
	signed int16 b1;
	signed int16 b2; 
}DWD_SGOLD_biquad_filters;

typedef struct {
/*	bool ep_pn1;
	bool ep_pa1;
	bool ep_ref;
	bool ep_pa2;
	bool dac1_r;
	bool dac1_l;
	bool dac2_r;
	bool dac2_l;
	bool dac3_r;
	bool dac3_l; 
*/
	bool vmicmode;
	signed int16 mic; 	// 0 - None
		  		// 1 - MIC1
		  		// 2 - MIC2
	bool veppn;
	signed int16 veppa;
	signed int16 rxgainpa;
	signed int16 outsel;
	signed int16 outsell;
	signed int16 rxgainlo;
	bool txgain0;
	bool txgain1;
	bool txgain2;
}DWD_SGOLD_AFE_params;

typedef struct {
	signed int16 duration;
	signed int16 freq1;
	signed int16 freq2;
	signed int16 freq3;
	signed int16 amp1;
	signed int16 amp2;
	signed int16 amp3;
}DWD_SGOLD_tonegen;

typedef struct {
	signed int16 on;
        signed int16 analog_gain;
        signed int16 lms_length;
        signed int16 step_width;
        signed int16 lms_offset;
        signed int16 block_length;
        signed int16 rxtx_relation;
        signed int16 add_atten;
        signed int16 min_atten;
        signed int16 max_atten;
        signed int16 nr_u_fak_0;
        signed int16 nr_sw_2;
        signed int16 nr_u_fak;
}DWD_SGOLD_handsfree;

typedef struct {
	signed int16 scal_in;
	signed int16 scal_mic;
	signed int16 mix_i2s1;
	signed int16 scal_out;
	signed int16 scal_rec;
	signed int16 mix_afe;
	signed int16 scal_sapp;
	signed int16 scal_ext;
	signed int16 side_ton;
	signed int16 gain_out;
	signed int16 delta0;
	signed int16 lambda0;
	signed int16 delta1;
	signed int16 ton_mix;
	signed int16 speech_mix;
	signed int16 kappa0;
	signed int16 kappa1;
	signed int16 lambda1;
	signed int16 alpha0;
	signed int16 alpha1;
	signed int16 gamma0;
	signed int16 mic_mute;
	signed int16 beta0;
	signed int16 beta1;
	signed int16 gamma1;
}DWD_SGOLD_dsp_params;

typedef struct {
	bool usehex;
	unsigned int volume_step;
	unsigned int dai_mode; 
	unsigned int i2s1_mode;
	unsigned int i2s2_mode;
}DWD_SGOLD_misc_params;


typedef struct {
	DWD_SGOLD_misc_params misc_params;
	DWD_SGOLD_dsp_params dsp_params;
	DWD_SGOLD_AFE_params afe_params;
	DWD_SGOLD_uplink_data uplink_data;
	DWD_SGOLD_downlink_data downlink_data;
	DWD_SGOLD_biquad_filters biquad_in1;
	DWD_SGOLD_biquad_filters biquad_in2;
	DWD_SGOLD_biquad_filters biquad_out1;
	DWD_SGOLD_biquad_filters biquad_out2;
	DWD_SGOLD_handsfree handsfree;
	DWD_SGOLD_tonegen tonegen;
}DWD_SGOLD_AUDIO_data;


/*-------------------------------------------------------------------------*/
/*----------------------- Functionns---------------------------------------*/
/*-------------------------------------------------------------------------*/

/*---------------------- Communication ------------------------------------*/
extern "C" __declspec(dllexport) bool DWD_set_com_port(unsigned char com_port, int *handle);
extern "C" __declspec(dllexport) bool DWD_close_com_port(int handle);
extern "C" __declspec(dllexport) bool DWD_check_comm_link(int handle);
extern "C" __declspec(dllexport) bool DWD_set_baud_rate(int baud, int handle);
extern "C" __declspec(dllexport) bool DWD_set_DTR(bool value, int handle); // "true" is the default value
extern "C" __declspec(dllexport) bool DWD_set_RTS(bool value, int handle); // "false" is the default value
extern "C" __declspec(dllexport) bool DWD_set_ms_baudrate(dwd_baud_rate_type baudrate, int handle);
extern "C" __declspec(dllexport) bool DWD_check_CTS(int handle);
/*-------------------------------------------------------------------------*/

/*---------------------- Test modes ---------------------------------------*/
extern "C" __declspec(dllexport) bool DWD_set_test_mode(unsigned int16 mode, unsigned int16 arfcn, int handle);  /* IN LINE, CALIB, MMI */
extern "C" __declspec(dllexport) bool DWD_set_v24_mode(dwd_v24_mode_type mode, int handle);
/*-------------------------------------------------------------------------*/

/*---------------------- Get feautures present in mobile ------------------*/
extern "C" __declspec(dllexport) bool DWD_features_present(unsigned int16 *features, int handle);

/*------------------------ ATE# 2 INLINE ----------------------------------*/
extern "C" __declspec(dllexport) bool DWD_set_rf_mode(unsigned int16 mode, int handle);
extern "C" __declspec(dllexport) bool DWD_set_rf_channel(unsigned int16 arfcn_tp, unsigned int16 arfcn, int handle);
extern "C" __declspec(dllexport) bool DWD_set_rf_gain(unsigned int16 gain_tp, signed char gain, int handle);
extern "C" __declspec(dllexport) bool DWD_get_iqrms( unsigned int16 *iqrms, int handle);
extern "C" __declspec(dllexport) bool DWD_change_pa_level( unsigned char txpwr, unsigned char txpwr2, int handle);
extern "C" __declspec(dllexport) bool DWD_set_gmsk_mode( unsigned int16 mode, unsigned int16 tsc /*training sequence*/,int handle);
extern "C" __declspec(dllexport) bool DWD_inl_set_nof_slot(unsigned char nof_tx_slot, int handle);
extern "C" __declspec(dllexport) bool DWD_inl_set_nof_rx_slot(unsigned char nof_rx_slot, int handle);
extern "C" __declspec(dllexport) bool DWD_inl_get_mult_rx_iqrms(unsigned int16 *iqrms, int handle);
extern "C" __declspec(dllexport) bool DWD_get_power_ramp(unsigned char band, unsigned int16 pa_level, unsigned int16 *ramp_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_get_edge_power_ramp(unsigned char band, unsigned int16 pa_level, unsigned int16 *ramp_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_inl_set_power_ramps(unsigned int16 *power_ramp1_ptr, unsigned int16 *power_ramp2_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_inl_set_power_ramp_mode(unsigned char mode, int handle);
extern "C" __declspec(dllexport) bool DWD_set_afc(unsigned int16 dac_value, int handle);
extern "C" __declspec(dllexport) bool DWD_store_afc(dwd_afc_comp_type *comp_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_get_afc(dwd_afc_comp_type *comp_ptr, int handle );
extern "C" __declspec(dllexport) bool DWD_meas_all_adc(dwd_adc_meas_type *meas_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_store_adc(dwd_adc_adjusted_comp_parms_type *comp_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_get_adc(dwd_adc_adjusted_comp_parms_type *comp_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_set_audio(bool on, unsigned char volume, int handle); // Volume must be in the interval [0;8]
extern "C" __declspec(dllexport) bool DWD_set_ear_piece(dwd_audio_mode_type mode, unsigned char volume, int handle);  // Volume must be in the interval [0;8]
extern "C" __declspec(dllexport) bool DWD_set_mic(dwd_audio_mode_type mode, int handle);
extern "C" __declspec(dllexport) bool DWD_set_charge_mode(unsigned char on, int handle);
extern "C" __declspec(dllexport) bool DWD_check_rtc(bool *result, int handle);
extern "C" __declspec(dllexport) bool DWD_get_rtc_date_time(dwd_rtc_date_type *date, dwd_rtc_time_type *time,int handle);
extern "C" __declspec(dllexport) bool DWD_program_rtc_date_time(dwd_rtc_date_type *date, dwd_rtc_time_type *time, dwd_rtc_result_type *result, int handle);

/*-------------------------------------------------------------------------*/

/*------------------------- ATE #3 Calibration & Test ---------------------*/
extern "C" __declspec(dllexport) bool DWD_dut_in_idle( bool *in_idle, int handle);
extern "C" __declspec(dllexport) bool DWD_get_rf_temp( signed char *rf_temp, int handle);
extern "C" __declspec(dllexport) bool DWD_get_pmb_temp_offset(signed int16 *rf_temp_offset, int handle);
extern "C" __declspec(dllexport) bool DWD_set_pmb_temp_offset(signed int16 rf_temp_offset, int handle);
extern "C" __declspec(dllexport) bool DWD_store_pmb_temp_offset(signed int16 rf_temp_offset, int handle);
extern "C" __declspec(dllexport) bool DWD_setup_emergency_call(int handle);
extern "C" __declspec(dllexport) bool DWD_clear_rxlev(int handle);
extern "C" __declspec(dllexport) bool DWD_get_rxlev(signed char *rxlev_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_store_rxlev_gain_offset(unsigned char band,dwd_rxlev_offset_table_type *rxlev_offsets_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_set_rxlev_gain_offset(unsigned char band,dwd_rxlev_offset_table_type *rxlev_offsets_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_get_rxlev_gain_offset(unsigned char band,dwd_rxlev_offset_table_type *rxlev_offsets_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_store_rxlev_ch_comp_offset(unsigned char band,dwd_ch_comp_rxlev_offset_table_type *rxlev_ch_offsets_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_set_rxlev_ch_comp_offset(unsigned char band,dwd_ch_comp_rxlev_offset_table_type *rxlev_ch_offsets_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_get_rxlev_ch_comp_offset(unsigned char band, dwd_ch_comp_rxlev_offset_table_type *rxlev_ch_offsets_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_get_rxlev_tmp_comp(signed char *tmp_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_store_rxlev_tmp_comp(unsigned char band, signed char *tmp_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_configure_rxlev_aq(unsigned char band, unsigned char nof_ch, unsigned int16 *ch_array, int handle);
extern "C" __declspec(dllexport) bool DWD_clear_rxlev_aq(int handle);
extern "C" __declspec(dllexport) bool DWD_get_rxlev_aq(signed char *rxlev_ptr, signed char error, int handle);
extern "C" __declspec(dllexport) bool DWD_stop_rxlev_aq(int handle);
extern "C" __declspec(dllexport) bool DWD_set_pa_offset(unsigned char band, unsigned int16 txpwr, signed int16 offset, int handle);
extern "C" __declspec(dllexport) bool DWD_set_max_pa_ch_comp(unsigned char band, unsigned char ch_high_low, signed char offset, int handle);
extern "C" __declspec(dllexport) bool DWD_set_vhome_offset(unsigned char band, unsigned int16  txpwr, unsigned char offset, int handle);
extern "C" __declspec(dllexport) bool DWD_set_pa_timing_offset(unsigned char band, unsigned int16 txpwr,signed char rampup_offset, signed char rampdown_offset, int handle);
extern "C" __declspec(dllexport) bool DWD_store_pa_offset(unsigned char band,dwd_pa_offset_comp_table_type *pa_offsets_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_get_pa_offset(unsigned char band,dwd_pa_offset_comp_table_type *pa_offsets_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_store_max_pa_ch_comp(unsigned char band, unsigned char ch_high_low, signed char offset, int handle);
extern "C" __declspec(dllexport) bool DWD_store_vhome_offset(unsigned char band,dwd_pa_vhome_offset_comp_table_type *vhome_offsets_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_get_vhome_offset(unsigned char band,dwd_pa_vhome_offset_comp_table_type *vhome_offsets_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_store_pa_timing_offset(unsigned char band,pa_timing_offset_table_type *timing_offsets_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_get_pa_timing_offset(unsigned char band,pa_timing_offset_table_type *timing_offsets_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_set_audio_loop(int handle);
extern "C" __declspec(dllexport) bool DWD_clear_audio_loop(int handle);
extern "C" __declspec(dllexport) bool DWD_store_audio_parms(signed int16 scal_in, signed int16 scal_out, int handle);
extern "C" __declspec(dllexport) bool DWD_get_audio_parms(signed int16 *scal_in, signed int16 *scal_out, int handle);
extern "C" __declspec(dllexport) bool DWD_verify_sim_connection( bool *sim_ok, int handle);
extern "C" __declspec(dllexport) bool DWD_get_max_pa_offsets(unsigned char band, unsigned int16 *max_pa_levels_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_get_max_pa_ch_comp(signed char *offset_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_get_pa_dac16_range(unsigned int16 band, unsigned char high_txpwr, unsigned char low_txpwr, unsigned int16 *result, unsigned int16 *data, int handle);
extern "C" __declspec(dllexport) bool DWD_treat_1800_as_1900(unsigned int16 mode, unsigned int handle);
extern "C" __declspec(dllexport) bool DWD_get_edge_pa_timing_offset( unsigned char band,pa_timing_offset_table_type *timing_offsets_ptr, int handle );
extern "C" __declspec(dllexport) bool DWD_store_edge_pa_timing_offset(unsigned char band, pa_timing_offset_table_type *timing_offsets_ptr,int handle);
extern "C" __declspec(dllexport) bool DWD_get_edge_pa_ch_comp(unsigned char band,pa_ch_comp_type *pa_ch_comp_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_store_edge_pa_ch_comp(unsigned char band,pa_ch_comp_type *pa_ch_comp_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_get_gmsk_pa_ch_comp(unsigned char band,pa_ch_comp_type *pa_ch_comp_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_store_gmsk_pa_ch_comp(unsigned char band,pa_ch_comp_type *pa_ch_comp_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_get_edge_pa_temp_comp(unsigned char band,pa_temp_comp_type *pa_temp_comp_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_store_edge_pa_temp_comp(unsigned char band,pa_temp_comp_type *pa_temp_comp_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_get_gmsk_pa_temp_comp(unsigned char band,pa_temp_comp_type *pa_temp_comp_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_store_gmsk_pa_temp_comp(unsigned char band,pa_temp_comp_type *pa_temp_comp_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_set_edge_pa_ch_comp(unsigned char band, unsigned int16 txpwr, dwd_pa_ch_comp_elm_type *offset, int handle );
extern "C" __declspec(dllexport) bool DWD_set_gmsk_pa_ch_comp(unsigned char band, unsigned int16 txpwr, dwd_pa_ch_comp_elm_type *offset, int handle );
extern "C" __declspec(dllexport) bool DWD_get_edge_pa_dac16_range(unsigned int16 band, unsigned char high_txpwr, unsigned char low_txpwr, unsigned int16 *result, unsigned int16 *data, int handle);
extern "C" __declspec(dllexport) bool DWD_get_audio_data(DWD_get_audio_data_con_type *data, int handle);

/*----------------------------- ATE #4 MMI --------------------------------*/
extern "C" __declspec(dllexport) bool DWD_store_lcd_contrast(unsigned char contrast, int handle);
extern "C" __declspec(dllexport) bool DWD_get_lcd_contrast(unsigned char *contrast, int handle);
extern "C" __declspec(dllexport) bool DWD_set_lcd_contrast(unsigned int16 contrast, int handle);
extern "C" __declspec(dllexport) bool DWD_lcd_generic_func(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *input,unsigned int16 *nof_output_bytes, unsigned char *output, int handle);
extern "C" __declspec(dllexport) bool DWD_start_test_image(unsigned int16 pattern, int handle);
extern "C" __declspec(dllexport) bool DWD_stop_test_image(int handle);
extern "C" __declspec(dllexport) bool DWD_read_lcd_register(unsigned char address,unsigned char *data, int handle);
extern "C" __declspec(dllexport) bool DWD_write_lcd_register(unsigned char address, unsigned char data, int handle);
extern "C" __declspec(dllexport) bool DWD_start_buzzer_tune(int handle);
extern "C" __declspec(dllexport) bool DWD_stop_buzzer_tune(int handle);
extern "C" __declspec(dllexport) bool DWD_start_key_board_test(int handle);
extern "C" __declspec(dllexport) bool DWD_poll_keyboard_result( bool *result, unsigned int32 *keymatrix, int handle);
extern "C" __declspec(dllexport) bool DWD_external_keypress(signed int16 key, int handle);
extern "C" __declspec(dllexport) bool DWD_get_current_key_matrix(unsigned int32 *keymatrix, int handle ); 
extern "C" __declspec(dllexport) bool DWD_get_keyflip_status(unsigned int16 *status,int handle); 
extern "C" __declspec(dllexport) bool DWD_switch_on_back_light(int handle);
extern "C" __declspec(dllexport) bool DWD_switch_off_back_light(int handle);
extern "C" __declspec(dllexport) bool DWD_switch_vibrator_on(int handle);
extern "C" __declspec(dllexport) bool DWD_switch_vibrator_off(int handle);
extern "C" __declspec(dllexport) bool DWD_charger_inserted(bool *result, int handle);
extern "C" __declspec(dllexport) bool DWD_store_imei(signed char imei[14], bool *already_programmed, int handle);
extern "C" __declspec(dllexport) bool DWD_store_sp_lock( unsigned char *sp_lock_code_ptr, bool *already_programmed, int handle);
extern "C" __declspec(dllexport) bool DWD_nv_generic(unsigned int16 opcode,unsigned char nof_input_bytes, void *pinput, unsigned char *nof_output_bytes,void *poutput, int handle);
extern "C" __declspec(dllexport) bool DWD_set_pixel(unsigned char x, unsigned char y, unsigned int16 nof_input_bytes, unsigned char *data, int handle);

extern "C" __declspec(dllexport) bool DWD_measure_equip_threshold(signed int16 *threshold, int handle);
extern "C" __declspec(dllexport) bool DWD_get_equip_threshold(signed int16 *threshold, int handle);
extern "C" __declspec(dllexport) bool DWD_store_equip_threshold(signed int16 threshold, int handle);

/*--------------- Test of connection to capacity estimation device ------- */
extern "C" __declspec(dllexport) bool DWD_check_gg(bool *ok, int handle);
/*-------------------------------------------------------------------------*/

/*-------------------------------- Audio -----------------------------------*/
extern "C" __declspec(dllexport) bool DWD_set_audiomode(unsigned char mode, int handle);
extern "C" __declspec(dllexport) bool DWD_set_volumestep(unsigned char  step,int handle);
extern "C" __declspec(dllexport) bool DWD_set_speakeramp_handsfree(unsigned char  mode, int handle);
extern "C" __declspec(dllexport) bool DWD_start_melody_tune(unsigned int16 tune, unsigned char volume, int handle);
extern "C" __declspec(dllexport) bool DWD_stop_melody_tune(int handle);

/*--------------- handling of production configuration data ---------------*/
extern "C" __declspec(dllexport) bool DWD_store_serial_number(unsigned int32 serial_number, int handle);
extern "C" __declspec(dllexport) bool DWD_get_serial_number(unsigned int32 *serial_number, int handle);
extern "C" __declspec(dllexport) bool DWD_store_testseries_id(unsigned int16 testseries_id, int handle);
extern "C" __declspec(dllexport) bool DWD_get_testseries_id(unsigned int16 *testseries_id, int handle);
extern "C" __declspec(dllexport) bool DWD_store_config(unsigned char config_id, dwd_config_type *config, int handle);
extern "C" __declspec(dllexport) bool DWD_get_config(unsigned char config_id, dwd_config_type *config, int handle);
extern "C" __declspec(dllexport) bool DWD_store_test_station_parms(unsigned char test_station_id, dwd_test_station_type *parms, int handle);
extern "C" __declspec(dllexport) bool DWD_get_test_station_parms(unsigned char test_station_id, dwd_test_station_type *parms, int handle);
extern "C" __declspec(dllexport) bool DWD_store_production_date(dwd_production_date_type *date, int handle);
extern "C" __declspec(dllexport) bool DWD_get_production_date(dwd_production_date_type *date, int handle);
extern "C" __declspec(dllexport) bool DWD_store_customer_parms(dwd_customer_parm_type *customer, int handle);
extern "C" __declspec(dllexport) bool DWD_get_customer_parms(dwd_customer_parm_type *customer, int handle);
extern "C" __declspec(dllexport) bool DWD_store_pn_number(dwd_pn_type *number,int handle);
extern "C" __declspec(dllexport) bool DWD_get_pn_number(dwd_pn_type *number, int handle);
extern "C" __declspec(dllexport) bool DWD_get_hw_version_string(dwd_hw_ver_string_type *string,int handle);
extern "C" __declspec(dllexport) bool DWD_store_hw_version_string(dwd_hw_ver_string_type *string,int handle);

/*--------------------------camera functions ------------------------------------*/
extern "C" __declspec(dllexport) bool DWD_start_preview(unsigned int16 mode, unsigned int16 framerate, int handle);
extern "C" __declspec(dllexport) bool DWD_stop_preview(int handle);
extern "C" __declspec(dllexport) bool DWD_sleep_camera(int handle);
extern "C" __declspec(dllexport) bool DWD_get_camera_status(unsigned int16 *status,int handle);
extern "C" __declspec(dllexport) bool DWD_take_picture(int handle);
extern "C" __declspec(dllexport) bool DWD_cam_generic(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput,unsigned int16 *nof_output_bytes, unsigned char *poutput, int handle);
extern "C" __declspec(dllexport) bool DWD_get_picture(char *filename, int handle);
extern "C" __declspec(dllexport) bool DWD_put_jpeg_picture(char *filename,unsigned int16 left,unsigned int16 top,unsigned int16 right,unsigned int16 buttom,int handle);


/*--------------------------Irda functions ---------------------------------------*/
extern "C" __declspec(dllexport) bool DWD_enter_irda_test_mode(unsigned int16 *result, int handle);
extern "C" __declspec(dllexport) bool DWD_exit_irda_test_mode(unsigned int16 *result,int handle);
extern "C" __declspec(dllexport) bool DWD_send_irda_data(unsigned int16 pattern,unsigned int32 baudrate, unsigned int16 *result, int handle);
extern "C" __declspec(dllexport) bool DWD_receive_irda_data(unsigned int16 pattern, unsigned int16 timeout, unsigned int32 baudrate, unsigned int16 *result, int handle);
/*---------------------------------------------------------------------------*/

/*--------------- User commands ------------------------------------------*/
/* User command. Sends the given bytes to the mobile using the internal protocol.
If a reception function,rxdone, is specified this function is called from the DLL
if when response mail has been received from the mobile. If timeout or another
error occurres, the function is not call, and the user command function returns false.
If rxdone is NULL the DLL will not wait for a confirm mail.
The 'id' parameter is passed on the the mobile to enable the mobile software to
figure out what user command is being received.
Note, that the mobile can't receive more than approximately 240 bytes in one mail
at a time. Each occurrence of the character 13 in any of the data bytes will extend
the length of the mail with an additional byte (used for byte-stuffing).
*/
extern "C" __declspec(dllexport) bool DWD_user_command(unsigned int16 id,unsigned char *data,unsigned char length,
                                                	  	void (*rxdone)(unsigned char *rxdata,int rx_length),int handle);

extern "C" __declspec(dllexport) bool DWD_user_command_timeout(unsigned int16 id, unsigned char *data,unsigned char length,void (*rxdone)(unsigned char *rxdata,int rx_length),unsigned int timeout,int handle);
extern "C" __declspec(dllexport) bool DWD_sec_user_cmd(unsigned char *data, unsigned char length,
	                                                void (*rxdone)(unsigned char *rxdata,int16 rx_length),int handle);

extern "C" __declspec(dllexport) bool DWD_set_keypad_reference_matrix(unsigned int32 matrix);
extern "C" __declspec(dllexport) long DWD_get_keypad_reference_matrix(void);
/*------------------------------------------------------------------------*/

/*--------------- Miscellaneous functions --------------------------------*/
extern "C" __declspec(dllexport) bool DWD_store_to_nv_memory(int handle);
extern "C" __declspec(dllexport) bool DWD_store_to_nv_wchksum(bool *checksum_ok,int handle);
extern "C" __declspec(dllexport) bool DWD_set_serial_interface_mode(dwd_mode_type mode, int handle);
extern "C" __declspec(dllexport) bool DWD_store_item_in_nv_mem(unsigned short int item_index, int handle);
extern "C" __declspec(dllexport) bool DWD_get_parm_xx(char *parameter_name, unsigned int nof_bytes, void *data_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_store_parm_xx(char *parameter_name, unsigned int nof_bytes, void *data_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_read_static_nv(unsigned short int start_addr, unsigned short int nof_bytes, void *pdest,  int handle);
extern "C" __declspec(dllexport) bool DWD_read_dynamic_nv(unsigned short int start_addr, unsigned short int nof_bytes, void *pdest, int handle);
extern "C" __declspec(dllexport) bool DWD_write_static_nv(unsigned int16 start_addr, unsigned int16 nof_bytes, void *psrc, int handle);
extern "C" __declspec(dllexport) bool DWD_write_dynamic_nv(unsigned int16 start_addr, unsigned int16 nof_bytes, void *psrc, int handle);
extern "C" __declspec(dllexport) bool DWD_store_generic_tag_parms(char *parm_name,void *data,unsigned int nof_bytes,char *tag_name,int handle);
extern "C" __declspec(dllexport) bool DWD_get_generic_tag_parms(char *parm_name,void *data, unsigned int nof_bytes,char *tag_name,unsigned char *tag,int handle);
extern "C" __declspec(dllexport) bool DWD_reset_dyn_nv_to_default(int handle);

/* Software version. 13 chars must be allocated as destination 'sw_version' */
extern "C" __declspec(dllexport) bool DWD_get_sw_version(char *sw_version, int handle);
extern "C" __declspec(dllexport) bool DWD_get_additional_version_info(unsigned char opcode, unsigned char *string,int handle);

/* DLL version. 13 chars must be allocated as destination 'dll_version' */
extern "C" __declspec(dllexport) bool DWD_get_dll_version(char *dll_version);
extern "C" __declspec(dllexport) bool DWD_get_ms_id(dwd_ms_id_type *id_ptr, int handle);
extern "C" __declspec(dllexport) bool DWD_get_eep_version(int *eep_version, int handle);
extern "C" __declspec(dllexport) bool DWD_get_eep_revision(unsigned int16 *eep_revision,int handle);
// If trace is already on, when calling "DWD_start_trace()" the function call
// will have no effect.
extern "C" __declspec(dllexport) bool DWD_start_trace(void);
extern "C" __declspec(dllexport) void DWD_stop_trace(void);
extern "C" __declspec(dllexport) char *DWD_get_last_error(void);
extern "C" __declspec(dllexport) bool DWD_sw_reset(int handle);


/*----------- Internal used function not used for production test ------*/
// Same as  "DWD_store_adc()", but with all parameters directly exposed for eay use in LabView
extern "C" __declspec(dllexport) bool DWD_store_adc_direct(signed int16 vbat_gain,
                          signed int16 vbat_offset, signed int16 tbat_gain,
                          signed int16 tbat_offset, signed int16 tenv_gain,
                          signed int16 tenv_offset, signed int16 btec_gain,
                          signed int16 btec_offset, signed int16 tvco_gain,
                          signed int16 tvco_offset, int handle );

/*---------------------------------------------------------------------*/
extern "C" __declspec(dllexport) void DWD_external_msg_handler(bool (*process)(void));

/* This is used if it is unacceptable that the calling application can't
   process messages while the DLL is waiting for a respons or sendning
   large amounts of data. The function pointer given to this function
   should process the incomming Windows messages, and return 'true' if
   the calling application has been terminated, i.e. received a WM_QUIT
   message (false otherwise). This function will be called from within
   the DLL during lengthy operations. Note, this will allow the user to
   request a new mobile communication command before a previous one is
   done. The DLL will handle this by returning with error on the new
   request.

   The code for this function for e.g. Borland C++ Builder should be:

   bool process_msg(void)
   {
     Application->ProcessMessages();
     return (Application->Terminated);
   }

   To activate this function: DWD_external_msg_handler(process_msg);
   To deativate: DWD_external_msg_handler(NULL); // this is default
---------------------------------------------------------------------*/
extern "C" __declspec(dllexport) bool DWD_set_eep_cfg_filename(char *eep_input_name,int handle);
extern "C" __declspec(dllexport) bool DWD_get_mslog(dwd_ms_log_type *mslog, int handle);
extern "C" __declspec(dllexport) bool DWD_get_pc_id(unsigned int32 *id);
extern "C" __declspec(dllexport) bool DWD_get_parameters(unsigned char *dest, int nof_bytes,
                                      unsigned short int start_addr, unsigned short int dynamic_start_addr, int handle);
extern "C" __declspec(dllexport) bool DWD_dump_parameter(unsigned char *data_start, unsigned short int size,
                                      unsigned short int start_addr,unsigned short int dynamic_start_addr, int handle);
extern "C" __declspec(dllexport) bool DWD_dump_dynamic(unsigned char *data, int nof_bytes, int handle);
extern "C" __declspec(dllexport) bool DWD_dump_static(unsigned char *data, int remaining_to_process, int handle);
extern "C" __declspec(dllexport) bool DWD_dump_static_wchksum(unsigned char *data, int remaining_to_process,unsigned int16 chksum,bool *chksum_ok, int handle);

extern "C" __declspec(dllexport) bool DWD_get_dynamic_tag_parms(dwd_tag_parms tag_parms, void *buffer, unsigned int handle);
extern "C" __declspec(dllexport) unsigned int DWD_get_error_status(void);
extern "C" __declspec(dllexport) bool DWD_set_power_saving(bool on, int handle);
extern "C" __declspec(dllexport) void DWDIO_SetCharDelay(int delay);
extern "C" __declspec(dllexport) void DWD_get_buffers(unsigned char **rx,unsigned char **tx, unsigned char **txAT);
extern "C" __declspec(dllexport) bool DWD_send_buffer(int handle, int length);
extern "C" __declspec(dllexport) bool DWD_send_buffer_special(int handle, int length);
extern "C" __declspec(dllexport) int  DWD_get_mail(int handle);
extern "C" __declspec(dllexport) int  DWD_wrap_AT_data(unsigned char *dest, unsigned char *data_src, int src_len);
extern "C" __declspec(dllexport) int  DWD_get_AT_wrapped_len(unsigned char *data_src, int src_len);
extern "C" __declspec(dllexport) bool DWD_not_ready_to_send(int handle,int id);
extern "C" __declspec(dllexport) bool DWD_rx_monitor_start(int handle, void (*process_line)(unsigned char *, int));
extern "C" __declspec(dllexport) bool DWD_rx_monitor_stop(int handle);
extern "C" __declspec(dllexport) bool DWD_memory_read(unsigned char *dest, unsigned int16 nof_bytes, unsigned int32 address, int handle);
extern "C" __declspec(dllexport) bool DWD_ram_modify(unsigned int32 address, unsigned int16 nof_bytes, unsigned char *src, int handle);
extern "C" __declspec(dllexport) bool DWD_charger_status(unsigned char *dest, int handle);
extern "C" __declspec(dllexport) bool DWD_battery_status(unsigned char *dest, int handle);
extern "C" __declspec(dllexport) bool DWD_clear_excp_log( int handle);
extern "C" __declspec(dllexport) bool DWD_capacity_status_direct(  unsigned int16 *capacity_state,
												   unsigned int16 *level,unsigned int16 *availcap,
												   unsigned int16 *lastdchg,unsigned int16 *compcap,
												   unsigned int16 *ccr,unsigned int16 *dcr, int handle);

extern "C" __declspec(dllexport) bool DWD_charger_status_direct(unsigned int16 *battery_id,
												   unsigned int16 *battery_voltage,unsigned int16 *battery_low_warning,
												   signed char *battery_temperature, signed char *environment_temperature,
												   unsigned int16 *charger_on,unsigned int16 *gl1_mode, int handle);
extern "C" __declspec(dllexport) bool DWD_get_battery_info(unsigned char *dest, int handle);
extern "C" __declspec(dllexport) bool DWD_start_buzzer_melody(unsigned char ring_tune, unsigned char duty_cycle,unsigned int16 repeats, int handle);
extern "C" __declspec(dllexport) bool DWD_play_buzzer_tone(unsigned int16 freq, unsigned char duty_cycle, int handle);
extern "C" __declspec(dllexport) bool DWD_start_ll_trace(char *output_filename, int baudrate, int handle);
extern "C" __declspec(dllexport) bool DWD_stop_ll_trace(void);
extern "C" __declspec(dllexport) void DWD_external_ll_trace_rx_indicator(void (*indicator)(unsigned long nof_bytes));
extern "C" __declspec(dllexport) void DWD_external_ll_trace_graph_draw(void (*draw_func)(signed short int *data, int nof_points));
// returns COM port used by the given handle, -1 if there is an error:
extern "C" __declspec(dllexport) int  DWD_get_com_port_for_handle( int handle);
extern "C" __declspec(dllexport) bool DWD_convert_function_trace2txt(char *func_file, char *output_file);
// Takes a point to a LL trace mail and graphs it via 'DWD_external_ll_trace_graph_draw()'
extern "C" __declspec(dllexport) void DWD_handle_graph_mail(unsigned char *data);
extern "C" __declspec(dllexport) void DWD_init_graph_data(void);
extern "C" __declspec(dllexport) void simulate_input(void);
extern "C" __declspec(dllexport) void DWD_external_debug_message_displayer(void (*show_func)(char *msg));
extern "C" __declspec(dllexport) bool DWD_get_eep_info(dwd_get_eep_info_type *eep_ptr, int handle);
extern "C" __declspec(dllexport) dwd_ch_array_type DWD_get_ch_array(void);
extern "C" __declspec(dllexport) bool DWD_provoke_excp(int handle);
#ifdef DEBUG_INFO
extern "C" __declspec(dllexport) void DWD_debug_message_handler(void (*show_line_func)(char *));
#endif

// Same as DWD_meas_all_adc(), but arguments are given directly for easy use from LabView
extern "C" __declspec(dllexport) bool DWD_meas_all_adc_direct(signed int16 *vbat,signed int16 *tbat,
                             signed int16 *tenv,signed int16 *btec,
                             signed int16 *tvco,signed int16 *curr, int handle );

extern "C" __declspec(dllexport) bool DWD_rf_bands_supported(unsigned char *band, int handle);
extern "C" __declspec(dllexport) bool DWD_ffs_generic(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput,unsigned int16 *nof_output_bytes, unsigned char *poutput, int handle);
extern "C" __declspec(dllexport) bool DWD_ffs_generic_timeout_delay(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput,unsigned int16 *nof_output_bytes, unsigned char *poutput, unsigned int timeout_delay, int handle);
extern "C" __declspec(dllexport) bool DWD_afr_generic(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput,unsigned int16 *nof_output_bytes, unsigned char *poutput, int handle);
extern "C" __declspec(dllexport) bool DWD_afr_generic_timeout_delay(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput,unsigned int16 *nof_output_bytes, unsigned char *poutput,unsigned int timeout_delay,int handle);
extern "C" __declspec(dllexport) bool DWD_aud_generic(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput,unsigned int16 *nof_output_bytes, unsigned char *poutput, int handle);
extern "C" __declspec(dllexport) bool DWD_send_dsp_cmd(unsigned int16 nof_dsp_cmd, dsp_cmd_type *data,int handle);
extern "C" __declspec(dllexport) bool DWD_send_at_command(unsigned char *at_cmd_str,unsigned char len, unsigned int wait_for_response_timer, unsigned int wait_for_char,unsigned char *at_cmd_resp_str, bool *timeout, int handle);
extern "C" __declspec(dllexport) bool DWD_chr_generic(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput, unsigned int16 *nof_output_bytes, unsigned char *poutput, int handle);
extern "C" __declspec(dllexport) bool DWD_gtb_generic(unsigned int16 opcode, unsigned char fileID, int handle);
extern "C" __declspec(dllexport) bool DWD_get_ffs_version( unsigned int16 *ffs_version, int handle );
extern "C" __declspec(dllexport) bool DWD_get_ffs_revision( unsigned int16 *ffs_revision, int handle );
extern "C" __declspec(dllexport) bool DWD_baseband_present(unsigned int16 *baseband, int handle);
extern "C" __declspec(dllexport) bool DWD_rf_present(unsigned int16 *rf, int handle);
extern "C" __declspec(dllexport) bool DWD_get_hasp_id(unsigned int32 *id, int handle);
extern "C" __declspec(dllexport) bool DWD_pow_management_generic_func(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput,unsigned int16 *nof_output_bytes, unsigned char *poutput, int handle);
extern "C" __declspec(dllexport) bool DWD_monitor_pin_generic_func(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput,unsigned int16 *nof_output_bytes, unsigned char *poutput, int handle);
extern "C" __declspec(dllexport) bool DWD_sim_generic(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput,unsigned int16 *nof_output_bytes, unsigned char *poutput, int handle);
extern "C" __declspec(dllexport) bool DWD_acc_generic(unsigned int16 opcode, unsigned int16 nof_input_bytes,unsigned char *pinput, unsigned int16 *nof_output_bytes, unsigned char *poutput, int handle);
extern "C" __declspec(dllexport) bool DWD_vib_generic(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput, unsigned int16 *nof_output_bytes, unsigned char *poutput, int handle);
extern "C" __declspec(dllexport) bool DWD_set_umts_fdd_test_mode(unsigned int16 mode, unsigned int16 uarfcn, unsigned int16 primary_sc, int handle);
extern "C" __declspec(dllexport) bool DWD_send_umts_fdd_coprocessor_cmd(unsigned int16 nof_send_bytes, unsigned char *psend, unsigned int16 *nof_receive_bytes, unsigned char *preceive, int handle);
extern "C" __declspec(dllexport) bool DWD_mmci_generic(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput,unsigned int16 *nof_output_bytes, unsigned char *poutput, int handle);
extern "C" __declspec(dllexport) bool DWD_mmci_generic_timeout_delay(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput,unsigned int16 *nof_output_bytes, unsigned char *poutput, unsigned int timeout_delay, int handle);
extern "C" __declspec(dllexport) bool DWD_rtt_generic(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput,unsigned int16 *nof_output_bytes, unsigned char *poutput, int handle);


//-------------------------- SECURITY HANDLING ---------------------------------------

extern "C" __declspec(dllexport) bool DWD_get_sec_version(unsigned char *sec_version,int handle);
extern "C" __declspec(dllexport) bool DWD_program_pers_code(unsigned char nof_input_bytes,unsigned char *pers_code,unsigned char *nof_output_bytes, unsigned char *poutput, int handle);
extern "C" __declspec(dllexport) bool DWD_set_cust_key(dwd_cust_key_type *key);
extern "C" __declspec(dllexport) bool DWD_sec_generic(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput,unsigned int16 *nof_output_bytes, unsigned char *poutput, int handle);
extern "C" __declspec(dllexport) bool DWD_sec_generic_timeout_delay(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput,unsigned int16 *nof_output_bytes, unsigned char *poutput, unsigned int timeout_delay, int handle);
extern "C" __declspec(dllexport) bool DWD_gdd_generic(unsigned int16 opcode, unsigned int16 nof_input_bytes, unsigned char *pinput,unsigned int16 *nof_output_bytes, unsigned char *poutput, int handle);

//--------------------------- SGOLD WORKBENCH HANDLING ------------------------
extern "C" __declspec(dllexport) bool DWD_wrk_start_rxlev_band(unsigned char band, unsigned int16 start_arfcn,
                                      unsigned char nof_arfcn_in,unsigned char *nof_arfcn_out, unsigned char *rxlev,int handle);
extern "C" __declspec(dllexport) bool DWD_wrk_stop_rxlev_band(int handle);
extern "C" __declspec(dllexport) bool DWD_wrk_start_fcb_sb(unsigned int16 arfcn, unsigned char fcb_only, unsigned char *fcb_result,
                                      signed int16 *freq_offs, unsigned int16 *qual, unsigned int16 *rms, unsigned char *bsic,int handle);
extern "C" __declspec(dllexport) bool DWD_wrk_stop_fcb_sb(int handle);
extern "C" __declspec(dllexport) bool DWD_wrk_start_si(unsigned int16 arfcn,unsigned int16 si_read_mode,unsigned int16 si_indicator,unsigned char pbcch_lr_start,
                                      unsigned char bcch_descr_psi1_repeat_period, unsigned char bcch_descr_bs_pbcch_blks, unsigned char bcch_descr_pb,unsigned char bcch_descr_tsc,
									  unsigned char bcch_descr_tn,unsigned char bcch_descr_chan_sel_present,unsigned int16 bcch_descr_chan_sel_union_rf,
									  unsigned int16 bcch_descr_mobile_alloc_rf_chan_cnt,unsigned int16 *bcch_descr_mobile_alloc_rf_chan_no, int handle);
extern "C" __declspec(dllexport) bool DWD_wrk_get_si(unsigned int16 *status, unsigned int16 *metric, unsigned char *channel_type, unsigned int16 *arfcn,
                                      unsigned long *fn, unsigned int16 *rms, signed int16 *toffs,signed int32 *qual, signed int16 *foffs, int handle);
extern "C" __declspec(dllexport) bool DWD_wrk_stop_si(int handle);
extern "C" __declspec(dllexport) bool DWD_wrk_start_tch(unsigned int16 ta, dwd_l1_channel_elem chan, dwd_amr_config_type amr_config,unsigned char audio_enable, int handle);
extern "C" __declspec(dllexport) bool DWD_wrk_stop_tch(int handle);
extern "C" __declspec(dllexport) bool DWD_wrk_start_idle(unsigned int16 arfcn, unsigned char txpwr, int handle);
extern "C" __declspec(dllexport) bool DWD_wrk_start_tch_loop(unsigned char tch_loop_mode, int handle);
extern "C" __declspec(dllexport) bool DWD_wrk_start_ptm(unsigned int16 trx_mode, dwd_timeslot_allocation uplnk, dwd_timeslot_allocation downlnk,
                       dwd_radio_freq_no arfcn, dwd_timeslot_source timeslot_source, dwd_loopback_mode_type loopback_mode,  int handle);
extern "C" __declspec(dllexport) bool DWD_wrk_stop_ptm(int handle);
extern "C" __declspec(dllexport) bool DWD_wrk_start_rach(unsigned int16 ch_req_msg, dwd_tsc_type tsc, unsigned int16 timing_advance, dwd_block_format_type access_burst_type,
     dwd_channel_type  channel_type, dwd_radio_freq_no arfcn, dwd_txpwr cs_txpwr, dwd_txpwr ps_txpwr, unsigned char iq_swap,
     unsigned int16 bsic, dwd_rach_type rachtype, int handle);
extern "C" __declspec(dllexport) bool DWD_wrk_stop_rach(int handle);
extern "C" __declspec(dllexport) bool DWD_wrk_get_ptm(unsigned int32 *fn, dwd_equ_data *equ_data, int handle);
extern "C" __declspec(dllexport) bool DWD_fwval_setup_adjust_mode(unsigned char flags, int handle); 

//------------------------------------- LED & Backlight ----------------------
extern "C" __declspec(dllexport) bool DWD_led_set_color(unsigned int16 color, unsigned int16 time_on, unsigned int16 total_time, unsigned int16 action, int handle);
extern "C" __declspec(dllexport) bool DWD_led_color_off(int handle);
extern "C" __declspec(dllexport) bool DWD_keypad_backlight_init(int handle);
extern "C" __declspec(dllexport) bool DWD_lcd_backlight_init(int handle);
extern "C" __declspec(dllexport) bool DWD_set_lcd_backlight(unsigned char lcd_tp, unsigned char action, unsigned int16 fade, unsigned int16 intensity,int handle);
extern "C" __declspec(dllexport) bool DWD_set_keypad_backlight(unsigned char action, unsigned int16 fade, unsigned int16 intensity, int handle);
extern "C" __declspec(dllexport) bool DWD_bl_get_status(unsigned int16 *status, int handle);
extern "C" __declspec(dllexport) bool DWD_bl_get_intensity(unsigned char lcd_tp, unsigned int16 *intensity,int handle);
extern "C" __declspec(dllexport) bool DWD_led_set_colorstream(unsigned char nof_color,dwd_colorstream_type *color , int handle);
extern "C" __declspec(dllexport) bool DWD_led_change_intensity(unsigned char color,unsigned char intensity,int handle);
extern "C" __declspec(dllexport) bool DWD_led_set_photolight(unsigned int16 action, unsigned int16 intensity, unsigned int16 total_time, unsigned int16 on_time,int handle);



