# SMS_PDU_processing.py
# Global functions / classes for SMS / PDU processing 
#
# 
# Version history:
# V1.0  12.11.2003    R. Weiden   started as C++ implementation for ATT1.0
# V1.1  24.08.2004    R. Weiden	  PYTHON portation  
# V1.2  15.11.2004    T.Kleinmann Correction regarding SCAlen
# V1.3	23.11.2004    T.Kleinmann Test Version because of SCA len problem
# --------------------------------------------------------------------------------



class CPdu:
	"Class for PDU processing"

	#
	# initialization
	#####################################################################
	def __init__(self):
		# public data members for necessary user-created data

		self.m_strServiceCenterAddress = '' 			# Phone Number of Service Center
		self.m_strOriginatorAddress=''				# Mobile Number of SMS sender (in international format)
		self.m_strDestinationAddress=''				# Mobile Number of SMS receiver(in international format) 
		self.m_strTimeStamp=''					# Timestamp of SMS
		self.m_strUserData=''					# User's data to be transferred in SMS/PDU
		self.m_strCurrentPDU=''					# resulting PDU after preocessing
	

		
	#
	# Creates a SMS-SUBMIT PDU for mobile originated SMS transmission
	# Before calling this method, required data have to be provided 
	# in object's member variables:
	# self.m_strServiceCenterAddress
	# self.m_strDestinationAddress
	# self.m_strUserData	(see comments in __init__() above)
	# After execution, resulting SubmitPDU is written to member
	# self.m_strCurrentPDU for further usage
	#
	# @return len of created PDU
	#####################################################################
	def CreateSubmitPDU(self):

		strPDU=self.ConvertASCII2PDU(self.m_strUserData)

		if self.m_strServiceCenterAddress[0]!='+':
			# this is not an international number!
			return -1
	
		strSCA=self.m_strServiceCenterAddress[1:]

		if (len(strSCA)%2)!=0:
			strSCA+='F'

		strSCA=self.FlipBytesInString(strSCA);

		if self.m_strDestinationAddress[0]!='+':
			# this is not an international number!
			return -1

		strDA=self.m_strDestinationAddress[1:]

	##### Check PDU here 
		if (len(strDA)%2)!=0:
		        strDA+='F'
		strDA=self.FlipBytesInString(strDA)
		#Correction of SCAlen - 15.11.2004 Kleinmann
		strPDU='%(SCAlen)02X91%(SCA)s0100%(DAlen)02X91%(DA)s0000%(DATAlen)02X%(DATA)s' % \
		{"SCAlen": (len(self.m_strServiceCenterAddress)/2+1), "SCA": strSCA, \
		"DAlen": len(self.m_strDestinationAddress)-1, "DA": strDA, \
		"DATAlen": len(self.m_strUserData), "DATA": self.ConvertASCII2PDU(self.m_strUserData)}

		self.m_strCurrentPDU=strPDU
		return (len(strPDU)-len(self.m_strServiceCenterAddress))/2-1
		#return self.m_strServiceCenterAddress
		

	#
	# Flips all bytes in strInput (interpreted as bytefield) and returns
	# the result.
	# FOR INTERNAL USE ONLY!
	#####################################################################
	def FlipBytesInString(self, strInput):

		strOutput=''

		if len(strInput)%2!=0: strInput+=' '

		for i in range (0, len(strInput), 2):
			strOutput+=strInput[i+1]
			strOutput+=strInput[i]

		return strOutput

	#
	# Converts a given ASCII string to PDU format and returns it.
	#
	# @return resulting PDU
	#####################################################################
	def ConvertASCII2PDU(self, strASCII):
		strTemp=''
		strFlipped=''
		strPDU=''
		achHexNumbers='0123456789ABCDEF'

		# ToDo: Remove german 'umlauts' etc. 
		# Create 7 bit reverse binary representation

		for i in range (0, len(strASCII)):
			for j in range (0, 7):
				if ((ord(strASCII[i])>>j) & 0x01) !=0:
					strTemp+='1'
				else:
					strTemp+='0'

		# make len a multiple of 8
		strLen=len(strTemp)%8
		for i in range (0, 8-(len(strTemp)%8)):
			strTemp+='0'

		# flip bytes as 8-bit representation
		for i in range (0, len (strTemp), 8):
			for j in range (7, -1, -1):
				strFlipped+=strTemp[i+j]

		for i in range (0, len (strFlipped), 4):
			iNibbleValue=0
			for j in range (0, 4):
				iNibbleValue=iNibbleValue<<1
				iNibbleValue|=(strFlipped[i+j]=='1')
			strPDU+=achHexNumbers[iNibbleValue]
		
		return strPDU
