# keycommands.py
#
# ATT2.0 python script introducing key resolution commands:
# KEY ("<KEYNAME>") will resolve to AT+CKPD=<resolvedkey>
# were the mapping between KEYNAME and resolvedkey is done via 
# dictionary KEYDICTIONARY.
# 


# Version history
# 2004/08/17	Ralf Weiden		Started. STATE IS STILL EXPERIMENTAL!
#
# ------------------------------------------------------------------------------------------------------------

from time import sleep
from ATT_PYTHON import *

# KEYDICTIONARY contains all mappings for mapping human-readable key names to the values used
# with AT+CKPD.
#
# THIS CURRENTLY IS ONLY COMPATIBLE WITH ULYSSES / PENELOPE!

KEYDICTIONARY= {\
'HOOKON': 'E',\
'NAVIUP': '^',\
'NAVIDOWN': 'V',\
'NAVILEFT': '<',\
'NAVIRIGHT': '>',\
'NAVICENTER': 'F',\
'LSK':'[',\
'RSK': ']',\
' ': '1',\
'A':'2',\
'B': '22',\
'C': '222',\
'D': '3',\
'E': '33',\
'F': '333',\
'G': '4',\
'H': '44',\
'I': '444',\
'J': '5',\
'K': '55',\
'L': '555',\
'M': '6',\
'N': '66',\
'O': '666',\
'P': '7', \
'Q': '77',\
'R': '777',\
'S': '7777',\
'T': '8',\
'U': '88',\
'V': '888',\
'W': '9',\
'X': '99',\
'Y': '999',\
'Z': '9999',\
'!': '0000'\
}


# ------------------------------------------------------------------------------------------------------------

# enable AT+CKPD

COM ('keycommands.py: Initialising KEYPAD')
ATCMD (1, 'AT+CMEC=2')
WAITFOR (1, 'OK')


# ------------------------------------------------------------------------------------------------------------
# function KEY sends the defined key to mobile. Resolution is done via KEYDICTIONARY 

def KEY (strInput):	# use AT+CKPD for simulating key press
	strOutput=KEYDICTIONARY.get(strInput, None)
	if strOutput==None:
		strOutput=strInput

	ATCMD (1, 'AT+CKPD="', strOutput, '", 0,0')
	WAITFOR (1, 'OK')
	sleep (0.5)

# ------------------------------------------------------------------------------------------------------------
# function QUICKTYPE expects an input string and 'types' its content to mobile. 
# Usable for creation of quick SMS or organizer content 

def QUICKTYPE (strInput):	# converts an ASCII input string to mobile-compatibe output
	strOutput=cCurrentKey=cPreviousKey=''
	for char in strInput:
		cKeyValue=KEYDICTIONARY.get(char, None)
		if cKeyValue==None: cKeyValue=char

		cCurrentKey=cKeyValue[0]
		if (cCurrentKey==cPreviousKey):
			ATCMD (1, 'AT+CKPD=', strOutput, ',0,0')
			WAITFOR (1, 'OK')
			strOutput=''
			sleep(1.5)
		cPreviousKey=cCurrentKey
		strOutput=strOutput+cKeyValue
		
	ATCMD (1, 'AT+CKPD=', strOutput, ',0,0')
	WAITFOR (1, 'OK')
	
