/*
 * Decompiled with CFR 0.152.
 */
package jelatine;

import java.util.TimeZone;

public final class VMTimeZone
extends TimeZone {
    private int rawOffset;
    private boolean useDaylight;
    private int dstSavings = 3600000;
    private int startYear;
    private static final int DOM_MODE = 1;
    private static final int DOW_IN_MONTH_MODE = 2;
    private static final int DOW_GE_DOM_MODE = 3;
    private static final int DOW_LE_DOM_MODE = 4;
    private int startMode;
    private int startMonth;
    private int startDay;
    private int startDayOfWeek;
    private int startTime;
    private int startTimeMode = 0;
    private int endMonth;
    private int endMode;
    private int endDay;
    private int endDayOfWeek;
    private int endTime;
    private int endTimeMode = 0;
    private static final byte[] monthArr = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final int STANDARD_TIME = 1;
    public static final int WALL_TIME = 0;
    public static final int UTC_TIME = 2;

    public VMTimeZone(int n, String string) {
        this.rawOffset = n;
        this.useDaylight = false;
        this.startYear = 0;
    }

    public void setStartYear(int n) {
        this.startYear = n;
        this.useDaylight = true;
    }

    private int checkRule(int n, int n2, int n3) {
        if (n < 0 || n > 11) {
            throw new IllegalArgumentException();
        }
        int n4 = this.getDaysInMonth(n, 1);
        if (n3 == 0) {
            if (n2 <= 0 || n2 > n4) {
                throw new IllegalArgumentException();
            }
            return 1;
        }
        if (n3 > 0) {
            if (Math.abs(n2) > (n4 + 6) / 7) {
                throw new IllegalArgumentException();
            }
            if (n3 > 7) {
                throw new IllegalArgumentException();
            }
            return 2;
        }
        if (n2 == 0 || Math.abs(n2) > n4) {
            throw new IllegalArgumentException();
        }
        if (n3 < -7) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0) {
            return 4;
        }
        return 3;
    }

    public void setStartRule(int n, int n2, int n3, int n4) {
        this.startMode = this.checkRule(n, n2, n3);
        this.startMonth = n;
        this.startDay = n2;
        this.startDayOfWeek = Math.abs(n3);
        this.startTime = this.startTimeMode == 0 || this.startTimeMode == 1 ? n4 : n4 + this.rawOffset;
        this.useDaylight = true;
    }

    public void setStartRule(int n, int n2, int n3, int n4, boolean bl) {
        this.startDay = bl ? Math.abs(n2) : -Math.abs(n2);
        int n5 = this.startDayOfWeek = bl ? Math.abs(n3) : -Math.abs(n3);
        this.startMode = n3 != 0 ? (bl ? 3 : 4) : this.checkRule(n, n2, n3);
        this.startDay = Math.abs(this.startDay);
        this.startDayOfWeek = Math.abs(this.startDayOfWeek);
        this.startMonth = n;
        this.startTime = this.startTimeMode == 0 || this.startTimeMode == 1 ? n4 : n4 + this.rawOffset;
        this.useDaylight = true;
    }

    public void setStartRule(int n, int n2, int n3) {
        this.setStartRule(n, n2, 0, n3);
    }

    public void setEndRule(int n, int n2, int n3, int n4) {
        this.endMode = this.checkRule(n, n2, n3);
        this.endMonth = n;
        this.endDay = n2;
        this.endDayOfWeek = Math.abs(n3);
        this.endTime = this.endTimeMode == 0 ? n4 : (this.endTimeMode == 1 ? n4 + this.dstSavings : n4 + this.rawOffset + this.dstSavings);
        this.useDaylight = true;
    }

    public void setEndRule(int n, int n2, int n3, int n4, boolean bl) {
        this.endDay = bl ? Math.abs(n2) : -Math.abs(n2);
        int n5 = this.endDayOfWeek = bl ? Math.abs(n3) : -Math.abs(n3);
        this.endMode = n3 != 0 ? (bl ? 3 : 4) : this.checkRule(n, n2, n3);
        this.endDay = Math.abs(this.endDay);
        this.endDayOfWeek = Math.abs(this.endDayOfWeek);
        this.endMonth = n;
        this.endTime = this.endTimeMode == 0 ? n4 : (this.endTimeMode == 1 ? n4 + this.dstSavings : n4 + this.rawOffset + this.dstSavings);
        this.useDaylight = true;
    }

    public void setEndRule(int n, int n2, int n3) {
        this.setEndRule(n, n2, 0, n3);
    }

    public int getOffset(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.getDaysInMonth(n3, n2);
        if (n4 < 1 || n4 > n7) {
            throw new IllegalArgumentException();
        }
        if (n5 < 1 || n5 > 7) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || n3 > 11) {
            throw new IllegalArgumentException();
        }
        int n8 = 0;
        if (this.useDaylight && n == 1 && n2 >= this.startYear) {
            boolean bl = !this.isBefore(n2, n3, n4, n5, n6, this.startMode, this.startMonth, this.startDay, this.startDayOfWeek, this.startTime);
            boolean bl2 = this.isBefore(n2, n3, n4, n5, n6 + this.dstSavings, this.endMode, this.endMonth, this.endDay, this.endDayOfWeek, this.endTime);
            n8 = this.startMonth < this.endMonth ? (bl && bl2 ? this.dstSavings : 0) : (bl2 || bl ? this.dstSavings : 0);
        }
        return this.rawOffset + n8;
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public void setRawOffset(int n) {
        this.rawOffset = n;
    }

    public int getDSTSavings() {
        return this.dstSavings;
    }

    public void setDSTSavings(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.dstSavings = n;
    }

    public boolean useDaylightTime() {
        return this.useDaylight;
    }

    private int getDaysInMonth(int n, int n2) {
        if (n == 1) {
            if ((n2 & 3) != 0) {
                return 28;
            }
            if (n2 < 1582) {
                return 29;
            }
            return n2 % 100 != 0 || n2 % 400 == 0 ? 29 : 28;
        }
        return monthArr[n];
    }

    private boolean isBefore(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        if (n2 != n7) {
            return n2 < n7;
        }
        switch (n6) {
            case 1: {
                if (n3 == n8) break;
                return n3 < n8;
            }
            case 2: {
                n3 += n9 - n4;
                n3 = n8 < 0 ? (n3 -= this.getDaysInMonth(n2, n) + 7) : (n3 += 6);
                int n11 = n3 / 7;
                if (n11 != n8) {
                    return n11 < n8;
                }
                if (n4 == n9) break;
                return n4 < n9;
            }
            case 4: {
                n8 = Math.abs(n8) - 6;
            }
            case 3: {
                if ((n3 -= (n4 < n9 ? 7 : 0) + n4 - n9) < n8) {
                    return true;
                }
                if (n4 == n9 && n3 < n8 + 7) break;
                return false;
            }
        }
        return n5 < n10;
    }

    public synchronized int hashCode() {
        return this.rawOffset ^ (this.useDaylight ? this.startMonth ^ this.startDay ^ this.startDayOfWeek ^ this.startTime ^ this.endMonth ^ this.endDay ^ this.endDayOfWeek ^ this.endTime : 0);
    }

    public String toString() {
        return this.getClass().getName() + "[" + "id=" + this.getID() + ",offset=" + this.rawOffset + ",dstSavings=" + this.dstSavings + ",useDaylight=" + this.useDaylight + (this.useDaylight ? ",startYear=" + this.startYear + ",startMode=" + this.startMode + ",startMonth=" + this.startMonth + ",startDay=" + this.startDay + ",startDayOfWeek=" + this.startDayOfWeek + ",startTime=" + this.startTime + ",startTimeMode=" + this.startTimeMode + ",endMode=" + this.endMode + ",endMonth=" + this.endMonth + ",endDay=" + this.endDay + ",endDayOfWeek=" + this.endDayOfWeek + ",endTime=" + this.endTime + ",endTimeMode=" + this.endTimeMode : "") + "]";
    }
}

