/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Double {
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_VALUE = 4.9E-324;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    private final double value;

    public Double(double d) {
        this.value = d;
    }

    public static native String toString(double var0);

    public static Double valueOf(String string) throws NumberFormatException, NullPointerException {
        return new Double(Double.parseDouble(string));
    }

    public static double parseDouble(String string) throws NumberFormatException, NullPointerException {
        long l;
        String string2 = string.trim();
        long l2 = 0L;
        int n = 0;
        int n2 = string2.length();
        if (n2 == 0) {
            throw new NumberFormatException();
        }
        char c = string2.charAt(0);
        if (c == '-') {
            l2 = Long.MIN_VALUE;
            ++n;
        } else if (c == '+') {
            ++n;
        }
        string2 = string2.substring(n);
        if (string2.equals("NaN")) {
            l = 9221120237041090560L;
        } else if (string2.equals("Infinity")) {
            l = 0x7FF0000000000000L;
        } else {
            n2 = string2.length();
            if (n2 == 0) {
                throw new NumberFormatException();
            }
            double d = 0.0;
            for (n = 0; n < n2 && Character.isDigit(string2.charAt(n)); ++n) {
                d = d * 10.0 + (double)Character.digit(string2.charAt(n), 10);
            }
            if (n < n2 && string2.charAt(n) == '.') {
                ++n;
            }
            double d2 = 10.0;
            while (n < n2 && Character.isDigit(string2.charAt(n))) {
                d += (double)Character.digit(string2.charAt(n), 10) / d2;
                d2 *= 10.0;
                ++n;
            }
            int n3 = 0;
            boolean bl = true;
            if (n < n2 && Character.toLowerCase(string2.charAt(n)) == 'e') {
                if (++n < n2) {
                    c = string2.charAt(n);
                    if (c == '-') {
                        ++n;
                        bl = false;
                    } else if (c == '+') {
                        ++n;
                    }
                }
                int n4 = n;
                while (n < n2 && Character.isDigit(string2.charAt(n))) {
                    n3 = n3 * 10 + Character.digit(string2.charAt(n), 10);
                    ++n;
                }
                if (n == n4) {
                    throw new NumberFormatException();
                }
                if (!bl) {
                    n3 = -n3;
                }
            }
            if (n < n2) {
                c = Character.toLowerCase(string2.charAt(n));
                ++n;
                if (c != 'f' && c != 'd') {
                    throw new NumberFormatException();
                }
            }
            if (n != n2) {
                throw new NumberFormatException();
            }
            l = Double.doubleToLongBits(d *= Math.pow(10.0, n3));
        }
        return Double.longBitsToDouble(l | l2);
    }

    public static boolean isNaN(double d) {
        return d != d;
    }

    public static boolean isInfinite(double d) {
        return d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY;
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Double)) {
            return false;
        }
        double d = ((Double)object).value;
        if (this.value == d) {
            return this.value != 0.0 || 1.0 / this.value == 1.0 / d;
        }
        return Double.isNaN(this.value) && Double.isNaN(d);
    }

    public static native long doubleToLongBits(double var0);

    public static native double longBitsToDouble(long var0);
}

