/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Character {
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    private final char value;

    public Character(char c) {
        this.value = c;
    }

    public char charValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Character && this.value == ((Character)object).value;
    }

    public String toString() {
        return new String(new char[]{this.value}, 0, 1, true);
    }

    public static boolean isLowerCase(char c) {
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        return c >= '\u00df' && c <= '\u00ff' && c != '\u00f7';
    }

    public static boolean isUpperCase(char c) {
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        return c >= '\u00c0' && c <= '\u00de' && c != '\u00d7';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static char toLowerCase(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c - 65 + 97);
        }
        if (c >= '\u00c0' && c <= '\u00de' && c != '\u00d7') {
            return (char)(c - 192 + 223);
        }
        return c;
    }

    public static char toUpperCase(char c) {
        if (c >= 'a' && c <= 'z') {
            return (char)(c - 97 + 65);
        }
        if (c >= '\u00df' && c <= '\u00ff' && c != '\u00f7') {
            return (char)(c - 223 + 192);
        }
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int digit(char c, int n) {
        int n2 = 0;
        if (n < 2) return -1;
        if (n > 36) return -1;
        if (c >= '0' && c <= '9') {
            n2 = c - 48;
        } else {
            if (!Character.isUpperCase(c) && !Character.isLowerCase(c)) return -1;
            n2 = (c & 0x1F) + 9;
        }
        if (n2 >= n) return -1;
        return n2;
    }
}

