/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class StringBuffer {
    int count;
    char[] value;
    boolean shared;
    private static final int DEFAULT_CAPACITY = 16;

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int n) {
        this.value = new char[n];
    }

    public StringBuffer(String string) {
        this.count = string.count;
        this.value = new char[this.count + 16];
        string.getChars(0, this.count, this.value, 0);
    }

    public synchronized int length() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.value.length;
    }

    public synchronized void ensureCapacity(int n) {
        this.ensureCapacity_unsynchronized(n);
    }

    public synchronized void setLength(int n) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        int n2 = this.value.length;
        this.ensureCapacity_unsynchronized(n);
        if (n < n2) {
            this.count = n;
        } else {
            while (this.count < n) {
                this.value[this.count++] = '\u0000';
            }
        }
    }

    public synchronized char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        return this.value[n];
    }

    public synchronized void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n2 > this.count || n2 < n) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, n, cArray, n3, n2 - n);
    }

    public synchronized void setCharAt(int n, char c) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity_unsynchronized(this.count);
        this.value[n] = c;
    }

    public StringBuffer append(Object object) {
        return this.append(object == null ? "null" : object.toString());
    }

    public synchronized StringBuffer append(String string) {
        if (string == null) {
            string = "null";
        }
        int n = string.count;
        this.ensureCapacity_unsynchronized(this.count + n);
        string.getChars(0, n, this.value, this.count);
        this.count += n;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StringBuffer append(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return this.append("null");
        }
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            int n = stringBuffer.count;
            this.ensureCapacity_unsynchronized(this.count + n);
            System.arraycopy(stringBuffer.value, 0, this.value, this.count, n);
            this.count += n;
        }
        return this;
    }

    public StringBuffer append(char[] cArray) {
        return this.append(cArray, 0, cArray.length);
    }

    public synchronized StringBuffer append(char[] cArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n > cArray.length - n2) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity_unsynchronized(this.count + n2);
        System.arraycopy(cArray, n, this.value, this.count, n2);
        this.count += n2;
        return this;
    }

    public StringBuffer append(boolean bl) {
        return this.append(bl ? "true" : "false");
    }

    public synchronized StringBuffer append(char c) {
        this.ensureCapacity_unsynchronized(this.count + 1);
        this.value[this.count++] = c;
        return this;
    }

    public StringBuffer append(int n) {
        return this.append(String.valueOf(n));
    }

    public StringBuffer append(long l) {
        return this.append(Long.toString(l, 10));
    }

    public StringBuffer append(float f) {
        return this.append(Float.toString(f));
    }

    public StringBuffer append(double d) {
        return this.append(Double.toString(d));
    }

    public synchronized StringBuffer delete(int n, int n2) {
        if (n < 0 || n > this.count || n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n2 > this.count) {
            n2 = this.count;
        }
        this.ensureCapacity_unsynchronized(this.count);
        if (this.count - n2 != 0) {
            System.arraycopy(this.value, n2, this.value, n, this.count - n2);
        }
        this.count -= n2 - n;
        return this;
    }

    public StringBuffer deleteCharAt(int n) {
        return this.delete(n, n + 1);
    }

    public StringBuffer insert(int n, Object object) {
        return this.insert(n, object == null ? "null" : object.toString());
    }

    public synchronized StringBuffer insert(int n, String string) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        if (string == null) {
            string = "null";
        }
        int n2 = string.count;
        this.ensureCapacity_unsynchronized(this.count + n2);
        System.arraycopy(this.value, n, this.value, n + n2, this.count - n);
        string.getChars(0, n2, this.value, n);
        this.count += n2;
        return this;
    }

    public StringBuffer insert(int n, char[] cArray) {
        for (int i = n; i < cArray.length; ++i) {
            this.value[i] = cArray[i - n];
        }
        return this;
    }

    public StringBuffer insert(int n, boolean bl) {
        return this.insert(n, bl ? "true" : "false");
    }

    public synchronized StringBuffer insert(int n, char c) {
        if (n < 0 || n > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        this.ensureCapacity_unsynchronized(this.count + 1);
        System.arraycopy(this.value, n, this.value, n + 1, this.count - n);
        this.value[n] = c;
        ++this.count;
        return this;
    }

    public StringBuffer insert(int n, int n2) {
        return this.insert(n, String.valueOf(n2));
    }

    public StringBuffer insert(int n, long l) {
        return this.insert(n, Long.toString(l, 10));
    }

    public StringBuffer insert(int n, float f) {
        return this.insert(n, Float.toString(f));
    }

    public StringBuffer insert(int n, double d) {
        return this.insert(n, Double.toString(d));
    }

    public synchronized StringBuffer reverse() {
        this.ensureCapacity_unsynchronized(this.count);
        int n = this.count >> 1;
        int n2 = this.count - n;
        while (--n >= 0) {
            char c = this.value[n];
            this.value[n] = this.value[n2];
            this.value[n2] = c;
            ++n2;
        }
        return this;
    }

    public String toString() {
        return new String(this);
    }

    private void ensureCapacity_unsynchronized(int n) {
        if (this.shared || n > this.value.length) {
            int n2 = n > this.value.length ? this.value.length * 2 + 2 : this.value.length;
            n = n < n2 ? n2 : n;
            char[] cArray = new char[n];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
            this.shared = false;
        }
    }
}

