
#include "../inc/swilib.h"
#include "helper.h"
#include "swihook.h"



void __jel_helper_msghandler()
{
  GBS_MSG msg;
  if (GBS_RecActDstMessage(&msg))
  {
    if (msg.msg==MSG_HELPER_RUN)
    {
      if (msg.data0)
      {
	((void (*)(int, void *))(msg.data0))(msg.submess, msg.data1);
      }
    }
    else
    {
      GBS_SendMessage(MMI_CEPID,MSG_HELPER_TRANSLATOR,msg.pid_from,msg.msg,msg.submess);
    }
  }
}


void __jel_helper_create()
{
  CreateGBSproc(HELPER_CEPID, HELPER_NAME, __jel_helper_msghandler, HELPER_PRIO, 0);
}

void __jel_helper_kill()
{
 KillGBSproc(HELPER_CEPID);
}

void __jel_subproc(void *f, int p2, void *p1)
{
  GBS_SendMessage(HELPER_CEPID, MSG_HELPER_RUN, p2, f, p1);
}

void __jel_redraw()
{
  LockSched();
  GBS_SendMessage(MMI_CEPID, 0x90);
  UnlockSched();
}


void __jel_seqkiller(void *data, void(*next_in_seq)(void *), void *data_to_kill)
{
  next_in_seq(data);
  mfree(data_to_kill);
}

void __jel_helper_install()
{
 __jel_helper_create();
 __jel_swihook_setfunc(SWINUM_SUBPROC, (unsigned int)&__jel_subproc);
 __jel_swihook_setfunc(SWINUM_REDRAW, (unsigned int)&__jel_redraw);
 __jel_swihook_setfunc(SWINUM_SEQKILLER, (unsigned int)&__jel_seqkiller);
}

void __jel_helper_deinstall()
{
 __jel_helper_kill();
}
