#include "..\inc\swilib.h"
#include "md5.h"

char *_n = "\n";

#define _LOG

static void log(char *text)
{
#ifdef _LOG
  int hFile;
  unsigned int io_error = 0;
  hFile = fopen("4:\\naticq_md5.txt",A_ReadWrite + A_Create + A_Append,P_READ+P_WRITE, &io_error);
  if(hFile!=-1)
  {
    fwrite(hFile, (char*)text, strlen((char*)text), &io_error);
//    fwrite(hFile, "\r\n", 2, &io_error);
    fclose(hFile, &io_error);
  }
  else
    ShowMSG(1,(int)"Error!");
#else
  return;
#endif
}


char* get_imei()
{
#ifdef NEWSGOLD
  unsigned char *addr = (unsigned char *)0xA003E410;
#else
  unsigned char *addr = (unsigned char *)0xA000065C;
#endif
  char *imei = malloc(17);
  zeromem(imei,sizeof(imei));
  int i;  
  for(i=0; i<15; i++)
  {
    imei[i] = *addr;
    addr++;
  }
  
  log("origin imei = "); log(imei); log(_n);
    
  i = (imei[1]-'0') + (imei[4]-'0') + (imei[10]-'0') + (imei[8]-'0');
  i = i > 10 ? i % 10 : i;
  imei[15] = i > 0 ? i + '0' : '6';
  imei[16] = '\0';  

  int i2;
  
  i =  ((imei[1]-'0') + (imei[4]-'0') + (imei[10]-'0') * (imei[15]-'0'));
  i2 = ((imei[15]-'0') - (imei[14]-'0') + (imei[5]-'0') * (imei[17]-'0'));
  
  if(i2 < 0) i2 = i2*(-1);
  if(i < 0) i = i*(-1);
  

  int imei_len = strlen(imei);
  int pos1 = (i > imei_len) ? (i % imei_len) : (imei_len % i);
  int pos2 = (i2 > imei_len) ? (i2 % imei_len) : (imei_len % i2);
  
  imei[pos1] = ( (i > 10 ? (i % 10) : i) + '0');
  imei[pos2] = ( (i2 > 10 ? (i2 % 10) : i2) + '0');
  
  log("convert imei = "); log(imei); log(_n);
  return (char*)imei;
}

char *md5(char *md5text)
{
  md5_state_t md5state;
  unsigned char md5pword[16];
  zeromem(md5pword, sizeof(md5pword));
  md5_init(&md5state);
  md5_append(&md5state, (unsigned const char *)md5text, (int)strlen(md5text));
  md5_finish(&md5state, md5pword);

  char *key = malloc(33);
  zeromem(key,sizeof(key));
  for (int j = 0;j < 16;j++)
  {
    char a[3];
    sprintf(a, "%02x", md5pword[j]);
    key[2*j] = a[0];
    key[2*j+1] = a[1];
  }
  key[32] = '\0';  
  return key;
}


int hex2dec(int c)
{
  if(c >= '0' && c <= '9') c = c-'0';
  else
      if(c >= 'a' && c <= 'f') c = 10 + (c-'a');
 return c;
}

int get_hex_sum(char *hex)//  
{
  int len = strlen(hex);
  int retval=0;
  for(int i=0 ; i <= len ; i++)
  {
    retval+=hex2dec(hex[i]);
    
    /*if(hex[i] >= '0' && hex[i] <= '9') retval += hex[i]-'0';
    else
      if(hex[i] >= 'a' && hex[i] <= 'f') retval += 10 + (hex[i]-'a');*/
  }
  return retval;
}

char *getkey()
{
  char imei_part[4][5];
  char *hash_part[4];
  const char *imei = md5(get_imei());
  char *hash = malloc(32); 
  zeromem(hash,32);

  memcpy(imei_part[0],imei,   4);
  memcpy(imei_part[1],imei+4, 4);
  memcpy(imei_part[2],imei+8, 4);
  memcpy(imei_part[3],imei+12,4);

  for(int i=0;i<4;i++)
  {
    imei_part[i][4] = '\0';
    hash_part[i] = md5(imei_part[i]);  
  } 
  
  memcpy(hash,    (char*)(hash_part[0]+24), 8);
  memcpy(hash+8,  (char*)(hash_part[1]+16), 8);
  memcpy(hash+16, (char*)(hash_part[2]+8),  8);
  memcpy(hash+24, (char*)hash_part[3],      8);
  hash[31] = '\0';  

  return hash;
}

int kkey[]={
  2752, //kluchnik
  4048  //ComeWithMe
};


char *get_origin_imei()
{
  char *imei = malloc(16);
  zeromem(imei,sizeof(imei));
  int i;  
#ifdef NEWSGOLD
  unsigned char *addr = (unsigned char *)0xA003E410;
#else
  unsigned char *addr = (unsigned char *)0xA000065C;
#endif

  for(i=0; i<15; i++)
  {
    imei[i] = *addr;
    addr++;
  }
 imei[15] = '\0';  
 return imei; 
}


int invalidkey()
{
  int i=0;
  char *gkey = getkey();
  log("getkey = "); log(gkey); log(_n);
  int key1 = get_hex_sum(gkey);
  int k = 0;
  int ckey = 0;// 
  int lenkey = strlen(gkey)/2;
  
  char *oImei = get_origin_imei();
  log("imei = "); log(oImei); log(_n);
  unsigned int sum = get_hex_sum(oImei)*(hex2dec(gkey[6])+hex2dec(gkey[12]));

  while(k++ < lenkey)
  {
     ckey+=hex2dec(gkey[lenkey-k]);
     ckey+=hex2dec(gkey[lenkey+k]);
  }
  
  key1*=ckey;
  int res =  key1 > sum ? key1%sum : sum%key1;
  if(res<1000) res<<=4;
 
#ifdef _LOG
  char s[64];
  sprintf(s,"key1 = %d\nsum = %d\nResultat: %d\n",key1,sum,res);
  log(s);
#endif
  
  while(kkey[i])
  {
    if(kkey[i] - res == 0)
    {
      log("(kkey[i] - key1) == 0\n");
      log("-------------\n");
      return 1;
    }
    i++;
  }
  log("not accessible key =(\n");
  log("-------------\n");
  return (-1);
}
