#include "..\inc\swilib.h"
#include "local_ipc.h"
#include "../inc/xtask_ipc.h"
#include "main.h"
#include "language.h"
//  ,  ....    ....


#define FUNC_PT_START	0xA085DEA4
#define FUNC_PT_END	0xA0865BA3
#define FUNC_PT_PSIZE	0x80
#define FUNC_PT_OFFSET	0x10
#define MAX_FUNC	0xFA

GBSTMR mytmr;
int menus_id;
int active;

const char ipc_my_name[]=IPC_TEXTINFO_NAME;
const IPC_REQ gipc={
  ipc_my_name,
  ipc_my_name,
  NULL
};

#define TMR_SECOND 216

void TimerProc(void)
{
  GBS_SendMessage(MMI_CEPID,MSG_IPC,IPC_UPDATE_STAT,&gipc);
}

const char _s[]="%s";

#pragma inline=forced
int toupper(int c)
{
  if((c>='a')&&(c<='z')) c+='A'-'a';
  return(c);
}

int strncmpNoCase(const char *s1,const char *s2,unsigned int n)
{
  int i;
  int c;
  while(!(i=(c=toupper(*s1++))-toupper(*s2++))&&(--n)) if (!c) break;
  return(i);
}

//    sieelf.googlecode.com (r)BingK

#ifdef NEWSGOLD
unsigned int GetFunctionPointByName(char *name)
{
  char *p=(char *)FUNC_PT_START;
  int len=strlen(name);
  if(len==0)
     return 0;
  while((char *)FUNC_PT_END-p>0)
   {
     if(!strncmpNoCase(p, name, len))
	return (*(unsigned int *)(p+FUNC_PT_OFFSET));
     p+=FUNC_PT_PSIZE;
   }
  return 0;
}
#endif


void run_address(unsigned int address) 
{
  void (*runaddr)(void);
  runaddr=(void (*)())address;
  if (runaddr) 
  {
    runaddr();
  }
}

void run_shortcut(char *shortcut) 
{
#ifdef NEWSGOLD
   run_address(GetFunctionPointByName(shortcut));
#else
   run_address((unsigned int)GetFunctionPointer(shortcut));
#endif
}

int chr2num(char chr)
{
  if(chr>='0'&&chr<='9')
     return (chr-('0'-0));
  if(chr>='A'&&chr<='Z')
     return (chr-('A'-0xA));
  if(chr>='a'&&chr<='z')
     return (chr-('a'-0xA));
  return 0;
}

int RunBM2(int bm)
{
 const char *s=bmfile(bm);
 if((s)&&strlen(s))
 {
  if ((s[2]=='\\')&&((s[(strlen(s))-3]=='.')||//     '\\'  '.'
     (s[(strlen(s))-4]=='.')||(s[(strlen(s))-5]=='.')))
       {
        WSHDR *ws;
        ws=AllocWS(256);
        str_2ws(ws,s,256);
        if(ExecuteFile(ws,0,0))
        {
          FreeWS(ws);
          return(1);
        }
        else
        {
          FreeWS(ws);
          return 0;
        }
       }
    
    if ((s[2]!='\\')&&(s[(strlen(s))-3]!='.')&&
       (s[(strlen(s))-4]!='.')&&(s[(strlen(s))-5]!='.')&&
       ((s[0]=='a')||(s[0]=='A'))&&(s[1]=='0'))  
        {
          int i;
          unsigned int addr=0;
          char *p=(char*)s;
          for(i=0;i<strlen(s);i++)
          {
             addr=chr2num(p[i])+addr*0x10;
          }
          run_address(addr);
          return 1;
        }
    else
    {
          char ShortCut[32];
          char *p=(char*)s;
          int i=0;
          int j=0;
          for(;j<strlen(s);j++)
          {
            if(p[j]>='A')
            {
              ShortCut[i]=p[j];
              i++;
            }
          }
          ShortCut[i]=0;
          run_shortcut(ShortCut);     
          return 1;
    }  
  }
 return(0);
}


int num_book()
{
  int number_book=0;
  if(strlen(BM1FILE)) number_book=1;
  if(strlen(BM2FILE)) number_book=2;
  if(strlen(BM3FILE)) number_book=3;
  if(strlen(BM4FILE)) number_book=4;
  if(strlen(BM5FILE)) number_book=5;
  if(strlen(BM6FILE)) number_book=6;
  if(strlen(BM7FILE)) number_book=7;
  if(strlen(BM8FILE)) number_book=8;
  if(strlen(BM9FILE)) number_book=9;
  if(strlen(BM10FILE)) number_book=10;
  if(strlen(BM11FILE)) number_book=11;
  if(strlen(BM12FILE)) number_book=12;
  if(strlen(BM13FILE)) number_book=13;
  if(strlen(BM14FILE)) number_book=14;
  if(strlen(BM15FILE)) number_book=15; 
return number_book;
}

int get_file_size(char* fname)
{
  unsigned int err;
  FSTATS fs;
  if ((GetFileStats(fname,&fs,&err))==-1) return 0;
  return (fs.size);
}


/*------------------------------------------------------------------------*/
/*--------------------     ---------------------*/
/*------------------------------------------------------------------------*/

int itemFromDisp;//-  
int totalItems;//  
int curpos=0;// 
int curpage=1;// 

extern const char clrSelect[4];//={0xFF,0x00,0x00,0x20};
extern const char fntSelect[4];//={0xFF,0xFF,0x00,0x60};
extern const char bordSelect[4];//={0x00,0x00,0x00,0x60};

extern const char clrNotSelect[4];//={0xFF,0x00,0x00,0x60};
extern const char bordNotSelect[4];//={0x00,0x00,0x00,0x60}
extern const char fntNotSelect[4];//={0xFF,0xFF,0xFF,0x60};

char clrBlack[]={0x00,0x00,0x00,0x64};
char clrWhite[]={0xFF,0xFF,0xFF,0x64};
char prozr[]={0x00,0x00,0x00,0x00};
extern const int font;//=FONT_SMALL;
const char _t[]="%t";

char img_dir[128];//  ,  ...

//IMGHDR *icons[16];
IMGHDR *noico;

#define CLIST_Y1 (YDISP+GetFontYSIZE(font)+8)

void PrintAbout()
{
  WSHDR *ws=AllocWS(128);
  wsprintf(ws,"AltMyMenu2 v0.2\n(c)kluchnik\n%s at %s",__DATE__,__TIME__);
  DrawRoundedFrame(0,YDISP+1,ScreenW()-1,ScreenH()-1,0,0,0,clrBlack,clrBlack);
  char *s=malloc(128);
  sprintf(s,"%s\\%s",img_dir,"bg.png");
  DrawImg(1,YDISP,(int)s);
  mfree(s);
  DrawString(ws,0,(ScreenH()/2)-GetFontYSIZE(font),ScreenW()-1,ScreenH()-1,font,TEXT_ALIGNMIDDLE,fntSelect,0);
}


static void DrawSoftKeys(WSHDR *ws,char *right,char *left)
{
  int scr_w=ScreenW()-1;
  int scr_h=ScreenH()-1;
  
  LockSched();
  wsprintf(ws,_t,right);
  DrawString(ws,2,scr_h-4-GetFontYSIZE(font),scr_w,scr_h-4,font,0,fntNotSelect,0);

  CutWSTR(ws,32);
  wsprintf(ws,_t,left);
  DrawString(ws,(scr_w >> 1),scr_h-2-GetFontYSIZE(font),scr_w-2,scr_h-2,font,TEXT_ALIGNRIGHT,fntNotSelect,0);
  UnlockSched();
}

void DrwImage(IMGHDR *img, int x, int y, char *pen, char *brush)
{
  RECT rc;
  DRWOBJ drwobj;
  StoreXYWHtoRECT(&rc,x,y,img->w,img->h);
  SetPropTo_Obj5(&drwobj,&rc,0,img);
  SetColor(&drwobj,pen,brush);
  DrawObject(&drwobj);
}

typedef struct
{
  void *next;
  WSHDR *ws_name;
  WSHDR *ws_descript;
  int desc_len;
  IMGHDR *icon;
 // char *icon;
  int icon_size;
}BOOKMARKS;

BOOKMARKS *bmktop;

void AddToBmk(int numbmk,const char *name,const char *descript,char *icon)
{
 BOOKMARKS *bmk=malloc(sizeof(BOOKMARKS));
 bmk->next=0;
 bmk->ws_name=AllocWS(strlen(name)+4);
 bmk->ws_descript=AllocWS(strlen(descript));
 bmk->desc_len=strlen(descript);
// bmk->icon=icon;
 bmk->icon=CreateIMGHDRFromPngFile(icon, 0);   
 bmk->icon_size=get_file_size(icon);
 
 wsprintf(bmk->ws_name,"%d. %t",numbmk,name);
 wsprintf(bmk->ws_descript,_t,descript);
 
 if(!bmktop)
 {
   bmktop=bmk; 
 }
 else
 {
   BOOKMARKS *bm=bmktop;
   while(bm->next)
       bm=bm->next;
   bm->next=bmk;   
 } 
}

void FreeBmkList()
{/*
  if(bmktop)
   {
     BOOKMARKS *bmk=bmktop;
     BOOKMARKS *bm;
     while(bmk)
     {
       bm=bmk->next;
       mfree(bmk);
       bmk=bm;
     } 
   }*/
  
  LockSched();
  BOOKMARKS *bmk=(BOOKMARKS *)bmktop;
  bmktop=0;
  UnlockSched();
  while(bmk)
  {
    BOOKMARKS *bmk_prev=bmk;
    bmk=bmk->next;
    mfree(bmk_prev);
  }
}

BOOKMARKS *GetBmkByItem(int curitem)
{
  BOOKMARKS *bmk;
  bmk=bmktop;
  int i=0;
  while(bmk)
  {
    if(i==curitem)
      return bmk;
    i++;
    if(bmk->next) bmk=bmk->next;  
    else return 0;
  }
  return 0;
}

int TotalBmk()
{
  if(!bmktop) return 0;
  BOOKMARKS *bmk;
  bmk=bmktop;
  int i=1; 
  while(bmk=bmk->next) i++;
  return i;
}
/*
void LoadIcons()
{
  int i=0,y=TotalBmk()-1;
  for(i=0;i<y;i++)
  {
    icons[i]=CreateIMGHDRFromPngFile((char*)S_ICONS[i], 2);   
  }  
  icons[15]=CreateIMGHDRFromPngFile((char*)NO_ICON, 2);   
}

*/
void InitBmk()
{
  FreeBmkList();
  int i=num_book();
  for(int j=0;j<i;j++)
    AddToBmk(j+1,bmname(j),description(j),(char*)S_ICONS[j]);
  char s[128];
  sprintf(s,"%s\\no_icon.png",img_dir);
  noico=CreateIMGHDRFromPngFile((char*)s, 0);  
}

static void DrawList(WSHDR *ws)
{
  int font_y = GetFontYSIZE(font)+2;//16+2
  int scr_w=ScreenW();
  int scr_h=ScreenH()-1;
  int y2=scr_w-(GetFontYSIZE(font)+2);
#ifdef ELKA
  itemFromDisp = sdiv(font_y,ScreenH()-CLIST_Y1-GetFontYSIZE(font)-2)-1;
#else
  itemFromDisp = sdiv(font_y,ScreenH()-CLIST_Y1-GetFontYSIZE(font)-2);
#endif
  
  LockSched();
  totalItems = TotalBmk();
 
  //     
  int pageNum = sdiv(itemFromDisp, totalItems);
  
  if( itemFromDisp*pageNum < totalItems) pageNum++; // ,   

  BOOKMARKS *bmk;
//  bmk=bmktop;
  int i=0;
  int start_y;
  int x=iconSize;

  while(i<totalItems)
  {
     if((i>=(curpage-1)*itemFromDisp) && (i<=itemFromDisp*curpage))//          curpage
        {
          bmk=GetBmkByItem(i);// 
          if(bmk)//     
          {           
//          wsprintf(out_ws,"%d. %t",i+1,bmname(i));//           
          if(bmk->desc_len)//
            wsprintf(ws,"(%d/%d) %w",curpos+1,totalItems,bmk->ws_descript);
          else
            wsprintf(ws,"(%d/%d) %t",curpos+1,totalItems,LG_NOT_DESCRIPT);
          
          start_y = (CLIST_Y1 + (i - (curpage-1)*itemFromDisp)*font_y);    //          
              
          if(i>curpos) start_y+=font_y+3;
          if(bmk->icon_size)
            //DrawImg(1,start_y+3,(int)bmk->icon);               
              DrwImage(bmk->icon,1,start_y+2,0,0);
          else
            DrwImage(noico,1,start_y+2,0,0);
            //DrawImg(1,start_y+3,(int)bmk->icon);             

          if(i==curpos)//    
          {
            DrawRoundedFrame(x-4,start_y+2,scr_w-1,start_y+(font_y*2),5,5,0,bordSelect,clrSelect);
            DrawString(bmk->ws_name,x,start_y+2,scr_w-1,start_y+font_y,font,0,fntSelect,0);
            DrawString(ws,x,YDISP+2,scr_w-1,YDISP+font_y,8,0,fntSelect,0);
            DrawString(bmk->ws_descript,x,start_y+font_y+1,scr_w-1,start_y+(font_y*2),8,0,fntSelect,0);
          }
          else
          {
            DrawRoundedFrame(x,start_y+1,scr_w-1,start_y+font_y,0,0,0,bordNotSelect,clrNotSelect);//clrBlack
            DrawString(bmk->ws_name,x,start_y+2,scr_w-1,start_y+font_y,font,0,fntNotSelect,0);          
          }            
         }
       }
      i++;
//      if(bmk->next) bmk=bmk->next;
  //    else break;
      if(i>(pageNum*itemFromDisp)) break;
  }
  UnlockSched();  
}



//  
void MoveUp()
{
  if(!itemFromDisp)return;
  if(curpos<1)
  {
    curpos=totalItems-1;
    
    if(itemFromDisp!=totalItems)
    {
      curpage = sdiv(itemFromDisp,totalItems)+1;
    }
    else
      curpage = 1;
  }
  else
  {
    curpos--;
    if(curpos<(curpage-1)*itemFromDisp){ curpos++; curpage--; }
  }
 // REDRAW();
}


void MoveDown()
{
  if(!totalItems)return;
  curpos++;  
  if(curpos>=totalItems) { curpos=0; curpage=1; }
  if(curpage*itemFromDisp<curpos){ curpos--; curpage++; } 
 // REDRAW();
}

static void OnRedraw(MAIN_GUI *data)
{  
  DrawRoundedFrame(0,YDISP+1,ScreenW()-1,ScreenH()-1,0,0,0,clrBlack,clrBlack);

  LockSched();
  char *s=malloc(128);
  sprintf(s,"%s\\%s",img_dir,"bg.png");
  DrawImg(1,YDISP,(int)s);
  sprintf(s,"%s\\%s",img_dir,"head.png");
  DrawImg(2,YDISP+2,(int)s);
  DrawLine(0,CLIST_Y1-3,ScreenW()-1,CLIST_Y1-3,0,clrWhite);
  DrawSoftKeys(data->ws1,LG_SELECT,LG_CLOSE);
  UnlockSched();

  DrawList(data->ws1);
}

static void onCreate(MAIN_GUI *data, void *(*malloc_adr)(int))
{
//  LoadIcons();
  active=1;
  data->ws1=AllocWS(256);
  data->gui.state=1;
}

static void onClose(MAIN_GUI *data, void (*mfree_adr)(void *))
{
  active=0;
  FreeWS(data->ws1);
  data->gui.state=0;
}

static void onFocus(MAIN_GUI *data, void *(*malloc_adr)(int), void (*mfree_adr)(void *))
{
  data->gui.state=2;
  DisableIDLETMR();
}

static void onUnfocus(MAIN_GUI *data, void (*mfree_adr)(void *))
{
  if (data->gui.state!=2) return;
  data->gui.state=1;
}

static int OnKey(MAIN_GUI *data, GUI_MSG *msg)
{
  DirectRedrawGUI(); 
  int k=msg->gbsmsg->submess;
  if (msg->gbsmsg->msg==KEY_DOWN || msg->gbsmsg->msg==LONG_PRESS)
  {
    switch(msg->gbsmsg->submess)
    {
    case UP_BUTTON:   MoveUp();   break;
    case DOWN_BUTTON: MoveDown(); break;
    case '*' : PrintAbout();      break;    
    case '#' :
      {
        WSHDR *ws;
        ws=AllocWS(150);
        extern const char *successed_config_filename;
        str_2ws(ws,successed_config_filename,128);
        ExecuteFile(ws,0,0);
        FreeWS(ws);
      }
      break;      
    case RIGHT_SOFT:case RED_BUTTON: return (1);
    }
  }
  
  if (k=='0')
  {
    if (RunBM2(9)) return 1;
  }

  if ((k>='1')&&(k<='9'))
  { 
    if (RunBM2(k-'1')) return 1;
  }
  
  if ((msg->gbsmsg->msg==KEY_DOWN) && (k==ENTER_BUTTON || k==LEFT_SOFT))
  {
    if (RunBM2(curpos)) return(1);
  }
  return(0);
}

extern void kill_data(void *p, void (*func_p)(void *));

int method8(void){return(0);}
int method9(void){return(0);}

const void * const gui_methods[11]={
  (void *)OnRedraw,
  (void *)onCreate,
  (void *)onClose,
  (void *)onFocus,
  (void *)onUnfocus,
  (void *)OnKey,
  0,
  (void *)kill_data,
  (void *)method8,
  (void *)method9,
  0
};

const RECT Canvas={0,0,0,0};
void ShowMenu()
{
//  active=0;
  MAIN_GUI *main_gui=malloc(sizeof(MAIN_GUI));
  zeromem(main_gui,sizeof(MAIN_GUI));
  main_gui->gui.canvas=(void *)(&Canvas);
  main_gui->gui.methods=(void *)gui_methods;
  main_gui->gui.item_ll.data_mfree=(void (*)(void *))mfree_adr();
  //patch_rect((RECT*)&Canvas,0,YDISP,ScreenW()-1,ScreenH()-1);
  menus_id=CreateGUI(main_gui); 
}

int mode=0;
int mode_enter;

int my_keyhook(int submsg, int msg)
{
  if(submsg==ACTIVE_KEY_1 && ACTIVE_KEY_STYLE!=2 && !active)
    {      
      switch(msg)
      {
        case KEY_DOWN:
          if (!ACTIVE_KEY_STYLE)
          {
            if(IDLE_MODE)//    
            {
              if(ENA_LOCK)//    
              {
                 if(IsIdle())//    
                 {
                  ShowMenu();
                 }
                 else//       
                 {
                  GBS_SendMessage(MMI_CEPID,KEY_UP,ACTIVE_KEY_1);break;
                 }
              }
              else//     
              {
                if(IsIdle() && IsUnlocked())
                 {
                  ShowMenu();
                 }
                else
                 {
                  GBS_SendMessage(MMI_CEPID,KEY_UP,ACTIVE_KEY_1);break;
                 }
              }
             }            
            else // 
              if(ENA_LOCK) ShowMenu();
              else if(IsUnlocked())
               {
                ShowMenu();
               }
            return(2);
          }
          else
          {
            if (mode_enter==2)
            {
              GBS_SendMessage(MMI_CEPID,KEY_UP,ACTIVE_KEY_1);
              return (0);
            }
            mode_enter=0;
            return (2);
          }          
        case KEY_UP:
          if (ACTIVE_KEY_STYLE)
          {
            if (mode_enter==0)
            {
              mode_enter=2;
              GBS_SendMessage(MMI_CEPID,KEY_DOWN,ACTIVE_KEY_1);
              return (2);
            }
            if (mode_enter==2)
            {
              mode_enter=0;
              return (0);
            }
            mode_enter=0;
            return (2);
          }          
        case LONG_PRESS:
          if (ACTIVE_KEY_STYLE)
          {
            mode_enter=1;
            if(IDLE_MODE)
            {
              if(ENA_LOCK)
              {
                 if(IsIdle())
                 {
                  ShowMenu();
                 }
                 else
                 {
                   GBS_SendMessage(MMI_CEPID,KEY_UP,ACTIVE_KEY_1);break;
                 }
              }
              else
              {
                if(IsIdle() && IsUnlocked())
                 {
                  ShowMenu();
                 }
              else
                 {
                   GBS_SendMessage(MMI_CEPID,KEY_UP,ACTIVE_KEY_1);break;
                 }
              }
             }
            else
            {
              if(ENA_LOCK) ShowMenu();
              else if(IsUnlocked())
              {
                ShowMenu();
              }
            }
          }
         break;
      }
    }
  else
  {
  // * + # implementation
  if ((ACTIVE_KEY_STYLE==2) && (!active))
  {
    if (msg==KEY_UP)
    {
      mode=0;
      return KEYHOOK_NEXT;
    }
    if (msg==KEY_DOWN)
    {
      switch (submsg)
      {
      case '*':
        mode=1;
        return (0);
      case '#':
        if (mode==1)
        {
          if(ENA_LOCK) ShowMenu();
          else if(IsUnlocked())
          {
           ShowMenu();
          }
          else mode=0;
         }
        else { active=0; return KEYHOOK_NEXT; }
      }
     }
    }
  }  
return 0;
}

static void maincsm_oncreate(CSM_RAM *data)
{
  InitBmk();
  GBS_SendMessage(MMI_CEPID,MSG_IPC,IPC_UPDATE_STAT,&gipc);
}


//---------------------------------------------------------------------------//

int strcmp_nocase(const char *s1,const char *s2)
{
  int i;
  int c;
  while(!(i=(c=toupper(*s1++))-toupper(*s2++))) if (!c) break;
  return(i);
}


void ElfKiller(void)
{
  extern void *ELF_BEGIN;
  kill_data(&ELF_BEGIN,(void (*)(void *))mfree_adr());
}


static void maincsm_onclose(CSM_RAM *csm)
{
  FreeBmkList();
  RemoveKeybMsgHook((void *)my_keyhook);
  SUBPROC((void *)ElfKiller);
}


static int maincsm_onmessage(CSM_RAM *data, GBS_MSG *msg)
{
  MAIN_CSM *csm=(MAIN_CSM*)data;
  if ((msg->msg==MSG_GUI_DESTROYED)&&((int)msg->data0==csm->gui_id))
  {
    csm->csm.state=-3;
  }
  
  if (msg->msg==MSG_RECONFIGURE_REQ)
  {
    extern const char *successed_config_filename;
    if (strcmp_nocase(successed_config_filename,(char *)msg->data0)==0)
    {
      ShowMSG(1,(int)"AltMyMenu2 config updated!");
      InitConfig();
      InitBmk();
    }
  }
  
  if (msg->msg==MSG_IPC)
  {
    IPC_REQ *ipc;
    if ((ipc=(IPC_REQ*)msg->data0))
    {
      if (strcmp_nocase(ipc->name_to,ipc_my_name)==0)
      {
        switch (msg->submess)
        {
        case IPC_UPDATE_STAT:
          GBS_StartTimerProc(&mytmr, 10*TMR_SECOND/10, TimerProc);break;
        }
      }
    }
  }

  return(1);
}


static const struct
{
  CSM_DESC maincsm;
  WSHDR maincsm_name;
}MAINCSM =
{
  {
  maincsm_onmessage,
  maincsm_oncreate,
#ifdef NEWSGOLD
  0,
  0,
  0,
  0,
#endif
  maincsm_onclose,
  sizeof(MAIN_CSM),
  1,
  &minus11
  },
  {
    maincsm_name_body,
    NAMECSM_MAGIC1,
    NAMECSM_MAGIC2,
    0x0,
    139
  }
};

void UpdateCSMname(void)
{
  wsprintf((WSHDR *)(&MAINCSM.maincsm_name),"AltMyMenu2");
}


int main(char *exename, char *fname)
{ 
/*  MAIN_CSM main_csm;
  InitConfig();
  LockSched();
  UpdateCSMname();
  CreateCSM(&MAINCSM.maincsm,&main_csm,0);
  UnlockSched();*/
  
  CSMROOT *csmr;
  CSM_RAM *save_cmpc;
  CSM_RAM main_csm;
  InitConfig();
  UpdateCSMname();
  LockSched();

  AddKeybMsgHook((void *)my_keyhook);
  csmr=CSM_root();
  save_cmpc=csmr->csm_q->current_msg_processing_csm;
  csmr->csm_q->current_msg_processing_csm=csmr->csm_q->csm.first;
  my_csm_id=CreateCSM(&MAINCSM.maincsm,&main_csm,0);
  csmr->csm_q->current_msg_processing_csm=save_cmpc;
  UnlockSched();
  
  //strcpy(img_dir,exename);
//  for(int i=strlen(img_dir);img_dir[i]!='\\';i--) img_dir[i]=0;
  //strcat(img_dir,"img");  
  strcpy(img_dir,path);
  return 0;
}
