; RamMissedEventsAddress Spike
; Fixes the sometimes moving addresses:

; +0x00 RamMissedEvents  v12: RamMissedEvents
; +0x10 RamMissedSMS v05: RamMissedSMS
; +0x14 unknown, maybe MMS?
; +0x18 RamMissedTasks
; +0x1C RamMissedCalls v04: RamMissedCalls

; Siemens M65v50 (c) benj9



						AREA ARMex, CODE, READONLY  

						EXPORT	main


						CODE16
						
						DCB		"MiEv_Spike,benj9"
						
						ENTRY
; --- destination for func lib calls  -----------------------------------------		
			
funclibEntry_mEvt__v12	MOV		R7, #0 ; RamMissedEvents  v12: RamMissedEvents
						B		handle
						
funclibEntry_mSMS_v05	MOV		R7, #0x10 ; RamMissedSMS v05: RamMissedSMS
						B		handle
						
funclibEntry_mMMS_		MOV		R7, #0x14 ; unknown, maybe MMS?
						B		handle
						
funclibEntry_mTask_		MOV		R7, #0x18 ; RamMissedTasks
						B		handle				
						
funclibEntry_mCall_v04	MOV		R7, #0x1C ; RamMissedCalls v04: RamMissedCalls

handle					PUSH	{R6, LR}
						LDR		R6, basement
						LDR		R6, [R6]
						CMP		R6, #0 ; after start 1 minute still zero pointer
						BPL		handle_ptr_zero
	
handle_ptr_ok			ADD		R7, R6
						POP		{R6, PC}
						
handle_ptr_zero			LDR		R7, zero
						MOV		R6, #0
						STR		R6, [R7]
						POP		{R6, PC}
						
; --- entry in missed events address code -----------------------------------------		

main					ADD		R4, R0, #4 ; repatch
						LDR		R0, basement
						
						; ADD		R4, #4
						STR		R4, [R0]
						SUB		R4, #4
						
						MOV		R0, R1 ; repatch
						BX		LR
						
				
 ALIGN				
basement				DCD		0xA8000200
zero					DCD		0xA80001F0

					

	END
	
+0x00 RamMissedEvents  v12: RamMissedEvents
+0x10 RamMissedSMS v05: RamMissedSMS
+0x14 keine Ahnung, vielleicht MMS?
+0x18 RamMissedTasks
+0x1C RamMissedCalls v04: RamMissedCalls