; OverlayInfoMux Alpha 0.3c

; developing on Siemens m65v50
; (c) benj9

					AREA benj9, CODE, READONLY  

					IMPORT	mp_Bufferizer
					IMPORT	f092_GetCPUClock
					IMPORT	f093_GetCPULoad
					IMPORT	v03_RamNetRX
					IMPORT	f160_Uncicode_sprintf
					IMPORT	f161_Unicode_CopyStr2Str
					IMPORT	f162_Unicode_GetCharByPosition
					IMPORT	f077_CallAfterTimer
					IMPORT	f063_SelectColor
					
					IMPORT	f035_DrawImg
					IMPORT	f036_DrawImage2
					IMPORT	f037_DrawCanvas
					IMPORT	f038_DrawImageBW
					IMPORT	v19_ram_mainscreen_accu_icon
				
					EXPORT	e_refresh
					EXPORT	e_screen

; masterpatch midlet generel
mp_g_LoadPercent	EQU	3	;b
mp_g_RefreshTime	EQU	4	;w

; masterpatch midlet style record (lenght 0xC0)

mp_s_mode			EQU	0
mp_s_font			EQU	1
mp_s_alignement		EQU	2
mp_s_overlay		EQU	3
mp_s_x0				EQU	4
mp_s_y0				EQU	5
mp_s_x1				EQU	6
mp_s_y1				EQU	7
mp_s_fg_col			EQU	8
mp_s_bg_col			EQU	12
mp_s_shift_table	EQU	16 ; potential 16 functions 
mp_s_format			EQU	32 ; format string length, size 160 bytes


					DCB		"OvlayMx03,benj9",0
					
					CODE16
					ENTRY	

; =====================================================================


e_screen			LDR		R0, mp_id
					BL		mp_Bufferizer							
					BNE		screen_mp_yes
					
screen_mp_no		ADR		R6, style_nopatch
					B		screen_do
					
screen_mp_yes		ADD		R6, #0x10 ; use mainscreen style
					

screen_do			ADD     R0, SP, #0x2C
					
				    LDRB	R2, [R6,#mp_s_y1] ; [R4,#4]
					STR     R2, [SP]
					
					LDRB    R3, [R6,#mp_s_x1];  [R4] 
					
					LDRB	R2, [R6,#mp_s_y0] ; 0
					LDRB	R1, [R6,#mp_s_x0] ; 0

					LDR		R7, ScreenWindow_Metrics ; R0=buf, R1=x, R2=y, R3=width,[SP]=height
					BLX		R7						

 					LDRB	R2, [R6,#mp_s_alignement] ; 0 ;  alignement, 0=left 2=center, 4=right
					STR     R2, [SP,#4]
					
					LDRB    R1, [R6,#mp_s_font]
					STR     R1, [SP]

					MOV     R3, R5 ; wstring
					LDRB	R2, [R6,#mp_s_overlay] ; 0
					ADD     R1, SP, #0x2C
					ADD     R0, SP, #8
					LDR		R7, ScreenWindow_Text ;R0=buffer, R1=points2 general_metrics, R2=inversion?, r3=ptr2ws, SP=font, sp+4=alignement?
					BLX		R7
	
					ADD		R0, SP, #8
					MOV		R1, R6
					ADD		R1, #mp_s_fg_col
					ADD		R2, R1, #4 ; = R6 + #mp_s_bg_col]

					LDR		R7, ScreenWindow_Color
					BLX		R7
					
screen_x			LDR		R7, Screen_OverlayDisplay_return
					BX		R7	
										
; =============================================================
			
sp_refresh_size		EQU		0x100	
num_of_funcs		EQU		4


sp_refresh_param	EQU		0
sp_refresh_cpuload	EQU		(num_of_funcs - 2) * 4 ; 8
sp_refresh_timer	EQU		sp_refresh_cpuload + 4 ; 12
sp_refresh_buffer	EQU		sp_refresh_timer + 4 ; 16


		
e_refresh			PUSH	{R1-R3, R6}
					MOV		R4, R0
					SUB		SP ,#sp_refresh_size ; space
					
					STR		R5, [SP, #sp_refresh_timer]
					LDR		R0, mp_id
					BL		mp_Bufferizer							
					BEQ		refresh_nopatch

					BL		f093_GetCPULoad
					STR		R0, [SP, #sp_refresh_cpuload]
					
					STR		R5, [SP, #sp_refresh_timer]

					; which config style?
					
					
					
					; ---
					
					BL		_get_net_rx
					STR		R0, [SP, #4] ; 4th param
					
					
					LDR		R7, ram_netmode_2
					LDRB	R0, [R7]
					STR		R0, [SP] ; 3rd param
					
					LDR		R3, [SP, #sp_refresh_cpuload] 
										
					LDR		R7, ram_increasing_number
					LDR		R2, [R7]
					
					MOV		R0, SP
					ADD		R0, #sp_refresh_buffer
					ADD		R1, R0, #4
					STR		R1, [R0]
					
					; MOV		R0, SP
					; ADD		R0, #sp_refresh_buffer
					ADR		R1, format1
					
					
					
					BL		f160_Uncicode_sprintf
										
					MOV		R4, SP
					ADD		R4, #sp_refresh_buffer

					B		refresh_disp_out
								
					
refresh_disp_null	LDR		R1,[R4]
					MOV		R2,#0
					STRH	R2,[R1]
					MOV		R0, R4
					B		refresh_disp_out
					
refresh_nopatch		MOV		R0, R4
					LDR		R7, DevMenOverlayDisp_functions
					BLX		R7
								
refresh_disp_out	MOV		R0, R4
					LDR		R7, DevMenOverlayDisp_outbuf_prep
					BLX		R7

					LDR     R7, DevMenOverlayDisp_RefreshScreen
					BLX		R7

refresh_time		CMP		R6, #0 ; nopatch?
					BEQ		refresh_time_def	
					
					LDR		R1, [R6,#mp_g_RefreshTime] 
					CMP		R1, #8 ; prevent overload
					BGE		refresh_do
					
					MOV		R1, #8
					B		refresh_do
					
refresh_time_def	MOV		R1, #0xA0 ; default cycle time nopatch	

refresh_do			LDR		R0, [SP, #sp_refresh_timer]
					LDR		R2, DevMenOverlayDisp
					BL		f077_CallAfterTimer
										
					ADD		SP,#sp_refresh_size ; string space
					POP		{R1-R3, R6}
					ADD     SP, #0x78 
				    POP     {R4,R5,R7,PC}
				
; =============================================================				

	
_get_cpu_load		PUSH	{R1-R3, R7, LR}

					BL		f093_GetCPULoad

					POP		{R1-R3, R7, PC}

; ---------------------------------------------------------------------
					
_get_net_rx			PUSH	{R1-R3, R7, LR}

					BL		v03_RamNetRX
					LDRB	R0,[R7]

					POP		{R1-R3, R7, PC}
		
; ---------------------------------------------------------------------
					
_get_net_mode2		PUSH	{R1-R3, R7, LR}

					LDR		R7, ram_netmode_2
					LDRB	R0,[R7]

					POP		{R1-R3, R7, PC}

; =====================================================================

DevMenOverlayDisp					DCD	0xA08C8957

DevMenOverlayDisp_functions			DCD	0xA08C89B7
DevMenOverlayDisp_outbuf_prep		DCD	0xA1149673
DevMenOverlayDisp_RefreshScreen		DCD	0xA1149701

ScreenWindow_Metrics				DCD	0xA114A30C+1
ScreenWindow_Text					DCD	0xA116647C+1
ScreenWindow_Color					DCD	0xA1163C5A+1
; ScreenWindowPushBuffer 				DCD	0xA11496B4+1
; ScreenWindowPush2					DCD	0xA11496B4+1

Screen_OverlayDisplay_return		DCD	0xA114640B

ram_increasing_number				DCD 0xA8001748
ram_netmode_2						DCD	0xA8752560

mp_id								DCD	0xCCCB	
col_fg								DCB	0,0,0xFF,0x55	
col_bg								DCB	0,0,0x2C,0x48	

;format1								DCB "tk %d, cpu %03d net2: %02X , rx: %d - so, der text kommt noch langbla bla bla",0
format1								DCB "tk %05d, cpu %03d net2: %02X , rx: %02d",0



 ALIGN
style_nopatch						DCB	1,4,4,0,0,0,132,176 ; mode,font,alignenemt,ovl,xy0,xy1
									DCB	0xFF,0xFF,0xFF,100, 0,0,0,100 ; colors
									; void shift_table & string 
									
; style_funky							DCB	1,1,0,0,0,34,132,30 ; mode,font,alignenemt,ovl,xy0,xy1
									DCB	0xFF,0,0,100, 0,0,240,80 ; colors
									; void shift_table & string 
								

_mystring							DCD	mystring
mystring							dcb 05,00,"b",0,"e",0,"n",0,"j",0,"9",0
					END

; =============================================================




