; OverlayInfoMux Alpha 0.3

; developing on Siemens m65v50
; (c) benj9

					AREA benj9, CODE, READONLY  

					IMPORT	mp_Bufferizer
					IMPORT	f092_GetCPUClock
					IMPORT	f093_GetCPULoad
					IMPORT	v03_RamNetRX
					IMPORT	f160_Uncicode_sprintf
					IMPORT	f161_Unicode_CopyStr2Str
					IMPORT	f162_Unicode_GetCharByPosition
					IMPORT	f077_CallAfterTimer
					IMPORT	f063_SelectColor
					
					IMPORT	f035_DrawImg
					IMPORT	f036_DrawImage2
					IMPORT	f037_DrawCanvas
					IMPORT	f038_DrawImageBW
					IMPORT	v19_ram_mainscreen_accu_icon
				
					EXPORT	e_refresh
					EXPORT	e_screen

; masterpatch midlet generel
mp_g_LoadPercent	EQU	3	;b
mp_g_RefreshTime	EQU	4	;w

; masterpatch midlet style record (lenght 0xC0)

mp_s_mode			EQU	0
mp_s_font			EQU	1
mp_s_alignement		EQU	2
mp_s_overlay		EQU	3
mp_s_x0				EQU	4
mp_s_y0				EQU	5
mp_s_x1				EQU	6
mp_s_y1				EQU	7
mp_s_fg_col			EQU	8
mp_s_bg_col			EQU	12
mp_s_shift_table	EQU	16 ; potential 16 functions 
mp_s_format			EQU	32 ; format string length, size 160 bytes


					DCB		"OvlayMx03,benj9",0
					
					CODE16
					ENTRY	

; =====================================================================

e_screen			LDR		R0, mp_id
					BL		mp_Bufferizer							
					BNE		screen_mp_ok
					
screen_mp_not_ok	ADR		R6, style_nopatch
					B		screen_do
					
screen_mp_ok		ADD		R6, #0x10 ; use mainscreen style
					
screen_do			
					LDR		R0,=0xA8750000
					ADD     R0, #0x2C
					
					MOV		R2,#0x50
					STR     R2, [SP]
					
					MOV		R3,#0x40
					
					MOV		R2,#0x30
					MOV		R1,#0x20

					LDR		R7, ScreenWindow_Metrics ; R0=buf, R1=x, R2=y, R3=width,[SP]=height
					BLX		R7						

					MOV		R2,#0
					STR     R2, [SP,#4]
					
					MOV		R1,#3
					STR     R1, [SP]

					ADR		R3, _mystring
					LDRB	R2, [R6,#mp_s_overlay] ; 0
					
					LDR		R0,=0xA8750000
					LDR		R1,=0xA8750000
					ADD     R1, #0x2C					
					ADD     R0, #0x8					
	
					LDR		R7, ScreenWindow_Text ;R0=buffer, R1=points2 general_metrics, R2=inversion?, r3=ptr2ws, SP=font, sp+4=alignement?
					BLX		R7
	
					LDR		R0,=0xA8750000
					ADD     R0, #0x8					
					MOV		R1, R6
					ADD		R1, #mp_s_bg_col
					SUB		R2, R1, #4 ; = R6 + #mp_s_bg_col]

					LDR		R7, ScreenWindow_Color
					BLX		R7

					LDR		R1,=0xA8750000
					ADD     R1, #0x8
					MOV		R0,R4
					LDR		R7,ScreenWindowPushBuffer
					BLX		R7		
					
					LDR		R0,=0xA8750000
					ADD     R0, #0x8
					LDR		R7,ScreenWindowPush2
					BLX		R7				
					; -----

					ADD     R0, SP, #0x2C
					
				    LDRB	R2, [R6,#mp_s_y1] ; [R4,#4]
					STR     R2, [SP]
					
					LDRB    R3, [R6,#mp_s_x1];  [R4] 
					
					LDRB	R2, [R6,#mp_s_y0] ; 0
					LDRB	R1, [R6,#mp_s_x0] ; 0

					LDR		R7, ScreenWindow_Metrics ; R0=buf, R1=x, R2=y, R3=width,[SP]=height
					BLX		R7						

 					LDRB	R2, [R6,#mp_s_alignement] ; 0 ;  alignement, 0=left 2=center, 4=right
					STR     R2, [SP,#4]
					
					LDRB    R1, [R6,#mp_s_font]
					STR     R1, [SP]

					MOV     R3, R5 ; wstring
					LDRB	R2, [R6,#mp_s_overlay] ; 0
					ADD     R1, SP, #0x2C
					ADD     R0, SP, #8
					LDR		R7, ScreenWindow_Text ;R0=buffer, R1=points2 general_metrics, R2=inversion?, r3=ptr2ws, SP=font, sp+4=alignement?
					BLX		R7
	
					ADD		R0, SP, #8
					MOV		R1, R6
					ADD		R1, #mp_s_fg_col
					ADD		R2, R1, #4 ; = R6 + #mp_s_bg_col]

					LDR		R7, ScreenWindow_Color
					BLX		R7
					

screen_x			LDR		R7, Screen_OverlayDisplay_return
					BX		R7	
										
; =============================================================
					
					
					
e_refresh			PUSH	{R1-R3, R6}
					MOV		R4, R0
					
					LDR		R0, mp_id
					BL		mp_Bufferizer							
					BEQ		refresh_nopatch
					
					; BL		_get_cpu_load

					
					
					MOV		R2, R0
					ADR		R1, format1
					MOV		R0, R4
					BL		f160_Uncicode_sprintf
											
					B		refresh_disp_out
					
					
refresh_disp_null	LDR		R1,[R4]
					MOV		R2,#0
					STRH	R2,[R1]
					B		refresh_disp_out
					
refresh_nopatch		MOV		R0, R4
					LDR		R7, DevMenOverlayDisp_functions
					BLX		R7
					
refresh_disp_out	MOV		R0, R4
					LDR		R7, DevMenOverlayDisp_outbuf_prep
					BLX		R7

					LDR     R7, DevMenOverlayDisp_RefreshScreen
					BLX		R7
					
					LDR		R1, [R6,#mp_g_RefreshTime] 
					CMP		R1,#8 ; prevent overload
					BGE		refresh_do
								
;refresh_nopatch		MOV		R1,#0x36 ; standard value

refresh_do			MOV		R0, R5 
					LDR		R2, DevMenOverlayDisp
					BL		f077_CallAfterTimer
					
					
					; CHECK: ###
					
					ADD     SP, SP, #0x78 

					POP		{R1-R3, R6}
				    POP     {R4,R5,R7,PC}
				
; =============================================================				

	
_get_cpu_load		PUSH	{R1-R3, R7, LR}

					BL		f093_GetCPULoad

					POP		{R1-R3, R7, PC}

; ---------------------------------------------------------------------
					
_get_net_rx			PUSH	{R1-R3, R7, LR}

					BL		v03_RamNetRX
					LDRB	R0,[R7]

					POP		{R1-R3, R7, PC}
		
; ---------------------------------------------------------------------
					
_get_net_mode2		PUSH	{R1-R3, R7, LR}

					LDR		R7, ram_netmode_2
					LDRB	R0,[R7]

					POP		{R1-R3, R7, PC}
					
; =====================================================================

testcat				PUSH	{R0-R7, LR}

					ADR		R0, _mystring
					LDR		R7,DevMenOverlayDisp_outbuf_prep
					BLX		R7
					LDR     R7, DevMenOverlayDisp_RefreshScreen
					BLX		R7
					
					LDR		R0,=0xA8000270
					LDR		R1,=500
					LDR		R2, _testcat
					BL		f077_CallAfterTimer
					

					POP		{R0-R7, PC}

; =====================================================================

_testcat	DCD	testcat					

DevMenOverlayDisp					DCD	0xA08C8957

DevMenOverlayDisp_functions			DCD	0xA08C89B7
DevMenOverlayDisp_outbuf_prep		DCD	0xA1149673
DevMenOverlayDisp_RefreshScreen		DCD	0xA1149701

ScreenWindow_Metrics				DCD	0xA114A30C+1
ScreenWindow_Text					DCD	0xA116647C+1
ScreenWindow_Color					DCD	0xA1163C5A+1
ScreenWindowPushBuffer 				DCD	0xA11496B4+1
ScreenWindowPush2					DCD	0xA11496B4+1


Screen_OverlayDisplay_return		DCD	0xA114640B

ram_netmode_2						DCD	0xA8752560

mp_id								DCD	0xCCCB	
col_fg								DCB	0,0,0xFF,0x55	
col_bg								DCB	0,0,0x2C,0x48	

format1								DCB "m65v50,%03d",0

style_nopatch						DCB	1,4,4,0,0,0,132,176 ; mode,font,alignenemt,ovl,xy0,xy1
									DCB	0xFF,0xFF,0xFF,100, 0,0,0,100 ; colors
									; void shift_table & string 
								

_mystring							DCD	mystring
mystring							dcb 05,00,"b",0,"e",0,"n",0,"j",0,"9",0
					END

; =============================================================



MOV     R2, #0          ; y pos
MOV     R1, #0          ; x pos
LDR     R3, [R4]        ; window width
BL      ScreenWindow_Metrics ; R0=buf, R1=x, R2=y, R3=width,[SP]=height
MOV     R1, #4          ;  font
MOV     R2, #0          ;  alignement, 0=left 2=center, 4=right, 0x30=invertscreem
STR     R1, [SP]
ADD     R1, SP, #0x2C
STR     R2, [SP,#4]
ADD     R3, R5, #0
ADD     R0, SP, #8
BL      ScreenWindow_Text ;R0=buffer, R1=points2 general_metrics,
;                               R2=inversion?, r3=ptr2ws, SP=font, sp+4=alignement?

MOV     R0, #0
BL      Select_Color
ADD     R5, R0, #0
MOV     R0, #1
BL      Select_Color
ADD     R1, R0, #0
ADD     R0, SP, #8
ADD     R2, R5, #0
BL      ScreenWindow_Color



	
start				PUSH	{R1-R3, R5, R6, LR}
					MOV		R4, R0
					
					LDR		R0, mp_id
					BL		mp_Bufferizer							
					BEQ		nopatch
					
					PUSH	{R4-R6}
					BL		f093_GetCPULoad
					POP		{R4-R6}
					
					LDRB	R7, [R6,#1] ; percent
					CMP		R0, R7
					BGE		mydisplay
					
					LDR		R1,[R4]
					MOV		R2,#0
					STRH	R2,[R1]
					B		out
					
mydisplay			;BL		v03_RamNetRX
					;MOV		R3, R5
					;LDRB	R2,[R7]
					
					
					MOV		R2, R0
					ADR		R1, format1
					MOV		R0, R4
					BL		f160_Uncicode_sprintf
											
					B		out
					
					
nopatch				MOV		R0, R4
					LDR		R7, DevMenOverlayDisp_functions
					BLX		R7
					
out					MOV		R0, R4
					LDR		R7, DevMenOverlayDisp_strings_graph
					BLX		R7
					
					POP		{R1-R3, R5, R6, R7}
					ADD		R7,#4
					BX		R7
						
	ALIGN
	
format1								DCB	"%03d benj9 ",0
		
; found at entrypoint
DevMenOverlayDisp_functions			DCD	0xA08C89B7
DevMenOverlayDisp_strings_graph		DCD	0xA1149673


mp_magic							DCD 0,0,0,0xB1C2D3E4
mp_id								DCD	0x0000CCCB,0,0

