; 
; x65 M65v50 (c) benj9 
; keypadlight trigger 1 rebuild

		AREA ARMex, CODE, READONLY  
            
		ENTRY
		GBLA	TYPE	;1 for M65v50, 2 for CX6C

TYPE	SETA	1 						

 IF  TYPE = 1


GetProfile    	EQU 	0xA08C9FE5
e_Keypadlight	EQU		0xA0BC78B8

 ENDIF

; func keypadlight:
; r0+r1 have to be 1, otherwise func disabled
; r2: brightness. 0,1: off. 2 darkest, approx.64 brightest. 
; r3=b0b1b2b3: b0,b1=delay, b2=special value (best 8a), b3=0
		
		CODE16
		
KeypadlightTrigger
                PUSH    {LR}
                PUSH    {R0-R7}
                
                LDR		R7, =e_Keypadlight
                LDR     R0, =GetProfile
                BLX     R0
				
				LDR     R1, =ProfileModes
                LDRB    R6, [R1,R0]
     
                
                POP     {R0-R3}


if_M__on        CMP     R6, #1
                BEQ     kpl_on

if_M__off       CMP     R6, #2
                BEQ     klp_off

if_M__delay     CMP     R6, #3
                BEQ     kpl_delay
                
if_M__sfx1      CMP     R6, #4
                BEQ     kpl_sfx1
                
if_M__sfx2      CMP     R6, #5
                BEQ     kpl_sfx2

else_kpl_exec   B       kpl_exec


klp_off         MOV     R2, #0
                B       kpl_exec

kpl_on          MOV     R2, #0x2D
                B       kpl_exec

kpl_delay       MOV		R3,#0x02
				LSL		R3,#8
				MOV		R3,#0x8A
				LSL		R3,#8
				MOV		R3,#0x1A
				LSL		R3,#8
				B       kpl_exec
						
                
kpl_sfx1    	BL		sfx
				LSR		R3,R2,#3
			    CMP		R3,#3
				BGE		kpl_sfx1_
				ADD		R3,#1
kpl_sfx1_		LSL		R3,#8
				B       kpl_exec
				
kpl_sfx2    	BL		sfx
				MOV		R3,#0x08
				LSL		R3,#8
				B       kpl_exec

kpl_exec      	BL		kpl 
kpl_x           POP     {R4-R7,PC}
                
                
kpl				PUSH	{R0-R3,LR}
                MOV     R0, #1
                MOV     R1, #1
                BLX     R7
                POP		{R0-R3,PC}

sfx				PUSH 	{R0-R6,LR}
				MOV		R4,#3
sfx_l			CMP		R4,#0
				BEQ		sfx_x
				MOV		R2,#0xFF
				MOV		R3,#3
				BL		kpl
				NOP
				NOP
				NOP
				MOV		R2,#0x0
				MOV		R3,#0
				BL		kpl
				NOP
				NOP
				SUB		R4,#1
				B		sfx_l
sfx_x			POP		{R0-R6,PC}

             
ProfileModes	DCB		4, 3, 1, 3, 2, 5, 0
;                       N, S, L, T, D, X, -
        END
/* Keypadlight Modes are:
   00 = normal
   01 = keypadlight always on
   02 = keypadlight always off
   03 = keypadlight delayed afterburner
   04 = sfx2
*/   
        
                       -----
                PUSH 	{R0-R3}           
                MOV		R3,#0
                MOV		R2,#0x2D
                BL		kpl
                NOP
                NOP
                NOP
                NOP
                NOP
                MOV		R3,#0
                MOV		R2,#0x0
                BL		kpl
                MOV		R3,#0
                MOV		R2,#0x2D
                BL		kpl
                NOP
                NOP
                NOP
                NOP
                NOP
                MOV		R2,#0x0
                MOV		R3,#0
                BL		kpl
                MOV		R2,#0x2D
                MOV		R3,#0
                BL		kpl
                NOP
                NOP
                NOP
                NOP
                NOP
                MOV		R2,#0x0
                MOV		R3,#0
                BL		kpl
                POP {R0-R3}
                -------