; Key Sequencer Test with midlet support, changed entry. SP.
; prototype
; m65v50 (c) benj9 


; conditions of sequence record: Hotkey?, SuppresslastKey, Mainscreen?


; entry m65v50
; 114C9D4: 041C251C B3F694FB ; -> A1000100
; repatch: ADD R4, R0, #0. ADD R5, R4, #0


		AREA benj9, CODE, READONLY  
            
		ENTRY
		GBLA	TYPE	;1 for M65v50, 2 for SL65v50

TYPE	SETA	1 						

 IF  TYPE = 1

free_ram			EQU	0xA8752F00

; _ram_keypress_buffer	EQU 0xA114CCF0

; internally functions addresses downstairs

; plug-in funtion addresses
PlaySoundLoop		EQU	0xA0935CF8
SwitchPhoneOff		EQU 0xA1240938
SetProfile			EQU	0xA08C9EB3
DevM_NativeMenu		EQU	0xA08E714B
DevM_Sexit			EQU 0xA0903FE1
DevM_Configuration	EQU 0xA0904301
Usr_Setup			EQU	0xA08E1AF1
Usr_FlashExplorer 	EQU 0xA08E1A35
Usr_AlarmClock		EQU 0xA08E19DF
Usr_Messages		EQU 0xA08E19BD
Usr_Organizer       EQU 0xA08E19A9
Usr_Camera			EQU 0xA08E1A05
Usr_SMS_new			EQU 0xA08E19C9

; Usr_SoundRecorder	EQU 0xA08E219B
; Usr_StopWatch	 	EQU 0xA08E19F1
; Usr_MyMenu		EQU 0xA08E2131
; Usr_CountDown 	EQU 0xA08E19FB
; Usr_Downloads		EQU	0xA08E1A81
; Usr_Pictures		EQU 0xA08E1A8B
; Usr_DynamicLight 	EQU 0xA08E1BA3
; A08E1BB3             usr_Ringtones
; A08E1C7F             usr_ClockSetup_TimeDate
; A08E19E9             usr_Calc

; constants
hotkey				EQU	0x2A ; left softkey
sp_offset			EQU	0x08
sp_offset_sub		EQU 0x14


 ENDIF
 
 
; free_ram: count_key_in_sequence[0], ..., count_key_in_sequence[n-1]
; count_key_in_sequence=0: not entered. =n: n keys accepted.

; -----------------------------------------------------------------------------

 CODE16			
 				
 				NOP 
 				; B		start
				; DCB		"KeySeq1,benj9"
				
start			PUSH	{R2-R7,LR}
				MOV		R5,R0 ; repatch related
				SUB		SP,#sp_offset ; need  more stack slots
				
				LDR		R6,IsKeyUnlock_
				BLX		R6
				STR		R0,[SP,#4] ; store KeyUnlock_State
				

; -----------------------------------------------------------------------------


init_loop		LDR		R3,=sequences
				SUB		R3,#1
				LDR		R4,=free_ram
				MOV		R7,#0 ; counter of sequences
				
loop			LDRB	R1,[R4,R7] ; counter of elements of current sequence record
				LSL		R0,R7,#4 ; *16
				ADD		R2,R3,R0 ; address of very first byte of current sequence record
				
				LDR		R6,[R2] ; R6=execAddress
				MOV		R0,#0xFF ; end-of-sequence-records-marker
				
				STR		R0,[SP] ; Skip-KeypressOn-Func(FF=False) [SP] reset with FF

				AND		R6,R0 ; is the byte in R6 FF ?
				CMP		R6,R0 
				BEQ		exit
				
				ADD		R0,R2,R1
				ADD		R0,#8 ; 
				LDRB	R6,[R0] ; R0=key sequence byte of current sequence record
				
				CMP		R5,R6 ; is currently pressed key = the current key in the current sequence?
				BNE     reset_sequence 
							
key_snapped		LDRB	R6,[R0,#1]
				CMP		R6,#0 ; sequence end reached, cause next key sequence element 0?
				BEQ		execute
				
				CMP		R1,#3 ; sequence end reached, cause maximum number of elements reached? (max=5. max-2=3)
				
				BLE		key_in_sequence

; -----------------------------------------------------------------------------


execute			PUSH	{R0-R3,R7}
				MOV		R7,R2		
				
				; test next two lines
				;MOV		R1,#0
				;STRB	R1,[R4,R7] ; reset free_ram-buf for seq
					
					
execute_sound	LDRB	R0,[R7,#0x0E] ; R0=sound for PlaySound
				LDRB	R2,[R7,#0x0F] ; R2=loops for PlaySound
				ADD		R6,R0,R2
				CMP		R6,#0
				BEQ		execu_light_on
				MOV		R1,#2
				LDR		R6,PlaySoundLoop_
				BLX		R6
				
execu_light_on	LDR		R0,[SP,#sp_offset_sub+4] ; KeyUnlockState?
				CMP		R0,#0 ; key locked?
				BNE		execute_what 
				BL		illuminatio_on

execute_what	LDR		R6,[R7] ; R6=ExecAddress or Action
				CMP		R6,#0
				BNE		execute_loadr
				
execute_midlet	LDRB	R0,[R7,#0x04] ; R0=number of midlet string
				MOV		R1,#0x30 ; length of string record
				MUL		R0,R1
				ADR		R1,midlet_fnames
				ADD		R0,R1
				MOV		R1,#1
				LDR		R6,MidletExec_
				B		execute_blx
				
execute_loadr	LDRB	R0,[R7,#4] ; R0 for exec_address
				LDRB	R1,[R7,#5] ; R1 for exec_address
				LDRB	R2,[R7,#6] ; R2 for exec_address
				LDRB	R3,[R7,#7] ; R3 for exec_address

execute_blx		STR		R4,[SP,#sp_offset_sub] ; store anything else than 0xFF in Skip-KeypressOn-Func(FF=False) to dirty it. SP: ({R0-R3,R7}: 5 regs x 4 = 20 = 0x14.
				BLX		R6
				
				
				
;execu_light_off	LDR		R0,[SP,#sp_offset_sub+4] ; KeyUnlockState?
				;CMP		R0,#0 ; key locked?
				;BNE		execute_x 
				;BL		illuminatio_off
				
execute_x	  	POP		{R0-R3,R7}
				B		reset_sequence

; -----------------------------------------------------------------------------

				
key_in_sequence	ADD		R1,#1
				B		loop_return
				
reset_sequence	MOV		R1,#0
				
loop_return		LDR		R0,[SP]
				CMP		R0,#0xFF ; Skip-KeypressOn-Func(FF=False) 
				BNE		exit ; leave patch when one sequence accepted and the action performed.
			
				STRB	R1,[R4,R7] ; reset free_ram-buf for seq
				ADD		R7,#1 ; read next key sequence record
				B		loop
				

; -----------------------------------------------------------------------------	
			
exit			ADD		SP,#sp_offset ; release my stack slot
				MOV		R1,R0 ; Skip-KeypressOn-Func(FF=False) 
				
				MOV		R0,R5 ; repatch
				
				POP		{R2-R7}
				
				;CMP		R1,#0xFF ; Skip KeypressOn_Func? (FF=False) 
				;BNE		exit_x
				LDR		R4,Keypress_On_Store2Ram_
				BLX		R4
				
exit_x			POP		{PC}
				
; -----------------------------------------------------------------------------


illumination	PUSH	{LR}
				MOV		R1,#1  
				LDR		R6,Illumination_
				BLX		R6
				POP		{PC}
				
illuminatio_on	PUSH	{LR}
				MOV		R0,#1  ; Keypadlight
				MOV		R2,#50 ; brightness 
				MOV		R3,#19 ; smoothness slooow
				BL		illumination
				MOV		R0,#0  ; Screen
				MOV		R2,#50 ; brightness 
				MOV		R3,#0x05
				LSL		R3,#8  ; smoothness slooow
				BL		illumination
				POP		{PC}
				
			
; -----------------------------------------------------------------------------

; m65v50 function addresses needed by patch core 
Keypress_On_Store2Ram_	DCD 0xA114C9D3
GetProfile_				DCD	0xA08C9FE5
Malloc_					DCD	0xA0820F98
MidletExec_				DCD	0xA0C349A8
PlaySoundLoop_			DCD	0xA0935CF8
Illumination_			DCD	0xA0BC78B8
IsKeyUnlock_			DCD	0xA114D0A7
; DrawImage				EQU 0xA16341BD


 

; -----------------------------------------------------------------------------

			ALIGN
				; strings are called just by number 0, 1, ... and so on.
midlet_fnames	DCB "2:\\amark.jar",0 ; end string with zero
				DCB 0,0,0
				DCB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; 
				DCB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; lenght 48 byte (incl. 0 to end string)

next_string		DCB "0:\\Java\\jam\\Applications\\QuotD\\Qotd.jad",0 ; end string with zero
				DCB	0,0,0,0,0,0,0 ; lenght 48 byte (incl. 0 to end string)


; -----------------------------------------------------------------------------

			ALIGN

				; DCD			0

; format: action(>=A0=address), R0(if address),8 bytes key sequence

 ; 0  1  2  3      4  5  6  7  8 9 A B C  D  E  F
; Function Address R0 R1 R2 R3 KKKKKKKKKK KK KK KK
 
; AA  action number
; R0-R3 registers R0 - R3 as bytes
; KK  elements of key sequences
 
 ; Keys: 0-9=0x30-0x39. *=0x2A. #=0x23
 ; left softkey=0x01. right softkey=0x04. red button=0x0C. green button=0x0B.
 ; joystick: up=0x3B. down=0x3C. left=0x3D. right=0x3E. click=0x1A.
sequences

				DCD	SetProfile
				DCB 0,0,0,0 ; r0-r3  set profile 1
				DCB 0x2A,0x2A,0x31,0,0 ; **1 
				DCB 0
				DCB 0,0 ; no sound
						
				DCD	SetProfile
				DCB 1,0,0,0 ; r0-r3  set profile 2
				DCB 0x2A,0x2A,0x32,0,0 ; **2
				DCB 0
				DCB 0,0 ; no sound
				
				DCD	SetProfile
				DCB 2,0,0,0 ; r0-r3  set profile 3
				DCB 0x2A,0x2A,0x33,0,0 ; **3
				DCB 0
				DCB 0,0 ; no sound
				
				DCD	SetProfile
				DCB 4,0,0,0 ; r0-r3  set profile 5
				DCB 0x2A,0x2A,0x35,0,0 ; **5
				DCB 0
				DCB 0,0 ; no sound
				
				DCD	SetProfile
				DCB 3,0,0,0 ; r0-r3  set profile 4
				DCB 0x2A,0x2A,0x34,0,0 ; **4
				DCB 0
				DCB 0,0 ; no sound
				
				DCD	SetProfile
				DCB 5,0,0,0 ; r0-r3  set profile 6
				DCB 0x2A,0x2A,0x36,0,0 ; **6
				DCB 0
				DCB 0,0 ; no sound
				
				DCD	SetProfile
				DCB 6,0,0,0 ; r0-r3  set profile 7
				DCB 0x2A,0x2A,0x37,0,0 ; **7
				DCB 0
				DCB 0,0 ; no sound
				
				DCD	SetProfile
				DCB 7,0,0,0 ; r0-r3  set profile 8
				DCB 0x2A,0x2A,0x30,0,0 ; **0
				DCB 0
				DCB 0x22,0x5 ;  
				
				DCD PlaySoundLoop
				DCB 0x3a,2,3,0 ; sfx. R0: sound: 3a. R1=2, R2=lenght, R3=0
				DCB 0x01,0x31,0,0,0,0,0,0 ;  left-sk, 1
				
				DCD PlaySoundLoop
				DCB 0x5a,2,0x15,0 ; muuuh
				DCB 0x01,0x32,0,0,0,0,0,0 ; left-sk,2
				
				DCD PlaySoundLoop
				DCB 0x5e,2,0xD,0 ; tadaa!
				DCB 0x01,0x33,0,0,0,0,0,0 ; left-sk, 3
				
				DCD PlaySoundLoop
				DCB 0x22,2,3,0 ; dialtone
				DCB 0x01,0x34,0,0,0,0,0,0 ; left-sk, 4
				
				DCD	SwitchPhoneOff
				DCD 0
				DCB 0x32,0x3B,0,0,0 ; 2, up
				DCB 0
				DCB 0x22,0x5 ; 
				
				DCD	DevM_NativeMenu
				DCD 0
				DCB 0x01,0x0B,0,0,0,0,0,0 ; left sk, green
				
				DCD	DevM_Sexit
				DCD 0
				DCB 0x23,0x23,0x30,0,0,0,0x3a,3 ; ##0
				
				DCD	DevM_Configuration
				DCD 0
				DCB 0x23,0x23,0x39,0,0,0,0x3a,3 ; ##9
				
				DCD	Usr_Setup
				DCD 0
				DCB 0x23,0x23,0x23,0x23,0,0,0x3a,2 ; ####
				
				DCD	Usr_FlashExplorer 
				DCD 0
				DCB 0x31,0x31,0x31,0x31,0,0,0x3a,1 ; 1111
				
				DCD	Usr_AlarmClock	
				DCD 0
				DCB 0x37,0x37,0x37,0x37,0,0,0,0 ; 7777
				
				DCD	Usr_Messages
				DCD 0
				DCB 0x34,0x34,0x34,0x34,0,0,0x3a,3 ; 4444
			
				DCD	Usr_Organizer
				DCD 0
				DCB 0x38,0x38,0x38,0x38,0,0,0,0 ; 8888
				
				DCD	Usr_Camera	
				DCD 0
				DCB 0x35,0x35,0x35,0x35,0,0,0,0 ; 5555
				
				DCD Usr_SMS_new
				DCD 0
				DCB 0x32,0x32,0x32,0x32,0,0,0x3a,3 ; 2222	
				
				DCD	0 ; execute MIDlet
				DCB	0,0,0,0 ; execute MIDlet number 0
				DCB 0x23,0x23,0x31,0,0,0,0x3a,3 ; ##1
				
				DCD	0 ; execute MIDlet
				DCB	1,0,0,0 ; execute MIDlet number 1
				DCB 0x23,0x23,0x32,0,0,0,0x3a,3 ; ##2
				

sequences_end	DCD 0xFF			


 END
 				hotkey disable code
 
 				LDR		R4,=free_ram
				SUB		R4,#1
				MOV		R1,#0x99
				STRB	R1,[R4] ; reset hotkey enabled flag with anything else than 1 
				ADD		R4,#1
				


				; hotkey code in start
				;LDR		R4,=free_ram
				;SUB		R4,#1
				;LDRB	R0,[R4] ; hotkey enabled flag
				;CMP		R0,#1 
				;BEQ		init_loop ; hotkey already enabled, skip
				
				;CMP		R5,#hotkey
				;BNE		init_loop ; hotkey not entered, skip to normal operation
				
				;MOV		R0,#1
				;STRB	R0,[R4] ; make hotkey enabled flag dirty 
				;STR		R0,[SP] ; make Skip-KeypressOn-Func(FF=False) dirty 
				; end hotkey code


illuminatio_off	PUSH	{LR}
				MOV		R0,#1  ; Keypadlight
				MOV		R2,#0 ; brightness
				MOV		R3,#19 ; smoothness slooow
				BL		illumination
				MOV		R0,#0  ; Screen
				MOV		R2,#0 ; brightness
				MOV		R3,#0x02
				LSL		R3,#8  ; smoothness slooow
				BL		illumination
				POP		{PC}
				