; Key Sequencer Beta 3
; m65v50 (c) benj9 

; start hotkey flag new error
; cond engine
; showmessageInR2 ...
; funLib schtzen
; AND/TST opten
; parameter neu einstellen
; shutd schtzen
; check sample keys



; entry m65v50
; 114C9D4: 041C251C B3F694FB ; -> A1000100
; repatch: ADD R4, R0, #0. ADD R5, R4, #0


			AREA benj9, CODE, READONLY              
			ENTRY
			; GBLA	FIRMWARE	; defined in project/target

; FIRMWARE	SETA	1 ; $FW_target 	; 1=m65v50, 2=sl65v50, 3=m75v13				

; uses func lib no. 2, 20, 31, 52, 68, 75

; constants
number_of_sequence_records	EQU	35 + 3
profile_key					EQU 255 ; 0n01111111 

hotkey						EQU	"*" ; 
sp_param					EQU	0x24 ; 9 additional parameters needed. 9x4=0x24
sp_sub_scan_key_sequences	EQU	0x1C ; 7 pushes
; 0x14 ; PUSH {R0-R3,R7}: 5 regs pushed, 5*4=0x14
sp_ActionPerformed			EQU 0    ; [SP,#0] ; SequAccepted&ActionPerformed(FF=False)
sp_SequenceRecords 			EQU 8    ; [SP,#8] ; number of sequence records
sp_ScanKeySequencesMode		EQU 0xC  ; [SP,#0xC] ; scan_key_sequences - mode. 0=direct mode. 1=after hotkey mode.
sp_AnySequenceTouched		EQU 0x10 ; [SP,#0x10] ; is in ScanKeySequences the key in at least one sequence?
sp_Direct_or_Hotkey_seq		EQU	0x14
sp_State_keylock			EQU 4     ; keylock state
sp_State_screensaver		EQU 0x18  ; screensaver state
sp_State_keylock_addr		EQU 0x20  ; address of keylock state
sp_State_screensaver_addr	EQU 0x1C  ; address of screensaver state
			
;[_ram_mainscreen_accu_icon_,#2] ; Mainscreen_Menu_State. 0 on boot, FF on everything else then mainscreen 

ram_sp_main									EQU 0
ram_offset_hotkey_mode						EQU	4 ; [ram_basement+0] hotkey-mode
ram_offset_keypress_after_hotkey_counter	EQU 5 ; [ram_basement+1] keypress-after-hotkey-counter
ram_offset_sequence_record_table			EQU	6 ; ; [ram_basement+3]... sequence record buffers 

number_of_action_params		EQU 5 ; "FFFFFFFx" - commands of sequence records

FF					EQU 0xFF

 
; ram_basemen+2: count_key_in_sequence[0], ..., count_key_in_sequence[n-1]
; count_key_in_sequence=0: not entered. =n: n keys accepted.

; -----------------------------------------------------------------------------

 CODE16			
 
 IMPORT	sequences
 IMPORT keyseq_strings
 EXPORT main				

					DCB		"KeySeq2,benj9",0
				
main				PUSH	{R0-R7,LR}

					SUB		SP,#sp_param ; need more stack slots
					MOV		R5,R0 ; save R5 = key number
					
					LDR		R0,free_ram_dword_
					LDR		R0,[R0]
					CMP		R0,#1
					BEQ		m_nopatch
					
					LDR		R1,ram_mainscreen_accu_icon_
					LDRH	R1,[R1]
					CMP		R1,#0 ; phone boots up?
					BEQ		m_nopatch
					
					BL		_is_shutdown
					BEQ		m_nopatch
						
					BL		_get_scrsaver
					STR		R0,[SP,#sp_State_screensaver]
					
					BL		_get_keylock
					STR		R0,[SP,#sp_State_keylock]
					STR		R6,[SP,#sp_State_keylock_addr]	
					
					LDR		R6,=0xFF00
					CMP		R1,R6 ; mainscreen-status off because key seq called a func?
					BNE		m_profile_check
					CMP		R0,#1 ; is keylock on?
					BNE		m_profile_check
					MOV		R6,#68 ; TempLigntOn ; if command launched in keylock mode, no illumination events. therefore in this case, we turn it on.
					MOV		R0,#3 ; turn all lights on
					BL		_FuncLib
					
m_profile_check		MOV		R6,#2 ; GetProfile
					BL		_FuncLib
					MOV 	R6,#profile_key
					LSR		R6, R0
					
					MOV		R0 ,#1
					;AND		R6, R0
					;CMP		R6, #1
					TST		R6,R0 ; #OPT#
					BNE		m_init
					
m_nopatch			MOV		R0,R5
					LSL     R1,R0,#0x18 ; key_off=key_on+0x80
					BMI     m_off_exec ; is negative?	
					B		m_on_exec

m_init				MOV		R7,#number_of_sequence_records
					STR		R7,[SP,#sp_SequenceRecords] ; [SP,#8]=number of records
									
					
m_init_ram			LDR		R0,free_ram_dword_
					LDR		R4,[R0]
					CMP		R4,#0
					BNE		m_init_1
					
					ADD		R0,R7,#ram_offset_sequence_record_table
					MOV		R6,#20 ; Malloc
					BL		_FuncLib
					MOV		R4,R0
					LDR		R0,free_ram_dword_
					CMP		R4,#0
					BNE		m_init_ram_1
					
m_init_ram_no		MOV		R1,#1
					STR		R1,[R0] ; lock

					; MOV		R0,#0 ; no mem error message
					; BL		_error_message
					B 		m_nopatch
					
m_init_ram_1		STR		R4,[R0]
													
m_init_ram_reset	; reset all ram buffers to zero 
					MOV		R0,#0
					MOV		R1,#0
					STR		R0,[SP,#sp_AnySequenceTouched]
					STR		R0,[R4]
					
					; ADD		R4,#ram_offset_sequence_record_table
m_init_ram_reset_l	CMP		R0,R7 ; last sequence
					BEQ		m_init_ram_x
					STRB	R1,[R4,R0] ; store zero to ram
					ADD		R0,#1 ; reset next ram sequence buffer
					B		m_init_ram_reset_l

m_init_ram_x		; SUB		R4,#ram_offset_sequence_record_table
					MOV		R0,SP ; save SP to fall back at func lib error
					STR		R0,[R4,#ram_sp_main]
					BL		_sound_init_ok
					
					; popup
					;B		main_exit

m_init_1			MOV		R0,R5 ; put R0 = pressed key
					LDRB	R2,[R4,#ram_offset_hotkey_mode] ; hotkey enabled flag

m_on_off	 		LSL     R1,R0,#0x18 ; key_off=key_on+0x80
					BMI     m_off ; is negative?

m_on				CMP		R0,#hotkey ; ###hotkey###
					BNE		m_on_hotk_no
					
m_on_hotk_yes		CMP		R2,#1 ; is hotkey already enabled?
					BGE		m_on_hotk_escape ; hotkey already enabled
					
m_on_hotk_activate	MOV		R2,#2 ; lock hotkey flag
					STRB	R2,[R4,#ram_offset_hotkey_mode] ; enable hotkey flag
					MOV		R2,#0 ; zero keypresses-after-hotkey-counter
					STRB	R2,[R4,#ram_offset_keypress_after_hotkey_counter] ; NEW
					
					MOV		R0,#0x78 ; 62; 0x22 ; ##########  hotkey activation sound
					MOV		R2,#1 ; 1
					BL		_playsoundloop
					B		main_exit
					
m_on_hotk_no		CMP		R0,#0xC ; red button
					BEQ		m_on_hotk_escape ; kill hotkey on red button
			
					CMP		R2,#0 ; isnt hotkey already enabled?
					BNE		m_on_hotk_snapped
					
					MOV		R1,#0 
					STR		R1,[SP,#sp_ScanKeySequencesMode]  ; without hotkey, direct mode.
					BL 		scan_key_sequences
					B		m_on_exec 	
					
m_on_hotk_snapped	MOV		R1,#1
					STR		R1,[SP,#sp_ScanKeySequencesMode]  ; after hotkey .
					BL 		scan_key_sequences
					
					; NEW
					LDRB	R2,[R4,#ram_offset_keypress_after_hotkey_counter] ; [ram_basement+1] keypress-after-hotkey-counter
					ADD		R2,#1
					STRB	R2,[R4,#ram_offset_keypress_after_hotkey_counter] ; increase the counter 

					LDR		R2,[SP,#sp_AnySequenceTouched]
					CMP		R2,#1
					BEQ		m_on_hotk_touched_y

					BL		_sound_key_failed
					B		m_on_hotk_touched_n
					
m_on_hotk_touched_y	CMP		R1,#FF ; SequAccepted&ActionPerformed(FF=False)
					BEQ		main_exit 
					
m_on_hotk_touched_n	MOV		R2,#1 ; hotkeyflag: skip key_off, but be 0 on next key.
					STRB	R2,[R4,#ram_offset_hotkey_mode] ; enable hotkey flag
					
					B		main_exit
					
m_on_hotk_escape	CMP		R2,#0
					BEQ		m_on_hotk_escape_1
					BL		_sound_key_failed

m_on_hotk_escape_1	MOV		R2,#0 ; disable hotkey flag
					STRB	R2,[R4,#ram_offset_hotkey_mode] ; 
			
m_on_exec			LDR		R1,Keypress_On_Store2Ram_
					B		m_exec
				
m_off				CMP		R2,#0 ; 0: no hotkey flag. 
					BEQ		m_off_exec
					CMP		R2,#1 ; 1: hotkeyflag for key_off locked, after clear. 2: hotkey flag locked, leave
					BNE		main_exit
					
					MOV		R2,#0 ; disable hotkey flag
					STRB	R2,[R4,#ram_offset_hotkey_mode] ;  hotkey flag
					
					B		main_exit

m_off_exec			LDR		R1,Keypress_Off_Store2Ram_

m_exec				BLX		R1

main_exit			ADD		SP,#sp_param ; release my stack slot
					POP		{R0-R7,PC}

; -----------------------------------------------------------------------------	
					
_sound_key_failed	PUSH	{R0,R2,LR}
					MOV		R0,#0x7B
					B		_sound_init_ok_ex
					
_sound_init_ok		PUSH	{R0,R2,LR}
					MOV		R0,#0x2F ; vibrate
_sound_init_ok_ex	BL		_playsoundloop_len1
					POP		{R0,R2,PC}
				
; ========================================================================================

scan_key_sequences
				PUSH	{R2-R7,LR}
				MOV		R5,R0 ; put pressed key to R5. there come key_on_events and key_off_events(key=key_on+0x80)

s_init			LDR		R7,[SP,#sp_sub_scan_key_sequences + sp_SequenceRecords] ; [SP,#8]=number of sequence records
				
				LDR		R4,free_ram_dword_ 
				LDR		R4,[R4]
				ADD		R4,#ram_offset_sequence_record_table ; goto base address for sequence record table
				MOV		R7,#0 ; counter of sequences
				STR		R7,[SP,#sp_sub_scan_key_sequences + sp_AnySequenceTouched] ; reset
				
s_loop			LDR		R3,=sequences
				LDR		R0,[SP,#sp_sub_scan_key_sequences + sp_SequenceRecords] ; R0=# of sequence records
				CMP		R0,R7
				BLE		s_exit ; if last sequence+1, its so nice, but i must leave

				LDRB	R1,[R4,R7] ; ram status byte of current sequence
				LSL		R6,R7,#4 ; *16
				ADD		R2,R3,R6 ; address of very first byte of current sequence record
				
				MOV		R0,#FF
				STR		R0,[SP,#sp_sub_scan_key_sequences + sp_ActionPerformed] ; SequAccepted&ActionPerformed(FF=False) [SP] reset with FF
				
				; filter

				; process sequence record depending SequenceMode_Snap _AfterHotkey or _Directly?
				LDRB	R3,[R2,#0xD] ; mode byte of sequence record
				MOV		R0,#1 ; bit 0
				AND		R0,R3 ; sequence mode byte, bit zero: SequenceMode_Snap
				LDR		R6,[SP,#sp_sub_scan_key_sequences + sp_ScanKeySequencesMode]
				STR		R0,[SP,#sp_sub_scan_key_sequences + sp_Direct_or_Hotkey_seq]
				
				CMP		R0,#1 ; is sequence hotkey mode?
				BEQ		s_loop_seq_hotk
				
s_loop_seq_dire	CMP		R6,#1 ; is current run of func hotkey mode?
				BEQ		s_key_not_snapped
				B		s_loop_filter_conditions ; NEW
				
s_loop_seq_hotk	CMP		R6,#0 ; is current run of func direct mode?
				BEQ		s_key_not_snapped

				SUB		R0,R4,#(ram_offset_sequence_record_table -  ram_offset_keypress_after_hotkey_counter) 
				LDRB	R0,[R0] ; ; [ram_basement+1] keypress-after-hotkey-counter
				CMP		R0,#0
				BEQ		s_loop_filter_conditions ; if 1st run process all sequences
				CMP		R1,#0 ; if status byte of curr. sequence unused
				BEQ		s_key_not_snapped 
				



s_loop_filter_conditions				
								
; input: 		; R2=sequence record address

				; MOV		R3,#1 ; R3=mode byte 0 or 1. check by default condition bits in mode byte 0
				BL		_s_loop_filter_evaluate_and3
				CMP		R0,#1 ; was filtering by condition bits in mode byte 0 successfull?
				BNE		s_key_not_snapped
				
				
				;MOV		R3,#0 ; R3=mode byte 0 or 1. check by default condition bits in mode byte 0
				;BL		_s_loop_filter_evaluate_and3
				;CMP		R0,#0 ; failed filtering by condition bits in mode byte 0 ?
				;BEQ		s_key_not_snapped

s_loop_filter_x	LDR		R0,[SP,#sp_sub_scan_key_sequences + sp_Direct_or_Hotkey_seq]
				CMP		R0,#1 ; is sequence direct or hotkey mode?
				BEQ		s_loop_8_hotk ; NEW

s_loop_8_direct	ADD		R0,R2,R1 ; R0=Very1stByteOfCurrSeqRec + seq rec ram counter
				B		s_loop_9
				
s_loop_8_hotk	SUB		R0,R4,#(ram_offset_sequence_record_table -  ram_offset_keypress_after_hotkey_counter)
				LDRB	R0,[R0] ; ; [ram_basement+1] keypress-after-hotkey-counter
				ADD		R0,R2,R0 ; R0=Very1stByteOfCurrSeqRec + keypress-after-hotkey-counter

s_loop_9		ADD		R0,#8 ; position of first key sequence byte
				LDRB	R6,[R0] ; R0=key sequence byte of current sequence record
				
				CMP		R5,R6 ; is currently pressed key = the current key in the current sequence?
				BEQ		s_key_snapped

s_key_not_snapped					
				MOV		R1,#0 ; reset_sequence
				STRB	R1,[R4,R7] ; reset ram-buf for seq
				B		s_loop_return
							
s_key_snapped	MOV		R6,#1 ; counter of sequences
				STR		R6,[SP,#sp_sub_scan_key_sequences + sp_AnySequenceTouched] ; set to true		

s_key_snapped_1	LDRB	R6,[R0,#1]
				CMP		R6,#0 ; sequence end reached, cause next key sequence element 0?
				BEQ		s_action

				LDR		R3,[SP,#sp_sub_scan_key_sequences + sp_Direct_or_Hotkey_seq]
				CMP		R3,#1 ; is sequence direct or hotkey mode?
				BEQ		s_key_snapped_1_hotk ; NEW

s_key_snapped_1_direct
				CMP		R1,#4 ; sequence end reached, cause maximum number of elements reached? (max=5. max-1=4)
				BGE		s_action
				B		s_key_in_sequence

s_key_snapped_1_hotk
				SUB		R3,R4,#(ram_offset_sequence_record_table -  ram_offset_keypress_after_hotkey_counter)
				LDRB	R3,[R3] ; [ram_basement+1] keypress-after-hotkey-counter
				CMP		R3,#4 ; sequence end reached, cause maximum number of elements reached? (max=5. max-1=4)
				BGE		s_action
		
s_key_in_sequence
				ADD		R1,#1
				STRB	R1,[R4,R7]
				B		s_loop_return
										
s_exit			LDR		R1,[SP,#sp_sub_scan_key_sequences + sp_ActionPerformed] ; SequAccepted&ActionPerformed(FF=False) 
				MOV		R0,R5 
 				POP		{R2-R7,PC}			

; -----------------------------------------------------------------------------


s_action		;PUSH	{R0-R3,R7} ; do i need all these pushes really?
				MOV		R7,R2
				LDR		R0,ram_mainscreen_accu_icon_
				LDR		R2,=0xFF00
				STRH	R2,[R0] ; set to special_no_mainscreen

				;STR		R2,[SP,#sp_sub_scan_key_sequences + +0x14 + sp_State_mainscreen] ; 0x14 ; PUSH {R0-R3,R7}: 5 regs pushed, 5*4=0x14
				STR		R4,[SP,#sp_sub_scan_key_sequences + sp_ActionPerformed] ; store anything else than FF in SequAccepted&ActionPerformed(FF=False) to dirty it. SP: ({R0-R3,R7}: 5 regs x 4 = 20 = 0x14.

s_action_reset	; reset all sequence ram buffers to zero here
				LDR		R0,[SP,#sp_sub_scan_key_sequences + sp_SequenceRecords] ; number of sequence records
				MOV		R2,#0
				MOV		R1,R2
				
s_action_reset_l
				CMP		R2,R0 ; last sequence
				BEQ		s_action_sound
				STRB	R1,[R4,R2] ; store zero to ram
				ADD		R2,#1 ; reset next ram sequence buffer
				B		s_action_reset_l
				
s_action_sound	LDRB	R0,[R7,#0x0E] ; R0=sound for PlaySound ; ##########  action sound 
				LDRB	R2,[R7,#0x0F] ; R2=loops for PlaySound
				ADD		R6,R0,R2
				CMP		R6,#0
				BEQ		s_action_illu_on
				MOV		R1,#2
				BL		_playsoundloop
				
s_action_illu_on
 				;MOV		R0,#3 ; turn all lights on
				;MOV		R6,#68 ; IlluminationEvent_
				;BL		_FuncLib

s_action_what	LDR		R2,[SP,#sp_sub_scan_key_sequences + sp_State_keylock]
				LDR		R3,[SP,#sp_sub_scan_key_sequences + sp_State_keylock_addr]
				; MOV		R2,R0 ; keylock state
				; MOV		R3,R6 ; address of keylock state

				LDR		R6,[R7] ; R6=ExecAddress or Action
				ADD		R6,#number_of_action_params ; shift for comparing
				BMI		s_action_blx
				
				CMP		R6,#0 ; device unlock ? action=0xFFFFFFFB
				BEQ		s_action_device_shutdown
				
				CMP		R6,#1 ; device unlock ? action=0xFFFFFFFC
				BEQ		s_action_device_unlock
				
				CMP		R6,#2 ; device lock ? action=0xFFFFFFFD
				BEQ		s_action_device_lock
				
				CMP		R6,#3 ; toggle keylock? action=0xFFFFFFFE
				BEQ		s_action_keylock
				
				CMP		R6,#4 ; midlet? action=0xFFFFFFFF
				BEQ		s_action_midlet
	
s_action_flib	BL		_s_action_prep_exec
				BL		_FuncLib
				B		s_action_x
				
s_action_device_shutdown
				LDR		R6,_ram_is_shutdown
				MOV		R1,#1
				STRB	R1,[R6]
				MOV		R6,#9 ; SwitchPhoneOff
				BL 		_FuncLib
				B		s_action_x
	
s_action_keylock
				MOV		R1,#1
				SUB		R2,R1,R2
				STRB	R2,[R3] ; toggle keylock
				B		s_action_x
				
s_action_device_lock
				MOV		R0,#0xFF ; input: R0
				BL		_set_scrsaver ; unlock device
				B		s_action_x
				
s_action_device_unlock
				MOV		R0,#0x10
 				BL		_set_scrsaver ; unlock device
				MOV		R6,#31 ; DrawMainscreen
				BL 		_FuncLib
				B		s_action_x
				
s_action_midlet	LDRB	R0,[R7,#0x04] ; R0=number of midlet string
				BL		_get_keyseq_string
				MOV		R1,#1
				MOV		R6,#75 ; StartMidlet
				BL		_FuncLib
				B		s_action_x

s_action_blx	BL		_s_action_prep_exec
				BLX		R6

s_action_x	  	; send red key after action? 
				LDRB	R6,[R7,#0xD] ; mode byte of sequence record
				MOV		R3,#2
				;AND		R6,R3 ; sequence mode byte, bit 1: SequenceMode_SendKey
				;CMP		R6,R3
				TST		R6,R3 ; #OPT#
				BEQ		s_action_xx
				BL		_send_redkey
				BL		_send_redkey			
s_action_xx		;POP		{R0-R3,R7}
				; B		s_loop_return

		
s_loop_return	LDR		R0,[SP,#sp_sub_scan_key_sequences + sp_ActionPerformed]
				CMP		R0,#FF ; SequAccepted&ActionPerformed(FF=False) 
				BNE		s_exit ; leave patch when one sequence accepted and the action performed.
			
				ADD		R7,#1 ; read next key sequence record
				B		s_loop
				
; -----------------------------------------------------------------------------
				
_s_loop_filter_evaluate_and3 
; X=used. R0, R1X,R2X, R3, R4X,R5X,R6,R7X
; input: 		; R2=sequence record address
	; DCB "*****"
				PUSH	{R1,R2,LR}
				
				; ADD		R2,#0xD ; R2=address of mode byte 0
				LDRB	R1,[R2,#0xD] ; selected mode byte
				
				MOV		R0,#0xFC ; 0n11111100 ; mask for conditions bits 7-2
				AND		R0,R1
				CMP		R0,#0 ; all conditions zero, just do true?
				BEQ		_s_loop_filter_evaluate_and3_true_snapped
						 									
_s_loop_filter_evaluate_and3_keylock	; process sequence record depending by SequenceMode_Keylock
				LDR		R0,[SP,#sp_sub_scan_key_sequences + 12 + sp_State_keylock]
				MOV		R6,#0x80 ; bit 7 keylock test yes or no
				BL		_s_loop_filter_evaluate
				CMP		R0,#1 ; test succeeded or bit 7 keylock test=no?
				BNE		_s_loop_filter_evaluate_and3_false_not_snapped
				
_s_loop_filter_evaluate_and3_scrsav	; process sequence record depending by SequenceMode_Screensaver
				LDR		R0,[SP,#sp_sub_scan_key_sequences + 12+ sp_State_screensaver]
				MOV		R6,#0x20 ; bit 5 scrsaver test yes or no
				BL		_s_loop_filter_evaluate
				CMP		R0,#1 ; test succeeded or bit 4 scrsav test=no?
				BNE		_s_loop_filter_evaluate_and3_false_not_snapped
		; f27e		
_s_loop_filter_evaluate_and3_mainscreen	; process sequence record depending by SequenceMode_GUI_State
				LDR		R0,[SP,#sp_sub_scan_key_sequences + 12 + sp_State_keylock]
				LDR		R6,[SP,#sp_sub_scan_key_sequences + 12 + sp_State_screensaver]
				BL		_get_mainscreen_state
				MOV		R6,#1
				AND		R0,R6 ; view only if "mainscreen" is on or off, dont why.
				MOV		R6,#0x8 ; bit 3 "is mainscreen or menu/list" test yes or no
				BL		_s_loop_filter_evaluate
				CMP		R0,#1 ; test succeeded or bit 2 mainscreen test=no?
				BNE		_s_loop_filter_evaluate_and3_false_not_snapped
				
_s_loop_filter_evaluate_and3_true_snapped
				MOV		R0,#1
				B		_s_loop_filter_evaluate_and3_x	

_s_loop_filter_evaluate_and3_false_not_snapped				
				MOV		R0,#0		
				
_s_loop_filter_evaluate_and3_x
				POP		{R1,R2,PC}

; -----------------------------------------------------------------------------

_s_loop_filter_evaluate
; X=used. R0, R1X,R2, R3, R4X,R5X,R6,R7X

; evaluates a "and" expression stored in mode byte 0 or 1, in the bits 7-6, 5-4 or 3-2
; input: 		; R0=condition content, e.g. screensaver_state. always 0 or 1.
				; R1= R1,[R2,R3] ; mode byte of sequence record
				
				; R6=first bit of condition, eg:0x20=bit5.
				MOV		R2,R6 ; first bit of condition, eg:0x20=bit5.
				AND		R2,R1 ; R5=0 do always. R5=1 do conditional depending on condition sex bit
				CMP		R2,#0
				BEQ		_s_loop_filter_evaluate_true ; skip this check - return true
				
				LSR		R6,#1 ; set to condition sex bit of condition 2-bit-set
				MUL		R0,R6 ; make it up to condition sex bit
				AND		R6,R1 ; if bit=1: R6=0: do only if false. R6=1: do only if true
				CMP		R0,R6
				BEQ		_s_loop_filter_evaluate_true
				MOV		R0,#0
				B		_s_loop_filter_evaluate_x	
_s_loop_filter_evaluate_true
				MOV		R0,#1	
_s_loop_filter_evaluate_x
				BX		LR

; -----------------------------------------------------------------------------



_s_action_prep_exec
				PUSH	{LR}
				
_s_action_prep_exec_scrsaver_off
				LDR		R0,[SP,#sp_sub_scan_key_sequences + 4 + sp_State_screensaver] ; 4=PUSH LR
				CMP		R0,#FF ; device locked 
				BEQ		_s_action_prep_exec_x
				MOV		R0,#0x10 ; screensaver and devicelock off
				BL		_set_scrsaver
				
;_s_action_prep_exec_keylock_off_if_wished
;				CMP		R2,#1 ; isKeylock?
;				BNE		_s_action_prep_exec_x
;				
;				LDRB	R2,[R7,#0xC] ; mode byte 2 of sequence record
;				MOV		R0,#4
;				AND		R0,R2 ; sequence mode byte, bit 2: break keylock ans screensaver after command
;				CMP		R0,#0
;				BEQ		_s_action_prep_exec_x
;				
;				MOV		R2,#0
;				STRB	R2,[R3] ; open keylock
;				MOV		R0,#0x10
				
_s_action_prep_exec_x
				SUB		R6,#number_of_action_params ; shift back
				LDRB	R0,[R7,#4] ; R0 for exec_address
				LDRB	R1,[R7,#5] ; R1 for exec_address
				LDRB	R2,[R7,#6] ; R2 for exec_address
				LDRB	R3,[R7,#7] ; R4 for exec_address
				POP		{PC}
			
; ========================================================================================
			
_FuncLib		; input: r6=func-no from func lib
				PUSH	{R4,R7,LR}
				LDR		R7,FunctionLibrary_
				LSL		R6,#3
				ADD		R7,R6
				LDR		R7,[R7,#4]
				ADD		R4,R7,#1
				CMP		R4,#0
				BEQ		_FuncLib_err
				BLX		R7
 
				POP		{R4,R7,PC}
							
_FuncLib_err	LDR		R4,free_ram_dword_
				LDR		R0,[R4]
				CMP		R0,#1 ; patch already locked?
				BEQ		_FuncLib_err1
				
				;MOV		R0,#1 ; func lib error message
				;BL		_error_message
				
				MOV		R1,#1
				LDR		R0,[R4]
				STR		R1,[R4] ; lock
				CMP		R0,#0 ; ram not yet initialized?
				BEQ  	_FuncLib_err1
				
				;use in ram stored sp for dynamic calculation
				LDR		R1,[R0,#ram_sp_main] ; main function sp
				B		_FuncLib_err2

_FuncLib_err1	;use direct calculated sp for err before ram init
				MOV		R1,SP
				ADD		R1,#3*4 ; funclib pushes
				
_FuncLib_err2	; ADD		R1,#(8*4)+sp_param ; main function (9-1)*4 pushes + sp_param
				MOV		SP,R1
				B 		m_nopatch
				
; -----------------------------------------------------------------------------
				
_send_redkey	PUSH	{R6,LR}
				MOV		R0,#0xC ; red button on
				LDR		R6,Keypress_On_Store2Ram_
				BLX		R6
				MOV		R0,#0x8C ; red button off
				LDR		R6,Keypress_Off_Store2Ram_
				BLX		R6
				POP		{R6,PC}
				
; -----------------------------------------------------------------------------
				
_set_scrsaver	PUSH	{R1,LR} ; input R0=state.
				MOV		R1,R0
				LDR		R0,Screensaver_GetAddress_
				BLX		R0
				CMP		R0,#0
				BEQ		_set_scrsaver_x
				STRB	R1,[R0]
								
_set_scrsaver_x	POP		{R1,PC}

; -----------------------------------------------------------------------------

_get_scrsaver	PUSH	{R1,LR} ; 
				LDR		R0,Screensaver_GetAddress_
				BLX		R0
				CMP		R0,#0
				BNE		_get_scrsaver_1
				MOV		R0,#0
				B		_get_scrsaver_x
_get_scrsaver_1	LDRB	R0,[R0]
				MOV		R1,#0x19 ; mask 00011001 for "device lock" bits
				AND		R1,R0
				CMP		R1,#0x19
				BEQ		_get_scrsaver_x
				MOV		R1,#1
				AND		R0,R1
_get_scrsaver_x	POP		{R1,PC}  ;returns R0: 0=no scrsaver, 1=scrsaver, FF=devicelock
				
; -----------------------------------------------------------------------------
		
_get_mainscreen_state 	
; iput: R0: keylock state, R6=screensaver state
; returns in R0:
; 0 normal not mainscreen (menus, lists, midlets etc)
; 1 mainscreen (idle, keylock, screensaver, #-dialogs in keylock and screensaver)
; 2 cmd launched by keysequencer-not - at mainscreen

				PUSH	{R1-R3,LR} 
				LDR		R1,ram_mainscreen_accu_icon_
				LDRB	R3,[R1,#1] ; byte 1	
				CMP		R3,#FF 
				BNE		_get_mainscreen_state_return_true
				
_get_mainscreen_state_ff
				LDRB	R2,[R1] ; byte 0
				CMP		R2,#0 
				BNE		_get_mainscreen_state_ff_1
				
				MOV		R0,#2 ; R2=0, R3=FF: func started by key sequencer 
				B		_get_mainscreen_state_x

_get_mainscreen_state_ff_1
				CMP		R2,#FF
				BNE		_get_mainscreen_state_return_false ; !!! fall-back !!! 
				
				CMP		R6,#1 ; is screensaver?
				BEQ		_get_mainscreen_state_return_true
				
				CMP		R0,#1 ; is keylock?
				BEQ		_get_mainscreen_state_return_true

				; thist must be menu/list/progs reached normally from mainscreen

_get_mainscreen_state_return_false				
				MOV		R0,#0 
				B		_get_mainscreen_state_x	
							
_get_mainscreen_state_return_true				
				MOV		R0,#1

_get_mainscreen_state_x
				POP		{R1-R3,PC}

; -----------------------------------------------------------------------------
				
_get_keylock	LDR		R6,ram_Keylock 
				LDRB	R0,[R6]
				BX		LR  ; returns in R0 the content of R6

; -----------------------------------------------------------------------------
				
_playsoundloop_len1
				PUSH	{R2,LR}
				MOV		R2,#1
				BL		_playsoundloop
				POP		{R2,PC}	

; -----------------------------------------------------------------------------

_playsoundloop	PUSH	{R1,R6,LR}
				MOV		R1,#2
				MOV		R6,#52 ; PlaySoundloop
				BL		_FuncLib
				POP		{R1,R6,PC}	

; -----------------------------------------------------------------------------
				
;_show_message	; input: R0=LP-number OR string-address
;				PUSH	{R1,R5,R6,LR}
;				MOV		R1,R0
;				MOV		R0,#1 ; popup style
;				LDR		R6,ShowMsgInR1_4_
;				BLX		R6
;				POP		{R1,R5,R6,PC}
;
; -----------------------------------------------------------------------------
			
_get_keyseq_string	; input: R0=string number from string database
				PUSH	{R1,LR}
				MOV		R1,#0x30 ; length of string record
				MUL		R0,R1
				LDR		R1,keyseq_strings_
				ADD		R0,R1
				POP		{R1,PC} ; returns in r0: address of string

; -----------------------------------------------------------------------------
	
;_get_net_access_mode	
;				PUSH	{LR}
;				MOV		R6,#81 ; GetNetMode
;				BL		_FuncLib
;				POP		{PC}

; -----------------------------------------------------------------------------

_is_shutdown	LDR		R0,_ram_is_shutdown
				LDRB	R0,[R0]
				CMP		R0,#1
				BX		LR


; -----------------------------------------------------------------------------
				
;_error_message	PUSH	{R0,R1,LR}
;				BL		_get_keyseq_string
;				MOV		R1,R0
;				BL		_show_message
;				MOV		R0,R1
;				BL		_show_message
;				POP		{R0,R1,PC}
;				
; -----------------------------------------------------------------------------

 IF  FIRMWARE = 1 ; 1=m65v50
; m65v50  addresses needed by patch core 
; entrypoint: 010602D59999999910BD9999999910BDB0B5999900200831

free_ram_dword_				DCD 0xA8000204
Keypress_On_Store2Ram_		DCD 0xA114C9D3 ; 2nd BL after Enrypoint
Keypress_Off_Store2Ram_		DCD 0xA114CA91 ; 1st BL after Enrypoint
;GetProfile_				DCD	0xA08C9FE5 ; 2
;Malloc_					DCD	0xA0820F98 ; 20
;MidletExec_				DCD	0xA0C349A8 ; 75
;PlaySoundLoop_				DCD	0xA0935CF8 ; 52
;IlluminationEvent_			DCD	0xA0B69779 ; 68
;IsScreensaver				DCD	0xA163E2D1 ; 66
ram_Keylock					DCD 0xA8655EE0

ram_mainscreen_accu_icon_	DCD 0xA863A544 ; s65v58: A868C4E4, sl65v50: A863A3D0
; A1633BF2 46 49                       LDR     R1, =ram_mainscreen_states    + 4
; (7047B0B599999999006899990028)+0xA there you find an address loaded. add 4 to address

Screensaver_GetAddress_		DCD 0xA16310B3 ; (A0680028999901219999999910BD) + 0xE

FunctionLibrary_ 			DCD	0xA0FC0000

;ShowMsgInR1_4_				DCD 0xA113BCEB
 
;_get_net_access_			DCD	0xA132D75D 
;(9999021C09780120914200D000207047999900787047)+0x10 you find a LDR loading the address or you can start the function.

_ram_is_shutdown			DCD	0xA86B41BC

 ENDIF
; -----------------------------------------------------------------------------
 
 IF  FIRMWARE = 2 ; 2=sl65v50
free_ram_dword_				DCD 0xA8000204
Keypress_On_Store2Ram_		DCD 0xA1150227
Keypress_Off_Store2Ram_		DCD 0xA11502E5 

ram_Keylock					DCD 0xA864FA8C

ram_mainscreen_accu_icon_	DCD 0xA863A3D0 

Screensaver_GetAddress_		DCD 0xA163ECC7

FunctionLibrary_ 			DCD	0xA0FC0000

;ShowMsgInR1_4_				DCD 0xA113BCEB

;_get_net_access_			DCD	0xA1339035 
_ram_is_shutdown			DCD	0xA86ADE7C


 ENDIF 
; -----------------------------------------------------------------------------
 
 IF  FIRMWARE = 3 ; m75v13

; entry: A07FE0DA 

free_ram_dword_				DCD 0xA8000204
Keypress_On_Store2Ram_		DCD 0xA07FDEFB
Keypress_Off_Store2Ram_		DCD 0xA07FE029 

ram_Keylock					DCD 0xA84FF840

ram_mainscreen_accu_icon_	DCD 0xA84CB48C 

Screensaver_GetAddress_		DCD 0xA02A5D85

FunctionLibrary_ 			DCD	0xA0FC0000

;ShowMsgInR1_4_				DCD 0xA113BCEB

_get_net_access_			DCD	0xA0B3F1FD

 ENDIF 
 
 IF  FIRMWARE = 4 ; s65v58
 ; 
 ENDIF
 
keyseq_strings_				DCD	keyseq_strings

 END
 				
