; ilumination master 0.1
; prototyping mode
; m65v50 (c) benj9 

; entry m65v50:
; 0823368: 4010D4E5 64DC38FB ; _IllByKey_On_5mX_5_ Debug Mitte 64DC38FB->A165A500, A4DC38FB ->A165A600

; Running in function:
; A08232F8 IlluminationByKeyEventOn_5mX
; background proc., starts once, never leaves, ever cycles inner
; reading events from rom and creating jump addresses to start according processes
; there are different branches where processes are started.
; A0823364 _IllByKey_On_5mX_5_best fits the center of the web
; to calculate all dependencies of event processes started.


		AREA ARMex, CODE, READONLY  
            
		ENTRY
		GBLA	TYPE	;1 for M65v50, 2 for SL65v50

TYPE	SETA	1 						

 IF  TYPE = 1

buffer				EQU	0xA8248000
Illumination			EQU	0xA0BC78B8 
_ram_illumination_data	EQU 0xA12265F8

 ENDIF

; patch data in rom structure: 
; +00 - 0x31, len: 0x32 = 8 blink rhythms pattern x 4 byte.  (3 data byte + 1 empty)
; byte0: number_of_loops, byte1: brightness, byte2: smoothness

; patch data in ram structure:base=buffer
; +00 - 0x31, len: 0x32 = 8 blink rhythms buffer x 4 byte.  (2 words)
; word0: toggle_on_off, word1:toggle_counter 
; +32: 



; SET means: set in armdebugger ram value
;intern ;0=brightn , 4=funcnow, 8=recorder-offset, 
;SET   ;10 mode, 14=toggle-miss-loop-max (start 08)
;		20 functionfilter1, 24  functionfilter2, 28=functionfilter3 2c=filter4
;       30 ff. recorder-store

		CODE16

		
		NOP
mStart	PUSH {R0-R7,LR}

		LDR		R7,=buffer

mCalc__5mX

		; R4=5mX_5
			
		; R0,R2,R4 kommen aus dem laufenden event code
		; R5 <- 5mX_7. R3=tmp
		ADD		R0,#0x14
		MOV		R5,R0
		MOV		R3,#0x7F
		AND		R2,R3
		MOV		R0,R2
		LDMIA	R5!,{R0,R5} ; R5=5mX_7

		LDR		R6,[R4,#0x3c] ; R6=5xM_5_g  
		
		
		; R5=  5mX_7  -- REGULAR
		; A1367E93 937E36A1 ; REGULAR steady 1,5sec blink (max_loop: 1)
		; mit R6=21 DD 32 A1: algo1:1  (auch regular)
		
		; KPL-OFF-SLIDE
		; R4=7C 4D 01 A8 R1=00 00 00 00 kpl-off-slide algo1:1 (mit serial-mll?)
		; luft gut mit: BL _IsIlluminationOnByOS, CMP R0,#0, BNE mExit

		; R4= R4 of 5mX_5 (entry of this patch) - SERIAL/OBEX
		; C4 8E 00 A8 R5=FC CE 01 steady fast serial/obex (algo0: 1)(algo:1 6)
		
		; 2C 5A 01 A8 ; hnlich wie R5= A801CEFC ; serial/obex,  
		; mit allem: (2) OK - verpasst kabeil rein 50% wegen (2) (algo0) !
		;  mit R5=0: serieller etw.slower serieller. Cable zu schnell algo1(2)
		;  mit R5=FC CE 01 A8 netter flotter serial blinker, ohne cable algo1(04)
 

		; R6= 5xM_5_g und 5xM_5_E1
		; B1 05 31 A1 A13105B1 ; net1 entry
		

		;LDR		R6,[R5,#0x10] ; SET: which mode 0=off, 1=light , 2=Ram Recorder of Functions
		;CMP		R6,#0 ; mode
		;BEQ		mExit
		;CMP		R6,#2 
		;BEQ		recorder
		
filter		LDR		R3,=0xA8014D7C ; kpl_off-slide
			CMP		R4,R3
			BNE		mExit

			MOV		R3,#0
			CMP		R5,R3
			BNE		mExit
		
			BL		_IsIlluminationOnByOS
			CMP		R0,#0
			BNE		mExit  ; kpl_off slide .- end

xxx			
			MOV		R0,#4 ; pattern no.4 kpl-off slide
			BL		_Blinker		


mExit	POP		{R0-R7}
		MOV		R1,R4		; repatch _IllByKey_On_5mX_5
 		ADD		R1,#0x40	; repatch _IllByKey_On_5mX_5
		LDRB	R1,[R1]		; repatch _IllByKey_On_5mX_5
		POP		{PC}

_Blinker	PUSH	{LR}
			LDR		R7,=buffer
			LDR		R3,=pattern
			SUB		R3,#1 ; porters delight
					
_Blinker_Calc_DataOffset  ; input: R0=pattern#. Ab hier R3=akt.rom-pattern, R0=akt. ram-buffer
			LSL		R0,#2 ; R0= pattern# * 4 = offset
			ADD		R3,R0 ; R3= pattern + offset = akt-rom-pattern
			ADD		R0,R7 ; R0=offset + buffer_base = akt-ram-buffer
		
_Blinker_Filter_LoopToggler
			LDRB	R2,[R0,#2] ; toggle-funcnow1
			;MOV	R3,#loop_trigger_max
			LDRB	R1,[R3] ; <loop_trigger_max>
			CMP		R2,R1 ; signal ausdnnen
			BEQ 	_Blinker_Step	
		
			ADD		R2,#1
			STRB	R2,[R0,#2]  ; reset funcnow
			POP {PC} ; B		_Blinker_X
	
_Blinker_Step
			MOV		R2,#0
			STRB	R2,[R4,#0x0C] ; make dirty: Toggle_Set_KPL_Correct_First_Idle
			
			MOV 	R2,#1
			STRB	R2,[R0,#2]	; set toggle_funcnow

       		LDRB	R2,[R0] ; toggle_on/off
			;MOV 	R1,#brightness 
			LDRB	R1,[R3,#1] ; ############# [R3,#2]  ; <smoothness> ; <brightness>
			SUB		R2,R1,R2
			STRB	R2,[R0]
		
_Blinker_Go	MOV     R0, #1 ; <output>
			;LDRB	R0,[R5,#1]
        	MOV     R1, #1
      	  	;MOV		R3,#smoothness ; <smoothness>
        	LDRB	R3,[R3,#2] ; changed! ############# [R5,#3]  ; <smoothness>
    	    LDR		R7,=Illumination
   	    	BLX     R7
_Blinker_X	POP {PC}
		
_IsIlluminationOnByOS
		LDR		R0,=_ram_illumination_data
		LDR		R0,[R0] ; A1255C34 1C E2 6A A8 dword_A1255C34  DCD 0xA86AE21C
		ADD		R0,#0x94  ; +94: What OS thinks is state of Illumination On/Off
		LDRB	R0,[R0] 
   	    BX		LR
   	    
pattern ; <loop_trigger_max>,<brightness>,<smoothness>
; <loop_trigger_max>: min 3!,<output>0=Scr,1=KPL,2=DL,<brightness>0-0x64,<smoothness>0=off
p0_net	DCB	4,40,02,0 ; ;R6=0 beim Rufaufbau kurz
p1_net	DCB	3,55,02,0 ;  R6=1 beim Rufaufbau sehr kurz
p2_net	DCB	7,50,06,0 ;  R6=2 + 3  Verbindung
p3_net	DCB 9,25,32,0 ; R6=1B, blink for idle and default
p4_kpl	DCB	1,60,03,0 ; keypadlight-off slide



 END
 
 
manip	LDR		R6,[R5,#0x24] ; SET: exec only when this function is called
		CMP		R1,R6
		BNE		mExit

		LDR		R6,[R5,#0x20] ; SET: exec only when this function is called
		CMP		R0,R6
		BEQ		tog12
		

		LDR		R6,[R5,#0x28] ; SET: exec only when this function is called
		CMP		R2,R6
		BEQ		tog12
		
		LDR		R6,[R5,#0x2C] ; SET: exec only when this function is called
		CMP		R3,R6
		BEQ		tog12
		B		mExit