; blink module number
; x65 M65v50 (c) benj9 

		AREA ARMex, CODE, READONLY  
            
		ENTRY
		GBLA	TYPE	;1 for M65v50, 2 for CX6C

TYPE	SETA	1 						

 IF  TYPE = 1
 ENDIF

		; IMPORT ram
		IMPORT  _funclib
		IMPORT	_set_illumination_state_to_law
		IMPORT	master_entry
		IMPORT 	_illumination_toggler
		IMPORT	_get_number_missed_events
		IMPORT	_get_net_online
		EXPORT	number_blinker, number_blinker_loop, netlost_blinker
		
		CODE16
		
		
; ram usage:
; 0-7: timer data
; 8-9: illumination toggler, resides in DynamicBlinker
; A. DynamicBlinker polarity
; B: NumberBlinker Remainder
; C: Numberblinker Step 
; D: BlinkderMissedEventsResult (FF if not set)

number_blinker	PUSH	{R0-R7,LR}

				CMP		R0,#1 ; 1 missed event
				BEQ		number1
			
				CMP		R0,#2
				BEQ		number2
		
number3			MOV		R0,#18
				B		number_exec	
		
number2			MOV		R0,#30
				B		number_exec	
		
number1			MOV		R0,#90

number_exec		LDR		R6,ram
				MOV		R1,#60 ; brightness
				STRB	R1,[R6,#8] ; 8-9: illumination toggler

				STRB	R0,[R6,#0xC] ; Numberblinker Step
				MOV		R0,#90
				STRB	R0,[R6,#0xB] ; NumberBlinker Remainder
				
				BL		number_blinker_loop
				POP		{R0-R7,PC}

; -----------------------------------------------------------------

			
netlost_blinker	PUSH	{R0-R7,LR}
				LDR		R6,ram
				MOV		R1,#0xA ; short duration
				STRB	R1,[R6,#0xB] ; NumberBlinker Remainder
				MOV		R1,#0xA ; short bleep
				STRB	R1,[R6,#0xC] ; Numberblinker Step

				MOV		R1,#60 ; brightness
				STRB	R1,[R6,#8] ; 8-9: illumination toggler
				
				BL		number_blinker_loop
				POP		{R0-R7,PC}

; -----------------------------------------------------------------
			
number_blinker_loop
				PUSH	{LR}
		
				BL		_illumination_toggler

				LDRB	R0,[R6,#0xB] ; NumberBlinker Remainder
				LDRB	R1,[R6,#0xC] ; Numberblinker Step 
				SUB		R0,R1
				STRB	R0,[R6,#0xB] ; NumberBlinker Remainder
				
				CMP		R0,#0
				BMI		number_blinker_return
				
				LDR		R2,=number_blinker_loop
				B		exec1

number_blinker_return
				BL		_get_number_missed_events
				CMP		R0,#0
				BNE		exec
				
				BL		_get_net_online
				CMP		R0,#0
				BEQ		exec
				
				BL		_set_illumination_state_to_law

exec			MOV		R1,#225 ; Dauer, 225/225 Sekunden
				LDR		R2,=master_entry			
				
exec1			MOV		R0,R6
				MOV     R7,#77 ; CallAfterTimer
				BL		_funclib
				
				POP		{PC}
				

ram				DCD	0xA8240000 

 END		

    
   