; AccuTemperature Indicator v2.1 masterpatch
; x65 M65v50 (c) benj9

				AREA ARMex, CODE, READONLY  

				EXPORT	AccuTempIndic
				IMPORT	mp_Bufferizer
				IMPORT	f006_GetAkku
				IMPORT	f035_DrawImg
				IMPORT	f033_GetImgHeight
				IMPORT	f034_GetImgWidth
				IMPORT	f037_DrawCanvas


C0centidegrees	EQU		0xC0 

				
				CODE16
	
				DCB		"AccuTmpI21,benj9"
	
				ENTRY
AccuTempIndic	PUSH	{R0-R6,LR}

				LDR		R0, mp_id
				BL		mp_Bufferizer
				BEQ		Exit
	
				
Accutemp		MOV     R0, #1
				MOV     R1, #3
				BL		f006_GetAkku
				MOV     R1, #0x0A
				LSL		R1, #8
				ADD     R1, #0xAA
				SUB     R0, R0, R1
				MOV		R5, #17 ; temp calibration
				LDRSB	R1, [R6, R5] ; Adjust temperature by centidegrees
				ADD		R0, R1
				BPL     Calc_icons
				
				NEG     R0, R0

Calc_icons 		MOV     R1, #C0centidegrees
				; range of display of the 12 icons between temp_min and temp_max 19.2C or 38.4C
				LDRB	R5, [R6, #16] ; range `19.2C`=0 `38.4C`=1
				CMP		R5, #0
				BEQ		Calc_icons192
				
Calc_icons394	ADD     R1, #C0centidegrees
				MOV		R3,	#0x1B
				MOV		R5,	#5
				B		Calc_icons0
				
Calc_icons192	MOV		R3,	#0x1C
				MOV		R5,	#4
				
Calc_icons0		LDRB	R7, [R6, #3] ; temp_min
				SUB     R0, R7	; underrun?
				BPL     Calc_icons_o
				
Calc_icons_u	LDR		R4, [R6, #8]  ; icon_underflow
				B		Draw_canvas

Calc_icons_o	CMP     R0, R1 ; overflow?
				BLT		Calc_icons2
				
				LDR		R4, [R6, #12] ;  icon_overflow
				B		Draw_canvas

Calc_icons2		ASR     R1, R0, #0x1F 
				LSR     R1, R3 ; #0x1B ; (a):090F (,#0x1C), (b):C90E (,#0x1B)
				ADD     R0, R1 
				LDR		R1, [R6, #4] ; icon_first
				ASR     R0, R5 ; #4  ; (a):0011 (,#4), (b):4011 (,#5)
				ADD     R4, R0, R1    

Draw_canvas		SUB		SP, #8

				MOV		R0, R4
				BL		f033_GetImgHeight
				LDRB	R1, [R6, #2] ; icon_start_y  
				ADD		R1, R0
				MOV		R0, #1
				STR		R0, [SP, #4]
				SUB		R1, R0
				STR     R1, [SP]
				
				MOV		R0, R4
				BL		f034_GetImgWidth
				LDRB	R1, [R6, #1] ; icon_start_x 
				
				ADD		R3, R0, R1
				SUB		R3, #1

r1=x0; r2=y0; r3=x1; [sp]=y1, (sp+4)=1

				LDRB	R2, [R6, #2] ; icon_start_y  
				LDR     R0, [SP,#0x14 + 2*4 + 8*4 ] ; normally: 0x14. add 8 for 2 regs sp. add 8*4 for 8 pushed regs by this func
				BL		f037_DrawCanvas	
				ADD		SP,#8
				
Draw_icon		LDRB	R1, [R6, #2] ; icon_start_y  
				LDRB	R0, [R6, #1] ; icon_start_x 
				MOV		R2, R4
 
				BL		f035_DrawImg
				
Exit			POP		{R0-R7}
				
				; repatch
				MUL     R0, R3
				MOV     R3, SP
				SUB     R1, R1, R0
				LDRH    R0, [R3, #0x18]
				ADD     R0, #1
				
				ADD		R7,#4 ; jump over address at entrypoint
				BX		R7
				
_sub1			ADD		R1, R0
				SUB		R1, #1
				BX		LR
				
				
				
mp_data			DCD		0xB1C2D3E4
mp_id			DCD		0x0000CCCD, 0, 0

        END  
        
