; ilumination master 0.1
; prototyping mode
; m65v50 (c) benj9 

; entry m65v50:
; 0823368: 4010D4E5 64DC38FB ; _IllByKey_On_5mX_5_ Debug Mitte 64DC38FB->A165A500, A4DC38FB ->A165A600

; Running in function:
; A08232F8 IlluminationByKeyEventOn_5mX 
; background proc., starts once, never leaves, ever cycles inner
; reading events from rom and creating jump addresses to start according processes
; there are different branches where processes are started.
; A0823364 _IllByKey_On_5mX_5_best fits the center of the web
; to calculate all dependencies of event processes started.


		AREA ARMex, CODE, READONLY  
            
		ENTRY
		GBLA	TYPE	;1 for M65v50, 2 for SL65v50

TYPE	SETA	1 						

 IF  TYPE = 1

buffer					EQU	0xA8000210
Illumination			EQU	0xA0BC78B8
IsKeypadUnlocked		EQU	0xA114D0A7 
GetProfile				EQU	0xA08C9FE5 
_ram_illumination_data	EQU 0xA12265F8
_ram_netaccess_netmode	EQU 0xA132D7D0
_ram_keypress_buffer	EQU 0xA114CCF0
_ram_net_online			EQU	0xA863D124
_ram_timer975			EQU	0xA8739EF4 ; 1sec=975,238 ticks

 ENDIF

; patch data in rom structure: 
; +00 - 0x31, len: 0x32 = 8 blink rhythms pattern x 3 byte.  
; byte0: number_of_loops, byte1: brightness, byte2: smoothness. 

;
; patch data in ram structure:base=buffer
; +00 - 0x31, len: 0x32 = 8 blink rhythms buffer x 3 byte.  
; byte0: toggle_on_off, byte1:toggle_counter, byte2: KPL_CorrectFirstIdle_yes
; byte2: KPL_CorrectFirstIdle_yes is used by service. Filter_NetAcess uses the first 4 pattern-buffers, only the very-first byte3.
; +32:  


		CODE16

		
		NOP
main		PUSH {R0-R7,LR}

mainCalc__5mX

			; R4=5mX_5
				
			; R0,R2,R4 kommen aus dem laufenden event code
			; R5 <- 5mX_7. R3=tmp
			ADD		R0,#0x14
			MOV		R5,R0
			MOV		R3,#0x7F
			AND		R2,R3
			MOV		R0,R2
			LDMIA	R5!,{R0,R5} ; R5=5mX_7

			LDR		R6,[R4,#0x3c] ; R6=5xM_5_g  
			
			
			; R5=  5mX_7  -- REGULAR
			; A1367E93 937E36A1 ; REGULAR steady 1,5sec blink (max_loop: 1)
			; mit R6=21 DD 32 A1: algo1:1  (auch regular)
			
			; KPL-OFF-SLIDE
			; R4=7C 4D 01 A8 R1=00 00 00 00 kpl-off-slide algo1:1 (mit serial-mll?)
			; luft gut mit: BL _IsIlluminationOnByOS, CMP R0,#0, BNE mExit

			; R4= R4 of 5mX_5 (entry of this patch) - SERIAL/OBEX
			; C4 8E 00 A8 R5=FC CE 01 steady fast serial/obex (algo0: 1)(algo:1 6)
			
			; 2C 5A 01 A8 ; hnlich wie R5= A801CEFC ; serial/obex,  
			; mit allem: (2) OK - verpasst kabeil rein 50% wegen (2) (algo0) !
			;  mit R5=0: serieller etw.slower serieller. Cable zu schnell algo1(2)
			;  mit R5=FC CE 01 A8 netter flotter serial blinker, ohne cable algo1(04)
	 

			; R6= 5xM_5_g und 5xM_5_E1
			; B1 05 31 A1 A13105B1 ; net1 entry
			

			;LDR		R6,[R5,#0x10] ; SET: which mode 0=off, 1=light , 2=Ram Recorder of Functions
			;CMP		R6,#0 ; mode
			;BEQ		mExit
			;CMP		R6,#2 
			;BEQ		recorder
			
mainSelector	LDR		R7,=GetProfile
			BLX		R7
			MOV		R7,R0

; --- main entry, place calls for services here ------------

mainPattern0_3_NetAccessTraffic
			CMP		R7,#5 ; only in profile 6
			BNE		mainPattern0_3_NetAccessTraffic_x
			BL		filterPattern0_3_NetAccessTraffic
			CMP		R0,#0xFF
			BEQ		mainPattern0_3_NetAccessTraffic_x
			BL		blinker	
mainPattern0_3_NetAccessTraffic_x

mainPattern4_KplOffSlide
			CMP		R7,#1 ; only in profile 2 & 6
			BEQ		mainPattern4_KplOffSlide_do
			CMP		R7,#5 
			BNE		mainPattern4_KplOffSlide_x
mainPattern4_KplOffSlide_do
			BL 		filterPattern4_KplOffSlide
			CMP		R0,#0xFF
			BEQ		mainPattern4_KplOffSlide_x
			BL		blinker
mainPattern4_KplOffSlide_x	

mainPattern5_SerialTraffic
			CMP		R7,#6 ; only in profile 7
			BNE		mainPattern5_SerialTraffic_x
			BL		filterPattern5_SerialTraffic
			CMP		R0,#0xFF
			BEQ		mainPattern5_SerialTraffic_x
			BL		blinker
mainPattern5_SerialTraffic_x

mainPattern6_MediumTimedBlinker
			CMP		R7,#4 ; only in profile 5
			BNE		mainPattern6_MediumTimedBlinker_x
			BL		filterPattern6_MediumTimedBlinker
			CMP		R0,#0xFF
			BEQ		mainPattern6_MediumTimedBlinker_x
			BL		blinker
mainPattern6_MediumTimedBlinker_x

mainPattern7_NetLost
			CMP		R7,#5 ; profile 6  
			BNE		mainPattern7_NetLost_x
			BL		filterPattern7_SlowTimedBlinker
			CMP		R0,#0xFF
			BEQ		mainPattern7_NetLost_x
			BL		blinker
mainPattern7_NetLost_x

mainShouldLightBeOff
			LDR		R1,=buffer
   	    	SUB		R1,#4 ; timer
   	    	LDR		R3,[R1] ; load previous time stamp
   	    	CMP		R3,#0 ; if zero disabled
   	    	BEQ		mainExit
   	    	
   	    	LDR		R7,=_ram_timer975
   	    	LDR		R7,[R7]
   	    	
   	    	SUB		R7,R3
   	    	LDR		R3,=2600 ; more than 2600 auf (975clicks/per)second gone?
   	    	CMP		R7,R3
   	    	BLE		mainExit
   	    	
   	    	BL		_IsIlluminationOnByOS
   	    	MOV		R7,R0
   	    	MOV		R2,R0
   	    	MOV		R0,#0
   	    	MOV		R3,#0x28 ; smoothness
   	    	BL		_SetIllumination
   	    	MOV		R2,R7
   	    	MOV		R0,#1
   	    	MOV		R3,#0x28 ; smoothness
   	    	BL		_SetIllumination
   	    	
   	    	MOV		R3,#0
   	    	STR		R3,[R1] ; set timerstamp to zero


; --- main entry end ---------------------------------------

mainExit		POP		{R0-R7}
			MOV		R1,R4		; repatch _IllByKey_On_5mX_5
 			ADD		R1,#0x40	; repatch _IllByKey_On_5mX_5
			LDRB	R1,[R1]		; repatch _IllByKey_On_5mX_5
			POP		{PC}

; --- main end ---------------------------------------------


blinker		PUSH	{R7, LR}
			LDR		R7,=buffer
			LDR		R3,=pattern
			SUB		R3,#1 ; porters delight
					
blinkerCalc_DataOffset  ; input: R0=pattern#. Ab hier R3=akt.rom-pattern, R0=akt. ram-buffer
			ADD		R2,R0,R0
			ADD		R0,R2,R0 ; R0= pattern# * 3 = offset
			ADD		R3,R0 ; R3= pattern + offset = akt-rom-pattern
			ADD		R0,R7 ; R0=offset + buffer_base = akt-ram-buffer
		
blinkerFilter_LoopToggler
			LDRB	R2,[R0,#1] ; toggle-funcnow1
			
			LDRB	R1,[R3] ; <loop_trigger_max>
			; get <loop_trigger_max> from ram 
			;LDR		R1,=0xA800020F ; <loop_trigger_max>
			;LDRB	R1,[R1]
			; end #
			CMP		R2,R1 ; signal ausdnnen
			BEQ 	blinkerStep	
		
			ADD		R2,#1
			STRB	R2,[R0,#1]  ; reset funcnow
			B		blinker_x
	
blinkerStep
			MOV		R2,#0
			STRB	R2,[R0,#3] ; make dirty: KPL_CorrectFirstIdle
			
			MOV 	R2,#1
			STRB	R2,[R0,#1]	; set toggle_funcnow

       		LDRB	R2,[R0] ; toggle_on/off
			;MOV 	R1,#brightness 
			LDRB	R1,[R3,#1] ; <brightness>
			SUB		R2,R1,R2
			STRB	R2,[R0]
		
blinkerGo	MOV     R0, #1 ; <output>
			;LDRB	R0,[R5,#1]
      	  	;MOV		R3,#smoothness ; <smoothness>
        	LDRB	R3,[R3,#2] ; <smoothness>
    	    BL		_SetIllumination
   	    	
   	    	LDR		R7,=_ram_timer975
   	    	LDR		R7,[R7]
   	    	LDR		R3,=buffer
   	    	SUB		R3,#4 ; store timer
   	    	STR		R7,[R3]
			
blinker_x	POP {R7,PC}

;--- filterPattern ------------------------------------------------------
	
   	    
filterPattern4_KplOffSlide
; Filter KPL-ON event, wenn Licht an. Z.B Zeitabfrage oder diese RAM-Zelle, die bei keyb kurz 1 ist?
			PUSH	{LR}
			MOV		R1,#0xFF
			LDR		R3,=0xA8014D7C ; kpl_off-slide 7C4D01A8 ; filterPattern by 5mX_5 hook data
			; found M65v50: [A1389EC0]+0x34
			CMP		R4,R3
			BNE		filterPattern4_KplOffSlide_x
			MOV		R3,#0 ; filterPattern by 5mX_5 hook data
			CMP		R5,R3
			BNE		filterPattern4_KplOffSlide_x
			BL		_IsKeyPressed
			CMP		R0,#0 ; filterPattern by OS state
			BNE		filterPattern4_KplOffSlide_x
			MOV		R1,#4 ; pattern
filterPattern4_KplOffSlide_x
			MOV		R0,R1	
			POP		{PC}
			
; ---------------------------	
		
filterPattern5_SerialTraffic
			MOV		R0,#0xFF
			LDR		R3,=0xA8015A2C ; serial/obex 2C5A01A8 
			CMP		R4,R3  ; filterPattern by 5mX_5 hook data
			BNE		filterPattern5_SerialTraffic_x
			MOV		R0,#5 ; blink pattern 5	
filterPattern5_SerialTraffic_x
			BX		LR
			
; ---------------------------	
	
filterPattern0_3_NetAccessTraffic
			PUSH	{LR}
			BL		_IsNetAccessMode_var1
			CMP		R0,#0
			BEQ		filterPattern0_3_NetAccessTraffic__IsNetAccessMode_var1_no
			; --- KPL_CorrectFirstIdle method: ---
		
		; falls erstes idle-event, kpl setzen nach soll-zustand
		; LDR		R3,=buffer
		; LDRB	R2,[R3,#3] ; KPL_Correct_First_Idle Of NetaccessTraffic, for 4 net patterns always in buffer0
		; CMP		R2,#1 ; if KPL_Correct_First_Idle is clean, continue checking.
		; BEQ		filterPattern0_3_NetAccessTraffic_var2
		; MOV		R2,#1
		; STRB	R2,[R3,#3] ; set  KPL_Correct_First_Idle to clean
		; BL		_IsIlluminationOnByOS
		; MOV		R2,R0
		; MOV		R0,#1
		; MOV		R1,R0
		; MOV		R3,#9
		; LDR		R4,=Illumination
   	    ; BLX     	R4
		; B		filterPattern0_3_NetAccessTraffic__IsNetAccessMode_var1_no
			; --- end method ----------------------
filterPattern0_3_NetAccessTraffic_var2
			BL		_WhichNetAccessMode_var2
			B		filterPattern0_3_NetAccessTraffic_x
filterPattern0_3_NetAccessTraffic__IsNetAccessMode_var1_no
			MOV		R0,#0xFF			
filterPattern0_3_NetAccessTraffic_x
			POP		{PC}
			
filterPattern6_MediumTimedBlinker
		PUSH 	{LR}
		MOV		R0,#0xFF
		LDR		R1,=0xA1367E93
		CMP		R5,R1
		BNE		filterPattern6_MediumTimedBlinker_x
		BLX		_IsKeypadUnlocked
		CMP		R0,#0 ; Locked?
		BEQ		filterPattern6_MediumTimedBlinker_x
		MOV		R0,#6 ; blink pattern 6		
filterPattern6_MediumTimedBlinker_x
		POP		{PC}
		
filterPattern7_SlowTimedBlinker
		PUSH 	{LR}
		MOV		R0,#0xFF
		LDR		R1,=0xA1367E93
		CMP		R5,R1
		BNE		filterPattern7_SlowTimedBlinker_x
		BL		_IsNet
		CMP		R0,#0 ; Netlost?
		BNE		filterPattern7_SlowTimedBlinker_x
		MOV		R0,#7 ; blink pattern 7		
filterPattern7_SlowTimedBlinker_x
		POP		{PC}
		
; ---------------------------		
_SetIllumination
		; input R0: output, R2=brightness, R3=smoothness
		PUSH	{R1,R7,LR}
    	MOV     R1, #1
	    LDR		R7,=Illumination
    	BLX     R7
    	POP		{R1,R7,PC}
	

;--- status requests ---------------------------------------------

_IsIlluminationOnByOS
	 	LDR		R0,=_ram_illumination_data
		LDR		R0,[R0] ; A1255C34 1C E2 6A A8 dword_A1255C34  DCD 0xA86AE21C
		ADD		R0,#0x94  ; +94: What OS thinks is state of Illumination On/Off
		LDRB	R0,[R0] 
   	    BX		LR 

; ---------------------------

_IsKeyPressed
		LDR		R0,=_ram_keypress_buffer
		LDR		R0,[R0]
   	 	LDR		R0,[R0,#0x18] ; ram_keypress_buffer + 0x18 = currently pressed key
   	 	BX		LR

; ---------------------------

_IsNetAccessMode_var1 ; 1 wenn irgendein netaccess, sonst 0
		PUSH	{LR}
		BL 		_WhichNetAccessMode_var1  
   	    CMP		R0,#0x13 ; ruhiges netz
		BNE		_IsNetAccessMode_var1_yes
		MOV		R0,#0
		POP		{PC}
_IsNetAccessMode_var1_yes
		MOV		R0,#1
		POP		{PC}

; ---------------------------

_WhichNetAccessMode_var1	; returns R0: NetAccessMode1
		; 05=pre-phon, 06=pho+sms, 09 gprs, 13=idle. 14=post-sms !
		LDR		R0,=_ram_netaccess_netmode 
		LDR		R0,[R0] ;  R0 points to ram_netaccess_netmode 
		LDRB	R0,[R0]
		BX		LR

; ---------------------------

_WhichNetAccessMode_var2 ; output in R0: net blink pattern (0-3)
		LDR		R0,=_ram_netaccess_netmode 
		LDR		R0,[R0] ;  R0 points to ram_netaccess_netmode
		SUB		R0,#0x68 ; netaccess_base+2b  (netaccess_mode-0x68): 03, 02 meistens phone
		LDRB	R0,[R0] ; R4=A8752560 
		CMP		R0,#2
		BLE		_WhichNetAccessMode_var2_x
		CMP		R0,#3
		BEQ		_WhichNetAccessMode_var2_3
		MOV		R0,#3 ; choose pattern 3 - idle/default
		B		_WhichNetAccessMode_var2_x	
_WhichNetAccessMode_var2_3
		MOV		R0,#2 ; choose pattern 2	
		; B		_WhichNetAccessMode_var2_x	
_WhichNetAccessMode_var2_x
		BX		LR
		
; ---------------------------
	
_IsNet	LDR		R0,=_ram_net_online
		LDR		R0,[R0]
		BX		LR
; ---------------------------
_IsKeypadUnlocked
		PUSH	{LR}
		LDR		R0,=IsKeypadUnlocked
		BLX		R0
		POP		{PC}
; ---------------------------
		
		
;--- data --------------------------------------------------------			
; <loop_trigger_max>: min 1!,<output>0=Scr,1=KPL,2=DL,<brightness>0-0x64,<smoothness>0=off  	    
pattern ; <loop_trigger_max>,<brightness>,<smoothness>
p0_net		DCB	0x24,40,02 ; ;R6=0 beim Rufaufbau (whlen) kurz ; 17
p1_net		DCB	0x18,55,02 ;  R6=1 beim Rufaufbau sehr kurz
p2_net		DCB	0x2C,50,06 ;  R6=2 + 3  Verbindung ; 1F
p3_net		DCB 0x34,25,32 ; R6=1B, blink for idle and default; 30
p4_kplslide	DCB	1,60,03 ; keypadlight-off slide
p5_serial	DCB 3,50,01 ; serial/obex traffic, cable off
p6_reg_fast DCB	1,80,09 ; regular steady blinker full-speed
p7_reg_slow	DCB	2,80,09 ; regular steady blinker half-speed


 END